/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class AnimatedObjectData {
    static AnimatedObjectData[] pStaticAnimatedObjectData = new AnimatedObjectData[10];
    short nType;
    int nImageResID;
    byte nSettings;
    short nModuleCount;
    short nFrameCount;
    short nActionCount;
    byte[][] pModuleTypeAndSize;
    byte[][] pModuleParams;
    byte[][] pFrameDurationColBox;
    byte[][][] pFrameSprite;
    byte[][] pActions;
    Image pImg;
    public boolean m_bFreeImage = true;

    static AnimatedObjectData loadData(byte[] byArray, int n) {
        return AnimatedObjectData.loadData(byArray, n, true);
    }

    static AnimatedObjectData loadData(byte[] byArray, int n, boolean bl) {
        System.gc();
        int n2 = byArray[0] & 0xFF;
        if (n2 >= pStaticAnimatedObjectData.length) {
            int n3 = pStaticAnimatedObjectData.length * 2;
            if (n2 >= n3) {
                n3 = n2;
            }
            AnimatedObjectData[] animatedObjectDataArray = new AnimatedObjectData[n3];
            System.arraycopy(pStaticAnimatedObjectData, 0, animatedObjectDataArray, 0, pStaticAnimatedObjectData.length);
            pStaticAnimatedObjectData = animatedObjectDataArray;
        }
        if (pStaticAnimatedObjectData[n2] == null) {
            AnimatedObjectData.pStaticAnimatedObjectData[n2] = new AnimatedObjectData();
            AnimatedObjectData.pStaticAnimatedObjectData[n2].m_bFreeImage = bl;
            pStaticAnimatedObjectData[n2].init(byArray, n);
        } else if (AnimatedObjectData.pStaticAnimatedObjectData[n2].nImageResID != n) {
            // empty if block
        }
        return pStaticAnimatedObjectData[n2];
    }

    static void drawModuleImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Graphics graphics) {
        if (n2 < 0) {
            if ((n6 += n2) <= 0) {
                return;
            }
            if ((n8 & 1) == 0) {
                n4 -= n2;
            }
            n2 = 0;
        }
        if (n3 < 0) {
            if ((n7 += n3) <= 0) {
                return;
            }
            if ((n8 & 2) == 0) {
                n5 -= n3;
            }
            n3 = 0;
        }
        graphics.setClip(n2, n3, n6, n7);
        graphics.drawImage(AnimatedObjectData.getImage(n), n2 - n4, n3 - n5, 20);
    }

    static void drawModule(int n, int n2, int n3, int n4, int n5, Graphics graphics) {
        int n6 = AnimatedObjectData.getModuleWidth(n, n2);
        int n7 = AnimatedObjectData.getModuleHeight(n, n2);
        graphics.setClip(n3, n4, n6, n7);
        AnimatedObjectData.drawModuleImage(n, n3, n4, AnimatedObjectData.getModulePosX(n, n2), AnimatedObjectData.getModulePosY(n, n2), n6, n7, n5, graphics);
    }

    void init(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.nImageResID = n;
        if (n != -1) {
            GameCanvasEx.RM_Load(n);
            GameCanvasEx.RM_Synchronize();
            this.pImg = GameCanvasEx.RM_GetResource_Image(n);
            if (this.m_bFreeImage) {
                GameCanvasEx.RM_Free(n);
                GameCanvasEx.RM_Synchronize();
            }
        }
        int n8 = 0;
        this.nType = (short)(byArray[0 + n8] & 0xFF);
        this.nSettings = byArray[1 + n8];
        this.nModuleCount = (short)(byArray[2 + n8] & 0xFF);
        this.nFrameCount = (short)(byArray[3 + n8] & 0xFF);
        this.nActionCount = (short)(byArray[4 + n8] & 0xFF);
        this.pModuleTypeAndSize = new byte[this.nModuleCount][];
        this.pModuleParams = new byte[this.nModuleCount][];
        int n9 = 5 + n8;
        for (n7 = 0; n7 < this.nModuleCount; ++n7) {
            this.pModuleTypeAndSize[n7] = new byte[3];
            this.pModuleTypeAndSize[n7][0] = byArray[n9++];
            this.pModuleTypeAndSize[n7][1] = byArray[n9++];
            this.pModuleTypeAndSize[n7][2] = byArray[n9++];
            n6 = 4;
            this.pModuleParams[n7] = new byte[n6];
            System.arraycopy(byArray, n9, this.pModuleParams[n7], 0, n6);
            n9 += n6;
        }
        n7 = n9;
        this.pFrameSprite = new byte[this.nFrameCount][][];
        this.pFrameDurationColBox = new byte[this.nFrameCount][];
        for (n6 = 0; n6 < this.nFrameCount; ++n6) {
            n5 = byArray[n7];
            this.pFrameDurationColBox[n6] = (n5 & 0x80) != 0 ? new byte[6] : new byte[2];
            this.pFrameDurationColBox[n6][0] = byArray[n7++];
            this.pFrameDurationColBox[n6][1] = byArray[n7++];
            if ((n5 & 0x80) != 0) {
                for (n4 = 0; n4 < 4; ++n4) {
                    this.pFrameDurationColBox[n6][2 + n4] = byArray[n7++];
                }
            }
            this.pFrameSprite[n6] = new byte[AnimatedObjectData.getFrameNumberOfSprite(this.nType, n6)][];
            n4 = this.pFrameDurationColBox[n6][1];
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = 3;
                this.pFrameSprite[n6][n3] = new byte[n2];
                System.arraycopy(byArray, n7, this.pFrameSprite[n6][n3], 0, n2);
                n7 += n2;
            }
        }
        n6 = n7;
        this.pActions = new byte[this.nActionCount][];
        for (n5 = 0; n5 < this.nActionCount; ++n5) {
            n4 = byArray[n6] & 0xFF;
            n3 = n4 + 1;
            this.pActions[n5] = new byte[n3];
            System.arraycopy(byArray, n6, this.pActions[n5], 0, n3);
            n6 += n3;
            for (n2 = 0; n2 < n4; ++n2) {
            }
        }
    }

    private AnimatedObjectData() {
    }

    static int getModulePosX(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        return GameCanvasEx.readUnsignedShortLittleEndian(animatedObjectData.pModuleParams[n2], 0);
    }

    static int getModulePosY(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        return GameCanvasEx.readUnsignedShortLittleEndian(animatedObjectData.pModuleParams[n2], 2);
    }

    static int getModuleWidth(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        return animatedObjectData.pModuleTypeAndSize[n2][1] & 0xFF;
    }

    static int getModuleHeight(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        return animatedObjectData.pModuleTypeAndSize[n2][2] & 0xFF;
    }

    static int getModuleParam1(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        byte[] byArray = animatedObjectData.pModuleParams[n2];
        return GameCanvasEx.readUnsignedShortLittleEndian(byArray, 4);
    }

    static int getModuleParam2(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        byte[] byArray = animatedObjectData.pModuleParams[n2];
        return GameCanvasEx.readUnsignedShortLittleEndian(byArray, 6);
    }

    static int getFrameDuration(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        byte[] byArray = animatedObjectData.pFrameDurationColBox[n2];
        return byArray[0] & 0x7F;
    }

    static int getFrameNumberOfSprite(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        byte[] byArray = animatedObjectData.pFrameDurationColBox[n2];
        return byArray[1] & 0xFF;
    }

    static int getSpritePosX(int n, int n2, int n3) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        byte[] byArray = animatedObjectData.pFrameSprite[n2][n3];
        return byArray[0];
    }

    static int getSpritePosY(int n, int n2, int n3) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        byte[] byArray = animatedObjectData.pFrameSprite[n2][n3];
        return byArray[1];
    }

    static int getSpriteModuleIndex(int n, int n2, int n3) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        byte[] byArray = animatedObjectData.pFrameSprite[n2][n3];
        return byArray[2] & 0xFF;
    }

    static int getFrameCountInAction(int n, int n2) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        return animatedObjectData.pActions[n2][0] & 0xFF;
    }

    static int getFrameIdInAction(int n, int n2, int n3) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        int n4 = 1;
        return animatedObjectData.pActions[n2][n4 + n3] & 0xFF;
    }

    static Image getImage(int n) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        return animatedObjectData.pImg;
    }

    static void setImage(int n, Image image) {
        AnimatedObjectData animatedObjectData = pStaticAnimatedObjectData[n];
        animatedObjectData.pImg = image;
    }

    static void Free(int n) {
        if (pStaticAnimatedObjectData[n] != null) {
            AnimatedObjectData.pStaticAnimatedObjectData[n].pModuleTypeAndSize = null;
            AnimatedObjectData.pStaticAnimatedObjectData[n].pModuleParams = null;
            AnimatedObjectData.pStaticAnimatedObjectData[n].pFrameDurationColBox = null;
            AnimatedObjectData.pStaticAnimatedObjectData[n].pFrameSprite = null;
            AnimatedObjectData.pStaticAnimatedObjectData[n].pActions = null;
            AnimatedObjectData.pStaticAnimatedObjectData[n].pImg = null;
            AnimatedObjectData.pStaticAnimatedObjectData[n] = null;
            System.gc();
        }
    }
}

