/*
 * Decompiled with CFR 0.152.
 */
public class Vector {
    static int vrx = 0;
    static int vry = 0;

    static final void scale(int n, int n2, int n3) {
        vrx = FP.fpMul(n, n3);
        vry = FP.fpMul(n2, n3);
    }

    static final void add(int n, int n2, int n3, int n4) {
        vrx = n + n3;
        vry = n2 + n4;
    }

    static final int length(int n, int n2) {
        int n3 = FP.fpMul(n, n) + FP.fpMul(n2, n2);
        if (n3 < 0) {
            return -1;
        }
        return FP.fpSqrt(n3);
    }

    static final int lengthSquared(int n, int n2) {
        int n3 = FP.fpMul(n, n) + FP.fpMul(n2, n2);
        if (n3 < 0) {
            return -1;
        }
        return n3;
    }

    static final void normalise(int n, int n2) {
        int n3 = Vector.length(n, n2);
        if (n3 == 0) {
            return;
        }
        Vector.scale(n, n2, FP.fpDiv(4096, n3));
    }

    static final void rotate(int n, int n2, int n3) {
        int n4 = FP.fpCos(n3);
        int n5 = FP.fpSin(n3);
        vrx = FP.fpMul(n4, n) - FP.fpMul(n5, n2);
        vry = FP.fpMul(n5, n) + FP.fpMul(n4, n2);
    }

    static final void rightNormal(int n, int n2) {
        vrx = -n2;
        vry = n;
    }

    static final void leftNormal(int n, int n2) {
        vrx = n2;
        vry = -n;
    }

    static void project(int n, int n2, int n3, int n4) {
        int n5 = Vector.dotProd(n, n2, n3, n4);
        int n6 = FP.fpDiv(n5, FP.fpMul(n3, n3) + FP.fpMul(n4, n4));
        vrx = FP.fpMul(n6, n3);
        vry = FP.fpMul(n6, n4);
    }

    static void projectNormal(int n, int n2, int n3, int n4) {
        int n5 = Vector.dotProd(n, n2, n3, n4);
        vrx = FP.fpMul(n5, n3);
        vry = FP.fpMul(n5, n4);
    }

    static int dotProd(int n, int n2, int n3, int n4) {
        return FP.fpMul(n, n3) + FP.fpMul(n2, n4);
    }

    static final void reflect(int n, int n2, int n3, int n4) {
        int n5 = Vector.dotProd(n, n2, n3, n4);
        vrx = n - FP.fpMul(n5, n3) * 2;
        vry = n2 - FP.fpMul(n5, n4) * 2;
    }

    static final int intersection(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3;
        int n10 = n4;
        int n11 = n7;
        int n12 = n8;
        int n13 = n5 - n;
        int n14 = n6 - n2;
        int n15 = FP.fpMul(n10, n11) - FP.fpMul(n9, n12);
        if (n15 == 0) {
            return Integer.MAX_VALUE;
        }
        int n16 = FP.fpMul(n11, n14) - FP.fpMul(n12, n13);
        return FP.fpDiv(n16, n15);
    }

    static int fpVectorAngle(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = Vector.dotProd(n, n2, n3, n4);
        int n7 = Vector.length(n, n2);
        int n8 = FP.fpMul(n7, n5 = Vector.length(n3, n4));
        if (n8 == 0) {
            return 0;
        }
        int n9 = FP.fpDiv(n6, n8);
        return FP.fpAcos(n9);
    }
}

