/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class TouchGameController
implements ConstantsTFC,
Constants,
GameConstants,
TouchConstants {
    static final int ZONE_TYPE_GAME_BOARD = 0;
    static final int ZONE_TYPE_SEED_PACKET = 1;
    static final int ZONE_TYPE_SUN = 2;
    static final int ZONE_TYPE_MONEY = 3;
    static final int ZONE_TYPE_LEVEL_AWARD = 4;
    static final int FRAME_FLAT_PLANT = 4;
    static int m_nPlantableSeedType;
    static int m_nPlantableSeedAlphaFrame;
    static int m_nCurrentHighlightedSeedIndex;
    static int m_nCurrentSeedPresses;
    static boolean m_bSeedsSelected;

    static void init() {
    }

    static void setVarsNewLevel(int n) {
        int n2;
        m_nPlantableSeedType = -1;
        m_nPlantableSeedAlphaFrame = 0;
        m_nCurrentSeedPresses = 0;
        m_nCurrentHighlightedSeedIndex = -1;
        for (n2 = 348; n2 < 363; ++n2) {
            TouchController.clearTouchZone(n2);
        }
        for (n2 = 282; n2 < 335; ++n2) {
            TouchController.clearTouchZone(n2);
        }
        TouchController.clearTouchZone(347);
        TouchController.clearTouchZone(346);
    }

    static void setInGameZones(int n) {
        TouchGameController.setBoardZones(n);
    }

    static boolean bIsZoneActive(int n) {
        return TouchConstants.TOUCH_ZONE_LEFT[n] != -1 && TouchConstants.TOUCH_ZONE_RIGHT[n] != -1 && TouchConstants.TOUCH_ZONE_TOP[n] != -1 && TouchConstants.TOUCH_ZONE_BTM[n] != -1;
    }

    static void setBoardZones(int n) {
        for (int i = 0; i < 9 * GModel.m_nGameBoardRows; ++i) {
            if ((GModel.m_lBoardGridAsDirt & 1L << i) != 0L) continue;
            Cursor.getGridPosRect(i, 0);
            int n2 = i / 9;
            int n3 = Cursor.GRID_POS[Cursor.GRID_POS_X];
            int n4 = Cursor.GRID_POS[Cursor.GRID_POS_Y] + GCanvas.getPlantY(n3, n2);
            if (GameController.m_nLevel >= 40) {
                n4 += 10;
            }
            int n5 = n3 + Cursor.GRID_POS[Cursor.GRID_POS_W];
            int n6 = n4 + Cursor.GRID_POS[Cursor.GRID_POS_H];
            TouchController.setTouchZoneDataInstantly(282 + i, n3, n4, n5, n6, true);
        }
    }

    static void update() {
        boolean bl;
        TouchController.update();
        boolean bl2 = bl = Cursor.m_nCursorType == 3 && Plants.getPlantIndexAtPos(Cursor.m_nCursorPos) != -1;
        if (m_nPlantableSeedAlphaFrame >= 0 && Cursor.m_nCursorPos >= 0 && (bl || Cursor.m_nCursorType == 0)) {
            int n = GraphicsUtil.getPingPongMaxFrame(9);
            m_nPlantableSeedAlphaFrame = (m_nPlantableSeedAlphaFrame + 1) % n;
        } else {
            m_nPlantableSeedAlphaFrame = 0;
        }
        if (Cursor.m_nCursorType != 3 && GameController.m_nGameState != 1) {
            TouchGameController.setShovelSoftKeyImage((short)"]\u015d\u01fb\u00fa\u013c".charAt(4));
        }
    }

    static void handleInput() {
    }

    static boolean handleAction(int n, int n2, int n3, int n4) {
        switch (n) {
            case -1: {
                return true;
            }
            case 83: {
                if (Cursor.m_nCursorType == 3) {
                    Cursor.m_nCursorPos = n2 - 282;
                } else {
                    Cursor.m_nCursorPos = n2 - 282;
                    Cursor.m_nCursorType = 0;
                }
                return true;
            }
            case 89: {
                if (Cursor.m_nCursorType == 3) {
                    Cursor.m_nCursorPos = n2 - 282;
                    TouchGameController.removePlant(Cursor.m_nCursorPos);
                } else {
                    Cursor.m_nCursorPos = n2 - 282;
                    Cursor.m_nCursorType = 0;
                    TouchGameController.plantSeed();
                }
                return true;
            }
            case 84: {
                TouchGameController.handleSeedPacketZone(n2, n, n3, n4);
                TouchController.skipRemainingTransparentActions();
                return true;
            }
            case 92: {
                TouchGameController.handleSeedPacketZone(n2, n, n3, n4);
                TouchController.skipRemainingTransparentActions();
                return true;
            }
            case 90: {
                TouchGameController.handleSeedPacketZone(n2, n, n3, n4);
                TouchController.skipRemainingTransparentActions();
                return true;
            }
            case 94: {
                if (m_nCurrentHighlightedSeedIndex != -1) {
                    TouchGameController.setPlantableSeed(m_nCurrentHighlightedSeedIndex, n3, n4, true);
                }
                TouchController.skipRemainingTransparentActions();
                return true;
            }
            case 93: {
                TouchGameController.updatePlantableSeedZone(n3, n4);
                TouchController.skipRemainingTransparentActions();
                return true;
            }
            case 91: {
                TouchGameController.plantSeed();
                return true;
            }
            case 85: {
                TouchGameController.handleCoinPress(n2);
                TouchController.skipRemainingTransparentActions();
                return true;
            }
            case 87: {
                if (GameController.m_nGameState == 1) {
                    GFUIState.gotoStateOrPerformAction(24);
                    return true;
                }
            }
            case 88: {
                if (GameController.m_nLevel >= 4) {
                    TouchGameController.handlePressShovel();
                    TouchController.skipRemainingTransparentActions();
                    return true;
                }
                return false;
            }
            case 16: {
                PVZActions.gotoPauseMenu(GameController.m_nGameMode);
                return true;
            }
            case 54: {
                if (GFUIState.UI_PREVIOUS_STATES[GFUIState.m_nUIState] == -1) {
                    PVZActions.returnToGameFromPauseMenu();
                } else {
                    GFUIState.gotoPreviousState();
                }
                if (!GameController.isInGameLoading) {
                    Game.restartGameAudio();
                    GFSoundManager.handleSoundEvent(6);
                }
                return true;
            }
            case 73: {
                if (!m_bSeedsSelected) {
                    TouchGameController.handlePressSeedPickerLibrary(n2);
                }
                return true;
            }
            case 72: {
                if (!m_bSeedsSelected) {
                    TouchGameController.handleSeedPickerRemoveSeed(n2);
                }
                return true;
            }
            case 61: {
                int n5 = SeedPicker.getRemainingSeeds();
                if (n5 < SeedBank.m_nCurrMaxSeeds) {
                    return true;
                }
                m_bSeedsSelected = true;
                return false;
            }
            case 62: {
                if (AwardScreen.m_nAwardType == 4) {
                    GFUIState.gotoStateOrPerformAction(56);
                    GFMain.clearKeysPressed();
                } else {
                    GFUIState.gotoStateOrPerformAction(62);
                }
                return true;
            }
            case 74: {
                int n6 = GFCanvas.getImageHeight(374);
                int n7 = GFCanvas.getImageHeight(191);
                int n8 = SeedPicker.m_nSeedPickerLibraryH - (n6 + n7);
                int n9 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
                int n10 = n9 + 7;
                int n11 = n8 / n10;
                int n12 = SeedPicker.m_nSeedPickerOnScreenRows;
                int n13 = SeedPicker.prevRow;
                int n14 = n13--;
                if (n2 == 94) {
                    if (n13 < 0) {
                        n13 = 0;
                    }
                } else if (n2 == 95 && ++n13 >= SeedPicker.m_nSeedPickerRows - n12 - 1) {
                    n13 = SeedPicker.m_nSeedPickerRows - n12 - 1;
                }
                if (n14 != n13) {
                    if (n13 - SeedPicker.prevRow > 0) {
                        SeedPicker.rowMovement -= n10;
                        ++SeedPicker.prevRow;
                        SeedPicker.renderTopScrollArrow = true;
                    } else if (n13 - SeedPicker.prevRow < 0) {
                        SeedPicker.rowMovement += n10;
                        --SeedPicker.prevRow;
                        SeedPicker.renderBottomScrollArrow = true;
                    }
                }
                if (n13 == 0) {
                    SeedPicker.renderTopScrollArrow = false;
                } else if (n13 == SeedPicker.m_nSeedPickerRows - n12 - 1) {
                    SeedPicker.renderBottomScrollArrow = false;
                }
                return true;
            }
            case 79: {
                int n15 = GFUIState.getCurrentSelectionIndex();
                int n16 = n15 / AlmanacScreenMenu.maxCols;
                if (n2 == 189 || n2 == 226) {
                    if (--n16 < 0) {
                        n16 = 0;
                    }
                } else if (++n16 > AlmanacScreenMenu.totalRows - AlmanacScreenMenu.maxRows) {
                    n16 = AlmanacScreenMenu.totalRows - AlmanacScreenMenu.maxRows;
                }
                AlmanacScreenMenu.selectedMenuItemCurr = GFUIState.UI_MENU_CURRENT_SELECTION[GFUIState.m_nUIState] = n16 * AlmanacScreenMenu.maxCols;
                AlmanacScreenMenu.barIndex = AlmanacScreenMenu.prevRow = n16;
                AlmanacScreenMenu.firstElementTop = AlmanacScreenMenu.gridTop - n16 * AlmanacScreenMenu.almanacMenuItemHeight;
                return true;
            }
            case 80: {
                GFUIState.UI_MENU_CURRENT_SELECTION[GFUIState.m_nUIState] = GFUIState.m_nUIState == 36 ? (AlmanacScreenMenu.selectedMenuItemCurr = n2 - 192 - 1) : (AlmanacScreenMenu.selectedMenuItemCurr = n2 - 229 - 1);
                char c = "\u0006,,,,,,\u0002-.\u0000\u0005\u0004\r#/\u001c\u00010\u0003\r\u000f/\u0000\u00021\b\u000223\u0000\u0000\u0000\u0000\u00034\u000e\u001e\u0006555555\u0003\u001a\u001b\u001c\u00066\u0013\u0014\u0011\u0012\u0015\u00024\u000e\u0000\u000273\u000283\u000293\u000293\u0002:3\u000278\u0000\u0000\u0000\u0000\u0000\u0002;3\u0002;3\u0000\u0000\u0000\u0003$%(\u0001&\u0001'\u0000\u0000\u0000\u0000\u0001<".charAt(GFUIState.getStateStringsOffset(GFUIState.m_nUIState));
                GFUIState.gotoStateOrPerformAction(c);
                return true;
            }
            case 75: 
            case 77: 
            case 81: {
                if (!GFTextArea.isReachingTop()) {
                    int n17 = GFUIState.m_nUIState == 40 || GFUIState.m_nUIState == 28 || GFUIState.m_nUIState == 18 ? GFFont.getFontHeight(1) - 1 : GFFont.getFontHeight(6) + 1;
                    int n18 = GFTextArea.getContentY();
                    GFTextArea.setContentY(n18 += n17);
                }
                return true;
            }
            case 76: 
            case 78: 
            case 82: {
                if (!GFTextArea.isReachingBottom()) {
                    int n19 = GFUIState.m_nUIState == 40 || GFUIState.m_nUIState == 28 || GFUIState.m_nUIState == 18 ? GFFont.getFontHeight(1) - 1 : GFFont.getFontHeight(6) + 1;
                    int n20 = GFTextArea.getContentY();
                    GFTextArea.setContentY(n20 -= n19);
                }
                return true;
            }
            case 59: 
            case 86: {
                RMS.resetGame(true);
                GFUIState.gotoPreviousState();
                return true;
            }
        }
        return false;
    }

    static void setPlantableSeed(int n, int n2, int n3, boolean bl) {
        SeedBank.m_nSelectedSeedIndexToPlant = n;
        int n4 = n * SeedBank.SEED_MAX_VALS;
        int n5 = SeedBank.SEEDS[n4 + SeedBank.SEED_BANK_POS];
        int n6 = SeedBank.SEEDS[n4 + SeedBank.SEED_TYPE];
        if (Cursor.bSeedAtCursorPlantable(n5, n6, 1)) {
            m_nPlantableSeedType = n6;
            if (bl) {
                int n7;
                int n8;
                if (Layer.isLandscape(2)) {
                    n8 = Cursor.getCursorGameW() * 2;
                    n7 = Cursor.getCursorGameH() * 2;
                } else {
                    n8 = Cursor.getCursorGameW() * 2;
                    n7 = Cursor.getCursorGameH() * 2;
                }
                int n9 = n2 - n8 / 2;
                int n10 = n3 - n7 / 2;
                int n11 = n9 + n8;
                int n12 = n10 + n7;
                TouchController.setTouchZoneDataInstantly(346, n9, n10, n11, n12, false);
            }
        }
    }

    static int addZone(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        return n6;
    }

    static void updatePlantableSeedZone(int n, int n2) {
        int n3 = TouchConstants.TOUCH_ZONE_RIGHT[346] - TouchConstants.TOUCH_ZONE_LEFT[346];
        int n4 = TouchConstants.TOUCH_ZONE_BTM[346] - TouchConstants.TOUCH_ZONE_TOP[346];
        TouchConstants.TOUCH_ZONE_LEFT[346] = (short)(n - n3 / 2);
        TouchConstants.TOUCH_ZONE_TOP[346] = (short)(n2 - n4 / 2);
        TouchConstants.TOUCH_ZONE_RIGHT[346] = (short)(TouchConstants.TOUCH_ZONE_LEFT[346] + n3);
        TouchConstants.TOUCH_ZONE_BTM[346] = (short)(TouchConstants.TOUCH_ZONE_TOP[346] + n4);
        Cursor.m_nCursorPos = TouchGameController.getClosestBoardCellPos();
        Cursor.m_nCursorType = 0;
    }

    static int getClosestBoardCellPos() {
        short s = TouchConstants.TOUCH_ZONE_LEFT[346];
        short s2 = TouchConstants.TOUCH_ZONE_TOP[346];
        int n = Math.abs(TouchConstants.TOUCH_ZONE_RIGHT[346] - TouchConstants.TOUCH_ZONE_LEFT[346]);
        int n2 = Math.abs(TouchConstants.TOUCH_ZONE_BTM[346] - TouchConstants.TOUCH_ZONE_TOP[346]);
        int n3 = s + n / 2;
        int n4 = s2 + n2 / 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 300;
        int n8 = Math.abs(TouchConstants.TOUCH_ZONE_RIGHT[n7] - TouchConstants.TOUCH_ZONE_LEFT[n7]) / 2;
        int n9 = Math.abs(TouchConstants.TOUCH_ZONE_BTM[n7] - TouchConstants.TOUCH_ZONE_TOP[n7]) / 2;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        for (int i = 0; i < 9 * GModel.m_nGameBoardRows; ++i) {
            if ((GModel.m_lBoardGridAsDirt & 1L << i) != 0L) continue;
            n5 = TouchConstants.TOUCH_ZONE_LEFT[282 + i] + n8;
            n6 = TouchConstants.TOUCH_ZONE_TOP[282 + i] + n9;
            n12 = Math.abs(n3 - n5) * Math.abs(n3 - n5) + Math.abs(n4 - n6) * Math.abs(n4 - n6);
            if (n11 != -1 && n12 >= n11) continue;
            n11 = n12;
            n10 = i;
        }
        if (Geometry.rectIntersect(s, s2, n, n2, TouchConstants.TOUCH_ZONE_LEFT[282 + n10], TouchConstants.TOUCH_ZONE_TOP[282 + n10], n8 * 2, n9 * 2)) {
            return n10;
        }
        return -1;
    }

    static void drawPlantableSeed(Graphics graphics, int n, int n2) {
        if (m_nPlantableSeedType >= 0 && Cursor.m_nCursorType != 1 && Cursor.m_nCursorPos != -1 && Plants.getPlantIndexAtPos(Cursor.m_nCursorPos) == -1) {
            TouchGameController.drawPlantableSeedAlpha(graphics, n, n2);
        }
    }

    static void drawPlantableSeedAlpha(Graphics graphics, int n, int n2) {
    }

    static void handleSeedPacketZone(int n, int n2, int n3, int n4) {
        int n5;
        if (n2 == 90) {
            ++m_nCurrentSeedPresses;
            n5 = TouchGameController.getSeedIndexFromZoneID(n);
            if (m_nCurrentHighlightedSeedIndex == n5 && n5 != -1) {
                if (m_nCurrentSeedPresses == 2) {
                    TouchGameController.resetSelectedSeed();
                    return;
                }
            } else {
                m_nCurrentSeedPresses = 1;
            }
        }
        if (n2 == 84 || n2 == 92 || n2 == 90) {
            int n6;
            n5 = m_nCurrentHighlightedSeedIndex;
            int n7 = TouchGameController.getSeedIndexFromZoneID(n);
            int n8 = SeedBank.SEEDS[n7 * SeedBank.SEED_MAX_VALS + SeedBank.SEED_BANK_POS];
            if (!Cursor.bSeedAtCursorPlantable(n8, n6 = SeedBank.SEEDS[n7 * SeedBank.SEED_MAX_VALS + SeedBank.SEED_TYPE], 1)) {
                TouchGameController.resetSelectedSeed();
                return;
            }
            m_nCurrentHighlightedSeedIndex = n7;
            SeedBank.setSeedToHighlight(n8);
            Cursor.m_nCursorType = 1;
            if (m_nCurrentHighlightedSeedIndex != n5) {
                SeedBank.updatePositions(n8, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), true);
                Cursor.m_nCursorPos = n8;
                if (n2 != 90) {
                    m_nCurrentSeedPresses = 0;
                }
            }
            m_nPlantableSeedType = -1;
            TouchController.setTouchZoneDataInstantly(346, -1, -1, -1, -1, true);
            if (GFHint.m_nCurrentHint == 1) {
                Hints.flagHint(2);
            }
        }
        if (n2 == 90 && m_nCurrentHighlightedSeedIndex != -1) {
            TouchGameController.setPlantableSeed(m_nCurrentHighlightedSeedIndex, n3, n4, false);
        }
    }

    static void resetSelectedSeed() {
        m_nCurrentHighlightedSeedIndex = -1;
        m_nPlantableSeedType = -1;
        Cursor.m_nCursorPos = -1;
        m_nCurrentSeedPresses = 0;
        SeedBank.updatePositions(0, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), false);
    }

    static int getSeedIndexFromZoneID(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 7 && n2 < SeedBank.m_nSeeds; ++i) {
            if (!SeedBank.isSeedAtIndex(i)) continue;
            n3 = i * SeedBank.SEED_MAX_VALS;
            if (SeedBank.SEEDS[n3 + SeedBank.SEED_ZONE_ID] == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    static void plantSeed() {
        if (m_nPlantableSeedType >= 0 && Cursor.m_nCursorType == 0 && Cursor.m_nCursorPos != -1 && Cursor.bSeedAtCursorPlantable(Cursor.m_nCursorPos, m_nPlantableSeedType, 0)) {
            SeedBank.plantSeed(Cursor.m_nCursorPos, m_nPlantableSeedType);
        }
        TouchGameController.resetSelectedSeed();
        TouchConstants.TOUCH_ZONE_LEFT[346] = -1;
        TouchConstants.TOUCH_ZONE_RIGHT[346] = -1;
        TouchConstants.TOUCH_ZONE_TOP[346] = -1;
        TouchConstants.TOUCH_ZONE_BTM[346] = -1;
        SeedBank.updatePositions(0, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), false);
    }

    static int createNewCoinZone(int n, int n2, int n3) {
        for (int i = 348; i < 363; ++i) {
            if (TouchGameController.bIsZoneActive(i)) continue;
            char c = "\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n3);
            TouchController.setTouchZoneDataInstantly(i, n, n2, GFCanvas.getImageWidth(c), GFCanvas.getImageHeight(c), true);
            return i;
        }
        return -1;
    }

    static void clearSeedBankZones() {
        for (int i = 336; i < 345; ++i) {
            TouchController.clearTouchZone(i);
        }
    }

    static int createNewSeedZone(int n, int n2, int n3) {
        for (int i = 336; i < 345; ++i) {
            if (TouchGameController.bIsZoneActive(i)) continue;
            int n4 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n3));
            int n5 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n3));
            TouchController.setTouchZoneDataInstantly(i, n, n2, n + n4, n2 + n5, true);
            return i;
        }
        return -1;
    }

    static void updateSeedZone(int n, boolean bl) {
        int n2 = SeedBank.SEED_MAX_VALS * n;
        int n3 = SeedBank.SEEDS[n2 + SeedBank.SEED_ZONE_ID];
        int n4 = SeedBank.SEEDS[n2 + SeedBank.SEED_TYPE];
        if (n3 != -1 && n4 != -1) {
            int n5 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n4)) + 2;
            int n6 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(n4));
            if (bl) {
                TouchController.clearTouchZone(n3);
            } else if (GModel.m_bConveyorLevel) {
                int n7 = FP.toInt(SeedBank.SEEDS[n2 + SeedBank.SEED_FP_X]);
                int n8 = FP.toInt(SeedBank.SEEDS[n2 + SeedBank.SEED_FP_Y]);
                n8 = GModel.m_bConveyorLevel ? (n8 += n * 8) : (n8 -= 30 + n * 7);
                int n9 = n7 + n6;
                int n10 = n8 + n5;
                TouchController.setTouchZoneDataInstantly(n3, n7, n8, n9, n10, true);
            } else {
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = HUDModel.HUD_COMPONENT_SEEDS * HUDModel.HUD_PAN_MAX_VALS;
                if (Layer.isLandscape(2)) {
                    n12 += FP.toInt(HUDModel.m_HudPanComponents[n14 + HUDModel.HUD_PAN_FP_CURR_POS]);
                } else {
                    n13 += FP.toInt(HUDModel.m_HudPanComponents[n14 + HUDModel.HUD_PAN_FP_CURR_POS]);
                }
                n13 -= 30;
                for (int i = 0; i < 7 && n11 < SeedBank.m_nSeeds; ++i) {
                    if (!SeedBank.isSeedAtIndex(i)) continue;
                    n2 = SeedBank.SEED_MAX_VALS * i;
                    n3 = SeedBank.SEEDS[n2 + SeedBank.SEED_ZONE_ID];
                    if (TouchGameController.bIsZoneActive(n3)) {
                        int n15 = n12 + FP.toInt(SeedBank.SEEDS[n2 + SeedBank.SEED_FP_X]);
                        int n16 = n13 + FP.toInt(SeedBank.SEEDS[n2 + SeedBank.SEED_FP_Y]) + i * 7;
                        TouchController.setTouchZoneDataInstantly(n3, n15, n16, n15 + n6, n16 + n5, true);
                    }
                    ++n11;
                }
            }
        }
    }

    static void handleCoinPress(int n) {
        int n2 = Coins.getCoinIndexFromAttribute(Coins.COIN_ZONE_ID, n);
        int n3 = n2 * Coins.COIN_MAX_VALS;
        int n4 = Coins.COINS[n3 + Coins.COIN_STATE];
        if (n4 == 0 || n4 == 2) {
            Coins.startZoomToDest(n2);
            TouchController.clearTouchZone(n);
        }
    }

    static void updateCoinZone(int n, boolean bl) {
        int n2 = Coins.COIN_MAX_VALS * n;
        int n3 = Coins.COINS[n2 + Coins.COIN_ZONE_ID];
        int n4 = Coins.COINS[n2 + Coins.COIN_TYPE];
        if (n3 != -1 && n4 != -1) {
            if (bl) {
                TouchController.clearTouchZone(n3);
            } else {
                char c = "\u01c6\u01c6\u0197\u019b\u00e6\u014e".charAt(n4);
                int n5 = FP.toInt(Coins.COINS[n2 + Coins.COIN_FP_X]);
                int n6 = FP.toInt(Coins.COINS[n2 + Coins.COIN_FP_Y]);
                int n7 = n5 + GFCanvas.getImageWidth(c);
                int n8 = n6 + GFCanvas.getImageHeight(c);
                TouchController.setTouchZoneDataInstantly(n3, n5, n6, n7, n8, true);
            }
        }
    }

    static void handlePressShovel() {
        if (GameController.m_nLevel >= 4) {
            Cursor.m_nCursorPos = -1;
            m_nPlantableSeedType = -1;
            if (Cursor.m_nCursorType == 3) {
                Cursor.m_nCursorType = -1;
                TouchGameController.setShovelSoftKeyImage((short)"]\u015d\u01fb\u00fa\u013c".charAt(4));
            } else {
                Cursor.m_nCursorType = 3;
                if (GModel.m_bShovelTutorialLevel && GFHint.m_nCurrentHint == 10) {
                    Hints.clearHint(10, true);
                    if (!GFHint.bHintDisplayed(11)) {
                        Hints.flagHint(11);
                    }
                }
                TouchGameController.setShovelSoftKeyImage(89);
                SeedBank.updatePositions(0, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), false);
            }
        }
    }

    static void setShovelSoftKeyImage(int n) {
        if (GameController.m_nLevel >= 4) {
            if ((short)"\u0000\u0001\u0001\u0001\u0000".charAt(4) == 0) {
                GFMain.m_LeftGameSoftkeyButton[2] = n;
            } else {
                GFMain.m_RightGameSoftkeyButton[2] = n;
            }
        }
    }

    static void removePlant(int n) {
        int n2 = Plants.getTopPlant(n, 5);
        if (n2 != -1) {
            Plants.killPlant(n2);
            if (GFHint.m_nCurrentHint == 11) {
                Hints.clearHint(11, true);
                if (!GFHint.bHintDisplayed(12)) {
                    Hints.flagHint(12);
                }
            }
        }
        Cursor.m_nCursorType = 1;
        Cursor.m_nCursorPos = -1;
    }

    static void setSeedPickerZones(int n) {
        for (int i = 53; i < 93; ++i) {
            TouchController.clearTouchZone(i);
        }
        TouchController.clearTouchZone(94);
        TouchController.clearTouchZone(95);
        TouchGameController.updateSeedPickerBankZones();
        TouchGameController.updateSeedPickerLibraryZones(0, 0);
    }

    static void updateSeedPickerBankZones() {
        int n = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(SeedPicker.m_nSeedSelected));
        int n2 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(SeedPicker.m_nSeedSelected));
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 7 && n3 < SeedPicker.m_nSeeds; ++i) {
            if (!SeedPicker.isSeedAtIndex(i)) continue;
            n4 = i * SeedPicker.SEED_PICKER_MAX_VALS;
            n5 = SeedPicker.SEED_PICKER_SELECTION[n4 + SeedPicker.SEED_PICKER_BANK_POS];
            ++n3;
            SeedPicker.getSeedPos(n5, 0, false, true);
            int n6 = SeedPicker.m_nSeedTempX;
            int n7 = SeedPicker.m_nSeedTempY;
            TouchController.setTouchZoneDataInstantly(43 + n5, n6, n7, n6 + n, n7 + n2, true);
        }
    }

    static void updateSeedPickerLibraryZones(int n, int n2) {
        int n3;
        for (n3 = 53; n3 < 93; ++n3) {
            TouchController.clearTouchZone(n3);
        }
        n3 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        int n4 = GFCanvas.getImageHeight("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(3));
        for (int i = 0; i < SeedPicker.m_nMaxItems; ++i) {
            SeedPicker.getSeedPos(i, 1, false, true);
            if (SeedPicker.m_nSeedTempY + n4 > SeedPicker.SEED_LIBRARY_DIMS[SeedPicker.SEED_LIBRARY_Y] + SeedPicker.SEED_LIBRARY_DIMS[SeedPicker.SEED_LIBRARY_H] || SeedPicker.m_nSeedTempY < SeedPicker.SEED_LIBRARY_DIMS[SeedPicker.SEED_LIBRARY_Y] - 16) continue;
            int n5 = SeedPicker.m_nSeedTempX + n;
            int n6 = SeedPicker.m_nSeedTempY + n2;
            TouchController.setTouchZoneDataInstantly(53 + i, n5, n6, n5 + n3, n6 + n4, true);
        }
    }

    static void handlePressSeedPickerLibrary(int n) {
        int n2 = n - 53;
        if (SeedPicker.isRooftopSeedOff(SeedPicker.UNLOCKED_SEED_TYPES[n2]) || SeedPicker.isDaySeedOff(SeedPicker.UNLOCKED_SEED_TYPES[n2])) {
            return;
        }
        if (SeedPicker.m_nSeeds < SeedBank.m_nCurrMaxSeeds) {
            boolean bl = SeedPicker.addSeed(SeedPicker.UNLOCKED_SEED_TYPES[n2], n2, GFUIState.m_nUIState);
            if (!bl) {
                int n3 = SeedPicker.getSeedBankPosFromLibPos(n2);
                SeedPicker.deSelectSeed(n3);
            }
        } else if ((SeedPicker.m_lSeedsSelected & 1L << n2) != 0L) {
            int n4 = SeedPicker.getSeedBankPosFromLibPos(n2);
            SeedPicker.deSelectSeed(n4);
        }
    }

    static void handleSeedPickerRemoveSeed(int n) {
        int n2 = n - 43;
        SeedPicker.deSelectSeed(n2);
    }

    static {
        m_bSeedsSelected = false;
    }
}

