/*
 * Decompiled with CFR 0.152.
 */
public class Mowers
implements GameConstants,
Constants {
    static int MOWER_TYPE_NONE = -1;
    static int MOWER_TYPE_NORMAL = 0;
    static int MOWER_TYPE_POOL = 1;
    static int MOWER_STATE_ROLLING_IN = 0;
    static int MOWER_STATE_READY = 1;
    static int MOWER_STATE_MOWING = 2;
    static int m_nMowers;
    static int MAX_NUM_MOWERS;
    static int MOWER_TYPE;
    static int MOWER_FP_X;
    static int MOWER_FP_Y;
    static int MOWER_FP_VX;
    static int MOWER_FP_VY;
    static int MOWER_STATE;
    static int MOWER_FRAME;
    static int MOWER_ROW;
    static int MOWER_MAX_VALS;
    static final int[] MOWERS;

    static void init() {
    }

    static void resetVarsNewLevel() {
        Util.resetArray(MOWERS, MOWER_TYPE_NONE);
        m_nMowers = 0;
    }

    static void addMower(int n, int n2, int n3) {
        if (n >= 0) {
            int n4 = 0;
            for (int i = 0; i < MAX_NUM_MOWERS; ++i) {
                if (Mowers.isMowerAtIndex(i)) continue;
                n4 = MOWER_MAX_VALS * i;
                Mowers.MOWERS[n4 + Mowers.MOWER_TYPE] = n;
                Mowers.MOWERS[n4 + Mowers.MOWER_FP_X] = Mowers.getStartFPX(n, n2, 25);
                Mowers.MOWERS[n4 + Mowers.MOWER_FP_Y] = Mowers.getStartFPY(n, n2);
                Mowers.MOWERS[n4 + Mowers.MOWER_FP_VX] = 20480;
                Mowers.MOWERS[n4 + Mowers.MOWER_ROW] = n2;
                Mowers.MOWERS[n4 + Mowers.MOWER_STATE] = MOWER_STATE_ROLLING_IN;
                Mowers.MOWERS[n4 + Mowers.MOWER_FRAME] = n3;
                ++m_nMowers;
                return;
            }
        }
    }

    static int getStartFPX(int n, int n2, int n3) {
        return (-35 - n3 + GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5))) * 4096;
    }

    static int getStartFPY(int n, int n2) {
        return (41 - GFCanvas.getImageHeight("\u00ec\u018b".charAt(n)) + n2 * Cursor.getCursorGameH() + GModel.getBoardOffsetY(Layer.getLayerProperty(2, 5))) * 4096;
    }

    static boolean isMowerAtIndex(int n) {
        return MOWERS[MOWER_MAX_VALS * n + MOWER_TYPE] != MOWER_TYPE_NONE;
    }

    static void update() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < MAX_NUM_MOWERS && n < m_nMowers; ++i) {
            if (!Mowers.isMowerAtIndex(i)) continue;
            n2 = i * MOWER_MAX_VALS;
            if (MOWERS[n2 + MOWER_STATE] == MOWER_STATE_ROLLING_IN) {
                Mowers.updateRollingIn(i);
            } else if (MOWERS[n2 + MOWER_STATE] == MOWER_STATE_READY) {
                Mowers.updateReady(i);
            } else if (MOWERS[n2 + MOWER_STATE] == MOWER_STATE_MOWING) {
                Mowers.updateMowing(i);
            }
            ++n;
        }
    }

    static void updateRollingIn(int n) {
        int n2 = n * MOWER_MAX_VALS;
        if (MOWERS[n2 + MOWER_FRAME] > 0) {
            int n3 = n2 + MOWER_FRAME;
            MOWERS[n3] = MOWERS[n3] - 1;
            return;
        }
        int n4 = n2 + MOWER_FP_X;
        MOWERS[n4] = MOWERS[n4] + MOWERS[n2 + MOWER_FP_VX];
        Mowers.MOWERS[n2 + Mowers.MOWER_FP_VX] = FP.fpMul(MOWERS[n2 + MOWER_FP_VX], GModel.FP_90_PERCENT);
        int n5 = (-35 + GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5))) * 4096;
        if (MOWERS[n2 + MOWER_FP_X] >= n5) {
            Mowers.MOWERS[n2 + Mowers.MOWER_FP_X] = n5;
            Mowers.MOWERS[n2 + Mowers.MOWER_FP_VX] = 0;
            Mowers.MOWERS[n2 + Mowers.MOWER_STATE] = MOWER_STATE_READY;
        }
    }

    static void updateReady(int n) {
        int n2 = n * MOWER_MAX_VALS;
        int n3 = CollisionHandler.checkMowerCollisions(n);
        if (n3 != -1) {
            int n4 = n3 * Zombies.ZOMBIE_MAX_VALS;
            int n5 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_TYPE];
            if (n5 == 21 || n5 == 22) {
                Mowers.killMower(n);
            } else {
                Mowers.MOWERS[n2 + Mowers.MOWER_STATE] = MOWER_STATE_MOWING;
                Zombies.killZombie(n3, true);
                Mowers.MOWERS[n2 + Mowers.MOWER_FP_VX] = 8192;
            }
        }
    }

    static void updateMowing(int n) {
        int n2;
        int n3 = n * MOWER_MAX_VALS;
        int n4 = CollisionHandler.checkMowerCollisions(n);
        if (n4 != -1) {
            n2 = n4 * Zombies.ZOMBIE_MAX_VALS;
            int n5 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_TYPE];
            if (n5 == 21 || n5 == 22) {
                Mowers.killMower(n);
            } else if (n5 != 20) {
                Zombies.killZombie(n4, true);
            }
        }
        int n6 = n3 + MOWER_FP_X;
        MOWERS[n6] = MOWERS[n6] + MOWERS[n3 + MOWER_FP_VX];
        if (MOWERS[n3 + MOWER_FP_VX] < 28672) {
            Mowers.MOWERS[n3 + Mowers.MOWER_FP_VX] = Math.min(FP.fpMul(MOWERS[n3 + MOWER_FP_VX], GModel.FP_110_PERCENT), 28672);
        }
        n2 = Layer.getLayerProperty(2, 3) * 4096;
        if (MOWERS[n3 + MOWER_TYPE] == MOWER_TYPE_NORMAL && GModel.PLANT_ROW[MOWERS[n3 + MOWER_ROW]] == 3 && MOWERS[n3 + MOWER_FP_X] > GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) * 4096) {
            GCanvasController.doMowerSplash(n);
            Mowers.killMower(n);
        }
        if (MOWERS[n3 + MOWER_FP_X] >= n2) {
            Mowers.killMower(n);
        }
    }

    static void killMower(int n) {
        Mowers.MOWERS[n * Mowers.MOWER_MAX_VALS + Mowers.MOWER_TYPE] = MOWER_TYPE_NONE;
        --m_nMowers;
    }

    static {
        MAX_NUM_MOWERS = 6;
        MOWER_TYPE = 0;
        MOWER_FP_X = MOWER_TYPE + 1;
        MOWER_FP_Y = MOWER_FP_X + 1;
        MOWER_FP_VX = MOWER_FP_Y + 1;
        MOWER_FP_VY = MOWER_FP_VX + 1;
        MOWER_STATE = MOWER_FP_VY + 1;
        MOWER_FRAME = MOWER_STATE + 1;
        MOWER_ROW = MOWER_FRAME + 1;
        MOWER_MAX_VALS = MOWER_ROW + 1;
        MOWERS = new int[MAX_NUM_MOWERS * MOWER_MAX_VALS];
    }
}

