/*
 * Decompiled with CFR 0.152.
 */
public class LevelIntro
implements GameConstants,
Constants,
ReanimAttributes,
ConstantsReanim {
    static final int STREET_GRID_SIZE_X = 5;
    static final int STREET_GRID_SIZE_Y = 5;
    static final int[] m_nZombieTypeCount = new int[23];
    static final int WEIGHTED_GRID_X = 0;
    static final int WEIGHTED_GRID_Y = 1;
    static final int WEIGHTED_GRID_WEIGHT = 2;
    static final int WEIGHTED_GRID_MAX_VALS = 3;
    static final int[][] WeightedGridArray = new int[25][3];
    static final boolean[][] ZombieGridArray = new boolean[5][5];
    static final int[] m_TempZombieIndexes = new int[5];
    static int m_nTempGridX;
    static int m_nTempGridY;
    static int m_nLevelIntroPausedFrames;
    static int m_nState;

    static void init() {
    }

    static void resetVarsNewLevel() {
        Util.resetArray(m_nZombieTypeCount, 0);
        m_nState = -1;
    }

    static void startLevelIntro() {
        m_nLevelIntroPausedFrames = 36;
        m_nState = 0;
        ViewPort.startLevel();
        LevelIntro.placeZombiesOnStreet();
        LevelIntro.sortZombieRenderOrders();
        if (CrazyDave.bCheckForCrazyDave(GameController.m_nLevel, GameController.m_nGameMode)) {
            GFUIState.gotoStateOrPerformAction(42);
        }
    }

    static void startLevelOutro() {
        m_nLevelIntroPausedFrames = 9;
    }

    static void update() {
        if (GameController.m_nGameState == 2) {
            if (m_nState == 0) {
                if (m_nLevelIntroPausedFrames > 0 && --m_nLevelIntroPausedFrames == 0) {
                    ViewPort.startLevelIntroMoving();
                    m_nState = 2;
                }
            } else if (m_nState == 2) {
                if (ViewPort.bFinishedZoom()) {
                    m_nState = 1;
                    m_nLevelIntroPausedFrames = 36;
                }
            } else if (m_nState == 1 && m_nLevelIntroPausedFrames > 0 && --m_nLevelIntroPausedFrames == 0) {
                LevelIntro.finishLevelIntroViewZombies();
            }
        } else if (GameController.m_nGameState == 3) {
            if (m_nLevelIntroPausedFrames > 0 && --m_nLevelIntroPausedFrames == 0) {
                ViewPort.startLevelOutroMoving();
            }
            if (m_nLevelIntroPausedFrames == 0 && ViewPort.bFinishedZoom()) {
                if (GameController.m_nGameMode == 0 && (GameController.m_nLevel == 0 || GameController.m_nLevel == 1 || GameController.m_nLevel == 3)) {
                    GameController.changeState(5);
                } else {
                    GameController.changeState(0);
                }
                if (GameController.m_nLevel == 49) {
                    Zombies.addZombie(20, 3, 0);
                }
            }
        }
    }

    static void placeZombiesOnStreet() {
        int n;
        int n2;
        Util.resetArray(m_nZombieTypeCount, 0);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < ZombieController.m_nNumWaves; ++n2) {
            for (n = 0; n < 50 && (n5 = ZombieController.mZombiesInWave[n2][n]) != -1; ++n) {
                n4 += "\u0001\u0001\u0002\u0004\u0007\u0004\u0002\u0005\u0003\u0002\u0001\n\u0004\u0005\u0004\u0004\u0002\u0001\u0003\u0003\n\n\n".charAt(n5);
                if (n5 == 1) continue;
                int n6 = n5;
                m_nZombieTypeCount[n6] = m_nZombieTypeCount[n6] + 1;
                ++n3;
            }
        }
        for (n2 = 0; n2 < GModel.m_nGameBoardRows; ++n2) {
            if (GModel.PLANT_ROW[n2] != 3) continue;
            LevelIntro.m_nZombieTypeCount[17] = 1;
            ++n3;
        }
        for (n2 = 0; n2 < 5; ++n2) {
            Util.resetArray(ZombieGridArray[n2], false);
        }
        n2 = 10;
        for (n5 = 0; n5 < 23; ++n5) {
            if (m_nZombieTypeCount[n5] == 0 || !LevelIntro.Is2x2Zombie(n5)) continue;
            LevelIntro.findAndPlaceZombie(n5, ZombieGridArray);
        }
        for (n5 = 0; n5 < 23; ++n5) {
            if (m_nZombieTypeCount[n5] == 0 || LevelIntro.Is2x2Zombie(n5)) continue;
            n = m_nZombieTypeCount[n5] * n2 / n3;
            n = Util.clampInt(n, 1, m_nZombieTypeCount[n5]);
            for (int i = 0; i < n; ++i) {
                LevelIntro.findAndPlaceZombie(n5, ZombieGridArray);
            }
        }
    }

    static void findAndPlaceZombie(int n, boolean[][] blArray) {
        LevelIntro.findPlaceForStreetZombies(n, blArray);
        blArray[LevelIntro.m_nTempGridX][LevelIntro.m_nTempGridY] = true;
        if (LevelIntro.Is2x2Zombie(n)) {
            blArray[LevelIntro.m_nTempGridX - 1][LevelIntro.m_nTempGridY] = true;
            blArray[LevelIntro.m_nTempGridX][LevelIntro.m_nTempGridY - 1] = true;
            blArray[LevelIntro.m_nTempGridX - 1][LevelIntro.m_nTempGridY - 1] = true;
        }
        if (GameController.m_nLevel != 49) {
            LevelIntro.placeAZombie(n, m_nTempGridX, m_nTempGridY);
        }
    }

    static void findPlaceForStreetZombies(int n, boolean[][] blArray) {
        int n2;
        int n3;
        for (n3 = 0; n3 < WeightedGridArray.length; ++n3) {
            Util.resetArray(WeightedGridArray[n3], 0);
        }
        n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            for (int i = 0; i < 5; ++i) {
                if (!LevelIntro.canZombieGoInGridSpot(n, n2, i, blArray)) continue;
                LevelIntro.WeightedGridArray[n3][0] = n2;
                LevelIntro.WeightedGridArray[n3][1] = i;
                LevelIntro.WeightedGridArray[n3][2] = 1;
                ++n3;
            }
        }
        if (n3 == 0) {
            m_nTempGridX = 2;
            m_nTempGridY = 2;
            return;
        }
        n2 = LevelIntro.pickFromWeightedGridArray(WeightedGridArray, n3);
        m_nTempGridX = WeightedGridArray[n2][0];
        m_nTempGridY = WeightedGridArray[n2][1];
    }

    static void placeAZombie(int n, int n2, int n3) {
        short s = (short)"\u0000\u0000\u0000\u0000\u0004\u0000\u0001\u0002\u0005\u0006\u0003\u0007\t\n\u000b\f\r\u0000\u000f\b\u0010\u0011\u0012".charAt(n);
        short s2 = (short)"\u0005\u001e\uffff\uffffNXku\uffff\u009c\u00a5\u00b4\u00bd\u00d3\uffff\u00f3\u011e\uffff\uffff\u0143\u0150\u0157\u0162\u016c\u0176\u017a\u017c\u0187\u018d\u0192\u0196\u019c\u01a6\u01ac\u01b1\u01b8\u01bb\u01c1\u01ce\u01d5\u01dc\u01e1\u01ee\u01f2\u01f7\u01fd\u0201\u0204\u0213\uffff\uffff".charAt(s);
        if (s2 == -1) {
            s2 = (short)"\u0004!.AMYjv\u0089\u0098\u00a3\u00b3\u00be\u00d7\uffff\u00f2\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(s);
        }
        int n4 = Zombies.addZombie(n, 0, -1, s, s2);
        int n5 = Zombies.ZOMBIE_MAX_VALS * n4;
        if (Layer.isLandscape(2)) {
            Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_FP_CENTRE_X] = (365 + n2 * 19) * 4096;
            Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_FP_TOP_Y] = (45 + n3 * 31) * 4096;
        } else {
            Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_FP_CENTRE_X] = (335 + n2 * 19) * 4096;
            Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_FP_TOP_Y] = (45 + n3 * 31) * 4096;
        }
        Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_FP_VX] = 0;
        if (n2 % 2 == 1) {
            int n6 = n5 + Zombies.ZOMBIE_FP_TOP_Y;
            Zombies.ZOMBIES[n6] = Zombies.ZOMBIES[n6] + 24576;
        }
        int n7 = Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_REANIM_FP_FPS];
        int n8 = FP.fpMul(n7, FP.fpDiv(270336, 409600));
        Zombies.setReanimFPS(n4, Math.max(4096, n8), false);
        int n9 = n5 + Zombies.ZOMBIE_FP_CENTRE_X;
        Zombies.ZOMBIES[n9] = Zombies.ZOMBIES[n9] + Util.GetRandom(6) * 4096;
        int n10 = 36864;
        int n11 = n10 / GModel.m_nGameBoardRows;
        int n12 = (n3 * 2 + n2 % 2) * 4096;
        int n13 = FP.toInt(FP.fpDiv(n12, n11) - 1);
        Zombies.ZOMBIES[n5 + Zombies.ZOMBIE_ROW] = n13 = Util.clampInt(n13, 0, GModel.m_nGameBoardRows - 1);
    }

    static void sortZombieRenderOrders() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < GModel.m_nGameBoardRows; ++i) {
            Util.resetArray(m_TempZombieIndexes, -1);
            n4 = 0;
            for (int j = 0; j < 100 && n2 < Zombies.m_nZombies; ++j) {
                n = Zombies.ZOMBIE_MAX_VALS * j;
                if (!Zombies.isZombieAtIndex(j) || (n3 = Zombies.ZOMBIES[n + Zombies.ZOMBIE_ROW]) != i) continue;
                LevelIntro.m_TempZombieIndexes[n4] = j;
                if (++n4 == 5) break;
                ++n2;
            }
            if (n4 < 2) continue;
            LevelIntro.bubbleSortZombieRow(i, m_TempZombieIndexes, n4);
        }
    }

    static void bubbleSortZombieRow(int n, int[] nArray, int n2) {
        boolean bl = true;
        int n3 = 0;
        do {
            bl = false;
            ++n3;
            for (int i = 0; i < n2 - 1; ++i) {
                int n4 = Zombies.ZOMBIE_MAX_VALS * nArray[i];
                int n5 = Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_TYPE];
                Zombies.getZombieOffsets(n5, false);
                int n6 = FP.toInt(Zombies.ZOMBIES[n4 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_Y];
                int n7 = Zombies.ZOMBIE_MAX_VALS * nArray[i + 1];
                int n8 = Zombies.ZOMBIES[n7 + Zombies.ZOMBIE_TYPE];
                Zombies.getZombieOffsets(n8, false);
                int n9 = FP.toInt(Zombies.ZOMBIES[n7 + Zombies.ZOMBIE_FP_TOP_Y]) + Zombies.ZOMBIE_OFFSETS[Zombies.ZOMBIE_OFFSET_SHADOW_Y];
                if (n6 <= n9) continue;
                Zombies.swapZombieIndexes(nArray[i], nArray[i + 1]);
                bl = true;
            }
        } while (bl);
    }

    static boolean Is2x2Zombie(int n) {
        return n == 11;
    }

    static boolean canZombieGoInGridSpot(int n, int n2, int n3, boolean[][] blArray) {
        if (blArray[n2][n3]) {
            return false;
        }
        if (LevelIntro.Is2x2Zombie(n)) {
            if (n2 == 0 || n3 == 0) {
                return false;
            }
            if (blArray[n2 - 1][n3] || blArray[n2][n3 - 1] || blArray[n2 - 1][n3 - 1]) {
                return false;
            }
        }
        return n2 != 4 || n3 != 0;
    }

    static int pickFromWeightedGridArray(int[][] nArray, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 += nArray[n2][2];
        }
        if (n3 > 0) {
            n2 = Util.GetRandom(n3);
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                if (n2 >= (n4 += nArray[i][2])) continue;
                return i;
            }
        }
        return 0;
    }

    static void finishLevelIntroViewZombies() {
        if (GModel.m_bConveyorLevel) {
            PVZActions.returnToGameFromSeedPicker();
        } else if (SeedPicker.getNumOfUnlockedSeeds() > SeedBank.m_nCurrMaxSeeds) {
            GFUIState.gotoStateOrPerformAction(11);
        } else {
            PVZActions.returnToGameFromSeedPicker();
        }
    }
}

