/*
 * Decompiled with CFR 0.152.
 */
public class FP {
    public static final int FP_PRECISION = 12;
    public static final int FP_MAX = Integer.MAX_VALUE;
    public static final int FP_ONE = 4096;
    public static final int FP_HALF = 2048;
    public static final int FP_DECIMAL_MASK = 4095;
    public static final int FP_INTEGER_MASK = -4096;
    public static final int FP_ONEHUNDRED = 409600;
    public static final int FP_PI = 12867;
    public static final int FP_PI_HALF = 6433;
    public static final int FP_TWO_PI = 25734;
    public static final int FP_PI_DEGREES = 737280;
    public static final int FP_SIN_COS_45 = 2896;
    public static final int FP_SIN_15 = 1060;
    public static final int FP_COS_15 = 3956;
    public static final int FP_SQRT_2 = 5792;
    public static final int FP_DEGREES_TO_RADS = 71;
    public static final int FP_RADS_TO_DEGREES = FP.fpDiv(737280, 12867);
    static final int FP_SINE_TBL_1 = 31;
    static final int FP_SINE_TBL_2 = 680;
    static final int FP_ARCSINE_TBL_1 = -77;
    static final int FP_ARCSINE_TBL_2 = 304;
    static final int FP_ARCSINE_TBL_3 = 868;
    static final int FP_ARCSINE_TBL_4 = 6433;
    static boolean OVERFLOW = false;
    static final int CURVE_CONSTANT = 0;
    static final int CURVE_LINEAR = 1;
    static final int CURVE_BOUNCE_EASE_IN = 2;
    static final int CURVE_BOUNCE_EASE_OUT = 3;
    static final int CURVE_BOUNCE_EASE_IN_AND_OUT = 4;
    static final int CURVE_BOUNCE_SLOW_MIDDLE = 4;
    static final int CURVE_BOUNCE_FAST_MIDDLE = 5;
    static final int CURVE_SLOW_START_AND_END = 6;

    static final int toFP(int n) {
        return n * 4096;
    }

    static final int toIntRound(int n) {
        int n2 = n & 0xFFF;
        if (n > 0) {
            if (n2 >= 2048) {
                return (n >> 12) + 1;
            }
            return n >> 12;
        }
        if (n2 > 0) {
            n2 = 4096 - n2;
        }
        if (n2 >= 2048) {
            return -(-n >> 12) - 1;
        }
        return -(-n >> 12);
    }

    static final int toInt(int n) {
        if (n >= 0) {
            return n >> 12;
        }
        return -(-n >> 12);
    }

    static final int fpMul(int n, int n2) {
        int n3 = (int)((long)n * (long)n2 >> 12);
        if (Math.abs(n3) > Integer.MAX_VALUE) {
            OVERFLOW = true;
            if (n3 >= 0) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        return n3;
    }

    static final int fpDiv(int n, int n2) {
        OVERFLOW = false;
        long l = ((long)n << 24) / (long)n2 >> 12;
        if (Math.abs(l) > Integer.MAX_VALUE) {
            OVERFLOW = true;
            throw new RuntimeException();
        }
        return (int)l;
    }

    static final int fpSqrt(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = n + 4096 >> 1;
        for (int i = 0; i < 8; ++i) {
            n2 = n2 + FP.fpDiv(n, n2) >> 1;
        }
        return n2;
    }

    static final int fpDistance(int n, int n2, int n3) {
        return FP.fpSqrt(FP.fpMul(n, n) + FP.fpMul(n2, n2) + FP.fpMul(n3, n3));
    }

    static final int fpSin(int n) {
        int n2 = 1;
        if (n < 0) {
            n = -n;
            n2 = -1;
        }
        int n3 = 1;
        if (n > 25734) {
            n %= 25734;
        }
        if (n > 6433 && n <= 12867) {
            n = 12867 - n;
        } else if (n > 12867 && n <= 19300) {
            n -= 12867;
            n3 = -1;
        } else if (n > 19300) {
            n = 25734 - n;
            n3 = -1;
        }
        int n4 = FP.fpMul(n, n);
        int n5 = 31;
        n5 = FP.fpMul(n5, n4);
        n5 -= 680;
        n5 = FP.fpMul(n5, n4);
        n5 += 4096;
        n5 = FP.fpMul(n5, n);
        return n2 * n3 * n5;
    }

    static int fpAsin(int n) {
        int n2 = FP.fpSqrt(4096 - n);
        int n3 = -77;
        n3 = FP.fpMul(n3, n);
        n3 += 304;
        n3 = FP.fpMul(n3, n);
        n3 -= 868;
        n3 = FP.fpMul(n3, n);
        n3 += 6433;
        n3 = 6433 - FP.fpMul(n2, n3);
        return n3;
    }

    static int fpCos(int n) {
        return FP.fpSin(6433 - n);
    }

    static int fpAcos(int n) {
        return 6433 - FP.fpAsin(n);
    }

    static int fpTan(int n) {
        return FP.fpDiv(FP.fpSin(n), FP.fpCos(n));
    }

    static int fpCotan(int n) {
        return FP.fpDiv(FP.fpCos(n), FP.fpSin(n));
    }

    static int fpAtan(int n) {
        int n2 = 0;
        if (n > 4096) {
            n = FP.fpDiv(4096, n);
            n2 = 1;
        } else if (n < -4096) {
            n = FP.fpDiv(4096, n);
            n2 = 2;
        }
        int n3 = FP.fpAsin(FP.fpDiv(n, FP.fpSqrt(4096 + FP.fpMul(n, n))));
        if (n2 == 1) {
            n3 = 6433 - n3;
        } else if (n2 == 2) {
            n3 = -6433 - n3;
        }
        return n3;
    }

    static int fpAtan2(int n, int n2) {
        if (n2 == 0) {
            if (n >= 0) {
                return 6433;
            }
            return -6433;
        }
        int n3 = 1;
        if (n < 0) {
            n3 = -1;
            n = -n;
        }
        int n4 = Math.abs(FP.fpAtan(FP.fpDiv(n, n2)));
        if (n2 > 0) {
            return n3 * n4;
        }
        return n3 * (12867 - n4);
    }

    static int fpAcotan(int n) {
        n = 1 / n;
        return FP.fpAtan(n);
    }

    static int getDecimal(int n) {
        if (n >= 0) {
            return n & 0xFFF;
        }
        return -(-n & 0xFFF);
    }

    static int getRandFPValueAsFP(int n, int n2) {
        int n3;
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        n3 = Math.abs(n2 - n);
        int n4 = (Util.GetRandom(100) + 1) * 4096;
        int n5 = FP.fpMul(n3, n4);
        n5 = FP.fpDiv(n5, 409600);
        return Math.max(n5 += n, n);
    }

    static int fpDegToRad(int n) {
        return FP.fpMul(n, 71);
    }

    static int fpRadToDeg(int n) {
        return FP.fpMul(n, FP_RADS_TO_DEGREES);
    }

    static int fpAnimateCurve(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 - n;
        int n8 = n2 - n;
        int n9 = FP.fpDiv(n7, n8);
        int n10 = 0;
        if (n6 == 0) {
            n10 = 0;
        } else if (n6 == 1) {
            n10 = n9;
        } else if (n6 == 4) {
            n10 = FP.fpCurveInvQuad(FP.fpCurveBounce(n9));
        } else if (n6 == 5) {
            n10 = FP.fpCurveBounce(n9);
        } else if (n6 == 6) {
            n10 = FP.fpCurveQuadS(n9);
        } else if (n6 == 2) {
            n10 = FP.fpCurveQuad(n9);
        } else if (n6 == 3) {
            n10 = FP.fpCurveInvQuad(n9);
        } else if (n6 == 4) {
            n10 = FP.fpCurveS(n9);
        }
        int n11 = FP.fpLerp(n4, n5, n10);
        return n11;
    }

    static int fpCurveInvQuad(int n) {
        return 2 * n - FP.fpMul(n, n);
    }

    static int fpCurveQuad(int n) {
        return FP.fpMul(n, n);
    }

    static int fpCurveBounce(int n) {
        return 4096 - Math.abs(4096 - n * 2);
    }

    static int fpCurveS(int n) {
        int n2 = FP.fpMul(n, n);
        return 3 * n2 - 2 * FP.fpMul(n, n2);
    }

    static int fpCurveQuadS(int n) {
        if (n <= 2048) {
            return FP.fpMul(FP.fpCurveQuad(n * 2), 2048);
        }
        return FP.fpMul(FP.fpCurveInvQuad((n - 2048) * 2), 2048) + 2048;
    }

    static int fpLerp(int n, int n2, int n3) {
        return n + FP.fpMul(n2 - n, n3);
    }
}

