/*
 * Decompiled with CFR 0.152.
 */
public class Cursor
implements GameConstants,
Constants {
    static int m_nCursorPos;
    static int m_nCursorType;
    static int m_nCursorFrame;
    static int CURSOR_POS;
    static int CURSOR_TYPE;
    static int CURSOR_FP_X;
    static int CURSOR_FP_Y;
    static int CURSOR_FP_VX;
    static int CURSOR_FP_VY;
    static int CURSOR_FP_DEST_X;
    static int CURSOR_FP_DEST_Y;
    static int CURSOR_STATE;
    static int CURSOR_MAX_VALS;
    static final int[] CURSOR_MOVE;
    static int[] GRID_POS;
    static int GRID_POS_X;
    static int GRID_POS_Y;
    static int GRID_POS_W;
    static int GRID_POS_H;

    static void setLevelVars() {
        m_nCursorPos = -1;
        m_nCursorType = -1;
        m_nCursorFrame = 0;
    }

    static void handleCursor(int[] nArray, int n) {
        if (n == 0) {
            return;
        }
        if (m_nCursorType == 0) {
            if (Layer.isPortrait(2)) {
                Cursor.handleCursorBoardPortrait(nArray, n);
            } else {
                Cursor.handleCursorBoardLandscape(nArray, n);
            }
        } else if (m_nCursorType == 1) {
            if (Layer.isPortrait(2)) {
                Cursor.handleCursorSeedBankPortrait(nArray, n);
            } else {
                Cursor.handleCursorSeedBankLandscape(nArray, n);
            }
        } else if (m_nCursorType == 2) {
            Cursor.handleCursorSeedBankShovel(nArray, n);
        } else if (m_nCursorType == 3) {
            if (Layer.isPortrait(2)) {
                Cursor.handleCursorBoardShovelPortrait(nArray, n);
            } else {
                Cursor.handleCursorBoardShovelLandscape(nArray, n);
            }
        }
        if ((n & nArray[0]) != 0 || (n & nArray[3]) != 0 || (n & nArray[2]) != 0 || (n & nArray[1]) != 0 || (n & nArray[4]) != 0) {
            ViewPort.checkViewPort();
        }
        Hints.handleInput(nArray, n);
    }

    static void switchCursorType(int n, int n2, boolean bl) {
        int n3 = m_nCursorPos;
        int n4 = m_nCursorType;
        m_nCursorPos = n == 1 && GModel.m_bConveyorLevel ? 0 : (n == 0 && bl ? Cursor.placeCursorOnBoard(n, n2) : (n == 3 ? Util.clampInt(n2, 0, 9 * GModel.m_nGameBoardRows - 1) : (n == 0 ? (n2 != -1 ? Util.clampInt(n2, 0, 9 * GModel.m_nGameBoardRows - 1) : Util.findNextSetBit(GModel.m_lBoardGridAsDirt ^ 0xFFFFFFFFFFFFFFFFL, 0)) : (n2 != -1 ? n2 : 0))));
        if (n == 1) {
            SeedBank.m_nSelectedSeedTypeToPlant = -1;
            SeedBank.updatePositions(m_nCursorPos, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), true);
        } else if (n != 3 && n != 0) {
            SeedBank.updatePositions(0, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), false);
        }
        m_nCursorType = n;
        Cursor.startZoomToDest(n3, m_nCursorPos, n4, m_nCursorType, 10);
    }

    static int placeCursorOnBoard(int n, int n2) {
        if (n == 0) {
            int n3 = 9;
            int n4 = GModel.m_nGameBoardRows;
            boolean bl = false;
            boolean bl2 = false;
            if (SeedBank.m_nSelectedSeedTypeToPlant != -1) {
                short s = (short)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e".charAt(SeedBank.m_nSelectedSeedTypeToPlant);
                short s2 = (short)"\u0001\u0002\u0000\u0001\u0004\u0001\u0001\u0002\u0002\uffff\u0001\u0003\u0002\u0003\u0003\u0004\u0001\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0003\u0001\u0002\u0003\u0002\u0002\u0002".charAt(s);
                if (s2 == 0) {
                    n2 = Plants.getLeftMostFreeBoardPosition(-1, false, false);
                } else if (s == 29) {
                    n2 = Plants.getLeftMostFreeBoardPosition(-1, true, true);
                } else if (s == 30) {
                    n2 = Plants.getLeftMostFreeBoardPosition(-1, true, false);
                } else if (Zombies.m_nZombies > 0 || s == 0 || s == 1) {
                    boolean bl3 = false;
                    if (s == 0 || s == 1) {
                        bl3 = true;
                    }
                    int n5 = Zombies.getLeftMostZombie(bl3);
                    if (bl3 && n5 == 0) {
                        n2 = Plants.getLeftMostFreeBoardPosition(-1, true, true);
                    } else {
                        int n6 = Zombies.ZOMBIES[Zombies.ZOMBIE_MAX_VALS * n5 + Zombies.ZOMBIE_ROW];
                        n2 = Plants.getLeftMostFreeBoardPosition(n6, false, bl3);
                    }
                } else {
                    n2 = s2 == 4 ? Plants.getLeftMostFreeBoardPosition(-1, false, false) : Util.findNextSetBit(GModel.m_lBoardGridAsDirt ^ 0xFFFFFFFFFFFFFFFFL, 0);
                }
            } else {
                n2 = Util.findNextSetBit(GModel.m_lBoardGridAsDirt ^ 0xFFFFFFFFFFFFFFFFL, 0);
            }
        }
        return n2;
    }

    static void handleCursorSeedBankPortrait(int[] nArray, int n) {
        int n2;
        int n3;
        if (SeedBank.m_nSeeds == 0) {
            return;
        }
        int n4 = m_nCursorPos;
        if (GModel.m_bConveyorLevel) {
            n3 = SeedBank.m_nSeeds;
            n2 = 0;
        } else {
            n3 = 3;
            n2 = SeedBank.m_nSeeds / n3;
        }
        if (SeedBank.m_nSeeds % n3 != 0) {
            ++n2;
        }
        int n5 = m_nCursorPos / n3;
        int n6 = m_nCursorPos % n3;
        if ((n & nArray[3]) != 0) {
            boolean bl;
            ++n6;
            boolean bl2 = bl = n5 == n2;
            if (SeedBank.m_nSeeds % n3 != 0 && bl) {
                int n7 = SeedBank.m_nSeeds % n3;
                if (n6 > n7) {
                    n6 = 0;
                }
            } else if (n6 > n3 - 1) {
                n6 = 0;
            }
        } else if ((n & nArray[2]) != 0) {
            if (--n6 < 0) {
                n6 = n3 - 1;
            }
        } else if ((n & nArray[0]) != 0) {
            if (--n5 < 0) {
                Cursor.switchCursorType(0, GModel.getMaxValidBoardRow() * 9, false);
                return;
            }
        } else if ((n & nArray[1]) != 0 && ++n5 > n2 - 1) {
            Cursor.switchCursorType(0, GModel.getMinValidBoardRow() * 9, false);
            return;
        }
        m_nCursorPos = Math.min(n5 * n3 + n6, SeedBank.m_nSeeds - 1);
        if ((n & nArray[4]) != 0) {
            Cursor.handleFirePressedOnSeedBank();
        }
        if (m_nCursorPos != n4 && m_nCursorType == 1) {
            SeedBank.updatePositions(m_nCursorPos, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), true);
        }
    }

    static void handleCursorSeedBankLandscape(int[] nArray, int n) {
        if (SeedBank.m_nSeeds == 0) {
            return;
        }
        int n2 = m_nCursorPos;
        int n3 = 0;
        int n4 = SeedBank.m_nSeeds;
        int n5 = m_nCursorPos % n4;
        int n6 = m_nCursorPos / n4;
        if ((n & nArray[3]) != 0) {
            if (++n6 > 0) {
                int n7 = GModel.getMinValidBoardRow() * 9;
                Cursor.switchCursorType(0, n7, false);
                return;
            }
        } else if ((n & nArray[2]) != 0) {
            if (--n6 < 0) {
                int n8 = GModel.getMinValidBoardRow() * 9 + 9 - 1;
                Cursor.switchCursorType(0, n8, false);
                SeedBank.updatePositions(0, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), false);
                return;
            }
        } else if ((n & nArray[0]) != 0) {
            if (--n5 < 0) {
                n5 = n4 - 1;
            }
        } else if ((n & nArray[1]) != 0 && ++n5 > n4 - 1) {
            n5 = 0;
        }
        if (GModel.m_bConveyorLevel) {
            int n9 = n6 * n3 + n5;
            Cursor.getGridPosRect(n9, m_nCursorType);
            int n10 = GRID_POS[GRID_POS_Y];
            int n11 = GRID_POS[GRID_POS_H] >> 1;
            int n12 = 0;
            n12 = Layer.isLandscape(2) ? 2 : 244;
            int n13 = GFCanvas.getImageHeight(Conveyor.m_imgConveyorLeft);
            if (n10 + n11 > (n12 += GFCanvas.getImageHeight(Conveyor.m_imgConveyorTop)) + n13) {
                if ((n & nArray[0]) != 0) {
                    --n5;
                } else if ((n & nArray[1]) != 0) {
                    n5 = 0;
                }
            }
        }
        m_nCursorPos = n6 * n3 + n5;
        if ((n & nArray[4]) != 0) {
            Cursor.handleFirePressedOnSeedBank();
        }
        if (m_nCursorPos != n2 && m_nCursorType == 1) {
            SeedBank.updatePositions(m_nCursorPos, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), true);
        }
    }

    static void handleCursorBoardPortrait(int[] nArray, int n) {
        int n2;
        int n3 = 9;
        int n4 = GModel.m_nGameBoardRows;
        int n5 = m_nCursorPos / n3;
        int n6 = m_nCursorPos % n3;
        if ((n & nArray[3]) != 0) {
            n6 = Math.min(n6 + 1, n3 - 1);
        } else if ((n & nArray[2]) != 0) {
            n6 = Math.max(n6 - 1, 0);
        } else if ((n & nArray[0]) != 0) {
            int n7 = GModel.getMinValidBoardRow();
            if (--n5 < n7) {
                if (GModel.m_bShovelTutorialLevel) {
                    n5 = GModel.getMaxValidBoardRow();
                } else {
                    Cursor.switchCursorType(1, 0, false);
                    n6 = 0;
                    n5 = 0;
                }
            }
        } else if ((n & nArray[1]) != 0 && ++n5 > (n2 = GModel.getMaxValidBoardRow())) {
            if (GModel.m_bShovelTutorialLevel) {
                n5 = GModel.getMinValidBoardRow();
            } else {
                Cursor.switchCursorType(1, 0, false);
                n6 = 0;
                n5 = 0;
            }
        }
        m_nCursorPos = n5 * n3 + n6;
        if ((n & nArray[4]) != 0) {
            Cursor.handleFirePressedOnBoard();
        }
    }

    static void handleCursorBoardLandscape(int[] nArray, int n) {
        int n2;
        int n3 = 9;
        int n4 = GModel.m_nGameBoardRows;
        int n5 = m_nCursorPos / n3;
        int n6 = m_nCursorPos % n3;
        if ((n & nArray[3]) != 0) {
            if (++n6 > n3 - 1) {
                if (GModel.m_bShovelTutorialLevel) {
                    n6 = 0;
                } else {
                    Cursor.switchCursorType(1, 0, false);
                    n6 = 0;
                    n5 = 0;
                }
            }
        } else if ((n & nArray[2]) != 0) {
            if (--n6 < 0) {
                if (GModel.m_bShovelTutorialLevel) {
                    n6 = n3 - 1;
                } else {
                    Cursor.switchCursorType(1, 0, false);
                    n6 = 0;
                    n5 = 0;
                }
            }
        } else if ((n & nArray[0]) != 0) {
            int n7 = GModel.getMinValidBoardRow();
            if (--n5 < n7) {
                n5 = GModel.getMaxValidBoardRow();
            }
        } else if ((n & nArray[1]) != 0 && ++n5 > (n2 = GModel.getMaxValidBoardRow())) {
            n5 = GModel.getMinValidBoardRow();
        }
        m_nCursorPos = n5 * n3 + n6;
        if ((n & nArray[4]) != 0) {
            Cursor.handleFirePressedOnBoard();
        }
    }

    static void handleFirePressedOnBoard() {
        if (GModel.m_bShovelTutorialLevel) {
            return;
        }
        Plants.getPlantsOnLawn(m_nCursorPos);
        int n = Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_NORMAL_PLANT];
        int n2 = Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT];
        if (n == -1) {
            n = Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_UNDER_PLANT];
            n2 = Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_UNDER_PLANT];
        }
        if (SeedBank.m_nSelectedSeedTypeToPlant >= 0) {
            boolean bl = Cursor.bSeedAtCursorPlantable(m_nCursorPos, SeedBank.m_nSelectedSeedTypeToPlant, m_nCursorType);
            if (bl) {
                SeedBank.plantSeed(m_nCursorPos, SeedBank.m_nSelectedSeedTypeToPlant);
                SeedBank.m_nSelectedSeedTypeToPlant = -1;
            }
        } else if (n != -1) {
            if (GModel.m_bConveyorLevel) {
                if (SeedBank.m_nSeeds > 0) {
                    Cursor.switchCursorType(1, 0, false);
                }
            } else {
                int n3 = SeedBank.getSeedIndexFromType(n2);
                int n4 = SeedBank.SEEDS[n3 * SeedBank.SEED_MAX_VALS + SeedBank.SEED_BANK_POS];
                Cursor.switchCursorType(1, n4, false);
            }
        } else if (GModel.m_bConveyorLevel) {
            if (SeedBank.m_nSeeds > 0) {
                Cursor.switchCursorType(1, 0, false);
            }
        } else {
            Cursor.switchCursorType(1, 0, false);
        }
    }

    static boolean handleFirePressedOnSeedBank() {
        boolean bl = Cursor.bSeedAtCursorPlantable(m_nCursorPos, SeedBank.m_nSelectedSeedTypeToPlant, m_nCursorType);
        if (bl) {
            SeedBank.selectSeed(m_nCursorPos);
        }
        return bl;
    }

    static void handleCursorSeedBankShovel(int[] nArray, int n) {
        if ((n & nArray[3]) != 0) {
            Cursor.switchCursorType(0, 0, false);
        } else if ((n & nArray[2]) != 0) {
            Cursor.switchCursorType(0, 0, false);
        } else if ((n & nArray[0]) != 0) {
            int n2 = 9 * (GModel.m_nGameBoardRows - 1);
            Cursor.switchCursorType(0, n2, false);
        } else if ((n & nArray[1]) != 0) {
            Cursor.switchCursorType(0, 0, false);
        }
        if ((n & nArray[4]) != 0) {
            Cursor.switchCursorType(3, 0, false);
        }
    }

    static void handleCursorBoardShovelLandscape(int[] nArray, int n) {
        int n2;
        int n3 = 9;
        int n4 = GModel.m_nGameBoardRows;
        int n5 = m_nCursorPos / n3;
        int n6 = m_nCursorPos % n3;
        if ((n & nArray[3]) != 0) {
            if (++n6 > n3 - 1) {
                if (GModel.m_bShovelTutorialLevel) {
                    n6 = 0;
                } else {
                    Cursor.switchCursorType(1, 0, false);
                    n6 = 0;
                    n5 = 0;
                }
            }
        } else if ((n & nArray[2]) != 0) {
            if (--n6 < 0) {
                if (GModel.m_bShovelTutorialLevel) {
                    n6 = n3 - 1;
                } else {
                    Cursor.switchCursorType(1, 0, false);
                    n6 = 0;
                    n5 = 0;
                }
            }
        } else if ((n & nArray[0]) != 0) {
            n2 = GModel.getMinValidBoardRow();
            if (--n5 < n2) {
                n5 = GModel.getMaxValidBoardRow();
            }
        } else if ((n & nArray[1]) != 0 && ++n5 > (n2 = GModel.getMaxValidBoardRow())) {
            n5 = GModel.getMinValidBoardRow();
        }
        m_nCursorPos = n5 * n3 + n6;
        if ((n & nArray[4]) != 0) {
            n2 = Plants.getTopPlant(m_nCursorPos, 5);
            if (n2 != -1) {
                Plants.killPlant(n2);
                Cursor.switchCursorType(0, m_nCursorPos, false);
                if (GModel.m_bShovelTutorialLevel) {
                    if (GFHint.m_nCurrentHint == 11) {
                        Hints.clearHint(10, true);
                    }
                    if (!GFHint.bHintDisplayed(12)) {
                        Hints.flagHint(12);
                    }
                }
            } else if (!GModel.m_bShovelTutorialLevel) {
                Cursor.switchCursorType(1, 0, false);
            }
        }
    }

    static void handleCursorBoardShovelPortrait(int[] nArray, int n) {
        int n2;
        int n3 = 9;
        int n4 = GModel.m_nGameBoardRows;
        int n5 = m_nCursorPos / n3;
        int n6 = m_nCursorPos % n3;
        if ((n & nArray[3]) != 0) {
            n6 = Math.min(n6 + 1, n3 - 1);
        } else if ((n & nArray[2]) != 0) {
            n6 = Math.max(n6 - 1, 0);
        } else if ((n & nArray[0]) != 0) {
            n2 = GModel.getMinValidBoardRow();
            if (--n5 < n2) {
                n5 = GModel.getMaxValidBoardRow();
            }
        } else if ((n & nArray[1]) != 0 && ++n5 > (n2 = GModel.getMaxValidBoardRow())) {
            n5 = GModel.getMinValidBoardRow();
        }
        m_nCursorPos = n5 * n3 + n6;
        if ((n & nArray[4]) != 0) {
            n2 = Plants.getPlantIndexAtPos(m_nCursorPos);
            if (n2 != -1) {
                Plants.killPlant(n2);
                Cursor.switchCursorType(0, m_nCursorPos, false);
                if (GFHint.m_nCurrentHint == 11) {
                    Hints.clearHint(10, true);
                }
                if (!GFHint.bHintDisplayed(12)) {
                    Hints.flagHint(12);
                }
            } else if (!GModel.m_bShovelTutorialLevel) {
                Cursor.switchCursorType(1, 0, false);
            }
        }
    }

    static void getGridRowPos(int n, int n2) {
        Cursor.getGridPosRect(n * 9, n2);
    }

    static void getGridColPos(int n, int n2) {
        Cursor.getGridPosRect(n, n2);
    }

    static void getGridPosRect(int n, int n2) {
        int n3 = n / 9;
        int n4 = n % 9;
        int n5 = Cursor.getCursorGameW();
        int n6 = Cursor.getCursorGameH();
        if (n2 == 2) {
            n4 = 0;
            n3 = 0;
        } else if (Layer.isLandscape(2) && n2 == 1) {
            n3 = n % 9;
            n4 = n / 9;
        }
        if (n2 == 0 || n2 == 3) {
            if (GModel.GRID_SQUARE_TYPE[n] == 3) {
                Cursor.GRID_POS[Cursor.GRID_POS_W] = n5;
                Cursor.GRID_POS[Cursor.GRID_POS_H] = n6;
                Cursor.GRID_POS[Cursor.GRID_POS_X] = 0 + n4 * n5 + GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5));
                Cursor.GRID_POS[Cursor.GRID_POS_Y] = -2 + n3 * n6 + GModel.getBoardOffsetY(Layer.getLayerProperty(2, 5));
            } else {
                Cursor.GRID_POS[Cursor.GRID_POS_W] = n5;
                Cursor.GRID_POS[Cursor.GRID_POS_H] = n6;
                int n7 = 0;
                int n8 = 0;
                if (GameController.m_nLevel >= 40) {
                    n7 = -4;
                    n8 = 7 - (n4 << 1);
                }
                Cursor.GRID_POS[Cursor.GRID_POS_X] = (short)n7 + n4 * n5 + GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5));
                Cursor.GRID_POS[Cursor.GRID_POS_Y] = (short)n8 + n3 * n6 + GModel.getBoardOffsetY(Layer.getLayerProperty(2, 5));
            }
        } else if (n2 == 1) {
            if (Layer.isLandscape(2)) {
                Cursor.GRID_POS[Cursor.GRID_POS_W] = 45;
                Cursor.GRID_POS[Cursor.GRID_POS_H] = 32;
            } else {
                Cursor.GRID_POS[Cursor.GRID_POS_W] = 47;
                Cursor.GRID_POS[Cursor.GRID_POS_H] = 35;
            }
            if (SeedBank.getSeedCoords(n)) {
                Cursor.GRID_POS[Cursor.GRID_POS_X] = SeedBank.m_nSeedTempPosX;
                Cursor.GRID_POS[Cursor.GRID_POS_Y] = SeedBank.m_nSeedTempPosY;
            } else if (Layer.isLandscape(2)) {
                Cursor.GRID_POS[Cursor.GRID_POS_X] = 3 + n4 * 47;
                Cursor.GRID_POS[Cursor.GRID_POS_Y] = 34 + n3 * 35;
            } else {
                int n9;
                int n10 = SeedPicker.m_nSeedSelected;
                int n11 = GFCanvas.getImageWidth(SeedBank.SEED_IMGS_SML[n10]);
                int n12 = (Layer.getLayerProperty(2, 3) - 3 * n11) / 2;
                Cursor.GRID_POS[Cursor.GRID_POS_X] = n9 = n12 + n4 * (n11 + 0);
                Cursor.GRID_POS[Cursor.GRID_POS_Y] = 244 + n3 * 35;
            }
        } else if (n2 == 2) {
            Cursor.GRID_POS[Cursor.GRID_POS_W] = 46;
            Cursor.GRID_POS[Cursor.GRID_POS_H] = 20;
            if (Layer.isLandscape(2)) {
                Cursor.GRID_POS[Cursor.GRID_POS_X] = 120 + n4 * 46;
                Cursor.GRID_POS[Cursor.GRID_POS_Y] = 1 + n3 * 20;
            } else {
                Cursor.GRID_POS[Cursor.GRID_POS_X] = 69 + n4 * 46;
                Cursor.GRID_POS[Cursor.GRID_POS_Y] = 1 + n3 * 20;
            }
        }
    }

    static boolean bSeedAtCursorPlantable(int n, int n2, int n3) {
        if (n3 == 1) {
            if (n >= 0) {
                if (GModel.m_bConveyorLevel) {
                    return true;
                }
                if (n2 >= 0) {
                    return ScoreController.m_nSun >= (short)"\u0000\u00192d2\u00c8\u00af\u0096\u0019\u0096\u01452}d\u00af}dd\u012c}}\u0000\u0019KK\u0019KK}\u0019\u0019".charAt(n2) && SeedBank.bSeedRecharged(n);
                }
                return false;
            }
            return false;
        }
        int n4 = -1;
        if (n2 != -1) {
            n4 = (short)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e".charAt(n2);
        }
        Plants.getPlantsOnLawn(n);
        int n5 = GridItem.getGridItemTypeAtPos(n);
        int n6 = n / 9;
        boolean bl = false;
        for (int i = 0; i < Plants.PLANT_POS_TYPES.length; ++i) {
            if (Plants.PLANT_POS_TYPES[i] == -1) continue;
            bl = true;
        }
        if (n2 < 0) {
            return false;
        }
        if (n5 == 2) {
            return false;
        }
        if (n4 == 24) {
            return n5 == 1 && !bl;
        }
        if (n5 == 1) {
            return false;
        }
        if (n4 == 30) {
            return !bl;
        }
        if (n4 == 29 || n4 == 0 || n4 == 1) {
            return GModel.PLANT_ROW[n6] == 3 && !bl;
        }
        if (GModel.PLANT_ROW[n6] == 3) {
            return Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_UNDER_PLANT] == 29 && Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] == -1 && n4 != 13 && n4 != 8;
        }
        if (GModel.PLANT_ROW[n6] == 4) {
            return Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_UNDER_PLANT] == 30 && Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] == -1;
        }
        return !bl;
    }

    static void startZoomToDest(int n, int n2, int n3, int n4, int n5) {
        Cursor.CURSOR_MOVE[Cursor.CURSOR_STATE] = n4 == 1 ? 1 : 1;
        Cursor.getGridPosRect(n, n3);
        int n6 = GRID_POS[GRID_POS_X] * 4096;
        int n7 = GRID_POS[GRID_POS_Y] * 4096;
        Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_X] = n6;
        Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_Y] = n7;
        Cursor.getGridPosRect(n2, n4);
        int n8 = GRID_POS[GRID_POS_X] * 4096;
        int n9 = GRID_POS[GRID_POS_Y] * 4096;
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_DEST_X] = n8;
        Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_DEST_Y] = n9;
        int n12 = Vector.length(n10, n11);
        Vector.normalise(n10, n11);
        n5 = Math.max(Math.abs(FP.fpDiv(n12, 20480)), 16384);
        Vector.scale(Vector.vrx, Vector.vry, n5);
        Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_VX] = Vector.vrx;
        Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_VY] = Vector.vry;
    }

    static void updateCursorZoomToDest() {
        if (CURSOR_MOVE[CURSOR_STATE] == 1) {
            int n = GModel.FP_98_PERCENT;
            int n2 = CURSOR_MOVE[CURSOR_FP_X];
            int n3 = CURSOR_MOVE[CURSOR_FP_Y];
            int n4 = CURSOR_MOVE[CURSOR_FP_VX];
            int n5 = CURSOR_MOVE[CURSOR_FP_VY];
            int n6 = CURSOR_MOVE[CURSOR_FP_DEST_X];
            int n7 = CURSOR_MOVE[CURSOR_FP_DEST_Y];
            if (n4 > 0) {
                n2 = Math.min(n2 + n4, n6);
                if (n4 > n) {
                    n4 = Math.max(FP.fpMul(n4, n), 8192);
                }
            } else {
                n2 = Math.max(n2 + n4, n6);
                if (n4 < n) {
                    n4 = Math.min(FP.fpMul(n4, n), -8192);
                }
            }
            if (n5 > 0) {
                n3 = Math.min(n3 + n5, n7);
                if (n5 > n) {
                    n5 = Math.max(FP.fpMul(n5, n), 8192);
                }
            } else {
                n3 = Math.max(n3 + n5, n7);
                if (n5 < n) {
                    n5 = Math.min(FP.fpMul(n5, n), -8192);
                }
            }
            Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_X] = n2;
            Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_Y] = n3;
            Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_VX] = n4;
            Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_VY] = n5;
            Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_DEST_X] = n6;
            Cursor.CURSOR_MOVE[Cursor.CURSOR_FP_DEST_Y] = n7;
            if (n2 == n6 && n3 == n7) {
                Cursor.CURSOR_MOVE[Cursor.CURSOR_STATE] = 0;
            }
        }
    }

    static int getCursorGameW() {
        if (GModel.m_nBackgroundImgID == 8 || GModel.m_nBackgroundImgID == 104) {
            return 29;
        }
        if (GModel.m_nBackgroundImgID == 39) {
            return 29;
        }
        return 29;
    }

    static int getCursorGameH() {
        if (GModel.m_nBackgroundImgID == 8 || GModel.m_nBackgroundImgID == 104) {
            return 32;
        }
        if (GModel.m_nBackgroundImgID == 39) {
            return 37;
        }
        return 37;
    }

    static {
        CURSOR_POS = 0;
        CURSOR_TYPE = CURSOR_POS + 1;
        CURSOR_FP_X = CURSOR_TYPE + 1;
        CURSOR_FP_Y = CURSOR_FP_X + 1;
        CURSOR_FP_VX = CURSOR_FP_Y + 1;
        CURSOR_FP_VY = CURSOR_FP_VX + 1;
        CURSOR_FP_DEST_X = CURSOR_FP_VY + 1;
        CURSOR_FP_DEST_Y = CURSOR_FP_DEST_X + 1;
        CURSOR_STATE = CURSOR_FP_DEST_Y + 1;
        CURSOR_MAX_VALS = CURSOR_STATE + 1;
        CURSOR_MOVE = new int[CURSOR_MAX_VALS];
        GRID_POS = new int[4];
        GRID_POS_X = 0;
        GRID_POS_Y = 1;
        GRID_POS_W = 2;
        GRID_POS_H = 3;
    }
}

