/*
 * Decompiled with CFR 0.152.
 */
public class ZombieController
implements GameConstants,
Constants {
    static final int[][] mZombiesInWave = new int[50][50];
    static int m_nZombiesInWaveCount;
    static int m_nZombieHealthToNextWave;
    static int m_nZombieHealthWaveStart;
    static int m_nZombieCountDown;
    static int m_nZombieCountDownStart;
    static int m_nHugeWaveCountDown;
    static int m_nCurrentWave;
    static int m_nNumWaves;
    static int m_nSpawnedWaves;
    static int m_nRiseFromGraveCounter;
    static int m_nProgressMeterCurrWidth;
    static final String[] ZOMBIE_ALLOWED_LEVELS;
    static final int[] m_ZombieWeights;
    static final int[] m_ZombieTypes;
    static final int[] m_Weights;
    static final int[] m_WeightTypes;
    static int ZOMBIE_HEALTH_WAVE_RAND_MOD_MIN;
    static int ZOMBIE_HEALTH_WAVE_RAND_MOD_MAX;

    static void init() {
        ZOMBIE_HEALTH_WAVE_RAND_MOD_MIN = 2048;
        ZOMBIE_HEALTH_WAVE_RAND_MOD_MAX = FP.fpDiv(266240, 409600);
    }

    static void resetVarsNewLevel(int n) {
        ZombieController.initZombieWaves(n);
    }

    static void initZombieWaves(int n) {
        for (int i = 0; i < mZombiesInWave.length; ++i) {
            for (int j = 0; j < mZombiesInWave[i].length; ++j) {
                Util.resetArray(mZombiesInWave[i], -1);
            }
        }
        ZombieController.pickZombieWaves(n);
        m_nCurrentWave = 0;
        m_nSpawnedWaves = 0;
        m_nZombiesInWaveCount = 0;
        m_nZombieCountDown = GModel.m_bConveyorLevel ? 18 : 540;
        m_nZombieHealthToNextWave = -1;
        m_nZombieHealthWaveStart = 0;
        m_nHugeWaveCountDown = 0;
        m_nProgressMeterCurrWidth = 0;
    }

    static int getTotalZombieHealthInWave(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 100 && n3 < Zombies.m_nZombies; ++i) {
            if (!Zombies.isZombieAtIndex(i)) continue;
            n2 = Zombies.ZOMBIE_MAX_VALS * i;
            n4 = Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_WAVE];
            if (n4 == n && !Zombies.isFlagSet(12, i)) {
                n5 += Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_HEALTH_BODY] + Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_HEALTH_HELM] + Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_HEALTH_SHIELD];
                if (Zombies.bIsFlying(i)) {
                    n5 += Zombies.ZOMBIES[n2 + Zombies.ZOMBIE_PARAM_1];
                }
            }
            ++n3;
        }
        return n5;
    }

    static void pickZombieWaves(int n) {
        n = Util.clampInt(n, 0, "\u0004\u0006\b\n\b\n\u0014\n\u0014\u0014\n\u0014\n\u0014\n\n\u0014\n\u0014\u0014\n\u0014\u0014\u001e\u0014\u0014\u001e\u0014\u001e\u001e\n\u0014\n\u0014\u0014\n\u0014\n\u0014\u0014\n\u0014\u0014\u001e\u0014\u0014\u001e\u0014\u001e\u001e".length() - 1);
        m_nNumWaves = "\u0004\u0006\b\n\b\n\u0014\n\u0014\u0014\n\u0014\n\u0014\n\n\u0014\n\u0014\u0014\n\u0014\u0014\u001e\u0014\u0014\u001e\u0014\u001e\u001e\n\u0014\n\u0014\u0014\n\u0014\n\u0014\u0014\n\u0014\u0014\u001e\u0014\u0014\u001e\u0014\u001e\u001e".charAt(n);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < m_nNumWaves; ++i) {
            m_nZombiesInWaveCount = 0;
            boolean bl = ZombieController.isFlagWave(i);
            boolean bl2 = i == m_nNumWaves - 1;
            n2 = i == 0 ? 1 : i / 3 + 1;
            if (bl) {
                int n5 = Math.min(n2, 8);
                n2 = FP.fpMul(n2 * 4096, 10240);
                n2 = FP.toInt(n2);
                for (int j = 0; j < n5; ++j) {
                    ZombieController.putZombieInWave(0, i);
                    n2 -= "\u0001\u0001\u0002\u0004\u0007\u0004\u0002\u0005\u0003\u0002\u0001\n\u0004\u0005\u0004\u0004\u0002\u0001\u0003\u0003\n\n\n".charAt(0);
                }
                ZombieController.putZombieInWave(1, i);
            }
            if (i == 0 && n == 49) {
                n4 = 20;
            }
            while (n2 > 0 && n3 < 50) {
                if (n4 != 20) {
                    n4 = ZombieController.pickZombieType(n2, i, n);
                }
                if (n4 == 20 && n == 49 && i != 0) {
                    n4 = 0;
                }
                if (ZombieController.putZombieInWave(n4, i)) {
                    n2 -= "\u0001\u0001\u0002\u0004\u0007\u0004\u0002\u0005\u0003\u0002\u0001\n\u0004\u0005\u0004\u0004\u0002\u0001\u0003\u0003\n\n\n".charAt(n4);
                }
                n4 = -1;
            }
            if (n2 <= 0) continue;
        }
    }

    static int getNumWavesPerFlag() {
        if (m_nNumWaves < 10) {
            return m_nNumWaves;
        }
        return 10;
    }

    static boolean isFlagWave(int n) {
        if (GameController.m_nLevel == 0) {
            return false;
        }
        int n2 = ZombieController.getNumWavesPerFlag();
        return n % n2 == n2 - 1;
    }

    static int pickZombieType(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < 23; ++i) {
            if (!ZombieController.isZombieAllowed(i, n, n3, n2)) continue;
            ZombieController.m_ZombieTypes[n4] = i;
            ZombieController.m_ZombieWeights[n4] = "\u0fa0\u0000\u0fa0\u0dac\u07d0\u0bb8\u07d0\u1388\u03e8\u03e8\u0000\u05dc\u03e8\u05dc\u03e8\u03e8\u07d0\u0fa0\u07d0\u07d0\u0000\u05dc\u05dc".charAt(i);
            ++n4;
        }
        if (n4 > 0) {
            return ZombieController.selectWeightedItem(m_ZombieTypes, m_ZombieWeights, n4);
        }
        return -1;
    }

    static boolean isZombieAllowed(int n, int n2, int n3, int n4) {
        if ("\u0001\u0001\u0001\u0005\u0005\u0001\u0005\u0001\n\u0001\u0001\u000f\n\n\n\n\n\u0001\n\n\u0000\u000f\u000f".charAt(n) > n4 + 1) {
            return false;
        }
        if (n2 < "\u0001\u0001\u0002\u0004\u0007\u0004\u0002\u0005\u0003\u0002\u0001\n\u0004\u0005\u0004\u0004\u0002\u0001\u0003\u0003\n\n\n".charAt(n)) {
            return false;
        }
        return (short)ZOMBIE_ALLOWED_LEVELS[n].charAt(n3) > 0;
    }

    static int selectWeightedItem(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 += nArray2[n2];
        }
        if (n3 == 0) {
            return -1;
        }
        n2 = Util.GetRandom(n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (n2 >= (n4 += nArray2[i])) continue;
            return nArray[i];
        }
        return -1;
    }

    static boolean putZombieInWave(int n, int n2) {
        if (n2 >= 50 || m_nZombiesInWaveCount >= 50) {
            return false;
        }
        ZombieController.mZombiesInWave[n2][ZombieController.m_nZombiesInWaveCount] = n;
        ++m_nZombiesInWaveCount;
        return true;
    }

    static void updateZombieSpawning() {
        int n;
        if (m_nHugeWaveCountDown > 0) {
            if (--m_nHugeWaveCountDown == 0) {
                m_nZombieCountDown = 1;
            } else {
                return;
            }
        }
        if (GameController.m_nGameMode == 0 && GameController.m_nLevel == 0 && !GFHint.bHintDisplayed(6)) {
            return;
        }
        if (m_nRiseFromGraveCounter > 0 && --m_nRiseFromGraveCounter == 0) {
            ZombieController.spawnZombiesFromGraves();
        }
        if (m_nCurrentWave == m_nNumWaves) {
            return;
        }
        int n2 = m_nZombieCountDownStart - --m_nZombieCountDown;
        boolean bl = false;
        if (m_nZombieCountDown > 54 && n2 > 108 && (n = ZombieController.getTotalZombieHealthInWave(m_nCurrentWave - 1)) <= m_nZombieHealthToNextWave) {
            m_nZombieCountDown = 54;
            bl = true;
        }
        if (m_nZombieCountDown == 90 || bl) {
            n = ZombieController.isFlagWave(m_nCurrentWave);
            boolean bl2 = m_nCurrentWave == m_nNumWaves - 1;
            int n3 = -1;
            if (n != 0) {
                int n4;
                String string = Text.GAME_STRINGS[89];
                int n5 = GameConstants.IN_GAME_WARNING_POP_UP[0];
                int n6 = GameConstants.IN_GAME_WARNING_POP_UP[1];
                int n7 = Layer.getXCenter(2);
                if (bl2) {
                    n3 = 89;
                    string = Text.GAME_STRINGS[n3];
                } else {
                    n3 = 88;
                    string = Text.GAME_STRINGS[n3];
                }
                char[] cArray = string.toCharArray();
                int n8 = 0;
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    n8 += GFFont.getCharWidth(cArray[n4], 8);
                }
                n4 = GFCanvas.getImageWidth("\u01c0\u0234\u000e\u019b\u019e\u0111\u01c1\u008a\u020c\u0124\u0211\u0179\u00d9\u00b7\u012a\u00e5\u0199l\u00cf\u01d9\u0220\u00b8\u00af\u01d1\u01dfN\u013e\u0196;\u0003\u015e".charAt(SeedPicker.m_nSeedSelected));
                n5 = n4 + 2 + 3 + 4 + 30;
                n6 = Layer.getYCenter(2);
                GFBoardTexts.addText(n5, Layer.getYCenter(2), string, -1, 0, 7);
                m_nHugeWaveCountDown = 126;
                GFTextArea.createTextArea(Layer.getLayerProperty(2, 3) - (n4 + 2), GFFont.getFontHeight(8) << 3, n3, 8, 1, 1);
                GFTextArea.setTextAreaX(n5);
                GFTextArea.setTextAreaY(n6);
            }
        }
        if (m_nZombieCountDown > 0) {
            return;
        }
        ZombieController.spawnZombieWave();
        m_nZombieHealthWaveStart = ZombieController.getTotalZombieHealthInWave(m_nCurrentWave - 1);
        n = FP.getRandFPValueAsFP(ZOMBIE_HEALTH_WAVE_RAND_MOD_MIN, ZOMBIE_HEALTH_WAVE_RAND_MOD_MAX);
        m_nZombieHealthToNextWave = FP.toInt(FP.fpMul(n, m_nZombieHealthWaveStart * 4096));
        m_nZombieCountDownStart = m_nZombieCountDown = 630 + Util.GetRandom(180);
    }

    static void spawnZombieWave() {
        if (m_nCurrentWave >= 0 && m_nCurrentWave < 50 && m_nCurrentWave < m_nNumWaves) {
            int n = 0;
            for (int i = 0; i < 50 && (n = mZombiesInWave[m_nCurrentWave][i]) != -1; ++i) {
                ZombieController.spawnZombie(n, m_nCurrentWave);
            }
            if (m_nCurrentWave == m_nNumWaves - 1) {
                m_nRiseFromGraveCounter = 36;
            }
            ++m_nCurrentWave;
            ++m_nSpawnedWaves;
        }
    }

    static void spawnZombie(int n, int n2) {
        int n3 = ZombieController.pickRowForNewZombie(n);
        Zombies.addZombie(n, n3, m_nCurrentWave);
    }

    static int pickRowForNewZombie(int n) {
        Util.resetArray(m_Weights, 0);
        Util.resetArray(m_WeightTypes, 0);
        for (int i = 0; i < GModel.m_nGameBoardRows; ++i) {
            if (!ZombieController.bRowCanHaveZombieType(n, i)) continue;
            ZombieController.m_Weights[i] = 1;
            ZombieController.m_WeightTypes[i] = i;
        }
        return ZombieController.selectWeightedItem(m_WeightTypes, m_Weights, GModel.m_nGameBoardRows);
    }

    static boolean bRowCanHaveZombies(int n) {
        if (n < 0 || n >= GModel.m_nGameBoardRows) {
            return false;
        }
        return GModel.PLANT_ROW[n] != 1;
    }

    static boolean bRowCanHaveZombieType(int n, int n2) {
        if (!ZombieController.bRowCanHaveZombies(n2)) {
            return false;
        }
        if (GModel.PLANT_ROW[n2] == 3 && !Zombies.bZombieTypeCanGoInPool(n)) {
            return false;
        }
        if (GModel.PLANT_ROW[n2] == 3 && m_nCurrentWave < 5 && !Zombies.bIsZombieTypePoolOnly(n)) {
            return false;
        }
        if (GModel.PLANT_ROW[n2] != 3 && Zombies.bIsZombieTypePoolOnly(n)) {
            return false;
        }
        if (n == 7) {
            if (GModel.m_bPoolLevel) {
                return false;
            }
            if (!ZombieController.bRowCanHaveZombies(n2 - 1) || !ZombieController.bRowCanHaveZombies(n2 + 1)) {
                return false;
            }
        }
        return true;
    }

    static void updateZombossHealthMeter() {
        int n = HUDModel.m_nProgressBarFillTotalW;
        int n2 = 0;
        int n3 = Zombies.ZOMBIE_MAX_VALS * n2;
        int n4 = Math.max((short)"\u010e\u010e\u010e\u010e\u010e\u010e\u01f4\u01f4\u01f4\u010e\u010e\u0bb8\u01f4\u0352\u01f4\u010e\u010e\u010e\u010e\u00c8\u2710\u7530\u7530".charAt(20), 0);
        int n5 = Math.max(Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_HEALTH_BODY], 1);
        int n6 = n5 * 100 / n4;
        if (n6 < 100) {
            m_nProgressMeterCurrWidth = n - n * n6 / 100;
        }
        if (m_nProgressMeterCurrWidth > 0 && !HUDModel.m_bProgressBarVisible) {
            HUDModel.setProgressBarVisible();
        } else if (m_nProgressMeterCurrWidth <= 0) {
            HUDModel.m_bProgressBarVisible = false;
        }
    }

    static void updateProgressMeter() {
        int n;
        int n2;
        if (m_nCurrentWave == 0) {
            return;
        }
        int n3 = HUDModel.m_nProgressBarFillTotalW;
        int n4 = 3;
        int n5 = m_nNumWaves - 1;
        int n6 = n3 / n5;
        int n7 = (m_nCurrentWave - 1) * n3 / n5;
        int n8 = m_nCurrentWave * n3 / n5;
        int n9 = ZombieController.getNumWavesPerFlag();
        int n10 = m_nZombieCountDownStart == 0 ? 4096 : FP.fpDiv((m_nZombieCountDownStart - m_nZombieCountDown) * 4096, m_nZombieCountDownStart * 4096);
        if (m_nZombieHealthToNextWave != -1) {
            n2 = ZombieController.getTotalZombieHealthInWave(m_nCurrentWave - 1);
            n = Math.max(m_nZombieHealthWaveStart - m_nZombieHealthToNextWave, 1);
            int n11 = FP.fpDiv((n - n2 + m_nZombieHealthToNextWave) * 4096, n * 4096);
            if (n11 > n10) {
                n10 = n11;
            }
        }
        n10 = Math.min(n10, 4096);
        n2 = n7 + FP.toInt(FP.fpMul((n8 - n7) * 4096, n10));
        n = (n2 = Util.clampInt(n2, 1, n3)) - m_nProgressMeterCurrWidth;
        if (n > n6) {
            ++m_nProgressMeterCurrWidth;
        } else if (n > 0 && GameController.m_nGameStateFrame % 10 == 0) {
            ++m_nProgressMeterCurrWidth;
        }
        if (m_nProgressMeterCurrWidth > 0 && !HUDModel.m_bProgressBarVisible) {
            HUDModel.setProgressBarVisible();
        }
    }

    static boolean progressMeterHasFlags() {
        return GameController.m_nLevel != 0 && GameController.m_nLevel < 49;
    }

    static boolean bAllZombiesDead() {
        return m_nCurrentWave == m_nNumWaves && Zombies.m_nZombies <= 0;
    }

    static void spawnZombiesFromGraves() {
        if (GModel.m_bPoolLevel) {
            ZombieController.spawnZombiesFromPool();
            return;
        }
        int n = GridItem.getGridItemTypeCount(1);
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        for (int i = 0; i < GridItem.MAX_NUM_GRID_ITEMS && n2 < GridItem.m_nGridItems; ++i) {
            if (!GridItem.isGridItemAtIndex(i)) continue;
            n3 = i * GridItem.GRID_ITEM_MAX_VALS;
            if (GridItem.GRID_ITEMS[n3 + GridItem.GRID_ITEM_TYPE] == 1) {
                n6 = GridItem.GRID_ITEMS[n3 + GridItem.GRID_ITEM_POS] / 9;
                n4 = ZombieController.pickGraveRisingZombieType(n);
                n5 = Zombies.addZombie(n4, n6, m_nCurrentWave);
                if (n5 != -1) {
                    Zombies.riseFromGrave(n5, GridItem.GRID_ITEMS[n3 + GridItem.GRID_ITEM_POS]);
                    n -= (short)"\u0001\u0001\u0002\u0004\u0007\u0004\u0002\u0005\u0003\u0002\u0001\n\u0004\u0005\u0004\u0004\u0002\u0001\u0003\u0003\n\n\n".charAt(n4);
                    n = Math.max(1, n);
                }
            }
            ++n2;
        }
    }

    static int pickGraveRisingZombieType(int n) {
        int n2 = 0;
        ZombieController.m_ZombieTypes[n2] = 0;
        ZombieController.m_ZombieWeights[n2] = "\u0fa0\u0000\u0fa0\u0dac\u07d0\u0bb8\u07d0\u1388\u03e8\u03e8\u0000\u05dc\u03e8\u05dc\u03e8\u03e8\u07d0\u0fa0\u07d0\u07d0\u0000\u05dc\u05dc".charAt(0);
        ZombieController.m_ZombieTypes[++n2] = 2;
        ZombieController.m_ZombieWeights[n2] = "\u0fa0\u0000\u0fa0\u0dac\u07d0\u0bb8\u07d0\u1388\u03e8\u03e8\u0000\u05dc\u03e8\u05dc\u03e8\u03e8\u07d0\u0fa0\u07d0\u07d0\u0000\u05dc\u05dc".charAt(2);
        ++n2;
        if (GModel.m_nBackgroundImgID != 553) {
            ZombieController.m_ZombieTypes[n2] = 5;
            ZombieController.m_ZombieWeights[n2] = "\u0fa0\u0000\u0fa0\u0dac\u07d0\u0bb8\u07d0\u1388\u03e8\u03e8\u0000\u05dc\u03e8\u05dc\u03e8\u03e8\u07d0\u0fa0\u07d0\u07d0\u0000\u05dc\u05dc".charAt(5);
            ++n2;
        }
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            n3 = m_ZombieTypes[i];
            ZombieController.m_ZombieWeights[i] = n3 != 0 && !ZombieController.isZombieAllowed(n3, n, GameController.m_nLevel, m_nCurrentWave) ? 0 : (int)"\u0fa0\u0000\u0fa0\u0dac\u07d0\u0bb8\u07d0\u1388\u03e8\u03e8\u0000\u05dc\u03e8\u05dc\u03e8\u03e8\u07d0\u0fa0\u07d0\u07d0\u0000\u05dc\u05dc".charAt(n3);
        }
        return ZombieController.selectWeightedItem(m_ZombieTypes, m_ZombieWeights, n2);
    }

    static void spawnZombiesFromPool() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (GModel.m_nIceTrapCounter > 0) {
            return;
        }
        if (GameController.m_nLevel == 20 || GameController.m_nLevel == 21 || GameController.m_nLevel == 30 || GameController.m_nLevel == 31) {
            n5 = 2;
            n4 = 3;
        } else if (GameController.m_nLevel == 22 || GameController.m_nLevel == 23 || GameController.m_nLevel == 24 || GameController.m_nLevel == 32 || GameController.m_nLevel == 33 || GameController.m_nLevel == 34) {
            n5 = 3;
            n4 = 5;
        } else {
            n5 = 3;
            n4 = 7;
        }
        int n6 = 5;
        int n7 = 2;
        int n8 = 2;
        for (n3 = 0; n3 < LevelIntro.WeightedGridArray.length; ++n3) {
            Util.resetArray(LevelIntro.WeightedGridArray[n3], 0);
        }
        n3 = 0;
        for (n2 = n6; n2 < 9; ++n2) {
            n = n7;
            while (n < n7 + n8) {
                LevelIntro.WeightedGridArray[n3][0] = n2;
                LevelIntro.WeightedGridArray[n3][1] = n++;
                LevelIntro.WeightedGridArray[n3][2] = 10000;
                ++n3;
            }
        }
        if (n5 > n3) {
            n5 = n3;
        }
        if (n3 == 0) {
            return;
        }
        for (int i = 0; i < n5; ++i) {
            int n9;
            int n10 = LevelIntro.pickFromWeightedGridArray(LevelIntro.WeightedGridArray, n5);
            LevelIntro.WeightedGridArray[n10][2] = 0;
            n = ZombieController.pickGraveRisingZombieType(n4);
            n2 = Zombies.addZombie(n, n9 = LevelIntro.WeightedGridArray[n10][1], m_nCurrentWave);
            if (n2 == -1) continue;
            int n11 = LevelIntro.WeightedGridArray[n10][1] * 9 + LevelIntro.WeightedGridArray[n10][0];
            Zombies.riseFromGrave(n2, n11);
            n4 = Math.max(n4 - (short)"\u0001\u0001\u0002\u0004\u0007\u0004\u0002\u0005\u0003\u0002\u0001\n\u0004\u0005\u0004\u0004\u0002\u0001\u0003\u0003\n\n\n".charAt(n), 1);
        }
    }

    static {
        ZOMBIE_ALLOWED_LEVELS = new String[]{"\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001", "\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0000", "\u0000\u0000\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0000\u0000\u0001\u0000\u0001\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0001\u0000\u0000\u0001\u0000\u0001\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0001\u0001\u0000\u0001\u0000\u0000\u0001\u0000\u0000\u0000\u0001\u0001", "\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0000\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0001", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0001\u0000\u0001\u0000\u0001\u0001", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0001\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0001", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0000\u0000\u0000\u0000\u0001\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u0001\u0000\u0001\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000"};
        m_ZombieWeights = new int[23];
        m_ZombieTypes = new int[23];
        m_Weights = new int[10];
        m_WeightTypes = new int[10];
    }
}

