/*
 * Decompiled with CFR 0.152.
 */
public class Plants
implements GameConstants,
Constants,
ReanimAttributes,
ConstantsReanim {
    static int MAX_NUM_PLANTS = 144;
    static int PLANT_TYPE = 0;
    static int PLANT_POS = PLANT_TYPE + 1;
    static int PLANT_X = PLANT_POS + 1;
    static int PLANT_Y = PLANT_X + 1;
    static int PLANT_HEALTH = PLANT_Y + 1;
    static int PLANT_STATE = PLANT_HEALTH + 1;
    static int PLANT_STATE_COUNTDOWN = PLANT_STATE + 1;
    static int PLANT_FIRE_COUNTDOWN = PLANT_STATE_COUNTDOWN + 1;
    static int PLANT_PROJECTILE_DELAY = PLANT_FIRE_COUNTDOWN + 1;
    static int PLANT_PARAM_1 = PLANT_PROJECTILE_DELAY + 1;
    static int PLANT_PARAM_2 = PLANT_PARAM_1 + 1;
    static int PLANT_PARAM_3 = PLANT_PARAM_2 + 1;
    static int PLANT_PARAM_4 = PLANT_PARAM_3 + 1;
    static int PLANT_NUM_PROJECTILES = PLANT_PARAM_4 + 1;
    static int PLANT_FLAGS = PLANT_NUM_PROJECTILES + 1;
    static int PLANT_TARGET_ZOMBIE_ID = PLANT_FLAGS + 1;
    static int PLANT_LADDER_POS = PLANT_TARGET_ZOMBIE_ID + 1;
    static int PLANT_RECENT_EATEN_COUNTDOWN = PLANT_LADDER_POS + 1;
    static int PLANT_REANIM_FRAME = PLANT_RECENT_EATEN_COUNTDOWN + 1;
    static int PLANT_REANIM_FP_FRAMES_PER_TICK = PLANT_REANIM_FRAME + 1;
    static int PLANT_REANIM_FP_TICKS_COUNTER = PLANT_REANIM_FP_FRAMES_PER_TICK + 1;
    static int PLANT_REANIM_INDEX = PLANT_REANIM_FP_TICKS_COUNTER + 1;
    static int PLANT_REANIM_CURR_TRACK_GLOBAL_INDEX = PLANT_REANIM_INDEX + 1;
    static int PLANT_REANIM_CURR_TRACK_ID = PLANT_REANIM_CURR_TRACK_GLOBAL_INDEX + 1;
    static int PLANT_REANIM_FPS = PLANT_REANIM_CURR_TRACK_ID + 1;
    static int PLANT_REANIM_START_TRACK_INDEX = PLANT_REANIM_FPS + 1;
    static int PLANT_REANIM_HIDDEN_TRACKS = PLANT_REANIM_START_TRACK_INDEX + 1;
    static int PLANT_REANIM_LOOP_TYPE = PLANT_REANIM_HIDDEN_TRACKS + 1;
    static int PLANT_REANIM_LOOP_COUNT = PLANT_REANIM_LOOP_TYPE + 1;
    static int PLANT_REANIM_COUNTDOWN_FRAMES = PLANT_REANIM_LOOP_COUNT + 1;
    static int PLANT_MAX_VALS = PLANT_REANIM_COUNTDOWN_FRAMES + 1;
    static int[] PLANTS = new int[MAX_NUM_PLANTS * PLANT_MAX_VALS];
    static int m_nPlants;
    static int PLANT_OFFSET_X;
    static int PLANT_OFFSET_Y;
    static int PLANT_OFFSET_DRAW_X;
    static int PLANT_OFFSET_DRAW_Y;
    static int PLANT_OFFSET_SHADOW_X;
    static int PLANT_OFFSET_SHADOW_Y;
    static int PLANT_OFFSET_PROJECTILE_X;
    static int PLANT_OFFSET_PROJECTILE_Y;
    static int PLANT_OFFSET_MAX_VALS;
    static int[] PLANT_OFFSETS;
    static int PLANT_POS_TYPE_UNDER_PLANT;
    static int PLANT_POS_TYPE_PUMPKIN_PLANT;
    static int PLANT_POS_TYPE_FLYING_PLANT;
    static int PLANT_POS_TYPE_NORMAL_PLANT;
    static int PLANT_POS_MAX_TYPES;
    static int[] PLANT_POS_TYPES;
    static int[] PLANT_POS_INDEXES;
    static int[] PLANT_RECT;
    static int PLANT_RECT_X;
    static int PLANT_RECT_Y;
    static int PLANT_RECT_W;
    static int PLANT_RECT_H;

    static void init() {
        m_nPlants = 0;
    }

    static void resetVarsNewLevel() {
        Util.resetArray(PLANTS, -1);
        m_nPlants = 0;
    }

    static void addPlant(int n, int n2) {
        Plants.addPlant(n, n2, -1, -1);
    }

    static void addPlant(int n, int n2, int n3, int n4) {
        if (n >= 0) {
            int n5 = 0;
            for (int i = 0; i < MAX_NUM_PLANTS; ++i) {
                if (Plants.isPlantAtIndex(i)) continue;
                n5 = PLANT_MAX_VALS * i;
                Plants.PLANTS[n5 + Plants.PLANT_TYPE] = n;
                Plants.PLANTS[n5 + Plants.PLANT_POS] = n2;
                Plants.getPlantOffsets(n);
                Cursor.getGridPosRect(n2, 0);
                Plants.PLANTS[n5 + Plants.PLANT_X] = Cursor.GRID_POS[Cursor.GRID_POS_X] + PLANT_OFFSETS[PLANT_OFFSET_X];
                Plants.PLANTS[n5 + Plants.PLANT_Y] = Cursor.GRID_POS[Cursor.GRID_POS_Y] + PLANT_OFFSETS[PLANT_OFFSET_Y];
                Plants.PLANTS[n5 + Plants.PLANT_HEALTH] = "\u012c\u012c\u012c\u012c\u0fa0\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u1f40\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c".charAt(n);
                Plants.PLANTS[n5 + Plants.PLANT_NUM_PROJECTILES] = (short)"\u0001\uffff\u0001\u0001\uffff\u0002\u0001\uffff\uffff\uffff\u0001\uffff\uffff\uffff\uffff\uffff\u0001\u0001\u0001\u0005\u0001\u0001\u0001\u0001\uffff\u0001\uffff\uffff\uffff\uffff\uffff".charAt(n);
                Plants.PLANTS[n5 + Plants.PLANT_PROJECTILE_DELAY] = -2;
                Plants.PLANTS[n5 + Plants.PLANT_FLAGS] = 0;
                Plants.PLANTS[n5 + Plants.PLANT_TARGET_ZOMBIE_ID] = -1;
                Plants.PLANTS[n5 + Plants.PLANT_LADDER_POS] = -1;
                Plants.PLANTS[n5 + Plants.PLANT_RECENT_EATEN_COUNTDOWN] = 0;
                Plants.PLANTS[n5 + Plants.PLANT_PARAM_1] = -1;
                Plants.PLANTS[n5 + Plants.PLANT_PARAM_2] = -1;
                Plants.PLANTS[n5 + Plants.PLANT_PARAM_3] = -1;
                Plants.PLANTS[n5 + Plants.PLANT_PARAM_4] = -1;
                Plants.PLANTS[n5 + Plants.PLANT_FIRE_COUNTDOWN] = "\n\uffff\uffff\u0000\uffff\u0000\u0001\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\u0003\u0004\u0006\u0007\t\n\uffff\n\uffff\n\uffff\uffff\uffff\uffff\uffff".charAt(n) != '\uffffffff' ? Plants.getPlantsCountdown(n) : -1;
                Plants.setPlantReanim(n, i, n3, n4);
                Plants.setInitialState(i, n);
                int n6 = 15;
                if (GModel.PLANT_ROW[Plants.getRow(i)] == 3) {
                    n6 = 16;
                }
                GCanvasController.doDirt(i, n6);
                ++m_nPlants;
                return;
            }
        }
    }

    static boolean isPlantAtIndex(int n) {
        return PLANTS[PLANT_MAX_VALS * n + PLANT_TYPE] != -1;
    }

    public static boolean isFlagSet(int n, int n2) {
        return (PLANTS[n2 * PLANT_MAX_VALS + PLANT_FLAGS] & 1 << n) != 0;
    }

    public static void setFlag(int n, int n2) {
        int n3 = n2 * PLANT_MAX_VALS + PLANT_FLAGS;
        PLANTS[n3] = PLANTS[n3] | 1 << n;
    }

    public static void unSetFlag(int n, int n2) {
        int n3 = n2 * PLANT_MAX_VALS + PLANT_FLAGS;
        PLANTS[n3] = PLANTS[n3] & ~(1 << n);
    }

    static int getPlantsCountdown(int n) {
        int n2 = 0;
        if ("\u0001\u0000\u0000\u0001\uffff\u0001\u0001\u0000\u0000\u0001\u0001\uffff\uffff\uffff\uffff\uffff\u0000\u0000\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\uffff\u0000\uffff\uffff".charAt(n) == '\u0001') {
            n2 = 1;
        } else if (Plants.bMakesSun(n)) {
            short s = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(n);
            n2 = s / 4 + Util.GetRandom(s / 2);
        } else {
            n2 = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(n);
        }
        return n2;
    }

    static boolean bMakesSun(int n) {
        return n == 2 || n == 22;
    }

    static int getPlantAttributeAtPos(int n, int n2) {
        if (n >= 0) {
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < MAX_NUM_PLANTS && n4 < m_nPlants; ++i) {
                n3 = PLANT_MAX_VALS * i;
                if (!Plants.isPlantAtIndex(i)) continue;
                ++n4;
                if (PLANTS[n3 + PLANT_POS] != n) continue;
                return PLANTS[n3 + n2];
            }
        }
        return -1;
    }

    static void getPlantsOnLawn(int n) {
        Util.resetArray(PLANT_POS_TYPES, -1);
        Util.resetArray(PLANT_POS_INDEXES, -1);
        if (n < 0 || n >= 9 * GModel.m_nGameBoardRows) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < MAX_NUM_PLANTS && n3 < m_nPlants; ++i) {
            n2 = PLANT_MAX_VALS * i;
            if (!Plants.isPlantAtIndex(i)) continue;
            ++n3;
            if (PLANTS[n2 + PLANT_POS] != n) continue;
            n4 = PLANTS[n2 + PLANT_TYPE];
            if (n4 == 29) {
                Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_UNDER_PLANT] = n4;
                Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_UNDER_PLANT] = i;
                continue;
            }
            if (n4 == 30) {
                Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_UNDER_PLANT] = n4;
                Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_UNDER_PLANT] = i;
                continue;
            }
            Plants.PLANT_POS_TYPES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] = n4;
            Plants.PLANT_POS_INDEXES[Plants.PLANT_POS_TYPE_NORMAL_PLANT] = i;
        }
    }

    static int getTopPlant(int n, int n2) {
        Plants.getPlantsOnLawn(n);
        if (n2 == 7) {
            return PLANT_POS_INDEXES[PLANT_POS_TYPE_FLYING_PLANT];
        }
        if (n2 == 9) {
            return PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT];
        }
        if (n2 == 8) {
            return PLANT_POS_INDEXES[PLANT_POS_TYPE_PUMPKIN_PLANT];
        }
        if (n2 == 6) {
            return PLANT_POS_INDEXES[PLANT_POS_TYPE_NORMAL_PLANT];
        }
        if (n2 == 0) {
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_PUMPKIN_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_PUMPKIN_PLANT];
            }
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_NORMAL_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_NORMAL_PLANT];
            }
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT];
            }
            return -1;
        }
        if (n2 == 1) {
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_NORMAL_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_NORMAL_PLANT];
            }
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT];
            }
            return -1;
        }
        if (n2 == 2 || n2 == 3 || n2 == 5) {
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_FLYING_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_FLYING_PLANT];
            }
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_NORMAL_PLANT] != -1) {
                int n3;
                int n4 = PLANT_POS_INDEXES[PLANT_POS_TYPE_NORMAL_PLANT];
                if (PLANT_POS_TYPES[PLANT_POS_TYPE_NORMAL_PLANT] == 11 && PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT] != -1 && PLANTS[(n3 = n4 * PLANT_MAX_VALS) + PLANT_STATE] >= 14) {
                    n4 = PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT];
                }
                return n4;
            }
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_PUMPKIN_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_PUMPKIN_PLANT];
            }
            if (PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT] != -1) {
                return PLANT_POS_INDEXES[PLANT_POS_TYPE_UNDER_PLANT];
            }
            return -1;
        }
        return -1;
    }

    static int getPlantAttribute(int n, int n2) {
        if (Plants.isPlantAtIndex(n)) {
            return PLANTS[PLANT_MAX_VALS * n + n2];
        }
        return -1;
    }

    static void setInitialState(int n, int n2) {
        int n3 = PLANT_MAX_VALS * n;
        Plants.PLANTS[n3 + Plants.PLANT_STATE] = 0;
        Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = 0;
        if (n2 == 3) {
            Plants.hideReanimTrack(n, 439);
            Plants.hideReanimTrack(n, 438);
        } else if (n2 == 5) {
            Plants.hideReanimTrack(n, 437);
            Plants.hideReanimTrack(n, 438);
        } else if (n2 == 6) {
            Plants.hideReanimTrack(n, 439);
            Plants.hideReanimTrack(n, 437);
        }
        if (n2 == 9 || n2 == 11 || n2 == 25) {
            Plants.PLANTS[n3 + Plants.PLANT_STATE] = 1;
        } else if (n2 == 8) {
            Plants.PLANTS[n3 + Plants.PLANT_STATE] = 8;
            Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(8);
        } else if (n2 == 2) {
            Plants.PLANTS[n3 + Plants.PLANT_PARAM_1] = PLANTS[n3 + PLANT_FIRE_COUNTDOWN];
            Plants.hideReanimTrack(n, 348);
            Plants.hideReanimTrack(n, 349);
            Plants.hideReanimTrack(n, 350);
        } else if (n2 == 20) {
            Plants.PLANTS[n3 + Plants.PLANT_STATE] = 22;
            Plants.setReanimTrack(n, 446, 0);
        } else if (n2 == 22) {
            Plants.PLANTS[n3 + Plants.PLANT_PARAM_1] = PLANTS[n3 + PLANT_FIRE_COUNTDOWN];
            Plants.hideReanimTrack(n, 473);
            Plants.hideReanimTrack(n, 472);
            Plants.setState(n, 23, true);
        } else if (n2 == 24) {
            Plants.PLANTS[n3 + Plants.PLANT_STATE] = 26;
            Plants.setReanimTrack(n, 480, 1);
            int n4 = GridItem.getGridItemIndexAtPos(PLANTS[n3 + PLANT_POS]);
            if (n4 != -1) {
                GridItem.GRID_ITEMS[GridItem.GRID_ITEM_MAX_VALS * n4 + GridItem.GRID_ITEM_PARAM_3] = n;
            }
        } else if (n2 == 12) {
            Plants.setReanimTrack(n, 444, 0);
        } else if (n2 == 7) {
            Plants.setReanimTrack(n, 401, 0);
        } else if (n2 == 26) {
            Plants.PLANTS[n3 + Plants.PLANT_FIRE_COUNTDOWN] = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(26);
        } else if (n2 == 1) {
            Plants.setReanimTrack(n, 334, 0);
            Plants.setState(n, 32, true);
        }
    }

    static int getPlantIndexAtPos(int n) {
        if (n >= 0) {
            int n2 = 0;
            for (int i = 0; i < MAX_NUM_PLANTS && n2 < m_nPlants; ++i) {
                if (!Plants.isPlantAtIndex(i)) continue;
                ++n2;
                if (PLANTS[i * PLANT_MAX_VALS + PLANT_POS] != n) continue;
                return i;
            }
        }
        return -1;
    }

    static void setState(int n, int n2, boolean bl) {
        int n3 = PLANT_MAX_VALS * n;
        Plants.PLANTS[n3 + Plants.PLANT_STATE] = n2;
        if (bl) {
            Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(n2);
        }
    }

    static void getPlantOffsets(int n) {
        char c = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e".charAt(n);
        if (c == '\uffffffff') {
            return;
        }
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_X] = (short)"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0004\u0000\ufffe\u0000\u0000\u0004\ufffd\u0002\u0000\ufffb\ufff8\ufff6\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(c);
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_Y] = (short)"\u0003\u0002\u0002\u0003\u0001\u0003\u0003\u0006\u0001\ufffb\ufffd\u0000\ufffd\u0011\u0000\ufff7\ufffe\u0001\u0003\ufffc\u0002\u0000\u0000\u0005\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(c);
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_X] = (short)"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\ufff3\ufffd\u0000\u0000\u0000\u0000\u0000\ufffe\u0000\u0000\u0003\u0002\u0000\ufffe\u0007\u0003\ufffc\ufffd\u0003\uffff\u0004\ufff6\u0000\u0000".charAt(c);
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_DRAW_Y] = (short)"\u0003\u0003\u0003\u0003\u0003\u0003\u0003\ufff8\u0000\u0002\b\u0000\u0007\u0000\ufffc\u0000\u0000\ufff5\ufffa\f\uffe2\u0011\f\u0001\ufff9\u0005\u0005\u0005\u0000\u0014\u0014".charAt(c);
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_SHADOW_X] = (short)"\u0003\u0002\u0002\u0003\u0002\u0003\u0003\u0006\u0003\u0005\u0002\u0002\u0000\uffff\uffff\u0001\t\r\u0010\u0003\u0005\u0001\u0001\u0002\uffff\u0002\u0002\u0003\u0000\uffff\u0000".charAt(c);
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_SHADOW_Y] = (short)"\u0019\u001b\u001b\u0019\u0019\u0019\u0019\u0015\u0019!\u001c\u0019\u001f\uffff\u0019#\u0019\u0015\u0013\u0019\u0018\u0018\u0018\u0015\uffff\u0018\u0018\u001e\u001d\uffff\u0019".charAt(c);
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_PROJECTILE_X] = (short)"\u0000\uffff\uffff\u0000\uffff\u0000\u0000\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\u0000\u0000\u0000\uffff\u0000\u0000\u0000\u0000\uffff\u0002\uffff\uffff\uffff\uffff\uffff".charAt(c);
        Plants.PLANT_OFFSETS[Plants.PLANT_OFFSET_PROJECTILE_Y] = (short)"\u0000\uffff\uffff\u0000\uffff\u0000\u0000\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\u0000\u0000\u0000\uffff\u0000\u0000\u0000\u0000\uffff\ufffb\uffff\uffff\uffff\uffff\uffff".charAt(c);
    }

    static void setPlantReanim(int n, int n2, int n3, int n4) {
        int n5 = PLANT_MAX_VALS * n2;
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_INDEX] = -1;
        if (n3 == -1 && (n3 = (int)((short)"\u0013\u0014\u0015\"\u001b\"\"\u001d\u0017\u0016 \u0018$\u0019!\u001c\u001a\u001e\u001f#%&'()*+,-.0".charAt(n))) == -1) {
            Plants.PLANTS[n5 + Plants.PLANT_REANIM_INDEX] = -1;
            return;
        }
        if (n4 == -1) {
            n4 = (short)"\u0005\u001e\uffff\uffffNXku\uffff\u009c\u00a5\u00b4\u00bd\u00d3\uffff\u00f3\u011e\uffff\uffff\u0143\u0150\u0157\u0162\u016c\u0176\u017a\u017c\u0187\u018d\u0192\u0196\u019c\u01a6\u01ac\u01b1\u01b8\u01bb\u01c1\u01ce\u01d5\u01dc\u01e1\u01ee\u01f2\u01f7\u01fd\u0201\u0204\u0213\uffff\uffff".charAt(n3);
        }
        if (n3 == -1 || n4 == -1) {
            Plants.PLANTS[n5 + Plants.PLANT_REANIM_INDEX] = -1;
            return;
        }
        Reanim.loadReanim(n3, n4);
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[0];
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_FRAME] = Reanim.REANIM_LOADED_TEMP_VALS[1];
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_CURR_TRACK_GLOBAL_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[2];
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_CURR_TRACK_ID] = n4;
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_FPS] = Reanim.REANIM_LOADED_TEMP_VALS[3];
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_START_TRACK_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[4];
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_HIDDEN_TRACKS] = 0;
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_LOOP_TYPE] = 0;
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_LOOP_COUNT] = 0;
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_FP_FRAMES_PER_TICK] = FP.fpDiv(73728, 4096 * PLANTS[n5 + PLANT_REANIM_FPS]);
        Plants.PLANTS[n5 + Plants.PLANT_REANIM_FP_TICKS_COUNTER] = 0;
    }

    static void setReanimFPS(int n, int n2) {
        int n3 = PLANT_MAX_VALS * n;
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_FPS] = n2;
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_FP_FRAMES_PER_TICK] = n2 == 0 ? 0 : FP.fpDiv(73728, 4096 * PLANTS[n3 + PLANT_REANIM_FPS]);
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_FP_TICKS_COUNTER] = 0;
    }

    static boolean updateReanim(int n) {
        boolean bl;
        int n2 = PLANT_MAX_VALS * n;
        if (PLANTS[n2 + PLANT_REANIM_INDEX] == -1) {
            return false;
        }
        boolean bl2 = false;
        if (PLANTS[n2 + PLANT_REANIM_FPS] == 0) {
            return bl2;
        }
        Reanim.REANIM_UPDATE_VALS[0] = PLANTS[n2 + PLANT_REANIM_INDEX];
        Reanim.REANIM_UPDATE_VALS[1] = PLANTS[n2 + PLANT_REANIM_FRAME];
        Reanim.REANIM_UPDATE_VALS[2] = PLANTS[n2 + PLANT_REANIM_CURR_TRACK_GLOBAL_INDEX];
        Reanim.REANIM_UPDATE_VALS[3] = PLANTS[n2 + PLANT_REANIM_FP_FRAMES_PER_TICK];
        Reanim.REANIM_UPDATE_VALS[4] = PLANTS[n2 + PLANT_REANIM_FP_TICKS_COUNTER];
        Reanim.REANIM_UPDATE_VALS[6] = PLANTS[n2 + PLANT_REANIM_LOOP_TYPE];
        Reanim.REANIM_UPDATE_VALS[5] = PLANTS[n2 + PLANT_REANIM_LOOP_COUNT];
        boolean bl3 = false;
        if (!Plants.isFlagSet(0, n)) {
            bl3 = Reanim.updateReanim(Reanim.REANIM_UPDATE_VALS);
        }
        Plants.PLANTS[n2 + Plants.PLANT_REANIM_FRAME] = Reanim.REANIM_UPDATE_VALS[1];
        Plants.PLANTS[n2 + Plants.PLANT_REANIM_FP_FRAMES_PER_TICK] = Reanim.REANIM_UPDATE_VALS[3];
        Plants.PLANTS[n2 + Plants.PLANT_REANIM_FP_TICKS_COUNTER] = Reanim.REANIM_UPDATE_VALS[4];
        Plants.PLANTS[n2 + Plants.PLANT_REANIM_LOOP_COUNT] = Reanim.REANIM_UPDATE_VALS[5];
        boolean bl4 = bl = bl3 && PLANTS[n2 + PLANT_REANIM_LOOP_TYPE] == 1 && !Plants.isFlagSet(0, n);
        if (bl) {
            Plants.setFlag(0, n);
        } else if (Plants.isFlagSet(0, n)) {
            Plants.PLANTS[n2 + Plants.PLANT_REANIM_COUNTDOWN_FRAMES] = Math.max(0, PLANTS[n2 + PLANT_REANIM_COUNTDOWN_FRAMES] - 1);
            if (PLANTS[n2 + PLANT_REANIM_COUNTDOWN_FRAMES] <= 0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    static void setReanimHoldCountdown(int n, int n2) {
        Plants.PLANTS[Plants.PLANT_MAX_VALS * n + Plants.PLANT_REANIM_COUNTDOWN_FRAMES] = n2;
    }

    static void setReanimTrack(int n, int n2, int n3) {
        if (n2 < 0) {
            return;
        }
        int n4 = PLANT_MAX_VALS * n;
        Util.resetArray(Reanim.REANIM_LOADED_TEMP_VALS, -1);
        Reanim.setAnimTrack(Reanim.REANIM_LOADED_TEMP_VALS, PLANTS[n4 + PLANT_REANIM_INDEX], n2);
        Plants.PLANTS[n4 + Plants.PLANT_REANIM_FRAME] = Reanim.REANIM_LOADED_TEMP_VALS[1];
        Plants.PLANTS[n4 + Plants.PLANT_REANIM_CURR_TRACK_GLOBAL_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[2];
        Plants.PLANTS[n4 + Plants.PLANT_REANIM_CURR_TRACK_ID] = n2;
        Plants.PLANTS[n4 + Plants.PLANT_REANIM_LOOP_TYPE] = n3;
        Plants.PLANTS[n4 + Plants.PLANT_REANIM_LOOP_COUNT] = 0;
        Plants.PLANTS[n4 + Plants.PLANT_REANIM_FP_TICKS_COUNTER] = 0;
        Plants.unSetFlag(0, n);
    }

    static void incrementReanimTrack(int n, int n2) {
        int n3 = PLANT_MAX_VALS * n;
        Util.resetArray(Reanim.REANIM_LOADED_TEMP_VALS, -1);
        int n4 = Reanim.incrementReanimAnimTrack(Reanim.REANIM_LOADED_TEMP_VALS, PLANTS[n3 + PLANT_REANIM_INDEX], PLANTS[n3 + PLANT_REANIM_CURR_TRACK_ID]);
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_FRAME] = Reanim.REANIM_LOADED_TEMP_VALS[1];
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_CURR_TRACK_GLOBAL_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[2];
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_CURR_TRACK_ID] = n4;
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_LOOP_TYPE] = n2;
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_LOOP_COUNT] = 0;
    }

    static void hideReanimTrack(int n, int n2) {
        int n3 = PLANT_MAX_VALS * n;
        if (PLANTS[n3 + PLANT_REANIM_CURR_TRACK_ID] == n2) {
            return;
        }
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_HIDDEN_TRACKS] = Reanim.hideTrack(PLANTS[n3 + PLANT_REANIM_INDEX], PLANTS[n3 + PLANT_REANIM_START_TRACK_INDEX], n2, PLANTS[n3 + PLANT_REANIM_HIDDEN_TRACKS]);
    }

    static void showReanimTrack(int n, int n2) {
        int n3 = PLANT_MAX_VALS * n;
        Plants.PLANTS[n3 + Plants.PLANT_REANIM_HIDDEN_TRACKS] = Reanim.showTrack(PLANTS[n3 + PLANT_REANIM_INDEX], PLANTS[n3 + PLANT_REANIM_START_TRACK_INDEX], n2, PLANTS[n3 + PLANT_REANIM_HIDDEN_TRACKS]);
    }

    static void update() {
        int n = 0;
        int n2 = m_nPlants;
        boolean bl = false;
        for (int i = 0; i < MAX_NUM_PLANTS && n < n2; ++i) {
            if (!Plants.isPlantAtIndex(i)) continue;
            int n3 = i * PLANT_MAX_VALS;
            int n4 = PLANTS[n3 + PLANT_TYPE];
            short s = (short)"\u0001\u0002\u0000\u0001\u0004\u0001\u0001\u0002\u0002\uffff\u0001\u0003\u0002\u0003\u0003\u0004\u0001\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0003\u0001\u0002\u0003\u0002\u0002\u0002".charAt(n4);
            if (PLANTS[n3 + PLANT_STATE_COUNTDOWN] > 0) {
                int n5 = n3 + PLANT_STATE_COUNTDOWN;
                PLANTS[n5] = PLANTS[n5] - 1;
            }
            bl = false;
            if (PLANTS[n3 + PLANT_RECENT_EATEN_COUNTDOWN] > 0) {
                int n6 = n3 + PLANT_RECENT_EATEN_COUNTDOWN;
                PLANTS[n6] = PLANTS[n6] - 1;
                if (n4 == 4 || n4 == 15) {
                    bl = true;
                }
            }
            if (n4 == 8) {
                Plants.updatePotato(i);
            } else if (n4 == 11) {
                Plants.updateSquash(i);
            } else if (n4 == 13) {
                Plants.updateSpikey(i);
            } else if (n4 == 14) {
                Plants.updateTorchWood(i);
            } else if (n4 == 9) {
                Plants.updateChomper(i);
            } else if (n4 == 20) {
                Plants.updateCactus(i);
            } else if (n4 == 22) {
                Plants.updateSunShroom(i);
            } else if (n4 == 24) {
                Plants.updateGraveBuster(i);
            } else if (n4 == 25) {
                Plants.updateScaredyShroom(i);
            } else if (n4 == 26) {
                Plants.updateIceShroom(i);
            } else if (n4 == 28) {
                Plants.updateDoomShroom(i);
            } else if (n4 == 1) {
                Plants.updateTangleKelp(i);
            }
            if (s == 1) {
                Plants.updateShooter(i);
            } else if (s == 0 && n4 != 22) {
                Plants.updateProduction(i, (short)"\uffff\uffff\u0001\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u0001\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4));
            } else if (s == 2) {
                Plants.updateExploding(i, false);
            }
            if (!bl) {
                Plants.updateReanim(i);
            }
            ++n;
        }
    }

    static void updateShooter(int n) {
        short s;
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        int n4 = -1;
        int n5 = -1;
        if (PLANTS[n2 + PLANT_REANIM_INDEX] != -1) {
            n4 = Reanim.getReanimID(PLANTS[n2 + PLANT_REANIM_INDEX]);
            n5 = (short)"\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u00a4\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u0144\uffff\uffff\uffff\uffff\uffff\uffff\u017d\uffff\uffff\uffff\u0197\u019d\u01a5\uffff\u01b2\u01b9\uffff\u01c2\u01cd\uffff\u01db\uffff\u01ed\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n4);
        }
        if (PLANTS[n2 + PLANT_FIRE_COUNTDOWN] > 0) {
            int n6 = n2 + PLANT_FIRE_COUNTDOWN;
            PLANTS[n6] = PLANTS[n6] - 1;
            if (PLANTS[n2 + PLANT_FIRE_COUNTDOWN] == 0 && (s = (short)"\n\uffff\uffff\u0000\uffff\u0000\u0001\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\u0003\u0004\u0006\u0007\t\n\uffff\n\uffff\n\uffff\uffff\uffff\uffff\uffff".charAt(n3)) != -1) {
                short s2;
                int n7 = Plants.getRow(n);
                int n8 = -1;
                if (n3 == 19) {
                    n8 = Plants.findStarFruitTargetZombie(n7, n);
                } else if (n3 == 20) {
                    if (PLANTS[n2 + PLANT_STATE] == 20) {
                        n8 = Plants.findTargetZombie(n7, n, 0);
                    } else if (PLANTS[n2 + PLANT_STATE] == 22) {
                        n8 = Plants.findTargetZombie(n7, n, 1);
                    }
                } else {
                    n8 = Plants.findTargetZombie(n7, n, 0);
                    if (n8 == -1 && GameController.m_nLevel == 49 && Zombies.ZOMBIES[(s2 = 0) + Zombies.ZOMBIE_STATE] >= 91) {
                        n8 = 0;
                    }
                }
                if (n3 == 10) {
                    if (n8 == -1 && ZombieController.bRowCanHaveZombies(n7 - 1)) {
                        n8 = Plants.findTargetZombie(n7 - 1, n, 0);
                    }
                    if (n8 == -1 && ZombieController.bRowCanHaveZombies(n7 + 1)) {
                        n8 = Plants.findTargetZombie(n7 + 1, n, 0);
                    }
                }
                if (n8 != -1) {
                    s2 = (short)"\u0001\uffff\u0001\u0001\uffff\u0002\u0001\uffff\uffff\uffff\u0001\uffff\uffff\uffff\uffff\uffff\u0001\u0001\u0001\u0005\u0001\u0001\u0001\u0001\uffff\u0001\uffff\uffff\uffff\uffff\uffff".charAt(n3);
                    Plants.PLANTS[n2 + Plants.PLANT_PROJECTILE_DELAY] = (short)"\u0007\uffff\uffff\u0007\uffff\u0007\u0007\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u000b\u000e\n\u0007\u000e\t\uffff\u0012\uffff\n\uffff\uffff\uffff\uffff\uffff".charAt(n3);
                    if (n3 == 20) {
                        if (PLANTS[n2 + PLANT_STATE] == 20) {
                            Plants.setReanimTrack(n, 450, 1);
                        } else if (PLANTS[n2 + PLANT_STATE] == 22) {
                            Plants.setReanimTrack(n, 447, 1);
                        }
                    } else {
                        Plants.setReanimTrack(n, n5, 1);
                    }
                    if (n3 == 10 || n3 == 19) {
                        int n9 = n2 + PLANT_NUM_PROJECTILES;
                        PLANTS[n9] = PLANTS[n9] - s2;
                    } else {
                        int n10 = n2 + PLANT_NUM_PROJECTILES;
                        PLANTS[n10] = PLANTS[n10] - 1;
                    }
                    if (PLANTS[n2 + PLANT_NUM_PROJECTILES] > 0) {
                        Plants.PLANTS[n2 + Plants.PLANT_FIRE_COUNTDOWN] = Math.max((short)"\uffff\uffff6\uffff\uffff\t\uffff\u0002\uffff\uffff\uffff\uffff\u0002\r\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff6\t\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n3), (short)"\u0007\uffff\uffff\u0007\uffff\u0007\u0007\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\u000b\u000e\n\u0007\u000e\t\uffff\u0012\uffff\n\uffff\uffff\uffff\uffff\uffff".charAt(n3));
                    } else if (s2 > 1) {
                        int n11;
                        Plants.PLANTS[n2 + Plants.PLANT_FIRE_COUNTDOWN] = n11 = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(n3) - (s2 - 1) * (short)"\uffff\uffff6\uffff\uffff\t\uffff\u0002\uffff\uffff\uffff\uffff\u0002\r\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff6\t\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n3);
                        Plants.PLANTS[n2 + Plants.PLANT_NUM_PROJECTILES] = (short)"\u0001\uffff\u0001\u0001\uffff\u0002\u0001\uffff\uffff\uffff\u0001\uffff\uffff\uffff\uffff\uffff\u0001\u0001\u0001\u0005\u0001\u0001\u0001\u0001\uffff\u0001\uffff\uffff\uffff\uffff\uffff".charAt(n3);
                    } else {
                        Plants.PLANTS[n2 + Plants.PLANT_FIRE_COUNTDOWN] = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(n3);
                        int n12 = Math.max(Util.getPercentageOf((short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(n3), 20), 2);
                        int n13 = n2 + PLANT_FIRE_COUNTDOWN;
                        PLANTS[n13] = PLANTS[n13] - Util.GetRandom(n12);
                        Plants.PLANTS[n2 + Plants.PLANT_NUM_PROJECTILES] = (short)"\u0001\uffff\u0001\u0001\uffff\u0002\u0001\uffff\uffff\uffff\u0001\uffff\uffff\uffff\uffff\uffff\u0001\u0001\u0001\u0005\u0001\u0001\u0001\u0001\uffff\u0001\uffff\uffff\uffff\uffff\uffff".charAt(n3);
                    }
                    if (n3 == 23) {
                        Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = (short)"\uffff\uffff6\uffff\uffff\t\uffff\u0002\uffff\uffff\uffff\uffff\u0002\r\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff6\t\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n3);
                    }
                } else {
                    Plants.PLANTS[n2 + Plants.PLANT_FIRE_COUNTDOWN] = 1;
                }
            }
        }
        if (PLANTS[n2 + PLANT_PROJECTILE_DELAY] != -2) {
            Plants.updateShooting(n);
        }
        if (n5 != -1 && PLANTS[n2 + PLANT_REANIM_CURR_TRACK_ID] == n5 && PLANTS[n2 + PLANT_REANIM_LOOP_COUNT] > 0) {
            s = (short)"\u0005\u001e\uffff\uffffNXku\uffff\u009c\u00a5\u00b4\u00bd\u00d3\uffff\u00f3\u011e\uffff\uffff\u0143\u0150\u0157\u0162\u016c\u0176\u017a\u017c\u0187\u018d\u0192\u0196\u019c\u01a6\u01ac\u01b1\u01b8\u01bb\u01c1\u01ce\u01d5\u01dc\u01e1\u01ee\u01f2\u01f7\u01fd\u0201\u0204\u0213\uffff\uffff".charAt(n4);
            Plants.setReanimTrack(n, s, 0);
        }
    }

    static void updateShooting(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        int n4 = n2 + PLANT_PROJECTILE_DELAY;
        PLANTS[n4] = PLANTS[n4] - 1;
        if (n3 == 23 && PLANTS[n2 + PLANT_PARAM_1] > 0) {
            int n5 = n2 + PLANT_PARAM_1;
            PLANTS[n5] = PLANTS[n5] - 1;
            if (PLANTS[n2 + PLANT_PARAM_1] == 0) {
                GCanvasController.doFumeShroomPuffs(n);
            }
        }
        if (PLANTS[n2 + PLANT_PROJECTILE_DELAY] <= 0) {
            int n6 = "\n\uffff\uffff\u0000\uffff\u0000\u0001\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\u0003\u0004\u0006\u0007\t\n\uffff\n\uffff\n\uffff\uffff\uffff\uffff\uffff".charAt(n3);
            if (n6 != -1) {
                int n7;
                int n8 = Plants.getRow(n);
                int n9 = -1;
                int n10 = 0;
                if (n3 == 20) {
                    if (PLANTS[n2 + PLANT_STATE] == 20) {
                        n9 = Plants.findTargetZombie(n8, n, n10);
                    } else if (PLANTS[n2 + PLANT_STATE] == 22) {
                        n10 = 1;
                        n9 = Plants.findTargetZombie(n8, n, n10);
                    }
                } else {
                    n9 = Plants.findTargetZombie(n8, n, n10);
                    if (n9 == -1 && GameController.m_nLevel == 49 && Zombies.ZOMBIES[(n7 = 0) + Zombies.ZOMBIE_STATE] >= 91) {
                        n9 = 0;
                    }
                }
                if (n3 == 10) {
                    if (n9 == -1 && ZombieController.bRowCanHaveZombies(n8 - 1)) {
                        n9 = Plants.findTargetZombie(n8 - 1, n, n10);
                    }
                    if (n9 == -1 && ZombieController.bRowCanHaveZombies(n8 + 1)) {
                        n9 = Plants.findTargetZombie(n8 + 1, n, n10);
                    }
                }
                if (n3 == 19) {
                    Plants.fireStarProjectiles(n, -1);
                } else if (n9 != -1) {
                    if (n3 == 10) {
                        Plants.fireProjectile(n, -1, n3, 0, n10);
                        if (n8 > 0) {
                            Plants.fireProjectile(n, n8 - 1, n3, 1, n10);
                        }
                        if (n8 < GModel.m_nGameBoardRows - 1) {
                            Plants.fireProjectile(n, n8 + 1, n3, 1, n10);
                        }
                    } else if (n3 == 23) {
                        Plants.getAttackRect(n);
                        n7 = CollisionHandler.hitAllZombiesInRect(n, PLANT_RECT[PLANT_RECT_X], PLANT_RECT[PLANT_RECT_Y], PLANT_RECT[PLANT_RECT_W], PLANT_RECT[PLANT_RECT_H], 20, n8, 0, 4, 0, false);
                        if (n7 > 0) {
                            GCanvasController.doFumeShroomZombieSplats(n7, CollisionHandler.COLLISION_TEMP);
                        }
                    } else if (n6 == 3 || n6 == 4 || n6 == 6) {
                        if (n6 == 4 && Util.GetRandom(4) == 0) {
                            n6 = 5;
                        }
                        Plants.fireLobProjectile(n, n9, n6, n10);
                    } else {
                        Plants.fireProjectile(n, -1, n3, 0, n10);
                    }
                }
            }
            Plants.PLANTS[n2 + Plants.PLANT_PROJECTILE_DELAY] = -2;
        }
    }

    static void updateProduction(int n, int n2) {
        int n3 = n * PLANT_MAX_VALS;
        int n4 = PLANTS[n3 + PLANT_TYPE];
        boolean bl = false;
        if (!GModel.m_bDroppedLevelAward && PLANTS[n3 + PLANT_FIRE_COUNTDOWN] > 0) {
            int n5 = n3 + PLANT_FIRE_COUNTDOWN;
            PLANTS[n5] = PLANTS[n5] - 1;
            if (PLANTS[n3 + PLANT_FIRE_COUNTDOWN] == 0 && n2 != -1) {
                int n6 = PLANTS[n3 + PLANT_X] + (short)"\uffff\u0000\u0000".charAt(n2);
                int n7 = PLANTS[n3 + PLANT_Y] + (short)"\uffff\ufffb\r".charAt(n2);
                int n8 = PLANTS[n3 + PLANT_Y] + (short)"\uffff\u0014\u001c".charAt(n2);
                int n9 = -1;
                Coins.addCoin(n2, n6, n7, n8, n9, -1);
                Plants.PLANTS[n3 + Plants.PLANT_FIRE_COUNTDOWN] = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(n4);
                bl = true;
            }
        }
        if (n4 == 2) {
            Plants.updateSunFlowerGlow(n, bl);
        } else if (n4 == 22) {
            Plants.updateSunShroomGlow(n, bl);
        }
    }

    static void updateExploding(int n, boolean bl) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        if (PLANTS[n2 + PLANT_FIRE_COUNTDOWN] > 0 || bl) {
            int n4 = n2 + PLANT_FIRE_COUNTDOWN;
            PLANTS[n4] = PLANTS[n4] - 1;
            if (PLANTS[n2 + PLANT_FIRE_COUNTDOWN] == 0 || bl) {
                Plants.getHitRect(n);
                int n5 = PLANT_RECT[PLANT_RECT_X] + PLANT_RECT[PLANT_RECT_W] / 2;
                int n6 = PLANT_RECT[PLANT_RECT_Y] + PLANT_RECT[PLANT_RECT_H] / 2;
                int n7 = Plants.getRow(n);
                int n8 = Plants.getDamageRangeFlags(n, 0);
                int n9 = 20;
                if (n3 == 7) {
                    CollisionHandler.hitAllZombiesInRect(n, n5 - 42, n6 - 42, 84, 84, 1800, n7, 1, n9, n8, true);
                    CollisionHandler.hitAllLaddersInRect(n, n5 - 42, n6 - 42, 84, 84, 1800, n7, 1, n9, n8, true);
                    GCanvasController.doPowieExposion(n);
                    Plants.killPlant(n);
                } else if (n3 == 12) {
                    Cursor.getGridRowPos(n7, 0);
                    n5 = Cursor.GRID_POS[Cursor.GRID_POS_X];
                    n6 = Cursor.GRID_POS[Cursor.GRID_POS_Y];
                    int n10 = 270;
                    int n11 = Cursor.GRID_POS[Cursor.GRID_POS_H];
                    CollisionHandler.hitAllZombiesInRect(n, n5, n6, n10, n11, 1800, n7, 0, n9, n8, true);
                    CollisionHandler.hitAllLaddersInRect(n, n5, n6, n10, n11, 1800, n7, 0, n9, n8, true);
                    GCanvasController.doJalapenoExplosion(n);
                    Plants.killPlant(n);
                } else if (n3 == 26) {
                    Plants.freezeZombies(n);
                    Plants.killPlant(n);
                } else if (n3 == 28) {
                    CollisionHandler.hitAllZombiesInRect(n, n5 - 90, n6 - 90, 180, 180, 1800, n7, 3, n9, n8, true);
                    GCanvasController.doDoomExplosion(n);
                    GridItem.addGridItem(2, PLANTS[n2 + PLANT_POS], 0, 3240);
                    Plants.killAllPlantsAtDoomPos(n);
                    Plants.killPlant(n);
                } else if (n3 == 30) {
                    Plants.killPlant(n);
                }
            }
        }
    }

    static void updatePotato(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_STATE];
        int n4 = PLANTS[n2 + PLANT_REANIM_LOOP_COUNT];
        if (n3 == 8) {
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 9;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(9);
                Plants.setReanimTrack(n, 363, 1);
            }
        } else if (n3 == 9) {
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0 && n4 > 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 10;
                Plants.setReanimTrack(n, 362, 0);
            }
        } else if (n3 == 10) {
            int n5 = Plants.findTargetZombie(Plants.getRow(n), n, 0);
            if (n5 != -1) {
                Plants.getHitRect(n);
                int n6 = PLANT_RECT[PLANT_RECT_X] + PLANT_RECT[PLANT_RECT_W] / 2;
                int n7 = PLANT_RECT[PLANT_RECT_Y] + PLANT_RECT[PLANT_RECT_H] / 2;
                CollisionHandler.hitAllZombiesInRect(n, n6 - 25, n7 - 25, 50, 50, 1800, Plants.getRow(n), 0, 20, 0, false);
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 11;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(11);
                Plants.setReanimTrack(n, 361, 1);
                GCanvasController.doSpudowExplosion(n);
            }
        } else if (n3 == 11 && PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
            Plants.killPlant(n);
        }
    }

    static void updateSquash(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_STATE];
        int n4 = PLANTS[n2 + PLANT_REANIM_LOOP_COUNT];
        if (n3 == 1) {
            int n5 = Plants.findTargetZombie(Plants.getRow(n), n, 0);
            if (n5 != -1 && n5 != 21 && n5 != 22) {
                Plants.PLANTS[n2 + Plants.PLANT_TARGET_ZOMBIE_ID] = n5;
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 13;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(13);
            }
        } else if (n3 == 13) {
            int n6 = PLANTS[n2 + PLANT_TARGET_ZOMBIE_ID];
            if (Zombies.ZOMBIES[n6 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_TYPE] == -1) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 1;
                return;
            }
            if (Zombies.ZOMBIES[n6 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_TYPE] == 15 && Zombies.ZOMBIES[n6 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_STATE] == 67) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 1;
                return;
            }
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 14;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(14);
                Plants.setReanimTrack(n, 373, 1);
            }
        } else if (n3 == 14) {
            int n7 = PLANTS[n2 + PLANT_TARGET_ZOMBIE_ID];
            if (Zombies.ZOMBIES[n7 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_TYPE] == -1) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 1;
                return;
            }
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0 && n4 > 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 15;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(15);
                int n8 = PLANTS[n2 + PLANT_TARGET_ZOMBIE_ID];
                Zombies.getHitRect(n8);
                int n9 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] * 4096;
                int n10 = (PLANTS[n2 + PLANT_Y] - 50) * 4096;
                int n11 = PLANTS[n2 + PLANT_X] * 4096;
                int n12 = PLANTS[n2 + PLANT_Y] * 4096;
                int n13 = n9 - n11;
                int n14 = n10 - n12;
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_4] = Vector.length(n13, n14);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_3] = 0;
                Vector.normalise(n13, n14);
                Vector.scale(Vector.vrx, Vector.vry, 32768);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = Vector.vrx;
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_2] = Vector.vry;
            }
        } else if (n3 == 15) {
            int n15 = PLANTS[n2 + PLANT_X] * 4096;
            int n16 = PLANTS[n2 + PLANT_Y] * 4096;
            int n17 = PLANTS[n2 + PLANT_PARAM_1];
            int n18 = PLANTS[n2 + PLANT_PARAM_2];
            int n19 = PLANTS[n2 + PLANT_PARAM_3];
            int n20 = PLANTS[n2 + PLANT_PARAM_4];
            int n21 = Vector.length(n17, n18);
            if ((n19 = Math.min(n19 + n21, n20)) < n20) {
                Plants.PLANTS[n2 + Plants.PLANT_X] = FP.toInt(n15 += n17);
                Plants.PLANTS[n2 + Plants.PLANT_Y] = FP.toInt(n16 += n18);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = FP.fpMul(n17, GModel.FP_95_PERCENT);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_2] = FP.fpMul(n18, GModel.FP_95_PERCENT);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_3] = n19;
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_4] = n20;
            } else {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 16;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(16);
            }
        } else if (n3 == 16) {
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 17;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(17);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = PLANTS[n2 + PLANT_Y] + 50;
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_2] = 10;
                Plants.setReanimTrack(n, 372, 1);
            }
        } else if (n3 == 17) {
            int n22 = PLANTS[n2 + PLANT_PARAM_2];
            int n23 = PLANTS[n2 + PLANT_PARAM_1];
            Plants.PLANTS[n2 + Plants.PLANT_Y] = Math.min(PLANTS[n2 + PLANT_Y] + n22, n23);
            if (PLANTS[n2 + PLANT_Y] >= n23 && PLANTS[n2 + PLANT_TARGET_ZOMBIE_ID] != -1) {
                int n24 = PLANTS[n2 + PLANT_TARGET_ZOMBIE_ID] * Zombies.ZOMBIE_MAX_VALS;
                if (Zombies.ZOMBIES[n24 + Zombies.ZOMBIE_TYPE] != 11) {
                    Zombies.killZombie(PLANTS[n2 + PLANT_TARGET_ZOMBIE_ID], true);
                }
                short s = (short)"\u001c\u0014\u00122\u0014\u000f\u000f\u010eNvv\u010e".charAt(4);
                Plants.PLANT_RECT[Plants.PLANT_RECT_W] = s;
                short s2 = s;
                short s3 = (short)"\u001e\u001e!\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e".charAt(4);
                Plants.PLANT_RECT[Plants.PLANT_RECT_H] = s3;
                short s4 = s3;
                int n25 = PLANTS[n2 + PLANT_X] + (short)"\u0000\u000f\u001e\u0000\u0005\u000f\n\u0000\u0018\u0018\u0018\u0000".charAt(4) + s2 / 2;
                int n26 = PLANTS[n2 + PLANT_Y] + (short)"\u0000\u0003\u0005\u0003\u0003\u0000\ufff3\u0000\u0005\u0005\u0005\u0000".charAt(4) + s4 / 2;
                CollisionHandler.hitAllZombiesInRect(n, n25, n26, s2, s4, 1800, Plants.getRow(n), 0, 20, 0, false);
                Plants.PLANTS[n2 + Plants.PLANT_TARGET_ZOMBIE_ID] = -1;
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 18;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(18);
                GCanvasController.shakeBoard(2, 4, 3);
            }
        } else if (n3 == 18 && PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
            Plants.killPlant(n);
        }
    }

    static void updateTangleKelp(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = n2 + PLANT_STATE_COUNTDOWN;
        PLANTS[n3] = PLANTS[n3] - 1;
        int n4 = PLANTS[n2 + PLANT_STATE];
        if (n4 == 32) {
            int n5 = Plants.findTargetZombie(Plants.getRow(n), n, 0);
            if (n5 != -1) {
                Plants.PLANTS[n2 + Plants.PLANT_TARGET_ZOMBIE_ID] = n5;
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 31;
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(31);
                Plants.setReanimTrack(n, 333, 1);
            }
        } else if (n4 == 31) {
            Plants.PLANTS[n2 + Plants.PLANT_STATE] = 33;
            Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(31);
        } else if (n4 == 33) {
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(33);
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 34;
                Plants.setReanimTrack(n, 335, 1);
            }
        } else if (n4 == 34 && PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
            Zombies.killZombie(PLANTS[n2 + PLANT_TARGET_ZOMBIE_ID], true);
            Plants.PLANTS[n2 + Plants.PLANT_TARGET_ZOMBIE_ID] = -1;
            Plants.killPlant(n);
        }
    }

    static void updateTorchWood(int n) {
        int n2 = Plants.getRow(n);
        Plants.getAttackRect(n);
        int n3 = PLANT_RECT[PLANT_RECT_X];
        int n4 = PLANT_RECT[PLANT_RECT_Y];
        int n5 = PLANT_RECT[PLANT_RECT_W];
        int n6 = PLANT_RECT[PLANT_RECT_H];
        int n7 = 0;
        for (int i = 0; i < Projectiles.MAX_NUM_PROJECTILES && n7 < Projectiles.m_nProjectiles; ++i) {
            if (!Projectiles.isProjectileAtIndex(i)) continue;
            int n8 = Projectiles.PROJECTILE_MAX_VALS * i;
            int n9 = Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_TYPE];
            int n10 = Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_ROW];
            if (n2 != n10 || Projectiles.PROJECTILES[n8 + Projectiles.PROJECTILE_TORCHED_PLANT_INDEX] == n || n9 != 1 && n9 != 0 || Projectiles.isFlagSet(1, i)) {
                ++n7;
                continue;
            }
            Projectiles.getRect(i, false);
            int n11 = CollisionHandler.getRectOverlap(n3, n4, n5, n6, Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_X], Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_Y], Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_W], Projectiles.PROJECTILE_RECT[Projectiles.PROJECTILE_RECT_H]);
            if (n11 < 0) {
                ++n7;
                continue;
            }
            Projectiles.convertToFireball(i);
            int n12 = i * Projectiles.PROJECTILE_MAX_VALS;
            Projectiles.PROJECTILES[n12 + Projectiles.PROJECTILE_TORCHED_PLANT_INDEX] = n;
            ++n7;
        }
    }

    static void updateSpikey(int n) {
        int n2 = Plants.getRow(n);
        int n3 = n * PLANT_MAX_VALS;
        int n4 = PLANTS[n3 + PLANT_STATE];
        int n5 = PLANTS[n3 + PLANT_TYPE];
        int n6 = PLANTS[n3 + PLANT_REANIM_LOOP_COUNT];
        if (n4 == 0) {
            int n7 = Plants.findTargetZombie(Plants.getRow(n), n, 0);
            if (n7 != -1) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 12;
                Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(n5);
                Plants.setReanimTrack(n, 377, 1);
            }
        } else if (n4 == 12) {
            if (PLANTS[n3 + PLANT_STATE_COUNTDOWN] <= 0 && n6 > 0) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 0;
                Plants.setReanimTrack(n, 378, 0);
            } else if (PLANTS[n3 + PLANT_STATE_COUNTDOWN] == (short)"\uffff\uffff6\uffff\uffff\t\uffff\u0002\uffff\uffff\uffff\uffff\u0002\r\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff6\t\uffff\uffff\uffff\uffff\uffff\uffff\uffff".charAt(n5)) {
                Plants.getAttackRect(n);
                int n8 = PLANT_RECT[PLANT_RECT_X];
                int n9 = PLANT_RECT[PLANT_RECT_Y];
                int n10 = PLANT_RECT[PLANT_RECT_W];
                int n11 = PLANT_RECT[PLANT_RECT_H];
                CollisionHandler.hitAllZombiesInRect(n, n8, n9, n10, n11, 20, n2, 0, 3, 0, false);
            }
        }
    }

    static void updateChomper(int n) {
        int n2;
        int n3 = n * PLANT_MAX_VALS;
        int n4 = PLANTS[n3 + PLANT_STATE];
        int n5 = PLANTS[n3 + PLANT_REANIM_CURR_TRACK_ID];
        int n6 = PLANTS[n3 + PLANT_REANIM_LOOP_COUNT];
        if (n4 == 3) {
            if (PLANTS[n3 + PLANT_STATE_COUNTDOWN] <= 0) {
                boolean bl = false;
                boolean bl2 = true;
                int n7 = Plants.findTargetZombie(Plants.getRow(n), n, 0);
                int n8 = -1;
                int n9 = -1;
                if (n7 == -1) {
                    bl = true;
                } else {
                    n8 = Zombies.ZOMBIES[n7 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_TYPE];
                    n9 = Zombies.ZOMBIES[n7 * Zombies.ZOMBIE_MAX_VALS + Zombies.ZOMBIE_STATE];
                }
                if (n8 == 11) {
                    bl2 = false;
                }
                if (n7 != -1 && !Zombies.isFlagSet(3, n7)) {
                    if (Zombies.bIsBouncingPogo(n7)) {
                        bl = true;
                    } else if (n8 == 6 && (n9 == 41 || Zombies.isFlagSet(7, n7))) {
                        bl = true;
                    }
                }
                if (!bl2) {
                    Zombies.takeDamage(n7, 40, -1, 0, false);
                    Plants.PLANTS[n3 + Plants.PLANT_STATE] = 5;
                    Plants.setReanimTrack(n, 354, 1);
                } else if (bl) {
                    Plants.PLANTS[n3 + Plants.PLANT_STATE] = 5;
                    Plants.setReanimTrack(n, 354, 1);
                } else {
                    Zombies.killZombie(n7, true);
                    Plants.PLANTS[n3 + Plants.PLANT_STATE] = 4;
                    Plants.setReanimTrack(n, 352, 0);
                }
            }
        } else if (n4 == 4) {
            if (PLANTS[n3 + PLANT_STATE_COUNTDOWN] <= 0 && n5 == 352 && n6 > 0) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 6;
                Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(6);
            }
        } else if (n4 == 6) {
            if (PLANTS[n3 + PLANT_STATE_COUNTDOWN] <= 0 && n6 > 0) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 7;
                Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(7);
                Plants.setReanimTrack(n, 351, 1);
            }
        } else if (n4 == 7 || n4 == 5) {
            if (PLANTS[n3 + PLANT_STATE_COUNTDOWN] <= 0 && n6 > 0) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 1;
                Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = 0;
                Plants.setReanimTrack(n, 354, 0);
            }
        } else if (n4 == 1 && (n2 = Plants.findTargetZombie(Plants.getRow(n), n, 0)) != -1) {
            Plants.PLANTS[n3 + Plants.PLANT_STATE] = 3;
            Plants.PLANTS[n3 + Plants.PLANT_STATE_COUNTDOWN] = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(3);
            Plants.setReanimTrack(n, 353, 0);
        }
    }

    static void updateSunFlowerGlow(int n, boolean bl) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = n2 + PLANT_PARAM_1;
        PLANTS[n3] = PLANTS[n3] - 1;
        int n4 = PLANTS[n2 + PLANT_PARAM_1];
        if (bl) {
            Plants.setFlag(2, n);
            Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = 24;
            n4 = 24;
        } else if (Plants.isFlagSet(2, n)) {
            if (n4 == 17) {
                Plants.hideReanimTrack(n, 347);
                Plants.hideReanimTrack(n, 348);
                Plants.hideReanimTrack(n, 350);
                Plants.showReanimTrack(n, 349);
            } else if (n4 == 11) {
                Plants.hideReanimTrack(n, 347);
                Plants.hideReanimTrack(n, 349);
                Plants.hideReanimTrack(n, 350);
                Plants.showReanimTrack(n, 348);
            } else if (n4 == 5) {
                Plants.hideReanimTrack(n, 348);
                Plants.hideReanimTrack(n, 349);
                Plants.hideReanimTrack(n, 349);
                Plants.showReanimTrack(n, 347);
                Plants.unSetFlag(2, n);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = PLANTS[n2 + PLANT_FIRE_COUNTDOWN];
            }
        } else if (!GModel.m_bDroppedLevelAward) {
            if (n4 == 17) {
                Plants.hideReanimTrack(n, 347);
                Plants.hideReanimTrack(n, 349);
                Plants.hideReanimTrack(n, 350);
                Plants.showReanimTrack(n, 348);
            } else if (n4 == 11) {
                Plants.hideReanimTrack(n, 347);
                Plants.hideReanimTrack(n, 348);
                Plants.hideReanimTrack(n, 350);
                Plants.showReanimTrack(n, 349);
            } else if (n4 == 5) {
                Plants.hideReanimTrack(n, 347);
                Plants.hideReanimTrack(n, 348);
                Plants.hideReanimTrack(n, 349);
                Plants.showReanimTrack(n, 350);
            }
        }
    }

    static void killPlant(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        if (PLANTS[n2 + PLANT_LADDER_POS] != -1) {
            GridItem.killGridItemAtPos(PLANTS[n2 + PLANT_LADDER_POS]);
        }
        if (n3 != -1) {
            int n4;
            if (n3 == 24 && (n4 = GridItem.getGridItemIndexAtPos(PLANTS[n2 + PLANT_POS])) != -1) {
                GridItem.GRID_ITEMS[n4 * GridItem.GRID_ITEM_MAX_VALS + GridItem.GRID_ITEM_PARAM_3] = -1;
            }
            Plants.PLANTS[n * Plants.PLANT_MAX_VALS + Plants.PLANT_TYPE] = -1;
            --m_nPlants;
        }
    }

    static int fireProjectile(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n * PLANT_MAX_VALS;
        char c = "\n\uffff\uffff\u0000\uffff\u0000\u0001\uffff\uffff\uffff\u0000\uffff\uffff\uffff\uffff\uffff\u0003\u0004\u0006\u0007\t\n\uffff\n\uffff\n\uffff\uffff\uffff\uffff\uffff".charAt(n3);
        int n8 = Plants.getRow(n);
        Plants.getPlantOffsets(PLANTS[n7 + PLANT_TYPE]);
        if (n3 == 20 && (n6 = PLANTS[n7 + PLANT_STATE]) == 20) {
            int n9 = PLANT_OFFSET_PROJECTILE_Y;
            PLANT_OFFSETS[n9] = PLANT_OFFSETS[n9] + 2;
        }
        if (PLANTS[n7 + PLANT_TYPE] == 21) {
            Projectiles.getProjectileOffsets(11);
        } else {
            Projectiles.getProjectileOffsets(c);
        }
        n6 = PLANTS[n7 + PLANT_X] + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_X] + PLANT_OFFSETS[PLANT_OFFSET_PROJECTILE_X];
        int n10 = PLANTS[n7 + PLANT_Y] + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_Y] + PLANT_OFFSETS[PLANT_OFFSET_PROJECTILE_Y];
        if (PLANTS[n7 + PLANT_STATE] == 20) {
            n10 -= 30;
        }
        if (n2 == -1) {
            n2 = n8;
        }
        return Projectiles.addProjectile(c, n6, n10, n2, n, n4, n5);
    }

    static void fireStarProjectiles(int n, int n2) {
        int n3 = Plants.getRow(n);
        Plants.getHitRect(n);
        Projectiles.getProjectileOffsets(7);
        int n4 = GFCanvas.getImageWidth("C\u0238\u0143\u0242\u00b0\u018c\u01c7\u0014\u009co\u0138\u0138".charAt(7)) / 2;
        int n5 = GFCanvas.getImageHeight("C\u0238\u0143\u0242\u00b0\u018c\u01c7\u0014\u009co\u0138\u0138".charAt(7)) / 2;
        int n6 = PLANT_RECT[PLANT_RECT_X] + PLANT_RECT[PLANT_RECT_W] / 2 - n4 + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_X];
        int n7 = PLANT_RECT[PLANT_RECT_Y] + PLANT_RECT[PLANT_RECT_H] / 2 - n5 + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_Y];
        if (n2 == -1) {
            n2 = n3;
        }
        int n8 = Projectiles.getSpeedFP(7, "\u0d02\u0d02\u0d02\uffff\uffff\uffff\uffff\u0d02\uffff\u0d02\u0d02\u0d02");
        int n9 = FP.fpDegToRad(122880);
        int n10 = FP.fpMul(FP.fpCos(n9), n8);
        int n11 = FP.fpMul(FP.fpSin(n9), n8);
        block7: for (int i = 0; i < 5; ++i) {
            int n12 = Projectiles.addProjectile(7, n6, n7, GModel.m_nGameBoardRows - 1, n, 0, 0);
            int n13 = Projectiles.PROJECTILE_MAX_VALS * n12;
            switch (i) {
                case 0: {
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VX] = -n8;
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VY] = 0;
                    continue block7;
                }
                case 1: {
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VX] = 0;
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VY] = -n8;
                    continue block7;
                }
                case 2: {
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VX] = 0;
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VY] = n8;
                    continue block7;
                }
                case 3: {
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VX] = n10;
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VY] = -n11;
                    continue block7;
                }
                case 4: {
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VX] = n10;
                    Projectiles.PROJECTILES[n13 + Projectiles.PROJECTILE_FP_VY] = n11;
                    continue block7;
                }
            }
        }
    }

    static int fireLobProjectile(int n, int n2, int n3, int n4) {
        int n5 = n * PLANT_MAX_VALS;
        int n6 = Plants.getRow(n);
        Projectiles.getProjectileOffsets(n3);
        Plants.getPlantOffsets(PLANTS[n5 + PLANT_TYPE]);
        int n7 = (PLANTS[n5 + PLANT_X] + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_X] + PLANT_OFFSETS[PLANT_OFFSET_PROJECTILE_X]) * 4096;
        int n8 = (PLANTS[n5 + PLANT_Y] + Projectiles.PROJECTILE_OFFSETS[Projectiles.PROJECTILE_OFFSET_Y] + PLANT_OFFSETS[PLANT_OFFSET_PROJECTILE_Y]) * 4096;
        Zombies.getHitRect(n2);
        int n9 = Zombies.getZombieLeadFPX(n2, 72);
        int n10 = Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y] * 4096;
        int n11 = Math.abs(n7 - n9);
        int n12 = Math.abs(n8 - n10);
        int n13 = FP.fpDiv(n11, Projectiles.PROJECTILE_LOB_SPEED);
        int n14 = FP.fpDiv(n12, Projectiles.PROJECTILE_LOB_SPEED) + Projectiles.PROJECTILE_LOB_SPEED_OFFSET_Y;
        int n15 = Projectiles.addProjectile(n3, FP.toInt(n7), FP.toInt(n8), n6, n, 2, n4);
        int n16 = Projectiles.PROJECTILE_MAX_VALS * n15;
        Projectiles.PROJECTILES[n16 + Projectiles.PROJECTILE_FP_VX] = n13;
        Projectiles.PROJECTILES[n16 + Projectiles.PROJECTILE_FP_VY] = n14;
        return n15;
    }

    static int getRow(int n) {
        return PLANTS[n * PLANT_MAX_VALS + PLANT_POS] / 9;
    }

    static boolean getHitRect(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        short s = (short)"\u0000\u0001\u0002\u0003\u0004\u0006\u0007\b\t\n\u000b\f\u0005\u000e\r\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001a\u001a\u001b\u001c".charAt(n3);
        if (s == -1) {
            return false;
        }
        Plants.PLANT_RECT[Plants.PLANT_RECT_X] = PLANTS[n2 + PLANT_X] + (short)"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0002\u0005\u0000\n\r\u000f\u0000\u0000\u0003\u0005\u0003\u0003\u0003\u0003\u0000\u0000".charAt(s);
        Plants.PLANT_RECT[Plants.PLANT_RECT_Y] = PLANTS[n2 + PLANT_Y] + (short)"\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0005\b\u0003\u0000\ufff3\u000f\b\u0005\u0005\u0005\u0005\u0005\u0005\u0005\u0005\u0005\u0005\u0000\u0000".charAt(s);
        Plants.PLANT_RECT[Plants.PLANT_RECT_W] = (short)"\u0014\u001e\u0014\u0014\u0014\u0014\u0014\u0014\u0014\u0011\u0014\u0014\u0014\u0014\u001e\u001e\u0014\u0014\u0014\u0014\u0014\u0017\u0017\u0017\u0017\u0017\u0017\u0014\u0014".charAt(s);
        Plants.PLANT_RECT[Plants.PLANT_RECT_H] = (short)"\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001c#\u001e\u001e\u001e\u001e\u001e\u0019\u0019\u0019\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e".charAt(s);
        return true;
    }

    static boolean getAttackRect(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        short s = (short)"\u0007\u0001\uffff\u0007\uffff\u0007\u0007\uffff\u0000\u0002\u0007\u0003\uffff\u0006\u0005\uffff\u0007\u0007\u0007\u0007\u000b\b\uffff\t\uffff\u0007\uffff\uffff\uffff\uffff\uffff".charAt(n3);
        if (s == -1) {
            Util.resetArray(PLANT_RECT, 0);
            return false;
        }
        Plants.PLANT_RECT[Plants.PLANT_RECT_X] = PLANTS[n2 + PLANT_X] + (short)"\u0000\u000f\u001e\u0000\u0005\u000f\n\u0000\u0018\u0018\u0018\u0000".charAt(s);
        Plants.PLANT_RECT[Plants.PLANT_RECT_Y] = PLANTS[n2 + PLANT_Y] + (short)"\u0000\u0003\u0005\u0003\u0003\u0000\ufff3\u0000\u0005\u0005\u0005\u0000".charAt(s);
        Plants.PLANT_RECT[Plants.PLANT_RECT_W] = (short)"\u001c\u0014\u00122\u0014\u000f\u000f\u010eNvv\u010e".charAt(s);
        Plants.PLANT_RECT[Plants.PLANT_RECT_H] = (short)"\u001e\u001e!\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e\u001e".charAt(s);
        return true;
    }

    static int findTargetZombie(int n, int n2, int n3) {
        if (Zombies.m_nZombies <= 0) {
            return -1;
        }
        int n4 = n2 * PLANT_MAX_VALS;
        int n5 = PLANTS[n4 + PLANT_TYPE];
        short s = (short)"\u0001\u0002\u0000\u0001\u0004\u0001\u0001\u0002\u0002\uffff\u0001\u0003\u0002\u0003\u0003\u0004\u0001\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0003\u0001\u0002\u0003\u0002\u0002\u0002".charAt(n5);
        int n6 = Plants.getDamageRangeFlags(n2, n3);
        if (n == -1) {
            n = Plants.getRow(n2);
        }
        Plants.getAttackRect(n2);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 270;
        for (int i = 0; i < 100 && n7 < Zombies.m_nZombies; ++i) {
            if (!Zombies.isZombieAtIndex(i)) continue;
            n11 = Zombies.ZOMBIE_MAX_VALS * i;
            n9 = Zombies.ZOMBIES[n11 + Zombies.ZOMBIE_STATE];
            if (n9 == 38) {
                ++n7;
                continue;
            }
            n8 = Zombies.ZOMBIES[n11 + Zombies.ZOMBIE_ROW];
            n10 = Zombies.ZOMBIES[n11 + Zombies.ZOMBIE_TYPE];
            boolean bl = true;
            if (n10 == 20) {
                bl = n9 == 91 || n9 == 92 || n9 == 93 || n9 == 94 || n9 == 95;
            } else if (n10 == 21 || n10 == 22) {
                if (n5 == 16 || n5 == 17 || n5 == 18) {
                    bl = false;
                }
            } else if (n10 == 16 && n5 == 11) {
                bl = false;
            }
            if (n8 == n && bl) {
                int n17;
                if (!Zombies.bEffectedByDamage(i, n6)) {
                    ++n7;
                    continue;
                }
                Zombies.getHitRect(i);
                if (n5 == 9) {
                    n17 = PLANT_RECT[PLANT_RECT_W];
                    if (Zombies.isFlagSet(2, i)) {
                        n17 += Cursor.getCursorGameW();
                    }
                    if ((n12 = CollisionHandler.getRectOverlap(Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H], PLANT_RECT[PLANT_RECT_X], PLANT_RECT[PLANT_RECT_Y], n17, PLANT_RECT[PLANT_RECT_H])) < 0) {
                        ++n7;
                        continue;
                    }
                } else if (n5 == 11) {
                    n17 = PLANT_RECT[PLANT_RECT_W];
                    if (n9 == 41 || n9 == 78) continue;
                    if (Zombies.isFlagSet(2, i)) {
                        n17 += Cursor.getCursorGameW();
                    }
                    if ((n12 = CollisionHandler.getRectOverlap(Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H], PLANT_RECT[PLANT_RECT_X], PLANT_RECT[PLANT_RECT_Y], n17, PLANT_RECT[PLANT_RECT_H])) < 0 || !Zombies.isFlagSet(4, i)) {
                        ++n7;
                        continue;
                    }
                    if (i == PLANTS[n4 + PLANT_TARGET_ZOMBIE_ID]) {
                        return i;
                    }
                } else if (n5 == 1) {
                    if (!Zombies.isFlagSet(4, i) || !Zombies.isFlagSet(15, i)) {
                        ++n7;
                        continue;
                    }
                    n12 = CollisionHandler.getRectOverlap(Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H], PLANT_RECT[PLANT_RECT_X], PLANT_RECT[PLANT_RECT_Y], PLANT_RECT[PLANT_RECT_W], PLANT_RECT[PLANT_RECT_H]);
                    if (n12 < 0) {
                        ++n7;
                        continue;
                    }
                } else if (s == 2) {
                    if (n5 == 8 && !Zombies.isFlagSet(4, i)) {
                        ++n7;
                        continue;
                    }
                    n12 = CollisionHandler.getRectOverlap(Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H], PLANT_RECT[PLANT_RECT_X], PLANT_RECT[PLANT_RECT_Y], PLANT_RECT[PLANT_RECT_W], PLANT_RECT[PLANT_RECT_H]);
                    if (n12 < 0) {
                        ++n7;
                        continue;
                    }
                } else {
                    if (s == 1 && Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] > n16) {
                        ++n7;
                        continue;
                    }
                    n12 = CollisionHandler.getRectOverlap(Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W], Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H], PLANT_RECT[PLANT_RECT_X], PLANT_RECT[PLANT_RECT_Y], PLANT_RECT[PLANT_RECT_W], PLANT_RECT[PLANT_RECT_H]);
                    if (n12 < 0) {
                        ++n7;
                        continue;
                    }
                }
                if ((n14 = n16 - Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X]) > n15) {
                    n15 = n14;
                    n13 = i;
                }
            }
            ++n7;
        }
        return n13;
    }

    static int findStarFruitTargetZombie(int n, int n2) {
        if (Zombies.m_nZombies <= 0) {
            return -1;
        }
        if (n == -1) {
            n = Plants.getRow(n2);
        }
        int n3 = Plants.getDamageRangeFlags(n2, 0);
        int n4 = Projectiles.getSpeedFP(7, "\u0d02\u0d02\u0d02\uffff\uffff\uffff\uffff\u0d02\uffff\u0d02\u0d02\u0d02");
        Plants.getHitRect(n2);
        int n5 = (PLANT_RECT[PLANT_RECT_X] + PLANT_RECT[PLANT_RECT_W] / 2) * 4096;
        int n6 = (PLANT_RECT[PLANT_RECT_Y] + PLANT_RECT[PLANT_RECT_H] / 2) * 4096;
        int n7 = 0;
        int n8 = GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 270;
        for (int i = 0; i < 100 && n7 < Zombies.m_nZombies; ++i) {
            if (!Zombies.isZombieAtIndex(i)) continue;
            int n9 = Zombies.ZOMBIE_MAX_VALS * i;
            if (Zombies.ZOMBIES[n9 + Zombies.ZOMBIE_STATE] == 38) {
                ++n7;
                continue;
            }
            if (!Zombies.bEffectedByDamage(i, n3)) {
                ++n7;
                continue;
            }
            int n10 = Zombies.ZOMBIES[n9 + Zombies.ZOMBIE_ROW];
            Zombies.getHitRect(i);
            if (Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] > n8) {
                ++n7;
                continue;
            }
            if (n10 == n && PLANT_RECT[PLANT_RECT_X] > Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W]) {
                return i;
            }
            int n11 = (Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_X] + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W] / 2) * 4096 - n5;
            int n12 = (Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_Y] + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_H] / 2) * 4096;
            int n13 = n12 - n6;
            int n14 = FP.toInt(FP.fpDiv(Vector.length(n11, n13), n4));
            int n15 = Zombies.getZombieLeadFPX(i, n14);
            if (n5 < n15 + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W] * 4096 && n5 > n15) {
                return i;
            }
            n11 = n15 + Zombies.ZOMBIE_RECT[Zombies.ZOMBIE_RECT_W] * 4096 / 2 - n5;
            int n16 = FP.toInt(FP.fpRadToDeg(FP.fpAtan2(n13, n11)));
            if (Math.abs(n10 - n) < 2) {
                if (n16 >= 20 && n16 <= 40) {
                    return i;
                }
                if (n16 <= -25 && n16 >= -45) {
                    return i;
                }
            } else {
                if (n16 >= 25 && n16 <= 35) {
                    return i;
                }
                if (n16 <= -28 && n16 >= -38) {
                    return i;
                }
            }
            ++n7;
        }
        return -1;
    }

    static void takeDamage(int n, int n2, boolean bl) {
        int n3 = n * PLANT_MAX_VALS;
        int n4 = n3 + PLANT_HEALTH;
        PLANTS[n4] = PLANTS[n4] - n2;
        Plants.PLANTS[n3 + Plants.PLANT_RECENT_EATEN_COUNTDOWN] = 9;
        int n5 = PLANTS[n3 + PLANT_TYPE];
        if (PLANTS[n3 + PLANT_HEALTH] <= 0) {
            if ((short)"\u0001\u0002\u0000\u0001\u0004\u0001\u0001\u0002\u0002\uffff\u0001\u0003\u0002\u0003\u0003\u0004\u0001\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0003\u0001\u0002\u0003\u0002\u0002\u0002".charAt(n5) == 2) {
                if (n5 == 8) {
                    if (PLANTS[n3 + PLANT_STATE] == 9 || PLANTS[n3 + PLANT_STATE] == 10) {
                        Plants.updateExploding(n, true);
                    }
                } else {
                    Plants.updateExploding(n, true);
                }
            }
            Plants.killPlant(n);
            return;
        }
        if (PLANTS[n3 + PLANT_TYPE] == 4 || PLANTS[n3 + PLANT_TYPE] == 15) {
            Plants.damageMyNuts(n);
        }
    }

    static void damageMyNuts(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        int n4 = PLANTS[n2 + PLANT_HEALTH];
        int n5 = PLANTS[n2 + PLANT_REANIM_CURR_TRACK_ID];
        if (n3 == 4) {
            if (n4 < (short)"\u012c\u012c\u012c\u012c\u0fa0\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u1f40\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c".charAt(n3) / 3 && n5 == 389) {
                Plants.setReanimTrack(n, 388, 0);
            } else if (n4 < (short)"\u012c\u012c\u012c\u012c\u0fa0\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u1f40\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c".charAt(n3) * 2 / 3 && n5 == 391) {
                Plants.setReanimTrack(n, 389, 0);
            }
        } else if (n3 == 15) {
            if (n4 < (short)"\u012c\u012c\u012c\u012c\u0fa0\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u1f40\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c".charAt(n3) / 3 && n5 == 395) {
                Plants.setReanimTrack(n, 396, 0);
            } else if (n4 < (short)"\u012c\u012c\u012c\u012c\u0fa0\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u1f40\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c\u012c".charAt(n3) * 2 / 3 && n5 == 397) {
                Plants.setReanimTrack(n, 395, 0);
            }
        }
    }

    static int getLeftMostFreeBoardPosition(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        long l = GModel.m_lBoardGridAsDirt;
        for (n3 = 0; n3 < MAX_NUM_PLANTS && n4 < m_nPlants; ++n3) {
            if (!(bl || (n2 = Plants.getPlantAttribute(n3, PLANT_TYPE)) != 30 && n2 != 29)) {
                int n6 = Plants.getPlantAttribute(n3, PLANT_POS);
                Plants.getPlantsOnLawn(n6);
                if (PLANT_POS_TYPES[PLANT_POS_TYPE_NORMAL_PLANT] == -1) continue;
            }
            if (!Plants.isPlantAtIndex(n3)) continue;
            l |= 1L << PLANTS[n3 * PLANT_MAX_VALS + PLANT_POS];
            ++n4;
        }
        for (n3 = 0; n3 < 9; ++n3) {
            if (n >= 0) {
                n5 = n * 9 + n3;
                if ((l & 1L << n5) != 0L) continue;
                return n5;
            }
            for (n2 = 0; n2 < GModel.m_nGameBoardRows; ++n2) {
                if (bl2 && GModel.PLANT_ROW[n2] != 3 || (l & 1L << (n5 = n2 * 9 + n3)) != 0L) continue;
                return n5;
            }
        }
        return 0;
    }

    static int getPlantsTypeCount(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < MAX_NUM_PLANTS && n2 < m_nPlants; ++i) {
            if (!Plants.isPlantAtIndex(i)) continue;
            if (PLANTS[i * PLANT_MAX_VALS + PLANT_TYPE] == n) {
                ++n3;
            }
            ++n2;
        }
        return n3;
    }

    static void squish(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_TYPE];
        int n4 = PLANTS[n2 + PLANT_STATE];
        short s = (short)"\u0001\u0002\u0000\u0001\u0004\u0001\u0001\u0002\u0002\uffff\u0001\u0003\u0002\u0003\u0003\u0004\u0001\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0003\u0001\u0002\u0003\u0002\u0002\u0002".charAt(n3);
        if (n3 == 8) {
            if (n4 == 9 || n4 == 10) {
                Plants.updateExploding(n, true);
            } else {
                Plants.killPlant(n);
            }
            return;
        }
        if (s == 2) {
            Plants.updateExploding(n, true);
            return;
        }
        if (n3 == 11 && n4 != 0) {
            return;
        }
        Plants.killPlant(n);
    }

    static int getDamageRangeFlags(int n, int n2) {
        int n3 = n * PLANT_MAX_VALS;
        int n4 = PLANTS[n3 + PLANT_TYPE];
        if (n4 == 20) {
            if (n2 == 1) {
                return 1;
            }
            return 2;
        }
        if (n4 == 7 || n4 == 12 || n4 == 28) {
            return 63;
        }
        if (n4 == 18 || n4 == 16 || n4 == 17) {
            return 5;
        }
        if (n4 == 8) {
            return 37;
        }
        if (n4 == 11) {
            return 5;
        }
        if (n4 == 21 || n4 == 23 || n4 == 9) {
            return 1;
        }
        if (n4 == 1) {
            return 4;
        }
        return 1;
    }

    static void updateCactus(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_STATE];
        if (PLANTS[n2 + PLANT_PROJECTILE_DELAY] != -2) {
            return;
        }
        if (n3 == 19) {
            if (PLANTS[n2 + PLANT_REANIM_LOOP_COUNT] > 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 20;
                Plants.setReanimTrack(n, 449, 0);
                Plants.PLANTS[n2 + Plants.PLANT_FIRE_COUNTDOWN] = 1;
            }
        } else if (n3 == 20) {
            int n4 = Plants.findTargetZombie(Plants.getRow(n), n, 0);
            if (n4 == -1) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 21;
                Plants.setReanimTrack(n, 451, 1);
            }
        } else if (n3 == 21) {
            if (PLANTS[n2 + PLANT_REANIM_LOOP_COUNT] > 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 22;
                Plants.setReanimTrack(n, 446, 1);
            }
        } else {
            int n5 = Plants.findTargetZombie(Plants.getRow(n), n, 0);
            if (n5 != -1) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 19;
                Plants.setReanimTrack(n, 448, 1);
            }
        }
    }

    static void updateSunShroom(int n) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = PLANTS[n2 + PLANT_STATE];
        if (n3 == 23) {
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] == 0) {
                Plants.setReanimTrack(n, 467, 1);
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 24;
            }
            Plants.updateProduction(n, 2);
        } else if (n3 == 24) {
            if (PLANTS[n2 + PLANT_REANIM_LOOP_COUNT] > 0) {
                Plants.PLANTS[n2 + Plants.PLANT_STATE] = 25;
                Plants.setReanimTrack(n, 466, 0);
            }
        } else {
            Plants.updateProduction(n, 1);
        }
    }

    static void updateSunShroomGlow(int n, boolean bl) {
        int n2 = n * PLANT_MAX_VALS;
        int n3 = n2 + PLANT_PARAM_1;
        PLANTS[n3] = PLANTS[n3] - 1;
        int n4 = PLANTS[n2 + PLANT_PARAM_1];
        if (bl) {
            Plants.setFlag(2, n);
            Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = 27;
            n4 = 27;
        } else if (Plants.isFlagSet(2, n)) {
            if (n4 == 17) {
                Plants.hideReanimTrack(n, 471);
                Plants.hideReanimTrack(n, 473);
                Plants.showReanimTrack(n, 472);
            } else if (n4 == 8) {
                Plants.hideReanimTrack(n, 472);
                Plants.hideReanimTrack(n, 473);
                Plants.showReanimTrack(n, 471);
                Plants.unSetFlag(2, n);
                Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = PLANTS[n2 + PLANT_FIRE_COUNTDOWN];
            }
        } else if (n4 == 17) {
            Plants.hideReanimTrack(n, 471);
            Plants.hideReanimTrack(n, 473);
            Plants.showReanimTrack(n, 472);
        } else if (n4 == 8) {
            Plants.hideReanimTrack(n, 471);
            Plants.hideReanimTrack(n, 472);
            Plants.showReanimTrack(n, 473);
        }
    }

    static void updateGraveBuster(int n) {
        int n2 = n * PLANT_MAX_VALS;
        if (PLANTS[n2 + PLANT_STATE] == 26) {
            if (PLANTS[n2 + PLANT_REANIM_LOOP_COUNT] > 0) {
                Plants.setState(n, 27, true);
                Plants.setReanimTrack(n, 480, 0);
            }
        } else if (PLANTS[n2 + PLANT_STATE] == 27) {
            short s = (short)"\uffff\uffff\u0012\u0011\uffff\uffff\u02d0\uffff\u010e\u0012\uffff$\u0012\t\t\uffff\t\uffff\u0012\uffff\uffff\uffff\uffff\u0870\uffff\uffff\uffffH\uffff\uffff\uffff(\uffff\u001b\uffff\uffff\uffff\uffff\uffff\uffff\u001b\uffff\u00a2\r$$\t\uffff\uffff\uffff\uffff$\u001b\t\uffff\u0012\uffff2\u0012\uffff\u0000\u0000\r-\u0012\u0012\u0012\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffffP\u001e\uffff(\u000fPF\uffff\u001ex\uffff\uffff\uffff\n\u0014\uffff\uffff\n\u0014\uffff\uffff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(27);
            Plants.PLANTS[n2 + Plants.PLANT_PARAM_1] = FP.toInt(FP.fpAnimateCurve(s, 0, PLANTS[n2 + PLANT_STATE_COUNTDOWN], 0, 98304, 1));
            if (Util.GetRandom(3) == 0) {
                GCanvasController.doGraveDiggerEat(n);
            }
            if (PLANTS[n2 + PLANT_STATE_COUNTDOWN] <= 0) {
                GridItem.killGridItemAtPos(PLANTS[n2 + PLANT_POS]);
                Plants.killPlant(n);
            }
        }
    }

    static void updateScaredyShroom(int n) {
        int n2;
        int n3 = n * PLANT_MAX_VALS;
        if (PLANTS[n3 + PLANT_PROJECTILE_DELAY] != -2) {
            return;
        }
        boolean bl = false;
        if (Zombies.m_nZombies > 0) {
            Plants.getHitRect(n);
            n2 = PLANT_RECT[PLANT_RECT_X] + PLANT_RECT[PLANT_RECT_W] / 2;
            int n4 = PLANT_RECT[PLANT_RECT_Y] + PLANT_RECT[PLANT_RECT_H] / 2;
            int n5 = Plants.getRow(n);
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int i = 0; i < 100 && n7 < Zombies.m_nZombies; ++i) {
                n8 = Zombies.ZOMBIE_MAX_VALS * i;
                if (!Zombies.isZombieAtIndex(i)) continue;
                n6 = Zombies.ZOMBIES[n8 + Zombies.ZOMBIE_ROW] - n5;
                if (Zombies.bIsDeadOrDying(i) || Zombies.isFlagSet(12, i)) {
                    ++n7;
                    continue;
                }
                if (n6 > 1 || n6 < -1) {
                    ++n7;
                    continue;
                }
                if (!CollisionHandler.getCircleRectOverlap(n2, n4, 36, i)) {
                    ++n7;
                    continue;
                }
                bl = true;
                break;
            }
        }
        if ((n2 = PLANTS[n3 + PLANT_STATE]) == 1) {
            if (bl) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 28;
                Plants.setReanimTrack(n, 492, 1);
            }
        } else if (n2 == 28) {
            if (PLANTS[n3 + PLANT_REANIM_LOOP_COUNT] > 0) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 29;
                Plants.setReanimTrack(n, 491, 0);
            }
        } else if (n2 == 29) {
            if (!bl) {
                Plants.PLANTS[n3 + Plants.PLANT_STATE] = 30;
                Plants.setReanimTrack(n, 490, 1);
            }
        } else if (n2 == 30 && PLANTS[n3 + PLANT_REANIM_LOOP_COUNT] > 0) {
            Plants.PLANTS[n3 + Plants.PLANT_STATE] = 1;
            Plants.setReanimTrack(n, 494, 0);
        }
        if (PLANTS[n3 + PLANT_STATE] != 1) {
            Plants.PLANTS[n3 + Plants.PLANT_FIRE_COUNTDOWN] = (short)"$\u001b\u01c2$\uffff--\u001b\u01c2\u02d0-\uffff\u001b\u001b\uffff\uffff???$$$\u01c2$$$\u0012\u0012\u0012\uffff\uffff".charAt(25);
        }
    }

    static void updateIceShroom(int n) {
        int n2 = n * PLANT_MAX_VALS;
        if (PLANTS[n2 + PLANT_STATE] == 2) {
            return;
        }
        Plants.setState(n, 2, true);
    }

    static void freezeZombies(int n) {
        int n2 = 0;
        for (int i = 0; i < 100 && n2 < Zombies.m_nZombies; ++i) {
            if (!Zombies.isZombieAtIndex(i)) continue;
            int n3 = Zombies.ZOMBIE_MAX_VALS * i;
            int n4 = Zombies.ZOMBIES[n3 + Zombies.ZOMBIE_TYPE];
            if (n4 == 21) {
                Zombies.killZombie(i, false);
                continue;
            }
            if (n4 == 22) continue;
            Zombies.setFreezeZombie(i);
        }
        GModel.m_nIceTrapCounter = 54;
        GCanvasController.doIceShroomExplosion(n);
    }

    static void updateDoomShroom(int n) {
        int n2 = n * PLANT_MAX_VALS;
        if (PLANTS[n2 + PLANT_STATE] == 2) {
            return;
        }
        Plants.setState(n, 2, true);
        Plants.setReanimTrack(n, 508, 1);
    }

    static void updateLilyPad(int n) {
        int n2 = n * PLANT_MAX_VALS;
    }

    static void killAllPlantsAtDoomPos(int n) {
        int n2 = PLANTS[n * PLANT_MAX_VALS + PLANT_POS];
        int n3 = 0;
        for (int i = 0; i < MAX_NUM_PLANTS && n3 < m_nPlants; ++i) {
            if (i == n || !Plants.isPlantAtIndex(i) || PLANTS[i * PLANT_MAX_VALS + PLANT_POS] != n2) continue;
            Plants.killPlant(i);
        }
    }

    static int countEmptyUnderplants(int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < MAX_NUM_PLANTS && n2 < m_nPlants; ++i) {
            if (!Plants.isPlantAtIndex(i)) continue;
            int n4 = PLANT_MAX_VALS * i;
            int n5 = PLANTS[n4 + PLANT_POS];
            Plants.getPlantsOnLawn(n5);
            if (PLANT_POS_TYPES[PLANT_POS_TYPE_UNDER_PLANT] == n && PLANT_POS_TYPES[PLANT_POS_TYPE_NORMAL_PLANT] == -1) {
                ++n3;
            }
            ++n2;
        }
        return n3;
    }

    static {
        PLANT_OFFSET_X = 0;
        PLANT_OFFSET_Y = PLANT_OFFSET_X + 1;
        PLANT_OFFSET_DRAW_X = PLANT_OFFSET_Y + 1;
        PLANT_OFFSET_DRAW_Y = PLANT_OFFSET_DRAW_X + 1;
        PLANT_OFFSET_SHADOW_X = PLANT_OFFSET_DRAW_Y + 1;
        PLANT_OFFSET_SHADOW_Y = PLANT_OFFSET_SHADOW_X + 1;
        PLANT_OFFSET_PROJECTILE_X = PLANT_OFFSET_SHADOW_Y + 1;
        PLANT_OFFSET_PROJECTILE_Y = PLANT_OFFSET_PROJECTILE_X + 1;
        PLANT_OFFSET_MAX_VALS = PLANT_OFFSET_PROJECTILE_Y + 1;
        PLANT_OFFSETS = new int[PLANT_OFFSET_MAX_VALS];
        PLANT_POS_TYPE_UNDER_PLANT = 0;
        PLANT_POS_TYPE_PUMPKIN_PLANT = PLANT_POS_TYPE_UNDER_PLANT + 1;
        PLANT_POS_TYPE_FLYING_PLANT = PLANT_POS_TYPE_PUMPKIN_PLANT + 1;
        PLANT_POS_TYPE_NORMAL_PLANT = PLANT_POS_TYPE_FLYING_PLANT + 1;
        PLANT_POS_MAX_TYPES = PLANT_POS_TYPE_NORMAL_PLANT + 1;
        PLANT_POS_TYPES = new int[PLANT_POS_MAX_TYPES];
        PLANT_POS_INDEXES = new int[PLANT_POS_MAX_TYPES];
        PLANT_RECT = new int[4];
        PLANT_RECT_X = 0;
        PLANT_RECT_Y = 1;
        PLANT_RECT_W = 2;
        PLANT_RECT_H = 3;
    }
}

