/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ReanimScaler
implements GameConstants,
Constants,
ConstantsTFC,
ReanimAttributes,
ConstantsReanim {
    static int REANIM_INDEX = 0;
    static int REANIM_FRAME = REANIM_INDEX + 1;
    static int REANIM_TRACK_GLOBAL_INDEX = REANIM_FRAME + 1;
    static int REANIM_CURR_TRACK_ID = REANIM_TRACK_GLOBAL_INDEX + 1;
    static int REANIM_FPS = REANIM_CURR_TRACK_ID + 1;
    static int REANIM_START_TRACK_INDEX = REANIM_FPS + 1;
    static int REANIM_HIDDEN_TRACKS = REANIM_START_TRACK_INDEX + 1;
    static int REANIM_LOOP_TYPE = REANIM_HIDDEN_TRACKS + 1;
    static int REANIM_LOOP_COUNT = REANIM_LOOP_TYPE + 1;
    static int REANIM_FP_FRAMES_PER_TICK = REANIM_LOOP_COUNT + 1;
    static int REANIM_FP_TICKS_COUNTER = REANIM_FP_FRAMES_PER_TICK + 1;
    static int MAX_VALS = REANIM_FP_TICKS_COUNTER + 1;
    static int[] SCALED_REANIMS = new int[MAX_VALS];
    static final Image[] SCALED_IMGS = new Image[25];
    static int m_nImgsCount;
    static Graphics m_Graphics;
    static int m_nScalePercentX;
    static int m_nScalePercentY;
    static final int COLOUR_MAGENTA_FULL_ALPHA = 0xFF00FF;
    static int RECT_X;
    static int RECT_Y;
    static int RECT_W;
    static int RECT_H;
    static final int[] RECT;

    static void resetVars() {
        m_nImgsCount = 0;
        m_Graphics = null;
        Util.resetArray(SCALED_REANIMS, -1);
        for (int i = 0; i < SCALED_IMGS.length; ++i) {
            ReanimScaler.SCALED_IMGS[i] = null;
        }
        m_nScalePercentX = -1;
        m_nScalePercentY = -1;
    }

    static int scaleReanim(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return ReanimScaler.scaleReanim(n, n2, n3, n4, n5, n6, n7, 100);
    }

    static int filterReanim(int n, int n2, int n3, int n4, int n5) {
        return ReanimScaler.scaleReanim(n, n2, n3, n4, -1, -1, -1, n5);
    }

    static int scaleReanim(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (m_nImgsCount == SCALED_IMGS.length - 1) {
            return -1;
        }
        boolean bl = n6 != -1 && n5 != -1;
        ReanimScaler.loadReanim(n, n2, n3, n4, n5, n6);
        ReanimScaler.getReanimRect(RECT);
        if (bl) {
            ReanimScaler.getScalePercent(RECT, n5, n6);
        }
        int[] nArray = ReanimScaler.drawReanimToBuffer(m_Graphics, RECT, n8);
        ReanimScaler.SCALED_IMGS[ReanimScaler.m_nImgsCount] = bl ? Reanim.scaleImage(nArray, RECT[RECT_W], RECT[RECT_H], m_nScalePercentX * 4096, m_nScalePercentY * 4096, n7) : Image.createRGBImage((int[])nArray, (int)RECT[RECT_W], (int)RECT[RECT_H], (boolean)true);
        return ++m_nImgsCount;
    }

    static void loadReanim(int n, int n2, int n3, int n4, int n5, int n6) {
        Reanim.loadReanim(n, n2);
        ReanimScaler.SCALED_REANIMS[ReanimScaler.REANIM_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[0];
        ReanimScaler.SCALED_REANIMS[ReanimScaler.REANIM_FRAME] = Reanim.REANIM_LOADED_TEMP_VALS[1];
        ReanimScaler.SCALED_REANIMS[ReanimScaler.REANIM_START_TRACK_INDEX] = Reanim.REANIM_LOADED_TEMP_VALS[4];
        ReanimScaler.SCALED_REANIMS[ReanimScaler.REANIM_HIDDEN_TRACKS] = n3;
    }

    static void getScalePercent(int[] nArray, int n, int n2) {
        m_nScalePercentX = Util.getPercentage(n, nArray[RECT_W], -1);
        m_nScalePercentY = Util.getPercentage(n2, nArray[RECT_H], -1);
    }

    static void getReanimRect(int[] nArray) {
        int n = SCALED_REANIMS[REANIM_INDEX];
        int n2 = SCALED_REANIMS[REANIM_START_TRACK_INDEX];
        int n3 = SCALED_REANIMS[REANIM_HIDDEN_TRACKS];
        int n4 = SCALED_REANIMS[REANIM_FRAME];
        int n5 = n * 3;
        int n6 = Reanim.REANIM_DATA[n5 + 2];
        int n7 = 999;
        int n8 = 999;
        int n9 = -999;
        int n10 = -999;
        for (int i = 0; i < n6; ++i) {
            int n11;
            int n12 = i * 5;
            int n13 = Reanim.TRACK_ATTRIBS[n][n12 + 4];
            if (n13 == 0 && !Reanim.isTrackHidden(n11 = Reanim.TRACK_ATTRIBS[n][n12 + 0], n2, n3)) {
                int n14 = n4 * 9;
                int n15 = Reanim.nReanims[n].nTracks[n11].nTrackFrames[n4].TRACK_IMG;
                if (n15 >= 0) {
                    int n16 = FP.toInt(Reanim.nReanims[n].nTracks[n11].nTrackFrames[n4].TRACK_FP_X);
                    int n17 = FP.toInt(Reanim.nReanims[n].nTracks[n11].nTrackFrames[n4].TRACK_FP_Y);
                    int n18 = Reanim.TRACK_IMGS[n15].getWidth();
                    int n19 = Reanim.TRACK_IMGS[n15].getHeight();
                    if (n16 < n7) {
                        n7 = n16;
                    }
                    if (n17 < n8) {
                        n8 = n17;
                    }
                    if (n16 + n18 > n9) {
                        n9 = n16 + n18;
                    }
                    if (n17 + n19 > n10) {
                        n10 = n17 + n19;
                    }
                }
            }
            nArray[ReanimScaler.RECT_X] = n7;
            nArray[ReanimScaler.RECT_Y] = n8;
            nArray[ReanimScaler.RECT_W] = n9 - n7;
            nArray[ReanimScaler.RECT_H] = n10 - n8;
        }
    }

    static int[] drawReanimToBuffer(Graphics graphics, int[] nArray, int n) {
        int n2 = SCALED_REANIMS[REANIM_INDEX];
        int n3 = SCALED_REANIMS[REANIM_START_TRACK_INDEX];
        int n4 = SCALED_REANIMS[REANIM_HIDDEN_TRACKS];
        int n5 = SCALED_REANIMS[REANIM_FRAME];
        int n6 = n2 * 3;
        int n7 = Reanim.REANIM_DATA[n6 + 2];
        int[] nArray2 = new int[nArray[RECT_W] * nArray[RECT_H]];
        Util.resetArray(nArray2, 0xFF00FF);
        for (int i = 0; i < n7; ++i) {
            int n8;
            int n9 = i * 5;
            int n10 = Reanim.TRACK_ATTRIBS[n2][n9 + 4];
            if (n10 != 0 || Reanim.isTrackHidden(n8 = Reanim.TRACK_ATTRIBS[n2][n9 + 0], n3, n4)) continue;
            int n11 = n5 * 9;
            int n12 = Reanim.nReanims[n2].nTracks[n8].nTrackFrames[n5].TRACK_IMG;
            if (n12 < 0) continue;
            int n13 = FP.toInt(Reanim.nReanims[n2].nTracks[n8].nTrackFrames[n5].TRACK_FP_X) - nArray[RECT_X];
            int n14 = FP.toInt(Reanim.nReanims[n2].nTracks[n8].nTrackFrames[n5].TRACK_FP_Y) - nArray[RECT_Y];
            ReanimScaler.drawImageToRGBArray(graphics, Reanim.TRACK_IMGS[n12], n13, n14, nArray2, nArray[RECT_W], nArray[RECT_H]);
        }
        ReanimScaler.modifyAlphaOpacity(nArray2, n);
        return nArray2;
    }

    static void modifyAlphaOpacity(int[] nArray, int n) {
        if (n != 4096) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = ((nArray[i] & 0xFF000000) >>> 24) * 4096;
                n2 = Math.min(FP.toInt(FP.fpMul(n, n2)), 255);
                nArray[i] = n2 << 24 & 0xFF000000 | nArray[i] & 0xFFFFFF;
            }
        }
    }

    static void drawImageToRGBArray(Graphics graphics, Image image, int n, int n2, int[] nArray, int n3, int n4) {
        int n5 = image.getWidth();
        int n6 = image.getHeight();
        int[] nArray2 = new int[n5 * n6];
        image.getRGB(nArray2, 0, n5, 0, 0, n5, n6);
        for (int i = 0; i < n6; ++i) {
            int n7 = n2 + i;
            for (int j = 0; j < n5; ++j) {
                int n8 = n + j;
                nArray[n7 * n3 + n8] = ReanimScaler.blendPixels(nArray[n7 * n3 + n8], nArray2[i * n5 + j]);
            }
        }
    }

    static int blendPixels(int n, int n2) {
        int n3 = ((n2 & 0xFF000000) >>> 24) * 4096;
        int n4 = ((n & 0xFF000000) >>> 24) * 4096;
        if (n3 == 0) {
            return n;
        }
        if (n4 == 0) {
            return n2;
        }
        int n5 = ((n2 & 0xFF0000) >>> 16) * 4096;
        int n6 = ((n2 & 0xFF00) >>> 8) * 4096;
        int n7 = (n2 & 0xFF) * 4096;
        int n8 = ((n & 0xFF0000) >>> 16) * 4096;
        int n9 = ((n & 0xFF00) >>> 8) * 4096;
        int n10 = (n & 0xFF) * 4096;
        int n11 = FP.fpDiv(n3, 1044480);
        int n12 = n8 + FP.fpMul(n11, n5 - n8);
        int n13 = n9 + FP.fpMul(n11, n6 - n9);
        int n14 = n10 + FP.fpMul(n11, n7 - n10);
        int n15 = Math.min(FP.toInt(n3 + n4), 255);
        return n15 << 24 | FP.toInt(n12) << 16 | FP.toInt(n13) << 8 | FP.toInt(n14);
    }

    static {
        RECT_X = 0;
        RECT_Y = 1;
        RECT_W = 2;
        RECT_H = 3;
        RECT = new int[RECT_H + 1];
    }
}

