/*
 * Decompiled with CFR 0.152.
 */
public class GModel
implements ConstantsTFC,
Constants,
GameConstants {
    static boolean m_bGameOver;
    static int m_nSunCountdown;
    static int m_nSunsFallen;
    static int m_nBackgroundImgID;
    static boolean m_bDroppedLevelAward;
    static boolean m_bEnableGraveStones;
    static int m_nIceTrapCounter;
    static boolean m_bConveyorLevel;
    static boolean m_bPoolLevel;
    static boolean m_bShovelTutorialLevel;
    static boolean m_bLevelUp;
    static boolean m_bIsShovelLevelSetup;
    static int m_nGameBoardRows;
    static final int[] PLANT_ROW;
    static final int[] GRID_SQUARE_TYPE;
    static long m_lBoardGridAsDirt;
    static int FP_120_PERCENT;
    static int FP_110_PERCENT;
    static int FP_98_PERCENT;
    static int FP_95_PERCENT;
    static int FP_90_PERCENT;
    static int FP_85_PERCENT;
    static int FP_80_PERCENT;
    static int FP_60_PERCENT;
    static int FP_30_PERCENT;
    static int FP_2_PERCENT;
    static int FP2;
    static int FP1;
    static int FP_GRAVITY_ZOMBIE_LIMB;
    static int FP_SPEED_SCALER_WIDTH;
    static int FP_SPEED_SCALER_HEIGHT;
    static int FP_FPS_SCALER;
    static int FP_ZOMBIE_FPS_SCALER;
    static final int PC_FPS = 75;
    static final int PC_ZOMBIE_FPS = 45;
    static final int PC_SCREEN_LAWN_WIDTH = 753;
    static final int PC_SCREEN_LAWN_HEIGHT = 506;
    public static final int END_LEVEL = 49;
    public static final int ROOFTOP_LEVEL = 40;
    public static final int NIGHTTIME_POOL_LEVEL = 30;
    public static final int DAYTIME_POOL_LEVEL = 20;
    public static final int NIGHTTIME_LEVEL = 10;

    static void init() {
        FP2 = 8192;
        FP1 = 4096;
        FP_120_PERCENT = FP.fpDiv(491520, 409600);
        FP_110_PERCENT = FP.fpDiv(450560, 409600);
        FP_98_PERCENT = FP.fpDiv(401408, 409600);
        FP_95_PERCENT = FP.fpDiv(389120, 409600);
        FP_90_PERCENT = FP.fpDiv(368640, 409600);
        FP_85_PERCENT = FP.fpDiv(348160, 409600);
        FP_80_PERCENT = FP.fpDiv(327680, 409600);
        FP_60_PERCENT = FP.fpDiv(245760, 409600);
        FP_30_PERCENT = FP.fpDiv(122880, 409600);
        FP_2_PERCENT = FP.fpDiv(8192, 409600);
        FP_GRAVITY_ZOMBIE_LIMB = 4096;
        FP_SPEED_SCALER_WIDTH = FP.fpDiv(FP1 * 270, FP1 * 753);
        FP_SPEED_SCALER_HEIGHT = FP.fpDiv(FP1 * 240, FP1 * 506);
        FP_FPS_SCALER = FP.fpDiv(FP1 * 75, FP1 * 18);
        FP_ZOMBIE_FPS_SCALER = FP.fpDiv(FP1 * 45, FP1 * 18);
    }

    static void resetVars() {
        m_bGameOver = false;
        m_bIsShovelLevelSetup = false;
    }

    static void setLevelVars(int n, int n2) {
        m_bConveyorLevel = false;
        m_bIsShovelLevelSetup = false;
        m_bPoolLevel = false;
        m_bShovelTutorialLevel = false;
        if (GModel.bIsConveyorLevel(n, n2)) {
            m_bConveyorLevel = true;
            Conveyor.resetVarsNewLevel(n);
        } else if (GameController.m_nLevel == 4) {
            m_bShovelTutorialLevel = true;
        }
        ZombieController.initZombieWaves(n);
        GModel.setLevelBackground(n, n2);
        m_bDroppedLevelAward = false;
        m_bEnableGraveStones = false;
        m_nIceTrapCounter = 0;
        m_nSunsFallen = 0;
        m_bLevelUp = false;
        Cursor.setLevelVars();
        TouchGameController.setVarsNewLevel(n);
    }

    static void update() {
        ViewPort.updateViewPort();
        Zombies.update();
        if (GameController.m_nGameState == 5) {
            SodRoll.update();
            if (SodRoll.m_nSodRolls <= 0) {
                GameController.changeState(0);
            }
        }
        if (GameController.m_nGameState != 0 && GameController.m_nGameState != 1) {
            return;
        }
        Mowers.update();
        GridItem.update();
        Projectiles.update();
        Coins.update();
        if (m_bConveyorLevel) {
            Conveyor.update();
        }
        SeedBank.update();
        Plants.update();
        ScoreController.update();
        GModel.updateSunSpawning();
        GModel.updateIceTrapCounter();
        if (!m_bShovelTutorialLevel && GameController.m_nLevel != 49) {
            ZombieController.updateZombieSpawning();
        }
        if (m_bGameOver) {
            GameController.doGameOver();
        }
        GModel.updateGameStatus();
        if (GameController.m_nLevel != 49) {
            ZombieController.updateProgressMeter();
        } else {
            ZombieController.updateZombossHealthMeter();
        }
        AwardScreen.update();
        GFHint.showHints(false);
        Hints.update();
    }

    static void updateGameStatus() {
    }

    static void updateGameStatusChallenge() {
    }

    static int getLevelXMLOffset(int n) {
        return -1;
    }

    static void updateSunSpawning() {
        if (m_nBackgroundImgID == 553 || m_nBackgroundImgID == 104 || m_bConveyorLevel || m_bShovelTutorialLevel || m_bDroppedLevelAward || m_bLevelUp) {
            return;
        }
        if (!(GameController.m_nGameMode != 0 || GameController.m_nLevel != 0 || GFHint.bHintDisplayed(2) && GFHint.m_nCurrentHint != 2)) {
            return;
        }
        if (--m_nSunCountdown > 0) {
            return;
        }
        int n = Layer.isLandscape(2) ? GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 0 + Util.GetRandom(200) : GModel.getBoardOffsetX(Layer.getLayerProperty(2, 5)) + 0 + Util.GetRandom(140);
        int n2 = -10;
        int n3 = 0;
        if (m_lBoardGridAsDirt > 0L) {
            if (PLANT_ROW[0] == 1 && PLANT_ROW[1] == 1) {
                Cursor.getGridRowPos(2, 0);
                n3 = Cursor.GRID_POS[Cursor.GRID_POS_Y] + Util.GetRandom(Cursor.GRID_POS[Cursor.GRID_POS_W]);
            } else if (PLANT_ROW[0] == 1) {
                Cursor.getGridRowPos(1, 0);
                n3 = Cursor.GRID_POS[Cursor.GRID_POS_Y] + Util.GetRandom(Cursor.GRID_POS[Cursor.GRID_POS_W] * 3);
            }
        } else {
            n3 = 50 + Util.GetRandom(100);
        }
        Coins.addCoin(0, n, n2, n3, -1, -1);
        m_nSunCountdown = Math.min(270, 126 + ++m_nSunsFallen * 4) + Util.GetRandom(72);
    }

    static void updateIceTrapCounter() {
        if (m_nIceTrapCounter > 0) {
            --m_nIceTrapCounter;
        }
    }

    static int scaleValueX(int n, boolean bl) {
        int n2 = n * FP1;
        n2 = FP.fpMul(n2, FP_SPEED_SCALER_WIDTH);
        if (bl) {
            n2 = FP.fpDiv(n2, FP1 * 1000);
        }
        return n2;
    }

    static int getBoardOffsetX(int n) {
        if (Layer.isLandscape(2) && (n != 1 || n != 0)) {
            return 50;
        }
        return 0;
    }

    static int getBoardOffsetY(int n) {
        if (Layer.isLandscape(2) && (n != 1 || n != 0)) {
            return 35;
        }
        return 0;
    }

    static int getDrawAreaOffsetX() {
        if (Layer.isLandscape(2)) {
            return -43;
        }
        return -80;
    }

    static int getDrawAreaOffsetY() {
        if (Layer.isLandscape(2)) {
            return 0;
        }
        return 0;
    }

    static void switchOrientationOnTheFly(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (Layer.isLandscape(2) && (n == 1 || n == 0)) {
            n5 = 50;
            n4 = 35;
        } else if (Layer.isPortrait(2) && (n == 2 || n == 4)) {
            n5 = -50;
            n4 = -35;
        } else {
            return;
        }
        ViewPort.changeOrientation();
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (Plants.m_nPlants > 0) {
            for (n3 = 0; n3 < Plants.MAX_NUM_PLANTS && n9 < Plants.m_nPlants; ++n3) {
                if (!Plants.isPlantAtIndex(n3)) continue;
                n6 = Plants.PLANT_MAX_VALS * n3;
                int n10 = n6 + Plants.PLANT_X;
                Plants.PLANTS[n10] = Plants.PLANTS[n10] + n5;
                int n11 = n6 + Plants.PLANT_Y;
                Plants.PLANTS[n11] = Plants.PLANTS[n11] + n4;
            }
        }
        if (Zombies.m_nZombies > 0) {
            n9 = 0;
            for (n3 = 0; n3 < 100 && n9 < Zombies.m_nZombies; ++n3) {
                if (!Zombies.isZombieAtIndex(n3)) continue;
                n6 = Zombies.ZOMBIE_MAX_VALS * n3;
                int n12 = n6 + Zombies.ZOMBIE_FP_CENTRE_X;
                Zombies.ZOMBIES[n12] = Zombies.ZOMBIES[n12] + n5 * 4096;
                int n13 = n6 + Zombies.ZOMBIE_FP_TOP_Y;
                Zombies.ZOMBIES[n13] = Zombies.ZOMBIES[n13] + n4 * 4096;
            }
        }
        if (Mowers.m_nMowers > 0) {
            n9 = 0;
            for (n3 = 0; n3 < Mowers.MAX_NUM_MOWERS && n9 < Mowers.m_nMowers; ++n3) {
                if (!Mowers.isMowerAtIndex(n3)) continue;
                n6 = Mowers.MOWER_MAX_VALS * n3;
                int n14 = n6 + Mowers.MOWER_FP_X;
                Mowers.MOWERS[n14] = Mowers.MOWERS[n14] + n5 * 4096;
                int n15 = n6 + Mowers.MOWER_FP_Y;
                Mowers.MOWERS[n15] = Mowers.MOWERS[n15] + n4 * 4096;
            }
        }
        if (Coins.m_nCoins > 0) {
            n9 = 0;
            for (n3 = 0; n3 < Coins.MAX_NUM_COINS && n9 < Coins.m_nCoins; ++n3) {
                if (!Coins.isCoinAtIndex(n3)) continue;
                n6 = Coins.COIN_MAX_VALS * n3;
                int n16 = n6 + Coins.COIN_FP_X;
                Coins.COINS[n16] = Coins.COINS[n16] + n5 * 4096;
                int n17 = n6 + Coins.COIN_FP_Y;
                Coins.COINS[n17] = Coins.COINS[n17] + n4 * 4096;
            }
        }
        n9 = 0;
        n3 = -1;
        for (n2 = 0; n2 < 7 && n9 < SeedBank.m_nSeeds; ++n2) {
            if (!SeedBank.isSeedAtIndex(n2)) continue;
            n6 = SeedBank.SEED_MAX_VALS * n2;
            n7 = SeedBank.SEEDS[n6 + SeedBank.SEED_TYPE];
            n8 = SeedBank.SEEDS[n6 + SeedBank.SEED_BANK_POS];
            SeedBank.setSeedRow(n2, n8);
            if (SeedBank.isFlagSet(2, n2)) {
                n3 = n8;
            }
            SeedBank.SEEDS[n6 + SeedBank.SEED_FP_X] = SeedBank.getStartSeedBankPosFPX(n8, SeedBank.SEEDS[n6 + SeedBank.SEED_BANK_ROW]);
            SeedBank.SEEDS[n6 + SeedBank.SEED_FP_Y] = SeedBank.getStartSeedBankPosFPY(n8, SeedBank.SEEDS[n6 + SeedBank.SEED_BANK_ROW]);
        }
        if (n3 >= 0) {
            SeedBank.updatePositions(n3, 0, Layer.getLayerProperty(2, 4), 0, Layer.getLayerProperty(2, 3), true);
        }
        if (GFParticleEngine.m_nParticles > 0) {
            n2 = 0;
            for (int i = 0; i < GFParticleEngine.m_nParticles; ++i) {
                n2 = i * 13;
                if (GFParticleEngine.PARTICLE_DATA[n2] == -1) continue;
                int n18 = n2 + 1;
                GFParticleEngine.PARTICLE_DATA[n18] = GFParticleEngine.PARTICLE_DATA[n18] + n5 * 4096;
                int n19 = n2 + 2;
                GFParticleEngine.PARTICLE_DATA[n19] = GFParticleEngine.PARTICLE_DATA[n19] + n4 * 4096;
            }
        }
    }

    static final boolean bCheckFlags(int n, int n2) {
        return (n & n2) != 0;
    }

    static void setLevelBackground(int n, int n2) {
        m_nGameBoardRows = 5;
        Util.resetArray(PLANT_ROW, 2);
        Util.resetArray(GRID_SQUARE_TYPE, 2);
        if (n == 0) {
            m_nBackgroundImgID = 293;
            Util.resetArray(PLANT_ROW, 1);
            GModel.PLANT_ROW[2] = 2;
        } else if (n == 1 || n == 2) {
            m_nBackgroundImgID = 293;
            GModel.PLANT_ROW[0] = 1;
            GModel.PLANT_ROW[4] = 1;
        } else if (n < 10) {
            m_nBackgroundImgID = 141;
        } else if (n < 20) {
            m_nBackgroundImgID = 553;
        } else if (n < 30) {
            m_nGameBoardRows = 6;
            m_nBackgroundImgID = 8;
            GModel.PLANT_ROW[2] = 3;
            GModel.PLANT_ROW[3] = 3;
            m_bPoolLevel = true;
        } else if (n < 40) {
            m_nGameBoardRows = 6;
            m_nBackgroundImgID = 104;
            GModel.PLANT_ROW[2] = 3;
            GModel.PLANT_ROW[3] = 3;
            m_bPoolLevel = true;
        } else if (n < 50) {
            m_nBackgroundImgID = 39;
            GModel.PLANT_ROW[0] = 4;
            GModel.PLANT_ROW[1] = 4;
            GModel.PLANT_ROW[2] = 4;
            GModel.PLANT_ROW[3] = 4;
            GModel.PLANT_ROW[4] = 4;
        }
        if (m_nBackgroundImgID == 553) {
            if (n == 10 || n == 11 || n == 12) {
                GModel.addGraveStone(6, 1);
                GModel.addGraveStone(7, 1);
                GModel.addGraveStone(8, 2);
            } else if (n == 13 || n == 15 || n == 17) {
                GModel.addGraveStone(5, 1);
                GModel.addGraveStone(6, 1);
                GModel.addGraveStone(7, 2);
                GModel.addGraveStone(8, 3);
            } else if (n == 16 || n == 18) {
                GModel.addGraveStone(4, 1);
                GModel.addGraveStone(5, 2);
                GModel.addGraveStone(6, 2);
                GModel.addGraveStone(7, 3);
                GModel.addGraveStone(8, 3);
            } else if (n >= 19) {
                GModel.addGraveStone(3, 1);
                GModel.addGraveStone(4, 2);
                GModel.addGraveStone(5, 2);
                GModel.addGraveStone(6, 2);
                GModel.addGraveStone(7, 3);
                GModel.addGraveStone(8, 3);
            }
        }
        m_lBoardGridAsDirt = 0L;
        long l = Util.setAllBits(9L);
        for (int i = 0; i < m_nGameBoardRows; ++i) {
            if (PLANT_ROW[i] != 1) continue;
            m_lBoardGridAsDirt |= l << i * 9;
        }
    }

    static void setupShovelLevel() {
        if (!m_bIsShovelLevelSetup) {
            Plants.addPlant(3, 4);
            Plants.addPlant(3, 10);
            Plants.addPlant(3, 23);
            m_bIsShovelLevelSetup = true;
        }
    }

    static void endShovelLevel() {
        m_bShovelTutorialLevel = false;
        SeedPicker.addSeedsToHUD();
        GameController.changeState(0);
        Hints.clearHintAll();
        Hints.clearHintArrow();
    }

    static boolean bIsConveyorLevel(int n, int n2) {
        return n == 9 || n == 19 || n == 29 || n == 39 || n == 49;
    }

    static void addGraveStone(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n3 = Util.GetRandom(m_nGameBoardRows);
            if (!GModel.canAddGraveStoneAt(n, n3)) continue;
            n4 = -Util.GetRandom(9);
            GridItem.addGridItem(1, n3 * 9 + n, 0, n4);
            ++n5;
        }
    }

    static boolean canAddGraveStoneAt(int n, int n2) {
        int n3 = n2 * 9 + n;
        if (GRID_SQUARE_TYPE[n3] != 2 && GRID_SQUARE_TYPE[n3] != 4) {
            return false;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        for (int i = 0; i < GridItem.MAX_NUM_GRID_ITEMS && n4 < GridItem.m_nGridItems; ++i) {
            if (!GridItem.isGridItemAtIndex(i)) continue;
            n5 = i * GridItem.GRID_ITEM_MAX_VALS;
            if (GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_POS] == n3 && ((n6 = GridItem.GRID_ITEMS[n5 + GridItem.GRID_ITEM_TYPE]) == 1 || n6 == 0 || n6 == 2)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    static int getMinValidBoardRow() {
        if (m_lBoardGridAsDirt > 0L) {
            for (int i = 0; i < m_nGameBoardRows; ++i) {
                if (PLANT_ROW[i] == 1) continue;
                return i;
            }
        }
        return 0;
    }

    static int getMaxValidBoardRow() {
        if (m_lBoardGridAsDirt > 0L) {
            for (int i = m_nGameBoardRows - 1; i >= 0; --i) {
                if (PLANT_ROW[i] == 1) continue;
                return i;
            }
        }
        return m_nGameBoardRows - 1;
    }

    static {
        m_bIsShovelLevelSetup = false;
        PLANT_ROW = new int[6];
        GRID_SQUARE_TYPE = new int[54];
    }
}

