/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Transform;

public final class cFxObj
extends cObject {
    public static float[] mMatrix = new float[16];
    int mFxType;
    public int mX;
    public int mY;
    public int mZ;
    public int mAngle;
    public cFx mFxMesh;
    public Transform mModelTrans = null;
    public boolean mIsBillboard = false;
    public boolean mCanBlur = true;
    public boolean mAnimable = false;
    public static final int[][][] fxMeshProp = new int[][][]{new int[][]{{2, 100, 100, 0, 0, 0, 32, 32, 6, 0, 65, 162, 1, 1, 0}, {3, 12}}, new int[][]{{0, 80, 80, 0, 0, 0, 32, 32, 6, 0, 65, 162, 1, 0, 0}, {0}}, new int[][]{{0, 300, 600, 1, 0, 0, 20, 32, 2, 0, 65, 162, 1, 0, 0}, {1}}, new int[][]{{0, 50, 150, 1, 0, 0, 9, 16, 8, 0, 65, 162, 0, 0, 0}, {0}}, new int[][]{{0, 50, 150, 1, 0, 0, 9, 16, 10, 0, 65, 162, 0, 0, 0}, {0}}, new int[][]{{0, 50, 150, 1, 0, 0, 9, 16, 10, 0, 65, 162, 0, 0, 0}, {0}}, new int[][]{{0, 10, 4, 2, 0, 0, 0, 0, -1, 0, 68, 162, 0, 0, 0}, {0}}, new int[][]{{0, 50, 3, 2, 0, 0, 0, 0, -1, 0, 65, 162, 0, 0, 0}, {0}}, new int[][]{{1, 80, 80, 0, 0, 0, 32, 32, 6, 0, 65, 162, 1, 0, 0}, {35, 15, 12, 15, 18, 0, 15}}, new int[][]{{0, 500, 250, 0, 0, 0, 64, 32, 11, 1, 64, 162, 1, 0, 0}, {0}}, new int[][]{{0, 100, 100, 0, 0, 0, 32, 32, 6, 0, 65, 162, 1, 1, 0}, {0}}, new int[][]{{0, 10, 10, 0, 0, 0, 32, 32, 6, 0, 65, 162, 1, 0, 0}, {0}}, new int[][]{{0, 10, 10, 0, 0, 0, 32, 32, 6, 0, 65, 162, 1, 0, 0}, {0}}};
    public static cFx[] fxMeshes = new cFx[20];
    public static final int[][][] textureAnimations = new int[][][]{new int[][]{{0, 0}, {0, 5}, {0, 1}}, new int[][]{{32, 0}, {0, 5}, {0, 1}}, new int[][]{{0, 0, 20, 0, 40, 0}, {0, 1, 1, 1, 2, 1}, {0, 3}}, new int[][]{{0, 0, 32, 0, 0, 32, 32, 32}, {0, 1, 1, 1, 2, 1, 3, 1}, {0, 4}}, new int[][]{{0, 0, 32, 0, 64, 0, 96, 0}, {0, 1, 1, 1, 2, 1, 3, 1}, {0, 4}}, new int[][]{{0, 0, 32, 0}, {0, 15, -1, 15, 1, 20}, {0, 3}}, new int[][]{{0, 0, 9, 0, 18, 0, 0, 16, 9, 16}, {0, 1, 1, 1, 2, 1, 3, 1, 4, 1}, {0, 5}}, new int[][]{{64, 0, 0, 32, 64, 32, 0, 0, 64, 64, 0, 96, 64, 96, 0, 64}, {0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1}, {0, 8}}, new int[][]{{0, 0, 32, 0}, {0, 1, 1, 1}, {0, 2}}};
    private int[] mTexModules = null;
    private int[] mTexAnimFrames = null;
    private int[] mTexAnim = null;
    private int mTexCurrAnimation = 0;
    private int mTexCurrFrame = 0;
    private int frameContor = 0;
    private float mMirrorX = 1.0f;
    private float mMirrorY = 1.0f;
    private float mMirrorZ = 1.0f;
    private float mBlurFX_Amount = 0.01f;
    private float mBlurFx_AmountTarget = 0.01f;
    private boolean mBluring = false;
    private int mBlurYawAngle = 0;

    public cFxObj(int type, int animType) {
        super(1);
        cFxObj.markTexturesAndMakeFxTemplate(type);
        this.mModelTrans = new Transform();
        this.mModelTrans.setIdentity();
        this.mFxType = type;
        this.mFxMesh = fxMeshes[this.mFxType];
        if (fxMeshProp[type][0][0] == 0) {
            boolean bl = this.mIsBillboard = fxMeshProp[type][1][0] != 0;
        }
        if (animType >= 0) {
            this.setTexAnimation(textureAnimations[animType][0], textureAnimations[animType][1], textureAnimations[animType][2]);
        }
    }

    public final void unload() {
        this.mTexModules = null;
        this.mTexAnimFrames = null;
        this.mTexAnim = null;
        this.mModelTrans = null;
        if (fxMeshes != null) {
            if (fxMeshes[this.mFxType] != null) {
                fxMeshes[this.mFxType].unload();
            }
            cFxObj.fxMeshes[this.mFxType] = null;
        }
        if (this.mFxMesh != null) {
            this.mFxMesh.unload();
        }
        this.mFxMesh = null;
    }

    public final void setTransform(int x, int y, int z, int angle, int rx, int ry, int rz) {
        this.mX = x;
        this.mY = y;
        this.mZ = z;
        this.mModelTrans.setIdentity();
        this.mModelTrans.postTranslate((float)this.mX / PLATFORM.mCoord2JsrDivider, (float)this.mY / PLATFORM.mCoord2JsrDivider, (float)this.mZ / PLATFORM.mCoord2JsrDivider);
        this.mAngle = angle;
        if (angle != 0) {
            this.mModelTrans.postRotate((float)angle / 11.37f, (float)rx, (float)ry, (float)rz);
        }
    }

    private void setTexAnimation(int[] texModules, int[] texAnimFrames, int[] texAnim) {
        this.mTexModules = texModules;
        this.mTexAnimFrames = texAnimFrames;
        this.mTexAnim = texAnim;
        this.mAnimable = true;
    }

    private static void markTexturesAndMakeFxTemplate(int type) {
        if (fxMeshProp[type][0].length == 15) {
            if (fxMeshes[type] == null) {
                cFxObj.fxMeshes[type] = new cFx(fxMeshProp[type][0][0], fxMeshProp[type][0][1], fxMeshProp[type][0][2], fxMeshProp[type][0][3]);
                boolean processAlpha = false;
                if (fxMeshProp[type][0][9] != 0) {
                    processAlpha = true;
                }
                cFxObj.fxMeshes[type].mTexture = cTexture.getTexture(2, fxMeshProp[type][0][8], processAlpha, true, 241, 241, false, false);
                return;
            }
        } else {
            cFxObj.fxMeshProp[type] = null;
        }
    }

    public static void createFxMeshes() {
        for (int i = 0; i < fxMeshProp.length; ++i) {
            if (fxMeshes[i] == null) continue;
            fxMeshes[i].setBaseTexCoor(fxMeshProp[i][0][4], fxMeshProp[i][0][5], fxMeshProp[i][0][6], fxMeshProp[i][0][7], cFxObj.fxMeshes[i].mTexture == null ? (short)0 : cFxObj.fxMeshes[i].mTexture.mWidth, cFxObj.fxMeshes[i].mTexture == null ? 0 : (int)cFxObj.fxMeshes[i].mTexture.mHeight);
            switch (fxMeshes[i].getType()) {
                case 1: {
                    fxMeshes[i].setExtraMiddle(fxMeshProp[i][1][0], fxMeshProp[i][1][1], fxMeshProp[i][1][2], fxMeshProp[i][1][3], fxMeshProp[i][1][4], fxMeshProp[i][1][5], fxMeshProp[i][1][6]);
                    break;
                }
                case 2: {
                    fxMeshes[i].setExtra2Triangles(fxMeshProp[i][1][0], fxMeshProp[i][1][1]);
                }
            }
            fxMeshes[i].genGeom();
            fxMeshes[i].createAppearance(fxMeshProp[i][0][10], fxMeshProp[i][0][11], fxMeshProp[i][0][12] != 0, fxMeshProp[i][0][13] != 0, fxMeshProp[i][0][14] != 0);
        }
    }

    private void updateTexAnim() {
        int n;
        cFxObj cFxObj2;
        int frame = this.mTexCurrFrame + this.mTexAnim[this.mTexCurrAnimation * 2 + 0];
        int frameLifeTime = this.mTexAnimFrames[frame * 2 + 1];
        int animLength = this.mTexAnim[this.mTexCurrAnimation * 2 + 1];
        if (this.frameContor >= frameLifeTime) {
            ++this.mTexCurrFrame;
            if (this.mTexCurrFrame >= animLength) {
                this.mTexCurrFrame = 0;
            }
            cFxObj2 = this;
            n = 0;
        } else {
            cFxObj cFxObj3 = this;
            cFxObj2 = cFxObj3;
            n = cFxObj3.frameContor + 1;
        }
        cFxObj2.frameContor = n;
    }

    private void renderModule(Graphics3D g3d, int moduleIdx) {
        if (moduleIdx < 0 || moduleIdx >= this.mTexModules.length / 2) {
            return;
        }
        if (this.mFxMesh.getType() == 2 && this.mCanBlur) {
            this.addBlurToLights();
        }
        this.mFxMesh.transformTexture(this.mTexModules[moduleIdx * 2 + 0], this.mTexModules[moduleIdx * 2 + 1]);
        if (this.mIsBillboard) {
            this.mFxMesh.renderAsBillboard(g3d, this.mX, this.mY, this.mZ, cGame.s_camX, cGame.s_camY, cGame.s_camZ);
        } else {
            this.mFxMesh.render(g3d, this.mModelTrans);
        }
        this.mFxMesh.restoreTextureTransform();
    }

    private void renderAnim(Graphics3D g3d) {
        this.renderModule(g3d, this.mTexAnimFrames[(this.mTexCurrFrame + this.mTexAnim[this.mTexCurrAnimation * 2 + 0]) * 2 + 0]);
    }

    public final void renderAnim(Graphics3D g3d, int texAnimation, int texFrame) {
        this.renderModule(g3d, this.mTexAnimFrames[(texFrame + this.mTexAnim[texAnimation * 2 + 0]) * 2 + 0]);
    }

    public final void render(Graphics3D g3d) {
        if (this.mAnimable) {
            this.updateTexAnim();
            this.renderAnim(g3d);
            return;
        }
        this.mFxMesh.render(g3d, this.mModelTrans);
    }

    public final int getPropViewDistance() {
        if (PLATFORM.bDoubleViewDistance) {
            return 3000;
        }
        return 2000;
    }

    private void addBlurToLights() {
        int dirY;
        int carSpeed = cGame.s_playerCar.mDisplaySpeed;
        int toCamX = cGame.s_camX - this.mX;
        int toCamY = cGame.s_camY - this.mY;
        int blurYawAngleTarget = cMath.angleZeroTo2PI(cGame.s_camYaw) + 2048;
        int dirX = cMath.cos(blurYawAngleTarget);
        int dist = toCamX * dirX + toCamY * (dirY = cMath.sin(blurYawAngleTarget)) >> 12;
        if (dist < 800 && dist > -300 && carSpeed > 0) {
            this.mBluring = true;
            this.mBlurFx_AmountTarget = carSpeed << 2;
        } else {
            this.mBlurFx_AmountTarget = this.mBlurFx_AmountTarget * 5.0f / 8.0f;
            if (this.mBlurFx_AmountTarget < 1.0f) {
                this.mBlurFx_AmountTarget = 0.01f;
                this.mBluring = false;
            }
        }
        this.mBlurFX_Amount = (this.mBlurFX_Amount * 6.0f + this.mBlurFx_AmountTarget * 10.0f) / 16.0f;
        this.mBlurYawAngle = (this.mBlurYawAngle * 6 + blurYawAngleTarget * 10) / 16;
        if (!this.mBluring) {
            float f;
            cFxObj cFxObj2;
            int angleToCamLocCoor;
            int angleToCamWorldCoor = cMath.angleZeroTo2PI(cMath.atan2(toCamX, toCamY)) + 4096;
            int difAngle = cMath.normAngle(angleToCamWorldCoor - (angleToCamLocCoor = cMath.angleZeroTo2PI(cMath.angleZeroTo2PI(cGame.s_camYaw) + 2048)));
            if (difAngle < 0) {
                cFxObj2 = this;
                f = 1.0f;
            } else {
                cFxObj2 = this;
                f = -1.0f;
            }
            cFxObj2.mMirrorY = f;
        }
        this.mModelTrans.setIdentity();
        this.mModelTrans.postTranslate((float)this.mX / PLATFORM.mCoord2JsrDivider, (float)this.mY / PLATFORM.mCoord2JsrDivider, (float)this.mZ / PLATFORM.mCoord2JsrDivider);
        this.mModelTrans.postRotate((float)this.mBlurYawAngle / 11.37f, 0.0f, 0.0f, 1.0f);
        if (this.mBlurFX_Amount < 1.0f) {
            this.mBlurFX_Amount = 0.01f;
        }
        this.mModelTrans.postScale(this.mBlurFX_Amount * this.mMirrorX, this.mMirrorY, this.mMirrorZ);
    }
}

