/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public final class cIntersection {
    int xCenter;
    int yCenter;
    int zCenter = 0;
    short[] roads = null;
    short nrRoads = 0;
    int[] vtx;
    short[] roadIdxCW = null;
    int[][] roadBlocksCoords = null;
    float[] roadBlocksScale = null;
    boolean[] roadBlockToTheRight = null;
    int roadBlockCount;
    VertexBuffer s_intersectionVtxBuffer;
    IndexBuffer s_intersectionIdxBuffer;
    Appearance s_intersectionAppearance;
    cTexture m_textureIntersection;
    VertexBuffer s_intersectionFenceVtxBuffer;
    IndexBuffer s_intersectionFenceIdxBuffer;
    static Appearance s_intersectionFenceAppearance;
    static cTexture s_textureFenceIntersection;
    Transform m_Transform;

    cIntersection(int[] listRoad, int numRoads, int[] vertex, int lengthVertex, int xc, int yc, int idx) {
        this.xCenter = xc;
        this.yCenter = yc;
        this.nrRoads = (short)numRoads;
        if (numRoads > 0) {
            this.roads = new short[numRoads];
            for (int i = 0; i < numRoads; ++i) {
                this.roads[i] = (short)listRoad[i];
            }
            this.createIntersection(vertex, lengthVertex);
            this.createIntersectionFences(vertex);
            this.initRoadBlocks();
            int[] angles = new int[numRoads];
            this.roadIdxCW = new short[numRoads];
            for (int i = 0; i < numRoads; ++i) {
                this.roadIdxCW[i] = this.roads[i];
                int endseg = cRoad.s_roadIntersection[this.roads[i]][1] == idx ? cRoad.s_vtxCount[this.roads[i]] - 2 : 0;
                angles[i] = cMath.atan2(cRoad.getCenterX(this.roads[i], endseg) - xc, cRoad.getCenterY(this.roads[i], endseg) - yc);
                angles[i] = cMath.normAngle(angles[i]);
            }
            for (int i = numRoads - 1; i >= 0; --i) {
                for (int j = 1; j <= i; ++j) {
                    if (angles[j - 1] >= angles[j]) continue;
                    int temp = angles[j - 1];
                    angles[j - 1] = angles[j];
                    angles[j] = temp;
                    temp = this.roadIdxCW[j - 1];
                    this.roadIdxCW[j - 1] = this.roadIdxCW[j];
                    this.roadIdxCW[j] = (short)temp;
                }
            }
        }
    }

    private void initRoadBlocks() {
        this.roadBlocksCoords = new int[this.nrRoads][4];
        this.roadBlocksScale = new float[this.nrRoads];
        this.roadBlockToTheRight = new boolean[this.nrRoads];
        this.roadBlockCount = 0;
    }

    private void createIntersection(int[] coords, int lengthCoords) {
        this.m_Transform = new Transform();
        this.m_Transform.postTranslate((float)this.xCenter / PLATFORM.mCoord2JsrDivider, (float)this.yCenter / PLATFORM.mCoord2JsrDivider, 0.0f);
        int nrOfRoads = lengthCoords / 6;
        int nrPoli = 2 * nrOfRoads;
        int lengthVertex = 9 * nrPoli;
        int[] vertex = new int[lengthVertex];
        int poz = 0;
        for (int i = 0; i < lengthVertex / 9; ++i) {
            vertex[i * 9 + 0] = this.xCenter;
            vertex[i * 9 + 1] = this.yCenter;
            vertex[i * 9 + 2] = 0;
            for (int j = 1; j < 3; ++j) {
                vertex[i * 9 + j * 3 + 0] = coords[poz * 3 + 0];
                vertex[i * 9 + j * 3 + 1] = coords[poz * 3 + 1];
                vertex[i * 9 + j * 3 + 2] = coords[poz * 3 + 2];
                if (j != 1 || ++poz < nrPoli) continue;
                poz = 0;
            }
        }
        PolygonMode pm = new PolygonMode();
        pm.setPerspectiveCorrectionEnable(true);
        pm.setCulling(162);
        this.vtx = new int[lengthVertex];
        short[] r_vtx = new short[lengthVertex];
        int stripLength = lengthVertex / 9;
        for (int i = 0; i < lengthVertex; ++i) {
            int n;
            int n2;
            short[] sArray;
            this.vtx[i] = vertex[i];
            if (i % 3 == 0) {
                sArray = r_vtx;
                n2 = i;
                n = vertex[i] - this.xCenter;
            } else if (i % 3 == 1) {
                sArray = r_vtx;
                n2 = i;
                n = vertex[i] - this.yCenter;
            } else {
                sArray = r_vtx;
                n2 = i;
                n = this.vtx[i];
            }
            sArray[n2] = (short)n;
        }
        VertexArray vertArray = new VertexArray(r_vtx.length / 3, 3, 2);
        vertArray.set(0, r_vtx.length / 3, r_vtx);
        this.s_intersectionVtxBuffer = new VertexBuffer();
        this.s_intersectionVtxBuffer.setPositions(vertArray, 1.0f / PLATFORM.mCoord2JsrDivider, null);
        this.s_intersectionAppearance = new Appearance();
        this.s_intersectionAppearance.setPolygonMode(pm);
        this.s_intersectionVtxBuffer.setDefaultColor(0x5555CC);
        int[] stripLen = new int[stripLength];
        for (int i = 0; i < stripLength; ++i) {
            stripLen[i] = 3;
        }
        this.s_intersectionIdxBuffer = new TriangleStripArray(0, stripLen);
        this.buildTextureData(stripLength);
    }

    private void buildTextureData(int nrOfTri) {
        switch (nrOfTri) {
            case 6: {
                short[] tex = new short[]{500, 500, 1000, 1000, 1000, 252, 500, 500, 1000, 252, 868, 0, 500, 500, 868, 0, 132, 0, 500, 500, 132, 0, 0, 252, 500, 500, 0, 252, 0, 1000, 500, 500, 0, 1000, 1000, 1000};
                VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
                this.s_intersectionVtxBuffer.setTexCoords(0, texArray, 0.001f, null);
                texArray.set(0, tex.length / 2, tex);
                this.m_textureIntersection = new cTexture();
                this.m_textureIntersection = cTexture.getTexture(0, 41 + cGame.s_currentTrack, false, false, 241, 241, false, false);
                if (this.m_textureIntersection.mTexture != null) {
                    this.s_intersectionAppearance.setTexture(0, this.m_textureIntersection.mTexture);
                }
                return;
            }
            case 8: {
                short[] tex = new short[]{500, 500, 100, 1000, 0, 900, 500, 500, 0, 900, 0, 100, 500, 500, 0, 100, 100, 0, 500, 500, 100, 0, 900, 0, 500, 500, 900, 0, 900, 100, 500, 500, 900, 100, 900, 900, 500, 500, 900, 900, 900, 1000, 500, 500, 900, 1000, 100, 1000};
                VertexArray texArray = new VertexArray(tex.length / 2, 2, 2);
                this.s_intersectionVtxBuffer.setTexCoords(0, texArray, 0.001f, null);
                texArray.set(0, tex.length / 2, tex);
                this.m_textureIntersection = new cTexture();
                this.m_textureIntersection = cTexture.getTexture(0, 46 + cGame.s_currentTrack, false, false, 241, 241, false, false);
                if (this.m_textureIntersection.mTexture == null) break;
                this.s_intersectionAppearance.setTexture(0, this.m_textureIntersection.mTexture);
            }
        }
    }

    final void render(Graphics3D g3d) {
        if (this.nrRoads == 0) {
            return;
        }
        g3d.render(this.s_intersectionVtxBuffer, this.s_intersectionIdxBuffer, this.s_intersectionAppearance, this.m_Transform);
        g3d.render(this.s_intersectionFenceVtxBuffer, this.s_intersectionFenceIdxBuffer, s_intersectionFenceAppearance, this.m_Transform);
    }

    public final int getTriangleFromIntersection(int x, int y) {
        int end = this.vtx.length / 3;
        int x1 = this.vtx[0];
        int y1 = this.vtx[1];
        int x2 = this.vtx[3];
        int y2 = this.vtx[4];
        for (int i = 2; i < end; ++i) {
            int x3 = this.vtx[i * 3 + 0];
            int y3 = this.vtx[i * 3 + 1];
            long fAB = (y - y1) * (x2 - x1) - (x - x1) * (y2 - y1);
            long fBC = (y - y2) * (x3 - x2) - (x - x2) * (y3 - y2);
            long fCA = (y - y3) * (x1 - x3) - (x - x3) * (y1 - y3);
            if (fBC < 5000L && fBC > -5000L || fAB < 5000L && fAB > -5000L || fCA < 5000L && fCA > -5000L) {
                boolean c = false;
                if ((y1 <= y && y < y3 || y3 <= y && y < y1) && x < (x3 - x1) * (y - y1) / (y3 - y1) + x1) {
                    c = true;
                }
                if ((y2 <= y && y < y1 || y1 <= y && y < y2) && x < (x1 - x2) * (y - y2) / (y1 - y2) + x2) {
                    boolean bl = c = !c;
                }
                if ((y3 <= y && y < y2 || y2 <= y && y < y3) && x < (x2 - x3) * (y - y3) / (y2 - y3) + x3) {
                    boolean bl = c = !c;
                }
                if (c) {
                    return i - 2;
                }
            } else if (fAB * fBC > 0L && fBC * fCA > 0L) {
                return i - 2;
            }
            x1 = x2;
            y1 = y2;
            x2 = x3;
            y2 = y3;
        }
        return -999999;
    }

    private void createIntersectionFences(int[] coords) {
        int i;
        int startVtx = this.nrRoads == 3 ? 2 : 0;
        short[] vert = new short[(coords.length + startVtx * 3) * 2];
        for (i = 0; i < coords.length / 3; ++i) {
            vert[i * 6 + 0] = (short)(coords[i * 3 + 0] - this.xCenter);
            vert[i * 6 + 1] = (short)(coords[i * 3 + 1] - this.yCenter);
            vert[i * 6 + 2] = (short)coords[i * 3 + 2];
            vert[i * 6 + 3] = (short)(coords[i * 3 + 0] - this.xCenter);
            vert[i * 6 + 4] = (short)(coords[i * 3 + 1] - this.yCenter);
            vert[i * 6 + 5] = (short)(coords[i * 3 + 2] + 160);
        }
        for (int j = 0; j < startVtx; ++j) {
            vert[i * 6 + 0] = vert[j * 6 + 0];
            vert[i * 6 + 1] = vert[j * 6 + 1];
            vert[i * 6 + 2] = vert[j * 6 + 2];
            vert[i * 6 + 3] = vert[j * 6 + 3];
            vert[i * 6 + 4] = vert[j * 6 + 4];
            vert[i * 6 + 5] = vert[j * 6 + 5];
            ++i;
        }
        VertexArray vertArray = new VertexArray(30, 3, 2);
        vertArray.set(0, vert.length / 3, vert);
        this.s_intersectionFenceVtxBuffer = new VertexBuffer();
        short[] tex = new short[(this.nrRoads + 1) * 4 * 2];
        int factor = 4;
        for (i = 0; i < this.nrRoads + 1; ++i) {
            if (this.nrRoads == 3 && i == 2) {
                factor = 6;
            }
            tex[i * 8 + 0] = 0;
            tex[i * 8 + 1] = 0;
            tex[i * 8 + 2] = 0;
            tex[i * 8 + 3] = 1;
            tex[i * 8 + 4] = (short)factor;
            tex[i * 8 + 5] = 0;
            tex[i * 8 + 6] = (short)factor;
            tex[i * 8 + 7] = 1;
        }
        VertexArray texArray = new VertexArray(30, 2, 2);
        texArray.set(0, tex.length / 2, tex);
        this.s_intersectionFenceVtxBuffer.setPositions(vertArray, 1.0f / PLATFORM.mCoord2JsrDivider, null);
        this.s_intersectionFenceVtxBuffer.setTexCoords(0, texArray, 1.0f, null);
        int[] stripLen = new int[this.nrRoads];
        for (i = 0; i < this.nrRoads; ++i) {
            stripLen[i] = 4;
        }
        this.s_intersectionFenceIdxBuffer = new TriangleStripArray(startVtx, stripLen);
        cIntersection.loadIntersectionFenceTexture(1 + (cGame.s_currentTrack << 1));
    }

    private static void loadIntersectionFenceTexture(int texIndex) {
        if (s_textureFenceIntersection == null) {
            s_textureFenceIntersection = cTexture.getTexture(1, texIndex, false, false, 241, 241, false, false);
            s_intersectionFenceAppearance = new Appearance();
            PolygonMode pm = new PolygonMode();
            pm.setPerspectiveCorrectionEnable(true);
            pm.setCulling(161);
            s_intersectionFenceAppearance.setPolygonMode(pm);
            s_intersectionFenceAppearance.setTexture(0, cIntersection.s_textureFenceIntersection.mTexture);
        }
    }

    final void createRoadBlocks(int intersectIdx) {
        int i;
        this.roadBlockCount = 0;
        int blockedRoadsNo = 0;
        for (i = 0; i < this.nrRoads; ++i) {
            if (cRoad.s_availableRoads[this.roads[i]]) continue;
            ++blockedRoadsNo;
        }
        if (blockedRoadsNo == 0) {
            return;
        }
        for (i = 0; i < this.nrRoads; ++i) {
            if (cRoad.s_availableRoads[this.roads[i]]) continue;
            this.computeRoadBlockPosition(i, intersectIdx);
            ++this.roadBlockCount;
        }
    }

    private void computeRoadBlockPosition(int roadIdx, int intersectIdx) {
        boolean useRightIndicator;
        int distance;
        int y;
        int x;
        short blockedRoad = this.roads[roadIdx];
        int pos = -1;
        for (int i = 0; i < this.nrRoads; ++i) {
            if (this.roadIdxCW[i] != blockedRoad) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return;
        }
        int rightRoadIdx = (pos - 1 >= 0 ? pos : (int)this.nrRoads) - 1;
        int leftRoadIdx = pos + 1 < this.nrRoads ? pos + 1 : 0;
        short rightRoad = this.roadIdxCW[rightRoadIdx];
        short leftRoad = this.roadIdxCW[leftRoadIdx];
        int headBlockedRoad = cRoad.s_roadIntersection[blockedRoad][1] == intersectIdx ? cRoad.s_vtxCount[blockedRoad] - 1 : 0;
        int blockedRoadCenterX = cRoad.getCenterX(blockedRoad, headBlockedRoad);
        int blockedRoadCenterY = cRoad.getCenterY(blockedRoad, headBlockedRoad);
        int rightRoadEnd = cRoad.s_roadIntersection[rightRoad][1] == intersectIdx ? cRoad.s_vtxCount[rightRoad] * 3 * 2 - 6 : 0;
        int leftRoadEnd = cRoad.s_roadIntersection[leftRoad][1] == intersectIdx ? cRoad.s_vtxCount[leftRoad] * 3 * 2 - 6 : 0;
        int blockedRoadEnd = cRoad.s_roadIntersection[blockedRoad][1] == intersectIdx ? cRoad.s_vtxCount[blockedRoad] * 3 * 2 - 6 : 0;
        int offsetHeadRight = 0;
        int offsetHeadLeft = 0;
        int offsetHeadBlocked = 0;
        if ((blockedRoadCenterX - cRoad.s_vtx[rightRoad][rightRoadEnd]) * (blockedRoadCenterX - cRoad.s_vtx[rightRoad][rightRoadEnd]) + (blockedRoadCenterY - cRoad.s_vtx[rightRoad][rightRoadEnd + 1]) * (blockedRoadCenterY - cRoad.s_vtx[rightRoad][rightRoadEnd + 1]) > (blockedRoadCenterX - cRoad.s_vtx[rightRoad][rightRoadEnd + 3]) * (blockedRoadCenterX - cRoad.s_vtx[rightRoad][rightRoadEnd + 3]) + (blockedRoadCenterY - cRoad.s_vtx[rightRoad][rightRoadEnd + 4]) * (blockedRoadCenterY - cRoad.s_vtx[rightRoad][rightRoadEnd + 4])) {
            offsetHeadRight = 3;
        }
        if ((blockedRoadCenterX - cRoad.s_vtx[leftRoad][leftRoadEnd]) * (blockedRoadCenterX - cRoad.s_vtx[leftRoad][leftRoadEnd]) + (blockedRoadCenterY - cRoad.s_vtx[leftRoad][leftRoadEnd + 1]) * (blockedRoadCenterY - cRoad.s_vtx[leftRoad][leftRoadEnd + 1]) > (blockedRoadCenterX - cRoad.s_vtx[leftRoad][leftRoadEnd + 3]) * (blockedRoadCenterX - cRoad.s_vtx[leftRoad][leftRoadEnd + 3]) + (blockedRoadCenterY - cRoad.s_vtx[leftRoad][leftRoadEnd + 4]) * (blockedRoadCenterY - cRoad.s_vtx[leftRoad][leftRoadEnd + 4])) {
            offsetHeadLeft = 3;
        }
        boolean leftRoadInvalid = false;
        boolean rightRoadInvalid = false;
        int headLeftRoad = leftRoadEnd == 0 ? 0 : cRoad.s_vtxCount[leftRoad] - 1;
        int headRightRoad = rightRoadEnd == 0 ? 0 : cRoad.s_vtxCount[rightRoad] - 1;
        int angle = cMath.subAngle(cRoad.s_roadYaws[blockedRoad][headBlockedRoad], cRoad.s_roadYaws[leftRoad][headLeftRoad]) < 0 ? -cMath.subAngle(cRoad.s_roadYaws[blockedRoad][headBlockedRoad], cRoad.s_roadYaws[leftRoad][headLeftRoad]) : cMath.subAngle(cRoad.s_roadYaws[blockedRoad][headBlockedRoad], cRoad.s_roadYaws[leftRoad][headLeftRoad]);
        if (angle > 1536 || angle < 512) {
            leftRoadInvalid = true;
        }
        if ((angle = cMath.subAngle(cRoad.s_roadYaws[blockedRoad][headBlockedRoad], cRoad.s_roadYaws[rightRoad][headRightRoad]) < 0 ? -cMath.subAngle(cRoad.s_roadYaws[blockedRoad][headBlockedRoad], cRoad.s_roadYaws[rightRoad][headRightRoad]) : cMath.subAngle(cRoad.s_roadYaws[blockedRoad][headBlockedRoad], cRoad.s_roadYaws[rightRoad][headRightRoad])) > 1536 || angle < 512) {
            rightRoadInvalid = true;
        }
        if (!rightRoadInvalid && !leftRoadInvalid) {
            int nextRoad;
            angle = cMath.atan2(cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft] - cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight], cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft + 1] - cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight + 1]);
            boolean leftRoadAngle = false;
            boolean rightRoadAngle = false;
            x = cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight];
            y = cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight + 1];
            angle = cMath.subAngle(angle, 1024);
            distance = (cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft] - cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight]) * (cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft] - cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight]) + (cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft + 1] - cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight + 1]) * (cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft + 1] - cRoad.s_vtx[rightRoad][rightRoadEnd + offsetHeadRight + 1]);
            distance = cMath.sqrt(distance);
            if (!cRoad.s_availableRoads[leftRoad]) {
                int n;
                int n2;
                int dist1 = (cRoad.s_vtx[blockedRoad][blockedRoadEnd] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft]) + (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 1] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft + 1]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 1] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft + 1]);
                int dist2 = (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 3] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 3] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft]) + (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 4] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft + 1]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 4] - cRoad.s_vtx[leftRoad][leftRoadEnd + offsetHeadLeft + 1]);
                if (dist1 > dist2) {
                    n2 = distance;
                    n = dist2;
                } else {
                    n2 = distance;
                    n = dist1;
                }
                distance = n2 - ((cMath.sqrt(n) >> 1) + 400);
            }
            useRightIndicator = (nextRoad = cCar.getTheNextRoad(intersectIdx, (byte)0)) != rightRoad && (cRoad.s_availableRoads[rightRoad] || nextRoad == leftRoad);
        } else {
            short coorectRoad = rightRoad;
            int coorectRoadEnd = rightRoadEnd;
            int offsetHeadCorrect = offsetHeadRight;
            int headCorrectRoad = headRightRoad;
            if (rightRoadInvalid) {
                coorectRoad = leftRoad;
                coorectRoadEnd = leftRoadEnd;
                offsetHeadCorrect = offsetHeadLeft;
                headCorrectRoad = headLeftRoad;
            }
            x = cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect];
            y = cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect + 1];
            angle = cMath.subAngle(cRoad.s_roadYaws[coorectRoad][headCorrectRoad], 1024);
            if (headCorrectRoad == 0) {
                angle += 2048;
            }
            if ((cRoad.s_vtx[blockedRoad][blockedRoadEnd] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect]) + (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 1] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect + 1]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 1] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect + 1]) < (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 3] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 3] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect]) + (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 4] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect + 1]) * (cRoad.s_vtx[blockedRoad][blockedRoadEnd + 4] - cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect + 1])) {
                offsetHeadBlocked = 3;
            }
            distance = cMath.sqrt((cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect] - cRoad.s_vtx[blockedRoad][blockedRoadEnd + offsetHeadBlocked]) * (cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect] - cRoad.s_vtx[blockedRoad][blockedRoadEnd + offsetHeadBlocked]) + (cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect + 1] - cRoad.s_vtx[blockedRoad][blockedRoadEnd + offsetHeadBlocked + 1]) * (cRoad.s_vtx[coorectRoad][coorectRoadEnd + offsetHeadCorrect + 1] - cRoad.s_vtx[blockedRoad][blockedRoadEnd + offsetHeadBlocked + 1])) - 100;
            useRightIndicator = cCar.getTheNextRoad(intersectIdx, (byte)0) != coorectRoad;
        }
        float xScaleFactor = (float)distance / 3150.0f;
        this.roadBlocksCoords[this.roadBlockCount][0] = x;
        this.roadBlocksCoords[this.roadBlockCount][1] = y;
        this.roadBlocksCoords[this.roadBlockCount][2] = 0;
        this.roadBlocksCoords[this.roadBlockCount][3] = angle;
        this.roadBlocksScale[this.roadBlockCount] = xScaleFactor;
        this.roadBlockToTheRight[this.roadBlockCount] = useRightIndicator;
    }

    final void unloadRoadBlocks() {
        this.roadBlockCount = 0;
    }

    final void renderRoadBlocks(Graphics3D g3d) {
        for (int i = 0; i < this.roadBlockCount; ++i) {
            cRoad.s_roadBlock.setTransform(this.roadBlocksCoords[i][0], this.roadBlocksCoords[i][1], this.roadBlocksCoords[i][2], this.roadBlocksCoords[i][3], 0, 0);
            cRoad.s_roadBlock.mTransform.postScale(this.roadBlocksScale[i], 1.0f, 1.0f);
            cRoad.s_roadBlock.render(g3d);
            cAnimObject.setDirectionRight(!this.roadBlockToTheRight[i]);
            cRoad.s_animTexObject.setCoords(this.roadBlocksCoords[i][0], this.roadBlocksCoords[i][1], this.roadBlocksCoords[i][2], this.roadBlocksCoords[i][3]);
            cAnimObject.setScaleX(this.roadBlocksScale[i] * 3050.0f);
            cRoad.s_animTexObject.render(g3d);
        }
    }

    final void computeRoadBlocksCollision() {
        int collisionCount = 0;
        if (this.roadBlockCount > 1) {
            boolean col = false;
            for (int i = 0; i < this.roadBlockCount; ++i) {
                cRoad.s_roadBlock.setTransform(this.roadBlocksCoords[i][0], this.roadBlocksCoords[i][1], this.roadBlocksCoords[i][2], this.roadBlocksCoords[i][3], 0, 0);
                if (i == 0) {
                    col = cCar.CheckMeshCollision(cGame.s_playerCar, cRoad.s_roadBlock, 12600);
                    continue;
                }
                if (!col || !cCar.CheckMeshCollision(cGame.s_playerCar, cRoad.s_roadBlock, 12600)) continue;
                cGame.s_playerCar.mSpeedYaw += 2048;
                cGame.s_playerCar.SetSpeed(13620);
            }
        }
        for (int i = 0; i < this.roadBlockCount; ++i) {
            cRoad.s_roadBlock.setTransform(this.roadBlocksCoords[i][0], this.roadBlocksCoords[i][1], this.roadBlocksCoords[i][2], this.roadBlocksCoords[i][3], 0, 0);
            if (!cGame.s_playerCar.ComputeMeshCollision(cRoad.s_roadBlock, 12600)) continue;
            cGame.s_playerCar.SetSpeed(cGame.s_playerCar.mSpeed / 3);
            byte by = (byte)(collisionCount + 1);
            collisionCount = by;
            if (by != 2) continue;
            cRoad.s_roadBlock.setTransform(this.roadBlocksCoords[0][0], this.roadBlocksCoords[0][1], this.roadBlocksCoords[0][2], this.roadBlocksCoords[0][3], 0, 0);
            cGame.s_playerCar.ComputeMeshCollision(cRoad.s_roadBlock, 12600);
        }
    }

    final void unloadIntersection() {
        this.roads = null;
        this.vtx = null;
        this.roadIdxCW = null;
        this.s_intersectionVtxBuffer = null;
        this.s_intersectionIdxBuffer = null;
        this.s_intersectionAppearance = null;
        this.m_textureIntersection = null;
        this.s_intersectionFenceVtxBuffer = null;
        this.s_intersectionFenceIdxBuffer = null;
        this.m_Transform = null;
        this.roadBlocksCoords = null;
        this.roadBlocksScale = null;
        this.roadBlockToTheRight = null;
    }
}

