/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.spritehandler;

import com.funfil.midp.games.spritehandler.LayerSprite;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledSprite
implements LayerSprite {
    private byte currentSequence;
    private int x;
    private int y;
    private int height;
    private int width;
    private String imageFile;
    private int totalFrames;
    protected Image[] image;
    private final int row;
    private final int col;
    private int[][] tiles;

    public TiledSprite(String imageFile, int x, int y, int width, int height, int row, int col, int totalFrames) throws IOException {
        this.x = x;
        this.y = y;
        this.row = row;
        this.col = col;
        this.height = height;
        this.width = width;
        this.imageFile = imageFile;
        this.totalFrames = totalFrames;
        this.image = new Image[totalFrames + 1];
        this.createImage();
    }

    private void createImage() throws IOException {
        Image image = Image.createImage((String)this.imageFile);
        int[] rgbData = new int[this.width * this.height];
        for (int i = -1; i < this.totalFrames; ++i) {
            for (int j = 0; j < rgbData.length; ++j) {
                rgbData[j] = 0;
            }
            if (i != -1) {
                image.getRGB(rgbData, 0, this.width, i * this.width, 0, this.width, this.height);
            }
            this.image[i + 1] = Image.createRGBImage((int[])rgbData, (int)this.width, (int)this.height, (boolean)true);
        }
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public byte getCurrentSequence() {
        return this.currentSequence;
    }

    public void setCurrentSequence(byte currentSequence) {
        this.currentSequence = currentSequence;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(String imageFile) throws IOException {
        this.imageFile = imageFile;
        this.createImage();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void paint(Graphics g) {
        try {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.col; ++j) {
                    g.drawImage(this.image[this.tiles[i][j]], this.x + j * this.width, this.y + i * this.height, 0);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int[][] getTiles() {
        return this.tiles;
    }

    public void setTiles(int[][] tiles) {
        this.tiles = tiles;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }
}

