/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.screen;

import com.funfil.midp.games.screen.FunMidlet;
import com.funfil.midp.games.spritehandler.FunPainter;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public abstract class FunScreen
extends GameCanvas
implements Runnable {
    private boolean interrupted;
    private final FunMidlet midlet;
    private final FunScreen parentScreen;
    private Thread thread;
    private FunPainter funPainter;

    protected FunScreen(FunMidlet midlet, FunScreen parentScreen) throws IOException {
        super(true);
        this.midlet = midlet;
        this.parentScreen = parentScreen;
        this.setFullScreenMode(true);
        this.init();
    }

    protected FunScreen(FunMidlet midlet) throws IOException {
        this(midlet, null);
    }

    public void run() {
        Graphics g = this.getGraphics();
        while (!this.interrupted) {
            int keyState = this.getKeyStates();
            this.run(g, keyState);
            this.funPainter.paint(g);
            this.flushGraphics(0, 0, this.getWidth(), this.getHeight());
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.setInterrupted(false);
        this.thread.start();
    }

    private void init() throws IOException {
        this.init(this.funPainter);
    }

    protected boolean isInterrupted() {
        return this.interrupted;
    }

    protected void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    protected abstract void openNewScreen(FunScreen var1);

    public FunMidlet getMidlet() {
        return this.midlet;
    }

    public FunScreen getParentScreen() {
        return this.parentScreen;
    }

    public void back() {
        if (this.parentScreen != null) {
            try {
                this.parentScreen.init();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.stop();
        }
    }

    public abstract void stop();

    public abstract void pauseApp();

    protected abstract void init(FunPainter var1) throws IOException;

    protected abstract void run(Graphics var1, int var2);
}

