/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.record;

import com.funfil.midp.games.screen.FunMidlet;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Recorder {
    private Hashtable table;
    private RecordStore recordStore;
    private String rmsName;
    private int totalRecord;
    public static final String ACTIVATION = "ACTIVATION";
    public static final String SOUND = "SOUND";

    public Recorder(FunMidlet midlet) throws RecordStoreException {
        this(midlet.getAppProperty("MIDlet-Name"));
    }

    public Recorder(String rmsName) throws RecordStoreException {
        this.rmsName = rmsName;
        this.recordStore = RecordStore.openRecordStore((String)rmsName, (boolean)true);
        this.totalRecord = this.recordStore.getNumRecords();
        this.table = new Hashtable();
        this.refreshTable();
    }

    public String add(String key, String value) {
        if (!this.table.containsKey(key)) {
            try {
                Record record = new Record(key, value);
                this.table.put(key, record);
                return null;
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        } else {
            Record record = (Record)this.table.get(key);
            String val = record.value;
            record.value = value;
            try {
                record.update();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
            return val;
        }
        return null;
    }

    public String remove(String Key) {
        Record record = (Record)this.table.remove(Key);
        try {
            record.remove();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        if (record != null) {
            return record.value;
        }
        return null;
    }

    public String get(String key) {
        Record record = (Record)this.table.get(key);
        if (record != null) {
            return record.value;
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public final void refreshTable() throws RecordStoreNotOpenException, RecordStoreException {
        this.table.clear();
        this.totalRecord = this.recordStore.getNumRecords();
        RecordEnumeration enu = this.recordStore.enumerateRecords(null, null, true);
        while (enu.hasNextElement()) {
            int id = enu.nextRecordId();
            Record record = new Record(id);
            this.table.put(record.key, record);
        }
    }

    public String getRmsName() {
        return this.rmsName;
    }

    public void setRmsName(String rmsName) {
        this.rmsName = rmsName;
    }

    public int getTotalRecord() {
        return this.totalRecord;
    }

    public void setTotalRecord(int totalRecord) {
        this.totalRecord = totalRecord;
    }

    public void close() {
        try {
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private class Record {
        int id;
        String value;
        String key;

        public Record(String key, String value) throws RecordStoreException {
            this.key = key;
            this.value = value;
            byte[] encodedData = this.encode();
            this.id = Recorder.this.recordStore.addRecord(encodedData, 0, encodedData.length);
        }

        public Record(int id) throws RecordStoreException {
            this.id = id;
            this.decode(Recorder.this.recordStore.getRecord(id));
        }

        private byte[] encode() {
            StringBuffer encodedData = new StringBuffer(this.key);
            encodedData.append(';');
            encodedData.append(this.value);
            return encodedData.toString().getBytes();
        }

        private void decode(byte[] recordData) {
            String record = new String(recordData);
            this.key = record.substring(0, record.indexOf(59));
            this.value = record.substring(record.indexOf(59) + 1);
        }

        public void update() throws RecordStoreException {
            byte[] encodedData = this.encode();
            Recorder.this.recordStore.setRecord(this.id, encodedData, 0, encodedData.length);
        }

        private void remove() throws RecordStoreException {
            Recorder.this.recordStore.deleteRecord(this.id);
        }
    }
}

