/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.mplayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class FunPlayer
implements Runnable,
PlayerListener {
    public static final boolean ON = true;
    public static final boolean OFF = false;
    private boolean sound;
    public final int LOOP;
    public final int ONCE;
    public final int REVERCE_LOOP;
    public final int REVERCE_ONCE;
    public final int CURRENT_LOOP;
    public final int CURRENT_ONCE;
    private Thread thread;
    private Player player;
    private Vector soundFiles = new Vector();
    private Vector sequence = new Vector();
    private boolean running;
    private int current;
    private long durationGap;
    private int state;
    private InputStream inputStream;
    int loopCount = -1;

    private static byte[] encode(String str) {
        return FunPlayer.change(str.getBytes());
    }

    private static byte[] change(byte[] data) {
        byte[] converted = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            converted[converted.length - 1 - i] = ~data[i];
        }
        return converted;
    }

    private static String decode(byte[] data) {
        return new String(FunPlayer.change(data));
    }

    public FunPlayer(String[] soundFile, boolean sound) throws IOException {
        this.LOOP = 1;
        this.ONCE = 2;
        this.REVERCE_LOOP = 3;
        this.REVERCE_ONCE = 4;
        this.CURRENT_LOOP = 5;
        this.CURRENT_ONCE = 6;
        for (int i = 0; i < soundFile.length; ++i) {
            this.soundFiles.addElement(soundFile[i]);
            this.sequence.addElement(new Integer(i));
        }
        this.state = 1;
        this.current = 0;
        this.durationGap = 0L;
        this.sound = sound;
    }

    public FunPlayer(boolean sound) throws IOException {
        this(new String[0], sound);
    }

    public void start() {
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void refreshPlayer() {
        try {
            this.sequenceRefresh();
            this.defplayer();
            System.gc();
            int index = (Integer)this.sequence.elementAt(this.current);
            String soundFile = (String)this.soundFiles.elementAt(index);
            this.inputStream = this.getClass().getResourceAsStream(soundFile);
            this.player = Manager.createPlayer((InputStream)this.inputStream, (String)"audio/midi");
            this.player.setLoopCount(this.loopCount);
            this.player.realize();
            this.player.prefetch();
            System.gc();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setLoopCount(int count) {
        this.loopCount = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        int old = -1;
        while (this.running) {
            try {
                if (!(!this.sound || this.soundFiles.isEmpty() || this.sequence.isEmpty() || this.player != null && this.player.getState() != 300 || old == this.current)) {
                    old = this.current;
                    this.refreshPlayer();
                }
                if (this.sound && this.player != null && this.player.getState() != 400) {
                    this.player.start();
                }
                try {
                    FunPlayer funPlayer = this;
                    synchronized (funPlayer) {
                        System.gc();
                        this.wait(this.durationGap);
                    }
                }
                catch (InterruptedException ex) {
                }
            }
            catch (MediaException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void sequenceRefresh() {
        switch (this.state) {
            case 1: {
                this.current = this.current == this.sequence.size() - 1 ? 0 : this.current + 1;
                break;
            }
            case 2: {
                int n = this.current = this.current == this.sequence.size() - 1 ? 0 : this.current + 1;
                if (this.current != 0) break;
                this.stop();
                break;
            }
            case 3: {
                this.current = this.current == 0 ? this.sequence.size() - 1 : this.current - 1;
                break;
            }
            case 4: {
                int n = this.current = this.current == 0 ? this.sequence.size() - 1 : this.current - 1;
                if (this.current != this.sequence.size() - 1) break;
                this.stop();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.stop();
                break;
            }
        }
    }

    public void stop() {
        this.running = false;
        try {
            this.defplayer();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void getSoundFiles(Object[] anArray) {
        this.soundFiles.copyInto(anArray);
    }

    public void setSoundFile(String soundFile) {
        this.soundFiles.addElement(soundFile);
    }

    public int getCurrent() {
        return this.current;
    }

    public void playSound(int current, int loopCount) {
        this.setSoundOff();
        this.setLoopCount(loopCount);
        this.setCurrent(current);
        this.setSoundOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCurrent(int current) {
        this.current = current;
        this.refreshPlayer();
        FunPlayer funPlayer = this;
        synchronized (funPlayer) {
            System.gc();
            this.notify();
        }
    }

    public long getDurationGap() {
        return this.durationGap;
    }

    public void setDurationGap(long durationGap) {
        this.durationGap = durationGap;
    }

    public int[] getSequence() {
        int[] seq = new int[this.sequence.size()];
        Enumeration enu = this.sequence.elements();
        int i = 0;
        while (enu.hasMoreElements()) {
            seq[i] = (Integer)enu.nextElement();
            ++i;
        }
        return seq;
    }

    public void setSequence(int[] sequence) {
        this.sequence.removeAllElements();
        try {
            this.current = 0;
            for (int i = 0; i < sequence.length; ++i) {
                if (sequence[i] >= this.soundFiles.size()) continue;
                this.sequence.addElement(new Integer(sequence[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setSoundOn() {
        this.sound = true;
        try {
            if (this.player != null) {
                this.player.start();
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void setSoundOff() {
        this.sound = false;
        try {
            if (this.player != null && this.player.getState() == 400) {
                this.player.stop();
            }
        }
        catch (MediaException me) {
            this.reset();
        }
    }

    public boolean isSound() {
        return this.sound;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event == "endOfMedia") {
            try {
                this.defplayer();
            }
            catch (MediaException me) {
                // empty catch block
            }
            this.reset();
        }
    }

    void play(String url) {
        try {
            this.defplayer();
            this.player = Manager.createPlayer((String)url);
            this.player.addPlayerListener((PlayerListener)this);
            this.player.realize();
            this.player.prefetch();
            this.player.start();
        }
        catch (Throwable t) {
            this.reset();
        }
    }

    void defplayer() throws MediaException {
        if (this.player != null) {
            if (this.player.getState() == 400) {
                this.player.stop();
            }
            if (this.player.getState() == 300) {
                this.player.deallocate();
            }
            if (this.player.getState() == 200 || this.player.getState() == 100) {
                this.player.close();
            }
        }
        this.player = null;
    }

    void reset() {
        this.player = null;
    }

    void stopPlayer() {
        try {
            this.defplayer();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        this.reset();
    }
}

