/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.imager;

import com.funfil.midp.games.imager.PngEncoder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FunImage {
    private byte[] rgbData;
    private String fileName = "Honey";
    private String dirPath;
    private Image image;

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[] getRgbData() {
        return this.rgbData;
    }

    public void setRgbData(byte[] rgbData) {
        this.rgbData = rgbData;
    }

    public void setRgbData(int[] rgbData) {
        this.rgbData = FunImage.getByteArray(rgbData);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void write() {
        String str = System.getProperty("microedition.io.file.FileConnection.version");
        if (str == null) {
            System.out.println("");
        } else {
            System.out.println("file seperator:" + System.getProperty("file.separator"));
            Enumeration enu = FileSystemRegistry.listRoots();
            while (enu.hasMoreElements()) {
                this.dirPath = (String)enu.nextElement();
            }
            if (this.dirPath != null) {
                try {
                    FileConnection fc = (FileConnection)Connector.open((String)("file:///" + this.dirPath + this.fileName + ".png"));
                    if (!fc.exists()) {
                        fc.create();
                    }
                    OutputStream out = fc.openOutputStream();
                    if (this.image.isMutable()) {
                        Graphics g = this.image.getGraphics();
                        g.setColor(255, 0, 255);
                        int x = 225;
                        int y = 100;
                        int h = 16;
                        String funfil = "FUNFIL";
                        for (int i = 0; i < funfil.length(); ++i) {
                            g.drawString("" + funfil.charAt(i), x, y + i * h, 0);
                        }
                    }
                    PngEncoder png = new PngEncoder(this.image);
                    png.encode(out);
                    out.flush();
                    out.close();
                    fc.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                throw new NullPointerException();
            }
        }
    }

    public static byte[] getByteArray(Image image) {
        int[] raw = new int[image.getWidth() * image.getHeight()];
        image.getRGB(raw, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        byte[] rawByte = new byte[image.getWidth() * image.getHeight() * 4];
        int n = 0;
        for (int i = 0; i < raw.length; ++i) {
            int ARGB = raw[i];
            int a = (ARGB & 0xFF000000) >> 24;
            int r = (ARGB & 0xFF0000) >> 16;
            int g = (ARGB & 0xFF00) >> 8;
            int b = ARGB & 0xFF;
            rawByte[n] = (byte)b;
            rawByte[n + 1] = (byte)g;
            rawByte[n + 2] = (byte)r;
            rawByte[n + 3] = (byte)a;
            n += 4;
        }
        raw = null;
        return rawByte;
    }

    public static byte[] getByteArray(int[] rgbData) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (int i = 0; i < rgbData.length; ++i) {
            try {
                dos.writeInt(rgbData[i]);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return baos.toByteArray();
    }
}

