/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.spritehandler;

import com.funfil.midp.games.spritehandler.Animator;
import com.funfil.midp.games.spritehandler.ChildScreen;
import com.funfil.midp.games.spritehandler.FunPainter;
import com.funfil.midp.games.spritehandler.LayerSprite;
import com.funfil.midp.games.spritehandler.MainScreen;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Screen
implements Animator {
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_POUND = 35;
    public static final int KEY_STAR = 42;
    public static final int LEFT = -6;
    public static final int RIGHT = -7;
    public static final int UP_ARROW = -1;
    public static final int DOWN_ARROW = -2;
    public static final int FIRE = -5;
    public static final int LEFT_ARROW = -3;
    public static final int RIGHT_ARROW = -4;
    protected FunPainter painter;
    protected MainScreen mainScreen;
    private String selectPng;

    public MainScreen getMainScreen() {
        return this.mainScreen;
    }

    public void setMainScreen(MainScreen mainScreen) {
        this.mainScreen = mainScreen;
    }

    public Screen(MainScreen mainScreen) {
        this.mainScreen = mainScreen;
        this.painter = new FunPainter();
    }

    public void paint(Graphics g) {
        this.painter.paint(g);
        try {
            if (this.selectPng != null) {
                Image select = Image.createImage((String)this.selectPng);
                g.drawImage(select, 0, this.mainScreen.getHeight(), 4 | 0x20);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void init() {
        this.init(this.painter);
    }

    public void start() {
        LayerSprite[] layerSprite = this.painter.getSprites();
        for (int i = 0; i < layerSprite.length; ++i) {
            if (!(layerSprite[i] instanceof Animator)) continue;
            ((Animator)((Object)layerSprite[i])).start();
        }
    }

    public void stop() {
        LayerSprite[] layerSprite = this.painter.getSprites();
        for (int i = 0; i < layerSprite.length; ++i) {
            if (!(layerSprite[i] instanceof Animator)) continue;
            ((Animator)((Object)layerSprite[i])).stop();
        }
    }

    public void pause() {
        LayerSprite[] layerSprite = this.painter.getSprites();
        for (int i = 0; i < layerSprite.length; ++i) {
            if (!(layerSprite[i] instanceof Animator)) continue;
            ((Animator)((Object)layerSprite[i])).pause();
        }
    }

    public void release() {
        LayerSprite[] layerSprite = this.painter.getSprites();
        for (int i = 0; i < layerSprite.length; ++i) {
            if (!(layerSprite[i] instanceof Animator)) continue;
            ((Animator)((Object)layerSprite[i])).release();
        }
    }

    public FunPainter getPainter() {
        return this.painter;
    }

    public void waitfor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void back() {
        this.mainScreen.stop();
    }

    public void keyPressed(int keycode) {
        switch (keycode) {
            case 48: {
                this.key_Num0Pressed();
                break;
            }
            case 49: {
                this.key_Num1Pressed();
                break;
            }
            case 50: {
                this.key_Num2Pressed();
                break;
            }
            case 51: {
                this.key_Num3Pressed();
                break;
            }
            case 52: {
                this.key_Num4Pressed();
                break;
            }
            case 53: {
                this.key_Num5Pressed();
                break;
            }
            case 54: {
                this.key_Num6Pressed();
                break;
            }
            case 55: {
                this.key_Num7Pressed();
                break;
            }
            case 56: {
                this.key_Num8Pressed();
                break;
            }
            case 57: {
                this.key_Num9Pressed();
                break;
            }
            case 35: {
                this.key_PoundPressed();
                break;
            }
            case 42: {
                this.key_StarPressed();
                break;
            }
            case -3: {
                this.leftArrowPressed();
                break;
            }
            case -4: {
                this.rightArrowPressed();
                break;
            }
            case -1: {
                this.upArrowPressed();
                break;
            }
            case -2: {
                this.downArrowPressed();
                break;
            }
            case -5: {
                this.firePressed();
                break;
            }
            case -6: {
                this.leftPressed();
                break;
            }
            case -7: {
                this.rightPressed();
            }
        }
    }

    public void keyReleased(int keycode) {
    }

    protected void key_Num0Pressed() {
    }

    protected void key_Num1Pressed() {
    }

    protected void key_Num2Pressed() {
        this.upArrowPressed();
    }

    protected void key_Num3Pressed() {
    }

    protected void key_Num4Pressed() {
        this.leftArrowPressed();
    }

    protected void key_Num5Pressed() {
        this.firePressed();
    }

    protected void key_Num6Pressed() {
        this.rightArrowPressed();
    }

    protected void key_Num7Pressed() {
    }

    protected void key_Num8Pressed() {
        this.downArrowPressed();
    }

    protected void key_Num9Pressed() {
    }

    protected void key_PoundPressed() {
    }

    protected void key_StarPressed() {
    }

    protected void leftPressed() {
        this.firePressed();
    }

    protected void rightPressed() {
        if (this instanceof ChildScreen) {
            ((ChildScreen)this).back();
        } else {
            this.mainScreen.stop();
        }
    }

    protected abstract void init(FunPainter var1);

    protected void leftArrowPressed() {
    }

    protected void rightArrowPressed() {
    }

    protected void upArrowPressed() {
    }

    protected void downArrowPressed() {
    }

    protected void firePressed() {
    }

    public String getSelectPng() {
        return this.selectPng;
    }

    public void setSelectPng(String selectPng) {
        this.selectPng = selectPng;
    }

    public void keyRepeated(int keyCode) {
    }
}

