/*
 * Decompiled with CFR 0.152.
 */
package com.funfil.midp.games.spritehandler;

import com.funfil.midp.games.spritehandler.Animator;
import com.funfil.midp.games.spritehandler.TiledSprite;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class AnimatedTiledSprite
extends TiledSprite
implements Animator {
    private Vector sequenceList = new Vector(0);

    public AnimatedTiledSprite(String imageFile, int x, int y, int width, int height, int row, int col, int totalFrames) throws IOException {
        super(imageFile, x, y, width, height, row, col, totalFrames);
    }

    public int setAnimatedSprite(byte[] sequence, int delay) {
        Animate animate = new Animate(sequence, delay);
        this.sequenceList.addElement(animate);
        return -(this.sequenceList.indexOf(animate) + 1);
    }

    public void paint(Graphics g) {
        try {
            for (int i = 0; i < this.getRow(); ++i) {
                for (int j = 0; j < this.getCol(); ++j) {
                    int imageIndex = this.getTiles()[i][j];
                    if (imageIndex < 0) {
                        Animate animate = (Animate)this.sequenceList.elementAt(-imageIndex - 1);
                        imageIndex = animate.getCurrentIndex();
                    }
                    g.drawImage(this.image[imageIndex], this.getX() + j * this.getWidth(), this.getY() + i * this.getHeight(), 0);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void start() {
        for (int i = 0; i < this.sequenceList.size(); ++i) {
            Animate animate = (Animate)this.sequenceList.elementAt(i);
            animate.start();
        }
    }

    public void stop() {
        for (int i = 0; i < this.sequenceList.size(); ++i) {
            Animate animate = (Animate)this.sequenceList.elementAt(i);
            animate.stop();
        }
    }

    public void pause() {
        for (int i = 0; i < this.sequenceList.size(); ++i) {
            Animate animate = (Animate)this.sequenceList.elementAt(i);
            animate.pause();
        }
    }

    public void release() {
        for (int i = 0; i < this.sequenceList.size(); ++i) {
            Animate animate = (Animate)this.sequenceList.elementAt(i);
            animate.release();
        }
    }

    private class Animate
    implements Runnable {
        private byte[] sequence;
        private int delay;
        private int currentIndex;
        private int interrupt;
        private boolean forward;
        private boolean moving;
        private Thread thread;

        public Animate(byte[] sequence, int delay) {
            this.delay = delay;
            this.sequence = sequence;
            this.currentIndex = 0;
        }

        public void next() {
            this.currentIndex = this.currentIndex < this.sequence.length ? ++this.currentIndex : 0;
        }

        public void prev() {
            this.currentIndex = this.currentIndex > 0 ? --this.currentIndex : this.sequence.length - 1;
        }

        public int getCurrentIndex() {
            return this.sequence[this.currentIndex];
        }

        public void run() {
            while (this.interrupt != 1) {
                if (this.interrupt == 0) {
                    if (this.forward) {
                        this.next();
                    } else {
                        this.prev();
                    }
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public boolean isForward() {
            return this.forward;
        }

        public void setForward(boolean forward) {
            this.forward = forward;
        }

        public int getState() {
            return this.interrupt;
        }

        public void setInterrupt(int interrupt) {
            this.interrupt = interrupt;
        }

        public void stop() {
            this.setInterrupt(1);
        }

        public void start() {
            this.thread = new Thread(this);
            this.setInterrupt(0);
            this.thread.start();
        }

        private void pause() {
            this.setInterrupt(2);
        }

        private void release() {
            this.setInterrupt(0);
        }
    }
}

