/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.mobile.utils;

import com.golden.gamedev.mobile.canvas.Properties;
import com.golden.gamedev.mobile.utils.FPUtil;
import com.golden.gamedev.mobile.utils.GraphicsUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageUtil {
    private static Image im = null;
    private static Image[] ims = null;
    private static int[] argb = null;
    private static Graphics g2;

    public static Image loadImage(String f) {
        try {
            im = Image.createImage((String)f);
        }
        catch (IOException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return im;
    }

    public static Image[] loadImages(Image img, int cols, int rows) {
        int l = cols * rows;
        int i1 = 0;
        ims = new Image[l];
        int l1 = img.getWidth() / cols;
        int l2 = img.getHeight() / rows;
        try {
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    ImageUtil.ims[i1] = Image.createImage((Image)img, (int)(j * l1), (int)(i * l2), (int)l1, (int)l2, (int)0);
                    ++i1;
                }
            }
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        return ims;
    }

    public static Image loadEmptyImage(int w, int h) {
        try {
            im = Image.createImage((int)w, (int)h);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return im;
    }

    public static Image loadImage(Image image) {
        try {
            im = Image.createImage((Image)image);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return im;
    }

    public static Image loadImageFromBytes(byte[] imageData, int imageOffset, int imageLength) {
        try {
            im = Image.createImage((byte[])imageData, (int)imageOffset, (int)imageLength);
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return im;
    }

    public static Image loadImageFromStream(InputStream stream) {
        try {
            im = Image.createImage((InputStream)stream);
        }
        catch (IOException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return im;
    }

    public static Image loadARGBImage(int color, int w, int h, boolean alpha) {
        int l = w * h;
        try {
            argb = new int[l];
            for (int i = 0; i < l; ++i) {
                ImageUtil.argb[i] = color;
            }
            im = Image.createRGBImage((int[])argb, (int)w, (int)h, (boolean)alpha);
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            // empty catch block
        }
        return im;
    }

    public static Image loadARGBImage(int[] colors, int w, int h, boolean alpha) {
        int l = w * h;
        try {
            argb = new int[l];
            for (int i = 0; i < l; ++i) {
                ImageUtil.argb[i] = colors[i];
            }
            im = Image.createRGBImage((int[])argb, (int)w, (int)h, (boolean)alpha);
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            // empty catch block
        }
        return im;
    }

    public static Image getScaledImage(Image image, int _w, int _h) {
        int imgW = image.getWidth();
        int imgH = image.getHeight();
        int imgSW = 0;
        int imgSH = 0;
        int posX = 0;
        int posY = 0;
        if (_w >= imgW) {
            imgSW = FPUtil.div(_w, imgW);
        } else if (_w < imgW) {
            imgSW = FPUtil.div(imgW, _w);
        }
        if (_h >= imgH) {
            imgSH = FPUtil.div(_h, imgH);
        } else if (_h < imgH) {
            imgSH = FPUtil.div(imgH, _h);
        }
        int l = imgW * imgH;
        argb = new int[l];
        image.getRGB(argb, 0, imgW, 0, 0, imgW, imgH);
        im = ImageUtil.loadEmptyImage(_w, _h);
        g2 = im.getGraphics();
        g2.setColor(Properties.bg);
        g2.fillRect(0, 0, _w, _h);
        for (int i = 0; i < l; ++i) {
            g2.setColor(argb[i]);
            if (++posX > imgW) {
                posX = 1;
                ++posY;
            }
            g2.fillRect((posX - 1) * imgSW, posY * imgSH, imgSW, imgSH);
        }
        return im;
    }

    public static Image getMaskedImage(Image image, int bgColor, int fgColor, int translateCol) {
        int l = image.getWidth() * image.getHeight();
        argb = new int[l];
        image.getRGB(argb, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        for (int i = 0; i < l; ++i) {
            if (argb[i] == bgColor) {
                ImageUtil.argb[i] = 0;
                continue;
            }
            if (argb[i] != fgColor) continue;
            ImageUtil.argb[i] = translateCol;
        }
        return ImageUtil.loadARGBImage(argb, image.getWidth(), image.getHeight(), true);
    }

    public static Image getNumberImage(char c) {
        if (c == '1') {
            im = GraphicsUtil.numbers[0];
        } else if (c == '2') {
            im = GraphicsUtil.numbers[1];
        } else if (c == '3') {
            im = GraphicsUtil.numbers[2];
        } else if (c == '4') {
            im = GraphicsUtil.numbers[3];
        } else if (c == '5') {
            im = GraphicsUtil.numbers[4];
        } else if (c == '6') {
            im = GraphicsUtil.numbers[5];
        } else if (c == '7') {
            im = GraphicsUtil.numbers[6];
        } else if (c == '8') {
            im = GraphicsUtil.numbers[7];
        } else if (c == '9') {
            im = GraphicsUtil.numbers[8];
        } else if (c == '0') {
            im = GraphicsUtil.numbers[9];
        }
        return im;
    }

    public static Image getSmallNumberImage(char c) {
        if (c == '1') {
            im = GraphicsUtil.smallNumbers[0];
        } else if (c == '2') {
            im = GraphicsUtil.smallNumbers[1];
        } else if (c == '3') {
            im = GraphicsUtil.smallNumbers[2];
        } else if (c == '4') {
            im = GraphicsUtil.smallNumbers[3];
        } else if (c == '5') {
            im = GraphicsUtil.smallNumbers[4];
        } else if (c == '6') {
            im = GraphicsUtil.smallNumbers[5];
        } else if (c == '7') {
            im = GraphicsUtil.smallNumbers[6];
        } else if (c == '8') {
            im = GraphicsUtil.smallNumbers[7];
        } else if (c == '9') {
            im = GraphicsUtil.smallNumbers[8];
        } else if (c == '0') {
            im = GraphicsUtil.smallNumbers[9];
        }
        return im;
    }
}

