/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.mobile.gameobjects;

import com.golden.gamedev.mobile.gameobjects.SimpleSprite;
import com.golden.gamedev.mobile.gameobjects.SpriteGroup;
import com.golden.gamedev.mobile.gameobjects.TileBackground;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;

public class PlayField {
    private LayerManager layer = null;
    public int x;
    public int y;
    public int w;
    public int h;
    private Vector v;

    public PlayField(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.layer = new LayerManager();
        this.layer.setViewWindow(x, y, w, h);
        this.v = new Vector();
    }

    public void update() {
        this.layer.setViewWindow(this.x, this.y, this.w, this.h);
        for (int i = 0; i < this.getSize(); ++i) {
            SimpleSprite s = (SimpleSprite)((Object)this.v.elementAt(i));
            if (!s.isActive()) {
                this.remove(s);
            }
            s.update();
        }
    }

    public void render(Graphics g, int x, int y) {
        this.layer.paint(g, x, y);
    }

    public void render(Graphics g) {
        this.layer.paint(g, this.x, this.y);
    }

    public void add(SpriteGroup s) {
        for (int i = 0; i < s.size(); ++i) {
            this.add(s.getSprite(i));
        }
    }

    public void add(SimpleSprite s) {
        this.layer.append((Layer)s);
        this.v.addElement(s);
    }

    public void remove(SpriteGroup s) {
        for (int i = 0; i < s.size(); ++i) {
            this.remove(s.getSprite(i));
        }
    }

    private void remove(SimpleSprite s) {
        this.layer.remove((Layer)s);
        this.v.removeElement((Object)s);
    }

    public int getSize() {
        return this.v.size();
    }

    public int getRoughSize() {
        return this.layer.getSize();
    }

    public void addTileBackground(TileBackground t) {
        this.layer.append((Layer)t);
    }

    public void removeTileBackground(TileBackground t) {
        this.layer.remove((Layer)t);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.layer.setViewWindow(this.x, this.y, this.w, this.h);
    }

    public void setDimension(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void clear() {
        if (this.getSize() > 0) {
            this.v.removeAllElements();
        }
        if (this.getRoughSize() > 0) {
            for (int i = 0; i < this.getRoughSize(); ++i) {
                Layer l = this.layer.getLayerAt(i);
                this.layer.remove(l);
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

