/*
 * Decompiled with CFR 0.152.
 */
import com.golden.gamedev.mobile.canvas.GCanvas;
import com.golden.gamedev.mobile.canvas.Properties;
import com.golden.gamedev.mobile.gameobjects.PlayField;
import com.golden.gamedev.mobile.gameobjects.SpriteGroup;
import com.golden.gamedev.mobile.gameobjects.TileBackground;
import com.golden.gamedev.mobile.media.Sound;
import com.golden.gamedev.mobile.objects.About;
import com.golden.gamedev.mobile.objects.Controls;
import com.golden.gamedev.mobile.objects.Credits;
import com.golden.gamedev.mobile.objects.Options;
import com.golden.gamedev.mobile.records.HighScores;
import com.golden.gamedev.mobile.utils.FontUtil;
import com.golden.gamedev.mobile.utils.GRandom;
import com.golden.gamedev.mobile.utils.GraphicsUtil;
import com.golden.gamedev.mobile.utils.ImageUtil;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class OACanvas
extends GCanvas {
    private OperationAlpha midlet = null;
    public static GRandom rand = null;
    public static int timer;
    public static int level;
    public static int missionIndex;
    public static int stars;
    public static PlayField playfield;
    private Image tileset = null;
    public static TileBackground background;
    private Image heroStatus = null;
    public static int heroLife;
    public static int heroHP;
    public static int heroBomb;
    public static int heroStar;
    public static Image heroImage;
    public static Soldier hero;
    public static SpriteGroup heroGROUP;
    public static Image heroBulletImage;
    public static Image heroSpecialImage;
    public static HeroBullet heroBullet;
    public static HeroSpecial heroSpecialBullet;
    public static SpriteGroup heroBulletGROUP;
    public static SpriteGroup heroSpecialBulletGROUP;
    private int heroRespawnTimer;
    public static Image heroShield;
    public static Image enemyImage;
    public static Image enemyBullet;
    public static SoldierGroup soldiers;
    public static SpriteGroup soldiersGroup;
    public static SpriteGroup soldiersBulletGroup;
    private int enemySoldierTimer;
    public static Image riderImage;
    public static Image riderBullet;
    public static RiderGroup riders;
    public static SpriteGroup ridersGroup;
    public static SpriteGroup ridersBulletGroup;
    private int enemyRiderTimer;
    public static Image copterImage;
    public static Image copterBullet;
    public static CopterGroup copters;
    public static SpriteGroup coptersGroup;
    public static SpriteGroup coptersBulletGroup;
    private int enemyCopterTimer;
    public static Image[] bossImage;
    public static Image[] bossStatusImage;
    public static Image bossBullet;
    public static BossGroup bosses;
    public static SpriteGroup bossesGroup;
    public static SpriteGroup bossesBulletGroup;
    private int enemyBossTimer;
    public static BossBullet boSSBullet;
    public static SpriteGroup boSSBulletGroup;
    public static Image bonusImage;
    private Sound music = null;
    private Sound ingameSound = null;
    private String[] about = new String[]{"It's time for Operation Alpha Zylon, ", "a fast paced shoot'em up in which ", "you have to destroy the enemy and ", "collect the stars from their uniforms.", " ", "Many stages of heavy fighting and", "brutal combat will lead you to final", "victory over the evil dictator!"};

    public OACanvas(OperationAlpha midlet) {
        super(midlet);
        this.midlet = midlet;
    }

    public void initGame() {
        this.music = new Sound("/music.mid", true);
        this.instalThemeMusic(this.music);
        this.ingameSound = new Sound("/music.mid", true);
        Properties.bg = -16631078;
        Properties.fg = -274427;
        Properties.sh = -4473162;
        About.setItemsAbout(this.about);
        Credits.setCredtis(1, "XING MOBILE");
        Controls.clear();
        Controls.setControl(0, "2");
        Controls.setControl(1, "UP");
        Controls.setControl(2, "8");
        Controls.setControl(3, "DOWN");
        Controls.setControl(4, "6");
        Controls.setControl(5, "RIGHT");
        Controls.setControl(6, "4");
        Controls.setControl(7, "LEFT");
        Controls.setControl(8, "5");
        Controls.setControl(9, "SHOOT");
        Controls.setControl(8, "5");
        Controls.setControl(9, "SHOOT");
        Controls.setControl(10, "1");
        Controls.setControl(11, "SPECIAL");
        Controls.setControl(14, "#");
        Controls.setControl(15, "PAUSE");
        Controls.setControl(16, "*");
        Controls.setControl(17, "EXIT");
        rand = new GRandom();
        level = 0;
        missionIndex = 0;
        this.tileset = ImageUtil.loadImage("/tileset.png");
        background = new TileBackground(4, 30, this.tileset, 48, 48, this.getMap());
        background.setPosition(0, 0);
        playfield = new PlayField(background.getWidth() / 2, background.getHeight() - Properties.height, Properties.width, Properties.height);
        this.heroStatus = ImageUtil.loadImage("/status.png");
        heroImage = ImageUtil.loadImage("/hero.png");
        heroBulletImage = ImageUtil.loadImage("/herobullet.png");
        heroSpecialImage = ImageUtil.loadImage("/herospecial.png");
        enemyImage = ImageUtil.loadImage("/soldier.png");
        enemyBullet = ImageUtil.loadImage("/soldierbullet.png");
        riderImage = ImageUtil.loadImage("/bike.png");
        riderBullet = ImageUtil.loadImage("/riderbullet.png");
        copterImage = ImageUtil.loadImage("/copter.png");
        copterBullet = ImageUtil.loadImage("/copterbullet.png");
        bossImage = new Image[3];
        bossStatusImage = new Image[3];
        OACanvas.bossImage[0] = ImageUtil.loadImage("/bossA.png");
        OACanvas.bossImage[1] = ImageUtil.loadImage("/bossB.png");
        OACanvas.bossImage[2] = ImageUtil.loadImage("/bossC.png");
        OACanvas.bossStatusImage[0] = ImageUtil.loadImage("/bossAstatus.png");
        OACanvas.bossStatusImage[1] = ImageUtil.loadImage("/bossBstatus.png");
        OACanvas.bossStatusImage[2] = ImageUtil.loadImage("/bossCstatus.png");
        bossBullet = ImageUtil.loadImage("/bossbullet.png");
        heroShield = ImageUtil.loadImage("/shield.png");
        bonusImage = ImageUtil.loadImage("/bonus.png");
        hero = new Soldier(heroImage, 24, 32);
        heroGROUP = new SpriteGroup("HERO GROUP");
        heroBullet = new HeroBullet(hero, heroBulletImage);
        heroSpecialBullet = new HeroSpecial(hero, heroSpecialImage);
        heroBulletGROUP = new SpriteGroup("HERO BULLET GROUP");
        heroSpecialBulletGROUP = new SpriteGroup("HERO SPECIAL BULLET GROUP");
        soldiers = new SoldierGroup();
        soldiersGroup = new SpriteGroup("ENEMY SOLDIER GROUP");
        soldiersBulletGroup = new SpriteGroup("ENEMY SOLDIER BULLET GROUP");
        riders = new RiderGroup();
        ridersGroup = new SpriteGroup("ENEMY RIDER GROUP");
        ridersBulletGroup = new SpriteGroup("ENEMY RIDER BULLET GROUP");
        copters = new CopterGroup();
        coptersGroup = new SpriteGroup("ENEMY COPTER GROUP");
        coptersBulletGroup = new SpriteGroup("ENEMY COPTER BULLET GROUP");
        bosses = new BossGroup();
        bossesGroup = new SpriteGroup("ENEMY BOSS GROUP");
        bossesBulletGroup = new SpriteGroup("ENEMY BOSS BULLET GROUP");
        boSSBullet = new BossBullet(bosses.getEnemyGroup()[0], bossBullet);
        boSSBulletGroup = new SpriteGroup("BOSS BULLET GROUP");
    }

    public void updateGame() {
        switch (missionIndex) {
            case 0: {
                if (++timer % 50 == 0) {
                    timer = 0;
                    this.playSound(this.ingameSound);
                    missionIndex = 1;
                }
                if (!this.isPressed(53)) break;
                this.playSound(this.ingameSound);
                missionIndex = 1;
                break;
            }
            case 1: {
                this.updateWar();
                break;
            }
            case 4: {
                this.updateWar();
                if (++timer % 10 != 0) break;
                timer = 0;
                if (heroStar > 0) {
                    ++stars;
                    HighScores.playersScore += 10;
                }
                if (--heroStar > 0) break;
                heroStar = 0;
                switch (level) {
                    case 0: {
                        if (stars < 20) {
                            hero.setFrameSequence(Status.DIE_SEQ);
                            missionIndex = 3;
                            break;
                        }
                        if (stars < 20) break;
                        missionIndex = 2;
                        break;
                    }
                    case 1: {
                        if (stars < 50) {
                            hero.setFrameSequence(Status.DIE_SEQ);
                            missionIndex = 3;
                            break;
                        }
                        if (stars < 20) break;
                        missionIndex = 2;
                        break;
                    }
                    case 2: {
                        if (stars < 100) {
                            hero.setFrameSequence(Status.DIE_SEQ);
                            missionIndex = 3;
                            break;
                        }
                        if (stars < 20) break;
                        missionIndex = 2;
                    }
                }
                break;
            }
            case 2: {
                this.updateWar();
                if (++timer % 50 != 0) break;
                timer = 0;
                ++level;
                if (++OACanvas.soldiers.numSoldier >= 8) {
                    OACanvas.soldiers.numSoldier = 8;
                }
                if (++OACanvas.riders.numSoldier >= 4) {
                    OACanvas.riders.numSoldier = 4;
                }
                if (level <= 2) {
                    this.clearPlayField();
                    this.addToPlayField();
                    missionIndex = 0;
                    break;
                }
                if (level <= 2) break;
                this.stopSound(this.ingameSound);
                missionIndex = 0;
                Properties.state = 13;
                break;
            }
            case 3: {
                playfield.update();
                hero.nextFrame();
                OACanvas.playfield.y += 4;
                hero.setLocation(OACanvas.playfield.x + playfield.getWidth() / 2 - 12, OACanvas.playfield.y + playfield.getHeight() / 2 - 16);
                if (OACanvas.playfield.y < background.getHeight() - Properties.height) break;
                OACanvas.playfield.y = background.getHeight() - Properties.height;
                this.resetWar();
                missionIndex = 1;
            }
        }
    }

    private void updateWar() {
        Soldier d;
        int n;
        Bullet bullet;
        int j;
        playfield.update();
        heroBullet.updateBullet();
        heroSpecialBullet.updateBullet();
        soldiers.updateSoldierGroup();
        riders.updateSoldierGroup();
        copters.updateSoldierGroup();
        if (OACanvas.playfield.y <= 0) {
            bosses.updateSoldierGroup();
            boSSBullet.updateBullet();
            if (OACanvas.bosses.getEnemyGroup()[OACanvas.level].status == 2 && OACanvas.bosses.getEnemyGroup()[OACanvas.level].y + 32 <= OACanvas.playfield.y) {
                missionIndex = 4;
            }
        }
        if (OACanvas.playfield.y > 0) {
            if (++timer % 2 == 0) {
                timer = 0;
                --OACanvas.playfield.y;
                if (OACanvas.playfield.y < 0) {
                    OACanvas.playfield.y = 0;
                }
                if (OACanvas.hero.y > playfield.getY() + playfield.getHeight() - 32) {
                    OACanvas.hero.y = playfield.getY() + playfield.getHeight() - 32;
                }
            }
            if (++this.enemySoldierTimer % 288 == 0) {
                this.enemySoldierTimer = 0;
                soldiers.resetEnemy();
            }
            if (++this.enemyRiderTimer % 320 == 0) {
                this.enemyRiderTimer = 0;
                riders.resetEnemy();
            }
            if (++this.enemyCopterTimer % 1000 == 0) {
                this.enemyCopterTimer = 0;
                copters.resetEnemy();
            }
        }
        if (OACanvas.hero.status != 2) {
            if (this.heroRespawnTimer < 30 && ++this.heroRespawnTimer % 2 == 0) {
                hero.setVisible(!hero.isVisible());
                if (this.heroRespawnTimer > 29) {
                    this.heroRespawnTimer = 30;
                    hero.setVisible(true);
                }
            }
            if (this.isDown(52)) {
                --OACanvas.playfield.x;
                if (OACanvas.playfield.x < 0) {
                    OACanvas.playfield.x = 0;
                }
                OACanvas.hero.x -= 2;
                if (OACanvas.hero.x < 0) {
                    OACanvas.hero.x = 0;
                }
            } else if (this.isDown(54)) {
                ++OACanvas.playfield.x;
                if (OACanvas.playfield.x >= background.getWidth() - playfield.getWidth()) {
                    OACanvas.playfield.x = background.getWidth() - playfield.getWidth();
                }
                OACanvas.hero.x += 2;
                if (OACanvas.hero.x > background.getWidth() - 24) {
                    OACanvas.hero.x = background.getWidth() - 24;
                }
            }
            if (this.isDown(56)) {
                OACanvas.hero.y += 2;
                if (OACanvas.hero.y > playfield.getY() + playfield.getHeight() - 32) {
                    OACanvas.hero.y = playfield.getY() + playfield.getHeight() - 32;
                }
            } else if (this.isDown(50)) {
                OACanvas.hero.y -= 2;
                if (OACanvas.hero.y < OACanvas.playfield.y) {
                    OACanvas.hero.y = OACanvas.playfield.y;
                }
            }
            if (this.isPressed(53)) {
                heroBullet.fire();
            }
            if (this.isPressed(49) && heroBomb > 0 && !OACanvas.heroSpecialBullet.isFire) {
                OACanvas.heroSpecialBullet.isFire = true;
                if (--heroBomb <= 0) {
                    heroBomb = 0;
                }
            }
            if (!(this.isDown(52) || this.isDown(54) || this.isDown(50) || this.isDown(56))) {
                if (OACanvas.hero.dir != 4) {
                    hero.setDir(4);
                }
            } else if (this.isPressed(50)) {
                hero.setDir(0);
            } else if (this.isPressed(56)) {
                hero.setDir(1);
            } else if (this.isPressed(52)) {
                hero.setDir(2);
            } else if (this.isPressed(54)) {
                hero.setDir(3);
            }
        } else if (OACanvas.hero.status == 2 && OACanvas.hero.y < OACanvas.playfield.y) {
            if (--heroLife >= 0) {
                this.heroRespawnTimer = 0;
                hero.reset();
                heroBullet.reset();
                OACanvas.hero.str = 30;
                heroHP = 30;
                hero.setVisible(true);
                hero.setLocation(playfield.getWidth() / 2 - 12, playfield.getHeight() - 64);
            } else if (heroLife < 0) {
                this.stopSound(this.ingameSound);
                missionIndex = 0;
                Properties.state = 12;
            }
        }
        for (int i = 0; i < heroGROUP.size(); ++i) {
            Soldier soldier = (Soldier)heroGROUP.getSprite(i);
            if (!soldier.isVisible() || soldier.status == 1 || soldier.status == 2 || this.heroRespawnTimer <= 29) continue;
            this.checkCollisionHeroEnemy(soldier, soldiersGroup, soldiersBulletGroup);
            this.checkCollisionHeroEnemy(soldier, ridersGroup, ridersBulletGroup);
            this.checkCollisionHeroEnemy(soldier, coptersGroup, coptersBulletGroup);
            this.checkCollisionHeroEnemy(soldier, bossesGroup, bossesBulletGroup);
            for (int p = 0; p < boSSBulletGroup.size(); ++p) {
                Bullet bullet2 = (Bullet)boSSBulletGroup.getSprite(p);
                if (!bullet2.isFire || !bullet2.isVisible() || !bullet2.collided(soldier, true)) continue;
                bullet2.reset();
                if (OACanvas.heroSpecialBullet.shield.isVisible()) continue;
                soldier.setStatus(1);
                if (--heroHP > 0) continue;
                heroHP = 0;
            }
        }
        for (j = 0; j < heroSpecialBulletGROUP.size(); ++j) {
            bullet = (Bullet)heroSpecialBulletGROUP.getSprite(j);
            if (!bullet.isFire || !bullet.isVisible()) continue;
            this.checkCollisionHeroBullet(soldiersGroup, bullet);
            this.checkCollisionHeroBullet(ridersGroup, bullet);
            this.checkCollisionHeroBullet(coptersGroup, bullet);
            this.checkCollisionHeroBulletEnemyBullet(soldiersBulletGroup, bullet);
            this.checkCollisionHeroBulletEnemyBullet(ridersBulletGroup, bullet);
            this.checkCollisionHeroBulletEnemyBullet(coptersBulletGroup, bullet);
            this.checkCollisionHeroBulletEnemyBullet(bossesBulletGroup, bullet);
            for (n = 0; n < bossesGroup.size(); ++n) {
                d = (Soldier)bossesGroup.getSprite(n);
                if (!d.isVisible() || d.status == 1 || d.status == 2 || !bullet.collided(d, true)) continue;
                bullet.reset();
                if (OACanvas.bosses.shield.isVisible()) continue;
                d.setStatus(1);
            }
        }
        for (j = 0; j < heroBulletGROUP.size(); ++j) {
            bullet = (Bullet)heroBulletGROUP.getSprite(j);
            if (!bullet.isFire || !bullet.isVisible()) continue;
            this.checkCollisionHeroBullet(soldiersGroup, bullet);
            this.checkCollisionHeroBullet(ridersGroup, bullet);
            this.checkCollisionHeroBullet(coptersGroup, bullet);
            for (n = 0; n < bossesGroup.size(); ++n) {
                d = (Soldier)bossesGroup.getSprite(n);
                if (!d.isVisible() || d.status == 1 || d.status == 2 || !bullet.collided(d, true)) continue;
                bullet.reset();
                if (OACanvas.bosses.shield.isVisible()) continue;
                d.setStatus(1);
            }
        }
    }

    private void checkCollisionHeroBulletEnemyBullet(SpriteGroup s, Bullet b) {
        for (int n = 0; n < s.size(); ++n) {
            Bullet d = (Bullet)s.getSprite(n);
            if (!d.isVisible() || !d.isFire || !b.collided(d, false)) continue;
            b.reset();
            d.reset();
        }
    }

    private void checkCollisionHeroBullet(SpriteGroup s, Bullet b) {
        for (int n = 0; n < s.size(); ++n) {
            Soldier d = (Soldier)s.getSprite(n);
            if (!d.isVisible() || d.status == 1 || d.status == 2 || !b.collided(d, true)) continue;
            b.reset();
            d.setStatus(1);
        }
    }

    private void checkCollisionHeroEnemy(Soldier s, SpriteGroup group, SpriteGroup groupBullet) {
        int p;
        for (p = 0; p < group.size(); ++p) {
            Soldier enemy = (Soldier)group.getSprite(p);
            if (!enemy.isVisible() || enemy.status == 2 || enemy.status == 1 || !enemy.collided(s, true) || OACanvas.heroSpecialBullet.shield.isVisible()) continue;
            s.setStatus(1);
            if (--heroHP > 0) continue;
            heroHP = 0;
        }
        for (p = 0; p < groupBullet.size(); ++p) {
            Bullet bullet = (Bullet)groupBullet.getSprite(p);
            if (!bullet.isFire || !bullet.isVisible() || !bullet.collided(s, true)) continue;
            bullet.reset();
            s.setStatus(1);
            if (OACanvas.heroSpecialBullet.shield.isVisible() || --heroHP > 0) continue;
            heroHP = 0;
        }
    }

    public void renderGame(Graphics g) {
        GraphicsUtil.clear(g);
        g.setClip(0, 0, playfield.getWidth(), playfield.getHeight());
        playfield.render(g, 0, 0);
        g.drawImage(this.heroStatus, 2, 2, 20);
        g.drawImage(bossStatusImage[level], 59, 2, 20);
        GraphicsUtil.drawSmallInt(g, heroLife, 30, 4);
        GraphicsUtil.drawSmallInt(g, heroBomb, 42, 4);
        GraphicsUtil.drawSmallInt(g, heroStar, 54, 4);
        g.setColor(46, 196, 24);
        g.fillRect(21, 12, heroHP, 4);
        if (OACanvas.bosses.getEnemyGroup()[OACanvas.level].status != 2) {
            g.setColor(255, 0, 0);
            g.fillRect(63, 12, 30 - bosses.getStr() / (1 + level), 4);
        }
        GraphicsUtil.drawInt(g, HighScores.playersScore, Properties.width, 2);
        switch (missionIndex) {
            case 0: {
                g.setColor(0, 0, 255);
                g.setFont(FontUtil.FMB);
                g.drawString("MISSION :", 20, 40, 20);
                switch (level) {
                    case 0: {
                        g.drawString("- Collect 20 Stars", 20, 40 + FontUtil.FMH, 20);
                        g.drawString("- Defeat Boss", 20, 40 + FontUtil.FMH * 2, 20);
                        break;
                    }
                    case 1: {
                        g.drawString("- Collect 50 Stars", 20, 40 + FontUtil.FMH, 20);
                        g.drawString("- Defeat Boss", 20, 40 + FontUtil.FMH * 2, 20);
                        break;
                    }
                    case 2: {
                        g.drawString("- Collect 100 Stars", 20, 40 + FontUtil.FMH, 20);
                        g.drawString("- Defeat Final Boss", 20, 40 + FontUtil.FMH * 2, 20);
                    }
                }
                break;
            }
            case 4: {
                g.setColor(0, 0, 255);
                g.setFont(FontUtil.FMB);
                g.drawString("MISSION RESULTS :", 20, 40, 20);
                g.drawString("- Stars : " + String.valueOf(stars), 20, 40 + FontUtil.FMH, 20);
                g.drawString("- Boss Defeated!", 20, 40 + FontUtil.FMH * 2, 20);
                break;
            }
            case 2: {
                g.setColor(0, 0, 255);
                g.setFont(FontUtil.FMB);
                g.drawString("MISSION COMPLETED !!!", 20, 40, 20);
                break;
            }
            case 3: {
                g.setColor(0, 0, 255);
                g.setFont(FontUtil.FMB);
                g.drawString("MISSION FAILED !!!", 20, 40, 20);
                g.drawString("- Collect More Stars!!!", 20, 40 + FontUtil.FMH, 20);
            }
        }
    }

    public void resetGame() {
        level = 0;
        timer = 0;
        heroLife = 2;
        heroBomb = 2;
        heroStar = 0;
        stars = 0;
        HeroBullet.numBullet = 1;
        OACanvas.soldiers.numSoldier = 6;
        OACanvas.riders.numSoldier = 3;
        this.clearPlayField();
        this.addToPlayField();
    }

    public void clearPlayField() {
        playfield.clear();
        heroGROUP.clear();
        heroBulletGROUP.clear();
        heroSpecialBulletGROUP.clear();
        soldiersBulletGroup.clear();
        soldiersGroup.clear();
        ridersGroup.clear();
        ridersBulletGroup.clear();
        coptersGroup.clear();
        coptersBulletGroup.clear();
        bossesGroup.clear();
        bossesBulletGroup.clear();
        boSSBulletGroup.clear();
    }

    public void addToPlayField() {
        playfield.setPosition(background.getWidth() / 2 - playfield.getWidth() / 2, background.getHeight() - Properties.height);
        hero.setLocation(background.getWidth() / 2 - 12, background.getHeight() - 64);
        this.resetWar();
        boSSBullet.addToGroup(boSSBulletGroup);
        heroGROUP.add(hero);
        heroBullet.addToGroup(heroBulletGROUP);
        heroSpecialBullet.addToGroup(heroSpecialBulletGROUP);
        soldiers.addToGroup(soldiersGroup, soldiersBulletGroup);
        riders.addToGroup(ridersGroup, ridersBulletGroup);
        copters.addToGroup(coptersGroup, coptersBulletGroup);
        bosses.addToGroup(bossesGroup, bossesBulletGroup);
        bosses.addBonusToPlayfield();
        copters.addBonusToPlayfield();
        riders.addBonusToPlayfield();
        soldiers.addBonusToPlayfield();
        playfield.add(coptersGroup);
        playfield.add(OACanvas.heroSpecialBullet.shield);
        playfield.add(OACanvas.bosses.shield);
        playfield.add(coptersBulletGroup);
        playfield.add(heroGROUP);
        playfield.add(heroSpecialBulletGROUP);
        playfield.add(heroBulletGROUP);
        playfield.add(boSSBulletGroup);
        playfield.add(bossesBulletGroup);
        playfield.add(ridersBulletGroup);
        playfield.add(soldiersBulletGroup);
        playfield.add(bossesGroup);
        playfield.add(ridersGroup);
        playfield.add(soldiersGroup);
        playfield.addTileBackground(background);
    }

    private void resetWar() {
        int i;
        hero.reset();
        OACanvas.hero.str = 30;
        heroHP = 30;
        hero.setVisible(true);
        heroBullet.reset();
        heroSpecialBullet.reset();
        this.heroRespawnTimer = 30;
        for (i = 0; i < soldiers.getEnemyGroup().length; ++i) {
            soldiers.getEnemyGroup()[i].reset();
        }
        soldiers.resetEnemy();
        this.enemySoldierTimer = 0;
        for (i = 0; i < riders.getEnemyGroup().length; ++i) {
            riders.getEnemyGroup()[i].reset();
        }
        riders.resetEnemy();
        this.enemyRiderTimer = 0;
        for (i = 0; i < copters.getEnemyGroup().length; ++i) {
            copters.getEnemyGroup()[i].reset();
        }
        copters.resetEnemy();
        this.enemyCopterTimer = 0;
        for (i = 0; i < bosses.getEnemyGroup().length; ++i) {
            bosses.getEnemyGroup()[i].reset();
        }
        boSSBullet.setOwner(bosses.getEnemyGroup()[level]);
        bosses.resetEnemy();
        this.enemyBossTimer = 0;
        boSSBullet.reset();
    }

    public void reVolume() {
        this.music.setVolume(Options.musicLevel);
        this.ingameSound.setVolume(Options.fxLevel);
    }

    public void cleanResources() {
        this.ingameSound.destroySound();
    }

    private int[][] getMap() {
        return new int[][]{{4, 5, 5, 6}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {7, 8, 8, 9}, {10, 11, 11, 12}};
    }

    static {
        playfield = null;
        background = null;
        heroImage = null;
        hero = null;
        heroGROUP = null;
        heroBulletImage = null;
        heroSpecialImage = null;
        heroBullet = null;
        heroSpecialBullet = null;
        heroBulletGROUP = null;
        heroSpecialBulletGROUP = null;
        heroShield = null;
        enemyImage = null;
        enemyBullet = null;
        soldiers = null;
        soldiersGroup = null;
        soldiersBulletGroup = null;
        riderImage = null;
        riderBullet = null;
        riders = null;
        ridersGroup = null;
        ridersBulletGroup = null;
        copterImage = null;
        copterBullet = null;
        copters = null;
        coptersGroup = null;
        coptersBulletGroup = null;
        bossImage = null;
        bossStatusImage = null;
        bossBullet = null;
        bosses = null;
        bossesGroup = null;
        bossesBulletGroup = null;
        boSSBullet = null;
        boSSBulletGroup = null;
        bonusImage = null;
    }
}

