/*
 * Decompiled with CFR 0.152.
 */
import com.golden.gamedev.mobile.gameobjects.SimpleSprite;
import com.golden.gamedev.mobile.gameobjects.SpriteGroup;
import javax.microedition.lcdui.Image;

public class HeroBullet {
    private Bullet[][] bullet = null;
    private int bulletRowIndex;
    public static int numBullet;
    private SimpleSprite owner;
    private int timer;

    public HeroBullet(SimpleSprite owner, Image img) {
        this.owner = owner;
        this.bullet = new Bullet[5][5];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.bullet[i][j] = new Bullet(owner, img);
            }
        }
        this.timer = 0;
        this.bulletRowIndex = 0;
        numBullet = 1;
    }

    public void updateBullet() {
        for (int i = 0; i < numBullet; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (this.bullet[i][j].y + 8 < OACanvas.playfield.y) {
                    this.bullet[i][j].reset();
                }
                if (!this.bullet[i][j].isFire) continue;
                this.bullet[i][j].y -= 8;
            }
        }
    }

    public void fire() {
        for (int i = 0; i < numBullet; ++i) {
            if (this.bullet[i][this.bulletRowIndex].isFire || this.bullet[i][this.bulletRowIndex].isVisible()) continue;
            this.reload(this.bulletRowIndex);
            this.bullet[i][this.bulletRowIndex].isFire = true;
            this.bullet[i][this.bulletRowIndex].setVisible(true);
        }
        if (++this.bulletRowIndex >= 5) {
            this.bulletRowIndex = 0;
        }
    }

    public void reset() {
        for (int i = 0; i < numBullet; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.bullet[i][j].reset();
            }
        }
    }

    public Bullet[][] getBullets() {
        return this.bullet;
    }

    public void addToGroup(SpriteGroup group) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                group.add(this.bullet[i][j]);
            }
        }
    }

    private void reload(int j) {
        switch (numBullet) {
            case 1: {
                this.bullet[0][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3, this.owner.getY());
                break;
            }
            case 2: {
                this.bullet[0][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 - 3, this.owner.getY());
                this.bullet[1][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 + 3, this.owner.getY());
                break;
            }
            case 3: {
                this.bullet[0][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3, this.owner.getY());
                this.bullet[1][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 - 6, this.owner.getY());
                this.bullet[2][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 + 6, this.owner.getY());
                break;
            }
            case 4: {
                this.bullet[0][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 - 3, this.owner.getY());
                this.bullet[1][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 + 3, this.owner.getY());
                this.bullet[2][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 - 9, this.owner.getY());
                this.bullet[3][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 + 9, this.owner.getY());
                break;
            }
            case 5: {
                this.bullet[0][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3, this.owner.getY());
                this.bullet[1][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 - 6, this.owner.getY());
                this.bullet[2][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 + 6, this.owner.getY());
                this.bullet[3][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 - 12, this.owner.getY());
                this.bullet[4][j].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3 + 12, this.owner.getY());
            }
        }
    }
}

