/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.mobile.records;

import com.golden.gamedev.mobile.canvas.Properties;
import com.golden.gamedev.mobile.objects.InputName;
import com.golden.gamedev.mobile.objects.Menu;
import com.golden.gamedev.mobile.utils.FontUtil;
import com.golden.gamedev.mobile.utils.GraphicsUtil;
import com.golden.gamedev.mobile.utils.Timer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class HighScores {
    public static final int HSCORESL = 8;
    public static int[] hScores = new int[8];
    public static String[] pNames = new String[8];
    public static boolean isHighScore = false;
    public static int rank = 9;
    private static boolean isBlink = false;
    public static int playersScore = 0;

    public static void readHiScores() {
        RecordStore rs = null;
        int numRecord = 0;
        try {
            rs = RecordStore.openRecordStore((String)"HIGHSCORE", (boolean)false);
            numRecord = rs.getNumRecords();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (rs != null && numRecord != 0) {
            try {
                for (int i = 0; i < 8; ++i) {
                    byte[] record = rs.getRecord(i + 1);
                    DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
                    HighScores.hScores[i] = istream.readInt();
                    HighScores.pNames[i] = istream.readUTF();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                rs.closeRecordStore();
            }
            catch (Exception e) {}
        } else {
            try {
                for (int i = 0; i < 8; ++i) {
                    HighScores.pNames[i] = "__________";
                    HighScores.hScores[i] = 0;
                    ByteArrayOutputStream bstream = new ByteArrayOutputStream(11);
                    DataOutputStream ostream = new DataOutputStream(bstream);
                    ostream.writeInt(hScores[i]);
                    ostream.writeUTF(pNames[i]);
                    ostream.flush();
                    ostream.close();
                    byte[] record = bstream.toByteArray();
                    rs.addRecord(record, 0, record.length);
                }
                rs.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void updateScores() {
        HighScores.readHiScores();
        try {
            int u;
            for (u = 0; u < 8 && playersScore <= hScores[u]; ++u) {
            }
            if (u < 8) {
                for (int j = 7; j > u; --j) {
                    HighScores.hScores[j] = hScores[j - 1];
                    HighScores.pNames[j] = pNames[j - 1];
                }
                HighScores.hScores[u] = playersScore;
                HighScores.pNames[u] = new String(InputName.pCharName);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static void writeHiScores() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)"HIGHSCORE", (boolean)true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            for (int i = 0; i < 8; ++i) {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(11);
                DataOutputStream ostream = new DataOutputStream(bstream);
                ostream.writeInt(hScores[i]);
                ostream.writeUTF(pNames[i]);
                ostream.flush();
                ostream.close();
                byte[] recordData2 = bstream.toByteArray();
                rs.setRecord(i + 1, recordData2, 0, recordData2.length);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showHighScores(Graphics g) {
        GraphicsUtil.clear(g);
        g.setColor(Properties.fg);
        g.setFont(FontUtil.FMB);
        g.drawString(Menu.getMenu(2), Properties.midW - FontUtil.FMB.stringWidth(Menu.getMenu(2)) / 2, 20, 20);
        g.setFont(FontUtil.FS);
        try {
            int i;
            for (i = 0; i < 8; ++i) {
                if (isHighScore) {
                    if (i == rank) continue;
                    g.drawString(pNames[i], 10, 50 + i * (FontUtil.FSH + 1), 20);
                    GraphicsUtil.drawInt(g, hScores[i], Properties.width - 10, 50 + i * (FontUtil.FSH + 1));
                    continue;
                }
                if (isHighScore) continue;
                g.drawString(pNames[i], 10, 50 + i * (FontUtil.FSH + 1), 20);
                GraphicsUtil.drawInt(g, hScores[i], Properties.width - 10, 50 + i * (FontUtil.FSH + 1));
            }
            if (isHighScore) {
                InputName.showName(g, 10, 50 + rank * (FontUtil.FSH + 1));
                GraphicsUtil.drawInt(g, playersScore, Properties.width - 10, 50 + rank * (FontUtil.FSH + 1));
                InputName.charLengthTemp = 0;
                for (i = 0; i < InputName.cursor; ++i) {
                    InputName.charLengthTemp += FontUtil.FS.charWidth(InputName.pCharName[i]);
                }
                InputName.charLength = InputName.charLengthTemp;
                if (Timer.elapsed(5)) {
                    boolean bl = isBlink = !isBlink;
                }
                if (isBlink) {
                    g.drawLine(10 + InputName.charLength, 50 + rank * (FontUtil.FSH + 1) + (FontUtil.FSH - 1), 10 + InputName.charLength + FontUtil.FS.charWidth(InputName.pCharName[InputName.cursor]), 50 + rank * (FontUtil.FSH + 1) + (FontUtil.FSH - 1));
                }
                g.drawString("0-9 Key to insert character", 10, Properties.height - FontUtil.FSH * 3, 20);
                g.drawString("# Key to select next character", 10, Properties.height - FontUtil.FSH * 2, 20);
                g.drawString("* Key to finish", 10, Properties.height - FontUtil.FSH, 20);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

