/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.mobile.objects;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;

public class TileBackground
extends TiledLayer {
    public static final int MAP64P = 6;
    public static final int MAP32P = 5;
    public static final int MAP16P = 4;
    private static int time;
    private static int frame;
    private static int tile_size;

    public TileBackground(int cols, int rows, Image image, int imageWidth, int imageHeight, int[][] map) {
        super(cols, rows, image, imageWidth, imageHeight);
        for (int y = 0; y < map.length; ++y) {
            for (int x = 0; x < map[y].length; ++x) {
                this.setCell(x, y, map[y][x]);
            }
        }
        frame = 0;
        time = 0;
        tile_size = image.getWidth() / cols;
    }

    public void reLocateMap(int[][] map) {
        for (int y = 0; y < map.length; ++y) {
            for (int x = 0; x < map[y].length; ++x) {
                this.setCell(x, y, map[y][x]);
            }
        }
    }

    public TileBackground(int cols, int rows, Image image, int imageWidth, int imageHeight, int[][] map, int staticTileIndex) {
        super(cols, rows, image, imageWidth, imageHeight);
        this.createAnimatedTile(staticTileIndex);
        for (int y = 0; y < map.length; ++y) {
            for (int x = 0; x < map[y].length; ++x) {
                this.setCell(x, y, map[y][x]);
            }
        }
        frame = 0;
        time = 0;
        tile_size = image.getWidth() / cols;
    }

    public void animate(int staticTileIndex, int[] frames, int timePerFrame) {
        if (++time >= timePerFrame) {
            time = 0;
            if (++frame >= frames.length) {
                frame = 0;
            }
            this.setAnimatedTile(staticTileIndex, frames[frame]);
        }
    }

    public static int pixelsToTiles(int pixels) {
        return pixels / tile_size;
    }

    public static int pixelsToTiles(int pixels, int power) {
        return pixels >> power;
    }

    public static int tilesToPixels(int numTiles) {
        return numTiles * tile_size;
    }

    public static int tilesToPixels(int numTiles, int power) {
        return numTiles << power;
    }

    public boolean isIndexSameAs(int posx, int posy, int power, int tileIndex) {
        return this.getCell(TileBackground.pixelsToTiles(posx, power), TileBackground.pixelsToTiles(posy, power)) == tileIndex;
    }
}

