/*
 * Decompiled with CFR 0.152.
 */
import com.golden.gamedev.mobile.gameobjects.SimpleSprite;
import com.golden.gamedev.mobile.gameobjects.SpriteGroup;
import javax.microedition.lcdui.Image;

public class HeroSpecial {
    private Bullet[] bullet = null;
    private SimpleSprite owner;
    public SimpleSprite shield;
    private int timer;
    public boolean isFire;

    public HeroSpecial(SimpleSprite owner, Image img) {
        this.owner = owner;
        this.bullet = new Bullet[8];
        for (int i = 0; i < 8; ++i) {
            this.bullet[i] = new Bullet(owner, img);
        }
        this.timer = 0;
        this.isFire = false;
        this.shield = new SimpleSprite(OACanvas.heroShield, 24, 32);
        this.shield.setFrameSequence(Status.SHIELD_SEQ);
        this.shield.setVisible(false);
        this.shield.setLocation(owner.x, owner.y);
    }

    public void updateBullet() {
        if (this.outBoundary(this.bullet[0]) && this.outBoundary(this.bullet[1]) && this.outBoundary(this.bullet[2]) && this.outBoundary(this.bullet[3]) && this.outBoundary(this.bullet[4]) && this.outBoundary(this.bullet[5]) && this.outBoundary(this.bullet[6]) && this.outBoundary(this.bullet[7])) {
            this.reset();
        }
        for (int i = 0; i < 8; ++i) {
            if (this.bullet[i].y + 8 >= OACanvas.playfield.y && this.bullet[i].y + 8 <= OACanvas.playfield.y + OACanvas.playfield.getHeight() && this.bullet[i].x + 8 >= OACanvas.playfield.x && this.bullet[i].x + 8 <= OACanvas.playfield.x + OACanvas.playfield.getWidth()) continue;
            this.bullet[i].reset();
        }
        if (this.isFire) {
            if (++this.timer > 30) {
                this.timer = 0;
                this.isFire = false;
            }
            if (this.timer % 3 == 0) {
                this.fire();
            }
            this.shield.setVisible(true);
            this.shield.nextFrame();
            this.shield.setLocation(this.owner.x, this.owner.y);
        } else if (!this.isFire && this.shield.isVisible()) {
            this.shield.setVisible(false);
        }
        if (this.bullet[0].isFire) {
            this.bullet[0].x += 0;
            this.bullet[0].y -= 12;
        }
        if (this.bullet[1].isFire) {
            this.bullet[1].x -= 12;
            this.bullet[1].y -= 12;
        }
        if (this.bullet[2].isFire) {
            this.bullet[2].x -= 12;
            this.bullet[2].y += 12;
        }
        if (this.bullet[3].isFire) {
            this.bullet[3].x -= 12;
            this.bullet[3].y += 12;
        }
        if (this.bullet[4].isFire) {
            this.bullet[4].x += 0;
            this.bullet[4].y += 12;
        }
        if (this.bullet[5].isFire) {
            this.bullet[5].x += 12;
            this.bullet[5].y += 12;
        }
        if (this.bullet[6].isFire) {
            this.bullet[6].x += 12;
            this.bullet[6].y += 0;
        }
        if (this.bullet[7].isFire) {
            this.bullet[7].x += 12;
            this.bullet[7].y -= 12;
        }
    }

    public void fire() {
        for (int i = 0; i < 8; ++i) {
            if (this.bullet[i].isFire || this.bullet[i].isVisible()) continue;
            this.reload(i);
            this.isFire = true;
            this.bullet[i].isFire = true;
            this.bullet[i].setVisible(true);
        }
    }

    public void reset() {
        for (int i = 0; i < 8; ++i) {
            this.bullet[i].reset();
        }
    }

    public Bullet[] getBullets() {
        return this.bullet;
    }

    public void addToGroup(SpriteGroup group) {
        for (int i = 0; i < 8; ++i) {
            group.add(this.bullet[i]);
        }
    }

    private void reload(int a) {
        this.bullet[a].setLocation(this.owner.getX() + this.owner.getWidth() / 2 - 3, this.owner.getY() + this.owner.getHeight() / 2 - 4);
    }

    private boolean outBoundary(Bullet a) {
        return a.y + 8 < OACanvas.playfield.y || a.y + 8 > OACanvas.playfield.y + OACanvas.playfield.getHeight() || a.x + 8 < OACanvas.playfield.x || a.x + 8 > OACanvas.playfield.x + OACanvas.playfield.getWidth();
    }

    public void setOwner(SimpleSprite owner) {
        this.owner = owner;
    }
}

