/*
 * Decompiled with CFR 0.152.
 */
import com.golden.gamedev.mobile.gameobjects.SimpleSprite;
import com.golden.gamedev.mobile.gameobjects.SpriteGroup;

public class BossGroup {
    public Soldier[] enemies = new Soldier[3];
    public Bullet[] bullets = new Bullet[3];
    public int numSoldier;
    public boolean left;
    public Bonus[] bonus = new Bonus[3];
    public SimpleSprite shield;

    public BossGroup() {
        for (int i = 0; i < this.enemies.length; ++i) {
            this.enemies[i] = new Soldier(OACanvas.bossImage[i], 24, 32);
            this.bullets[i] = new Bullet(this.enemies[i], OACanvas.copterBullet);
            this.bonus[i] = new Bonus(this.enemies[i]);
        }
        this.numSoldier = 3;
        this.left = false;
        this.shield = new SimpleSprite(OACanvas.heroShield, 24, 32);
        this.shield.setFrameSequence(Status.SHIELD_SEQ);
        this.shield.setVisible(false);
        this.shield.setLocation(this.enemies[0].x, this.enemies[0].y);
    }

    public void updateSoldierGroup() {
        this.bonus[OACanvas.level].updateBonus();
        if (this.enemies[OACanvas.level].status == 2 && !this.bonus[OACanvas.level].isVisible()) {
            this.bonus[OACanvas.level].setBonus(this.enemies[OACanvas.level], 0);
        }
        if (this.enemies[OACanvas.level].y > OACanvas.playfield.y + OACanvas.playfield.getHeight()) {
            this.enemies[OACanvas.level].setVisible(false);
            this.enemies[OACanvas.level].reset();
        }
        if (this.bullets[OACanvas.level].y > OACanvas.playfield.y + OACanvas.playfield.getHeight()) {
            this.bullets[OACanvas.level].reset();
        }
        if (this.bullets[OACanvas.level].isFire) {
            this.bullets[OACanvas.level].y += 2 + OACanvas.level;
            this.bullets[OACanvas.level].x = OACanvas.hero.x > this.enemies[OACanvas.level].x + 24 ? (this.bullets[OACanvas.level].x += 2 + OACanvas.level) : (OACanvas.hero.x + 24 < this.enemies[OACanvas.level].x ? (this.bullets[OACanvas.level].x -= 2 + OACanvas.level) : (this.bullets[OACanvas.level].x += 0));
        }
        if (this.enemies[OACanvas.level].y > OACanvas.playfield.y + 32 && ++this.enemies[OACanvas.level].timer % 4 == 0) {
            this.enemies[OACanvas.level].timer = 0;
            if (!this.bullets[OACanvas.level].isFire) {
                this.bullets[OACanvas.level].setLocation(this.enemies[OACanvas.level].getX() + this.enemies[OACanvas.level].getWidth() / 2 - 3, this.enemies[OACanvas.level].getY() + 32);
                this.bullets[OACanvas.level].isFire = true;
                this.bullets[OACanvas.level].setVisible(true);
            }
        }
        switch (this.enemies[OACanvas.level].dir) {
            case 0: {
                --this.enemies[OACanvas.level].y;
                this.enemies[OACanvas.level].x += 0;
                if (this.enemies[OACanvas.level].y >= OACanvas.playfield.y) break;
                this.enemies[OACanvas.level].dir = 1;
                break;
            }
            case 1: {
                this.shield.setVisible(true);
                this.shield.nextFrame();
                this.shield.setLocation(this.enemies[OACanvas.level].x, this.enemies[OACanvas.level].y);
                if (++this.enemies[OACanvas.level].timer % 4 == 0) {
                    OACanvas.boSSBullet.fire();
                }
                this.enemies[OACanvas.level].y += 2;
                if (this.left) {
                    this.enemies[OACanvas.level].x += 2;
                } else if (!this.left) {
                    this.enemies[OACanvas.level].x -= 2;
                }
                if (this.enemies[OACanvas.level].y <= OACanvas.playfield.y + OACanvas.playfield.getHeight() - OACanvas.playfield.getHeight() / 3) break;
                this.enemies[OACanvas.level].dir = 0;
                boolean bl = this.left = !this.left;
                if (!this.shield.isVisible()) break;
                this.shield.setVisible(false);
                break;
            }
            case 4: {
                this.enemies[OACanvas.level].y += 0;
                this.enemies[OACanvas.level].x += 0;
            }
        }
    }

    public void resetEnemy() {
        boolean bl = this.left = !this.left;
        if (this.left) {
            this.enemies[OACanvas.level].setLocation(0, -32);
        } else {
            this.enemies[OACanvas.level].setLocation(168, -32);
        }
        this.enemies[OACanvas.level].setStr((1 + OACanvas.level) * 30);
        this.enemies[OACanvas.level].setDir(1);
        this.enemies[OACanvas.level].setStatus(0);
        this.enemies[OACanvas.level].setVisible(true);
    }

    public void addToGroup(SpriteGroup a, SpriteGroup b) {
        a.add(this.enemies[OACanvas.level]);
        b.add(this.bullets[OACanvas.level]);
    }

    public Soldier[] getEnemyGroup() {
        return this.enemies;
    }

    public void addBonusToPlayfield() {
        OACanvas.playfield.add(this.bonus[OACanvas.level]);
    }

    public int getStr() {
        return this.enemies[OACanvas.level].getStr();
    }
}

