/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.mobile.objects;

import com.golden.gamedev.mobile.canvas.Properties;
import com.golden.gamedev.mobile.objects.Menu;
import com.golden.gamedev.mobile.utils.FontUtil;
import com.golden.gamedev.mobile.utils.GraphicsUtil;
import javax.microedition.lcdui.Graphics;

public class Controls {
    public static String[] itemsControls = new String[]{"2", "up", "4", "left", "5", "jump", "6", "right", "8", "down", "*", "menu", "#", "pause", "1", "nw", "3", "ne", "7", "sw", "9", "se"};
    public static final int CONTROL_UP_KEY = 0;
    public static final int CONTROL_UP = 1;
    public static final int CONTROL_LEFT_KEY = 2;
    public static final int CONTROL_LEFT = 3;
    public static final int CONTROL_FIRE_KEY = 4;
    public static final int CONTROL_FIRE = 5;
    public static final int CONTROL_RIGHT_KEY = 6;
    public static final int CONTROL_RIGHT = 7;
    public static final int CONTROL_DOWN_KEY = 8;
    public static final int CONTROL_DOWN = 9;
    public static final int CONTROL_STAR_KEY = 10;
    public static final int CONTROL_STAR = 11;
    public static final int CONTROL_POUND_KEY = 12;
    public static final int CONTROL_POUND = 13;
    public static final int CONTROL_NW_KEY = 14;
    public static final int CONTROL_NW = 15;
    public static final int CONTROL_NE_KEY = 16;
    public static final int CONTROL_NE = 17;
    public static final int CONTROL_SW_KEY = 18;
    public static final int CONTROL_SW = 19;
    public static final int CONTROL_SE_KEY = 20;
    public static final int CONTROL_SE = 21;

    public static String getControl(int control) {
        return itemsControls[control];
    }

    public static void setControl(int control, String newControl) {
        Controls.itemsControls[control] = newControl;
    }

    public static void clear() {
        for (int i = 0; i < itemsControls.length; ++i) {
            Controls.itemsControls[i] = "";
        }
    }

    public static void showControls(Graphics g) {
        GraphicsUtil.clear(g);
        g.setColor(Properties.fg);
        g.setFont(FontUtil.FMB);
        g.drawString(Menu.getMenu(3), Properties.midW - FontUtil.FMB.stringWidth(Menu.getMenu(3)) / 2, 40, 20);
        g.setFont(FontUtil.FS);
        int a = itemsControls.length;
        int h = FontUtil.FSH / 2;
        for (int i = 0; i < a; i += 2) {
            g.drawString(Controls.getControl(i), Properties.midW - FontUtil.FS.stringWidth(Controls.getControl(0)) - 10, 70 + i * h, 20);
        }
        for (int j = 1; j < a; j += 2) {
            g.drawString(Controls.getControl(j), Properties.midW + 10, 70 + (j - 1) * h, 20);
        }
    }
}

