/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.mobile.media;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    private Player dP = null;
    private InputStream is = null;
    private ToneControl tC = null;
    private VolumeControl vC = null;

    public Player getPlayer() {
        return this.dP;
    }

    public Sound(String f, boolean loop) {
        this.initSound(f, loop);
        this.addVolume();
    }

    public Sound(byte[] sequence, boolean loop) {
        this.initTone(sequence, loop);
        this.addVolume();
    }

    public Player initSound(String f, boolean loop) {
        try {
            this.is = this.getClass().getResourceAsStream(f);
            if (f.toLowerCase().endsWith(".mid")) {
                this.dP = Manager.createPlayer((InputStream)this.is, (String)"audio/midi");
            } else if (f.toLowerCase().endsWith(".wav")) {
                this.dP = Manager.createPlayer((InputStream)this.is, (String)"audio/x-wav");
            } else if (f.toLowerCase().endsWith(".mp3")) {
                this.dP = Manager.createPlayer((InputStream)this.is, (String)"audio/mpeg");
            } else if (f.toLowerCase().endsWith(".au")) {
                this.dP = Manager.createPlayer((InputStream)this.is, (String)"audio/basic");
            }
            if (loop) {
                this.dP.setLoopCount(-1);
            }
            this.dP.prefetch();
        }
        catch (IOException ioe) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        return this.dP;
    }

    public Player initTone(byte[] sequence, boolean loop) {
        try {
            this.dP = Manager.createPlayer((String)"device://tone");
            this.dP.realize();
            this.tC = (ToneControl)this.dP.getControl("ToneControl");
            this.tC.setSequence(sequence);
            if (loop) {
                this.dP.setLoopCount(-1);
            }
        }
        catch (IOException ioe) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        return this.dP;
    }

    public void destroySound() {
        try {
            this.dP.stop();
            this.dP.close();
            this.dP = null;
            this.is = null;
            this.tC = null;
            this.vC = null;
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public VolumeControl addVolume() {
        this.vC = (VolumeControl)this.dP.getControl("VolumeControl");
        return this.vC;
    }

    public void setVolume(int level) {
        this.vC.setLevel(level);
    }
}

