/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.mobile.canvas;

import com.golden.gamedev.mobile.canvas.Properties;
import com.golden.gamedev.mobile.media.Sound;
import com.golden.gamedev.mobile.objects.About;
import com.golden.gamedev.mobile.objects.AlphabetKey;
import com.golden.gamedev.mobile.objects.Controls;
import com.golden.gamedev.mobile.objects.Credits;
import com.golden.gamedev.mobile.objects.InputName;
import com.golden.gamedev.mobile.objects.Menu;
import com.golden.gamedev.mobile.objects.Options;
import com.golden.gamedev.mobile.objects.ProgressBar;
import com.golden.gamedev.mobile.records.HighScores;
import com.golden.gamedev.mobile.utils.FontUtil;
import com.golden.gamedev.mobile.utils.GraphicsUtil;
import com.golden.gamedev.mobile.utils.Timer;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class GCanvas
extends Canvas
implements Runnable {
    private MIDlet midlet = null;
    private boolean sleep;
    private Thread t = null;
    private static final long MAX_CPS = 20L;
    public ProgressBar progressBar = null;
    private int[] keyPressed = new int[6];
    private int[] keyReleased = new int[6];
    private int[] keyDown = new int[12];
    private short pressedKey = 0;
    private short releasedKey = 0;
    private final int UNDEFINED_KEY;
    private Player themeSound = null;

    public GCanvas(MIDlet midlet) {
        this.UNDEFINED_KEY = -100;
        this.midlet = midlet;
        Properties.width = this.getWidth();
        Properties.midW = Properties.width / 2;
        Properties.height = this.getHeight();
        Properties.midH = Properties.height / 2;
        this.progressBar = new ProgressBar(this);
        HighScores.updateScores();
        HighScores.writeHiScores();
        this.progressBar.next(50);
    }

    public void start() {
        this.initGame();
        if (Properties.fg != -1) {
            GraphicsUtil.reCreateImageTemp();
        }
        this.progressBar.next(100);
        this.progressBar.nextGameState(1);
        this.sleep = false;
        this.t = new Thread(this);
        this.t.start();
    }

    public void stop() {
        this.sleep = true;
        this.t = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread ct = Thread.currentThread();
        for (int i = 0; i < this.keyDown.length; ++i) {
            this.keyDown[i] = -100;
        }
        if (!Properties.isUpdate) {
            while (!this.isShown()) {
                ct.yield();
            }
            Properties.width = this.getWidth();
            Properties.midW = Properties.width / 2;
            Properties.height = this.getHeight();
            Properties.midH = Properties.height / 2;
        }
        try {
            while (ct == this.t && !this.sleep) {
                long st = System.currentTimeMillis();
                this.updateCanvas();
                this.releasedKey = 0;
                this.pressedKey = 0;
                this.repaint();
                this.serviceRepaints();
                long tt = System.currentTimeMillis() - st;
                if (tt < 20L) {
                    GCanvas gCanvas = this;
                    synchronized (gCanvas) {
                        this.wait(20L - tt);
                        continue;
                    }
                }
                ct.yield();
            }
            this.midlet.notifyDestroyed();
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void updateCanvas() {
        switch (Properties.state) {
            case 1: {
                if (!Timer.elapsed(50)) break;
                Properties.state = 2;
                break;
            }
            case 2: {
                if (Timer.elapsed(50)) {
                    Properties.state = 3;
                }
                this.playThemeMusic();
                break;
            }
            case 3: {
                if (this.isPressed(56)) {
                    if (++Menu.menuID <= Menu.mainMenuItems) break;
                    Menu.menuID = 1;
                    break;
                }
                if (this.isPressed(50)) {
                    if (--Menu.menuID >= 1) break;
                    Menu.menuID = Menu.mainMenuItems;
                    break;
                }
                if (!this.isPressed(53)) break;
                if (Menu.menuID == 1) {
                    this.stopThemeMusic();
                    this.resetGame();
                } else if (Menu.menuID == 7) {
                    this.destroyThemeMusic();
                }
                Properties.nextState();
                break;
            }
            case 4: {
                this.updateGame();
                if (this.isPressed(35)) {
                    Properties.state = 11;
                    break;
                }
                if (!this.isPressed(42)) break;
                Properties.state = 9;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 15: {
                if (!this.isPressed(53)) break;
                Properties.backToMenu();
                break;
            }
            case 7: {
                if (this.isPressed(52)) {
                    if (Options.whichMusic == 0) {
                        if (Options.musicLevel > 0) {
                            Options.musicLevel -= 20;
                        }
                        this.reVolume();
                        break;
                    }
                    if (Options.whichMusic != 1) break;
                    if (Options.fxLevel > 0) {
                        Options.fxLevel -= 20;
                    }
                    this.reVolume();
                    break;
                }
                if (this.isPressed(54)) {
                    if (Options.whichMusic == 0) {
                        if (Options.musicLevel < 100) {
                            Options.musicLevel += 20;
                        }
                        this.reVolume();
                        break;
                    }
                    if (Options.whichMusic != 1) break;
                    if (Options.fxLevel < 100) {
                        Options.fxLevel += 20;
                    }
                    this.reVolume();
                    break;
                }
                if (this.isPressed(50)) {
                    if (--Options.whichMusic >= 0) break;
                    Options.whichMusic = 1;
                    break;
                }
                if (this.isPressed(56)) {
                    if (++Options.whichMusic <= 1) break;
                    Options.whichMusic = 0;
                    break;
                }
                if (!this.isPressed(53)) break;
                Properties.backToMenu();
                break;
            }
            case 10: {
                if (this.isKeyPressed(42)) {
                    HighScores.updateScores();
                    HighScores.writeHiScores();
                    Properties.state = 5;
                    HighScores.playersScore = 0;
                    HighScores.isHighScore = false;
                    HighScores.rank = 9;
                    break;
                }
                if (this.isKeyPressed(35)) {
                    if (++InputName.cursor > InputName.pCharName.length - 1) {
                        InputName.cursor = 0;
                    }
                    AlphabetKey.cursor = 0;
                    break;
                }
                if (this.isKeyPressed(49)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_1.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_1);
                    break;
                }
                if (this.isKeyPressed(50)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_2.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_2);
                    break;
                }
                if (this.isKeyPressed(51)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_3.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_3);
                    break;
                }
                if (this.isKeyPressed(52)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_4.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_4);
                    break;
                }
                if (this.isKeyPressed(53)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_5.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_5);
                    break;
                }
                if (this.isKeyPressed(54)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_6.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_6);
                    break;
                }
                if (this.isKeyPressed(55)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_7.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_7);
                    break;
                }
                if (this.isKeyPressed(56)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_8.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_8);
                    break;
                }
                if (this.isKeyPressed(57)) {
                    if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_9.length - 1) {
                        AlphabetKey.cursor = 0;
                    }
                    InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_9);
                    break;
                }
                if (!this.isKeyPressed(48)) break;
                if (++AlphabetKey.cursor > AlphabetKey.alphabetKey_0.length - 1) {
                    AlphabetKey.cursor = 0;
                }
                InputName.pCharName[InputName.cursor] = AlphabetKey.getKeyChar(AlphabetKey.alphabetKey_0);
                break;
            }
            case 9: {
                if (this.isPressed(52)) {
                    if (Properties.exit != 0) break;
                    Properties.exit = 1;
                    break;
                }
                if (this.isPressed(54)) {
                    if (Properties.exit != 1) break;
                    Properties.exit = 0;
                    break;
                }
                if (!this.isPressed(53)) break;
                Properties.state = Properties.exit == 0 ? 4 : 3;
                this.playThemeMusic();
                HighScores.playersScore = 0;
                break;
            }
            case 11: {
                if (!this.isPressed(35) && !this.isPressed(42)) break;
                Properties.state = 4;
                break;
            }
            case 12: 
            case 13: {
                if (!this.isPressed(53) && !Timer.elapsed(200)) break;
                HighScores.readHiScores();
                this.playThemeMusic();
                if (HighScores.playersScore > HighScores.hScores[7]) {
                    try {
                        int u;
                        for (u = 0; u < 8 && HighScores.playersScore <= HighScores.hScores[u]; ++u) {
                        }
                        if (u >= 8) break;
                        HighScores.rank = u;
                        HighScores.isHighScore = true;
                        Properties.state = 10;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    break;
                }
                Properties.state = 5;
                break;
            }
            case 14: {
                this.cleanResources();
                this.stop();
            }
        }
    }

    private void paintMenu(Graphics g) {
        switch (Properties.state) {
            case 0: {
                GraphicsUtil.clear(g);
                this.progressBar.render(g);
                break;
            }
            case 1: {
                GraphicsUtil.clear(g);
                GraphicsUtil.centeredImage(g, Properties.publisher);
                break;
            }
            case 2: {
                GraphicsUtil.clear(g);
                GraphicsUtil.centeredImage(g, Properties.developer);
                break;
            }
            case 3: {
                GraphicsUtil.clear(g);
                GraphicsUtil.centeredImage(g, Properties.logo);
                for (int i = Menu.mainMenuItems; i > 0; --i) {
                    Menu.render(g, Menu.getMenu(i), i);
                }
                Menu.renderActiveItem(g);
                break;
            }
            case 4: {
                this.renderGame(g);
                break;
            }
            case 5: 
            case 10: {
                HighScores.showHighScores(g);
                break;
            }
            case 6: {
                Controls.showControls(g);
                break;
            }
            case 7: {
                Options.showOptions(g);
                break;
            }
            case 8: {
                Credits.showCredits(g);
                break;
            }
            case 15: {
                About.showAbout(g);
                break;
            }
            case 9: {
                GraphicsUtil.clear(g);
                g.setColor(Properties.fg);
                g.setFont(FontUtil.FMB);
                GraphicsUtil.centeredText(g, Menu.getMenu(10));
                switch (Properties.exit) {
                    case 0: {
                        g.drawString(Menu.getMenu(11) + "    [" + Menu.getMenu(12) + "]", Properties.midW - FontUtil.FM.stringWidth(Menu.getMenu(11) + "    [" + Menu.getMenu(12) + "]") / 2, Properties.midH + FontUtil.FMH, 20);
                        break;
                    }
                    case 1: {
                        g.drawString("[" + Menu.getMenu(11) + "]    " + Menu.getMenu(12), Properties.midW - FontUtil.FM.stringWidth("[" + Menu.getMenu(11) + "]    " + Menu.getMenu(12)) / 2, Properties.midH + FontUtil.FMH, 20);
                    }
                }
                break;
            }
            case 11: {
                GraphicsUtil.clear(g);
                g.setColor(Properties.fg);
                g.setFont(FontUtil.FMB);
                GraphicsUtil.centeredText(g, Menu.getMenu(9));
                break;
            }
            case 12: {
                GraphicsUtil.clear(g);
                g.setColor(Properties.fg);
                g.setFont(FontUtil.FMB);
                GraphicsUtil.centeredText(g, Menu.getMenu(13));
                break;
            }
            case 13: {
                GraphicsUtil.clear(g);
                g.setColor(Properties.fg);
                g.setFont(FontUtil.FMB);
                GraphicsUtil.centeredText(g, Menu.getMenu(14));
            }
        }
    }

    public void paint(Graphics g) {
        this.paintMenu(g);
    }

    public void initGame() {
    }

    public void updateGame() {
    }

    public void renderGame(Graphics g) {
    }

    public void reVolume() {
    }

    public void resetGame() {
    }

    public void cleanResources() {
    }

    protected void keyPressed(int code) {
        this.keyPressed[this.pressedKey] = code;
        this.pressedKey = (short)(this.pressedKey + 1);
        if (this.pressedKey > this.keyPressed.length) {
            this.pressedKey = 0;
        }
        for (int i = 0; i < this.keyDown.length; ++i) {
            if (this.keyDown[i] != -100) continue;
            this.keyDown[i] = code;
            break;
        }
    }

    public boolean isJoystickPressed(int code) {
        for (int i = 0; i < this.pressedKey; ++i) {
            if (this.getGameAction(this.keyPressed[i]) != code) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyPressed(int code) {
        for (int i = 0; i < this.pressedKey; ++i) {
            if (this.keyPressed[i] != code) continue;
            return true;
        }
        return false;
    }

    public boolean isPressed(int key, int joystick) {
        int i;
        for (i = 0; i < this.pressedKey; ++i) {
            if (this.keyPressed[i] != key) continue;
            return true;
        }
        for (i = 0; i < this.pressedKey; ++i) {
            if (this.getGameAction(this.keyPressed[i]) != joystick) continue;
            return true;
        }
        return false;
    }

    public boolean isPressed(int key) {
        switch (key) {
            case 50: {
                return this.isPressed(key, 1);
            }
            case 52: {
                return this.isPressed(key, 2);
            }
            case 54: {
                return this.isPressed(key, 5);
            }
            case 56: {
                return this.isPressed(key, 6);
            }
            case 53: {
                return this.isPressed(key, 8);
            }
        }
        return this.isKeyPressed(key);
    }

    public boolean isJoystickDown(int code) {
        for (int i = 0; i < this.keyDown.length; ++i) {
            if (this.keyDown[i] == -100 || this.getGameAction(this.keyDown[i]) != code) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyDown(int code) {
        for (int i = 0; i < this.keyDown.length; ++i) {
            if (this.keyDown[i] == -100 || this.keyDown[i] != code) continue;
            return true;
        }
        return false;
    }

    public boolean isDown(int key, int joystick) {
        int i;
        for (i = 0; i < this.keyDown.length; ++i) {
            if (this.keyDown[i] == -100 || this.keyDown[i] != key) continue;
            return true;
        }
        for (i = 0; i < this.keyDown.length; ++i) {
            if (this.keyDown[i] == -100 || this.getGameAction(this.keyDown[i]) != joystick) continue;
            return true;
        }
        return false;
    }

    public boolean isDown(int key) {
        switch (key) {
            case 50: {
                return this.isDown(key, 1);
            }
            case 52: {
                return this.isDown(key, 2);
            }
            case 54: {
                return this.isDown(key, 5);
            }
            case 56: {
                return this.isDown(key, 6);
            }
            case 53: {
                return this.isDown(key, 8);
            }
        }
        return this.isKeyDown(key);
    }

    protected void keyReleased(int code) {
        this.keyReleased[this.releasedKey] = code;
        this.releasedKey = (short)(this.releasedKey + 1);
        if (this.releasedKey > this.keyReleased.length) {
            this.releasedKey = 0;
        }
        for (int i = 0; i < this.keyDown.length; ++i) {
            if (this.keyDown[i] != code) continue;
            this.keyDown[i] = -100;
        }
    }

    public boolean isJoystickReleased(int code) {
        for (int i = 0; i < this.releasedKey; ++i) {
            if (this.getGameAction(this.keyReleased[i]) != code) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyReleased(int code) {
        for (int i = 0; i < this.releasedKey; ++i) {
            if (this.keyReleased[i] != code) continue;
            return true;
        }
        return false;
    }

    public boolean isReleased(int key, int joystick) {
        int i;
        for (i = 0; i < this.releasedKey; ++i) {
            if (this.keyReleased[i] != key) continue;
            return true;
        }
        for (i = 0; i < this.releasedKey; ++i) {
            if (this.getGameAction(this.keyReleased[i]) != joystick) continue;
            return true;
        }
        return false;
    }

    public boolean isReleased(int key) {
        switch (key) {
            case 50: {
                return this.isReleased(key, 1);
            }
            case 52: {
                return this.isReleased(key, 2);
            }
            case 54: {
                return this.isReleased(key, 5);
            }
            case 56: {
                return this.isReleased(key, 6);
            }
            case 53: {
                return this.isReleased(key, 8);
            }
        }
        return this.isKeyReleased(key);
    }

    public void sizeChanged(int w, int h) {
        super.sizeChanged(w, h);
        Properties.width = w;
        Properties.midW = Properties.width / 2;
        Properties.height = h;
        Properties.midH = Properties.height / 2;
        Properties.isUpdate = true;
    }

    public void playSingleTone(int note, int duration, int volume) {
        try {
            Manager.playTone((int)note, (int)duration, (int)volume);
        }
        catch (MediaException me) {
            // empty catch block
        }
    }

    public void playSound(Sound sound) {
        try {
            sound.getPlayer().start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void stopSound(Sound sound) {
        try {
            sound.getPlayer().stop();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    private void playThemeMusic() {
        if (this.themeSound != null) {
            try {
                this.themeSound.start();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    private void stopThemeMusic() {
        if (this.themeSound != null) {
            try {
                this.themeSound.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    private void destroyThemeMusic() {
        if (this.themeSound != null) {
            try {
                this.themeSound.stop();
                this.themeSound.close();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public void instalThemeMusic(Sound sound) {
        this.themeSound = sound.getPlayer();
    }
}

