/*
 * Decompiled with CFR 0.152.
 */
import com.golden.gamedev.mobile.gameobjects.SimpleSprite;
import com.golden.gamedev.mobile.records.HighScores;
import javax.microedition.lcdui.Image;

public class Soldier
extends SimpleSprite {
    public int status;
    public int dir;
    public int timer;
    public int str;

    public Soldier(Image img, int w, int h) {
        super(img, w, h);
        this.reset();
        this.str = 3;
    }

    public void update() {
        super.update();
        switch (this.dir) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.nextFrame();
            }
        }
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                this.nextFrame();
                if (++this.timer % 7 != 0) break;
                this.timer = 0;
                if (OACanvas.heroHP <= 0) break;
                this.status = 0;
                this.setFrameSequence(Status.WALK_SEQ);
                break;
            }
            case 2: {
                this.nextFrame();
                this.y -= 8;
                if (this.y >= OACanvas.playfield.y - 64) break;
                this.y = OACanvas.playfield.y - 64;
                this.reset();
            }
        }
    }

    public void reset() {
        this.str = 3 + OACanvas.level;
        this.timer = 0;
        this.status = 0;
        this.dir = 4;
        this.setFrameSequence(Status.WALK_SEQ);
        this.setVisible(false);
    }

    public void setStatus(int a) {
        this.status = a;
        switch (this.status) {
            case 0: {
                break;
            }
            case 1: {
                Soldier s;
                int i;
                this.setFrameSequence(Status.HIT_SEQ);
                if (--this.str > 0) break;
                this.str = 0;
                this.timer = 0;
                for (i = 0; i < OACanvas.soldiersGroup.size(); ++i) {
                    s = (Soldier)OACanvas.soldiersGroup.getSprite(i);
                    if (!((Object)((Object)this.getSoldier())).equals((Object)s)) continue;
                    HighScores.playersScore += 10;
                }
                for (i = 0; i < OACanvas.ridersGroup.size(); ++i) {
                    s = (Soldier)OACanvas.ridersGroup.getSprite(i);
                    if (!((Object)((Object)this.getSoldier())).equals((Object)s)) continue;
                    HighScores.playersScore += 20;
                }
                for (i = 0; i < OACanvas.coptersGroup.size(); ++i) {
                    s = (Soldier)OACanvas.coptersGroup.getSprite(i);
                    if (!((Object)((Object)this.getSoldier())).equals((Object)s)) continue;
                    HighScores.playersScore += 30;
                }
                for (i = 0; i < OACanvas.bossesGroup.size(); ++i) {
                    s = (Soldier)OACanvas.bossesGroup.getSprite(i);
                    if (!((Object)((Object)this.getSoldier())).equals((Object)s)) continue;
                    HighScores.playersScore += 500;
                }
                this.setFrameSequence(Status.DIE_SEQ);
                this.status = 2;
                break;
            }
        }
    }

    public void setDir(int a) {
        this.dir = a;
        switch (this.dir) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.setFrameSequence(Status.WALK_SEQ);
                break;
            }
            case 4: {
                this.setFrameSequence(Status.STAY_SEQ);
            }
        }
    }

    public void setStr(int str) {
        this.str = str;
    }

    public int getStr() {
        return this.str;
    }

    public Soldier getSoldier() {
        return this;
    }
}

