/*
 * Decompiled with CFR 0.152.
 */
import com.golden.gamedev.mobile.gameobjects.SpriteGroup;

public class RiderGroup {
    public Soldier[] enemies = new Soldier[4];
    public Bullet[] bullets = new Bullet[4];
    public int numSoldier;
    public boolean left;
    public Bonus[] bonus = new Bonus[4];

    public RiderGroup() {
        for (int i = 0; i < this.enemies.length; ++i) {
            this.enemies[i] = new Soldier(OACanvas.riderImage, 32, 32);
            this.bullets[i] = new Bullet(this.enemies[i], OACanvas.riderBullet);
            this.bonus[i] = new Bonus(this.enemies[i]);
        }
        this.numSoldier = 4;
        this.left = false;
    }

    public void updateSoldierGroup() {
        block4: for (int i = 0; i < this.numSoldier; ++i) {
            this.bonus[i].updateBonus();
            if (this.enemies[i].status == 2 && !this.bonus[i].isVisible()) {
                this.bonus[i].setBonus(this.enemies[i], 4);
            }
            if (this.enemies[i].y > OACanvas.playfield.y + OACanvas.playfield.getHeight()) {
                this.enemies[i].setVisible(false);
                this.enemies[i].reset();
            }
            if (this.bullets[i].y > OACanvas.playfield.y + OACanvas.playfield.getHeight()) {
                this.bullets[i].reset();
            }
            if (this.bullets[i].isFire) {
                this.bullets[i].y += 2;
                if (i % 2 == 0) {
                    this.bullets[i].x += 0;
                } else if (this.left) {
                    ++this.bullets[i].x;
                } else if (!this.left) {
                    --this.bullets[i].x;
                }
            }
            switch (this.enemies[i].dir) {
                case 1: {
                    ++this.enemies[i].y;
                    if (this.enemies[i].y > OACanvas.playfield.y + OACanvas.playfield.getHeight() / 2) {
                        if (this.left) {
                            ++this.enemies[i].x;
                            continue block4;
                        }
                        if (this.left) continue block4;
                        --this.enemies[i].x;
                        continue block4;
                    }
                    if (this.enemies[i].y <= OACanvas.playfield.y + 32 || ++this.enemies[i].timer % 4 != 0) continue block4;
                    this.enemies[i].timer = 0;
                    if (this.bullets[i].isFire) continue block4;
                    this.bullets[i].setLocation(this.enemies[i].getX() + this.enemies[i].getWidth() / 2 - 3, this.enemies[i].getY() + 32);
                    this.bullets[i].isFire = true;
                    this.bullets[i].setVisible(true);
                    continue block4;
                }
                case 4: {
                    this.enemies[i].y += 0;
                }
            }
        }
    }

    public void resetEnemy() {
        this.left = !this.left;
        for (int i = 0; i < this.enemies.length; ++i) {
            if (this.left) {
                this.enemies[i].setLocation(32 + OACanvas.rand.nextInt(4) * 32, OACanvas.playfield.y - (i + 3) * 32);
            } else {
                this.enemies[i].setLocation(136 - OACanvas.rand.nextInt(4) * 32, OACanvas.playfield.y - (i + 3) * 32);
            }
            this.enemies[i].setStr((1 + OACanvas.level) * 3);
            this.enemies[i].setDir(1);
            this.enemies[i].setStatus(0);
            this.enemies[i].setVisible(true);
        }
    }

    public void addToGroup(SpriteGroup a, SpriteGroup b) {
        for (int i = 0; i < this.numSoldier; ++i) {
            a.add(this.enemies[i]);
            b.add(this.bullets[i]);
        }
    }

    public Soldier[] getEnemyGroup() {
        return this.enemies;
    }

    public Bonus[] getBonus() {
        return this.bonus;
    }

    public void addBonusToPlayfield() {
        for (int i = 0; i < this.numSoldier; ++i) {
            OACanvas.playfield.add(this.bonus[i]);
        }
    }
}

