/*
 * Decompiled with CFR 0.152.
 */
import com.golden.gamedev.mobile.gameobjects.SimpleSprite;
import com.golden.gamedev.mobile.records.HighScores;

public class Bonus
extends SimpleSprite {
    public SimpleSprite owner;
    private int dir;
    private int timer;

    public Bonus(SimpleSprite owner) {
        super(OACanvas.bonusImage, 12, 12);
        this.owner = owner;
        this.x = owner.x + owner.getWidth() / 2 - this.getWidth() / 2;
        this.y = owner.y + owner.getHeight() / 2 - this.getHeight() / 2;
        this.setPosition(this.x, this.y);
        this.setVisible(false);
        this.setFrameSequence(Status.BONUS_SEQ);
        this.dir = 0;
        this.timer = 0;
    }

    public void updateBonus() {
        if (this.isVisible()) {
            if (this.isCollided()) {
                switch (this.getFrame()) {
                    case 0: {
                        ++OACanvas.heroLife;
                        break;
                    }
                    case 1: {
                        if ((OACanvas.heroHP += 10) < 30) break;
                        OACanvas.heroHP = 30;
                        break;
                    }
                    case 2: {
                        ++OACanvas.heroBomb;
                        break;
                    }
                    case 3: {
                        if (++HeroBullet.numBullet < 5) break;
                        HeroBullet.numBullet = 5;
                        break;
                    }
                    case 4: {
                        ++OACanvas.heroStar;
                    }
                }
            }
            switch (this.dir) {
                case 0: {
                    this.y -= 2;
                    this.x += 0;
                    if (this.y >= OACanvas.playfield.y) break;
                    if (this.x + 6 < OACanvas.playfield.x + OACanvas.playfield.getWidth() / 2) {
                        this.dir = 3;
                        break;
                    }
                    this.dir = 2;
                    break;
                }
                case 1: {
                    ++this.y;
                    this.x += 0;
                    if (++this.timer % 20 != 0) break;
                    this.timer = 0;
                    if (this.x + 6 < OACanvas.playfield.x + OACanvas.playfield.getWidth() / 2) {
                        this.dir = 3;
                        break;
                    }
                    this.dir = 2;
                    break;
                }
                case 2: {
                    --this.x;
                    this.y += 0;
                    if (this.x >= OACanvas.playfield.x) break;
                    this.x = OACanvas.playfield.x;
                    this.dir = 1;
                    break;
                }
                case 3: {
                    ++this.x;
                    this.y += 0;
                    if (this.x + 12 <= OACanvas.playfield.x + OACanvas.playfield.getWidth()) break;
                    this.x = OACanvas.playfield.x + OACanvas.playfield.getWidth() - 12;
                    this.dir = 1;
                }
            }
            if (this.y > OACanvas.playfield.y + OACanvas.playfield.getHeight()) {
                this.setVisible(false);
            }
        }
    }

    public boolean isCollided() {
        if (OACanvas.hero.status != 2 && this.collidesWith(OACanvas.hero, false)) {
            HighScores.playersScore += 5;
            this.setVisible(false);
            return true;
        }
        return false;
    }

    public void setBonus(SimpleSprite owner, int b) {
        this.owner = owner;
        this.x = owner.x + owner.getWidth() / 2 - this.getWidth() / 2;
        this.y = owner.y + owner.getHeight() / 2 - this.getHeight() / 2;
        this.dir = 0;
        this.timer = 0;
        this.setPosition(this.x, this.y);
        this.setVisible(true);
        this.setFrame(b);
    }
}

