/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class Resizer {
    private static final int FP_SHIFT = 13;
    private static final int FP_ONE = 8192;
    private static final int FP_HALF = 4096;
    public static final int MODE_POINT_SAMPLE = 0;
    public static final int MODE_BOX_FILTER = 1;

    static int[] getPixels(Image src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int[] pixels = new int[w * h];
        src.getRGB(pixels, 0, w, 0, 0, w, h);
        return pixels;
    }

    static Image drawPixels(int[] pixels, int w, int h) {
        return Image.createRGBImage((int[])pixels, (int)w, (int)h, (boolean)true);
    }

    static Image rotateImage(Image src, float sinVal, float cosVal, int cx, int cy) {
        int w1 = src.getWidth();
        int h1 = src.getHeight();
        int x = w1 / 2;
        int y = h1 / 2;
        int[] srcMap = new int[w1 * h1];
        src.getRGB(srcMap, 0, w1, 0, 0, w1, h1);
        int dx = x > w1 / 2 ? x : w1 - x;
        int dy = y > h1 / 2 ? y : h1 - y;
        double dr = Math.sqrt(dx * dx + dy * dy);
        int wh2 = (int)(2.0 * dr);
        int[] destMap = new int[wh2 * wh2];
        int idx = 0;
        for (int i = 0; i < w1; ++i) {
            for (int j = 0; j < h1; ++j) {
                double destX;
                double destY;
                if (srcMap[j * w1 + i] >> 24 == 0 || (idx = (int)(destY = dr + (double)((float)(j - y) * cosVal) - (double)((float)(i - x) * sinVal)) * wh2 + (int)(destX = dr + (double)((float)(i - x) * cosVal) + (double)((float)(j - y) * sinVal))) > wh2 * wh2) continue;
                destMap[idx] = srcMap[j * w1 + i];
                destMap[wh2 * (int)destY + (int)destX + 1] = srcMap[j * w1 + i];
            }
        }
        int[] dd = new int[]{(int)((double)x - dr), (int)((double)y - dr)};
        return Image.createRGBImage((int[])destMap, (int)wh2, (int)wh2, (boolean)true);
    }

    static Image zoomImage(Image src, float factor) {
        if (src == null) {
            return null;
        }
        return Resizer.zoomImage(src, factor, 0);
    }

    static Image flipHImage(Image src) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int destW = srcW;
        int destH = srcH;
        int[] destPixels = new int[destW * destH];
        int[] srcPixels = Resizer.getPixels(src);
        for (int destY = 0; destY < destH; ++destY) {
            for (int destX = 0; destX < destW; ++destX) {
                destPixels[destX + destY * destW] = srcPixels[destW - 1 - destX + destY * srcW];
            }
        }
        return Resizer.drawPixels(destPixels, destW, destH);
    }

    static Image resizeImage(Image src, int width, int height) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int destW = width;
        int destH = height;
        int[] destPixels = new int[destW * destH];
        int[] srcPixels = Resizer.getPixels(src);
        for (int destY = 0; destY < destH; ++destY) {
            for (int destX = 0; destX < destW; ++destX) {
                int srcX = destX * srcW / destW;
                int srcY = destY * srcH / destH;
                destPixels[destX + destY * destW] = srcPixels[srcX + srcY * srcW];
            }
        }
        return Resizer.drawPixels(destPixels, destW, destH);
    }

    static Image zoomImage(Image src, float factor, int mode) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int destW = (int)((float)srcW * factor);
        int destH = (int)((float)srcH * factor);
        int[] destPixels = new int[destW * destH];
        int[] srcPixels = Resizer.getPixels(src);
        if (mode == 0) {
            for (int destY = 0; destY < destH; ++destY) {
                for (int destX = 0; destX < destW; ++destX) {
                    int srcX = destX * srcW / destW;
                    int srcY = destY * srcH / destH;
                    if (srcX + srcY * srcW > srcW * srcH - 1 || destX + destY * destW > destW * destH - 1) continue;
                    destPixels[destX + destY * destW] = srcPixels[srcX + srcY * srcW];
                }
            }
        } else {
            int argb;
            int g;
            int b;
            int r;
            int a;
            int count;
            int ratioW = (srcW << 13) / destW;
            int ratioH = (srcH << 13) / destH;
            int[] tmpPixels = new int[destW * srcH];
            for (int y = 0; y < srcH; ++y) {
                for (int destX = 0; destX < destW; ++destX) {
                    count = 0;
                    a = 0;
                    r = 0;
                    b = 0;
                    g = 0;
                    int srcX = destX * ratioW >> 13;
                    int srcX2 = (destX + 1) * ratioW >> 13;
                    do {
                        argb = srcPixels[srcX + y * srcW];
                        a += (argb & 0xFF000000) >> 24;
                        r += (argb & 0xFF0000) >> 16;
                        g += (argb & 0xFF00) >> 8;
                        b += argb & 0xFF;
                        ++count;
                    } while (++srcX <= srcX2 && srcX + y * srcW < srcPixels.length);
                    tmpPixels[destX + y * destW] = (a /= count) << 24 | (r /= count) << 16 | (g /= count) << 8 | (b /= count);
                }
            }
            for (int x = 0; x < destW; ++x) {
                for (int destY = 0; destY < destH; ++destY) {
                    count = 0;
                    a = 0;
                    r = 0;
                    b = 0;
                    g = 0;
                    int srcY = destY * ratioH >> 13;
                    int srcY2 = (destY + 1) * ratioH >> 13;
                    do {
                        argb = tmpPixels[x + srcY * destW];
                        a += (argb & 0xFF000000) >> 24;
                        r += (argb & 0xFF0000) >> 16;
                        g += (argb & 0xFF00) >> 8;
                        b += argb & 0xFF;
                        ++count;
                    } while (++srcY <= srcY2 && x + srcY * destW < tmpPixels.length);
                    a = (a /= count) > 255 ? 255 : a;
                    r = (r /= count) > 255 ? 255 : r;
                    g = (g /= count) > 255 ? 255 : g;
                    b = (b /= count) > 255 ? 255 : b;
                    destPixels[x + destY * destW] = a << 24 | r << 16 | g << 8 | b;
                }
            }
        }
        return Resizer.drawPixels(destPixels, destW, destH);
    }
}

