/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class CuttheBirdCanvas
extends Canvas
implements Runnable {
    public static final int KEY_DOWN = -2;
    public static final int KEY_LEFT = -3;
    public static final int KEY_RIGHT = -4;
    public static final int KEY_UP = -1;
    public static final int KEY_SELECT = -5;
    public static final int KEY_R = -7;
    public static final int KEY_L = -6;
    public static final int gm_splash = 1;
    public static final int gm_sound = 2;
    public static final int gm_menu = 3;
    public static final int gm_play = 4;
    public static final int gm_score = 5;
    public static final int gm_about = 6;
    public static final int gm_option = 7;
    public static final int gm_help = 8;
    public static final int gm_pause = 9;
    public static final int gm_confirm = 10;
    static final int GAME_NOPLAY = -1;
    static final int GAME_PLAYING = 0;
    static final int GAME_PAUSE = 1;
    static final int GAME_OVERINGBREAK = 2;
    static final int GAME_OVERINGBOMB = 3;
    static final int GAME_OVERBREAK = 4;
    static final int GAME_OVERBOMB = 5;
    static final int GAME_EXIT = 6;
    static final int SD_BREAK_BIRD = 0;
    static final int SD_DISP_BOMB = 1;
    static final int SD_BREAK_BOMB = 2;
    static final int SD_CUT_BIRD = 3;
    static final int SD_UPGRADE_SCORE = 4;
    static final int SD_GAME_OVER = 5;
    static final int SD_GAME_COMBO3 = 6;
    private int current_screen = 1;
    private int prev_screen;
    private int menuPressItem = 0;
    private int menu_item = 0;
    private int option_item = 0;
    private int pause_item = 0;
    private int nPlayState = -1;
    Image im_background;
    Image[] im_splash;
    Image[] im_sound;
    Image[] im_menu;
    Image[] im_option;
    Image[] im_confirm;
    Image[] im_help;
    Image[] im_about;
    Image[] im_play;
    Image[] im_pause;
    Image[] im_result;
    Image[] im_score;
    boolean bShowKeyImage = false;
    Timer logoTimer;
    private PressKeyWatch m_runWatchTask;
    Sound snd = new Sound(50);
    private int m_nSuccessNumber;
    private boolean m_bConfSelYes = false;
    private boolean m_bKnifeMove = false;
    private boolean m_bEnableSoundAll = true;
    boolean m_bEnableMusic = true;
    boolean m_bEnableSound = true;
    private int m_iBreaking = 20;
    GameEngine gameEngine;
    private Vector cutLines;
    private Vector cutBirds;
    private Vector birdObject;
    private Vector comboLabels;
    private Vector breakBrids;
    private int nRunCount;
    private int iRunCount = this.nRunCount = 100;
    private float nFireSize = 1.0f;
    Thread runThread;
    boolean bRunThread = false;
    boolean bPlay = false;
    int iCount = 0;

    public CuttheBirdCanvas() {
        try {
            this.jbInit();
            this.loadImageResource();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setFullScreenMode(true);
        this.bPlay = true;
        try {
            this.im_background = Image.createImage((String)"/Res/pic/background.png");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        this.logoTimer = new Timer();
        this.m_runWatchTask = new PressKeyWatch();
        this.logoTimer.scheduleAtFixedRate((TimerTask)this.m_runWatchTask, 0L, 500L);
        this.repaint();
    }

    void moveCursor() {
        if (this.gameEngine.m_bCursorToTop) {
            this.gameEngine.m_nCursorYPos -= 13;
        }
        if (this.gameEngine.m_bCursorToBottom) {
            this.gameEngine.m_nCursorYPos += 13;
        }
        if (this.gameEngine.m_bCursorToLeft) {
            this.gameEngine.m_nCursorXPos -= 13;
        }
        if (this.gameEngine.m_bCursorToRight) {
            this.gameEngine.m_nCursorXPos += 13;
        }
        if (this.gameEngine.m_nCursorXPos < 7) {
            this.gameEngine.m_nCursorXPos = 7;
        }
        if (this.gameEngine.m_nCursorXPos > 233) {
            this.gameEngine.m_nCursorXPos = 233;
        }
        if (this.gameEngine.m_nCursorYPos < 7) {
            this.gameEngine.m_nCursorYPos = 7;
        }
        if (this.gameEngine.m_nCursorYPos > 313) {
            this.gameEngine.m_nCursorYPos = 313;
        }
    }

    void newBird() {
        System.gc();
        Bird object = new Bird();
        if (object.m_bBomb) {
            boolean bExistBomb = false;
            for (int j = 0; j < this.birdObject.size(); ++j) {
                Bird obj = (Bird)this.birdObject.elementAt(j);
                if (!obj.m_bBomb || obj.m_bBreak) continue;
                bExistBomb = true;
                break;
            }
            if (!bExistBomb) {
                this.playSound(1, 1);
            }
        }
        this.birdObject.addElement(object);
    }

    void pauseGame() {
        this.stopSound();
        this.nPlayState = 1;
        this.pause_item = 0;
        this.repaint();
    }

    void retryGame() {
        this.gameEngine.m_nCursorXPos = 120;
        this.gameEngine.m_nCursorYPos = 160;
        this.stopSound();
        this.breakBrids.removeAllElements();
        this.comboLabels.removeAllElements();
        this.cutLines.removeAllElements();
        this.birdObject.removeAllElements();
        this.gameEngine.m_bCursorToRight = false;
        this.gameEngine.m_bCursorToLeft = false;
        this.gameEngine.m_bCursorToBottom = false;
        this.gameEngine.m_bCursorToTop = false;
        this.m_nSuccessNumber = 0;
        this.m_iBreaking = 20;
        this.nPlayState = 0;
        this.nRunCount = 100;
        this.nFireSize = 1.0f;
        Random rand = new Random();
        this.iRunCount = Math.abs(rand.nextInt()) % this.nRunCount;
        rand = null;
    }

    public void run() {
        this.iCount = 0;
        Random rand = new Random();
        this.iRunCount = Math.abs(rand.nextInt()) % this.nRunCount;
        while (this.bPlay && this.bRunThread) {
            block33: {
                block31: {
                    block32: {
                        try {
                            if (this.current_screen != 4 || this.nPlayState == 1 || this.nPlayState == 6 || this.nPlayState == 5 || this.nPlayState == 4) {
                                Thread.sleep(1000L);
                            } else {
                                Thread.sleep(50L);
                            }
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                        System.gc();
                        if (this.current_screen != 4) continue;
                        if (this.nPlayState != 3 && this.nPlayState != 2) break block31;
                        if (this.nPlayState != 3) break block32;
                        if (this.nFireSize == 1.0f) {
                            this.playSound(2, 0);
                        }
                        this.nFireSize += 0.5f;
                        if (this.nFireSize > 8.0f) {
                            this.nPlayState = 5;
                            if (this.m_nSuccessNumber > CuttheBird.instance.nOptionData[3]) {
                                CuttheBird.instance.nOptionData[3] = this.m_nSuccessNumber;
                            }
                            this.playSound(5, 0);
                        }
                        break block33;
                    }
                    --this.m_iBreaking;
                    if (this.m_iBreaking >= 0) break block33;
                    this.m_iBreaking = 0;
                    this.nPlayState = 4;
                    if (this.m_nSuccessNumber > CuttheBird.instance.nOptionData[3]) {
                        CuttheBird.instance.nOptionData[3] = this.m_nSuccessNumber;
                    }
                    this.playSound(5, 0);
                    break block33;
                }
                if (this.nPlayState == 0) {
                    int i;
                    ++this.iCount;
                    if (this.iCount > Integer.MAX_VALUE) {
                        this.iCount = Integer.MIN_VALUE;
                    }
                    this.moveCursor();
                    --this.iRunCount;
                    if (this.iRunCount < 0) {
                        this.iRunCount = Math.abs(rand.nextInt()) % this.nRunCount;
                        this.nRunCount = this.nRunCount < 15 ? 15 : (this.nRunCount < 40 ? --this.nRunCount : (this.nRunCount < 60 ? (this.nRunCount -= 2) : (this.nRunCount -= 3)));
                        this.newBird();
                    }
                    for (i = 0; i < this.cutLines.size(); ++i) {
                        KnifeLine lineObj = (KnifeLine)this.cutLines.elementAt(i);
                        --lineObj.m_nLifeDelay;
                        if (lineObj.m_nLifeDelay >= 0) continue;
                        this.cutLines.removeElementAt(i);
                        --i;
                    }
                    for (i = 0; i < this.birdObject.size(); ++i) {
                        Bird object = (Bird)this.birdObject.elementAt(i);
                        if (object == null) continue;
                        object.Move();
                        if (!object.m_bCut && this.gameEngine.m_nCursorXPos >= object.m_nXPos && (float)this.gameEngine.m_nCursorXPos <= (float)object.m_nXPos + (float)object.m_birdImage.getWidth() * object.m_fZoom && this.gameEngine.m_nCursorYPos >= object.m_nYPos && (float)this.gameEngine.m_nCursorYPos <= (float)object.m_nYPos + (float)object.m_birdImage.getHeight() * object.m_fZoom) {
                            object.m_bCut = true;
                            if (object.m_bBomb) {
                                this.nPlayState = 3;
                                this.stopSound();
                                this.cutLines.removeAllElements();
                                this.comboLabels.removeAllElements();
                                this.birdObject.removeAllElements();
                                CuttheBird.instance.nOptionData[4] = this.m_nSuccessNumber;
                                break;
                            }
                            this.playSound(3, 0);
                            ++this.m_nSuccessNumber;
                            CutBird obj = new CutBird(this.iCount, this.gameEngine.m_nCursorXPos, this.gameEngine.m_nCursorYPos);
                            this.cutBirds.addElement(obj);
                            if (this.m_nSuccessNumber - CuttheBird.instance.nOptionData[3] == 1) {
                                this.playSound(4, 0);
                            }
                        }
                        if (object.m_bBreak) {
                            this.breakBrids.addElement(object);
                            this.playSound(0, 0);
                            if (this.breakBrids.size() >= 5) {
                                this.stopSound();
                                this.repaint();
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Exception e) {
                                    System.out.println(e.getMessage());
                                }
                                this.nPlayState = 2;
                                this.cutLines.removeAllElements();
                                this.comboLabels.removeAllElements();
                                CuttheBird.instance.nOptionData[4] = this.m_nSuccessNumber;
                                break;
                            }
                            this.birdObject.removeElement(object);
                            --i;
                            continue;
                        }
                        if (!((float)object.m_nXPos + (float)object.m_birdImage.getWidth() * object.m_fZoom < 0.0f) && object.m_nXPos <= 240 && object.m_nYPos <= 320 && !object.m_bBreak && object.m_nCutImageDelay >= 0) continue;
                        if (object.m_bBomb) {
                            boolean bExistBomb = false;
                            for (int j = 0; j < this.birdObject.size(); ++j) {
                                Bird obj = (Bird)this.birdObject.elementAt(j);
                                if (obj == object || !obj.m_bBomb || obj.m_bBreak) continue;
                                bExistBomb = true;
                                break;
                            }
                            if (!bExistBomb) {
                                this.stopSound();
                            }
                        }
                        this.birdObject.removeElement(object);
                        --i;
                    }
                    boolean bCombo = false;
                    if (this.cutBirds.size() > 0) {
                        CutBird first = (CutBird)this.cutBirds.firstElement();
                        int start = first.m_nCutTime;
                        if (Math.abs(this.iCount - start) < 13) {
                            bCombo = true;
                        }
                    }
                    if (!bCombo) {
                        int size = this.cutBirds.size();
                        if (size >= 3) {
                            CutBird last = (CutBird)this.cutBirds.lastElement();
                            ComboLabel comboObj = new ComboLabel(last.m_cutXPos, last.m_cutYPos, size);
                            this.comboLabels.addElement(comboObj);
                            this.m_nSuccessNumber += size;
                            this.playSound(6, 0);
                        }
                        this.cutBirds.removeAllElements();
                    }
                    for (int i2 = 0; i2 < this.comboLabels.size(); ++i2) {
                        ComboLabel comboObj = (ComboLabel)this.comboLabels.elementAt(i2);
                        comboObj.decreaseTime();
                        if (comboObj.m_nDisTime != 0) continue;
                        this.comboLabels.removeElement(comboObj);
                        --i2;
                    }
                }
            }
            this.repaint();
        }
        rand = null;
        try {
            Thread.sleep(1000L);
            CuttheBirdCanvas cuttheBirdCanvas = this;
            cuttheBirdCanvas.runThread.yield();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadImageResource() {
        this.freeImageMem();
        try {
            switch (this.current_screen) {
                case 1: {
                    this.im_splash = new Image[4];
                    this.im_splash[0] = Image.createImage((String)"/Res/pic/Farm.png");
                    this.im_splash[1] = Image.createImage((String)"/Res/pic/logo.png");
                    this.im_splash[2] = Image.createImage((String)"/Res/pic/anykey.png");
                    this.im_splash[3] = Image.createImage((String)"/Res/pic/copyright.png");
                    break;
                }
                case 2: {
                    this.im_sound = new Image[4];
                    this.im_sound[0] = Image.createImage((String)"/Res/pic/confirmBack.png");
                    this.im_sound[1] = Image.createImage((String)"/Res/pic/confirmLabel.png");
                    this.im_sound[2] = Image.createImage((String)"/Res/pic/buttons.png");
                    this.im_sound[3] = Image.createImage((String)"/Res/pic/mark.png");
                    break;
                }
                case 3: {
                    this.im_menu = new Image[5];
                    this.im_menu[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_menu[1] = Image.createImage((String)"/Res/pic/menu_items.png");
                    this.im_menu[2] = Image.createImage((String)"/Res/pic/mark.png");
                    this.im_menu[3] = Image.createImage((String)"/Res/pic/close.png");
                    this.im_menu[4] = Image.createImage((String)"/Res/pic/help.png");
                    break;
                }
                case 8: {
                    this.im_help = new Image[4];
                    this.im_help[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_help[1] = Image.createImage((String)"/Res/pic/help_item.png");
                    this.im_help[2] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_help[3] = Image.createImage((String)"/Res/pic/helpContents.png");
                    break;
                }
                case 7: {
                    this.im_option = new Image[6];
                    this.im_option[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_option[1] = Image.createImage((String)"/Res/pic/option_items.png");
                    this.im_option[2] = Image.createImage((String)"/Res/pic/option.png");
                    this.im_option[3] = Image.createImage((String)"/Res/pic/onoff.png");
                    this.im_option[4] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_option[5] = Image.createImage((String)"/Res/pic/mark.png");
                    break;
                }
                case 6: {
                    this.im_about = new Image[5];
                    this.im_about[0] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_about[1] = Image.createImage((String)"/Res/pic/about_item.png");
                    this.im_about[2] = Image.createImage((String)"/Res/pic/text bg.png");
                    this.im_about[3] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_about[4] = Image.createImage((String)"/Res/pic/about_text.png");
                    break;
                }
                case 5: {
                    this.im_score = new Image[5];
                    this.im_score[0] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_score[1] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_score[2] = Image.createImage((String)"/Res/pic/score.png");
                    this.im_score[3] = Image.createImage((String)"/Res/pic/scoreLabel.png");
                    this.im_score[4] = Image.createImage((String)"/Res/pic/number.png");
                    break;
                }
                case 4: {
                    this.im_play = new Image[16];
                    this.im_play[0] = Image.createImage((String)"/Res/pic/cursor.png");
                    this.im_play[1] = Image.createImage((String)"/Res/pic/pause.png");
                    this.im_play[2] = Image.createImage((String)"/Res/pic/scoreLabel.png");
                    this.im_play[3] = Image.createImage((String)"/Res/pic/number.png");
                    this.im_play[4] = Image.createImage((String)"/Res/pic/succ.png");
                    this.im_play[5] = Image.createImage((String)"/Res/pic/miss.png");
                    this.im_play[6] = Image.createImage((String)"/Res/pic/option_Back.png");
                    this.im_play[7] = Image.createImage((String)"/Res/pic/pause_items.png");
                    this.im_play[8] = Image.createImage((String)"/Res/pic/gameover.png");
                    this.im_play[9] = Image.createImage((String)"/Res/pic/retry.png");
                    this.im_play[10] = Image.createImage((String)"/Res/pic/mark.png");
                    this.im_play[11] = Image.createImage((String)"/Res/pic/confirmBack.png");
                    this.im_play[12] = Image.createImage((String)"/Res/pic/buttons.png");
                    this.im_play[13] = Image.createImage((String)"/Res/pic/Gameover_back.png");
                    this.im_play[14] = Image.createImage((String)"/Res/pic/confirmLabel.png");
                    this.im_play[15] = Image.createImage((String)"/Res/pic/fire.png");
                }
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private void drawScore(Graphics g) {
        g.setColor(0xFFFFFF);
        g.drawString("Score: ", 120, 5, 24);
        g.drawString("Best  : ", 120, 25, 24);
        String strScore = Integer.toString(this.m_nSuccessNumber);
        g.drawString(strScore, 120, 5, 20);
        if (CuttheBird.instance.nOptionData != null) {
            strScore = Integer.toString(CuttheBird.instance.nOptionData[3]);
            g.drawString(strScore, 120, 25, 20);
        }
    }

    protected void drawPlayScreen(Graphics g) {
        Image scaleImage;
        int i;
        int iGameOverDelta = 0;
        if (this.nPlayState != 2 && this.nPlayState != 3 && this.nPlayState != 4 && this.nPlayState != 5) {
            Bird obj;
            for (i = 0; i < this.birdObject.size(); ++i) {
                obj = (Bird)this.birdObject.elementAt(i);
                if (obj.m_bBreak) continue;
                try {
                    if (obj.m_bBomb && !obj.m_bCut) {
                        scaleImage = Resizer.zoomImage(obj.m_birdImage, obj.m_fZoom);
                        scaleImage = Resizer.rotateImage(scaleImage, obj.m_fSinVal, obj.m_fCosVal, obj.m_birdImage.getWidth() / 2, obj.m_birdImage.getHeight() / 2);
                        g.drawImage(scaleImage, obj.m_nXPos, obj.m_nYPos, 20);
                    } else if (!obj.m_bCut) {
                        scaleImage = Resizer.zoomImage(obj.m_birdImage, obj.m_fZoom);
                        g.drawImage(scaleImage, obj.m_nXPos, obj.m_nYPos, 20);
                    } else {
                        scaleImage = Resizer.zoomImage(obj.m_cutImage, obj.m_fZoom);
                        g.drawImage(scaleImage, obj.m_nXPos, obj.m_nYPos, 20);
                    }
                    scaleImage = null;
                    continue;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            for (i = 0; i < this.breakBrids.size(); ++i) {
                obj = (Bird)this.breakBrids.elementAt(i);
                g.drawImage(obj.m_breakImage, obj.m_nXPos, obj.m_nYPos, 20);
            }
        }
        if (this.nPlayState == 1) {
            g.drawImage(this.im_play[6], 35, 79, 20);
            g.drawImage(this.im_play[6], 35, 131, 20);
            g.drawImage(this.im_play[6], 35, 183, 20);
            g.drawRegion(this.im_play[7], 0, 0, 101, 23, 0, 73, 92, 20);
            g.drawRegion(this.im_play[7], 0, 23, 101, 23, 0, 73, 143, 20);
            g.drawRegion(this.im_play[7], 0, 46, 101, 23, 0, 73, 195, 20);
            g.drawImage(this.im_play[10], 50, 88 + this.pause_item * 52, 20);
            this.drawScore(g);
        } else if (this.nPlayState == 2 || this.nPlayState == 3) {
            if (this.nPlayState == 3) {
                scaleImage = Resizer.zoomImage(this.im_play[15], this.nFireSize);
                g.drawImage(scaleImage, 240 - scaleImage.getWidth() >> 1, 320 - scaleImage.getHeight() >> 1, 20);
            } else {
                iGameOverDelta = this.m_iBreaking % 2 == 0 ? (iGameOverDelta -= 10) : (iGameOverDelta += 10);
                g.drawImage(this.im_play[13], -10 - iGameOverDelta, 0, 20);
            }
            scaleImage = null;
        } else if (this.nPlayState == 4 || this.nPlayState == 5) {
            g.drawImage(this.im_play[13], 0, 0, 20);
            g.drawImage(this.im_play[9], 0, 290, 20);
            g.drawImage(this.im_play[8], 0, 70, 20);
            g.drawRegion(this.im_play[2], 0, 0, 84, 27, 0, 40, 166, 20);
            int number = this.m_nSuccessNumber / 100;
            g.drawRegion(this.im_play[3], 18 * number, 0, 18, 27, 0, 140, 165, 20);
            number = this.m_nSuccessNumber % 100;
            g.drawRegion(this.im_play[3], 18 * (number / 10), 0, 18, 27, 0, 160, 165, 20);
            g.drawRegion(this.im_play[3], 18 * (number %= 10), 0, 18, 27, 0, 180, 165, 20);
        } else if (this.nPlayState == 6) {
            g.drawImage(this.im_play[11], 23, 96, 20);
            g.drawRegion(this.im_play[14], 0, 26, 174, 26, 0, 36, 127, 20);
            g.drawRegion(this.im_play[12], 0, 0, 43, 21, 0, 63, 172, 20);
            g.drawRegion(this.im_play[12], 0, 21, 43, 21, 0, 148, 172, 20);
            if (this.m_bConfSelYes) {
                g.drawImage(this.im_play[10], 37, 172, 20);
            } else {
                g.drawImage(this.im_play[10], 130, 172, 20);
            }
        } else if (this.nPlayState == 0) {
            g.setColor(0xFFFFFF);
            for (i = 0; i < this.cutLines.size(); ++i) {
                KnifeLine lineObj = (KnifeLine)this.cutLines.elementAt(i);
                g.drawLine(lineObj.m_nXStartPos, lineObj.m_nYStartPos, lineObj.m_nXEndPos, lineObj.m_nYEndPos);
                g.drawLine(lineObj.m_nXStartPos + 1, lineObj.m_nYStartPos, lineObj.m_nXEndPos, lineObj.m_nYEndPos);
                g.drawLine(lineObj.m_nXStartPos, lineObj.m_nYStartPos, lineObj.m_nXEndPos, lineObj.m_nYEndPos + 1);
            }
            this.drawScore(g);
            g.drawImage(this.im_play[1], 0, 290, 20);
            for (i = 0; i < 5; ++i) {
                if (i < 5 - this.breakBrids.size()) {
                    g.drawImage(this.im_play[4], 216 - 24 * i, 296, 20);
                    continue;
                }
                g.drawImage(this.im_play[5], 216 - 24 * i, 296, 20);
            }
            g.setFont(Font.getFont((int)64, (int)1, (int)16));
            for (int i2 = 0; i2 < this.comboLabels.size(); ++i2) {
                ComboLabel obj = (ComboLabel)this.comboLabels.elementAt(i2);
                String strCombo = "Combo+";
                strCombo = strCombo + Integer.toString(obj.m_nComboSize);
                g.drawString(strCombo, obj.m_nXPos, obj.m_nYPos, 20);
            }
            g.drawImage(this.im_play[0], this.gameEngine.m_nCursorXPos - 7, this.gameEngine.m_nCursorYPos - 7, 20);
        }
    }

    protected void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.clipRect(0, 0, 240, 320);
        g.drawImage(this.im_background, 0, 0, 20);
        if (!this.bPlay) {
            return;
        }
        switch (this.current_screen) {
            case 4: {
                this.drawPlayScreen(g);
                break;
            }
            case 1: {
                g.drawImage(this.im_splash[0], 0, 237, 20);
                g.drawImage(this.im_splash[1], 25, 56, 20);
                if (this.bShowKeyImage) {
                    g.drawImage(this.im_splash[2], 65, 255, 20);
                }
                g.drawImage(this.im_splash[3], 50, 285, 20);
                break;
            }
            case 2: {
                g.drawImage(this.im_sound[0], 23, 96, 20);
                g.drawRegion(this.im_sound[1], 0, 0, 174, 26, 0, 36, 127, 20);
                g.drawRegion(this.im_sound[2], 0, 0, 43, 21, 0, 63, 172, 20);
                g.drawRegion(this.im_sound[2], 0, 21, 43, 21, 0, 148, 172, 20);
                if (this.m_bEnableSoundAll) {
                    g.drawImage(this.im_sound[3], 37, 172, 20);
                    break;
                }
                g.drawImage(this.im_sound[3], 130, 172, 20);
                break;
            }
            case 3: {
                g.drawImage(this.im_menu[0], 36, 66, 0x10 | 4);
                g.drawImage(this.im_menu[0], 36, 108, 0x10 | 4);
                g.drawImage(this.im_menu[0], 36, 150, 0x10 | 4);
                g.drawImage(this.im_menu[0], 36, 192, 0x10 | 4);
                g.drawRegion(this.im_menu[1], 0, 0, 106, 22, 0, 73, 79, 20);
                g.drawRegion(this.im_menu[1], 0, 22, 106, 22, 0, 73, 121, 20);
                g.drawRegion(this.im_menu[1], 0, 44, 106, 22, 0, 73, 163, 20);
                g.drawRegion(this.im_menu[1], 0, 66, 106, 22, 0, 73, 205, 20);
                g.drawImage(this.im_menu[2], 50, 78 + this.menu_item * 42, 0x10 | 4);
                g.drawImage(this.im_menu[3], 0, 290, 0x10 | 4);
                g.drawImage(this.im_menu[4], 203, 290, 0x10 | 4);
                break;
            }
            case 8: {
                g.drawImage(this.im_help[0], 40, 10, 20);
                g.drawImage(this.im_help[1], 58, 16, 20);
                g.drawImage(this.im_help[2], 0, 290, 20);
                g.drawImage(this.im_help[3], 50, 55, 20);
                break;
            }
            case 7: {
                g.drawImage(this.im_option[0], 40, 10, 20);
                g.drawImage(this.im_option[2], 73, 22, 20);
                g.drawImage(this.im_option[4], 0, 290, 20);
                g.drawRegion(this.im_option[1], 0, 25, 139, 25, 0, 25, 123, 20);
                g.drawRegion(this.im_option[1], 0, 50, 139, 25, 0, 25, 190, 20);
                g.drawImage(this.im_option[5], 2, 123 + this.option_item * 67, 0x10 | 4);
                int[] y = new int[]{126, 193};
                block14: for (int i = 0; i < 2; ++i) {
                    switch (i) {
                        case 0: {
                            if (CuttheBird.instance.nOptionData[1] == 0) {
                                g.drawRegion(this.im_option[3], 0, 0, 64, 22, 0, 175, y[i], 20);
                                continue block14;
                            }
                            g.drawRegion(this.im_option[3], 0, 22, 64, 22, 0, 175, y[i], 20);
                            continue block14;
                        }
                        case 1: {
                            if (this.m_bEnableSound) {
                                g.drawRegion(this.im_option[3], 0, 0, 64, 22, 0, 175, y[i], 20);
                                continue block14;
                            }
                            g.drawRegion(this.im_option[3], 0, 22, 64, 22, 0, 175, y[i], 20);
                        }
                    }
                }
                y = null;
                break;
            }
            case 6: {
                g.drawImage(this.im_about[0], 40, 10, 20);
                g.drawImage(this.im_about[2], 25, 49, 20);
                g.drawImage(this.im_about[1], 85, 22, 20);
                g.drawImage(this.im_about[3], 0, 290, 20);
                g.drawImage(this.im_about[4], 60, 180, 20);
                break;
            }
            case 5: {
                g.drawImage(this.im_score[1], 40, 10, 20);
                g.drawImage(this.im_score[0], 0, 290, 20);
                g.drawImage(this.im_score[2], 85, 22, 20);
                g.drawRegion(this.im_score[3], 0, 0, 84, 27, 0, 80, 90, 20);
                g.drawRegion(this.im_score[3], 0, 27, 84, 27, 0, 80, 170, 20);
                int number = CuttheBird.instance.nOptionData[4] / 100;
                int nDelta = 0;
                if (number == 0) {
                    nDelta = 10;
                }
                if (number != 0) {
                    g.drawRegion(this.im_score[4], 18 * number, 0, 18, 27, 0, 95 - nDelta, 130, 20);
                }
                number = CuttheBird.instance.nOptionData[4] % 100;
                g.drawRegion(this.im_score[4], 18 * (number / 10), 0, 18, 27, 0, 115 - nDelta, 130, 20);
                g.drawRegion(this.im_score[4], 18 * (number %= 10), 0, 18, 27, 0, 135 - nDelta, 130, 20);
                number = CuttheBird.instance.nOptionData[3] / 100;
                nDelta = 0;
                if (number == 0) {
                    nDelta = 10;
                }
                if (number != 0) {
                    g.drawRegion(this.im_score[4], 18 * number, 0, 18, 27, 0, 95 - nDelta, 210, 20);
                }
                number = CuttheBird.instance.nOptionData[3] % 100;
                g.drawRegion(this.im_score[4], 18 * (number / 10), 0, 18, 27, 0, 115 - nDelta, 210, 20);
                g.drawRegion(this.im_score[4], 18 * (number %= 10), 0, 18, 27, 0, 135 - nDelta, 210, 20);
            }
        }
    }

    void Goto(int screen) {
        this.prev_screen = this.current_screen;
        this.current_screen = screen;
        if (this.prev_screen == 1) {
            this.logoTimer.cancel();
            this.logoTimer = null;
        }
        this.freeImageMem();
        this.loadImageResource();
        if (this.current_screen == 4 && this.nPlayState == -1) {
            this.nPlayState = 0;
            this.gameEngine = new GameEngine();
            this.comboLabels = new Vector();
            this.cutLines = new Vector();
            this.cutBirds = new Vector();
            this.birdObject = new Vector();
            this.breakBrids = new Vector();
            this.bRunThread = true;
            this.m_nSuccessNumber = 0;
            if (this.runThread == null) {
                this.runThread = new Thread(this);
                this.runThread.setPriority(5);
                this.runThread.start();
            }
        }
        this.repaint();
    }

    protected synchronized void keyReleased(int keyCode) {
        if (this.nPlayState == 0) {
            switch (keyCode) {
                case -1: {
                    this.gameEngine.m_bCursorToTop = false;
                    break;
                }
                case -2: {
                    this.gameEngine.m_bCursorToBottom = false;
                    break;
                }
                case -3: {
                    this.gameEngine.m_bCursorToLeft = false;
                    break;
                }
                case -4: {
                    this.gameEngine.m_bCursorToRight = false;
                    break;
                }
            }
        }
    }

    protected synchronized void keyPressed(int keyCode) {
        block61: {
            block0 : switch (this.current_screen) {
                case 4: {
                    if (this.nPlayState == 0) {
                        switch (keyCode) {
                            case -1: {
                                this.gameEngine.m_bCursorToTop = true;
                                break;
                            }
                            case -2: {
                                this.gameEngine.m_bCursorToBottom = true;
                                break;
                            }
                            case -3: {
                                this.gameEngine.m_bCursorToLeft = true;
                                break;
                            }
                            case -4: {
                                this.gameEngine.m_bCursorToRight = true;
                                break;
                            }
                            case -5: {
                                break;
                            }
                            case -6: {
                                this.pauseGame();
                            }
                        }
                        break;
                    }
                    if (this.nPlayState == 1) {
                        switch (keyCode) {
                            case -1: 
                            case 50: {
                                --this.pause_item;
                                if (this.pause_item >= 0) break;
                                this.pause_item = 2;
                                break;
                            }
                            case -2: 
                            case 56: {
                                ++this.pause_item;
                                if (this.pause_item <= 2) break;
                                this.pause_item = 0;
                                break;
                            }
                            case -5: {
                                if (this.pause_item == 0) {
                                    boolean bExistBomb = false;
                                    for (int j = 0; j < this.birdObject.size(); ++j) {
                                        Bird obj = (Bird)this.birdObject.elementAt(j);
                                        if (!obj.m_bBomb || obj.m_bBreak) continue;
                                        bExistBomb = true;
                                        break;
                                    }
                                    if (bExistBomb) {
                                        this.playSound(1, 1);
                                    }
                                    this.nPlayState = 0;
                                    break;
                                }
                                if (this.pause_item == 1) {
                                    this.Goto(7);
                                    break;
                                }
                                if (this.pause_item != 2) break;
                                this.nPlayState = 6;
                                this.m_bConfSelYes = false;
                            }
                        }
                        break;
                    }
                    if (this.nPlayState == 6) {
                        if (keyCode == -3 || keyCode == -4) {
                            this.m_bConfSelYes = !this.m_bConfSelYes;
                            break;
                        }
                        if (keyCode != -5) break;
                        if (this.m_bConfSelYes) {
                            this.nPlayState = -1;
                            this.stopSound();
                            this.Goto(3);
                            this.bRunThread = false;
                            this.runThread = null;
                            this.gameEngine = null;
                            this.comboLabels.removeAllElements();
                            this.cutLines.removeAllElements();
                            this.cutBirds.removeAllElements();
                            this.breakBrids.removeAllElements();
                            this.birdObject.removeAllElements();
                            System.gc();
                            break;
                        }
                        this.nPlayState = 1;
                        break;
                    }
                    if (this.nPlayState != 4 && this.nPlayState != 5 || keyCode != -6) break;
                    this.retryGame();
                    break;
                }
                case 1: {
                    this.Goto(2);
                    break;
                }
                case 2: {
                    switch (keyCode) {
                        case -4: 
                        case -3: {
                            this.m_bEnableSoundAll = !this.m_bEnableSoundAll;
                            break;
                        }
                        case -5: {
                            if (this.m_bEnableSoundAll) {
                                this.m_bEnableSound = true;
                                this.m_bEnableMusic = true;
                            } else {
                                this.m_bEnableSound = false;
                                this.m_bEnableMusic = false;
                            }
                            this.Goto(3);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (keyCode) {
                        case -1: 
                        case 50: {
                            --this.menu_item;
                            if (this.menu_item >= 0) break;
                            this.menu_item = 3;
                            break;
                        }
                        case -2: 
                        case 56: {
                            ++this.menu_item;
                            if (this.menu_item <= 3) break;
                            this.menu_item = 0;
                            break;
                        }
                        case -5: {
                            switch (this.menu_item) {
                                case 0: {
                                    this.Goto(4);
                                    break;
                                }
                                case 1: {
                                    this.Goto(7);
                                    break;
                                }
                                case 2: {
                                    this.Goto(5);
                                    break;
                                }
                                case 3: {
                                    this.Goto(6);
                                }
                            }
                            break;
                        }
                        case -7: {
                            this.Goto(8);
                            break;
                        }
                        case -6: {
                            CuttheBird.quitApp();
                            return;
                        }
                    }
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    if (keyCode != -6) break;
                    this.Goto(this.prev_screen);
                    break;
                }
                case 7: {
                    switch (keyCode) {
                        case -1: 
                        case 50: {
                            --this.option_item;
                            if (this.option_item < 0) {
                                this.option_item = 1;
                                break block0;
                            }
                            break block61;
                        }
                        case -2: 
                        case 56: {
                            ++this.option_item;
                            if (this.option_item > 1) {
                                this.option_item = 0;
                                break block0;
                            }
                            break block61;
                        }
                        case -4: 
                        case -3: 
                        case 52: 
                        case 54: {
                            switch (this.option_item) {
                                case 0: {
                                    CuttheBird.instance.nOptionData[1] = ~CuttheBird.instance.nOptionData[1];
                                    break block0;
                                }
                                case 1: {
                                    this.m_bEnableSound = !this.m_bEnableSound;
                                }
                            }
                            break block0;
                        }
                        case -6: {
                            this.Goto(this.prev_screen);
                        }
                    }
                }
            }
        }
        System.gc();
        this.repaint();
    }

    public void freeImageMem() {
        this.im_splash = null;
        this.im_menu = null;
        this.im_option = null;
        this.im_help = null;
        this.im_confirm = null;
        this.im_pause = null;
        this.im_play = null;
        this.im_result = null;
        this.im_score = null;
        this.im_about = null;
        System.gc();
    }

    public void freeSoundMem() {
        try {
            CuttheBird.instance.nOptionData[0] = this.m_bEnableMusic ? 0 : -1;
            CuttheBird.instance.nOptionData[2] = this.m_bEnableSound ? 0 : -1;
            this.snd.stopSound();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playSound(int soundId, int loop) {
        this.vibration(150);
        if (this.m_bEnableSound) {
            this.snd.startSound(soundId, loop);
        }
    }

    void stopSound() {
        this.snd.stopSound();
    }

    public void Tick() {
        this.bShowKeyImage = !this.bShowKeyImage;
        this.repaint();
        System.gc();
    }

    public void vibration(int nMiliSeconds) {
        if (CuttheBird.instance.nOptionData[1] != 0) {
            return;
        }
        Display d = Display.getDisplay((MIDlet)CuttheBird.instance);
        d.vibrate(nMiliSeconds);
    }

    class PressKeyWatch
    extends TimerTask {
        PressKeyWatch() {
        }

        public void run() {
            CuttheBirdCanvas.this.Tick();
        }
    }
}

