/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Entity;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.MasterAI;
import com.ea.game.ScriptConstants;
import com.ea.game.ScriptInstructions;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.UtilEntity;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Script
implements Constants,
ScriptConstants,
UnitsConstants,
SpriteConstants,
GraphicsConstants,
BuildingConstants {
    static short[][] _scripts;
    static short[][] _scriptInstances;
    static int _nrScripts;
    static short[] _memory;
    static int _first_script_file;
    static int _last_script_file;
    static String _debug_depth;

    public static void Scripts_Init(int n) {
        if (n == -1) {
            _first_script_file = 0;
            _last_script_file = -1;
            return;
        }
        _first_script_file = Level.GetLevelStats(n, 11);
        _last_script_file = Level.GetLevelStats(n, 12);
        _scriptInstances = new short[32][9];
        _nrScripts = 0;
        _scripts = new short[32][];
        for (int i = 0; i < 32; ++i) {
            short[] sArray = _scriptInstances[i];
            sArray[2] = 0;
            sArray[0] = -1;
        }
        _memory = new short[256];
    }

    public static void Scripts_Release() {
        int n;
        Script.Scripts_Clean();
        if (_scripts != null) {
            for (n = 0; n < 32; ++n) {
                Script._scripts[n] = null;
            }
        }
        _nrScripts = 0;
        if (_scriptInstances != null) {
            for (n = 0; n < 32; ++n) {
                Script._scriptInstances[n] = null;
            }
            _scriptInstances = null;
        }
        _scripts = null;
        _memory = null;
        System.gc();
    }

    public static void Scripts_Clean() {
        if (_scriptInstances != null) {
            for (int i = 0; i < 32; ++i) {
                short[] sArray = _scriptInstances[i];
                if (sArray == null) continue;
                sArray[2] = 0;
                sArray[0] = -1;
            }
        }
        System.gc();
    }

    public static void LoadScripts(int n) {
        if (n == -1) {
            return;
        }
        int n2 = _last_script_file - _first_script_file;
        int n3 = _first_script_file;
        for (int i = 0; i <= n2; ++i) {
            try {
                SDKInputStream sDKInputStream = new SDKInputStream(n3);
                int n4 = sDKInputStream.available() >> 1;
                Script.LoadScript(sDKInputStream, i, n4);
                sDKInputStream.close();
                sDKInputStream = null;
                System.gc();
                ++n3;
                continue;
            }
            catch (IOException iOException) {
                Debug.CatchException("IO exception while loading script", iOException);
            }
        }
        SDKInputStream.purgeCache();
        System.gc();
    }

    public static void LoadScript(SDKInputStream sDKInputStream, int n, int n2) throws IOException {
        Script._scripts[n] = new short[n2 + 1];
        short[] sArray = Script._scripts[n];
        for (int i = 0; i < n2; ++i) {
            sArray[i] = sDKInputStream.readShort();
        }
        sArray[n2] = -1;
    }

    public static void KillScripts(int n) {
        if (_scriptInstances != null) {
            for (int i = 0; i < 32; ++i) {
                if (_scriptInstances[i][0] != n) continue;
                Script.KillScript(i);
            }
        }
    }

    public static void PauseScripts(int n) {
        if (_scriptInstances != null) {
            for (int i = 0; i < 32; ++i) {
                short[] sArray = _scriptInstances[i];
                if (sArray[0] != n) continue;
                sArray[2] = 2;
            }
        }
    }

    public static void ResumeScripts(int n) {
        if (_scriptInstances != null) {
            for (int i = 0; i < 32; ++i) {
                short[] sArray = _scriptInstances[i];
                if (sArray[0] != n) continue;
                sArray[2] = 1;
            }
        }
    }

    public static void KillScript(int n) {
        if (_scriptInstances != null) {
            short[] sArray = _scriptInstances[n];
            sArray[2] = 0;
            sArray[0] = -1;
        }
    }

    public static void PauseScript(int n) {
        if (_scriptInstances != null) {
            Script._scriptInstances[n][2] = 2;
        }
    }

    public static void ResumeScript(int n) {
        if (_scriptInstances != null) {
            Script._scriptInstances[n][2] = 1;
        }
    }

    public static int StartScript(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            return -1;
        }
        int n6 = Script.GetScriptSource(n);
        return Script.StartScript(n, n6, n2, n3, n4, n5);
    }

    public static int StartAIScript(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            return -1;
        }
        int n6 = Script.GetScriptSource(n);
        int n7 = Script.StartScript(n, n6, n2, n3, n4, n5);
        Script._scriptInstances[n7][2] = 4;
        return n7;
    }

    public static int StartScript(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Script.GetFreeSlot();
        if (n7 >= 0 && n2 >= 0) {
            Script._scriptInstances[n7][0] = (short)n;
            Script._scriptInstances[n7][1] = (short)n2;
            Script._scriptInstances[n7][2] = 1;
            Script._scriptInstances[n7][3] = 1;
            Script._scriptInstances[n7][4] = 0;
            Script._scriptInstances[n7][5] = (short)n3;
            Script._scriptInstances[n7][6] = (short)n4;
            Script._scriptInstances[n7][7] = (short)n5;
            Script._scriptInstances[n7][8] = (short)n6;
        }
        return n7;
    }

    static String GetInstructionName(int n) {
        switch (n) {
            case 0: {
                return "BLOCK";
            }
            case 1: {
                return "IF";
            }
            case 2: {
                return "WHILE";
            }
            case 10: {
                return "SET_ANIM";
            }
            case 11: {
                return "SET_ANIM_FRAME";
            }
            case 12: {
                return "SET_POSITION";
            }
            case 13: {
                return "SPAWN_ENTITY";
            }
            case 14: {
                return "KILL_ENTITY";
            }
            case 15: {
                return "FOLLOW_ENTITY";
            }
            case 16: {
                return "CENTER_TO";
            }
            case 17: {
                return "IS_ANIM_ENDED";
            }
            case 19: {
                return "SET_FLAGS";
            }
            case 20: {
                return "RESET_FLAGS";
            }
            case 21: {
                return "CAMERA_LINEAR_TO";
            }
            case 52: {
                return "BREAK";
            }
            case 31: {
                return "TEST_VARIABLE";
            }
            case 32: {
                return "SET_VARIABLE";
            }
            case 33: {
                return "TEST_REGISTERE";
            }
            case 34: {
                return "SET_REGISTER";
            }
            case 35: {
                return "TEST_STATE";
            }
            case 36: {
                return "SET_STATE";
            }
            case 37: {
                return "ADD_REGISTER";
            }
            case 38: {
                return "SAVE_VARIABLE";
            }
            case 39: {
                return "SAVE_STATE";
            }
            case 40: {
                return "WAIT";
            }
            case 41: {
                return "START_SCRIPT";
            }
            case 42: {
                return "PLAY_SOUND";
            }
            case 44: {
                return "MOVIE_BARS";
            }
            case 45: {
                return "TEST_MEMORY";
            }
            case 46: {
                return "SET_MEMORY";
            }
            case 47: {
                return "SAVE_MEMORY";
            }
            case 48: {
                return "KILL_SCRIPTS";
            }
            case 50: {
                return "STOP_SOUND";
            }
            case 100: {
                return "SPAWN_UNIT";
            }
            case 101: {
                return "SELECT_UNITS";
            }
            case 102: {
                return "GROUP_UNITS";
            }
            case 103: {
                return "TEST_NR_UNITS";
            }
            case 104: {
                return "TEST_NR_BUILDINGS";
            }
            case 105: {
                return "TRAIN_UNIT";
            }
            case 106: {
                return "START_ATTACK";
            }
            case 107: {
                return "END_LEVEL";
            }
            case 108: {
                return "TEST_RANDOM";
            }
            case 109: {
                return "SET_CAMERA_TO";
            }
            case 110: {
                return "START_MOVE";
            }
            case 111: {
                return "SHOW_MESSAGE";
            }
            case 112: {
                return "START_CURSOR_TUTORIAL";
            }
            case 113: {
                return "START_MOVEMENT_TUTORIAL";
            }
            case 114: {
                return "START_ATTACK_TUTORIAL";
            }
            case 115: {
                return "START_BUILD_TUTORIAL";
            }
            case 116: {
                return "START_GROUP_TUTORIAL";
            }
            case 117: {
                return "START_TRAIN_TUTORIAL";
            }
            case 118: {
                return "START_SELECT_TUTORIAL";
            }
            case 120: {
                return "TEST_ACTIVE_TUTORIA";
            }
            case 121: {
                return "SET_ASSET_AVALABLE";
            }
            case 122: {
                return "END_TUTORIAL";
            }
            case 123: {
                return "TEST_BUILDING_OFFLINE";
            }
            case 124: {
                return "FOW_DISCOVER_TILES";
            }
            case 125: {
                return "FOW_DISCOVER_PIXELS";
            }
            case 126: {
                return "TEST_TRIGGER_STATE";
            }
            case 127: {
                return "SET_AI_DEFENSE";
            }
            case 128: {
                return "SET_AI_SCRIPTING";
            }
            case 129: {
                return "FIRE_SUPERWEAPON";
            }
            case 130: {
                return "TEST_FINISHED_TUTORIAL";
            }
            case 131: {
                return "SET_UNIT_ACTION";
            }
            case 132: {
                return "SET_UNIT_ANIM";
            }
            case 133: {
                return "SET_HULL_ANIM";
            }
            case 134: {
                return "SET_TURRET_ANIM";
            }
            case 135: {
                return "UNIT_FORCE_CRAWL";
            }
            case 136: {
                return "AISUPERWEAPON";
            }
            case 137: {
                return "START_SW_TUTORIAL";
            }
            case 138: {
                return "START_GARRISON_TUTORIAL";
            }
            case 139: {
                return "BUILD_STRUCTURE";
            }
            case 140: {
                return "DEPLOY_CHRONOSPHERE";
            }
            case 141: {
                return "SET_CAMERA_STATE";
            }
            case 142: {
                return "SET_TRIGGER_STATE";
            }
            case 143: {
                return "SET_GROUP_ACTION";
            }
            case 144: {
                return "TEST_AREA_UNITS";
            }
            case 145: {
                return "TEST_AREA_BUILDINGS";
            }
            case 146: {
                return "ADD_BRIEFING_MESSAGE";
            }
            case 147: {
                return "START_SNOW";
            }
            case 148: {
                return "STOP_SNOW";
            }
            case 149: {
                return "SET_CAMERA_SPEED";
            }
            case 150: {
                return "DEFINE_ENTITY_OBJECTIVE";
            }
            case 151: {
                return "DEFINE_GLOBAL_OBJECTIVE";
            }
            case 152: {
                return "SET_OBJECTIVE_STATE";
            }
            case 153: {
                return "START_ATTACK_ENTITY_TUTORIAL";
            }
            case 154: {
                return "SPAWN_ANIMATED_DECORATOR";
            }
            case 155: {
                return "FADE_TO_DARK";
            }
            case 156: {
                return "FADE_TO_GAME";
            }
            case 157: {
                return "SET_ALLEGIANCE_FLAGS";
            }
            case 158: {
                return "RESET_ALLEGIANCE_FLAGS";
            }
            case 159: {
                return "DISABLE_CURSOR_SELECT";
            }
            case 160: {
                return "ENABLE_CURSOR_SELECT";
            }
            case 161: {
                return "SPAWN_UNITS_AT_SP";
            }
            case 162: {
                return "START_SKIPABLE_MOVIE";
            }
            case 163: {
                return "END_SKIPABLE_MOVIE";
            }
            case 164: {
                return "TEST_MOVIE_SKIPPED";
            }
            case 165: {
                return "SELECT_GROUP";
            }
            case 166: {
                return "SHOW_POWER_LINES";
            }
            case 167: {
                return "DISABLE_CHANGE_SQUAD";
            }
            case 168: {
                return "SET_PATH_REGION";
            }
        }
        return "UNKNOWN INSTRUCTION: id " + n;
    }

    static int ExecuteInstruction(int n, int n2, int n3) {
        short s = _scripts[n2][n3];
        switch (s) {
            case 0: {
                return ScriptInstructions.ExecBlock(n, n2, n3);
            }
            case 1: {
                return ScriptInstructions.ExecIf(n, n2, n3);
            }
            case 2: {
                return ScriptInstructions.ExecWhile(n, n2, n3);
            }
            case 10: {
                return ScriptInstructions.ExecSetAnim(n, n2, n3);
            }
            case 11: {
                return ScriptInstructions.ExecSetAnimFrame(n, n2, n3);
            }
            case 12: {
                return ScriptInstructions.ExecSetPosition(n, n2, n3);
            }
            case 13: {
                return ScriptInstructions.ExecSpawnEntity(n, n2, n3);
            }
            case 14: {
                return ScriptInstructions.ExecKillEntity(n, n2, n3);
            }
            case 15: {
                return ScriptInstructions.ExecFollowEntity(n, n2, n3);
            }
            case 16: {
                return ScriptInstructions.ExecCenterTo(n, n2, n3);
            }
            case 17: {
                return ScriptInstructions.ExecIsAnimEnded(n, n2, n3);
            }
            case 19: {
                return ScriptInstructions.ExecSetFlags(n, n2, n3);
            }
            case 20: {
                return ScriptInstructions.ExecResetFlags(n, n2, n3);
            }
            case 21: {
                return ScriptInstructions.ExecCameraLinearTo(n, n2, n3);
            }
            case 52: {
                return ScriptInstructions.ExecBreak(n, n2, n3);
            }
            case 31: {
                return ScriptInstructions.ExecTestVariable(n, n2, n3);
            }
            case 32: {
                return ScriptInstructions.ExecSetVariable(n, n2, n3);
            }
            case 33: {
                return ScriptInstructions.ExecTestRegister(n, n2, n3);
            }
            case 34: {
                return ScriptInstructions.ExecSetRegister(n, n2, n3);
            }
            case 35: {
                return ScriptInstructions.ExecTestState(n, n2, n3);
            }
            case 36: {
                return ScriptInstructions.ExecSetState(n, n2, n3);
            }
            case 37: {
                return ScriptInstructions.ExecAddRegister(n, n2, n3);
            }
            case 38: {
                return ScriptInstructions.ExecSaveVariable(n, n2, n3);
            }
            case 39: {
                return ScriptInstructions.ExecSaveState(n, n2, n3);
            }
            case 40: {
                return ScriptInstructions.ExecWait(n, n2, n3);
            }
            case 41: {
                return ScriptInstructions.ExecStartScript(n, n2, n3);
            }
            case 42: {
                return ScriptInstructions.ExecPlaySound(n, n2, n3);
            }
            case 44: {
                return ScriptInstructions.ExecMovieBars(n, n2, n3);
            }
            case 45: {
                return ScriptInstructions.ExecTestMemory(n, n2, n3);
            }
            case 46: {
                return ScriptInstructions.ExecSetMemory(n, n2, n3);
            }
            case 47: {
                return ScriptInstructions.ExecSaveMemory(n, n2, n3);
            }
            case 48: {
                return ScriptInstructions.ExecKillScripts(n, n2, n3);
            }
            case 50: {
                return ScriptInstructions.ExecStopSound(n, n2, n3);
            }
            case 100: {
                return ScriptInstructions.ExecSpawnUnit(n, n2, n3);
            }
            case 101: {
                return ScriptInstructions.ExecSelectUnits(n, n2, n3);
            }
            case 102: {
                return ScriptInstructions.ExecGroupUnits(n, n2, n3);
            }
            case 103: {
                return ScriptInstructions.ExecTestNrUnits(n, n2, n3);
            }
            case 104: {
                return ScriptInstructions.ExecTestNrBuildings(n, n2, n3);
            }
            case 105: {
                return ScriptInstructions.ExecTrainUnit(n, n2, n3);
            }
            case 106: {
                return ScriptInstructions.ExecStartAttack(n, n2, n3);
            }
            case 107: {
                return ScriptInstructions.ExecEndLevel(n, n2, n3);
            }
            case 108: {
                return ScriptInstructions.ExecTestRandom(n, n2, n3);
            }
            case 109: {
                return ScriptInstructions.ExecSetCameraTo(n, n2, n3);
            }
            case 110: {
                return ScriptInstructions.ExecStartMove(n, n2, n3);
            }
            case 111: {
                return ScriptInstructions.ExecShowMessage(n, n2, n3);
            }
            case 112: {
                return ScriptInstructions.ExecStartCursorTutorial(n, n2, n3);
            }
            case 113: {
                return ScriptInstructions.ExecStartMovementTutorial(n, n2, n3);
            }
            case 114: {
                return ScriptInstructions.ExecStartAttackTutorial(n, n2, n3);
            }
            case 115: {
                return ScriptInstructions.ExecStartBuildTutorial(n, n2, n3);
            }
            case 116: {
                return ScriptInstructions.ExecStartGroupTutorial(n, n2, n3);
            }
            case 117: {
                return ScriptInstructions.ExecStartTrainTutorial(n, n2, n3);
            }
            case 118: {
                return ScriptInstructions.ExecStartSelectTutorial(n, n2, n3);
            }
            case 120: {
                return ScriptInstructions.ExecTestActiveTutorial(n, n2, n3);
            }
            case 121: {
                return ScriptInstructions.ExecSetAssetAvailable(n, n2, n3);
            }
            case 122: {
                return ScriptInstructions.ExecEndTutorial(n, n2, n3);
            }
            case 123: {
                return ScriptInstructions.ExecTestBuildingOffline(n, n2, n3);
            }
            case 124: {
                return ScriptInstructions.ExecFowDiscoverTiles(n, n2, n3);
            }
            case 125: {
                return ScriptInstructions.ExecFowDiscoverPixels(n, n2, n3);
            }
            case 126: {
                return ScriptInstructions.ExecTestTriggerState(n, n2, n3);
            }
            case 127: {
                return ScriptInstructions.ExecSetAIDefense(n, n2, n3);
            }
            case 128: {
                return ScriptInstructions.ExecSetAIScripting(n, n2, n3);
            }
            case 129: {
                return ScriptInstructions.ExecFireSuperWeapon(n, n2, n3);
            }
            case 130: {
                return ScriptInstructions.ExecTestFinishedTutorial(n, n2, n3);
            }
            case 131: {
                return ScriptInstructions.ExecSetUnitAction(n, n2, n3);
            }
            case 132: {
                return ScriptInstructions.ExecSetUnitAnim(n, n2, n3);
            }
            case 133: {
                return ScriptInstructions.ExecSetHullAnim(n, n2, n3);
            }
            case 134: {
                return ScriptInstructions.ExecSetTurretAnim(n, n2, n3);
            }
            case 135: {
                return ScriptInstructions.ExecUnitForceCrawl(n, n2, n3);
            }
            case 136: {
                return ScriptInstructions.ExecAISuperWeapon(n, n2, n3);
            }
            case 137: {
                return ScriptInstructions.ExecStartSwTutorial(n, n2, n3);
            }
            case 138: {
                return ScriptInstructions.ExecStartGarrisonTutorial(n, n2, n3);
            }
            case 139: {
                return ScriptInstructions.ExecBuildStructure(n, n2, n3);
            }
            case 140: {
                return ScriptInstructions.ExecDeployChronosphere(n, n2, n3);
            }
            case 141: {
                return ScriptInstructions.ExecSetCameraState(n, n2, n3);
            }
            case 142: {
                return ScriptInstructions.ExecSetTriggerState(n, n2, n3);
            }
            case 143: {
                return ScriptInstructions.ExecSetGroupAction(n, n2, n3);
            }
            case 144: {
                return ScriptInstructions.ExecTestAreaUnits(n, n2, n3);
            }
            case 145: {
                return ScriptInstructions.ExecTestAreaBuildings(n, n2, n3);
            }
            case 146: {
                return ScriptInstructions.ExecAddBriefingMessage(n, n2, n3);
            }
            case 147: {
                return ScriptInstructions.ExecStartSnow(n, n2, n3);
            }
            case 148: {
                return ScriptInstructions.ExecStopSnow(n, n2, n3);
            }
            case 149: {
                return ScriptInstructions.ExecSetCameraSpeed(n, n2, n3);
            }
            case 150: {
                return ScriptInstructions.ExecDefineEntityObjective(n, n2, n3);
            }
            case 151: {
                return ScriptInstructions.ExecDefineGlobalObjective(n, n2, n3);
            }
            case 152: {
                return ScriptInstructions.ExecSetObjectiveState(n, n2, n3);
            }
            case 153: {
                return ScriptInstructions.ExecStartAttackEntityTutorial(n, n2, n3);
            }
            case 154: {
                return ScriptInstructions.ExecSpawnAnimatedDecorator(n, n2, n3);
            }
            case 155: {
                return ScriptInstructions.ExecFadeToDark(n, n2, n3);
            }
            case 156: {
                return ScriptInstructions.ExecFadeToGame(n, n2, n3);
            }
            case 157: {
                return ScriptInstructions.ExecSetAlligeanceFlags(n, n2, n3);
            }
            case 158: {
                return ScriptInstructions.ExecResetAlligeanceFlags(n, n2, n3);
            }
            case 159: {
                return ScriptInstructions.ExecDisableCursorSelect(n, n2, n3);
            }
            case 160: {
                return ScriptInstructions.ExecEnableCursorSelect(n, n2, n3);
            }
            case 161: {
                return ScriptInstructions.ExecSpawnUnitsAtSP(n, n2, n3);
            }
            case 162: {
                return ScriptInstructions.ExecStartSkipableMovie(n, n2, n3);
            }
            case 163: {
                return ScriptInstructions.ExecEndSkipableMovie(n, n2, n3);
            }
            case 164: {
                return ScriptInstructions.ExecTestMovieSkipped(n, n2, n3);
            }
            case 165: {
                return ScriptInstructions.ExecSelectGroup(n, n2, n3);
            }
            case 166: {
                return ScriptInstructions.ExecShowPowerLines(n, n2, n3);
            }
            case 167: {
                return ScriptInstructions.ExecDisableChangeSquad(n, n2, n3);
            }
            case 168: {
                return ScriptInstructions.ExecSetPathRegion(n, n2, n3);
            }
        }
        return n3;
    }

    public static int RunScript(int n) {
        short s = _scriptInstances[n][3];
        if (s == -1) {
            Script.KillScript(n);
            return 0;
        }
        short s2 = _scriptInstances[n][1];
        short s3 = _scripts[s2][s];
        if (s3 == -1) {
            Script.KillScript(n);
            return 0;
        }
        Script._scriptInstances[n][3] = (short)Script.ExecuteInstruction(n, s2, s);
        return 1;
    }

    public static void RunEngine() {
        if (_scriptInstances != null) {
            for (int i = 0; i < 32; ++i) {
                if (_scriptInstances[i] == null || _scriptInstances[i][2] != 1) continue;
                Script.RunScript(i);
            }
        }
    }

    public static int GetFreeSlot() {
        for (int i = 0; i < 32; ++i) {
            if (_scriptInstances[i][2] != 0) continue;
            return i;
        }
        return -1;
    }

    public static int GetScriptSource(int n) {
        int n2 = -1;
        if (_scripts != null) {
            int n3 = _scripts.length;
            for (int i = 0; i < n3; ++i) {
                if (_scripts[i] == null || _scripts[i][0] != n) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    static int GetVariabile(int n, int n2, int n3) {
        n2 = Script.GetRegistryValue(n, n2);
        switch (n3) {
            case 1: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._state;
            }
            case 2: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._pos_x;
            }
            case 3: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._pos_y;
            }
            case 4: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._orientation;
            }
            case 5: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._crt_anim;
            }
            case 6: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._crt_aframe;
            }
            case 7: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 6) {
                    return ((Building)entity)._allegiance;
                }
                if (entity._type == 5) {
                    return ((Unit)entity)._allegiance;
                }
                return 2;
            }
            case 8: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 6) {
                    return ((Building)entity)._life;
                }
                if (entity._type == 5) {
                    return ((Unit)entity)._life;
                }
                return 0;
            }
            case 9: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null || entity._type != 5) break;
                return ((Unit)entity)._veterancy_lvl;
            }
            case 100: {
                return Level._player_money;
            }
            case 101: {
                return Level._player_power;
            }
            case 102: {
                return Level._player_power - Level._player_consumption;
            }
            case 103: {
                return Level._ai_money;
            }
            case 104: {
                return Level._ai_power;
            }
            case 105: {
                return Level._ai_power - Level._ai_consumption;
            }
            case 106: {
                return Level._level_timer / 1000;
            }
            case 107: {
                return Hud._hud_state;
            }
            case 108: {
                return Level._player_max_command_points;
            }
            case 109: {
                return Level._ai_max_command_points;
            }
            case 110: {
                return Hud._sw_cooldown[0] / 14;
            }
            case 113: {
                return Hud._sw_cooldown[1] / 14;
            }
            case 114: {
                return Hud._sw_cooldown[2] / 14;
            }
            case 121: {
                return Level._ai_command_points;
            }
            case 115: {
                return Hud._sw_cooldown[3] / 14;
            }
            case 116: {
                return Hud._sw_cooldown[4] / 14;
            }
            case 117: {
                return Hud._sw_cooldown[5] / 14;
            }
            case 111: {
                return Level._timeline_counter / 14;
            }
            case 112: {
                return Hud._event_timer / 14;
            }
            case 118: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                return entity._z_order;
            }
            case 119: {
                return Hud._wave_no;
            }
            case 120: {
                return Hud._wave_total;
            }
        }
        int n4 = Script.GetRegistryValue(n, n3);
        if (n4 == n3) {
            return 0;
        }
        return n4;
    }

    static void SetVariabile(int n, int n2, int n3, int n4) {
        n2 = Script.GetRegistryValue(n, n2);
        n3 = Script.GetRegistryValue(n, n3);
        n4 = Script.GetRegistryValue(n, n4);
        switch (n3) {
            case 1: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 5) {
                    ((Unit)entity).SetState(n4);
                    break;
                }
                if (entity._type == 6) {
                    ((Building)entity).SetState(n4);
                    break;
                }
                if (entity._type == 8) {
                    entity.Bridge_ChangeState(n4, true);
                    break;
                }
                entity._state = n4;
                break;
            }
            case 2: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity.SetPosition(n4, entity._pos_y);
                break;
            }
            case 3: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity.SetPosition(entity._pos_x, n4);
                break;
            }
            case 4: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity._orientation = (byte)n4;
                break;
            }
            case 5: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity.SetCrtAnim(n4);
                break;
            }
            case 6: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity._crt_aframe = n4;
                break;
            }
            case 7: {
                short s;
                Entity entity;
                Entity entity2 = Level.GetEntityById(-1, n2);
                if (entity2 == null) break;
                if (entity2._type == 6) {
                    entity = (Building)entity2;
                    entity.ChangeAllegiance(n4);
                }
                if (entity2._type != 5) break;
                entity = (Unit)entity2;
                Level.DecEntityNo(5, ((Unit)entity)._subtype, ((Unit)entity)._allegiance);
                Level.IncEntityNo(5, ((Unit)entity)._subtype, n4);
                int n5 = -1;
                byte by = ((Unit)entity)._group;
                ((Unit)entity)._bSelected = false;
                if (((Unit)entity)._allegiance == 0) {
                    --Level._player_command_points;
                    Level.Group_Remove((Unit)entity);
                }
                if (((Unit)entity)._allegiance == 1) {
                    --Level._ai_command_points;
                }
                if (((Unit)entity)._group > 0 && ((Unit)entity)._allegiance == 1 && MasterAI._AI_groups[s = (short)((Unit)entity)._group][0] > 0) {
                    int[] nArray = MasterAI._AI_groups[s];
                    nArray[0] = nArray[0] - 1;
                }
                s = ((Unit)entity)._life;
                ((Unit)entity)._life = 0;
                UtilEntity.CheckTriggers((Unit)entity, entity._pos_x, entity._pos_y);
                ((Unit)entity)._allegiance = (byte)n4;
                if (((Unit)entity)._allegiance == 0) {
                    ++Level._player_command_points;
                    Level.Group_Add((Unit)entity, by);
                }
                if (((Unit)entity)._allegiance == 1) {
                    ++Level._ai_command_points;
                }
                ((Unit)entity)._life = s;
                UtilEntity.CheckTriggers((Unit)entity, entity._pos_x, entity._pos_y);
                break;
            }
            case 8: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                if (entity._type == 6) {
                    ((Building)entity)._life = (short)n4;
                }
                if (entity._type != 5) break;
                ((Unit)entity)._life = (short)n4;
                break;
            }
            case 9: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null || entity._type != 5) break;
                ((Unit)entity)._veterancy_lvl = (byte)n4;
                break;
            }
            case 100: {
                Level._player_money = n4;
                break;
            }
            case 101: {
                Level._player_power = n4;
                break;
            }
            case 102: {
                Level._player_power = Level._player_consumption + n4;
                break;
            }
            case 103: {
                Level._ai_money = n4;
                break;
            }
            case 104: {
                Level._ai_power = n4;
                break;
            }
            case 105: {
                Level._ai_power = Level._ai_consumption + n4;
                break;
            }
            case 106: {
                Level._level_timer = n4 * 1000;
                break;
            }
            case 107: {
                Hud.ChangeState(n4, true);
                break;
            }
            case 108: {
                Level._player_max_command_points = n4;
                break;
            }
            case 109: {
                Level._ai_max_command_points = n4;
                break;
            }
            case 121: {
                Level._ai_command_points = n4;
                break;
            }
            case 110: {
                Hud._sw_cooldown[0] = n4 * 14;
                break;
            }
            case 113: {
                Hud._sw_cooldown[1] = n4 * 14;
            }
            case 114: {
                Hud._sw_cooldown[2] = n4 * 14;
            }
            case 115: {
                Hud._sw_cooldown[3] = n4 * 14;
            }
            case 116: {
                Hud._sw_cooldown[4] = n4 * 14;
            }
            case 117: {
                Hud._sw_cooldown[5] = n4 * 14;
            }
            case 111: {
                Level._timeline_counter = n4 * 14;
                break;
            }
            case 112: {
                Hud._event_timer = n4 * 14;
                break;
            }
            case 118: {
                Entity entity = Level.GetEntityById(-1, n2);
                if (entity == null) break;
                entity._z_order = n4;
                break;
            }
            case 119: {
                Hud._wave_no = n4;
                break;
            }
            case 120: {
                Hud._wave_total = n4;
                break;
            }
            case 15000: {
                Script._scriptInstances[n][5] = (short)n4;
                break;
            }
            case 15001: {
                Script._scriptInstances[n][6] = (short)n4;
                break;
            }
            case 15002: {
                Script._scriptInstances[n][7] = (short)n4;
                break;
            }
            case 15003: {
                Script._scriptInstances[n][8] = (short)n4;
            }
        }
    }

    static String GetVariabileName(int n) {
        switch (n) {
            case 1: {
                return "ENTITY_STATE";
            }
            case 2: {
                return "ENTITY_POS_X";
            }
            case 3: {
                return "ENTITY_POS_Y";
            }
            case 4: {
                return "ENTITY_ORIENTATION";
            }
            case 5: {
                return "ENTITY_ANIM";
            }
            case 6: {
                return "ENTITY_FRAME";
            }
            case 7: {
                return "ENTITY_ALLEGIACE";
            }
            case 8: {
                return "ENTITY_LIFE";
            }
            case 9: {
                return "UNIT_VETERANCY";
            }
            case 100: {
                return "PLAYER_MONEY";
            }
            case 101: {
                return "PLAYER_POWER";
            }
            case 102: {
                return "PLAYER_FREE_POWER";
            }
            case 103: {
                return "AI_MONEY";
            }
            case 104: {
                return "AI_POWER";
            }
            case 105: {
                return "AI_FREE_POWER";
            }
            case 106: {
                return "TIMER";
            }
            case 107: {
                return "HUD_STATE";
            }
            case 108: {
                return "PLAYER_MAX_COMMAND_POINTS";
            }
            case 109: {
                return "AI_MAX_COMMAND_POINTS";
            }
            case 110: {
                return "PLAYER_NUKE_COOLDOWN";
            }
            case 113: {
                return "PLAYER_KIROV_COOLDOWN";
            }
            case 114: {
                return "PLAYER_IRON_CURTAIN_COOLDOWN";
            }
            case 115: {
                return "PLAYER_HARRIER_COOLDOWN";
            }
            case 116: {
                return "PLAYER_CHRONO_COOLDOWN";
            }
            case 117: {
                return "PLAYER_WEATHER_COOLDOWN";
            }
            case 111: {
                return "TIMELINE_SECONDS";
            }
            case 112: {
                return "EVENT_TIMER";
            }
        }
        return "UNKNOWN VARIABLE: " + n;
    }

    public static int GetRegistryValue(int n, int n2) {
        switch (n2) {
            case 15000: {
                return _scriptInstances[n][5];
            }
            case 15001: {
                return _scriptInstances[n][6];
            }
            case 15002: {
                return _scriptInstances[n][7];
            }
            case 15003: {
                return _scriptInstances[n][8];
            }
        }
        return n2;
    }

    static int SpawnEntity(int n, int n2, int n3) {
        Entity entity = null;
        entity = n2 >= 0 ? Level.SpawnEntity(n2) : Level.SpawnEntity(2);
        if (entity != null) {
            if (n3 >= 0) {
                entity._sprite = n3;
            }
            if (n >= 0) {
                entity._id = n;
            }
            if (n2 < 0) {
                entity._z_order = 4;
                entity._flags &= 0xFFFFFDFF;
                entity._flags &= 0xFFFFF7FF;
            }
            return entity._id;
        }
        return -1;
    }
}

