/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.GameImpl;
import com.ea.game.Map;
import com.ea.game.PathfinderConstants;
import com.ea.game.Utils;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Pathfinder
implements Constants,
PathfinderConstants {
    static short[] _tasks_data = new short[720];
    static int _tasks_current = 0;
    static int _tasks_last = 0;
    static byte[][] _results_data = new byte[120][256];
    public static boolean _bAStarThreadRunning = false;
    public static boolean _bAStarSignalStop = false;
    public static short[] _node_data_list = new short[32000];
    public static int _node_data_list_count = 0;
    public static short[] _open_list = new short[1600];
    public static int _open_list_count = 0;
    public static int _start_tileX = 0;
    public static int _start_tileY = 0;
    public static int _start_tileIndex = 0;
    public static int _finish_tileX = 0;
    public static int _finish_tileY = 0;
    public static int _finish_tileIndex = 0;
    static short[] _regions = new short[60];
    static int _regions_count;

    public static void Init() {
        _tasks_current = 0;
        _tasks_last = 0;
        _bAStarThreadRunning = false;
        _bAStarSignalStop = false;
        _open_list_count = 0;
        _node_data_list_count = 0;
        _tasks_data = null;
        if (_results_data != null) {
            for (int i = 0; i < 120; ++i) {
                Pathfinder._results_data[i] = null;
            }
            _results_data = null;
        }
        System.gc();
        _tasks_data = new short[720];
        _results_data = new byte[120][256];
        Pathfinder.Region_Init();
    }

    public static void Update() {
        if (_bAStarThreadRunning) {
            try {
                Pathfinder.AStar_MainLoop();
            }
            catch (Exception exception) {
                Pathfinder.AStar_SignalStop();
                Pathfinder.AbortPath(_tasks_current);
            }
        } else if (_tasks_current != _tasks_last) {
            while (_tasks_current != _tasks_last && _tasks_data[(_tasks_current = (_tasks_current + 6) % 720) + 0] == -1) {
            }
            if (_tasks_data[_tasks_current + 0] != -1) {
                Pathfinder.AStar_DoTask(_tasks_current);
            }
        }
    }

    public static void Draw(SDKGraphics sDKGraphics) {
    }

    static void TASK_MANAGEMENT__() {
    }

    public static int RequestPath(int n, int n2, int n3, int n4) {
        int n5 = Pathfinder.GetRegionAt(n, n2);
        int n6 = Pathfinder.GetRegionAt(n3, n4);
        if (n5 != -1 && n6 != -1 && n5 != n6) {
            return -1;
        }
        int n7 = (_tasks_last + 6) % 720;
        if (n7 == _tasks_current) {
            return -1;
        }
        _tasks_last = (short)n7;
        Pathfinder._tasks_data[n7 + 0] = 0;
        Pathfinder._tasks_data[n7 + 1] = (short)n;
        Pathfinder._tasks_data[n7 + 2] = (short)n2;
        Pathfinder._tasks_data[n7 + 3] = (short)n3;
        Pathfinder._tasks_data[n7 + 4] = (short)n4;
        Pathfinder._tasks_data[n7 + 5] = -1;
        return n7;
    }

    public static int UpdatePathData(int n, int n2, int n3, int n4, int n5) {
        if (n < 0 || n >= 720) {
            return -1;
        }
        short s = _tasks_data[n + 0];
        if (s == 0) {
            Pathfinder._tasks_data[n + 1] = (short)n2;
            Pathfinder._tasks_data[n + 2] = (short)n3;
            Pathfinder._tasks_data[n + 3] = (short)n4;
            Pathfinder._tasks_data[n + 4] = (short)n5;
            return n;
        }
        Pathfinder.AbortPath(n);
        return Pathfinder.RequestPath(n2, n3, n4, n5);
    }

    public static void AbortPath(int n) {
        short s = _tasks_data[n + 0];
        if (s == 1) {
            Pathfinder.AStar_SignalStop();
        }
        Pathfinder._tasks_data[n + 0] = -1;
    }

    public static int GetPathStatus(int n) {
        return _tasks_data[n + 0];
    }

    public static byte[] GetPathData(int n) {
        return _results_data[n / 6];
    }

    public static int GetPathWaypoints(int n, byte[] byArray) {
        byte[] byArray2 = _results_data[n / 6];
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = _tasks_data[n + 5];
        if (n5 > n2) {
            n3 = n5 - n2;
        }
        while (n3 < n5) {
            byArray[n4] = byArray2[n3];
            ++n3;
            ++n4;
        }
        return n4 - 2;
    }

    static void __TASK_MANAGEMENT() {
    }

    static void ASTAR__() {
    }

    public static void AStar_DoTask(int n) {
        Pathfinder._tasks_data[n + 0] = 1;
        _start_tileX = _tasks_data[n + 1] / 8;
        _start_tileY = _tasks_data[n + 2] / 8;
        _start_tileIndex = _start_tileY * Map._coll_map_tw + _start_tileX;
        _finish_tileX = _tasks_data[n + 3] / 8;
        _finish_tileY = _tasks_data[n + 4] / 8;
        if (!Map.ValidateCollisionTile(_start_tileX, _start_tileY, 7)) {
            return;
        }
        _start_tileX = Map._validTileX;
        _start_tileY = Map._validTileY;
        _start_tileIndex = _start_tileY * Map._coll_map_tw + _start_tileX;
        if (!Map.ValidateCollisionTile(_finish_tileX, _finish_tileY, 7)) {
            return;
        }
        _finish_tileY = Map._validTileY;
        _finish_tileX = Map._validTileX;
        _finish_tileIndex = _finish_tileY * Map._coll_map_tw + _finish_tileX;
        if (_start_tileIndex == _finish_tileIndex) {
            Pathfinder._tasks_data[n + 0] = 2;
            return;
        }
        Pathfinder.AStar_Start();
    }

    public static void AStar_Start() {
        _bAStarThreadRunning = true;
        _bAStarSignalStop = false;
        int n = Pathfinder.AddNodeData(_start_tileIndex, 0, 0, -1);
        Pathfinder.AddPointerToOpenList(n);
    }

    private static void AStar_SignalStop() {
        _bAStarSignalStop = true;
    }

    public static void AStar_Reset() {
        _open_list_count = 0;
        _node_data_list_count <<= 2;
        for (int i = 0; i < _node_data_list_count; i += 4) {
            if (_node_data_list[i + 0] < 0 || _node_data_list[i + 0] >= Map._coll_map_size) continue;
            short s = _node_data_list[i + 0];
            Map._coll_map[s] = (byte)(Map._coll_map[s] & 0x7F);
        }
        _node_data_list_count = 0;
    }

    public static void AStar_MainLoop() {
        long l = -1L;
        long l2 = 70L;
        int n = -1;
        while (_bAStarThreadRunning) {
            if (_bAStarSignalStop) {
                _bAStarThreadRunning = false;
                _bAStarSignalStop = false;
                break;
            }
            long l3 = System.currentTimeMillis();
            if (l != -1L) {
                l2 -= l3 - l;
            }
            if (l2 < 0L) break;
            l = l3;
            int n2 = 0;
            int n3 = Pathfinder.FindBestNodeInOpenList();
            if (n3 == -1) {
                Pathfinder.AStar_SignalStop();
                Pathfinder.AbortPath(_tasks_current);
                continue;
            }
            n2 = Pathfinder.RemoveOpenNodeByIndex(n3);
            if (_node_data_list[n2 + 0] < 0 || _node_data_list[n2 + 0] >= Map._coll_map_size) {
                Pathfinder.AStar_SignalStop();
                Pathfinder.AbortPath(_tasks_current);
                continue;
            }
            short s = _node_data_list[n2 + 0];
            Map._coll_map[s] = (byte)(Map._coll_map[s] | 0x80);
            n3 = _node_data_list[n2 + 0];
            if (n3 == _finish_tileIndex) {
                n = n2;
                Pathfinder.AStar_Finish(n);
                continue;
            }
            short s2 = _node_data_list[n2 + 2];
            int n4 = _node_data_list[n2 + 1] - s2;
            int n5 = n3 % Map._coll_map_tw;
            int n6 = n3 / Map._coll_map_tw;
            int n7 = n3 - Map._coll_map_tw - 1;
            int n8 = -1;
            while (n8 < 2) {
                int n9 = -1;
                while (n9 < 2) {
                    if (n9 != 0 || n8 != 0) {
                        int n10;
                        int n11 = n5 + n9;
                        int n12 = n6 + n8;
                        if (n11 >= 0 && n12 >= 0 && n11 < Map._coll_map_tw && n12 < Map._coll_map_th && n7 >= 0 && n7 < Map._coll_map_size && (Map._coll_map[n7] & 0x80) == 0 && (n10 = Map._coll_map[n7] & 0x7F) <= 4) {
                            int n13;
                            int n14 = 0;
                            n14 = n9 == 0 || n8 == 0 ? n4 + 5 : n4 + 7;
                            int n15 = 7 * Math.max(Math.abs(n11 - _finish_tileX), Math.abs(n12 - _finish_tileY));
                            int n16 = Pathfinder.FindNodeInOpenList(n7);
                            if (n16 != -1) {
                                n13 = _open_list[n16];
                                if (_node_data_list[n13 + 1] > n14 + n15) {
                                    Pathfinder._node_data_list[n13 + 1] = (short)(n14 + n15);
                                    Pathfinder._node_data_list[n13 + 2] = (short)n15;
                                    Pathfinder._node_data_list[n13 + 3] = (short)n2;
                                }
                            } else {
                                n13 = Pathfinder.AddNodeData(n7, n14 + n15, n15, n2);
                                if (n13 != -1) {
                                    Pathfinder.AddPointerToOpenList(n13);
                                }
                            }
                        }
                    }
                    ++n9;
                    ++n7;
                }
                ++n8;
                n7 += Map._coll_map_tw - 3;
            }
        }
        if (!_bAStarThreadRunning) {
            Pathfinder.AStar_Reset();
        }
    }

    public static void AStar_Finish(int n) {
        Pathfinder._tasks_data[Pathfinder._tasks_current + 0] = 2;
        Pathfinder.AStar_SignalStop();
        byte[] byArray = _results_data[_tasks_current / 6];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 != -1) {
            short s = _node_data_list[n5 + 0];
            int n6 = s % Map._coll_map_tw;
            int n7 = s / Map._coll_map_tw;
            byArray[n2] = (byte)n6;
            byArray[n2 + 1] = (byte)n7;
            if (n2 == 2) {
                n3 = n6 - byArray[n2 - 2];
                n4 = n7 - byArray[n2 - 1];
            } else if (n2 > 2) {
                int n8 = n6 - byArray[n2 - 2];
                int n9 = n7 - byArray[n2 - 1];
                if (n8 == n3 && n9 == n4) {
                    byArray[n2 - 2] = (byte)n6;
                    byArray[n2 - 1] = (byte)n7;
                    n2 -= 2;
                } else {
                    byArray[n2] = (byte)n6;
                    byArray[n2 + 1] = (byte)n7;
                    n3 = n8;
                    n4 = n9;
                }
            }
            if ((n2 += 2) >= 256) break;
            n5 = _node_data_list[n5 + 3];
        }
        Pathfinder._tasks_data[Pathfinder._tasks_current + 5] = (short)n2;
    }

    public static int AddNodeData(int n, int n2, int n3, int n4) {
        if (_node_data_list_count >= 8000) {
            Pathfinder.AStar_SignalStop();
            return -1;
        }
        int n5 = _node_data_list_count << 2;
        Pathfinder._node_data_list[n5 + 0] = (short)n;
        Pathfinder._node_data_list[n5 + 1] = (short)n2;
        Pathfinder._node_data_list[n5 + 2] = (short)n3;
        Pathfinder._node_data_list[n5 + 3] = (short)n4;
        ++_node_data_list_count;
        return n5;
    }

    public static void PushOpenPointer(int n) {
        short s = _node_data_list[n + 1];
        short s2 = _node_data_list[n + 2];
        short s3 = 0;
        short s4 = 0;
        for (int i = ++_open_list_count; i != 1 && (s < (s3 = _node_data_list[(s4 = _open_list[i >> 1]) + 1]) || s == s3 && s2 < _node_data_list[s4 + 2]); i >>= 1) {
            Pathfinder._open_list[i] = _open_list[i >> 1];
        }
        Pathfinder._open_list[i] = (short)n;
    }

    public static short PopBestOpenPointer() {
        short s = _open_list[1];
        short s2 = _open_list[_open_list_count];
        --_open_list_count;
        int n = 1;
        while (n << 1 <= _open_list_count) {
            int n2 = n << 1;
            short s3 = _open_list[n2];
            short s4 = _open_list[n2 + 1];
            if (n2 < _open_list_count && _node_data_list[s3 + 1] > _node_data_list[s4 + 1]) {
                ++n2;
            }
            if (_node_data_list[s2 + 1] <= _node_data_list[s4 + 1]) break;
            Pathfinder._open_list[n] = _open_list[n2];
            n = n2;
        }
        Pathfinder._open_list[n] = s2;
        return s;
    }

    public static int AddPointerToOpenList(int n) {
        if (_open_list_count >= 1600) {
            Pathfinder.AbortPath(_tasks_current);
            return -1;
        }
        Pathfinder._open_list[Pathfinder._open_list_count++] = (short)n;
        return _open_list_count - 1;
    }

    public static int FindBestNodeInOpenList() {
        int n = -1;
        short s = 0;
        short s2 = 0;
        for (int i = 0; i < _open_list_count; ++i) {
            short s3 = _open_list[i];
            short s4 = _node_data_list[s3 + 2];
            short s5 = _node_data_list[s3 + 1];
            if (n != -1 && s5 >= s && (s5 != s || s4 >= s2)) continue;
            s = s5;
            s2 = s4;
            n = i;
        }
        return n;
    }

    public static int FindNodeInOpenList(int n) {
        for (int i = _open_list_count - 1; i >= 0; --i) {
            if (_node_data_list[_open_list[i] + 0] != n) continue;
            return i;
        }
        return -1;
    }

    public static int RemoveOpenNodeByIndex(int n) {
        short s = _open_list[n];
        if (_open_list_count > 1) {
            Pathfinder._open_list[n] = _open_list[_open_list_count - 1];
        }
        --_open_list_count;
        return s;
    }

    static void __ASTAR() {
    }

    static void REGIONS__() {
    }

    static void Region_Init() {
        _regions_count = 0;
    }

    static void Region_Load(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
        short s5 = sDKInputStream.readShort();
        int n = sDKInputStream.read() & 0xFF;
        Pathfinder.Region_Add(s, s2, s3, s4, s5, n);
    }

    static void Region_Add(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = _regions_count * 6;
        Pathfinder._regions[n7 + 0] = (short)n;
        Pathfinder._regions[n7 + 1] = (short)n2;
        Pathfinder._regions[n7 + 2] = (short)n3;
        Pathfinder._regions[n7 + 3] = (short)(n2 + n4);
        Pathfinder._regions[n7 + 4] = (short)(n3 + n5);
        Pathfinder._regions[n7 + 5] = (short)n6;
        ++_regions_count;
    }

    static void Region_Set(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = _regions_count * 6;
        for (int i = 0; i < n7; i += 6) {
            if (_regions[i + 0] != n) continue;
            Pathfinder._regions[i + 1] = (short)n2;
            Pathfinder._regions[i + 2] = (short)n3;
            Pathfinder._regions[i + 3] = (short)(n2 + n4);
            Pathfinder._regions[i + 4] = (short)(n3 + n5);
            Pathfinder._regions[i + 5] = (short)n6;
            break;
        }
    }

    static void Region_Delete(int n) {
        int n2 = _regions_count * 6;
        for (int i = 0; i < n2; i += 6) {
            int n3;
            if (_regions[i + 0] != n) continue;
            if (--_regions_count <= 0 || (n3 = _regions_count * 6) == i) break;
            Pathfinder._regions[i + 0] = _regions[n3 + 0];
            Pathfinder._regions[i + 1] = _regions[n3 + 1];
            Pathfinder._regions[i + 2] = _regions[n3 + 2];
            Pathfinder._regions[i + 3] = _regions[n3 + 3];
            Pathfinder._regions[i + 4] = _regions[n3 + 4];
            Pathfinder._regions[i + 5] = _regions[n3 + 5];
            break;
        }
    }

    static void Region_Draw(SDKGraphics sDKGraphics) {
        int n = _regions_count * 6;
        for (int i = 0; i < n; i += 6) {
            short s = _regions[i + 1];
            short s2 = _regions[i + 2];
            int n2 = _regions[i + 3] - s;
            int n3 = _regions[i + 4] - s2;
            short s3 = _regions[i + 5];
            sDKGraphics.setColor(65280);
            sDKGraphics.drawRect(GameImpl.SV_X + s - Camera._nCamX, GameImpl.SV_Y + s2 - Camera._nCamY, n2, n3);
            SDKUtils.setFont(GameImpl.fonts[4]);
            Utils.DrawNumber(s3, GameImpl.SV_X + s - Camera._nCamX, GameImpl.SV_Y + s2 - Camera._nCamY, 0);
        }
    }

    static int GetRegionAt(int n, int n2) {
        int n3 = -1;
        int n4 = _regions_count * 6;
        for (int i = 0; i < n4; i += 6) {
            if (n < _regions[i + 1] || n > _regions[i + 3] || n2 < _regions[i + 2] || n2 > _regions[i + 4]) continue;
            n3 = _regions[i + 5];
            break;
        }
        return n3;
    }

    static void __REGIONS() {
    }
}

