/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Encyclopedia;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.Menu;
import com.ea.game.MsgBox;
import com.ea.game.Pointer;
import com.ea.game.SpriteConstants;
import com.ea.game.Sprites;
import com.ea.game.Tutorial;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Hud
implements Constants,
Key,
SpriteConstants,
GraphicsConstants,
BuildingConstants,
UnitsConstants,
Pointer {
    public static int _hud_state = 0;
    public static int _hud_old_state;
    public static int _hud_substate;
    public static int _hud_old_substate;
    public static int _hud_current_tab;
    public static int _tutorial_tab;
    public static int _hud_current_squad;
    static short _changeDownFrames;
    static short _changeDoubleFrames;
    static boolean _bchangeDoubleTap;
    public static int _hud_old_squad;
    public static boolean _blink_RSK;
    public static boolean _bDrawCollisionMap;
    public static boolean _bTutorialOn;
    public static int _hud_building;
    public static byte[] _hud_building_cmap;
    public static int _hud_building_offx;
    public static int _hud_building_offy;
    public static int _hud_building_tw;
    public static int _hud_building_th;
    public static int _timer;
    public static int _minimap_timer;
    public static int _minimap_state;
    public static int _old_minimap_state;
    public static int _old_camera_x;
    public static int _old_camera_y;
    public static int _hud_timer;
    public static int _event_timer;
    public static byte _move_tab;
    public static boolean _refinery_snap;
    public static int _snap_x;
    public static int _snap_y;
    public static int _crt_anim;
    public static int _crt_aframe;
    public static int _crt_aframe_time;
    public static int _wave_no;
    public static int _wave_total;
    public static int _minimap_y;
    public static boolean _show_power_lines;
    public static boolean _disable_change_squad;
    public static byte[][] _hud_build_items_available;
    public static byte[] _hud_nr_items_available;
    public static int[] _hud_build_items_available_mask;
    public static byte[] _hud_build_cursor_pos;
    public static byte[] _hud_build_page_pos;
    public static byte[][][] _hud_build_items;
    public static byte[] _hud_build_items_count;
    public static int[] _sw_cooldown;
    public static int _hud_sw;
    public static int _player_iron_curtain_timer;
    public static int _hud_bars_hight;
    public static boolean _hud_movie_bars;
    public static int _old_player_money;
    static SDKString _tooltip_name_string;
    static SDKString _tooltip_cost_string;
    static SDKString _tooltip_descr_string;
    static int _tooltip_old_name;
    static int drawSquadSelX;
    static int drawSquadSelY;
    static int lastPointerX;
    static int lastPointerY;
    static long lastPointerPressedTime;
    static boolean wasPointerPressedBeforeDrag;

    public static void Init() {
        Hud.Reset();
        _minimap_y = 0;
        _hud_state = 0;
        _changeDownFrames = 0;
        _changeDoubleFrames = (short)6;
        _bchangeDoubleTap = false;
        _blink_RSK = true;
        _timer = 0;
        _minimap_timer = 0;
        _sw_cooldown = new int[6];
        for (int i = 0; i < 6; ++i) {
            Hud._sw_cooldown[i] = -1;
        }
        _event_timer = 0;
        _hud_bars_hight = 0;
        _hud_movie_bars = false;
    }

    public static void Reset() {
        for (int i = 0; i < 3; ++i) {
            Hud._hud_build_items_available_mask[i] = 0;
            Hud._hud_build_cursor_pos[i] = 0;
            Hud._hud_build_page_pos[i] = 0;
            Hud._hud_nr_items_available[i] = 0;
        }
        _move_tab = 0;
        Hud._hud_build_items_available_mask[0] = ~(Level._buildings_restricted & 0xFFFF);
        Hud._hud_build_items_available_mask[1] = ~(Level._units_restricted & 0xFFFF);
        Hud._hud_build_items_available_mask[2] = ~(Level._sw_restricted & 0xFFFF);
        _hud_bars_hight = 0;
        _hud_movie_bars = false;
        _minimap_state = 4;
        _wave_no = 0;
        _show_power_lines = true;
        _disable_change_squad = false;
    }

    public static void Update() {
        if (_old_player_money != Level._player_money) {
            _old_player_money = Level._player_money;
        }
        for (int i = 0; i < 6; ++i) {
            if (_sw_cooldown[i] <= 0 || !Level.HasPower(0) || _hud_state >= 4) continue;
            int n = i;
            _sw_cooldown[n] = _sw_cooldown[n] - 1;
        }
        if (_event_timer > 0 && _hud_state != 4) {
            --_event_timer;
        }
        Hud.UpdateMovieBars();
        switch (_hud_state) {
            case 0: {
                Hud.Update_MiniMap();
                Hud.ChangeState(1, true);
                break;
            }
            case 1: {
                Hud.Update_MiniMap();
                Hud.Play_Update();
                break;
            }
            case 2: {
                Hud.Update_MiniMap();
                Hud.Build_Update();
                break;
            }
            case 3: {
                Hud.Update_MiniMap();
                Hud.ChangeSquad_Update();
                break;
            }
            case 4: {
                Hud.Update_MiniMap();
                MsgBox.Update();
                break;
            }
            case 5: {
                if (!SDKCanvas.isNewKeyPressed(32) && (GameImpl._pointerAction & 1) == 0) break;
                GameImpl._pointerAction = 0;
                if (!Level._bCanSkipMovie || Level._skipMovieState != 0 || Utils._fadeCounter > 0) break;
                Level.SkipMovie();
            }
        }
    }

    public static void UpdateMinimapOnly() {
        Hud.Update_MiniMap();
    }

    public static void DrawMinimapAndDetailsOnly(SDKGraphics sDKGraphics) {
        Hud.Draw_MiniMap(sDKGraphics);
    }

    public static void Draw(SDKGraphics sDKGraphics) {
        switch (_hud_state) {
            case 0: {
                Tutorial.Tutorials_Draw(sDKGraphics);
                break;
            }
            case 1: {
                Hud.Play_Draw(sDKGraphics);
                Tutorial.Tutorials_Draw(sDKGraphics);
                Hud.DrawMovieBars(sDKGraphics);
                break;
            }
            case 2: {
                Hud.Build_Draw(sDKGraphics);
                Tutorial.Tutorials_Draw(sDKGraphics);
                break;
            }
            case 3: {
                Hud.ChangeSquad_Draw(sDKGraphics);
                Tutorial.Tutorials_Draw(sDKGraphics);
                break;
            }
            case 4: {
                if (!_hud_movie_bars) {
                    Hud.Draw_Details(sDKGraphics);
                    Hud.Draw_MiniMap(sDKGraphics);
                    Hud.Draw_CommandPoints(sDKGraphics);
                }
                Tutorial.Tutorials_Draw(sDKGraphics);
                Hud.DrawMovieBars(sDKGraphics);
                MsgBox.Draw(sDKGraphics);
                break;
            }
            case 5: {
                Tutorial.Tutorials_Draw(sDKGraphics);
                Hud.DrawMovieBars(sDKGraphics);
                if (!Level._bCanSkipMovie || Level._skipMovieState != 0 || Utils._fadeCounter > 0) break;
                Hud.DrawSoftKeys(SDKUtils.getString(14, Utils._temp_string), true, 4, true, true);
            }
        }
        Hud.DrawSoftKeys(SDKUtils.getString(9, Utils._temp_string), false, 4, true, true);
    }

    public static void ChangeState(int n, boolean bl) {
        if (_hud_state == n) {
            return;
        }
        if (_hud_state == 2 && _hud_substate == 4 && _hud_sw == 4 && Level._chrono_state == 0) {
            Level.SWChrono_Cancel();
        }
        switch (n) {
            case 2: {
                _old_camera_x = Camera._nCamX;
                _old_camera_y = Camera._nCamY;
                Hud.RefreshBuildMenuItems();
                for (int i = 0; i < 3; ++i) {
                    if (!bl) continue;
                    Hud.RefreshCursor(i);
                }
                _hud_substate = 0;
                Hud.SinkMovieBars();
                break;
            }
            case 3: {
                Hud.SinkMovieBars();
                _hud_old_squad = Level._currentGroup;
                if (Level._currentGroup != 0) break;
                Level._currentGroup = 1;
                break;
            }
            case 1: {
                Hud.SinkMovieBars();
                Level._paused = 0;
                break;
            }
            case 4: {
                Cursor._bCursorExpanded = false;
                break;
            }
            case 5: {
                Cursor._bCursorExpanded = false;
                Hud.RiseMovieBars();
            }
        }
        _hud_state = n;
    }

    static void GENERIC__() {
    }

    public static void AddAvailableBuildItems(int n, int n2) {
        int n3 = n;
        _hud_build_items_available_mask[n3] = _hud_build_items_available_mask[n3] | n2 & 0xFFFFFFFF;
        Hud.RefreshBuildMenuItems();
    }

    public static void RemoveAvailableBuildItems(int n, int n2) {
        int n3 = n;
        _hud_build_items_available_mask[n3] = _hud_build_items_available_mask[n3] & ~(n2 & 0xFFFFFFFF);
        Hud.RefreshBuildMenuItems();
    }

    public static int GetBuildMenuItem(int n, int n2) {
        return _hud_build_items[n][Level._player_faction][n2];
    }

    public static int GetBuildMenuItemCount(int n) {
        return _hud_build_items_count[n * 2 + Level._player_faction];
    }

    public static void RefreshBuildMenuItems() {
        for (int i = 0; i < 3; ++i) {
            int n;
            int n2;
            byte[] byArray = _hud_build_items_available[i];
            int n3 = _hud_build_items_available_mask[i];
            int n4 = 0;
            int n5 = 0;
            int n6 = Hud.GetBuildMenuItemCount(i);
            while (n5 < n6) {
                int n7 = Hud.GetBuildMenuItem(i, n5);
                if ((n3 & 1 << n7) != 0) {
                    n2 = 0;
                    switch (i) {
                        case 0: {
                            n2 = Level.GetBuildingStats(Level._player_faction, n7, 3);
                            break;
                        }
                        case 1: {
                            n2 = Level.GetUnitStats(n7, 24);
                            break;
                        }
                        case 2: {
                            n2 = Level.GetSWStats(n7, 1);
                        }
                    }
                    if (n2 == 0) {
                        ++n5;
                        continue;
                    }
                    n = 0;
                    boolean bl = true;
                    while (n2 != 0) {
                        if ((n2 & 1) != 0 && Level.GetEntityNo(6, n, 0) == 0) {
                            bl = false;
                            break;
                        }
                        ++n;
                        n2 >>= 1;
                    }
                    byArray[n4++] = bl ? (byte)n7 : (byte)(n7 + 50);
                }
                ++n5;
            }
            if (i == 0 && (n3 & 0x1000) != 0) {
                byArray[n4++] = 12;
            }
            Hud._hud_nr_items_available[i] = (byte)n4;
            if (i != 2) continue;
            for (n2 = 0; n2 < 6; ++n2) {
                n5 = -1;
                for (n = 0; n < n4; ++n) {
                    if (n2 != byArray[n] && n2 != byArray[n] + 50) continue;
                    n5 = n;
                }
                if (n5 == -1) {
                    Hud._sw_cooldown[n2] = -1;
                    continue;
                }
                if (byArray[n5] >= 50) {
                    Hud._sw_cooldown[n2] = -1;
                    continue;
                }
                if (_sw_cooldown[n2] != -1) continue;
                Hud._sw_cooldown[n2] = 14 * Level.GetSWStats(n2, 0);
            }
        }
    }

    public static void RefreshCursor(int n) {
        Hud._hud_build_cursor_pos[n] = -1;
        Hud._hud_build_page_pos[n] = 0;
        Hud.MoveCursor(n, 1);
    }

    public static void MoveCursor(int n, int n2) {
        int n3 = _hud_build_cursor_pos[n];
        n3 += n2;
        if (_hud_nr_items_available[n] == 0) {
            return;
        }
        if (n3 < 0) {
            n3 = _hud_nr_items_available[n] - 1;
        } else if (n3 >= _hud_nr_items_available[n]) {
            n3 = 0;
        }
        if (n3 < _hud_build_page_pos[n]) {
            Hud._hud_build_page_pos[n] = (byte)n3;
        } else if (n3 >= _hud_build_page_pos[n] + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS) {
            Hud._hud_build_page_pos[n] = (byte)(n3 - GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS + 1);
        }
        Hud._hud_build_cursor_pos[n] = (byte)n3;
    }

    public static void MoveTab(int n) {
        int n2 = _hud_current_tab;
        if (n > 0) {
            if (_move_tab < 0) {
                _move_tab = (byte)n;
                return;
            }
        } else if (_move_tab > 0) {
            _move_tab = (byte)n;
            return;
        }
        if (Math.abs(_move_tab = (byte)(_move_tab + (byte)n)) < 2) {
            return;
        }
        if ((n2 += n) < 0) {
            n2 = 2;
        }
        if (n2 >= 3) {
            n2 = 0;
        }
        _hud_current_tab = n2;
        _move_tab = 0;
    }

    static void __GENERIC() {
    }

    static void MINIMAP__() {
    }

    private static void Update_MiniMap() {
        ++_timer;
        _timer %= 8;
        switch (_minimap_state) {
            case 1: {
                _minimap_y = 0;
                if (Level._player_power > Level._player_consumption && Level.GetEntityNo(6, 8, 0) != 0) break;
                _minimap_state = 2;
                _minimap_timer = 0;
                break;
            }
            case 0: {
                _minimap_y = _minimap_y < -7 ? (_minimap_y -= -7) : 0;
                if (++_minimap_timer != 4) break;
                _minimap_state = 2;
                _minimap_timer = 0;
                break;
            }
            case 2: {
                _minimap_y = 0;
                if (++_minimap_timer != 20) break;
                _minimap_state = Level._player_power > Level._player_consumption && Level.GetEntityNo(6, 8, 0) > 0 ? 1 : 3;
                _minimap_timer = 0;
                break;
            }
            case 3: {
                _minimap_y = _minimap_y > -32 ? (_minimap_y += -4) : -28;
                if (++_minimap_timer != 6) break;
                _minimap_state = 4;
                _minimap_timer = 0;
                break;
            }
            case 4: {
                _minimap_y = -28;
                if (Level._player_power <= Level._player_consumption || Level.GetEntityNo(6, 8, 0) <= 0) break;
                _minimap_state = 0;
                _minimap_timer = 0;
            }
        }
    }

    private static void Draw_MiniMap(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Entity entity;
        int n6;
        int n7;
        int n8;
        XSprite xSprite = Sprites._sprites[11];
        xSprite.DrawFrame(0, 0, _minimap_y, 0);
        if (Level._player_faction == 0) {
            n8 = 0xFF0000;
            n7 = 255;
        } else {
            n8 = 255;
            n7 = 0xFF0000;
        }
        if (_minimap_state == 0) {
            sDKGraphics.setColor(0x400000);
            switch (_minimap_timer) {
                case 0: {
                    int n9 = 42;
                    int n10 = 31;
                    sDKGraphics.drawLine(n9 - 2, n10, n9, n10 - 2);
                    sDKGraphics.drawLine(n9 - 1, n10, n9, n10 - 1);
                    sDKGraphics.drawLine(n9 - 2, n10, n9, n10 + 2);
                    sDKGraphics.drawLine(n9 - 1, n10, n9, n10 + 1);
                    sDKGraphics.drawLine(n9 + 2, n10, n9, n10 - 2);
                    sDKGraphics.drawLine(n9 + 1, n10, n9, n10 - 1);
                    sDKGraphics.drawLine(n9 + 2, n10, n9, n10 + 2);
                    sDKGraphics.drawLine(n9 + 1, n10, n9, n10 + 1);
                    sDKGraphics.drawLine(n9, n10, n9, n10);
                    break;
                }
                case 1: {
                    int n11 = 30;
                    int n12 = 22;
                    sDKGraphics.drawRect(n11, n12, 19, 13);
                    break;
                }
                case 2: {
                    int n13 = 22;
                    int n14 = 17;
                    sDKGraphics.drawRect(n13, n14, 39, 27);
                    break;
                }
                case 3: {
                    int n15 = 12;
                    int n16 = 10;
                    sDKGraphics.drawRect(n15, n16, 57, 39);
                }
            }
            return;
        }
        if (_minimap_state == 3) {
            sDKGraphics.setColor(0xDFDFDF);
            switch (_minimap_timer) {
                case 0: {
                    int n17 = 3;
                    int n18 = 10;
                    sDKGraphics.drawLine(n17, n18, n17 + 78, n18);
                    sDKGraphics.drawLine(n17, n18 - 1, n17 + 78, n18 - 1);
                    n18 = 46;
                    sDKGraphics.drawLine(n17, n18, n17 + 78, n18);
                    sDKGraphics.drawLine(n17, n18 - 1, n17 + 78, n18 - 1);
                    break;
                }
                case 1: {
                    int n19 = 3;
                    int n20 = 22;
                    sDKGraphics.drawLine(n19, n20, n19 + 78, n20);
                    sDKGraphics.drawLine(n19, n20 - 1, n19 + 78, n20 - 1);
                    n20 = 34;
                    sDKGraphics.drawLine(n19, n20, n19 + 78, n20);
                    sDKGraphics.drawLine(n19, n20 - 1, n19 + 78, n20 - 1);
                    break;
                }
                case 2: {
                    int n21 = 3;
                    int n22 = 31;
                    sDKGraphics.drawLine(n21, n22, n21 + 78, n22);
                    break;
                }
                case 3: {
                    int n23 = 22;
                    int n24 = 31;
                    sDKGraphics.drawLine(n23, n24, n23 + 39, n24);
                }
                case 4: 
                case 5: {
                    int n23 = 42;
                    int n24 = 31;
                    sDKGraphics.drawLine(n23 - 2, n24, n23, n24 - 2);
                    sDKGraphics.drawLine(n23 - 1, n24, n23, n24 - 1);
                    sDKGraphics.drawLine(n23 - 2, n24, n23, n24 + 2);
                    sDKGraphics.drawLine(n23 - 1, n24, n23, n24 + 1);
                    sDKGraphics.drawLine(n23 + 2, n24, n23, n24 - 2);
                    sDKGraphics.drawLine(n23 + 1, n24, n23, n24 - 1);
                    sDKGraphics.drawLine(n23 + 2, n24, n23, n24 + 2);
                    sDKGraphics.drawLine(n23 + 1, n24, n23, n24 + 1);
                    sDKGraphics.drawLine(n23, n24, n23, n24);
                }
            }
            return;
        }
        if (_minimap_state == 2) {
            for (int i = 0; i < Utils.random(20); ++i) {
                int n25 = Utils.random(6, 59);
                for (int j = 0; j < Utils.random(1, 4); ++j) {
                    Hud.DrawWhiteLine(sDKGraphics, n25 + j - 2);
                }
            }
            return;
        }
        if (_minimap_state == 4) {
            return;
        }
        for (n6 = 0; n6 < 64; ++n6) {
            if (Level._entities_usage[n6] != 1) continue;
            entity = (Unit)Level._entities[n6];
            if (entity._life <= 0 || (entity._flags & 0x10) != 0 || GameImpl._useFog && entity._allegiance != 0 && !entity._FOW_visible) continue;
            n5 = 3 + entity._pos_x * 78 / Map._map_w;
            n4 = 4 + entity._pos_y * 55 / Map._map_h;
            if (entity._allegiance == 0) {
                if (entity._bSelected) {
                    sDKGraphics.setColor(0xFFFFFF);
                } else {
                    sDKGraphics.setColor(n8);
                }
                if (entity._beacon_time >= 0) {
                    entity._beacon_time = (byte)(entity._beacon_time - 1);
                    entity._cycle = (byte)(entity._cycle + (2 + (_timer & 1)));
                    entity._cycle = (byte)(entity._cycle % 24);
                    if (entity._pos_x > Camera._nCamX && entity._pos_x < Camera._nCamX + GameImpl.SV_W && entity._pos_y > Camera._nCamY && entity._pos_y < Camera._nCamY + GameImpl.SV_H) {
                        entity._noticed = true;
                    }
                    if (!entity._noticed) {
                        sDKGraphics.setColor(n8);
                        n3 = 0;
                        n2 = entity._cycle;
                        int n26 = 2;
                        while (n3 < 4) {
                            n = n2 / 2;
                            for (int i = 0; i < n26 * entity._cycle / 24; ++i) {
                                sDKGraphics.drawLine(n5 - n / 2, n4 - n + i, n5 + n / 2, n4 - n + i);
                                sDKGraphics.drawLine(n5 - n / 2, n4 + n + i, n5 + n / 2, n4 + n + i);
                                sDKGraphics.drawLine(n5 - n + i, n4 - n / 2, n5 - n + i, n4 + n / 2);
                                sDKGraphics.drawLine(n5 + n + i, n4 - n / 2, n5 + n + i, n4 + n / 2);
                            }
                            ++n3;
                            n2 += entity._cycle;
                            n26 += 2;
                        }
                    }
                    if (_timer < 4) {
                        sDKGraphics.setColor(0xFFFFFF);
                    } else {
                        sDKGraphics.setColor(n8);
                    }
                }
                if (entity._beacon_time == -1) {
                    entity._cycle = 0;
                    entity._noticed = false;
                }
            } else if (entity._allegiance == 1) {
                sDKGraphics.setColor(n7);
            } else {
                sDKGraphics.setColor(0xA0A0A0);
            }
            sDKGraphics.fillRect(n5, n4, 2, 2);
        }
        for (n6 = 64; n6 < 160; ++n6) {
            if (Level._entities_usage[n6] != 1) continue;
            entity = (Building)Level._entities[n6];
            if (((Building)entity)._life <= 0 || (entity._flags & 0x10) != 0 || GameImpl._useFog && ((Building)entity)._allegiance != 0 && !((Building)entity)._FOW_visible) continue;
            n5 = 3 + entity._pos_x * 78 / Map._map_w;
            n4 = 4 + entity._pos_y * 55 / Map._map_h;
            if (((Building)entity)._allegiance == 0) {
                sDKGraphics.setColor(n8);
                if (((Building)entity)._beacon_time >= 0) {
                    ((Building)entity)._beacon_time = (byte)(((Building)entity)._beacon_time - 1);
                    ((Building)entity)._cycle = (byte)(((Building)entity)._cycle + _timer % 2);
                    ((Building)entity)._cycle = (byte)(((Building)entity)._cycle % 24);
                    if (entity._pos_x > Camera._nCamX && entity._pos_x < Camera._nCamX + GameImpl.SV_W && entity._pos_y > Camera._nCamY && entity._pos_y < Camera._nCamY + GameImpl.SV_H) {
                        ((Building)entity)._noticed = true;
                    }
                    if (!((Building)entity)._noticed) {
                        n3 = 0;
                        n2 = ((Building)entity)._cycle;
                        while (n3 < 4) {
                            n = n2 / 2;
                            sDKGraphics.drawLine(n5 - n / 2, n4 - n, n5 + n / 2, n4 - n);
                            sDKGraphics.drawLine(n5 - n / 2, n4 + n, n5 + n / 2, n4 + n);
                            sDKGraphics.drawLine(n5 - n, n4 - n / 2, n5 - n, n4 + n / 2);
                            sDKGraphics.drawLine(n5 + n, n4 - n / 2, n5 + n, n4 + n / 2);
                            ++n3;
                            n2 += ((Building)entity)._cycle;
                        }
                    }
                    if (_timer < 4) {
                        sDKGraphics.setColor(0xFFFFFF);
                    } else {
                        sDKGraphics.setColor(n8);
                    }
                }
                if (((Building)entity)._beacon_time == -1) {
                    ((Building)entity)._cycle = 0;
                    ((Building)entity)._noticed = false;
                }
            } else if (((Building)entity)._allegiance == 1) {
                sDKGraphics.setColor(n7);
            } else {
                sDKGraphics.setColor(0xA0A0A0);
            }
            sDKGraphics.fillRect(n5, n4, 3, 3);
        }
        sDKGraphics.setColor(65280);
        sDKGraphics.drawRect(3 + Camera._nCamX * 78 / Map._map_w, 4 + Camera._nCamY * 55 / Map._map_h, GameImpl.SV_W * 78 / Map._map_w - 1, GameImpl.SV_H * 55 / Map._map_h + 0);
    }

    private static void DrawWhiteLine(SDKGraphics sDKGraphics, int n) {
        int n2 = 2;
        int n3 = 6;
        int n4 = 0;
        int n5 = Utils.random(n3);
        int n6 = 3;
        int n7 = Utils.random(2);
        n7 = n7 == 1 ? 0xDFDFDF : 0x202020;
        sDKGraphics.setColor(n7);
        sDKGraphics.drawLine(n6, n, n6 + n5, n);
        n7 ^= 0xFFFFFF;
        n6 += n5;
        while (n6 < 81) {
            n4 = Utils.random(n2, n3);
            sDKGraphics.setColor(n7);
            sDKGraphics.drawLine(n6, n, n6 + n4, n);
            n7 ^= 0xFFFFFF;
            n6 += n4;
        }
        n6 -= n4;
        n4 = 81 - n6;
        sDKGraphics.drawLine(n6, n, n6 + n4, n);
    }

    static void __MINIMAP() {
    }

    private static void Draw_Details(SDKGraphics sDKGraphics) {
        XSprite xSprite = Sprites._sprites[11];
        int n = (GameImpl.SCR_W - 60 - 78) / 78 + 1;
        int n2 = 117;
        int n3 = 1;
        for (int i = 1; i <= n; ++i) {
            xSprite.DrawFrame(1, n2, 0, n3);
            n3 = n3 == 0 ? 1 : 0;
            n2 += 78;
        }
        xSprite.DrawFrame(96, (GameImpl.SCR_W >> 1) - 28, 0, 0);
        SDKUtils.setFont(GameImpl.fonts[4]);
        Utils.DrawNumber(Level._player_money, (GameImpl.SCR_W >> 1) + -5 + 0, 1, 0);
        if (_event_timer > 0) {
            Utils.DrawNumber(_event_timer / 14, (GameImpl.SCR_W >> 1) + -28, 28, 0);
        }
        if (Level._b_tower_defense) {
            SDKUtils.getString(78, GameImpl._string);
            GameImpl._string = GameImpl._string.concat(_wave_no);
            SDKUtils.drawString(GameImpl._string, 90, 35, 0);
        }
        Hud.Draw_Power(sDKGraphics);
    }

    private static void Draw_Power(SDKGraphics sDKGraphics) {
        int n;
        if (!_show_power_lines) {
            return;
        }
        int n2 = Level._player_consumption;
        XSprite xSprite = Sprites._sprites[11];
        int n3 = (int)Utils.Ln(n2);
        int n4 = (int)Utils.Ln(Level._player_power);
        if (Level._buildings_off_times[0][1] > 0) {
            n4 = 0;
        }
        n2 = n3 >> 6;
        int n5 = n2 + (n4 - n3 >> 3);
        if (n2 > 20) {
            n2 = 20;
        }
        if (n5 > 20) {
            n5 = 20;
        }
        if ((n = n5) < n2) {
            n = n2;
        }
        int n6 = (GameImpl.SCR_W >> 1) + -10 + 0;
        int n7 = 22;
        boolean bl = false;
        int n8 = n6;
        int n9 = n6;
        for (int i = 0; i < n; ++i) {
            if (i < n2) {
                xSprite.DrawFrame(28, n6, n7, 0);
                if (Level._player_consumption >= Level._player_power) {
                    n9 = n6;
                }
            } else if (i == n2) {
                xSprite.DrawFrame(30, n6, n7, 0);
                xSprite.DrawFrame(27, n6, n7, 0);
            } else {
                xSprite.DrawFrame(30, n6, n7, 0);
            }
            if (i >= n5 && !bl) {
                n8 = n6;
                bl = true;
            }
            n6 += 5;
        }
        if (!bl) {
            n8 = n6 - 5;
        }
        if (Level._player_consumption >= Level._player_power) {
            n8 = n9;
            xSprite.DrawFrame(28, n8, n7, 0);
        } else {
            xSprite.DrawFrame(30, n8, n7, 0);
            if (n2 == n) {
                xSprite.DrawFrame(27, n8, n7, 0);
            }
        }
    }

    private static void Draw_CommandPoints(SDKGraphics sDKGraphics) {
        XSprite xSprite = Sprites._sprites[11];
        xSprite.DrawFrame(2, GameImpl.SCR_W, 0, 0);
        xSprite.DrawFrame(80, GameImpl.SCR_W + -44, 5, 0);
        xSprite.DrawFrame(81, GameImpl.SCR_W + -44, 21, 0);
        if (Level._player_command_points >= Level._player_max_command_points && GameImpl._frameCounter % 3 == 0) {
            SDKUtils.setFont(GameImpl.fonts[5]);
        }
        Utils.DrawSeparatedNumbers(Level._player_command_points, Level._player_max_command_points, "/", GameImpl.SCR_W + -32, 3, 0, 0);
        if (Level._player_command_points >= Level._player_max_command_points && GameImpl._frameCounter % 3 == 0) {
            SDKUtils.setFont(GameImpl.fonts[4]);
        }
        if (Level._player_build_points >= Level._player_max_build_points && GameImpl._frameCounter % 3 == 0) {
            SDKUtils.setFont(GameImpl.fonts[5]);
        }
        Utils.DrawSeparatedNumbers(Level._player_build_points, Level._player_max_build_points, "/", GameImpl.SCR_W + -32, 19, 0, 0);
        if (Level._player_build_points >= Level._player_max_build_points && GameImpl._frameCounter % 3 == 0) {
            SDKUtils.setFont(GameImpl.fonts[4]);
        }
    }

    static void BUILD__() {
    }

    public static void Build_Update() {
        if (_hud_substate != 5 && _hud_substate != 2 && _hud_substate != 3 && _hud_substate != 4) {
            if (SDKCanvas.isKeyPressed(2052) || (GameImpl._pointerAction & 0x10) != 0) {
                Hud.MoveTab(-1);
                Hud.Build_ChangeSubState(0);
            } else if (SDKCanvas.isKeyPressed(8200)) {
                Hud.MoveTab(1);
                Hud.Build_ChangeSubState(0);
            } else {
                _move_tab = 0;
            }
            if (SDKCanvas.isNewKeyReleased(32) || (GameImpl._pointerAction & 1) != 0) {
                GameImpl._pointerAction = 0;
                Camera.SetState(0);
                Hud.ChangeState(1, true);
                if (_bTutorialOn) {
                    _hud_current_tab = _tutorial_tab;
                }
                return;
            }
        }
        byte[] byArray = _hud_build_items_available[_hud_current_tab];
        switch (_hud_substate) {
            case 0: {
                if (SDKCanvas.isNewKeyReleased(513) || (GameImpl._pointerAction & 4) != 0) {
                    GameImpl._pointerAction = 0;
                    SDKCanvas.disableInput(1);
                    Hud.MoveCursor(_hud_current_tab, -1);
                    break;
                }
                if (SDKCanvas.isNewKeyReleased(32770) || (GameImpl._pointerAction & 8) != 0) {
                    GameImpl._pointerAction = 0;
                    SDKCanvas.disableInput(1);
                    Hud.MoveCursor(_hud_current_tab, 1);
                    break;
                }
                if (!SDKCanvas.isNewKeyReleased(4112) && (GameImpl._pointerAction & 0x40) == 0) break;
                GameImpl._pointerAction = 0;
                SDKCanvas.disableInput(1);
                if (_hud_build_cursor_pos[_hud_current_tab] == -1 || byArray[_hud_build_cursor_pos[_hud_current_tab]] >= 50) break;
                if (_hud_current_tab == 0) {
                    if (Level._player_build_points == Level._player_max_build_points && byArray[_hud_build_cursor_pos[_hud_current_tab]] != 12) {
                        return;
                    }
                    if (byArray[_hud_build_cursor_pos[_hud_current_tab]] == 12) {
                        Hud.Build_ChangeSubState(5);
                        break;
                    }
                    int n = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
                    int n2 = Level.GetBuildingStats(Level._player_faction, n, 15);
                    if (n2 > Level._player_money) break;
                    _hud_building = n;
                    Hud.Build_ChangeSubState(2);
                    break;
                }
                if (_hud_current_tab == 1) {
                    if (Level._player_command_points == Level._player_max_command_points) {
                        return;
                    }
                    if (!Level.HasPower(0)) break;
                    Hud.Build_ChangeSubState(1);
                    break;
                }
                if (_hud_current_tab != 2 || _sw_cooldown[byArray[_hud_build_cursor_pos[_hud_current_tab]]] != 0 || !Level.HasPower(0)) break;
                _hud_sw = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
                Hud.Build_ChangeSubState(3);
                break;
            }
            case 1: {
                int n;
                int n3;
                if (--_hud_timer == 0 && (n3 = Level.Group_GetLeader(_hud_current_squad)) != -1) {
                    Camera.DoFollowEntity(n3);
                }
                n3 = -1;
                for (n = 0; n < 8; ++n) {
                    int n4;
                    if (Tutorial._tutorials[n][0] != 1 || (n4 = Tutorial._tutorials[n][1]) != 5) continue;
                    int n5 = Tutorial._tutorials[n][8];
                    int n6 = Tutorial._tutorials[n][6];
                    if (n6 != _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]] || n5 <= 0) continue;
                    n3 = n5;
                }
                if (n3 >= 0) {
                    _hud_current_squad = n3;
                }
                if (SDKCanvas.isNewKeyReleased(513)) {
                    if (_hud_current_squad > 1) {
                        --_hud_current_squad;
                    }
                    _hud_timer = 14;
                    if (n3 < 0) break;
                    _hud_current_squad = n3;
                    break;
                }
                if (SDKCanvas.isNewKeyReleased(32770)) {
                    n = 2;
                    if (_hud_current_squad < n) {
                        ++_hud_current_squad;
                    }
                    if (n3 >= 0) {
                        _hud_current_squad = n3;
                    }
                    _hud_timer = 14;
                    break;
                }
                if (!SDKCanvas.isNewKeyReleased(4112) && (GameImpl._pointerAction & 0x40) == 0) break;
                GameImpl._pointerAction = 0;
                if (n3 >= 0) {
                    _hud_current_squad = n3;
                }
                Hud.Build_Unit();
                Hud.Build_ChangeSubState(0);
                SDKCanvas.disableInput(1);
                break;
            }
            case 2: {
                if (_hud_building == 2) {
                    Entity entity = Level.FindClosestMineralField(Cursor._nCursorPosX, Cursor._nCursorPosY, 64);
                    if (entity != null) {
                        _refinery_snap = true;
                        _snap_x = entity._pos_x;
                        _snap_y = entity._pos_y + 1;
                        if (!Hud.Build_IsValidBuildingPosition(_snap_x, _snap_y)) {
                            _refinery_snap = false;
                        }
                    } else {
                        _refinery_snap = false;
                    }
                }
                if (SDKCanvas.isNewKeyReleased(32) || (GameImpl._pointerAction & 1) != 0) {
                    GameImpl._pointerAction = 0;
                    Hud.Build_ChangeSubState(0);
                    return;
                }
                if (SDKCanvas.isNewKeyReleased(4112) || (GameImpl._pointerAction & 0x80) != 0) {
                    GameImpl._pointerAction = 0;
                    if (Hud.Build_Building()) {
                        Hud.Build_ChangeSubState(0);
                    }
                    SDKCanvas.disableInput(1);
                }
                Cursor.UpdateCursorMovement();
                break;
            }
            case 3: {
                if (SDKCanvas.isNewKeyReleased(32) || (GameImpl._pointerAction & 1) != 0) {
                    GameImpl._pointerAction = 0;
                    Hud.Build_ChangeSubState(0);
                    return;
                }
                if (SDKCanvas.isNewKeyReleased(4112) || (GameImpl._pointerAction & 0x80) != 0) {
                    GameImpl._pointerAction = 0;
                    if (Cursor.GetCursorAction() == 2) break;
                    boolean bl = false;
                    switch (_hud_sw) {
                        case 0: {
                            Level.DropNuke(0, Cursor._nCursorPosX, Cursor._nCursorPosY);
                            break;
                        }
                        case 1: {
                            Level.DropKirov(0, Cursor._nCursorPosX, Cursor._nCursorPosY);
                            break;
                        }
                        case 2: {
                            Level.DropIronCurtain(0, Cursor._nCursorPosX, Cursor._nCursorPosY);
                            break;
                        }
                        case 3: {
                            Level.DropHarrier(0, Cursor._nCursorPosX, Cursor._nCursorPosY);
                            break;
                        }
                        case 4: {
                            Level.SWChrono_MarkUnits(Cursor._nCursorPosX, Cursor._nCursorPosY);
                            Hud.Build_ChangeSubState(4);
                            bl = true;
                            break;
                        }
                        case 5: {
                            Level.DropStorm(0, Cursor._nCursorPosX, Cursor._nCursorPosY);
                        }
                    }
                    SDKCanvas.disableInput(2);
                    if (!bl) {
                        Hud.ChangeState(1, true);
                    }
                }
                Cursor.UpdateCursorMovement();
                break;
            }
            case 4: {
                if (SDKCanvas.isNewKeyReleased(32) || (GameImpl._pointerAction & 1) != 0) {
                    GameImpl._pointerAction = 0;
                    Hud.Build_ChangeSubState(0);
                    switch (_hud_sw) {
                        case 4: {
                            Level.SWChrono_Cancel();
                        }
                    }
                    return;
                }
                if (SDKCanvas.isNewKeyReleased(4112) || (GameImpl._pointerAction & 0x80) != 0) {
                    GameImpl._pointerAction = 0;
                    switch (_hud_sw) {
                        case 4: {
                            if (Cursor.GetCursorAction() == 2) break;
                            Level.SWChrono_TeleportUnits(Cursor._nCursorPosX, Cursor._nCursorPosY);
                            Encyclopedia.SetBeam();
                        }
                    }
                    Hud.ChangeState(1, true);
                }
                Cursor.UpdateCursorMovement();
                break;
            }
            case 5: {
                if (SDKCanvas.isNewKeyReleased(32) || (GameImpl._pointerAction & 1) != 0) {
                    GameImpl._pointerAction = 0;
                    Hud.Build_ChangeSubState(0);
                    return;
                }
                if (SDKCanvas.isNewKeyReleased(4112) || (GameImpl._pointerAction & 0x80) != 0) {
                    GameImpl._pointerAction = 0;
                    Entity entity = Level.GetEntitySafe(Cursor._targetPointer);
                    if (entity != null && entity._type == 6) {
                        Building building = (Building)entity;
                        if (building._subtype != 0 && building._allegiance == 0) {
                            building.SellBuilding();
                        }
                    }
                }
                Cursor.UpdateCursorMovement();
                Cursor.UpdateCursorTargetPointer();
            }
        }
    }

    public static void Build_ChangeSubState(int n) {
        if (_hud_substate == n) {
            return;
        }
        if (_hud_substate == 2) {
            Camera.SetState(0);
        } else if (_hud_substate == 1) {
            Camera.DoScroll(_old_camera_x, _old_camera_y);
        } else if (_hud_substate == 4 && _hud_sw == 4) {
            Level.SWChrono_Cancel();
        }
        switch (n) {
            case 0: {
                Hud.RefreshBuildMenuItems();
                break;
            }
            case 2: {
                Cursor._nCursorPosX = Camera._nCamX + (GameImpl.SV_W >> 1);
                Cursor._nCursorPosY = Camera._nCamY + (GameImpl.SV_H >> 1);
                int n2 = 0;
                if (Level._player_faction == 1) {
                    n2 = 10;
                }
                _hud_building_cmap = Level.GetCMap(n2 + _hud_building);
                _hud_building_offx = Level.GetCMapHeaderData(n2 + _hud_building, 0);
                _hud_building_offy = Level.GetCMapHeaderData(n2 + _hud_building, 1);
                _hud_building_tw = Level.GetCMapHeaderData(n2 + _hud_building, 2);
                _hud_building_th = Level.GetCMapHeaderData(n2 + _hud_building, 3);
                break;
            }
            case 1: {
                byte by = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
                int n3 = Level.GetUnitStats(by, 10);
                if (n3 > Level._player_money) {
                    return;
                }
                _hud_timer = 14;
                break;
            }
            case 3: {
                break;
            }
        }
        _hud_substate = n;
    }

    public static void Build_Draw(SDKGraphics sDKGraphics) {
        XSprite xSprite = Sprites._sprites[11];
        switch (_hud_substate) {
            case 0: {
                xSprite.DrawFrame(3, GameImpl.SCR_W, 0, 0);
                Hud.Build_Draw_Tabs(sDKGraphics, _hud_current_tab, true);
                Hud.Build_Draw_Slots(sDKGraphics, _hud_current_tab, true);
                Hud.Build_Draw_Slots_Tooltip(sDKGraphics, _hud_current_tab);
                break;
            }
            case 1: {
                xSprite.DrawFrame(3, GameImpl.SCR_W, 0, 0);
                Hud.Build_Draw_Tabs(sDKGraphics, _hud_current_tab, true);
                Hud.Build_Draw_Slots(sDKGraphics, _hud_current_tab, false);
                Hud.Build_Draw_SquadSel(sDKGraphics);
                break;
            }
            case 2: {
                Hud.Build_Draw_CreepOverlay(sDKGraphics);
                Hud.Build_Draw_Overlay(sDKGraphics);
                Hud.Build_Draw_Range(sDKGraphics, _hud_building, Cursor._nCursorPosX - Camera._nCamX + GameImpl.SV_X, Cursor._nCursorPosY - Camera._nCamY + GameImpl.SV_Y);
                Hud.Play_Draw_SuperWeapon_Cooldown(sDKGraphics);
                _refinery_snap = false;
                break;
            }
            case 3: {
                Hud.Build_Draw_SW_TargetSelection(sDKGraphics, 3);
                Hud.Play_Draw_SuperWeapon_Cooldown(sDKGraphics);
                break;
            }
            case 4: {
                Hud.Build_Draw_SW_TargetSelection(sDKGraphics, 4);
                break;
            }
            case 5: {
                Hud.Build_Draw_SW_TargetSelection(sDKGraphics, 5);
            }
        }
        Hud.Draw_Details(sDKGraphics);
        Hud.Draw_MiniMap(sDKGraphics);
        Hud.Draw_CommandPoints(sDKGraphics);
        Hud.DrawSoftKeys(SDKUtils.getString(6, Utils._temp_string), true, 4, true, _blink_RSK);
    }

    public static void Build_Draw_Range(SDKGraphics sDKGraphics, int n, int n2, int n3) {
        if (n == 6 || n == 5) {
            int n4 = Level.GetBuildingStats(Level._player_faction, n, 10);
            if (Level._b_tower_defense) {
                n4 <<= 1;
            }
            n4 *= 3;
            int n5 = 65280;
            sDKGraphics.setColor(n5);
            sDKGraphics.drawArc(n2 - ((n4 >>= 2) + (n4 >> 2)), n3 - (n4 + (n4 >> 2)), (n4 >> 1) + (n4 << 1), (n4 >> 1) + (n4 << 1), 0, 360);
        }
    }

    private static void Build_Draw_Tabs(SDKGraphics sDKGraphics, int n, boolean bl) {
        XSprite xSprite = Sprites._sprites[11];
        xSprite.DrawFrame(111 + n, GameImpl.HUD_BUILD_POSX, 58, 0);
        xSprite.DrawFrame(106, GameImpl.HUD_BUILD_NEXT_TAB_POSX, 52, 0);
        xSprite.DrawFrame(9 + (n - 1 + 3) % 3, GameImpl.HUD_BUILD_NEXT_TAB_POSX, 58, 0);
    }

    private static void Build_Draw_Slots(SDKGraphics sDKGraphics, int n, boolean bl) {
        XSprite xSprite = Sprites._sprites[11];
        XSprite xSprite2 = null;
        XSprite xSprite3 = Sprites._sprites[13];
        xSprite2 = Level._player_faction == 0 ? Sprites._sprites[29] : Sprites._sprites[30];
        byte by = _hud_build_cursor_pos[n];
        int n2 = _hud_build_page_pos[n];
        byte[] byArray = _hud_build_items_available[n];
        byte by2 = _hud_nr_items_available[n];
        int n3 = 150;
        int n4 = 0;
        if (n == 0) {
            n4 = 16;
        } else if (n == 1) {
            n4 = 1;
        } else if (n == 2) {
            n4 = 26;
        }
        for (int i = n2; i < n2 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS; ++i) {
            if (i < by2 && i != by) {
                if (byArray[i] == 12 && n == 0) {
                    xSprite3.DrawFrame(54, GameImpl.HUD_BUILD_SLOT_OFF_POSX, n3, 0);
                } else if (byArray[i] >= 50) {
                    xSprite2.DrawFrame(n4 + byArray[i] - 50, GameImpl.HUD_BUILD_SLOT_OFF_POSX, n3, 0);
                    Utils.FillRect(sDKGraphics, -1073741824, GameImpl.HUD_BUILD_SLOT_OFF_POSX - 19, n3 - 19, 38, 38);
                } else {
                    xSprite2.DrawFrame(n4 + byArray[i], GameImpl.HUD_BUILD_SLOT_OFF_POSX, n3, 0);
                }
            }
            n3 += 39;
        }
        if (by != -1) {
            n3 = 150 + (by - n2) * 39;
            if (byArray[by] == 12 && n == 0) {
                xSprite3.DrawFrame(54, GameImpl.HUD_BUILD_SLOT_ON_POSX, n3, 0);
            } else if (byArray[by] >= 50) {
                xSprite2.DrawFrame(n4 + byArray[by] - 50, GameImpl.HUD_BUILD_SLOT_ON_POSX, n3, 0);
                Utils.FillRect(sDKGraphics, -1073741824, GameImpl.HUD_BUILD_SLOT_ON_POSX - 19, n3 - 19, 38, 38);
            } else {
                xSprite2.DrawFrame(n4 + byArray[by], GameImpl.HUD_BUILD_SLOT_ON_POSX, n3, 0);
            }
        }
        if (bl) {
            xSprite.DrawFrame(110, GameImpl.HUD_BUILD_ARROWS_POSX, 86, 0);
            xSprite.DrawFrame(109, GameImpl.HUD_BUILD_ARROWS_POSX, GameImpl.HUD_BUILD_SLOT_BOTTOM_ARROW_POSY, 0);
        }
    }

    private static void Build_Draw_Slots_Tooltip(SDKGraphics sDKGraphics, int n) {
        XSprite xSprite = Sprites._sprites[11];
        byte by = _hud_build_cursor_pos[n];
        byte by2 = _hud_build_page_pos[n];
        byte[] byArray = _hud_build_items_available[n];
        int n2 = 0;
        if (by != -1) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = 150 + (by - by2) * 39;
            int n10 = 0;
            int n11 = 0;
            int n12 = n8 = byArray[by] < 50 ? byArray[by] : byArray[by] - 50;
            if (n == 1) {
                switch (n8) {
                    case 0: 
                    case 7: 
                    case 10: 
                    case 12: {
                        n2 = 123;
                        break;
                    }
                    case 4: {
                        n2 = 135;
                        break;
                    }
                    case 2: 
                    case 9: {
                        n2 = 124;
                        break;
                    }
                    case 8: 
                    case 11: {
                        n2 = 125;
                        break;
                    }
                    case 13: {
                        n2 = 127;
                        break;
                    }
                    case 3: {
                        n2 = 128;
                        break;
                    }
                    case 1: {
                        n2 = 129;
                        break;
                    }
                    case 14: {
                        n2 = 126;
                    }
                }
            }
            if (byArray[by] >= 50) {
                n7 = 0;
                n6 = 0;
                switch (n) {
                    case 0: {
                        n10 = 42 + Level._player_faction * 10;
                        n7 = Level.GetBuildingStats(Level._player_faction, n8, 3);
                        break;
                    }
                    case 1: {
                        n10 = 27;
                        n7 = Level.GetUnitStats(n8, 24);
                        break;
                    }
                    case 2: {
                        n10 = 65;
                        n7 = Level.GetSWStats(n8, 1);
                    }
                }
                if (_tooltip_old_name != n10 + n8) {
                    SDKUtils.getString(n10 + n8, _tooltip_name_string);
                    _tooltip_old_name = n10 + n8;
                }
                _tooltip_cost_string = SDKUtils.getString(75, _tooltip_cost_string);
                while (n7 != 0) {
                    if ((n7 & 1) != 0 && Level.GetEntityNo(6, n6, 0) == 0) {
                        GameImpl._string = SDKUtils.getString(42 + Level._player_faction * 10 + n6, GameImpl._string);
                    }
                    ++n6;
                    n7 >>= 1;
                }
                SDKUtils.setFont(GameImpl.fonts[5]);
                _tooltip_cost_string = _tooltip_cost_string.concat(GameImpl._string);
                SDKUtils.getString(n2, _tooltip_descr_string);
            } else {
                if (n == 2) {
                    int n13 = GameImpl.HUD_BUILD_POSX - 30 - 13;
                    n10 = 65;
                    n11 = -1;
                    if (_tooltip_old_name != n10 + n8) {
                        SDKUtils.getString(n10 + n8, _tooltip_name_string);
                        _tooltip_old_name = n10 + n8;
                    }
                    if (_sw_cooldown[n8] / 14 != 0) {
                        SDKUtils.setFont(GameImpl.fonts[5]);
                    } else {
                        SDKUtils.setFont(GameImpl.fonts[4]);
                    }
                    int n14 = SDKUtils.getStringSize(_tooltip_name_string) + 10;
                    int n15 = n14 - 25 - 26;
                    if (n15 < 0) {
                        n15 = 0;
                    }
                    n15 = n15 / 16 + 1;
                    n14 = 51 + n15 * 16;
                    int n16 = GameImpl.HUD_BUILD_POSX - 30 - n14;
                    int n17 = n9 - SDKUtils.getLineSize() / 2;
                    int n18 = n16 + 25;
                    xSprite.DrawFrame(57, n18, n9, 0);
                    n18 += 8;
                    for (int i = 0; i < n15; ++i) {
                        xSprite.DrawFrame(58, n18, n9, 0);
                        n18 += 16;
                    }
                    xSprite.DrawFrame(59, n18 -= 8, n9, 0);
                    if (SDKUtils.getStringSize(_tooltip_name_string) >= n13) {
                        SDKUtils.wrapString(_tooltip_name_string, Menu._outro_lines, n13, (short)124);
                        SDKUtils.drawWrappedString(_tooltip_name_string, Menu._outro_lines, 1, Menu._outro_lines[0], n16 + n14 / 2 + 0, n17 - SDKUtils.getLineSize() / 2, 1);
                    } else {
                        SDKUtils.drawString(_tooltip_name_string, n16 + n14 / 2 + 0, n17, 1);
                    }
                    SDKUtils.setFont(GameImpl.fonts[4]);
                    return;
                }
                if (n == 0) {
                    if (byArray[by] == 12) {
                        n10 = 77 - n8;
                        n11 = -1;
                    } else {
                        n10 = 42 + Level._player_faction * 10;
                        n11 = Level.GetBuildingStats(Level._player_faction, n8, 15);
                    }
                } else if (n == 1) {
                    n10 = 27;
                    n11 = Level.GetUnitStats(n8, 10);
                }
                if (_tooltip_old_name != n10 + n8) {
                    SDKUtils.getString(n10 + n8, _tooltip_name_string);
                    SDKUtils.getString(76, _tooltip_cost_string);
                    _tooltip_cost_string = Utils.ConcatNumber(_tooltip_cost_string, n11, 0);
                    _tooltip_old_name = n10 + n8;
                    if (n == 1) {
                        SDKUtils.getString(n2, _tooltip_descr_string);
                    }
                }
                if (n11 > Level._player_money || !Level.HasPower(0) && n != 0) {
                    SDKUtils.setFont(GameImpl.fonts[5]);
                } else {
                    SDKUtils.setFont(GameImpl.fonts[4]);
                }
            }
            n7 = SDKUtils.getStringSize(_tooltip_name_string);
            n6 = SDKUtils.getStringSize(_tooltip_cost_string);
            int n19 = SDKUtils.getStringSize(_tooltip_descr_string);
            int n20 = n5 = n7 > n6 ? n7 : n6;
            if (n == 1) {
                int n21 = n5 = n5 > n19 ? n5 : n19;
            }
            if (n5 > GameImpl.HUD_BUILD_POSX - 30 - 25) {
                n5 = GameImpl.HUD_BUILD_POSX - 30 - 25;
            }
            if ((n4 = (n3 = n5 + 10) - 25 - 26) < 0) {
                n4 = 0;
            }
            n4 = n4 / 16 + 1;
            n3 = 51 + n4 * 16;
            int n22 = GameImpl.HUD_BUILD_POSX - 30 - n3;
            int n23 = n11 < 0 ? n9 - SDKUtils.getLineSize() / 2 : n9 - SDKUtils.getLineSize();
            int n24 = 57;
            int n25 = 58;
            int n26 = 59;
            int n27 = GameImpl.HUD_BUILD_POSX - 30 - 13;
            if (n7 > n27 || n6 > n27 || n19 > n27) {
                n24 = 97;
                n25 = 98;
                n26 = 99;
                if (n7 > n27 && n6 > n27 || n7 > n27 && n19 > n27 || n6 > n27 && n19 > n27) {
                    n24 = 100;
                    n25 = 101;
                    n26 = 102;
                }
            }
            int n28 = n22 + 25;
            xSprite.DrawFrame(n24, n28, n9, 0);
            n28 += 8;
            for (int i = 0; i < n4; ++i) {
                xSprite.DrawFrame(n25, n28, n9, 0);
                n28 += 16;
            }
            xSprite.DrawFrame(n26, n28 -= 8, n9, 0);
            int n29 = 1;
            int n30 = SDKUtils.getLineSize() - 0;
            if (n == 1) {
                n23 -= n30 >> 1;
                n29 = 2;
            }
            if (n7 > n27 && n6 > n27 || n7 > n27 && n19 > n27 || n6 > n27 && n19 > n27) {
                n23 -= n30;
            }
            if (n7 > n27) {
                SDKUtils.wrapString(_tooltip_name_string, Menu._outro_lines, n27, (short)124);
                if (n != 1) {
                    n23 -= n30 >> 1;
                }
                SDKUtils.drawWrappedString(_tooltip_name_string, Menu._outro_lines, 1, Menu._outro_lines[0], n22 + n3 / 2 + 0, n23, 1);
                n23 += n30;
            } else {
                SDKUtils.drawString(_tooltip_name_string, n22 + n3 / 2 + 0, n23, 1);
            }
            if (n11 >= 0) {
                if (n6 > n27) {
                    SDKUtils.wrapString(_tooltip_cost_string, Menu._outro_lines, n27, (short)124);
                    if (n19 > n27) {
                        n23 += n30;
                    }
                    SDKUtils.drawWrappedString(_tooltip_cost_string, Menu._outro_lines, 1, Menu._outro_lines[0], n22 + n3 / 2 + 0, n23 + n29 * n30, 1);
                    if (n19 > n27) {
                        n23 -= n30;
                    }
                } else {
                    if (n19 > n27) {
                        n23 += n30;
                    }
                    SDKUtils.drawString(_tooltip_cost_string, n22 + n3 / 2 + 0, n23 + n29 * n30, 1);
                    if (n19 > n27) {
                        n23 -= n30;
                    }
                }
                if (n == 1) {
                    if (n19 > n27) {
                        SDKUtils.wrapString(_tooltip_descr_string, Menu._outro_lines, n27, (short)124);
                        SDKUtils.drawWrappedString(_tooltip_descr_string, Menu._outro_lines, 1, Menu._outro_lines[0], n22 + n3 / 2 + 0, n23 + n30, 1);
                    } else {
                        SDKUtils.drawString(_tooltip_descr_string, n22 + n3 / 2 + 0, n23 + n30, 1);
                    }
                }
                SDKUtils.setFont(GameImpl.fonts[4]);
            }
        }
    }

    private static void Build_Draw_SquadSel(SDKGraphics sDKGraphics) {
        byte by = _hud_build_cursor_pos[_hud_current_tab];
        byte by2 = _hud_build_page_pos[_hud_current_tab];
        int n = 150 + (by - by2) * 39;
        Hud.Draw_SquadSel(GameImpl.HUD_BUILD_SQUADS_POSX, n, _hud_current_squad, sDKGraphics);
    }

    private static void Draw_SquadSel(int n, int n2, int n3, SDKGraphics sDKGraphics) {
        int n4;
        drawSquadSelX = n;
        drawSquadSelY = n2;
        XSprite xSprite = Sprites._sprites[11];
        int n5 = n4 = n2 - 24 + 12;
        int n6 = 1;
        while (n6 < 3) {
            if (n6 != n3) {
                xSprite.DrawFrame(18 + n6 * 2, n, n5, 0);
                Utils.FillRect(sDKGraphics, -1728053248, n - 13, n5 - 6, 26, 12);
            }
            ++n6;
            n5 += 24;
        }
        n6 = n4 + (n3 - 1) * 24;
        xSprite.DrawFrame(18 + n3 * 2 + 1, n, n6, 0);
    }

    private static void Build_Draw_CreepOverlay(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(65280);
        int n = 1;
        if (_hud_building == 2) {
            n = 6;
        }
        for (int i = 1; i < Map._coll_map_th - 1; ++i) {
            for (int j = 1; j < Map._coll_map_tw - 1; ++j) {
                try {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    byte by = Map._map[(i / 4 * Map._map_tw + j / 4 << 1) + 1];
                    if ((Map._coll_map[i * Map._coll_map_tw + j] & 0x7F) != n || (by & 8) == 0 && _hud_building == 2) continue;
                    boolean bl = true;
                    int n6 = Map._coll_map[i * Map._coll_map_tw + (j - 1)] & 0x7F;
                    if (n6 != n && n6 != 12) {
                        n5 = j * 8;
                        n4 = i * 8;
                        n3 = j * 8;
                        n2 = (i + 1) * 8;
                        sDKGraphics.drawLine(n5 - Camera._nCamX + GameImpl.SV_X, n4 - Camera._nCamY + GameImpl.SV_Y, n3 - Camera._nCamX + GameImpl.SV_X, n2 - Camera._nCamY + GameImpl.SV_Y);
                        if (bl) {
                            Utils.FillRect(sDKGraphics, 0x6600CC00, j * 8 - Camera._nCamX + GameImpl.SV_X, i * 8 - Camera._nCamY + GameImpl.SV_Y, 8, 8);
                            bl = false;
                        }
                    }
                    if ((n6 = Map._coll_map[i * Map._coll_map_tw + (j + 1)] & 0x7F) != n && n6 != 12) {
                        n5 = (j + 1) * 8;
                        n4 = i * 8;
                        n3 = (j + 1) * 8;
                        n2 = (i + 1) * 8;
                        sDKGraphics.drawLine(n5 - Camera._nCamX + GameImpl.SV_X, n4 - Camera._nCamY + GameImpl.SV_Y, n3 - Camera._nCamX + GameImpl.SV_X, n2 - Camera._nCamY + GameImpl.SV_Y);
                        if (bl) {
                            Utils.FillRect(sDKGraphics, 0x6600CC00, j * 8 - Camera._nCamX + GameImpl.SV_X, i * 8 - Camera._nCamY + GameImpl.SV_Y, 8, 8);
                            bl = false;
                        }
                    }
                    if ((n6 = Map._coll_map[(i - 1) * Map._coll_map_tw + j] & 0x7F) != n && n6 != 12) {
                        n5 = j * 8;
                        n4 = i * 8;
                        n3 = (j + 1) * 8;
                        n2 = i * 8;
                        sDKGraphics.drawLine(n5 - Camera._nCamX + GameImpl.SV_X, n4 - Camera._nCamY + GameImpl.SV_Y, n3 - Camera._nCamX + GameImpl.SV_X, n2 - Camera._nCamY + GameImpl.SV_Y);
                        if (bl) {
                            Utils.FillRect(sDKGraphics, 0x6600CC00, j * 8 - Camera._nCamX + GameImpl.SV_X, i * 8 - Camera._nCamY + GameImpl.SV_Y, 8, 8);
                            bl = false;
                        }
                    }
                    if ((n6 = Map._coll_map[(i + 1) * Map._coll_map_tw + j] & 0x7F) == n || n6 == 12) continue;
                    n5 = j * 8;
                    n4 = (i + 1) * 8;
                    n3 = (j + 1) * 8;
                    n2 = (i + 1) * 8;
                    sDKGraphics.drawLine(n5 - Camera._nCamX + GameImpl.SV_X, n4 - Camera._nCamY + GameImpl.SV_Y, n3 - Camera._nCamX + GameImpl.SV_X, n2 - Camera._nCamY + GameImpl.SV_Y);
                    if (!bl) continue;
                    Utils.FillRect(sDKGraphics, 0x6600CC00, j * 8 - Camera._nCamX + GameImpl.SV_X, i * 8 - Camera._nCamY + GameImpl.SV_Y, 8, 8);
                    bl = false;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void Build_Draw_Overlay(SDKGraphics sDKGraphics) {
        int n = Cursor._nCursorPosX;
        int n2 = Cursor._nCursorPosY;
        if (_refinery_snap) {
            n = _snap_x;
            n2 = _snap_y;
        }
        int n3 = (n + _hud_building_offx) / 8;
        int n4 = (n2 + _hud_building_offy) / 8;
        int n5 = n3 * 8;
        int n6 = n4 * 8;
        int n7 = 0;
        int n8 = 0;
        int n9 = 65280;
        if (!Hud.Build_IsValidBuildingPosition(n, n2)) {
            n9 = 0xFF0000;
        }
        sDKGraphics.setColor(n9);
        int n10 = 0;
        while (n10 < _hud_building_th) {
            n7 = n5;
            int n11 = 0;
            while (n11 < _hud_building_tw) {
                if (_hud_building_cmap[n8] > 4) {
                    for (int i = n7 - 8; i <= n7 + 8; i += 8) {
                        for (int j = n6 - 8; j <= n6 + 8; j += 8) {
                            sDKGraphics.fillRect(i - Camera._nCamX + GameImpl.SV_X, j - Camera._nCamY + GameImpl.SV_Y, 8, 8);
                        }
                    }
                }
                ++n11;
                n7 += 8;
                ++n8;
            }
            ++n10;
            n6 += 8;
        }
    }

    private static void Build_Draw_SW_TargetSelection(SDKGraphics sDKGraphics, int n) {
        Cursor.DrawCursor(sDKGraphics);
        if (Cursor.GetCursorAction() == 2) {
            return;
        }
        if (n == 3) {
            switch (_hud_sw) {
                case 0: {
                    sDKGraphics.setColor(0xFF0000);
                    int n2 = Level.GetSWStats(0, 4);
                    n2 *= 3;
                    sDKGraphics.drawArc(GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX - (n2 >>= 2), GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY - n2, n2 << 1, n2 << 1, 0, 360);
                    break;
                }
                case 1: {
                    int n3 = Cursor._nCursorPosX / (Map._map_w >> 1) * Map._map_w;
                    int n4 = Cursor._nCursorPosY / (Map._map_h >> 1) * Map._map_h;
                    int n5 = Utils.GetOrientation2(Cursor._nCursorPosX - n3, Cursor._nCursorPosY - n4, 0);
                    int n6 = 0;
                    int n7 = -1;
                    XSprite xSprite = Sprites._sprites[13];
                    switch (n5) {
                        case 0: {
                            if (Cursor._nCursorPosX > n3) {
                                n5 = 15;
                                break;
                            }
                            n5 = 1;
                            break;
                        }
                        case 4: {
                            if (Cursor._nCursorPosY > n4) {
                                n5 = 3;
                                break;
                            }
                            n5 = 5;
                            break;
                        }
                        case 8: {
                            if (Cursor._nCursorPosX >= n3) {
                                n5 = 9;
                                break;
                            }
                            n5 = 7;
                            break;
                        }
                        case 12: {
                            n5 = Cursor._nCursorPosY > n4 ? 13 : 11;
                        }
                    }
                    if (n5 > 8) {
                        n5 = 16 - n5;
                        n6 = 1;
                    }
                    if (_crt_anim != (n7 = 22 + n5)) {
                        _crt_anim = n7;
                        _crt_aframe = 0;
                        _crt_aframe_time = xSprite.GetAnimFrameTime(_crt_anim, _crt_aframe);
                    } else {
                        --_crt_aframe_time;
                    }
                    if (_crt_aframe_time <= 0) {
                        if (++_crt_aframe >= xSprite.GetAnimLength(_crt_anim)) {
                            _crt_aframe = 0;
                        }
                        _crt_aframe_time = xSprite.GetAnimFrameTime(_crt_anim, _crt_aframe);
                    }
                    xSprite.DrawAnimFrame(_crt_anim, _crt_aframe, Cursor._nCursorPosX - Camera._nCamX + GameImpl.SV_X, Cursor._nCursorPosY - Camera._nCamY + GameImpl.SV_Y, n6);
                    break;
                }
                case 2: {
                    int n8 = Level.GetSWStats(2, 4);
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.drawArc(GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX - n8, GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY - n8, n8 << 1, n8 << 1, 0, 360);
                    break;
                }
                case 3: {
                    sDKGraphics.setColor(0xFF0000);
                    sDKGraphics.drawArc(GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX - 60, GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY - 60, 120, 120, 0, 360);
                    break;
                }
                case 4: {
                    int n9 = Level.GetSWStats(4, 3);
                    sDKGraphics.setColor(0xFFFFFF);
                    sDKGraphics.drawArc(GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX - n9, GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY - n9, n9 << 1, n9 << 1, 0, 360);
                    break;
                }
                case 5: {
                    sDKGraphics.setColor(0xFF0000);
                    int n10 = Level.GetSWStats(5, 4);
                    n10 *= 3;
                    sDKGraphics.drawArc(GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX - (n10 >>= 2), GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY - n10, n10 << 1, n10 * 3 / 2, 0, 360);
                }
            }
        }
    }

    private static void Build_Unit() {
        byte by = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
        int n = Level.GetUnitStats(by, 10);
        if (n > Level._player_money || Level._player_command_points >= Level._player_max_command_points) {
            return;
        }
        Building building = Level.FindSpawnBuilding(by, 0);
        if (Level._buildings_off_times[building._allegiance][building._subtype] > 0) {
            return;
        }
        if (building != null) {
            building.SpawnNewUnit(by);
        }
    }

    private static boolean Build_IsValidBuildingPosition(int n, int n2) {
        int n3 = (n + _hud_building_offx) / 8;
        int n4 = (n2 + _hud_building_offy) / 8;
        int n5 = n3 * 8;
        int n6 = n4 * 8;
        int n7 = 0;
        int n8 = 0;
        if (_hud_building == 2) {
            int n9 = 6;
            int n10 = 0;
            while (n10 < _hud_building_th) {
                n7 = n5;
                int n11 = 0;
                while (n11 < _hud_building_tw) {
                    if (_hud_building_cmap[n8] == 12) {
                        if (Map.GetCollisionAtTile(n3 + n11, n4 + n10) != n9) {
                            return false;
                        }
                        byte by = Map._map[((n4 + n10) / 4 * Map._map_tw + (n3 + n11) / 4 << 1) + 1];
                        if ((by & 8) == 0 && _hud_building == 2) {
                            return false;
                        }
                    }
                    ++n11;
                    n7 += 8;
                    ++n8;
                }
                ++n10;
                n6 += 8;
            }
        } else {
            int n12 = 1;
            int n13 = 0;
            while (n13 < _hud_building_th) {
                n7 = n5;
                int n14 = 0;
                while (n14 < _hud_building_tw) {
                    if (_hud_building_cmap[n8] == 12) {
                        for (int i = -1; i <= 1; ++i) {
                            for (int j = -1; j <= 1; ++j) {
                                if (Map.GetCollisionAtTile(n3 + n14 + i, n4 + n13 + j) == n12) continue;
                                return false;
                            }
                        }
                    }
                    ++n14;
                    n7 += 8;
                    ++n8;
                }
                ++n13;
                n6 += 8;
            }
        }
        return true;
    }

    private static boolean Build_Building() {
        Entity entity;
        int n = Level.GetBuildingStats(Level._player_faction, _hud_building, 15);
        if (n > Level._player_money) {
            return false;
        }
        if (Level._player_build_points >= Level._player_max_build_points) {
            return false;
        }
        if (Level._buildings_off_times[0][0] > 0) {
            return false;
        }
        int n2 = Cursor._nCursorPosX;
        int n3 = Cursor._nCursorPosY;
        if (_refinery_snap) {
            n2 = _snap_x;
            n3 = _snap_y;
        }
        if (!Hud.Build_IsValidBuildingPosition(n2, n3)) {
            return false;
        }
        if (_hud_building == 2) {
            entity = Level.FindClosestMineralField(n2, n3, 64);
            if (entity != null) {
                n2 = entity._pos_x;
                n3 = entity._pos_y + 1;
            } else {
                return false;
            }
        }
        if ((entity = Level.SpawnBuilding(_hud_building, n2, n3, 0, Level._player_faction)) != null) {
            if (((Building)entity)._allegiance == 0) {
                Level._player_money -= Level.GetBuildingStats(((Building)entity)._faction, _hud_building, 15);
                Level._statistics[0] = Level._statistics[0] + 1;
            } else if (((Building)entity)._allegiance == 1) {
                Level._ai_money -= Level.GetBuildingStats(((Building)entity)._faction, _hud_building, 15);
                Level._statistics[1] = Level._statistics[1] + 1;
            }
        }
        return true;
    }

    static void __BUILD() {
    }

    static void PLAY__() {
    }

    public static void Play_Update() {
        int n;
        int n2;
        Object object;
        int n3 = 32;
        if (SDKCanvas.isNewKeyPressed(n3) || (GameImpl._pointerAction & 1) != 0) {
            _changeDownFrames = 0;
            if (_changeDoubleFrames < 6) {
                if (Level.Group_GetLeader(Level._currentGroup) != -1 && (object = (Unit)Level.GetEntitySafe(Level.Group_GetLeader(Level._currentGroup))) != null) {
                    n2 = ((Entity)object)._pos_x - (GameImpl.SV_W >> 1);
                    n = ((Entity)object)._pos_y - (GameImpl.SV_H >> 1);
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 > Map._map_w - GameImpl.SV_W) {
                        n2 = Map._map_w - GameImpl.SV_W;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > Map._map_h - GameImpl.SV_H) {
                        n = Map._map_h - GameImpl.SV_H;
                    }
                    if (Hud.CanChangeGroup()) {
                        Camera.DoScroll(n2, n);
                    }
                }
                _bchangeDoubleTap = true;
                _changeDoubleFrames = (short)6;
            } else {
                _changeDoubleFrames = 0;
            }
        }
        if (SDKCanvas.isKeyPressed(n3)) {
            if (!_bchangeDoubleTap && (_changeDownFrames = (short)(_changeDownFrames + 1)) > 16 && Cursor._bUnitsSelected && !_disable_change_squad) {
                _changeDownFrames = 0;
            }
        } else if ((_changeDoubleFrames = (short)(_changeDoubleFrames + 1)) > 6) {
            _changeDoubleFrames = (short)6;
        }
        if (SDKCanvas.isNewKeyReleased(n3) || (GameImpl._pointerAction & 1) != 0) {
            GameImpl._pointerAction = 0;
            if (!_bchangeDoubleTap && Hud.CanChangeGroup()) {
                do {
                    if (++Level._currentGroup < 3) continue;
                    Level._currentGroup = 1;
                } while (Level.Group_GetLeader(Level._currentGroup) == -1);
                Cursor.SelectCurrentGroup();
            }
            _bchangeDoubleTap = false;
            _changeDownFrames = 0;
        }
        Cursor.UpdateCursor();
        if ((GameImpl._pointerAction & 0x100) != 0) {
            int n4;
            GameImpl._pointerAction = 0;
            object = _hud_build_items_available[1];
            n2 = _hud_nr_items_available[1];
            n = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                if (object[n4] <= 0) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                object = _hud_build_items_available[0];
                n2 = _hud_nr_items_available[0];
                for (n4 = 0; n4 < n2; ++n4) {
                    if (object[n4] <= 0) continue;
                    n = 1;
                    break;
                }
            }
            if (n == 0) {
                object = _hud_build_items_available[2];
                n2 = _hud_nr_items_available[2];
                for (n4 = 0; n4 < n2; ++n4) {
                    if (object[n4] <= 0) continue;
                    n = 1;
                    break;
                }
            }
            if (n != 0) {
                Hud.ChangeState(2, true);
                if (_bTutorialOn) {
                    _tutorial_tab = _hud_current_tab;
                }
            }
        }
        if ((GameImpl._pointerAction & 0x200) != 0) {
            GameImpl._pointerAction = 0;
        }
    }

    public static void Play_Draw(SDKGraphics sDKGraphics) {
        int n;
        XSprite xSprite = Sprites._sprites[11];
        Cursor.DrawCursor(sDKGraphics);
        Hud.Draw_Details(sDKGraphics);
        Hud.Draw_MiniMap(sDKGraphics);
        Hud.Draw_CommandPoints(sDKGraphics);
        SDKUtils.setFont(GameImpl.fonts[4]);
        if (Hud.CanChangeGroup()) {
            Hud.DrawSoftKeys(SDKUtils.getString(11, GameImpl._string), true, 4, true, _blink_RSK);
        }
        byte[] byArray = _hud_build_items_available[1];
        int n2 = _hud_nr_items_available[1];
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            if (byArray[n] <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            byArray = _hud_build_items_available[0];
            n2 = _hud_nr_items_available[0];
            for (n = 0; n < n2; ++n) {
                if (byArray[n] <= 0) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            byArray = _hud_build_items_available[2];
            n2 = _hud_nr_items_available[2];
            for (n = 0; n < n2; ++n) {
                if (byArray[n] <= 0) continue;
                bl = true;
                break;
            }
        }
        n = 26;
        switch (_hud_current_tab) {
            case 0: {
                n = 26;
                break;
            }
            case 1: {
                n = 127;
                break;
            }
            case 2: {
                n = 116;
            }
        }
        if (bl && !_bTutorialOn) {
            xSprite.DrawFrame(n, GameImpl.SV_X + (GameImpl.SV_W >> 1), GameImpl.SV_Y + GameImpl.SV_H, 0, 33);
        }
        Hud.Play_Draw_SuperWeapon_Cooldown(sDKGraphics);
    }

    private static void Play_Draw_SquadSel(SDKGraphics sDKGraphics) {
        int n = GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX;
        int n2 = GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY;
        if (n < 32) {
            n = 32;
        }
        if (n > GameImpl.SV_W - 32) {
            n = GameImpl.SV_W - 32;
        }
        if (n2 < 96) {
            n2 = 96;
        }
        if (n2 > GameImpl.SV_H - 64) {
            n2 = GameImpl.SV_H - 64;
        }
        Hud.Draw_SquadSel(n, n2, Level._currentGroup, sDKGraphics);
    }

    private static void Play_Draw_SuperWeapon_Cooldown(SDKGraphics sDKGraphics) {
        XSprite xSprite = Level._player_faction == 0 ? Sprites._sprites[29] : Sprites._sprites[30];
        int n = 163;
        int n2 = 60;
        byte[] byArray = _hud_build_items_available[2];
        int n3 = _hud_nr_items_available[2];
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[i];
            if (by >= 50) continue;
            if (_sw_cooldown[by] == 0) {
                byte by2 = by;
                _sw_cooldown[by2] = _sw_cooldown[by2] + 10;
            }
            if (_sw_cooldown[by] <= 70 && _sw_cooldown[by] % 10 < 5) {
                SDKUtils.setFont(GameImpl.fonts[5]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[4]);
            }
            xSprite.DrawFrame(32 + by, n, n2, 0);
            Utils.DrawSeparatedNumbers(_sw_cooldown[by] / 14 / 60, _sw_cooldown[by] / 14 % 60, ":", n + -8, n2 + 15, 0, 2);
            n += 29;
            SDKUtils.setFont(GameImpl.fonts[4]);
        }
    }

    private static void ChangeSquad_Draw(SDKGraphics sDKGraphics) {
        Hud.Play_Draw_SquadSel(sDKGraphics);
    }

    private static void ChangeSquad_Update() {
        if (SDKCanvas.isNewKeyPressed(32)) {
            Level._currentGroup = _hud_old_squad;
            Hud.ChangeState(1, true);
            return;
        }
        if (SDKCanvas.isNewKeyPressed(513)) {
            if (Level._currentGroup > 1) {
                --Level._currentGroup;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            if (Level._currentGroup < 2) {
                ++Level._currentGroup;
            }
        } else if (SDKCanvas.isNewKeyReleased(4112) || (GameImpl._pointerAction & 0x40) != 0) {
            Cursor.CursorOrderGroup();
            Level._currentGroup = _hud_old_squad;
            Hud.ChangeState(1, true);
        }
    }

    private static boolean CanChangeGroup() {
        for (int i = 0; i < 3; ++i) {
            if (i == Level._currentGroup || Level.Group_GetLeader(i) == -1) continue;
            return true;
        }
        return false;
    }

    static void __PLAY() {
    }

    static void RiseMovieBars() {
        _hud_movie_bars = true;
    }

    static void SinkMovieBars() {
        _hud_movie_bars = false;
    }

    static void UpdateMovieBars() {
        if (_hud_movie_bars) {
            if (_hud_bars_hight < 48) {
                _hud_bars_hight += 6;
            }
            if (_hud_bars_hight > 48) {
                _hud_bars_hight = 48;
            }
        } else {
            if (_hud_bars_hight > 0) {
                _hud_bars_hight -= 6;
            }
            if (_hud_bars_hight < 0) {
                _hud_bars_hight = 0;
            }
        }
    }

    static void DrawMovieBars(SDKGraphics sDKGraphics) {
        if (_hud_bars_hight > 0) {
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(0, 0, GameImpl.SV_W, _hud_bars_hight);
            sDKGraphics.fillRect(0, GameImpl.SCR_H - _hud_bars_hight, GameImpl.SV_W, _hud_bars_hight);
        }
    }

    static void DrawSoftKeys(SDKString sDKString, boolean bl, int n, boolean bl2, boolean bl3) {
        SDKUtils.setFont(GameImpl.fonts[n]);
        boolean bl4 = bl;
        if (bl2) {
            SDKUtils.setLeadingSpacing(0);
            int n2 = SDKUtils.getStringSize(sDKString);
            int n3 = 1;
            int n4 = 44;
            while (n2 + 1 > n4) {
                n4 += 10;
                ++n3;
            }
            XSprite xSprite = Sprites._sprites[11];
            if (bl4) {
                int n5 = 121;
                int n6 = 123;
                int n7 = 122;
                int n8 = 0;
                int n9 = GameImpl.SCR_H;
                xSprite.DrawFrame(n5, n8, n9, 0, 32);
                n8 += 21;
                for (int i = 0; i < n3; ++i) {
                    xSprite.DrawFrame(n7, n8, n9, 0, 32);
                    n8 += 10;
                }
                xSprite.DrawFrame(n6, n8, n9, 0, 32);
                SDKUtils.drawString(sDKString, 27 + ((n3 - 1) * 10 >> 1), GameImpl.SCR_H - 15, 33);
            } else {
                int n10 = 126;
                int n11 = 124;
                int n12 = 125;
                int n13 = GameImpl.SCR_W;
                int n14 = GameImpl.SCR_H;
                xSprite.DrawFrame(n10, n13, n14, 0, 34);
                n13 -= 23;
                for (int i = 0; i < n3; ++i) {
                    xSprite.DrawFrame(n12, n13, n14, 0, 34);
                    n13 -= 10;
                }
                xSprite.DrawFrame(n11, n13, n14, 0, 34);
                SDKUtils.drawString(sDKString, GameImpl.SCR_W - 27 - ((n3 - 1) * 10 >> 1), GameImpl.SCR_H - 15, 33);
            }
        } else if (bl4) {
            SDKUtils.drawString(sDKString, 1, GameImpl.SCR_H - 6, 36);
        } else {
            SDKUtils.drawString(sDKString, GameImpl.SCR_W - 1, GameImpl.SCR_H - 6, 40);
        }
    }

    public static void pointerPressed(int n, int n2, long l) {
        switch (_hud_state) {
            case 5: {
                GameImpl.checkSoftkeys(n, n2, 14, -1);
                break;
            }
            case 2: {
                if (GameImpl.checkSoftkeys(n, n2, 6, -1)) {
                    return;
                }
                if (_hud_substate == 0) {
                    int n3;
                    int n4;
                    if (n2 > 38 && n2 < 83 && n > Pointer.BUILD_SCROLL_LEFT_BUTTON_X && n < Pointer.BUILD_SCROLL_LEFT_BUTTON_X + 54) {
                        GameImpl._pointerAction |= 0x10;
                        return;
                    }
                    if (n2 > 85 && n2 < 130 && n > Pointer.BUILD_SCROLL_UP_BUTTON_X && n < Pointer.BUILD_SCROLL_UP_BUTTON_X + 54) {
                        GameImpl._pointerAction |= 4;
                        return;
                    }
                    if (n2 > Pointer.BUILD_SCROLL_DOWN_BUTTON_Y && n2 < Pointer.BUILD_SCROLL_DOWN_BUTTON_Y + 45 && n > Pointer.BUILD_SCROLL_DOWN_BUTTON_X && n < Pointer.BUILD_SCROLL_DOWN_BUTTON_X + 54) {
                        GameImpl._pointerAction |= 8;
                        return;
                    }
                    if (n <= GameImpl.HUD_BUILD_SLOT_ON_POSX - 14 || n2 < (n4 = 131) || (n3 = (n2 - n4) / 39) < 0 || n3 >= GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS || (n3 += _hud_build_page_pos[_hud_current_tab]) >= _hud_nr_items_available[_hud_current_tab]) break;
                    if (n3 != _hud_build_cursor_pos[_hud_current_tab]) {
                        Hud._hud_build_cursor_pos[Hud._hud_current_tab] = (byte)n3;
                        break;
                    }
                    GameImpl._pointerAction |= 0x40;
                    break;
                }
                if (_hud_substate == 1) {
                    byte by;
                    byte by2;
                    int n5;
                    if (n <= GameImpl.HUD_BUILD_SQUADS_POSX - 14 || n >= GameImpl.HUD_BUILD_SLOT_ON_POSX - 14 || n2 < (n5 = 150 + ((by2 = _hud_build_cursor_pos[_hud_current_tab]) - (by = _hud_build_page_pos[_hud_current_tab])) * 39 - 24)) break;
                    int n6 = (n2 - n5) / 24;
                    int n7 = 2;
                    for (int i = 0; i < 8; ++i) {
                        int n8;
                        int n9;
                        if (Tutorial._tutorials[i][0] != 1 || (n9 = Tutorial._tutorials[i][1]) != 5 || (n8 = Tutorial._tutorials[i][8]) <= 0) continue;
                        n7 = n8;
                    }
                    if (++n6 < 1 || n6 > n7) break;
                    if (n6 != _hud_current_squad) {
                        _hud_current_squad = n6;
                        break;
                    }
                    GameImpl._pointerAction |= 0x40;
                    break;
                }
                if (_hud_substate != 2 && _hud_substate != 3 && _hud_substate != 4 && _hud_substate != 5) break;
                if (Math.abs(n - lastPointerX) < 20 && Math.abs(n2 - lastPointerY) < 20 && l - lastPointerPressedTime < 1000L) {
                    GameImpl._pointerAction |= 0x80;
                }
                Cursor._nCursorPosX = Camera._nCamX + n - GameImpl.SV_X;
                Cursor._nCursorPosY = Camera._nCamY + n2 - GameImpl.SV_Y;
                lastPointerX = n;
                lastPointerY = n2;
                wasPointerPressedBeforeDrag = true;
                lastPointerPressedTime = l;
                break;
            }
            case 1: {
                int n10;
                if (Hud.CanChangeGroup() && GameImpl.checkSoftkeys(n, n2, 11, -1)) {
                    return;
                }
                byte[] byArray = _hud_build_items_available[1];
                int n11 = _hud_nr_items_available[1];
                boolean bl = false;
                for (n10 = 0; n10 < n11; ++n10) {
                    if (byArray[n10] <= 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    byArray = _hud_build_items_available[0];
                    n11 = _hud_nr_items_available[0];
                    for (n10 = 0; n10 < n11; ++n10) {
                        if (byArray[n10] <= 0) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    byArray = _hud_build_items_available[2];
                    n11 = _hud_nr_items_available[2];
                    for (n10 = 0; n10 < n11; ++n10) {
                        if (byArray[n10] <= 0) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl && n2 > GameImpl.SCR_H - 45 && n > GameImpl.SCR_W - 54 >> 1 && n < GameImpl.SCR_W + 54 >> 1) {
                    GameImpl._pointerAction |= 0x100;
                    return;
                }
                n10 = 149;
                int n12 = 48;
                byArray = _hud_build_items_available[2];
                int n13 = _hud_nr_items_available[2];
                for (int i = 0; i < n13; ++i) {
                    byte by = byArray[i];
                    if (by >= 50) continue;
                    if (_sw_cooldown[by] <= 10 && Level.HasPower(0) && n > n10 && n < n10 + 29 && n2 > n12 && n2 < n12 + 25) {
                        Hud.ChangeState(2, true);
                        _hud_current_tab = 2;
                        Hud._hud_build_cursor_pos[Hud._hud_current_tab] = (byte)i;
                        _hud_sw = _hud_build_items_available[_hud_current_tab][_hud_build_cursor_pos[_hud_current_tab]];
                        Hud.Build_ChangeSubState(3);
                        GameImpl._pointerAction |= 0x200;
                        return;
                    }
                    n10 += 29;
                }
                if (Math.abs(n - lastPointerX) < 20 && Math.abs(n2 - lastPointerY) < 20 && l - lastPointerPressedTime < 1000L) {
                    GameImpl._pointerAction |= 0x80;
                }
                Cursor._nCursorPosX = Camera._nCamX + n - GameImpl.SV_X;
                Cursor._nCursorPosY = Camera._nCamY + n2 - GameImpl.SV_Y;
                lastPointerX = n;
                lastPointerY = n2;
                wasPointerPressedBeforeDrag = true;
                lastPointerPressedTime = l;
                break;
            }
            case 3: {
                int n14;
                if (n <= drawSquadSelX - 14 || n >= drawSquadSelX + 14 || n2 < (n14 = drawSquadSelY - 24)) break;
                int n15 = (n2 - n14) / 24;
                int n16 = 2;
                for (int i = 0; i < 8; ++i) {
                    int n17;
                    int n18;
                    if (Tutorial._tutorials[i][0] != 1 || (n18 = Tutorial._tutorials[i][1]) != 5 || (n17 = Tutorial._tutorials[i][8]) <= 0) continue;
                    n16 = n17;
                }
                if (++n15 < 1 || n15 > n16) break;
                if (n15 != Level._currentGroup) {
                    Level._currentGroup = n15;
                    break;
                }
                GameImpl._pointerAction |= 0x40;
                break;
            }
            case 4: {
                MsgBox.pointerPressed(n, n2);
            }
        }
    }

    public static void pointerDragged(int n, int n2) {
        switch (_hud_state) {
            case 2: {
                if (_hud_substate != 2 && _hud_substate != 3 && _hud_substate != 4 && _hud_substate != 5) break;
            }
            case 1: {
                if (!wasPointerPressedBeforeDrag) {
                    return;
                }
                int n3 = n - lastPointerX;
                int n4 = n2 - lastPointerY;
                Camera.DoDrag(n3, n4);
                lastPointerX = n;
                lastPointerY = n2;
            }
        }
    }

    public static void pointerReleased(int n, int n2, long l) {
        wasPointerPressedBeforeDrag = false;
    }

    static {
        _hud_current_tab = 1;
        _hud_current_squad = 1;
        _bDrawCollisionMap = false;
        _bTutorialOn = false;
        _hud_building_cmap = null;
        _old_minimap_state = -1;
        _old_camera_x = 0;
        _old_camera_y = 0;
        _hud_timer = 0;
        _event_timer = 0;
        _move_tab = 0;
        _refinery_snap = false;
        _hud_build_items_available = new byte[3][12];
        _hud_nr_items_available = new byte[3];
        _hud_build_items_available_mask = new int[3];
        _hud_build_cursor_pos = new byte[3];
        _hud_build_page_pos = new byte[3];
        _hud_build_items = new byte[][][]{new byte[][]{{1, 2, 3, 4, 8, 6, 7, 5, 9}, {1, 2, 3, 4, 8, 6, 7, 5, 9}}, new byte[][]{{0, 7, 4, 2, 1, 3, 8}, {9, 12, 4, 10, 14, 11, 13}}, new byte[][]{{1, 2, 0}, {3, 4, 5}}};
        _hud_build_items_count = new byte[]{9, 9, 7, 7, 3, 3};
        _old_player_money = 0;
        _tooltip_name_string = new SDKString("");
        _tooltip_cost_string = new SDKString("");
        _tooltip_descr_string = new SDKString("");
        _tooltip_old_name = -1;
        lastPointerPressedTime = -1L;
        wasPointerPressedBeforeDrag = false;
    }
}

