/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.Pointer;
import com.ea.game.SpriteConstants;
import com.ea.game.Sprites;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;

public class Cursor
implements Constants,
UnitsConstants,
BuildingConstants,
SpriteConstants,
GraphicsConstants,
Key,
Pointer {
    static int _nCursorPosX = 0;
    static int _nCursorPosY = 0;
    static int _nCursorSpdX = 0;
    static int _nCursorSpdY = 0;
    static int[] _pCursorTrailX = new int[16];
    static int[] _pCursorTrailY = new int[16];
    static int _nCursorTrailLastPt = 0;
    static int _nCursorTrailLength = 0;
    static boolean _bCursorScroll = false;
    static boolean _bUnitsSelected = false;
    static boolean _bCursorExpanded = false;
    static short _cursorDownFrames;
    static short _cursorDoubleFrames;
    static boolean _bcursorDoubleTap;
    static int _nCursorSpdExp;
    static int[] _cursorRect;
    static int _targetPointer;
    static int _cursorFrame;
    static int _cursorFrameTime;
    static int _cursorAnimation;
    static int _sovietHeroPointer;
    static int _selectedUnitsCapabilities;
    static boolean _disableSelection;
    static boolean _disableBoxSelection;
    static int _cursor_group;

    static void InitCursor() {
        _nCursorPosX = GameImpl.SV_W / 2;
        _nCursorPosY = GameImpl.SV_H / 2;
        _nCursorSpdX = 0;
        _nCursorSpdY = 0;
        _nCursorSpdExp = 0;
        _bCursorScroll = false;
        _nCursorTrailLastPt = 0;
        _nCursorTrailLength = 0;
        _targetPointer = -1;
        _cursorDownFrames = 0;
        _cursorDoubleFrames = (short)6;
        _bcursorDoubleTap = false;
        _bUnitsSelected = false;
        _cursorRect = Utils.Rect(_cursorRect, _nCursorPosX - 4, _nCursorPosY - 4, 8, 8);
        _cursorFrame = 0;
        _cursorFrameTime = 0;
        _cursorAnimation = -1;
        _sovietHeroPointer = -1;
        _selectedUnitsCapabilities = 0;
        _disableSelection = false;
        _disableBoxSelection = false;
        _cursor_group = 1;
    }

    static void UpdateCursor() {
        if (!_bCursorExpanded) {
            Cursor.UpdateCursorMovement();
        }
        Cursor.UpdateCursorTargetPointer();
        if (!_disableSelection) {
            Cursor.UpdateCursorSelection();
        }
        Cursor.RefreshSelectCapabilities();
    }

    static void DrawCursor(SDKGraphics sDKGraphics, int n, int n2) {
        int n3 = _nCursorPosX;
        int n4 = _nCursorPosY;
        _nCursorPosX = n;
        _nCursorPosY = n2;
        Cursor.DrawCursor(sDKGraphics);
        _nCursorPosX = n3;
        _nCursorPosY = n4;
    }

    static void DrawCursor(SDKGraphics sDKGraphics) {
        int n = GameImpl.SV_X + _nCursorPosX - Camera._nCamX;
        int n2 = GameImpl.SV_Y + _nCursorPosY - Camera._nCamY;
        if (_bCursorExpanded) {
            sDKGraphics.setColor(65280);
            sDKGraphics.drawLine(n, n2, n, n2);
            sDKGraphics.drawRect(_cursorRect[0] - Camera._nCamX + GameImpl.SV_X, _cursorRect[1] - Camera._nCamY + GameImpl.SV_Y, _cursorRect[3] - _cursorRect[1], _cursorRect[2] - _cursorRect[0]);
        } else {
            int n3 = Cursor.GetCursorAction();
            XSprite xSprite = Sprites._sprites[13];
            int n4 = 4;
            block0 : switch (n3) {
                case 0: {
                    n4 = 4;
                    break;
                }
                case 1: {
                    n4 = 4;
                    break;
                }
                case 3: {
                    if (_cursor_group == 2) {
                        n4 = 4;
                        break;
                    }
                    n4 = 4;
                    break;
                }
                case 4: {
                    if (_cursor_group == 2) {
                        n4 = 4;
                        break;
                    }
                    n4 = 4;
                    break;
                }
                case 2: {
                    if (_cursor_group == 2) {
                        n4 = 4;
                        break;
                    }
                    n4 = 4;
                    break;
                }
                case 5: {
                    n4 = 9;
                    break;
                }
                case 9: {
                    n4 = 10;
                    break;
                }
                case 6: 
                case 13: {
                    n4 = 13;
                    break;
                }
                case 7: {
                    n4 = 12;
                    break;
                }
                case 8: {
                    switch (Hud._hud_sw) {
                        case 2: {
                            n4 = 15;
                            break block0;
                        }
                        case 1: {
                            n4 = 16;
                            break block0;
                        }
                        case 3: {
                            n4 = 17;
                            break block0;
                        }
                        case 4: {
                            n4 = 19;
                            break block0;
                        }
                        case 5: {
                            n4 = 18;
                            break block0;
                        }
                    }
                    n4 = 14;
                    break;
                }
                case 11: {
                    n4 = 14;
                    if (Hud._hud_sw != 4) break;
                    n4 = 20;
                    break;
                }
                case 10: {
                    n4 = 10;
                    break;
                }
                case 12: {
                    n4 = 11;
                    break;
                }
                case 14: {
                    n4 = 4;
                    break;
                }
                case 15: {
                    n4 = 4;
                    break;
                }
                case 16: {
                    n4 = 21;
                    break;
                }
                case 18: {
                    n4 = 35;
                    break;
                }
                case 17: {
                    n4 = 4;
                }
            }
            if (n4 != _cursorAnimation) {
                _cursorAnimation = n4;
                _cursorFrame = 0;
                _cursorFrameTime = 0;
            } else if (++_cursorFrameTime >= xSprite.GetAnimFrameTime(_cursorAnimation, _cursorFrame)) {
                _cursorFrame = (_cursorFrame + 1) % xSprite.GetAnimLength(_cursorAnimation);
                _cursorFrameTime = 0;
            }
            if (n4 >= 0 && n4 != 4) {
                xSprite.DrawAnimFrame(_cursorAnimation, _cursorFrame, n, n2, 0);
            }
        }
    }

    static void UpdateCursorMovement() {
        if (_nCursorSpdX > 0) {
            if ((_nCursorPosX += _nCursorSpdX) > Map._map_w) {
                _nCursorPosX = Map._map_w;
            }
        } else if (_nCursorSpdX < 0 && (_nCursorPosX += _nCursorSpdX) < 0) {
            _nCursorPosX = 0;
        }
        if (_nCursorSpdY > 0) {
            if ((_nCursorPosY += _nCursorSpdY) > Map._map_h) {
                _nCursorPosY = Map._map_h;
            }
        } else if (_nCursorSpdY < 0 && (_nCursorPosY += _nCursorSpdY) < Camera._nCamY + GameImpl.CURSOR_MIN_Y) {
            _nCursorPosY = Camera._nCamY + GameImpl.CURSOR_MIN_Y;
        }
    }

    static void UpdateCursorTargetPointer() {
        int n;
        Entity entity;
        int n2;
        if (!_bCursorExpanded) {
            _cursorRect = Utils.Rect(_cursorRect, _nCursorPosX - 4, _nCursorPosY - 4, 8, 8);
        }
        int n3 = -1;
        _targetPointer = -1;
        boolean bl = true;
        if (GameImpl._useFog) {
            bl = Level.FOW_IsDiscovered(_nCursorPosX, _nCursorPosY);
        }
        if (bl) {
            for (n2 = 0; n2 < 64; ++n2) {
                if (Level._entities_usage[n2] == 1) {
                    entity = (Unit)Level._entities[n2];
                    boolean bl2 = false;
                    if (((Unit)entity)._allegiance == 1 && ((Unit)entity)._FOW_visible && ((Unit)entity)._collisionBox[2] - ((Unit)entity)._collisionBox[0] < 32) {
                        ((Unit)entity)._collisionBox = Utils.Rect(((Unit)entity)._collisionBox, entity._pos_x - 16, entity._pos_y - 16, 32, 32);
                        bl2 = true;
                    }
                    if (((Unit)entity).IsSelectable(!_bUnitsSelected) && Utils.RectIntersect(((Unit)entity)._collisionBox, _cursorRect) && ((Unit)entity)._FOW_visible) {
                        n = Math.abs(entity._pos_x - _nCursorPosX) + Math.abs(entity._pos_y - _nCursorPosY);
                        if (n3 < 0 || n3 > n) {
                            n3 = n;
                            _targetPointer = entity.GetPointer();
                        }
                    }
                    if (bl2) {
                        ((Unit)entity).SetCollisionBox();
                    }
                }
                if (_targetPointer < 0) continue;
                ((Unit)Level.GetEntitySafe((int)Cursor._targetPointer))._bTargeted = true;
            }
            if (_targetPointer < 0) {
                for (n2 = 160; n2 < 416; ++n2) {
                    if (Level._entities_usage[n2] == 1) {
                        int[] nArray;
                        entity = Level._entities[n2];
                        if ((entity._flags & 0x400) != 0) continue;
                        if ((entity._type == 7 || entity._type == 9) && Utils.RectIntersect(nArray = entity.ComputeBoundingBox(), _cursorRect)) {
                            n = Math.abs(entity._pos_x - _nCursorPosX) + Math.abs(entity._pos_y - _nCursorPosY);
                            if (n3 < 0 || n3 > n) {
                                n3 = n;
                                _targetPointer = entity.GetPointer();
                            }
                        }
                    }
                    if (_targetPointer < 0 || (entity = Level.GetEntitySafe(_targetPointer)) == null || entity._type != 13) continue;
                    entity._sdata[4] = 1;
                }
            }
            if (_targetPointer < 0) {
                for (n2 = 64; n2 < 160; ++n2) {
                    if (Level._entities_usage[n2] != 1) continue;
                    entity = (Building)Level._entities[n2];
                    boolean bl3 = false;
                    if (((Building)entity)._allegiance == 1 && ((Building)entity)._FOW_visible && (((Building)entity)._subtype == 5 || ((Building)entity)._subtype == 6)) {
                        ((Building)entity)._collisionBox[0] = ((Building)entity)._collisionBox[0] - 8;
                        ((Building)entity)._collisionBox[2] = ((Building)entity)._collisionBox[2] + 8;
                        bl3 = true;
                    }
                    if (((Building)entity).IsSelectable(!_bUnitsSelected) && Utils.RectIntersect(((Building)entity)._collisionBox, _cursorRect) && ((Building)entity)._FOW_visible) {
                        n = Math.abs(entity._pos_x - _nCursorPosX) + Math.abs(entity._pos_y - _nCursorPosY);
                        if (n3 < 0 || n3 > n) {
                            n3 = n;
                            _targetPointer = entity.GetPointer();
                        }
                    }
                    if (!bl3) continue;
                    ((Building)entity)._collisionBox[0] = ((Building)entity)._collisionBox[0] + 8;
                    ((Building)entity)._collisionBox[2] = ((Building)entity)._collisionBox[2] - 8;
                }
                if (_targetPointer >= 0) {
                    ((Building)Level.GetEntitySafe((int)Cursor._targetPointer))._bTargeted = true;
                }
            }
        }
        if (_targetPointer < 0) {
            for (n2 = 160; n2 < 416; ++n2) {
                if (Level._entities_usage[n2] == 1) {
                    int[] nArray;
                    entity = Level._entities[n2];
                    if ((entity._flags & 0x400) != 0) continue;
                    if ((entity._type == 11 || entity._type == 13 || entity._type == 10) && Utils.RectIntersect(nArray = entity.ComputeBoundingBox(), _cursorRect)) {
                        n = Math.abs(entity._pos_x - _nCursorPosX) + Math.abs(entity._pos_y - _nCursorPosY);
                        if (n3 < 0 || n3 > n) {
                            n3 = n;
                            _targetPointer = entity.GetPointer();
                        }
                    }
                }
                if (_targetPointer < 0 || (entity = Level.GetEntitySafe(_targetPointer)) == null || entity._type != 13) continue;
                entity._sdata[4] = 1;
            }
        }
    }

    static void UpdateCursorSelection() {
        if ((_cursorDoubleFrames = (short)(_cursorDoubleFrames + 1)) > 6) {
            _cursorDoubleFrames = (short)6;
        }
        if ((GameImpl._pointerAction & 0x80) != 0) {
            GameImpl._pointerAction = 0;
            if (!_bcursorDoubleTap) {
                int n = Cursor.GetCursorAction();
                switch (n) {
                    case 1: {
                        Cursor.CursorSelect();
                        break;
                    }
                    case 3: {
                        Cursor.CursorOrderMove();
                        break;
                    }
                    case 4: 
                    case 14: 
                    case 15: {
                        Cursor.CursorOrderAttack();
                        break;
                    }
                    case 5: 
                    case 12: 
                    case 13: {
                        Cursor.CursorOrderGarrison();
                        break;
                    }
                    case 17: {
                        Cursor.CursorOrderRepairBuilding();
                        break;
                    }
                    case 9: {
                        Cursor.CursorOrderEvacuate();
                        break;
                    }
                    case 6: 
                    case 7: {
                        Cursor.CursorOrderDemolish();
                        break;
                    }
                    case 10: {
                        Cursor.CursorOrderClearGarrison();
                    }
                }
            }
            _bcursorDoubleTap = false;
            _cursorDownFrames = 0;
            _bCursorExpanded = false;
        }
    }

    static void CursorSelectSameUnits() {
        int n = _targetPointer & 0xFFFF;
        if (n >= 0 && n < 64) {
            Unit unit = (Unit)Level.GetEntitySafe(_targetPointer);
            if (unit == null) {
                return;
            }
            if (unit._allegiance == 0) {
                for (int i = 0; i < 64; ++i) {
                    Unit unit2;
                    if (Level._entities_usage[i] != 1 || !(unit2 = (Unit)Level._entities[i]).IsSelectable(true)) continue;
                    if (unit2._subtype != unit._subtype) {
                        unit2._bSelected = false;
                        continue;
                    }
                    unit2._bSelected = true;
                    _bUnitsSelected = true;
                    Level._currentGroup = 0;
                }
            }
        }
    }

    static void CursorSelect() {
        if (_bCursorExpanded) {
            Level._currentGroup = 0;
            for (int i = 0; i < 64; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit.IsSelectable(true) && Utils.RectIntersect(unit._collisionBox, _cursorRect)) {
                    unit._bSelected = true;
                    _bUnitsSelected = true;
                    continue;
                }
                unit._bSelected = false;
            }
        } else {
            Building building;
            int n = _targetPointer & 0xFFFF;
            if (n >= 64 && n < 160 && (building = (Building)Level.GetEntitySafe(_targetPointer)) != null) {
                switch (building._subtype) {
                    case 0: {
                        Hud.ChangeState(2, true);
                        Hud._hud_current_tab = 0;
                        break;
                    }
                    case 3: 
                    case 4: {
                        Hud.ChangeState(2, true);
                        Hud._hud_current_tab = 1;
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        Hud.ChangeState(2, true);
                        Hud._hud_current_tab = 2;
                    }
                }
            }
        }
    }

    static void CursorOrderMove() {
        if (_bCursorExpanded) {
            return;
        }
        Level.GetCurrentGravCenter(-1, 0);
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (!unit._bSelected) continue;
            int n = unit._pos_x - Level._gravity_center_X;
            int n2 = unit._pos_y - Level._gravity_center_Y;
            while (Math.abs(n) + Math.abs(n2) > 64) {
                n >>= 1;
                n2 >>= 1;
            }
            unit.DoAction(2, -1, n + _nCursorPosX, n2 + _nCursorPosY);
            unit.SetRallyPoint(_nCursorPosX, _nCursorPosY);
            unit._requested_action = true;
        }
    }

    static void CursorOrderRepairBuilding() {
        if (_bCursorExpanded) {
            return;
        }
        Entity entity = Level.GetEntitySafe(_targetPointer);
        if (entity._type == 6) {
            for (int i = 0; i < 64; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (!unit._bSelected || unit._subtype != 4) continue;
                unit.DoAction(4, _targetPointer, -1, -1);
                break;
            }
        }
    }

    static void CursorOrderGarrison() {
        block4: {
            Entity entity;
            block5: {
                if (_bCursorExpanded) {
                    return;
                }
                entity = Level.GetEntitySafe(_targetPointer);
                if (entity == null) {
                    return;
                }
                if (entity._type != 9 && entity._type != 13) break block5;
                for (int i = 0; i < 64; ++i) {
                    if (Level._entities_usage[i] != 1) continue;
                    Unit unit = (Unit)Level._entities[i];
                    if (!unit._bSelected || unit._subtype != 4) continue;
                    unit.DoAction(4, _targetPointer, -1, -1);
                    break block4;
                }
                break block4;
            }
            if (entity._type != 11) break block4;
            Entity entity2 = Level.GetEntitySafe(_targetPointer);
            for (int i = 0; i < 64; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (!unit._bSelected || !unit.IsGarrisonable() || !entity2.GarrisonBld_HasFreeSlots()) continue;
                unit.DoAction(4, _targetPointer, -1, -1);
            }
        }
    }

    static void CursorOrderEvacuate() {
        if (_bCursorExpanded) {
            return;
        }
        Entity entity = Level.GetEntitySafe(_targetPointer);
        if (entity == null) {
            return;
        }
        if (entity._type == 11) {
            entity.GarrisonBld_Evacuate();
        }
    }

    static void CursorOrderDemolish() {
        if (_bCursorExpanded) {
            return;
        }
        Entity entity = Level.GetEntitySafe(_targetPointer);
        if (entity == null) {
            return;
        }
        if (entity._type == 6) {
            for (int i = 0; i < 64; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (Cursor.CheckCapability(4)) {
                    if (!unit._bSelected || unit._subtype != 6) continue;
                    unit.DoAction(6, _targetPointer, -1, -1);
                    break;
                }
                if (!Cursor.CheckCapability(8) || !unit._bSelected || unit._subtype != 5 && unit._subtype != 4) continue;
                unit.DoAction(6, _targetPointer, -1, -1);
                break;
            }
        }
    }

    static void CursorOrderAttack() {
        if (_bCursorExpanded) {
            return;
        }
        Level.GetCurrentGravCenter(-1, 0);
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (!unit._bSelected) continue;
            int n = unit._pos_x - Level._gravity_center_X;
            int n2 = unit._pos_y - Level._gravity_center_Y;
            while (Math.abs(n) + Math.abs(n2) > 64) {
                n >>= 1;
                n2 >>= 1;
            }
            unit.DoAction(3, _targetPointer, n + _nCursorPosX, n2 + _nCursorPosY);
            unit._requested_action = true;
        }
    }

    static void CursorOrderGroup() {
        Level.Group_SetToSelection(Level._currentGroup);
    }

    static void CursorOrderClearGarrison() {
        if (_bCursorExpanded) {
            return;
        }
        Entity entity = Level.GetEntitySafe(_targetPointer);
        if (entity == null) {
            return;
        }
        if (entity._type == 11) {
            for (int i = 0; i < 64; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit._subtype != 10 || !unit._bSelected || unit._allegiance != 0) continue;
                unit.DoAction(7, _targetPointer, -1, -1);
            }
        }
    }

    static int GetCursorAction() {
        if (_bCursorExpanded) {
            return 1;
        }
        if (Hud._hud_state == 2) {
            if (Hud._hud_substate == 5) {
                Entity entity = Level.GetEntitySafe(_targetPointer);
                if (entity != null && entity._type == 6) {
                    Building building = (Building)entity;
                    if (building._subtype != 0 && building._allegiance == 0) {
                        return 16;
                    }
                }
                return 18;
            }
            if (Hud._hud_substate == 3) {
                if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3 && Hud._hud_sw == 4) {
                    return 2;
                }
                if (!GameImpl._useFog || Level.FOW_IsDiscovered(_nCursorPosX, _nCursorPosY)) {
                    return 8;
                }
                return 2;
            }
            if (Hud._hud_substate == 4) {
                if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3 && Hud._hud_sw == 4) {
                    return 2;
                }
                if (!GameImpl._useFog || Level.FOW_IsDiscovered(_nCursorPosX, _nCursorPosY)) {
                    if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                        return 2;
                    }
                    return 11;
                }
                return 2;
            }
        }
        if (!_bUnitsSelected) {
            if (GameImpl._useFog && !Level.FOW_IsDiscovered(_nCursorPosX, _nCursorPosY)) {
                return 2;
            }
            if (_targetPointer >= 0) {
                return 1;
            }
            return 0;
        }
        if (GameImpl._useFog && !Level.FOW_IsDiscovered(_nCursorPosX, _nCursorPosY)) {
            if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                return 2;
            }
            if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3) {
                return 2;
            }
            return 3;
        }
        Entity entity = Level.GetEntitySafe(_targetPointer);
        if (entity == null) {
            if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                return 2;
            }
            if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3) {
                return 2;
            }
            return 3;
        }
        switch (entity._type) {
            case 5: {
                Unit unit = (Unit)entity;
                if (unit._allegiance == 0) {
                    return 1;
                }
                if (unit._allegiance == 2) {
                    if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                        return 2;
                    }
                    return 3;
                }
                if ((unit._attack_capabilities & 0x100) != 0) {
                    if (Cursor.CheckCapability(2)) {
                        if (Level._b_tower_defense) {
                            return 2;
                        }
                        return 4;
                    }
                    if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                        return 2;
                    }
                    if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3) {
                        return 2;
                    }
                    return 3;
                }
                if (Cursor.CheckCapability(512)) {
                    Unit unit2 = (Unit)Level.GetEntitySafe(_sovietHeroPointer);
                    int n = Math.abs(unit2._pos_x - unit._pos_x) + Math.abs(unit2._pos_y - unit._pos_y);
                    if (n < unit2._fire_range && Map.NoLineOfSightCollisionBetween(unit2, entity, 10)) {
                        if (unit2._targetPointer == entity.GetPointer()) {
                            return 15;
                        }
                        return 14;
                    }
                    return 4;
                }
                if (Cursor.CheckCapability(1)) {
                    if (Level._b_tower_defense) {
                        return 2;
                    }
                    return 4;
                }
                if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                    return 2;
                }
                if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3) {
                    return 2;
                }
                return 3;
            }
            case 6: {
                Building building = (Building)entity;
                if (building._allegiance == 0) {
                    if (Cursor.CheckCapability(128) && building._life < building._initial_life && building._subtype != 5 && building._subtype != 6) {
                        return 17;
                    }
                    return 1;
                }
                if (building._allegiance == 2) {
                    return 0;
                }
                if (building._subtype != 5 && building._subtype != 6) {
                    if (Cursor.CheckCapability(4)) {
                        return 6;
                    }
                    if (Cursor.CheckCapability(8) && Level._buildings_off_times[1][building._subtype] == 0) {
                        return 7;
                    }
                }
                if (Cursor.CheckCapability(2)) {
                    return 4;
                }
                if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                    return 2;
                }
                if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3) {
                    return 2;
                }
                return 3;
            }
            case 7: {
                if (Cursor.CheckCapability(16)) {
                    return 4;
                }
                if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                    return 2;
                }
                if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3) {
                    return 2;
                }
                return 3;
            }
            case 9: {
                if (Cursor.CheckCapability(128)) {
                    if (entity.BridgeCmdPost_GetBridgeState() == 1) {
                        return 12;
                    }
                    return 13;
                }
                return 2;
            }
            case 13: {
                short s = entity._sdata[1];
                if (s == 1) {
                    return 4;
                }
                if (s == 0) {
                    return 2;
                }
                if (Cursor.CheckCapability(128)) {
                    return 5;
                }
                return 2;
            }
            case 11: {
                if (entity.GarrisonBld_IsFriendly(0)) {
                    if (Cursor.CheckCapability(64) && entity.GarrisonBld_HasFreeSlots()) {
                        return 5;
                    }
                    if (entity.GarrisonBld_IsOccupied()) {
                        return 9;
                    }
                    return 2;
                }
                if (Cursor.CheckCapability(1024) && entity.GarrisonBld_IsOccupied()) {
                    return 10;
                }
                if (Cursor.CheckCapability(32)) {
                    return 4;
                }
                if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
                    return 2;
                }
                return 3;
            }
        }
        if (Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) > 4) {
            return 2;
        }
        if (Level._b_tower_defense && Map.GetCollisionAt(_nCursorPosX, _nCursorPosY) == 3) {
            return 2;
        }
        return 3;
    }

    static void SelectCurrentGroup() {
        Entity entity;
        _bUnitsSelected = Level.Group_Select(Level._currentGroup);
        if (Level._currentGroup != 0 && Level._currentGroup != -1 && (entity = Level.GetEntitySafe(Level.Group_GetLeader(Level._currentGroup))) != null) {
            Level.SpawnIGMessage(0, _nCursorPosX, _nCursorPosY, 20, 73 + Level._currentGroup - 1, 33);
        }
    }

    static void RefreshSelectCapabilities() {
        int n;
        _selectedUnitsCapabilities = 0;
        _sovietHeroPointer = -1;
        int n2 = 0;
        for (n = 0; n < 64; ++n) {
            Entity entity;
            if (Level._entities_usage[n] != 1 || (entity = Level.GetEntityUnsafe(n)) == null) continue;
            Unit unit = (Unit)entity;
            if (unit._life <= 0 || !unit._bSelected) continue;
            _selectedUnitsCapabilities |= unit._attack_capabilities;
            if (unit._subtype == 5) {
                _sovietHeroPointer = unit.GetPointer();
            }
            n2 |= 1 << unit._group;
            _bUnitsSelected = true;
        }
        if (Level._b_tower_defense) {
            _selectedUnitsCapabilities &= 0xFFFFFFFD;
            _selectedUnitsCapabilities &= 0xFFFFFFFB;
        }
        n = 0;
        for (int i = 0; i < 3; ++i) {
            if ((n2 & 1 << i) == 0) continue;
            ++n;
        }
        _cursor_group = n == 1 && (n2 & 4) != 0 ? 2 : 1;
    }

    static boolean CheckCapability(int n) {
        return (_selectedUnitsCapabilities & n) != 0;
    }

    static {
        _cursorRect = new int[4];
    }
}

