/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Debug;
import com.ea.game.Encyclopedia;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Lights;
import com.ea.game.Map;
import com.ea.game.MasterAI;
import com.ea.game.Menu;
import com.ea.game.Pathfinder;
import com.ea.game.Script;
import com.ea.game.SpriteConstants;
import com.ea.game.Sprites;
import com.ea.game.Tutorial;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.UtilEntity;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Level
implements Constants,
GraphicsConstants,
BuildingConstants,
UnitsConstants,
SpriteConstants {
    public static final short[] _levels = new short[]{153, 156, 174, 159, 162, 165, 168, 171, 177, 180, 183, 186, 189, 192, 195, 198, 201, 204, 207};
    public static final short[] _level_maps = new short[]{151, 154, 172, 157, 160, 163, 166, 169, 175, 178, 181, 184, 187, 190, 193, 196, 199, 202, 205};
    public static final short[] _level_coll = new short[]{152, 155, 173, 158, 161, 164, 167, 170, 176, 179, 182, 185, 188, 191, 194, 197, 200, 203, 206};
    public static int _crt_level = -1;
    static int _player_faction;
    static int _ai_faction;
    public static int _player_sk_faction;
    public static int _ai_sk_faction;
    public static boolean _b_skirmish;
    public static boolean _b_tower_defense;
    static int _player_power;
    static int _player_consumption;
    static int _player_money;
    static int _player_command_points;
    static int _player_max_command_points;
    static int _player_build_points;
    static int _player_max_build_points;
    static int _ai_power;
    static int _ai_consumption;
    static int _ai_money;
    static int _ai_command_points;
    static int _ai_max_command_points;
    static int _ai_build_points;
    static int _ai_max_build_points;
    public static int _buildings_restricted;
    public static int _units_restricted;
    public static int _sw_restricted;
    static int _currentGroup;
    static int[] _groupLeaders;
    static int _level_timer;
    static long _last_time;
    static int _timeline_counter;
    static int _paused;
    public static int[] _statistics;
    public static int _unlock_now;
    public static boolean _bCanSkipMovie;
    public static int _skipMovieState;
    public static boolean _bMovieSkipped;
    public static int _flagGreenX;
    public static int _flagGreenY;
    public static int _flagYellowX;
    public static int _flagYellowY;
    static Entity[] _entities;
    static byte[] _entities_usage;
    public static int[] _entities_no;
    public static short[][] _buildings_off_times;
    static int _lastSpawnedIndex;
    static byte[] _fixed_ent_data;
    static short[] _fixed_ent_list;
    static int _fixedListPointer;
    static int _fixedDataPointer;
    static int _nrFixedLevelEntities;
    static int _lastCellOffset;
    static int _nClipCellX;
    static int _nClipCellY;
    static int _nClipCellX2;
    static int _nClipCellY2;
    static int[] _fixed_w_array;
    static int[] _fixed_clip_array;
    static int _fixed_clip_count;
    static int[] _dynamic_w_array;
    static int[] _dynamic_entities_clip;
    static int _dynamic_entities_clip_count;
    static short[] _building_stats_allied;
    static short[] _building_stats_soviets;
    static byte[] _bullet_stats;
    static short[] _unit_stats;
    static byte[] _attack_priorities;
    static byte[] _firing_positions;
    static short[] _sw_stats;
    static short[] _level_stats;
    static int _firingOffsetX;
    static int _firingOffsetY;
    static short[] _cmaps_header;
    static byte[][] _cmaps;
    static final int FOW_LU = 1;
    static final int FOW_U = 2;
    static final int FOW_RU = 4;
    static final int FOW_L = 8;
    static final int FOW_R = 16;
    static final int FOW_LD = 32;
    static final int FOW_D = 64;
    static final int FOW_RD = 128;
    static final int FOG_CELL_W = 16;
    static final int FOG_CELL_H = 16;
    static byte[] _fogtable;
    static SDKImage _fogtiles;
    static int _gravity_center_X;
    static int _gravity_center_Y;
    static int _chrono_units_count;
    static int _chrono_state;
    static int _chrono_timer;
    static int _chrono_destx;
    static int _chrono_desty;
    static int _chrono_radius;
    static boolean _bSWChronoActive;

    static void InitLevel() {
        Map.CDB_Invalidator_Init();
        _currentGroup = 1;
        _unlock_now = 0;
        _entities_no = new int[84];
        _buildings_off_times = new short[3][10];
        _bCanSkipMovie = false;
        _skipMovieState = 0;
        _bMovieSkipped = false;
        _flagYellowY = -1;
        _flagYellowX = -1;
        _flagGreenY = -1;
        _flagGreenX = -1;
    }

    static void ClearLevel() {
        MasterAI.AI_Clean();
        Level.ClearOffTimes();
        Level.ClearStatistics();
        Map.ClearTileMap();
        Map.ClearCollisionMap();
        Utils.Clear_Fade();
        Hud.Reset();
        Level.ClearEntities();
        UtilEntity.Triggers_Clean();
        UtilEntity.WayPoints_Clean();
        UtilEntity.BuildSpots_Clean();
        UtilEntity.Objectives_Clean();
        Script.Scripts_Clean();
        Tutorial.Tutorials_Clean();
        Utils.SnowClean();
    }

    static void ClearOffTimes() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 10; ++j) {
                Level._buildings_off_times[i][j] = 0;
            }
        }
    }

    static void ClearStatistics() {
        for (int i = 0; i < 10; ++i) {
            Level._statistics[i] = 0;
        }
    }

    static void UpdateOffTimes() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (_buildings_off_times[i][j] <= 0) continue;
                short[] sArray = _buildings_off_times[i];
                int n = j;
                sArray[n] = (short)(sArray[n] - 1);
            }
        }
    }

    static void LoadLevel(int n, int n2) {
        System.gc();
        _bCanSkipMovie = false;
        _skipMovieState = 0;
        _bMovieSkipped = false;
        if (n2 == 0) {
            int n3;
            if (n < 0 || n >= 19) {
                _crt_level = -1;
                return;
            }
            _last_time = GameImpl._canvas.getAppTime();
            _level_timer = 0;
            _timeline_counter = 0;
            Level.ClearLevel();
            GameImpl.DisableCheat(2);
            GameImpl.DisableCheat(1);
            GameImpl.DisableCheat(4);
            Map.LoadTileMap(_level_maps[n]);
            Map.LoadCollisionMap(_level_coll[n]);
            if (_b_skirmish) {
                _player_faction = _player_sk_faction == 2 ? ((n3 = Utils.randomInt()) % 2 == 0 ? 0 : 1) : _player_sk_faction;
                _ai_faction = _ai_sk_faction == 2 ? ((n3 = Utils.randomInt()) % 2 == 0 ? 0 : 1) : _ai_sk_faction;
            } else {
                _player_faction = Level.GetLevelStats(n, 0);
                _ai_faction = Level.GetLevelStats(n, 1);
            }
            _currentGroup = 0;
            Hud._hud_current_squad = 1;
            for (n3 = 0; n3 < 84; ++n3) {
                Level._entities_no[n3] = 0;
            }
            Level.Groups_Init();
            _player_power = 0;
            _player_consumption = 0;
            _ai_power = 0;
            _ai_consumption = 0;
            _player_money = Level.GetLevelStats(n, 2);
            _ai_money = Level.GetLevelStats(n, 3);
            _player_command_points = 0;
            _player_build_points = 0;
            _ai_command_points = 0;
            _ai_build_points = 0;
            _player_max_command_points = Level.GetLevelStats(n, 4);
            _ai_max_command_points = Level.GetLevelStats(n, 5);
            _player_max_build_points = Level.GetLevelStats(n, 6);
            _ai_max_build_points = Level.GetLevelStats(n, 7);
            _buildings_restricted = Level.GetLevelStats(n, 13) & 0xFFFF;
            _units_restricted = Level.GetLevelStats(n, 14) & 0xFFFF;
            _sw_restricted = Level.GetLevelStats(n, 15) & 0xFFFF;
            Hud.Init();
            Pathfinder.Init();
            Level.LoadEntities(_levels[n]);
            SDKInputStream.purgeCache();
            System.gc();
            if (_b_skirmish) {
                for (n3 = 64; n3 < 160; ++n3) {
                    if (_entities_usage[n3] != 1) continue;
                    Building building = (Building)_entities[n3];
                    if (building._allegiance == 0) {
                        building._faction = (byte)_player_faction;
                    }
                    if (building._allegiance != 1) continue;
                    building._faction = (byte)_ai_faction;
                }
            }
            for (n3 = 0; n3 < 416; ++n3) {
                if (_entities_usage[n3] != 1) continue;
                _entities[n3].Init();
            }
            GameImpl._loadingStatus = 1;
            Sprites.MarkSprites();
            Sprites.unLoadSplash();
            return;
        }
        if (n2 == 1 && _b_skirmish) {
            Script.Scripts_Release();
            Script.Scripts_Init(_crt_level);
            Script.LoadScripts(_crt_level);
        }
        if (n2 <= 8) {
            Sprites.LoadSprites();
            ++GameImpl._loadingStatus;
            return;
        }
        if (n2 == 9) {
            int n4;
            XSprite xSprite = Sprites._sprites[11];
            xSprite.SetCurrentPalette(0);
            for (n4 = 0; n4 < 416; ++n4) {
                if (_entities_usage[n4] != 1) continue;
                _entities[n4].Init2();
            }
            MasterAI._AI_defend = true;
            MasterAI._AI_run_script = true;
            Camera.ResetCamera();
            Cursor.InitCursor();
            Camera.SetState(0);
            Script.StartScript(Level.GetLevelStats(n, 8), 0, 0, 0, 0);
            n4 = Level.GetLevelStats(n, 9);
            if (!_b_tower_defense) {
                if (_b_skirmish) {
                    int n5 = Utils.randomInt();
                    n4 = _ai_faction == 0 ? (n5 % 2 == 0 ? (n4 += 0) : ++n4) : (n5 % 2 == 0 ? (n4 += 2) : (n4 += 3));
                }
                MasterAI._AI_script_instance = Script.StartAIScript(n4, 0, 0, 0, 0);
            }
            _crt_level = n;
            Map._bResetCDB = true;
            if (Level.Group_GetLeader(1) != -1) {
                _currentGroup = 1;
            } else if (Level.Group_GetLeader(2) != -1) {
                _currentGroup = 2;
            }
            Unit unit = (Unit)Level.GetEntitySafe(Level.Group_GetLeader(_currentGroup));
            if (unit != null) {
                int n6 = unit._pos_x - (GameImpl.SV_W >> 1);
                int n7 = unit._pos_y - (GameImpl.SV_H >> 1);
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 > Map._map_w - GameImpl.SV_W) {
                    n6 = Map._map_w - GameImpl.SV_W;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n7 > Map._map_h - GameImpl.SV_H) {
                    n7 = Map._map_h - GameImpl.SV_H;
                }
                Camera.DoScroll(n6, n7);
                Camera._nCamX = n6;
                Camera._nCamY = n7;
                int n8 = Cursor._nCursorPosX - n6;
                int n9 = Cursor._nCursorPosY - n7;
                Cursor._nCursorPosX = Camera._nCamX + n8;
                Cursor._nCursorPosY = Camera._nCamX + n9;
                Cursor.SelectCurrentGroup();
                SDKCanvas.disableInput(1);
            }
            GameImpl._loadingStatus = 10;
        }
        Hud._minimap_state = Level.GetEntityNo(6, 8, 0) > 0 ? 1 : 4;
        Level.RandomAnimation();
        System.gc();
        Level.FOW_DiscoverPixels(0, 0, Map._map_w, Map._map_h);
    }

    public static void RandomAnimation() {
        for (int i = 64; i < 416; ++i) {
            XSprite xSprite;
            if (_entities_usage[i] != 1 || Level._entities[i]._sprite <= 0 || (xSprite = Sprites._sprites[Level._entities[i]._sprite]).GetAnimLength(Level._entities[i]._crt_anim) <= 0) continue;
            Level._entities[i]._crt_aframe = (short)Utils.random(0, xSprite.GetAnimLength(Level._entities[i]._crt_anim));
        }
    }

    static void LoadEntities(int n) {
        try {
            int n2 = Map._map_vcell_w * Map._map_vcell_h;
            _fixed_ent_data = null;
            _fixed_ent_list = null;
            System.gc();
            _fixed_ent_data = new byte[5000];
            _fixed_ent_list = new short[(n2 * 2 + 1000) * 2];
            Utils.MemSet(_fixed_ent_list, (short)-1);
            _fixedDataPointer = 0;
            _fixedListPointer = n2 * 2;
            SDKInputStream sDKInputStream = null;
            try {
                sDKInputStream = new SDKInputStream(n);
                block12: while (sDKInputStream.available() > 0) {
                    int n3 = sDKInputStream.read() & 0xFF;
                    if (Level.IsFixedEntity(n3)) {
                        Level.LoadFixedEntity(sDKInputStream, n3);
                        ++_nrFixedLevelEntities;
                        continue;
                    }
                    switch (n3) {
                        case 101: {
                            Lights.LoadLightMapEntity(sDKInputStream);
                            continue block12;
                        }
                        case 102: {
                            Lights.LoadLightEntity(sDKInputStream);
                            continue block12;
                        }
                        case 108: {
                            UtilEntity.Load_Trigger(sDKInputStream);
                            continue block12;
                        }
                        case 4: {
                            UtilEntity.Load_WayPoint(sDKInputStream);
                            continue block12;
                        }
                        case 12: {
                            UtilEntity.Load_BuildSpot(sDKInputStream);
                            continue block12;
                        }
                        case 116: {
                            Pathfinder.Region_Load(sDKInputStream);
                            continue block12;
                        }
                    }
                    Entity entity = Level.SpawnEntity(n3);
                    entity.Load(sDKInputStream);
                }
            }
            catch (Exception exception) {
                Debug.CatchException("Exception on LoadEntities:", exception);
            }
            sDKInputStream.close();
            SDKInputStream.purgeCache();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadEntities:", exception);
        }
    }

    public static boolean _stillAttacking() {
        int n;
        for (n = 0; n < 64; ++n) {
            if (_entities_usage[n] != 1 || ((Unit)Level._entities[n])._targetPointer == -1) continue;
            return true;
        }
        for (n = 160; n < 416; ++n) {
            if (_entities_usage[n] != 1 || Level._entities[n]._type != 110 && Level._entities[n]._type != 111 && Level._entities[n]._type != 115 && Level._entities[n]._type != 106) continue;
            return true;
        }
        return false;
    }

    public static void SoundSwitch() {
        if (Hud._hud_bars_hight > 0) {
            return;
        }
        if (Utils._fadeCounter > 0) {
            return;
        }
        if (GameImpl._soundFadeTimer != 21) {
            GameImpl._lastAttackSoundFrame = GameImpl._frameCounter;
            GameImpl._firstAttackFrame = GameImpl._frameCounter;
            GameImpl._attackSoundPlayed = true;
            GameImpl._constructionSoundPlayed = false;
            GameImpl._soundFadeTimer = 21;
            return;
        }
        if (GameImpl._constructionSoundPlayed && GameImpl._firstAttackFrame == 0) {
            GameImpl._firstAttackFrame = GameImpl._frameCounter;
            GameImpl._attackSoundPlayed = false;
            GameImpl._constructionSoundPlayed = false;
        } else if (GameImpl._firstAttackFrame > 0 && GameImpl._frameCounter - GameImpl._firstAttackFrame >= 18) {
            GameImpl._attackSoundPlayed = true;
            GameImpl._constructionSoundPlayed = false;
            GameImpl._lastAttackSoundFrame = GameImpl._frameCounter;
            if (GameImpl._soundEnable) {
                GameImpl._soundManager.stopSounds();
                GameImpl._soundManager.playSound(30);
                GameImpl._soundManager.setSoundVolume(GameImpl.soundVolume);
            }
            GameImpl._firstAttackFrame = 0;
        } else if (GameImpl._attackSoundPlayed) {
            GameImpl._lastAttackSoundFrame = GameImpl._frameCounter;
        }
    }

    static void _SoundUpdate() {
        if (Hud._hud_bars_hight > 0) {
            return;
        }
        if (Utils._fadeCounter > 0) {
            return;
        }
        boolean bl = Level._stillAttacking();
        if (bl) {
            Level.SoundSwitch();
        }
        if (GameImpl._soundFadeTimer == 0 || GameImpl._soundFadeTimer >= 0 && GameImpl._soundFadeTimer != 21 && GameImpl._attackSoundPlayed) {
            GameImpl._attackSoundPlayed = false;
            GameImpl._constructionSoundPlayed = true;
            GameImpl._lastAttackSoundFrame = 0;
            GameImpl._soundManager.stopSounds();
            if (GameImpl._soundEnable) {
                GameImpl._soundManager.playSound(29);
                GameImpl._soundManager.setSoundVolume(GameImpl.soundVolume);
            }
            ++GameImpl._soundFadeTimer;
            return;
        }
        if (GameImpl._soundFadeTimer != 21) {
            ++GameImpl._soundFadeTimer;
            return;
        }
        if (GameImpl._attackSoundPlayed) {
            if (GameImpl._frameCounter - GameImpl._lastAttackSoundFrame > 37 && !bl) {
                GameImpl._soundFadeTimer = -20;
            }
        } else if (bl) {
            Level.SoundSwitch();
        } else if (GameImpl._frameCounter - GameImpl._firstAttackFrame == 18) {
            GameImpl._constructionSoundPlayed = true;
            GameImpl._firstAttackFrame = 0;
        }
    }

    static void UpdateLevel() {
        if (_skipMovieState > 0) {
            Level.UpdateSkipMovie();
            return;
        }
        if (_b_tower_defense && SDKCanvas.isNewKeyPressed(256)) {
            int n;
            int n2 = 0;
            for (n = 0; n < 15; ++n) {
                n2 += Level.GetEntityNo(5, n, 1);
            }
            if (n2 == 0) {
                n = Level.GetLevelStats(_crt_level, 9);
                if (_ai_faction == 1) {
                    ++n;
                }
                Script.KillScripts(n);
                Script.StartScript(n, 0, 0, 0, 0);
            }
        }
        long l = GameImpl._canvas.getAppTime();
        _level_timer = (int)((long)_level_timer + (l - _last_time));
        _last_time = l;
        try {
            Hud.Update();
            Tutorial.Tutorials_Update();
            MasterAI.AI_Update();
            UtilEntity.Update_BuildSpots();
            Camera.UpdateCamera();
            if (_paused == 0) {
                if (GameImpl._soundEnable) {
                    Level._SoundUpdate();
                }
                Level.UpdateEntities();
                Level.UpdateOffTimes();
                ++_timeline_counter;
            }
            UtilEntity.Update_Triggers();
            Script.RunEngine();
            Map.CDB_Update();
            Map.CDB_Invalidator_Update();
            Pathfinder.Update();
            Level.SWChrono_Update();
            Utils.SnowUpdate();
            Utils.Update_Fade();
        }
        catch (Exception exception) {
            Debug.CatchException("Level update", exception);
        }
    }

    static void UpdateEntities() {
        for (int i = 0; i < 416; ++i) {
            if (_entities_usage[i] != 1) continue;
            _entities[i].Update();
        }
    }

    static void DrawLevel(SDKGraphics sDKGraphics) {
        if (Map._bResetCDB) {
            return;
        }
        if (_skipMovieState == 2) {
            return;
        }
        try {
            Constants constants;
            Map.CDB_Draw(sDKGraphics);
            sDKGraphics.setClip(GameImpl.SV_X, GameImpl.SV_Y, GameImpl.SV_W, GameImpl.SV_H);
            Level.DrawEntities(sDKGraphics);
            if (_flagGreenX != -1) {
                constants = Sprites._sprites[13];
                ((XSprite)constants).DrawFrame(113, _flagGreenX, _flagGreenY, 0);
            }
            if (_flagYellowX != -1) {
                constants = Sprites._sprites[13];
                ((XSprite)constants).DrawFrame(114, _flagYellowX, _flagYellowY, 0);
            }
            _flagYellowY = -1;
            _flagYellowX = -1;
            _flagGreenY = -1;
            _flagGreenX = -1;
            sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
            Utils.SnowDraw(sDKGraphics);
            if (GameImpl._useFog) {
                Level.FOW_Draw(sDKGraphics);
            }
            if ((constants = Level.GetEntitySafe(Cursor._targetPointer)) != null) {
                ((Entity)constants).DrawTooltip(sDKGraphics);
            }
            if (Menu._state != 10) {
                Hud.Draw(sDKGraphics);
            }
            Utils.Draw_Fade(sDKGraphics);
        }
        catch (Exception exception) {
            Debug.CatchException("Level paint", exception);
        }
    }

    static void DrawEntities(SDKGraphics sDKGraphics) {
        Entity entity;
        XSprite.SetGraphics(sDKGraphics);
        Level.SetEntityClipWithBorder(Camera._nCamX, Camera._nCamY, GameImpl.SV_W, GameImpl.SV_H);
        Level.ResetFixedEntitiesClipList();
        Level.FindFixedEntitiesInClip(false);
        Utils.QuickSort(_fixed_w_array, _fixed_clip_array, 0, _fixed_clip_count - 1);
        Level.ResetDynamicEntitiesClipList();
        Level.FindDynamicEntitiesInClip();
        Utils.QuickSort(_dynamic_w_array, _dynamic_entities_clip, 0, _dynamic_entities_clip_count - 1);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (_fixed_clip_count > 0 && _dynamic_entities_clip_count > 0) {
            if ((_fixed_w_array[n] & 0xFFFFFFFF) < (_dynamic_w_array[n2] & 0xFFFFFFFF)) {
                Level.DrawFixedEntityFromPackedValue(sDKGraphics, _fixed_clip_array[n], true);
                ++n;
                --_fixed_clip_count;
                continue;
            }
            if (!bl && Level._entities[Level._dynamic_entities_clip[n2]]._type == 5) {
                for (int i = 0; i < 64; ++i) {
                    if (_entities_usage[i] != 1) continue;
                    entity = _entities[i];
                    if (entity._type != 5) continue;
                    ((Unit)entity).DrawSelection(sDKGraphics);
                }
                bl = true;
            }
            try {
                _entities[_dynamic_entities_clip[n2]].Draw(sDKGraphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
            --_dynamic_entities_clip_count;
        }
        while (_fixed_clip_count > 0) {
            Level.DrawFixedEntityFromPackedValue(sDKGraphics, _fixed_clip_array[n], true);
            ++n;
            --_fixed_clip_count;
        }
        while (_dynamic_entities_clip_count > 0) {
            if (!bl && Level._entities[Level._dynamic_entities_clip[n2]]._type == 5) {
                for (int i = 0; i < 64; ++i) {
                    if (_entities_usage[i] != 1) continue;
                    entity = _entities[i];
                    if (entity._type != 5) continue;
                    ((Unit)entity).DrawSelection(sDKGraphics);
                }
                bl = true;
            }
            try {
                _entities[_dynamic_entities_clip[n2]].Draw(sDKGraphics);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
            --_dynamic_entities_clip_count;
        }
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            entity = _entities[i];
            if (entity._type != 5) continue;
            ((Unit)entity).Unit_Draw_Lines(sDKGraphics);
        }
    }

    static void DrawCDBEntities(SDKGraphics sDKGraphics) {
        Level.ResetFixedEntitiesClipList();
        Level.FindFixedEntitiesInClip(true);
        Utils.QuickSort(_fixed_w_array, _fixed_clip_array, 0, _fixed_clip_count - 1);
        for (int i = 0; i < _fixed_clip_count; ++i) {
            Level.DrawFixedEntityFromPackedValue(null, _fixed_clip_array[i], false);
        }
    }

    static void GROUP_MANAGEMENT__() {
    }

    public static void Groups_Init() {
        for (int i = 0; i < 3; ++i) {
            Level._groupLeaders[i] = -1;
        }
    }

    public static void Group_Add(Unit unit, int n) {
        if (unit._allegiance != 0) {
            return;
        }
        unit._group = (byte)n;
        if (n != -1 && n != 0) {
            if (_groupLeaders[n] == -1) {
                Level._groupLeaders[n] = unit.GetPointer();
            }
            if (_currentGroup == n) {
                unit._bSelected = true;
            }
        }
    }

    public static void Group_Remove(Unit unit) {
        if (unit._allegiance != 0) {
            return;
        }
        int n = -1;
        if (unit._group != 0 && _groupLeaders[unit._group] == unit.GetPointer()) {
            n = unit._group;
            Level._groupLeaders[unit._group] = -1;
        }
        if (_currentGroup == unit._group) {
            unit._bSelected = false;
        }
        unit._group = 0;
        if (n != -1) {
            Level.Group_FindNewLeader(n);
        }
    }

    public static void Group_SetToSelection(int n) {
        int n2 = -1;
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (!unit._bSelected) continue;
            if (n != unit._group && unit.GetPointer() == _groupLeaders[unit._group]) {
                n2 = unit._group;
                Level._groupLeaders[unit._group] = -1;
            }
            Level.Group_Add(unit, n);
        }
        if (n2 != -1) {
            Level.Group_FindNewLeader(n2);
        }
    }

    public static void Group_Clear(int n) {
        if (n == 0) {
            return;
        }
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._group != n) continue;
            unit._group = 0;
        }
        Level._groupLeaders[n] = -1;
    }

    public static boolean Group_Select(int n) {
        if (n == 0 || n == -1) {
            _currentGroup = 0;
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._group == n && unit._allegiance == 0 && (unit._flags & 0x400) == 0) {
                unit._bSelected = true;
                bl = true;
                continue;
            }
            unit._bSelected = false;
        }
        _currentGroup = n;
        return bl;
    }

    static int Group_GetLeader(int n) {
        if (n == -1 || n == 0) {
            return -1;
        }
        return _groupLeaders[n];
    }

    static void Group_FindNewLeader(int n) {
        Level._groupLeaders[n] = -1;
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._group != n || unit._allegiance != 0 || unit._life <= 0) continue;
            Level._groupLeaders[n] = unit.GetPointer();
            break;
        }
        if (_groupLeaders[n] == -1 && _currentGroup == n) {
            _currentGroup = 0;
        }
    }

    static void __GROUP_MANAGEMENT() {
    }

    static void SPAWNING__() {
    }

    static Unit SpawnUnit(int n, int n2, int n3, int n4, int n5, byte by) {
        Unit unit = (Unit)Level.SpawnEntity(5);
        if (unit != null) {
            unit._subtype = (byte)n;
            unit._allegiance = (byte)n4;
            unit._pos_x = n2;
            unit._pos_y = n3;
            unit._orientation = (byte)n5;
            unit._group = by;
            unit._veterancy_lvl = 0;
            if (Level.GetEntityNo(13, 1, n4) > 0) {
                unit._veterancy_lvl = (byte)(unit._veterancy_lvl + 1);
            }
            unit.Unit_Init();
            unit.Unit_Init2();
            unit.DoAction(2, -1, n2, n3);
            if ((by == 1 || by == 2) && n4 == 0) {
                Unit unit2 = (Unit)Level.GetEntitySafe(Level.Group_GetLeader(by));
                if (unit2 == null) {
                    Level._groupLeaders[by] = unit.GetPointer();
                    unit2 = unit;
                }
                if (unit2 != unit) {
                    int n6 = unit2._pos_x;
                    int n7 = unit2._pos_y;
                    if (unit2._path_cursor > 0) {
                        n6 = unit2._waypoints[0] * 8;
                        n7 = unit2._waypoints[1] * 8;
                    }
                    unit.DoAction(2, -1, n6, n7);
                }
            }
        }
        return unit;
    }

    static Building SpawnBuilding(int n, int n2, int n3, int n4, int n5) {
        Building building = (Building)Level.SpawnEntity(6);
        if (building != null) {
            building._subtype = (byte)n;
            building.SetPosition(n2, n3);
            building._allegiance = (byte)n4;
            building._faction = (byte)n5;
            building.Building_Init();
            building.Building_Init2();
            int n6 = 0;
            if (_player_faction == 1) {
                n6 = 10;
            }
            byte[] byArray = Level.GetCMap(n6 + n);
            int n7 = Level.GetCMapHeaderData(n6 + n, 0);
            int n8 = Level.GetCMapHeaderData(n6 + n, 1);
            int n9 = Level.GetCMapHeaderData(n6 + n, 2);
            int n10 = Level.GetCMapHeaderData(n6 + n, 3);
            int n11 = (n2 + n7) / 8;
            int n12 = (n3 + n8) / 8;
            int n13 = n11 * 8;
            int n14 = n12 * 8;
            int n15 = 0;
            int n16 = 0;
            n3 = 0;
            while (n3 < n10) {
                n15 = n13;
                n2 = 0;
                while (n2 < n9) {
                    if (byArray[n16] == 12) {
                        int n17 = (n11 + n2) * 8;
                        int n18 = (n12 + n3) * 8;
                        for (int i = 0; i < 64; ++i) {
                            if (_entities_usage[i] != 1) continue;
                            Unit unit = (Unit)_entities[i];
                            if (unit._life <= 0 || unit._pos_x <= n17 - 8 || unit._pos_x >= n17 + 8 + 8 || unit._pos_y <= n18 - 8 || unit._pos_y >= n18 + 8 + 8) continue;
                            unit.Unit_Jump_From_Collision();
                        }
                    }
                    ++n2;
                    n15 += 8;
                    ++n16;
                }
                ++n3;
                n14 += 8;
            }
        }
        return building;
    }

    static Entity SpawnIGMessage(int n, int n2, int n3, int n4, int n5, int n6) {
        Entity entity = Level.SpawnEntity(105);
        if (entity != null) {
            entity.IGMessage_Init(n, n2, n3, n4, n5, n6);
        }
        return entity;
    }

    static Building FindSpawnBuilding(int n, int n2) {
        for (int i = 64; i < 160; ++i) {
            if (_entities_usage[i] != 1) continue;
            Building building = (Building)_entities[i];
            if (building._allegiance != n2 || (building._spawn_unit_types & 1 << n) == 0) continue;
            return building;
        }
        return null;
    }

    static void __SPAWNING() {
    }

    static void Debug_DrawCollisionMapLayer(SDKGraphics sDKGraphics) {
        int n = Camera._nCamX / 8;
        int n2 = Camera._nCamY / 8;
        int n3 = (Camera._nCamX + GameImpl.SV_W + 7) / 8;
        int n4 = (Camera._nCamY + GameImpl.SV_H + 7) / 8;
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                int n5 = Map.GetCollisionAt(j * 8, i * 8);
                int n6 = 0;
                if (n5 == 0) {
                    n6 = 0x3300FF00;
                } else if (n5 == 1) {
                    n6 = 0x33FF0000;
                } else if (n5 == 2) {
                    n6 = 0x330000FF;
                } else if (n5 == 3) {
                    n6 = 0x33FF00FF;
                }
                Utils.FillRect(sDKGraphics, n6, j * 8 - Camera._nCamX, i * 8 - Camera._nCamY, 8, 8);
            }
        }
    }

    static void ENTITIES__() {
    }

    static void InitEntities() {
        _entities_usage = new byte[416];
        _entities = new Entity[416];
        int n = 0;
        for (n = 0; n < 64; ++n) {
            Level._entities[n] = new Unit(n);
            Level._entities_usage[n] = 0;
        }
        for (n = 64; n < 160; ++n) {
            Level._entities[n] = new Building(n);
            Level._entities_usage[n] = 0;
        }
        for (n = 160; n < 416; ++n) {
            Level._entities[n] = new Entity(n);
            Level._entities_usage[n] = 0;
        }
    }

    static void ReleaseEntities() {
        _entities_usage = null;
        for (int i = 0; i < 416; ++i) {
            Level._entities[i] = null;
        }
        _entities = null;
        System.gc();
    }

    static void ClearEntities() {
        Entity entity;
        int n;
        for (n = 0; n < 64; ++n) {
            if (_entities_usage[n] != 1) continue;
            Level._entities_usage[n] = 0;
            entity = (Unit)_entities[n];
            ((Unit)entity).Clean();
        }
        for (n = 64; n < 160; ++n) {
            if (_entities_usage[n] != 1) continue;
            Level._entities_usage[n] = 0;
            entity = (Building)_entities[n];
            ((Building)entity).Clean();
        }
        for (n = 160; n < 416; ++n) {
            Level._entities_usage[n] = 0;
            _entities[n].Release();
        }
    }

    static int GetUnusedEntityIndex(int n) {
        if (n == 5) {
            for (int i = 0; i < 64; ++i) {
                if (_entities_usage[i] != 0) continue;
                return i;
            }
        } else if (n == 6) {
            for (int i = 64; i < 160; ++i) {
                if (_entities_usage[i] != 0) continue;
                return i;
            }
        } else {
            int n2 = -1;
            for (int i = 160; i < 416; ++i) {
                if (_entities_usage[i] != 0) continue;
                if (n2 == -1) {
                    n2 = i;
                }
                if (Level._entities[i]._type != n) continue;
                return i;
            }
            return n2;
        }
        return -1;
    }

    static Entity GetEntityUnsafe(int n) {
        return _entities[n];
    }

    static Entity GetEntitySafe(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n & 0xFFFF;
        if (_entities_usage[n2] == 1 && Level._entities[n2]._uid == n >> 16) {
            return _entities[n2];
        }
        return null;
    }

    static Entity GetEntityById(int n, int n2) {
        int n3;
        if (n2 == -1) {
            return null;
        }
        if (n == -1 || n == 5) {
            for (n3 = 0; n3 < 64; ++n3) {
                if (_entities_usage[n3] != 1 || Level._entities[n3]._id != n2) continue;
                return _entities[n3];
            }
        }
        if (n == -1 || n == 6) {
            for (n3 = 64; n3 < 160; ++n3) {
                if (_entities_usage[n3] != 1 || Level._entities[n3]._id != n2) continue;
                return _entities[n3];
            }
        }
        for (n3 = 160; n3 < 416; ++n3) {
            if (_entities_usage[n3] != 1 || Level._entities[n3]._id != n2) continue;
            return _entities[n3];
        }
        return null;
    }

    static void DeleteEntity(int n) {
        Level.DeleteEntity(Level.GetEntitySafe(n));
    }

    static void DeleteEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        int n = entity.GetPointer();
        short s = entity._arrayIndex;
        if (Cursor._targetPointer == n) {
            Cursor._targetPointer = -1;
        }
        if (entity._type == 5) {
            byte by;
            Unit unit = (Unit)entity;
            if (unit._group > 0 && unit._allegiance == 1 && MasterAI._AI_groups[by = unit._group][0] > 0) {
                int[] nArray = MasterAI._AI_groups[by];
                nArray[0] = nArray[0] - 1;
            }
        }
        Level._entities_usage[s] = 0;
        entity.EntityDestructor();
        if ((entity._flags & 0x1000) != 0) {
            Level.DeleteFixedEntity(entity);
        }
    }

    static Entity SpawnEntity(int n) {
        int n2 = Level.GetUnusedEntityIndex(n);
        if (n2 < 0) {
            return null;
        }
        _lastSpawnedIndex = n2;
        Entity entity = _entities[n2];
        entity._uid = Entity.GetGlobalUID();
        entity.EntityConstructor(n);
        Level._entities_usage[n2] = 1;
        return entity;
    }

    public static void IncEntityNo(int n, int n2, int n3) {
        if (n == 6) {
            int n4 = n3 * 28 + (15 + n2);
            _entities_no[n4] = _entities_no[n4] + 1;
        } else if (n == 5) {
            int n5 = n3 * 28 + (0 + n2);
            _entities_no[n5] = _entities_no[n5] + 1;
        } else if (n == 13) {
            int n6 = n3 * 28 + (25 + n2);
            _entities_no[n6] = _entities_no[n6] + 1;
        }
    }

    public static void DecEntityNo(int n, int n2, int n3) {
        if (n == 6) {
            int n4 = n3 * 28 + (15 + n2);
            _entities_no[n4] = _entities_no[n4] - 1;
        } else if (n == 5) {
            int n5 = n3 * 28 + (0 + n2);
            _entities_no[n5] = _entities_no[n5] - 1;
        } else if (n == 13) {
            int n6 = n3 * 28 + (25 + n2);
            _entities_no[n6] = _entities_no[n6] - 1;
        }
    }

    public static int GetEntityNo(int n, int n2, int n3) {
        if (n == 6) {
            return _entities_no[n3 * 28 + (15 + n2)];
        }
        if (n == 5) {
            return _entities_no[n3 * 28 + (0 + n2)];
        }
        if (n == 13) {
            return _entities_no[n3 * 28 + (25 + n2)];
        }
        return -1;
    }

    static void __ENTITIES() {
    }

    static void FIXED_ENTITIES__() {
    }

    static boolean IsFixedEntity(int n) {
        return n == 0 || n == 8 || n == 9;
    }

    static boolean IsCDBEntity(Entity entity) {
        if (entity._z_order > 2) {
            return false;
        }
        return entity._type == 0 || entity._type == 8 || entity._type == 9;
    }

    static int AddFixedEntity(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 & 0xC7 | (n6 & 7) << 3;
        int n8 = _fixedDataPointer;
        Level._fixed_ent_data[n8 + 0] = (byte)(n7 & 0xFF);
        Level._fixed_ent_data[n8 + 1] = (byte)(n & 0x3F);
        Level._fixed_ent_data[n8 + 2] = (byte)(n2 & 0x3F);
        Level._fixed_ent_data[n8 + 3] = (byte)n3;
        Level._fixed_ent_data[n8 + 4] = (byte)n4;
        _fixedDataPointer += 5;
        _lastCellOffset = (n2 >> 6) * Map._map_vcell_w + (n >> 6) << 1;
        return Level.AddFixedEntityToList(_lastCellOffset, n8);
    }

    static int AddFixedCustomEntity(Entity entity) {
        short s = entity._arrayIndex;
        int n = s >> 8 & 0xFF;
        int n2 = s & 0xFF;
        int n3 = 128;
        entity._flags |= 0x1000;
        if (Level.IsCDBEntity(entity)) {
            entity._flags |= 0x2000;
            n3 |= 0x40;
        }
        return Level.AddFixedEntity(entity._pos_x, entity._pos_y, n, n2, n3, entity._z_order);
    }

    static int AddFixedCustomEntity(int n) {
        Entity entity = Level.GetEntityUnsafe(n);
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        int n4 = 128;
        entity._flags |= 0x1000;
        if (Level.IsCDBEntity(entity)) {
            entity._flags |= 0x2000;
            n4 |= 0x40;
        }
        return Level.AddFixedEntity(entity._pos_x, entity._pos_y, n2, n3, n4, entity._z_order);
    }

    static int AddFixedEntityToList(int n, int n2) {
        Level._fixed_ent_list[Level._fixedListPointer + 0] = -1;
        Level._fixed_ent_list[Level._fixedListPointer + 1] = (short)n2;
        short s = _fixed_ent_list[n + 0];
        short s2 = _fixed_ent_list[n + 1];
        if (s == -1) {
            Level._fixed_ent_list[n + 0] = (short)_fixedListPointer;
        }
        if (s2 != -1) {
            Level._fixed_ent_list[s2 + 0] = (short)_fixedListPointer;
        }
        Level._fixed_ent_list[n + 1] = (short)_fixedListPointer;
        return (_fixedListPointer += 2) - 2;
    }

    static void DeleteFixedEntity(Entity entity) {
        Level.DeleteFixedEntity(entity._arrayIndex);
    }

    static void DeleteFixedEntity(int n) {
    }

    static void LoadFixedEntity(SDKInputStream sDKInputStream, int n) throws IOException {
        if (n == 0) {
            Level.LoadStaticDecorator(sDKInputStream);
        } else {
            Level.LoadFixedCustomEntity(sDKInputStream, n);
        }
    }

    static void LoadStaticDecorator(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        int n = sDKInputStream.read();
        int n2 = sDKInputStream.read();
        int n3 = sDKInputStream.read() & 0xFF;
        int n4 = sDKInputStream.read() & 0xFF;
        if (n4 <= 2) {
            n3 |= 0x40;
        }
        Level.AddFixedEntity(s2, s3, n, n2, n3, n4);
    }

    static void LoadFixedCustomEntity(SDKInputStream sDKInputStream, int n) throws IOException {
        Entity entity = Level.SpawnEntity(n);
        entity.Load(sDKInputStream);
        Level.AddFixedCustomEntity(entity);
    }

    static void SetEntityClipWithBorder(int n, int n2, int n3, int n4) {
        _nClipCellX = n - 70 >> 6;
        _nClipCellY = n2 - 53 >> 6;
        _nClipCellX2 = n + n3 + 93 >> 6;
        _nClipCellY2 = n2 + n4 + 100 >> 6;
        if (_nClipCellX < 0) {
            _nClipCellX = 0;
        }
        if (_nClipCellY < 0) {
            _nClipCellY = 0;
        }
        if (_nClipCellX2 >= Map._map_vcell_w) {
            _nClipCellX2 = Map._map_vcell_w - 1;
        }
        if (_nClipCellY2 >= Map._map_vcell_h) {
            _nClipCellY2 = Map._map_vcell_h - 1;
        }
    }

    static void SetEntityClip(int n, int n2, int n3, int n4) {
        _nClipCellX = n >> 6;
        _nClipCellY = n2 >> 6;
        _nClipCellX2 = n + n3 >> 6;
        _nClipCellY2 = n2 + n4 >> 6;
        if (_nClipCellX < 0) {
            _nClipCellX = 0;
        }
        if (_nClipCellY < 0) {
            _nClipCellY = 0;
        }
        if (_nClipCellX2 >= Map._map_vcell_w) {
            _nClipCellX2 = Map._map_vcell_w - 1;
        }
        if (_nClipCellY2 >= Map._map_vcell_h) {
            _nClipCellY2 = Map._map_vcell_h - 1;
        }
    }

    static void ResetFixedEntitiesClipList() {
        _fixed_clip_count = 0;
    }

    static void FindFixedEntitiesInClip(boolean bl) {
        for (int i = _nClipCellY; i <= _nClipCellY2; ++i) {
            for (int j = _nClipCellX; j <= _nClipCellX2; ++j) {
                int n = (i * Map._map_vcell_w + j) * 2;
                short s = _fixed_ent_list[n + 0];
                while (s != -1) {
                    short s2 = _fixed_ent_list[s + 1];
                    byte by = _fixed_ent_data[s2 + 0];
                    int n2 = by >> 3 & 7;
                    int n3 = 0;
                    int n4 = 0;
                    if (bl && (by & 0x40) != 0) {
                        n3 = (n2 & 7) << 16 | s2;
                    } else if (!bl && (by & 0x40) == 0) {
                        int n5 = (j << 6) + _fixed_ent_data[s2 + 1];
                        int n6 = (i << 6) + _fixed_ent_data[s2 + 2];
                        n3 = (n2 & 7) << 24 | (n6 & 0xFFF) << 12 | n5 & 0xFFF;
                    } else {
                        s = _fixed_ent_list[s + 0];
                        continue;
                    }
                    n4 = (i & 0xFF) << 24 | (j & 0xFF) << 16 | s2 & 0xFFFF;
                    Level._fixed_w_array[Level._fixed_clip_count] = n3;
                    Level._fixed_clip_array[Level._fixed_clip_count] = n4;
                    ++_fixed_clip_count;
                    s = _fixed_ent_list[s + 0];
                }
            }
        }
    }

    static void DrawFixedEntityFromPackedValue(SDKGraphics sDKGraphics, int n, boolean bl) {
        int n2 = n & 0xFFFF;
        byte by = _fixed_ent_data[n2 + 0];
        byte by2 = _fixed_ent_data[n2 + 3];
        byte by3 = _fixed_ent_data[n2 + 4];
        if ((by & 0x80) == 0) {
            int n3 = (n >> 24 & 0xFF) << 6;
            int n4 = (n >> 16 & 0xFF) << 6;
            int n5 = (_fixed_ent_data[n2 + 1] & 0xFF) + n4 - Camera._nCamX;
            int n6 = (_fixed_ent_data[n2 + 2] & 0xFF) + n3 - Camera._nCamY;
            if (bl) {
                n5 += GameImpl.SV_X;
                n6 += GameImpl.SV_Y;
            }
            Sprites._sprites[by2].DrawFrame(by3, n5, n6, by & 7);
        } else {
            Level.GetEntityUnsafe((by2 & 0xFF) << 8 | by3 & 0xFF).Draw(sDKGraphics);
        }
    }

    static void ResetDynamicEntitiesClipList() {
        _dynamic_entities_clip_count = 0;
    }

    static void FindDynamicEntitiesInClip() {
        Utils.Rect(Utils._rect, Camera._nCamX - 70, Camera._nCamY - 53, GameImpl.SV_W + 70 + 93, GameImpl.SV_H + 53 + 100);
        for (int i = 0; i < 416; ++i) {
            int n;
            if (_entities_usage[i] != 1) continue;
            Entity entity = _entities[i];
            if ((entity._flags & 0x3000) != 0 || !Utils.PointInRect(Utils._rect, entity._pos_x, entity._pos_y)) continue;
            Level._dynamic_w_array[Level._dynamic_entities_clip_count] = n = (entity._z_order & 7) << 24 | (entity._pos_y & 0xFFF) << 12 | entity._pos_x & 0xFFF;
            Level._dynamic_entities_clip[Level._dynamic_entities_clip_count] = i;
            ++_dynamic_entities_clip_count;
        }
    }

    static void __FIXED_ENTITIES() {
    }

    static void STATS__() {
    }

    static void InitStats() {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(18);
            _building_stats_soviets = null;
            _building_stats_soviets = Utils.ReadShortArray(sDKInputStream, 200, _building_stats_soviets, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            sDKInputStream = new SDKInputStream(19);
            _building_stats_allied = null;
            _building_stats_allied = Utils.ReadShortArray(sDKInputStream, 200, _building_stats_allied, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            _bullet_stats = SDKInputStream.loadResourceAsByteArray(20);
            sDKInputStream = new SDKInputStream(21);
            _unit_stats = null;
            _unit_stats = Utils.ReadShortArray(sDKInputStream, 420, _unit_stats, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            _attack_priorities = SDKInputStream.loadResourceAsByteArray(22);
            System.gc();
            _firing_positions = SDKInputStream.loadResourceAsByteArray(23);
            System.gc();
            sDKInputStream = new SDKInputStream(24);
            _sw_stats = null;
            _sw_stats = Utils.ReadShortArray(sDKInputStream, 165, _sw_stats, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            sDKInputStream = new SDKInputStream(25);
            _level_stats = null;
            _level_stats = Utils.ReadShortArray(sDKInputStream, 323, _level_stats, 0);
            sDKInputStream.close();
            sDKInputStream = null;
            SDKInputStream.purgeCache();
            System.gc();
        }
        catch (IOException iOException) {
            Debug.CatchException("IO exception while loading levels stats", iOException);
        }
    }

    public static int GetBulletStats(int n, int n2) {
        return _bullet_stats[n * 8 + n2];
    }

    public static int GetBuildingStats(int n, int n2, int n3) {
        short[] sArray = n == 0 ? _building_stats_soviets : _building_stats_allied;
        return sArray[n2 * 20 + n3];
    }

    public static void SetBuildingStats(int n, int n2, int n3, int n4) {
        short[] sArray = n == 0 ? _building_stats_soviets : _building_stats_allied;
        sArray[n2 * 20 + n3] = (byte)n4;
    }

    public static int GetUnitStats(int n, int n2) {
        return _unit_stats[n * 28 + n2];
    }

    public static int GetSWStats(int n, int n2) {
        return _sw_stats[n * 11 + n2];
    }

    public static int GetLevelStats(int n, int n2) {
        return _level_stats[n * 17 + n2];
    }

    public static void GetBuildingFiringPosition(int n, int n2, int n3) {
        int n4 = 0;
        switch (n) {
            case 6: {
                n4 = 5;
                break;
            }
            case 5: {
                n4 = n2 == 0 ? 6 : 19;
            }
        }
        _firingOffsetX = _firing_positions[(n4 << 4) + (n3 << 1)];
        _firingOffsetY = _firing_positions[(n4 << 4) + (n3 << 1) + 1];
    }

    static void GetUnitFiringPosition(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 7;
                break;
            }
            case 6: {
                n3 = 8;
                break;
            }
            case 7: {
                n3 = 9;
                break;
            }
            case 8: {
                n3 = Utils.random(2) == 0 ? 10 : 11;
                break;
            }
            case 9: {
                n3 = 12;
                break;
            }
            case 10: {
                n3 = 13;
                break;
            }
            case 11: {
                n3 = 14;
                break;
            }
            case 13: {
                n3 = 17;
                break;
            }
            case 12: {
                n3 = 15;
                break;
            }
            case 14: {
                n3 = 18;
            }
        }
        _firingOffsetX = _firing_positions[(n3 << 4) + (n2 << 1)];
        _firingOffsetY = _firing_positions[(n3 << 4) + (n2 << 1) + 1];
    }

    static void __STATS() {
    }

    static void BUILDING_CMAP__() {
    }

    static void InitCMaps() {
        for (int i = 0; i < 23; ++i) {
            Level.LoadCMap(348 + i, i);
        }
        SDKInputStream.purgeCache();
        System.gc();
    }

    static int GetCMapHeaderData(int n, int n2) {
        return _cmaps_header[n * 4 + n2];
    }

    static void LoadCMap(int n, int n2) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            short s = sDKInputStream.readShort();
            short s2 = sDKInputStream.readShort();
            int n3 = sDKInputStream.read() & 0xFF;
            int n4 = sDKInputStream.read() & 0xFF;
            int n5 = n3 * n4;
            int n6 = n2 * 4;
            Level._cmaps_header[n6 + 0] = s;
            Level._cmaps_header[n6 + 1] = s2;
            Level._cmaps_header[n6 + 2] = (short)n3;
            Level._cmaps_header[n6 + 3] = (short)n4;
            Level._cmaps[n2] = new byte[n5];
            byte[] byArray = Level._cmaps[n2];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n4) {
                boolean bl = true;
                for (int i = 0; i < n3; ++i) {
                    if (bl) {
                        n8 = sDKInputStream.read();
                    }
                    bl = !bl;
                    int n10 = n8 & 0xF;
                    byArray[n7 + i] = (byte)n10;
                    n8 >>= 4;
                }
                ++n9;
                n7 += n3;
            }
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadBuildingCollisionMap(" + n2 + "):", exception);
        }
    }

    static byte[] GetCMap(int n) {
        return _cmaps[n];
    }

    static void ApplyCollisionMap(int n, int n2, int n3) {
        int n4 = Level.GetCMapHeaderData(n3, 0);
        int n5 = Level.GetCMapHeaderData(n3, 1);
        int n6 = Level.GetCMapHeaderData(n3, 2);
        int n7 = Level.GetCMapHeaderData(n3, 3);
        byte[] byArray = Level.GetCMap(n3);
        int n8 = (n + n4) / 8;
        int n9 = (n2 + n5) / 8;
        int n10 = n8 * 8;
        int n11 = n9 * 8;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        while (n14 < n7) {
            n12 = n10;
            int n15 = 0;
            while (n15 < n6) {
                if (byArray[n13] != 0) {
                    Map.SetCollisionAtTile(n8 + n15, n9 + n14, byArray[n13]);
                }
                ++n15;
                n12 += 8;
                ++n13;
            }
            ++n14;
            n11 += 8;
        }
    }

    static void EraseCollisionMap(int n, int n2, int n3, int n4) {
        int n5 = Level.GetCMapHeaderData(n3, 0);
        int n6 = Level.GetCMapHeaderData(n3, 1);
        int n7 = Level.GetCMapHeaderData(n3, 2);
        int n8 = Level.GetCMapHeaderData(n3, 3);
        byte[] byArray = Level.GetCMap(n3);
        int n9 = (n + n5) / 8;
        int n10 = (n2 + n6) / 8;
        int n11 = n9 * 8;
        int n12 = n10 * 8;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        while (n15 < n8) {
            n13 = n11;
            int n16 = 0;
            while (n16 < n7) {
                if (byArray[n14] != 0) {
                    Map.SetCollisionAtTile(n9 + n16, n10 + n15, n4);
                }
                ++n16;
                n13 += 8;
                ++n14;
            }
            ++n15;
            n12 += 8;
        }
    }

    static void __BUILDING_CMAP() {
    }

    static void FOG_OF_WAR__() {
    }

    static void FOW_NoAlphaDraw(SDKGraphics sDKGraphics) {
        int n = Camera._nCamX / 32;
        int n2 = Camera._nCamY / 32;
        int n3 = (Camera._nCamX + GameImpl.SV_W) / 32;
        int n4 = (Camera._nCamY + GameImpl.SV_H) / 32;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= Map._map_tw) {
            n3 = Map._map_tw - 1;
        }
        if (n4 >= Map._map_th) {
            n4 = Map._map_th - 1;
        }
        sDKGraphics.setColor(0);
        XSprite xSprite = Sprites._sprites[11];
        int n5 = Map._map_tw << 1;
        int n6 = n2;
        int n7 = n2 * 32 - Camera._nCamY + GameImpl.SV_Y;
        while (n6 <= n4) {
            int n8 = n;
            int n9 = n * 32 - Camera._nCamX + GameImpl.SV_X;
            int n10 = (n6 * Map._map_tw + n << 1) + 1;
            while (n8 <= n3) {
                if ((Map._map[n10] & 8) == 0) {
                    sDKGraphics.fillRect(n9, n7, 32, 32);
                } else {
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (n6 > 0 && (Map._map[n10 - n5] & 8) == 0) {
                        bl3 = true;
                    }
                    if (n6 < Map._map_th - 1 && (Map._map[n10 + n5] & 8) == 0) {
                        bl4 = true;
                    }
                    if (n8 > 0 && (Map._map[n10 - 2] & 8) == 0) {
                        bl = true;
                    }
                    if (n8 < Map._map_tw - 1 && (Map._map[n10 + 2] & 8) == 0) {
                        bl2 = true;
                    }
                    boolean bl5 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    if (n8 > 0 && n6 > 0 && (Map._map[n10 - n5 - 2] & 8) == 0) {
                        bl5 = true;
                    }
                    if (n8 < Map._map_tw - 1 && n6 > 0 && (Map._map[n10 - n5 + 2] & 8) == 0) {
                        bl6 = true;
                    }
                    if (n8 < Map._map_tw - 1 && n6 < Map._map_th - 1 && (Map._map[n10 + n5 + 2] & 8) == 0) {
                        bl7 = true;
                    }
                    if (n8 > 0 && n6 < Map._map_th - 1 && (Map._map[n10 + n5 - 2] & 8) == 0) {
                        bl8 = true;
                    }
                    if (bl) {
                        xSprite.DrawFrame(67, n9, n7, 0);
                        if (bl5) {
                            xSprite.DrawFrame(68, n9, n7, 0);
                        }
                        if (bl8) {
                            xSprite.DrawFrame(69, n9, n7, 0);
                        }
                    }
                    if (bl2) {
                        xSprite.DrawFrame(65, n9, n7, 0);
                        if (bl6) {
                            xSprite.DrawFrame(70, n9, n7, 0);
                        }
                        if (bl7) {
                            xSprite.DrawFrame(71, n9, n7, 0);
                        }
                    }
                    if (bl3) {
                        xSprite.DrawFrame(64, n9, n7, 0);
                        if (bl5) {
                            xSprite.DrawFrame(72, n9, n7, 0);
                        }
                        if (bl6) {
                            xSprite.DrawFrame(73, n9, n7, 0);
                        }
                    }
                    if (bl4) {
                        xSprite.DrawFrame(66, n9, n7, 0);
                        if (bl8) {
                            xSprite.DrawFrame(74, n9, n7, 0);
                        }
                        if (bl7) {
                            xSprite.DrawFrame(75, n9, n7, 0);
                        }
                    }
                }
                ++n8;
                n10 += 2;
                n9 += 32;
            }
            ++n6;
            n7 += 32;
        }
    }

    static void FOW_AlphaDraw(SDKGraphics sDKGraphics) {
        int n = Camera._nCamX / 32;
        int n2 = Camera._nCamY / 32;
        int n3 = (Camera._nCamX + GameImpl.SV_W) / 32;
        int n4 = (Camera._nCamY + GameImpl.SV_H) / 32;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= Map._map_tw) {
            n3 = Map._map_tw - 1;
        }
        if (n4 >= Map._map_th) {
            n4 = Map._map_th - 1;
        }
        XSprite xSprite = Sprites._sprites[42];
        int n5 = Map._map_tw << 1;
        int n6 = n2;
        int n7 = n2 * 32 - Camera._nCamY + GameImpl.SV_Y;
        while (n6 <= n4) {
            int n8 = n;
            int n9 = n * 32 - Camera._nCamX + GameImpl.SV_X;
            int n10 = (n6 * Map._map_tw + n << 1) + 1;
            while (n8 <= n3) {
                if ((Map._map[n10] & 8) == 0) {
                    xSprite.DrawFrame(9, n9, n7, 0);
                } else {
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (n6 > 0 && (Map._map[n10 - n5] & 8) == 0) {
                        bl3 = true;
                    }
                    if (n6 < Map._map_th - 1 && (Map._map[n10 + n5] & 8) == 0) {
                        bl4 = true;
                    }
                    if (n8 > 0 && (Map._map[n10 - 2] & 8) == 0) {
                        bl = true;
                    }
                    if (n8 < Map._map_tw - 1 && (Map._map[n10 + 2] & 8) == 0) {
                        bl2 = true;
                    }
                    boolean bl5 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    if (n8 > 0 && n6 > 0 && (Map._map[n10 - n5 - 2] & 8) == 0) {
                        bl5 = true;
                    }
                    if (n8 < Map._map_tw - 1 && n6 > 0 && (Map._map[n10 - n5 + 2] & 8) == 0) {
                        bl6 = true;
                    }
                    if (n8 < Map._map_tw - 1 && n6 < Map._map_th - 1 && (Map._map[n10 + n5 + 2] & 8) == 0) {
                        bl7 = true;
                    }
                    if (n8 > 0 && n6 < Map._map_th - 1 && (Map._map[n10 + n5 - 2] & 8) == 0) {
                        bl8 = true;
                    }
                    if (bl) {
                        xSprite.DrawFrame(10, n9, n7, 0);
                    }
                    if (bl2) {
                        xSprite.DrawFrame(11, n9, n7, 0);
                    }
                    if (bl3) {
                        xSprite.DrawFrame(12, n9, n7, 0);
                    }
                    if (bl4) {
                        xSprite.DrawFrame(13, n9, n7, 0);
                    }
                    if (bl5 && !bl3 && !bl) {
                        xSprite.DrawFrame(14, n9, n7, 0);
                    }
                    if (bl6 && !bl3 && !bl2) {
                        xSprite.DrawFrame(15, n9, n7, 0);
                    }
                    if (bl7 && !bl4 && !bl2) {
                        xSprite.DrawFrame(16, n9, n7, 0);
                    }
                    if (bl8 && !bl4 && !bl) {
                        xSprite.DrawFrame(17, n9, n7, 0);
                    }
                    if (bl5 && !bl3 && bl) {
                        xSprite.DrawFrame(18, n9, n7, 0);
                    }
                    if (bl5 && bl3 && !bl) {
                        xSprite.DrawFrame(20, n9, n7, 0);
                    }
                    if (bl6 && !bl3 && bl2) {
                        xSprite.DrawFrame(19, n9, n7, 0);
                    }
                    if (bl8 && bl4 && !bl) {
                        xSprite.DrawFrame(21, n9, n7, 0);
                    }
                }
                ++n8;
                n10 += 2;
                n9 += 32;
            }
            ++n6;
            n7 += 32;
        }
    }

    static void FOW_AlphaDrawTiles(SDKGraphics sDKGraphics) {
        int n = Camera._nCamX / 32;
        int n2 = Camera._nCamY / 32;
        int n3 = (Camera._nCamX + GameImpl.SV_W) / 32;
        int n4 = (Camera._nCamY + GameImpl.SV_H) / 32;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= Map._map_tw) {
            n3 = Map._map_tw - 1;
        }
        if (n4 >= Map._map_th) {
            n4 = Map._map_th - 1;
        }
        int[] nArray = new int[4];
        int n5 = Map._map_tw << 1;
        int n6 = n2;
        int n7 = n2 * 32 - Camera._nCamY + GameImpl.SV_Y;
        while (n6 <= n4) {
            int n8 = n;
            int n9 = n * 32 - Camera._nCamX + GameImpl.SV_X;
            int n10 = (n6 * Map._map_tw + n << 1) + 1;
            while (n8 <= n3) {
                boolean bl;
                int n11 = 0;
                if (n8 <= 0) {
                    n11 |= 0x29;
                }
                if (n8 >= Map._map_tw - 1) {
                    n11 |= 0x94;
                }
                if (n6 <= 0) {
                    n11 |= 7;
                }
                if (n6 >= Map._map_th - 1) {
                    n11 |= 0xE0;
                }
                if ((n11 & 1) == 0 && (Map._map[n10 - n5 - 2] & 8) == 0) {
                    n11 |= 1;
                }
                if ((n11 & 2) == 0 && (Map._map[n10 - n5] & 8) == 0) {
                    n11 |= 2;
                }
                if ((n11 & 4) == 0 && (Map._map[n10 - n5 + 2] & 8) == 0) {
                    n11 |= 4;
                }
                if ((n11 & 8) == 0 && (Map._map[n10 - 2] & 8) == 0) {
                    n11 |= 8;
                }
                if ((n11 & 0x10) == 0 && (Map._map[n10 + 2] & 8) == 0) {
                    n11 |= 0x10;
                }
                if ((n11 & 0x20) == 0 && (Map._map[n10 + n5 - 2] & 8) == 0) {
                    n11 |= 0x20;
                }
                if ((n11 & 0x40) == 0 && (Map._map[n10 + n5] & 8) == 0) {
                    n11 |= 0x40;
                }
                if ((n11 & 0x80) == 0 && (Map._map[n10 + n5 + 2] & 8) == 0) {
                    n11 |= 0x80;
                }
                boolean bl2 = bl = (Map._map[n10] & 8) == 0;
                if (n11 != 0 || bl) {
                    if (n11 == 255 && bl) {
                        sDKGraphics.drawRegion(_fogtiles, 32, 0, 32, 32, 0, n9, n7, 0);
                    } else {
                        if (bl) {
                            nArray[0] = _fogtable[n11 & 0xB | 0xD0] & 0xFF;
                            nArray[1] = _fogtable[256 + (n11 & 0x16 | 0x68)] & 0xFF;
                            nArray[2] = _fogtable[512 + (n11 & 0x68 | 0x16)] & 0xFF;
                            nArray[3] = _fogtable[768 + (n11 & 0xD0 | 0xB)] & 0xFF;
                        } else {
                            nArray[0] = _fogtable[n11 & 0xB] & 0xFF;
                            nArray[1] = _fogtable[256 + (n11 & 0x16)] & 0xFF;
                            nArray[2] = _fogtable[512 + (n11 & 0x68)] & 0xFF;
                            nArray[3] = _fogtable[768 + (n11 & 0xD0)] & 0xFF;
                        }
                        for (int i = 0; i < 4; ++i) {
                            if (nArray[i] == 0) continue;
                            sDKGraphics.drawRegion(_fogtiles, (nArray[i] & 3) * 16, (nArray[i] >> 2) * 16, 16, 16, 0, n9 + (i & 1) * 16, n7 + (i >> 1) * 16, 0);
                        }
                    }
                }
                ++n8;
                n9 += 32;
                n10 += 2;
            }
            ++n6;
            n7 += 32;
        }
    }

    static void FOW_Draw(SDKGraphics sDKGraphics) {
        Level.FOW_NoAlphaDraw(sDKGraphics);
    }

    static void FOW_DiscoverTiles(int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2 - n3;
        int n6 = n + n3;
        int n7 = n2 + n3;
        if (n3 <= 0) {
            return;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 >= Map._map_tw) {
            n6 = Map._map_tw - 1;
        }
        if (n7 >= Map._map_th) {
            n7 = Map._map_th - 1;
        }
        for (int i = n5; i <= n7; ++i) {
            int n8 = n4;
            int n9 = (i * Map._map_tw + n4 << 1) + 1;
            while (n8 <= n6) {
                int n10 = (n8 - n) * (n8 - n) + (i - n2) * (i - n2);
                if (n10 <= n3 * n3) {
                    int n11 = n9;
                    Map._map[n11] = (byte)(Map._map[n11] | 8);
                }
                ++n8;
                n9 += 2;
            }
        }
    }

    static void FOW_DiscoverPixels(int n, int n2, int n3) {
        int n4 = n / 32;
        int n5 = n2 / 32;
        int n6 = n3 / 32;
        Level.FOW_DiscoverTiles(n4, n5, n6);
    }

    static void FOW_DiscoverTiles(int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= Map._map_tw) {
            n3 = Map._map_tw - 1;
        }
        if (n4 >= Map._map_th) {
            n4 = Map._map_th - 1;
        }
        for (int i = n2; i <= n4; ++i) {
            int n5 = n;
            int n6 = (i * Map._map_tw + n << 1) + 1;
            while (n5 <= n3) {
                int n7 = n6;
                Map._map[n7] = (byte)(Map._map[n7] | 8);
                ++n5;
                n6 += 2;
            }
        }
    }

    static void FOW_DiscoverPixels(int n, int n2, int n3, int n4) {
        int n5 = n / 32;
        int n6 = n2 / 32;
        int n7 = n3 / 32;
        int n8 = n4 / 32;
        Level.FOW_DiscoverTiles(n5, n6, n7, n8);
    }

    static boolean FOW_IsDiscovered(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= Map._map_w || n2 >= Map._map_h) {
            return false;
        }
        byte by = Map._map[(n2 / 32 * Map._map_tw + n / 32 << 1) + 1];
        return (by & 8) != 0;
    }

    static int FOW_PercentageVisible(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2] - nArray[0];
        int n4 = nArray[3] - nArray[1];
        int n5 = 0;
        int n6 = 0;
        int n7 = n / 32;
        int n8 = n2 / 32;
        int n9 = n;
        int n10 = n2;
        int n11 = (n7 + 1) * 32;
        int n12 = (n8 + 1) * 32;
        if (n11 > n + n3) {
            n11 = n + n3;
        }
        if (n12 > n2 + n4) {
            n12 = n2 + n4;
        }
        while (n10 < n2 + n4) {
            n5 += (n11 - n9) * (n12 - n10);
            if (Level.FOW_IsDiscovered((n9 + n11) / 2, (n10 + n12) / 2)) {
                n6 += (n11 - n9) * (n12 - n10);
            }
            if ((n9 = n11 + 1) >= n + n3) {
                n9 = n;
                n11 = (n7 + 1) * 32;
                if (n11 > n + n3) {
                    n11 = n + n3;
                }
                n10 = n12 + 1;
                if ((n12 += 32) <= n2 + n4) continue;
                n12 = n2 + n4;
                continue;
            }
            if ((n11 += 32) <= n + n3) continue;
            n11 = n + n3;
        }
        if (n5 == 0) {
            return 100;
        }
        return n6 * 100 / n5;
    }

    static void __FOG_OF_WAR() {
    }

    static void RefreshCreep(int n) {
        for (int i = 64; i < 160; ++i) {
            if (_entities_usage[i] != 1) continue;
            Building building = (Building)_entities[i];
            if (building._allegiance != n || _b_tower_defense) continue;
            building.ApplyCreep(true);
        }
    }

    static void SetEndLevelMusic(boolean bl) {
        if (GameImpl._soundEnable) {
            GameImpl._soundManager.stopSounds();
            GameImpl._soundManager.setCurrentLoop(1);
            if (bl) {
                GameImpl._soundManager.playSound(32);
                GameImpl._soundManager.setSoundVolume(GameImpl.soundVolume);
            } else {
                GameImpl._soundManager.playSound(33);
                GameImpl._soundManager.setSoundVolume(GameImpl.soundVolume);
            }
        }
    }

    static void EndLevel(int n) {
        _bCanSkipMovie = false;
        _skipMovieState = 0;
        _bMovieSkipped = false;
        boolean bl = GameImpl._player_won = n == 0;
        if (_b_skirmish && n == 0) {
            if (Encyclopedia._superman && (GameImpl._unlockables & 0x2000000) == 0) {
                GameImpl._unlockables |= 0x2000000;
                _unlock_now |= 0x2000000;
            }
        } else if (!_b_skirmish && n == 1) {
            Encyclopedia.SetAlphaOmega();
            GameImpl.saveRMS();
        }
        if (GameImpl._player_won && !_b_skirmish) {
            if (Encyclopedia._alpha_omega) {
                Encyclopedia._msk_alpha_omega |= 1 << _crt_level;
            }
            if (Encyclopedia._doctor) {
                Encyclopedia._msk_doctor |= 1 << _crt_level;
            }
            if (Encyclopedia._stealth && (_crt_level == 0 || _crt_level == 3 || _crt_level == 7)) {
                Encyclopedia._msk_stealth |= 1 << _crt_level;
            }
            int n2 = 0;
            int n3 = 137;
            for (int i = 0; i < 15; ++i) {
                n2 |= 1 << i;
            }
            if (_crt_level < 14) {
                if (_crt_level != 7 && _crt_level != 13 && _crt_level != 14 && (GameImpl._unlockables & 1 << _crt_level) == 0) {
                    GameImpl._unlockables |= 1 << _crt_level;
                    _unlock_now |= 1 << _crt_level;
                }
                GameImpl._nextMission = _crt_level + 1;
                switch (_crt_level) {
                    case 2: {
                        if (GameImpl._maxSkirmishMission >= 16) break;
                        GameImpl._maxSkirmishMission = 16;
                        break;
                    }
                    case 3: {
                        if (GameImpl._maxAlliedMission >= 8) break;
                        GameImpl._maxAlliedMission = 8;
                        break;
                    }
                    case 6: {
                        if (GameImpl._maxSkirmishMission >= 17) break;
                        GameImpl._maxSkirmishMission = 17;
                        break;
                    }
                    case 7: {
                        if (!Encyclopedia._stealth || Encyclopedia._msk_stealth != n3 || (GameImpl._unlockables & 0x4000000) != 0) break;
                        GameImpl._unlockables |= 0x4000000;
                        _unlock_now |= 0x4000000;
                        break;
                    }
                    case 10: {
                        if (GameImpl._maxSkirmishMission >= 18) break;
                        GameImpl._maxSkirmishMission = 18;
                    }
                }
                if (_crt_level < 7) {
                    if (GameImpl._maxSovietMission < GameImpl._nextMission) {
                        GameImpl._maxSovietMission = GameImpl._nextMission;
                    }
                } else if (_crt_level < 14 && GameImpl._maxAlliedMission < GameImpl._nextMission) {
                    GameImpl._maxAlliedMission = GameImpl._nextMission;
                }
                GameImpl.saveRMS();
            } else {
                if (Level.GetEntityNo(13, 2, 2) != 0 || Level.GetEntityNo(13, 2, 1) != 0) {
                    Encyclopedia.SetDoctor();
                }
                if (Encyclopedia._alpha_omega && Encyclopedia._msk_alpha_omega == n2 && (GameImpl._unlockables & 0x100000) == 0) {
                    GameImpl._unlockables |= 0x100000;
                    _unlock_now |= 0x100000;
                }
                if (Encyclopedia._doctor && Encyclopedia._msk_doctor == n2 && (GameImpl._unlockables & 0x8000000) == 0) {
                    GameImpl._unlockables |= 0x8000000;
                    _unlock_now |= 0x8000000;
                }
                GameImpl.saveRMS();
            }
        }
        Level.SetEndLevelMusic(GameImpl._player_won);
        GameImpl.SetState(7);
    }

    static void GetCurrentGravCenter(int n, int n2) {
        _gravity_center_X = -1;
        _gravity_center_Y = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (unit._allegiance != n2 || unit._life <= 0 || (n != -1 || !unit._bSelected) && (n == -1 || unit._group != n)) continue;
            ++n3;
            n4 += unit._pos_x;
            n5 += unit._pos_y;
        }
        if (n3 > 0) {
            _gravity_center_X = n4 / n3;
            _gravity_center_Y = n5 / n3;
        }
    }

    public static Entity FindClosestMineralField(int n, int n2, int n3) {
        Entity entity = null;
        int n4 = 0;
        for (int i = 160; i < 416; ++i) {
            int n5;
            if (_entities_usage[i] != 1) continue;
            Entity entity2 = _entities[i];
            if (entity2._type != 10 || (n5 = Math.abs(n - entity2._pos_x) + Math.abs(n2 - entity2._pos_y)) >= n3 || entity != null && n5 >= n4) continue;
            entity = entity2;
            n4 = n5;
        }
        return entity;
    }

    static void SuperWeapons__() {
    }

    static void ResetSWTimer(int n, int n2) {
        if (n == 0) {
            if (Hud._sw_cooldown[n2] <= 10 && Hud._sw_cooldown[n2] >= 0) {
                Hud._sw_cooldown[n2] = 14 * Level.GetSWStats(n2, 0);
            }
        } else if (n == 1) {
            MasterAI._AI_sw_cooldown[n2] = 14 * Level.GetSWStats(n2, 0);
        }
    }

    static void DropNuke(int n, int n2, int n3) {
        if (_b_skirmish && n == 0) {
            Encyclopedia.SetSuperman();
        }
        Entity entity = Level.SpawnEntity(106);
        entity.Nuke_Init(n, n2, n3);
        Level.ResetSWTimer(n, 0);
    }

    static void DropKirov(int n, int n2, int n3) {
        if (_b_skirmish && n == 0) {
            Encyclopedia.SetSuperman();
        }
        Entity entity = Level.SpawnEntity(110);
        entity.Kirov_Init(n, n2, n3);
        Level.ResetSWTimer(n, 1);
    }

    static void DropHarrier(int n, int n2, int n3) {
        if (_b_skirmish && n == 0) {
            Encyclopedia.SetSuperman();
        }
        Entity entity = Level.SpawnEntity(111);
        entity.Harrier_Init(n, n2, n3);
        Level.ResetSWTimer(n, 3);
    }

    static void DropIronCurtain(int n, int n2, int n3) {
        if (_b_skirmish && n == 0) {
            Encyclopedia.SetSuperman();
        }
        Entity entity = Level.SpawnEntity(112);
        entity.IronCurtain_Init(n, n2, n3);
        Level.ResetSWTimer(n, 2);
    }

    static void DropStorm(int n, int n2, int n3) {
        if (_b_skirmish && n == 0) {
            Encyclopedia.SetSuperman();
        }
        Entity entity = Level.SpawnEntity(115);
        entity.Storm_Init(n, n2, n3);
        Level.ResetSWTimer(n, 5);
    }

    static void __SuperWeapons() {
    }

    static void DoSplashDamage(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < 416; ++i) {
            if (_entities_usage[i] != 1) continue;
            Entity entity = _entities[i];
            int n7 = Math.abs(entity._pos_x - n) + Math.abs(entity._pos_y - n2);
            if (n7 >= n3) continue;
            entity.TakeDamage(n4, n5, n6);
        }
    }

    static void SW_CHRONO__() {
    }

    static void SWChrono_Update() {
        if (!_bSWChronoActive) {
            return;
        }
        switch (_chrono_state) {
            case 1: {
                if (--_chrono_timer > 0) break;
                Level.SWChrono_DoTeleport();
                break;
            }
            case 2: {
                if (--_chrono_timer > 0) break;
                Level.SWChrono_FinishTeleport();
            }
        }
    }

    static void SWChrono_MarkUnits(int n, int n2) {
        int n3;
        if (_b_skirmish) {
            Encyclopedia.SetSuperman();
        }
        _bSWChronoActive = true;
        _chrono_state = 0;
        _chrono_units_count = 0;
        _chrono_radius = Level.GetSWStats(4, 3);
        int n4 = _chrono_radius * _chrono_radius;
        block3: for (n3 = 0; n3 < 64; ++n3) {
            if (_entities_usage[n3] != 1) continue;
            Unit unit = (Unit)_entities[n3];
            unit._bChronoSWSelected = false;
            if (unit._allegiance != 0 && unit._subtype != 6) continue;
            switch (unit._subtype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: {
                    continue block3;
                }
                default: {
                    int n5 = n - unit._pos_x;
                    int n6 = n2 - unit._pos_y;
                    int n7 = n5 * n5 + n6 * n6;
                    if (n7 > n4) continue block3;
                    Level._fixed_w_array[Level._fixed_clip_count] = n7;
                    Level._fixed_clip_array[Level._fixed_clip_count] = unit._arrayIndex;
                    ++_fixed_clip_count;
                }
            }
        }
        Utils.QuickSort(_fixed_w_array, _fixed_clip_array, 0, _fixed_clip_count - 1);
        n3 = Level.GetSWStats(4, 4);
        for (int i = 0; i < _fixed_clip_count && i < n3; ++i) {
            Unit unit = (Unit)_entities[_fixed_clip_array[i]];
            unit._bChronoSWSelected = true;
            ++_chrono_units_count;
        }
    }

    static void SWChrono_TeleportUnits(int n, int n2) {
        _chrono_state = 1;
        _chrono_destx = n;
        _chrono_desty = n2;
        _chrono_timer = Level.GetSWStats(4, 5);
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (!unit._bChronoSWSelected) continue;
            Entity entity = Level.SpawnEntity(2);
            entity.Decorator_Init(unit._pos_x, unit._pos_y, 36, 7, 512, 6, -1, 0);
        }
        Level.ResetSWTimer(0, 4);
    }

    private static void SWChrono_DoTeleport() {
        _chrono_state = 2;
        _chrono_timer = Level.GetSWStats(4, 5);
        if (!Map.ValidateCollisionTile(_chrono_destx / 8, _chrono_desty / 8, 7)) {
            _bSWChronoActive = false;
            for (int i = 0; i < 64; ++i) {
                if (_entities_usage[i] != 1) continue;
                Unit unit = (Unit)_entities[i];
                if (!unit._bChronoSWSelected) continue;
                unit._bChronoSWSelected = false;
                unit._flags &= 0xFFFFFFEF;
            }
            return;
        }
        _chrono_destx = Map._validTileX * 8 + 4;
        _chrono_desty = Map._validTileY * 8 + 4;
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (!unit._bChronoSWSelected) continue;
            unit.SetPosition(_chrono_destx, _chrono_desty);
            for (int j = 30; j > 0 && !unit.SolveOverlapping(); --j) {
                unit.SetPosition(unit._sdata[0], unit._sdata[1]);
            }
            unit.DoAction(1, -1, -1, -1);
            unit.RefreshFogOfWar();
            unit._flags |= 0x10;
            unit.SetCollisionBox();
            Entity entity = Level.SpawnEntity(2);
            entity.Decorator_Init(unit._pos_x, unit._pos_y, 36, 8, 512, 6, -1, 0);
        }
    }

    private static void SWChrono_FinishTeleport() {
        _bSWChronoActive = false;
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (!unit._bChronoSWSelected) continue;
            unit._bChronoSWSelected = false;
            unit._flags &= 0xFFFFFFEF;
        }
    }

    static void SWChrono_Cancel() {
        _bSWChronoActive = false;
        for (int i = 0; i < 64; ++i) {
            if (_entities_usage[i] != 1) continue;
            Unit unit = (Unit)_entities[i];
            if (!unit._bChronoSWSelected) continue;
            unit._bChronoSWSelected = false;
            unit._flags &= 0xFFFFFFEF;
        }
    }

    static void __SW_CHRONO() {
    }

    public static void CalculateEfficency() {
        int n = 0;
        int n2 = 0;
        n = _statistics[5] + _statistics[7] != 0 ? (_statistics[4] + _statistics[6]) * 10 / (_statistics[5] + _statistics[7]) : (_statistics[4] + _statistics[6]) * 10;
        n2 = _statistics[4] + _statistics[6] != 0 ? (_statistics[5] + _statistics[7]) * 10 / (_statistics[4] + _statistics[6]) : (_statistics[5] + _statistics[7]) * 10;
        Level._statistics[8] = n >= 10 ? 100 : (n * 10 <= 10 ? 0 : n * 100 / 10);
        Level._statistics[9] = n2 >= 10 ? 100 : (n2 * 10 <= 10 ? 0 : n2 * 100 / 10);
    }

    public static boolean HasPower(int n) {
        if (n == 0) {
            return _player_consumption < _player_power && _buildings_off_times[0][1] <= 0;
        }
        if (n == 1) {
            return _ai_consumption < _ai_power && _buildings_off_times[1][1] <= 0;
        }
        return true;
    }

    public static int Find_unlocked_now() {
        if (GameImpl.IsCheatActive(5)) {
            int n = 0;
            for (int i = 0; i < 12; ++i) {
                n |= 1 << i + 16;
            }
            return n | _unlock_now;
        }
        return _unlock_now;
    }

    public static void UpdateSkipMovie() {
        switch (_skipMovieState) {
            case 1: {
                Utils.Update_Fade();
                if (Utils._fadeCounter < Utils._fadeSteps) break;
                _skipMovieState = 2;
                break;
            }
            case 2: {
                while (_skipMovieState == 2) {
                    try {
                        long l = GameImpl._canvas.getAppTime();
                        _level_timer = (int)((long)_level_timer + (l - _last_time));
                        _last_time = l;
                        Hud.Update();
                        Tutorial.Tutorials_Update();
                        UtilEntity.Update_BuildSpots();
                        MasterAI.AI_Update();
                        Camera.UpdateCamera();
                        if (_paused == 0) {
                            Level.UpdateEntities();
                            Level.UpdateOffTimes();
                            ++_timeline_counter;
                        }
                        UtilEntity.Update_Triggers();
                        Script.RunEngine();
                        if (_skipMovieState != 2) {
                            Map.CDB_Update();
                            Map.CDB_Invalidator_Update();
                            Utils.Fade(false, 20, true);
                        }
                        Pathfinder.Update();
                        Level.SWChrono_Update();
                        Utils.SnowUpdate();
                    }
                    catch (Exception exception) {
                        Debug.CatchException("Level update", exception);
                    }
                }
                break;
            }
            case 3: {
                Utils.Update_Fade();
                if (Utils._fadeCounter > 0) break;
                _skipMovieState = 0;
            }
        }
    }

    public static void SkipMovie() {
        if (_bCanSkipMovie && _skipMovieState == 0) {
            Utils.Fade(true, 20, true);
            _skipMovieState = 1;
            _bMovieSkipped = true;
        }
    }

    static {
        _groupLeaders = new int[3];
        _paused = 0;
        _statistics = new int[10];
        _unlock_now = 0;
        _bCanSkipMovie = false;
        _skipMovieState = 0;
        _bMovieSkipped = false;
        _lastSpawnedIndex = -1;
        _fixed_ent_data = null;
        _fixed_ent_list = null;
        _fixedListPointer = 0;
        _fixedDataPointer = 0;
        _nrFixedLevelEntities = 0;
        _lastCellOffset = 0;
        _fixed_w_array = new int[320];
        _fixed_clip_array = new int[320];
        _fixed_clip_count = 0;
        _dynamic_w_array = new int[320];
        _dynamic_entities_clip = new int[320];
        _dynamic_entities_clip_count = 0;
        _cmaps_header = new short[92];
        _cmaps = new byte[23][];
        _chrono_units_count = 0;
        _chrono_state = 0;
        _chrono_timer = 0;
        _chrono_destx = 0;
        _chrono_desty = 0;
        _chrono_radius = 0;
        _bSWChronoActive = false;
    }
}

