/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.Map;

public class Camera
implements Constants,
Key {
    public static int _nCamX;
    public static int _nCamY;
    public static int _state;
    public static int _nDestX;
    public static int _nDestY;
    static int _nCamSpd;
    static int _nCamMaxSpd;
    public static int _nCursorDX;
    public static int _nCursorDY;
    public static int _followEntityPointer;

    public static void ResetCamera() {
        _nCamMaxSpd = 102;
        _nCamSpd = 6;
    }

    public static void DoScroll(int n, int n2) {
        _nDestX = n < 0 ? 0 : n;
        _nDestY = n2 < 0 ? 0 : n2;
        _nCursorDX = Cursor._nCursorPosX - _nCamX;
        _nCursorDY = Cursor._nCursorPosY - _nCamY;
        _nCamSpd = 6;
        Camera.SetState(1);
    }

    public static void DoDrag(int n, int n2) {
        _nDestX -= n * 2;
        _nDestY -= n2 * 2;
        _nCursorDX = Cursor._nCursorPosX - _nCamX;
        _nCursorDY = Cursor._nCursorPosY - _nCamY;
        _nCamSpd = 20;
        Camera.SetState(4);
    }

    public static void DoFollowEntity(int n) {
        _followEntityPointer = n;
        _nCamSpd = 6;
        Camera.SetState(3);
    }

    static void SetState(int n) {
        if (_state == n) {
            return;
        }
        _state = n;
    }

    static void UpdateCamera() {
        switch (_state) {
            case 0: {
                Camera.Update_State_Cursor();
                break;
            }
            case 2: {
                Camera.Update_State_CenterCursor();
                break;
            }
            case 1: {
                Camera.Update_State_Scroll();
                break;
            }
            case 3: {
                Camera.Update_State_FollowEntity();
                break;
            }
            case 4: {
                Camera.Update_State_Drag();
            }
        }
    }

    private static boolean MoveCamera() {
        int n;
        int n2 = _nDestX - _nCamX;
        int n3 = _nDestY - _nCamY;
        int n4 = Math.abs(n2);
        int n5 = n4 + (n = Math.abs(n3));
        if (n5 <= 4) {
            _nCamX = _nDestX;
            _nCamY = _nDestY;
            return false;
        }
        if (n5 <= _nCamSpd) {
            _nCamX = _nDestX;
            _nCamY = _nDestY;
            return true;
        }
        n5 = n4 > n ? n4 : n;
        n2 = (n2 * _nCamSpd << 6) / n5;
        n3 = (n3 * _nCamSpd << 6) / n5;
        _nCamX = (_nCamX << 6) + n2 >> 6;
        _nCamY = (_nCamY << 6) + n3 >> 6;
        return true;
    }

    private static void Update_State_Cursor() {
        Cursor._bCursorScroll = false;
        if (_nCamX > Cursor._nCursorPosX - 24) {
            _nCamX = Cursor._nCursorPosX - 24;
            Cursor._bCursorScroll = true;
            if (_nCamX < 0) {
                _nCamX = 0;
            }
        }
        if (_nCamX < Cursor._nCursorPosX + 24 - GameImpl.SV_W) {
            _nCamX = Cursor._nCursorPosX + 24 - GameImpl.SV_W;
            Cursor._bCursorScroll = true;
            if (_nCamX > Map._map_w - GameImpl.SV_W) {
                _nCamX = Map._map_w - GameImpl.SV_W;
            }
        }
        if (_nCamY > Cursor._nCursorPosY - GameImpl.CURSOR_MIN_Y - 24) {
            _nCamY = Cursor._nCursorPosY - GameImpl.CURSOR_MIN_Y - 24;
            Cursor._bCursorScroll = true;
            if (_nCamY < 0) {
                _nCamY = 0;
            }
        }
        if (_nCamY < Cursor._nCursorPosY + 24 - GameImpl.SV_H) {
            _nCamY = Cursor._nCursorPosY + 24 - GameImpl.SV_H;
            Cursor._bCursorScroll = true;
            if (_nCamY > Map._map_h - GameImpl.SV_H) {
                _nCamY = Map._map_h - GameImpl.SV_H;
            }
        }
        _nDestX = _nCamX;
        _nDestY = _nCamY;
    }

    private static void Update_State_CenterCursor() {
        Cursor._bCursorScroll = true;
        _nCamX = Cursor._nCursorPosX - (GameImpl.SV_W >> 1);
        _nCamY = Cursor._nCursorPosY - (GameImpl.SV_H >> 1);
        if (_nCamX < 0) {
            _nCamX = 0;
        }
        if (_nCamX > Map._map_w - GameImpl.SV_W) {
            _nCamX = Map._map_w - GameImpl.SV_W;
        }
        if (_nCamY < 0) {
            _nCamY = 0;
        }
        if (_nCamY > Map._map_h - GameImpl.SV_H) {
            _nCamY = Map._map_h - GameImpl.SV_H;
        }
        _nDestX = _nCamX;
        _nDestY = _nCamY;
    }

    private static void Update_State_Scroll() {
        boolean bl = false;
        if ((_nCamSpd += 6) > _nCamMaxSpd) {
            _nCamSpd = _nCamMaxSpd;
        }
        if (Camera.MoveCamera()) {
            if (_nCamX < 0) {
                _nCamX = 0;
                bl = true;
            }
            if (_nCamX > Map._map_w - GameImpl.SV_W) {
                _nCamX = Map._map_w - GameImpl.SV_W;
                bl = true;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
                bl = true;
            }
            if (_nCamY > Map._map_h - GameImpl.SV_H) {
                _nCamY = Map._map_h - GameImpl.SV_H;
                bl = true;
            }
        } else {
            if (_nCamX < 0) {
                _nCamX = 0;
            }
            if (_nCamX > Map._map_w - GameImpl.SV_W) {
                _nCamX = Map._map_w - GameImpl.SV_W;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
            }
            if (_nCamY > Map._map_h - GameImpl.SV_H) {
                _nCamY = Map._map_h - GameImpl.SV_H;
            }
            bl = true;
        }
        Cursor._nCursorPosX = _nCamX + _nCursorDX;
        Cursor._nCursorPosY = _nCamY + _nCursorDY;
        if (bl) {
            Camera.SetState(0);
        }
    }

    private static void Update_State_FollowEntity() {
        Entity entity = Level.GetEntitySafe(_followEntityPointer);
        if (entity == null) {
            Camera.SetState(0);
            return;
        }
        if ((_nCamSpd += 6) > _nCamMaxSpd) {
            _nCamSpd = _nCamMaxSpd;
        }
        Cursor._bCursorScroll = false;
        _nDestX = entity._pos_x - (GameImpl.SV_W >> 1);
        _nDestY = entity._pos_y - (GameImpl.SV_H >> 1);
        _nCursorDX = Cursor._nCursorPosX - _nCamX;
        _nCursorDY = Cursor._nCursorPosY - _nCamY;
        if (_nDestX < 0) {
            _nDestX = 0;
        }
        if (_nDestX > Map._map_w - GameImpl.SV_W) {
            _nDestX = Map._map_w - GameImpl.SV_W;
        }
        if (_nDestY < 0) {
            _nDestY = 0;
        }
        if (_nDestY > Map._map_h - GameImpl.SV_H) {
            _nDestY = Map._map_h - GameImpl.SV_H;
        }
        Camera.MoveCamera();
        Cursor._nCursorPosX = _nCamX + _nCursorDX;
        Cursor._nCursorPosY = _nCamY + _nCursorDY;
    }

    private static void Update_State_Drag() {
        boolean bl = false;
        if (Camera.MoveCamera()) {
            if (_nCamX < 0) {
                _nCamX = 0;
                bl = true;
            }
            if (_nCamX > Map._map_w - GameImpl.SV_W) {
                _nCamX = Map._map_w - GameImpl.SV_W;
                bl = true;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
                bl = true;
            }
            if (_nCamY > Map._map_h - GameImpl.SV_H) {
                _nCamY = Map._map_h - GameImpl.SV_H;
                bl = true;
            }
        } else {
            if (_nCamX < 0) {
                _nCamX = 0;
            }
            if (_nCamX > Map._map_w - GameImpl.SV_W) {
                _nCamX = Map._map_w - GameImpl.SV_W;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
            }
            if (_nCamY > Map._map_h - GameImpl.SV_H) {
                _nCamY = Map._map_h - GameImpl.SV_H;
            }
            bl = true;
        }
        Cursor._nCursorPosX = _nCamX + _nCursorDX;
        Cursor._nCursorPosY = _nCamY + _nCursorDY;
        if (bl) {
            Camera.SetState(0);
        }
    }

    static {
        _nCamSpd = 0;
        _nCamMaxSpd = 102;
    }
}

