/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.Script;
import com.ea.game.ScriptConstants;
import com.ea.game.SpriteConstants;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.UtilEntity;

public class MasterAI
implements Constants,
ScriptConstants,
UnitsConstants,
SpriteConstants,
GraphicsConstants,
BuildingConstants {
    public static int _AI_timer;
    public static int[][] _AI_groups;
    public static int _AI_script_instance;
    public static boolean _AI_defend;
    public static boolean _AI_run_script;
    public static int[] _AI_sw_cooldown;

    static void AI_Init() {
        _AI_groups = new int[64][4];
        _AI_sw_cooldown = new int[6];
        MasterAI.AI_Clean();
    }

    static void AI_Clean() {
        for (int i = 0; i < 64; ++i) {
            MasterAI._AI_groups[i][0] = 0;
            MasterAI._AI_groups[i][1] = 0;
            MasterAI._AI_groups[i][2] = 0;
            MasterAI._AI_groups[i][3] = -1;
        }
        _AI_timer = 0;
        _AI_script_instance = -1;
    }

    static void AI_Release() {
        if (_AI_groups != null) {
            for (int i = 0; i < 64; ++i) {
                MasterAI._AI_groups[i] = null;
            }
            _AI_groups = null;
        }
        System.gc();
    }

    static void AI_Update() {
        ++_AI_timer;
        for (int i = 0; i < 6; ++i) {
            if (_AI_sw_cooldown[i] <= 0 || !Level.HasPower(0) || Hud._hud_state >= 4) continue;
            int n = i;
            _AI_sw_cooldown[n] = _AI_sw_cooldown[n] - 1;
        }
        if (_AI_timer >= 8) {
            MasterAI.EvaluateSituation();
            if (_AI_script_instance >= 0 && _AI_run_script && Script._scriptInstances[_AI_script_instance] != null && Script._scriptInstances[_AI_script_instance][2] == 4) {
                Script.RunScript(_AI_script_instance);
            }
            _AI_timer = 0;
        }
    }

    static boolean EvaluateSituation() {
        int n;
        for (n = 0; n < 64; ++n) {
            if (_AI_groups[n][0] <= 0 || _AI_groups[n][2] <= 0) continue;
            MasterAI._AI_groups[n][2] = 0;
        }
        if (_AI_defend) {
            MasterAI.EvaluateDanger();
        }
        for (n = 0; n < 64; ++n) {
            if (Level._entities_usage[n] != 1) continue;
            Unit unit = (Unit)Level._entities[n];
            if (unit._group <= 0 || unit._allegiance != 1 || _AI_groups[unit._group][0] <= 0 || _AI_groups[unit._group][1] != 1 || unit._action != 1 || unit._targetPointer >= 0) continue;
            int[] nArray = _AI_groups[unit._group];
            nArray[2] = nArray[2] + 1;
            if (_AI_groups[unit._group][2] < _AI_groups[unit._group][0]) continue;
            if (_AI_groups[unit._group][3] > 0) {
                int n2 = UtilEntity.Get_WayPoint(_AI_groups[unit._group][3]);
                if (n2 != -1) {
                    short s = UtilEntity._wayPoints[n2 + 3];
                    if (s > 0) {
                        int n3 = UtilEntity.Get_WayPoint(s);
                        if (n3 != -1) {
                            MasterAI.Attack(unit._group, s, UtilEntity._wayPoints[n3 + 1], UtilEntity._wayPoints[n3 + 2], -1);
                            unit._requested_action = false;
                            continue;
                        }
                        MasterAI._AI_groups[unit._group][1] = 0;
                        continue;
                    }
                    MasterAI._AI_groups[unit._group][1] = 0;
                    continue;
                }
                MasterAI._AI_groups[unit._group][1] = 0;
                continue;
            }
            MasterAI._AI_groups[unit._group][1] = 0;
        }
        return false;
    }

    static void Attack(int n, int n2, int n3, int n4, int n5) {
        if (n > 0) {
            int n6;
            if (n2 > 0 && (n6 = UtilEntity.Get_WayPoint(n2)) != -1) {
                n3 = UtilEntity._wayPoints[n6 + 1];
                n4 = UtilEntity._wayPoints[n6 + 2];
            }
            Level.GetCurrentGravCenter(n, 1);
            for (n6 = 0; n6 < 64; ++n6) {
                if (Level._entities_usage[n6] != 1) continue;
                Unit unit = (Unit)Level._entities[n6];
                if (unit._group != n || unit._allegiance != 1 || (unit._flags & 0x400) != 0 || unit._garrisonBuilding != -1 || n5 >= 0 && unit._action != n5) continue;
                int n7 = unit._pos_x - Level._gravity_center_X;
                int n8 = unit._pos_y - Level._gravity_center_Y;
                while (Math.abs(n7) + Math.abs(n8) > 64) {
                    n7 >>= 1;
                    n8 >>= 1;
                }
                unit.DoAction(2, -1, n7 + n3, n8 + n4);
                MasterAI._AI_groups[unit._group][1] = 1;
                MasterAI._AI_groups[unit._group][3] = n2;
            }
        }
    }

    static void EvaluateDanger() {
        int n;
        int n2;
        int n3;
        Entity entity;
        int n4;
        Entity entity2 = null;
        Entity entity3 = null;
        short s = -1;
        for (n4 = 0; n4 < 64; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            entity = (Unit)Level._entities[n4];
            if (entity._allegiance != 1 || !entity._noticed) continue;
            n3 = entity._subtype * 28;
            if (Level._unit_stats[n3 + 11] > s) {
                entity3 = entity;
            }
            entity._noticed = false;
        }
        s = -1;
        for (n4 = 64; n4 < 160; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            entity = (Building)Level._entities[n4];
            if (((Building)entity)._allegiance != 1 || !((Building)entity)._noticed) continue;
            if (Level.GetBuildingStats(((Building)entity)._faction, ((Building)entity)._subtype, 11) > s) {
                entity2 = entity;
            }
            ((Building)entity)._noticed = false;
        }
        if (entity2 != null) {
            Unit unit;
            n4 = entity2.GetPointer();
            int n5 = 0;
            n3 = 0;
            for (n2 = 0; n2 < 64; ++n2) {
                if (Level._entities_usage[n2] != 1) continue;
                unit = (Unit)Level._entities[n2];
                if (unit._allegiance != 0 || unit._targetPointer != n4) continue;
                n5 = unit._pos_x + entity2._pos_x >> 1;
                n3 = unit._pos_y + entity2._pos_y >> 1;
                break;
            }
            if (n5 != 0 && n3 != 0) {
                for (n2 = 0; n2 < 64; ++n2) {
                    if (Level._entities_usage[n2] != 1) continue;
                    unit = (Unit)Level._entities[n2];
                    if (unit._allegiance != 1 || unit._action != 1 || unit._targetPointer >= 0 || (unit._flags & 0x4000) != 0 || unit._garrisonBuilding != -1) continue;
                    int n6 = unit._pos_x - entity2._pos_x;
                    n = unit._pos_y - entity2._pos_y;
                    if (Math.abs(n6) + Math.abs(n) >= 360) continue;
                    if (unit._group > 0 && _AI_groups[unit._group][0] > 0) {
                        int[] nArray = _AI_groups[unit._group];
                        nArray[0] = nArray[0] - 1;
                    }
                    int[] nArray = _AI_groups[63];
                    nArray[0] = nArray[0] + 1;
                    unit._group = (byte)63;
                }
                MasterAI.Attack(63, -1, n5, n3, 1);
            }
        }
        if (entity3 != null) {
            int n7;
            n4 = entity3.GetPointer();
            int n8 = -1;
            n3 = 0;
            n2 = 0;
            for (n7 = 0; n7 < 64; ++n7) {
                if (Level._entities_usage[n7] != 1) continue;
                Unit unit = (Unit)Level._entities[n7];
                if (unit._allegiance != 0 || unit._targetPointer != n4) continue;
                n8 = unit._garrisonBuilding == -1 ? unit.GetPointer() : unit._garrisonBuilding;
                n3 = unit._pos_x;
                n2 = unit._pos_y;
                break;
            }
            if (n3 != 0 && n2 != 0) {
                for (n7 = 0; n7 < 64; ++n7) {
                    if (Level._entities_usage[n7] != 1) continue;
                    Unit unit = (Unit)Level._entities[n7];
                    if (unit._allegiance != 1 || unit._action != 1 || unit._targetPointer >= 0 || unit._garrisonBuilding != -1) continue;
                    n = unit._pos_x - entity3._pos_x;
                    int n9 = unit._pos_y - entity3._pos_y;
                    if (Math.abs(n) + Math.abs(n9) >= 180) continue;
                    unit.DoAction(3, n8, n3, n2);
                    unit._requested_action = false;
                    break;
                }
            }
        }
    }

    public static void TrainUnit(int n, int n2) {
        int n3 = n * 28;
        short s = Level._unit_stats[n3 + 10];
        if (s > Level._ai_money || Level._ai_command_points >= Level._ai_max_command_points) {
            return;
        }
        if (Level._ai_command_points >= Level._ai_max_command_points) {
            return;
        }
        if (!Level.HasPower(1)) {
            return;
        }
        int n4 = 0;
        n4 = Level.GetUnitStats(n, 24);
        if (n4 == 0) {
            return;
        }
        int n5 = 0;
        boolean bl = true;
        while (n4 != 0) {
            if ((n4 & 1) != 0 && Level.GetEntityNo(6, n5, 1) == 0) {
                bl = false;
                break;
            }
            ++n5;
            n4 >>= 1;
        }
        if (!bl) {
            return;
        }
        Building building = null;
        if (n2 > 0) {
            building = (Building)Level.GetEntityById(6, n2);
        }
        if (building == null) {
            building = Level.FindSpawnBuilding(n, 1);
        }
        if (building != null && Level._buildings_off_times[building._allegiance][building._subtype] > 0) {
            return;
        }
        if (building != null) {
            building.SpawnNewUnit(n);
        }
    }

    public static void UseSW(int n, int n2, int n3) {
        if (_AI_sw_cooldown[n] > 0 || !Level.HasPower(1)) {
            return;
        }
        if (n2 <= 0 && n3 <= 0) {
            if (n == 2) {
                byte by;
                int n4 = 0;
                byte by2 = -1;
                for (by = 0; by < 64; ++by) {
                    if (_AI_groups[by][0] <= 0 || _AI_groups[by][0] <= n4) continue;
                    n4 = _AI_groups[by][0];
                    by2 = by;
                }
                if (by2 > 0) {
                    for (by = 0; by < 64; ++by) {
                        if (Level._entities_usage[by] != 1) continue;
                        Unit unit = (Unit)Level._entities[by];
                        if (unit._allegiance != 1 || unit._group != by2 || unit._garrisonBuilding != -1) continue;
                        n2 = unit._pos_x;
                        n3 = unit._pos_y;
                    }
                }
            } else {
                Building building;
                int n5;
                int n6;
                int n7;
                int n8;
                Entity entity = null;
                entity = Level.GetEntitySafe(Level.Group_GetLeader(1));
                if (entity != null) {
                    n8 = 0;
                    n7 = 0;
                    n6 = Level.GetSWStats(n, 4);
                    for (n5 = 64; n5 < 160; ++n5) {
                        if (Level._entities_usage[n5] != 1) continue;
                        building = (Building)Level._entities[n5];
                        if (building._allegiance != 1 || building._subtype == 5 || building._subtype == 6 || n6 <= (n8 = Math.abs(entity._pos_x - building._pos_x)) + (n7 = Math.abs(entity._pos_y - building._pos_y))) continue;
                        entity = null;
                        break;
                    }
                }
                if (entity == null) {
                    entity = Level.GetEntitySafe(Level.Group_GetLeader(2));
                }
                if (entity != null && n2 <= 0 && n3 <= 0) {
                    n8 = 0;
                    n7 = 0;
                    n6 = Level.GetSWStats(n, 4);
                    for (n5 = 64; n5 < 160; ++n5) {
                        if (Level._entities_usage[n5] != 1) continue;
                        building = (Building)Level._entities[n5];
                        if (building._allegiance != 1 || building._subtype == 5 || building._subtype == 6 || n6 <= (n8 = Math.abs(entity._pos_x - building._pos_x)) + (n7 = Math.abs(entity._pos_y - building._pos_y))) continue;
                        entity = null;
                        break;
                    }
                }
                if (entity != null) {
                    n2 = entity._pos_x;
                    n3 = entity._pos_y;
                } else {
                    Building building2;
                    int n9;
                    n8 = -1;
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                    for (n9 = 64; n9 < 160; ++n9) {
                        if (Level._entities_usage[n9] != 1) continue;
                        building2 = (Building)Level._entities[n9];
                        if (building2._allegiance != 1 || building2._subtype != 0) continue;
                        n6 = building2._pos_x;
                        n5 = building2._pos_y;
                        break;
                    }
                    for (n9 = 64; n9 < 160; ++n9) {
                        if (Level._entities_usage[n9] != 1) continue;
                        building2 = (Building)Level._entities[n9];
                        if (building2._allegiance != 0 || building2._subtype != 2) continue;
                        int n10 = Math.abs(n6 - building2._pos_x) + Math.abs(n5 - building2._pos_y);
                        if (n8 != -1 && n10 >= n7) continue;
                        n7 = n10;
                        n8 = n9;
                    }
                    if (n8 >= 0) {
                        Building building3 = (Building)Level._entities[n8];
                        n2 = building3._pos_x;
                        n3 = building3._pos_y;
                    } else {
                        for (n9 = 64; n9 < 160; ++n9) {
                            if (Level._entities_usage[n9] != 1) continue;
                            building2 = (Building)Level._entities[n9];
                            if (building2._allegiance != 0 || building2._subtype != 0) continue;
                            n2 = building2._pos_x;
                            n3 = building2._pos_y;
                            break;
                        }
                    }
                }
            }
        }
        if (n2 <= 0 && n3 <= 0) {
            return;
        }
        switch (n) {
            case 0: {
                if (Level.GetEntityNo(6, 9, 1) <= 0) break;
                Level.DropNuke(1, n2, n3);
                break;
            }
            case 1: {
                if (Level.GetEntityNo(6, 8, 1) <= 0) break;
                Level.DropKirov(1, n2, n3);
                break;
            }
            case 2: {
                if (Level.GetEntityNo(6, 7, 1) <= 0) break;
                Level.DropIronCurtain(1, n2, n3);
                break;
            }
            case 3: {
                if (Level.GetEntityNo(6, 8, 1) <= 0) break;
                Level.DropHarrier(1, n2, n3);
                break;
            }
            case 5: {
                if (Level.GetEntityNo(6, 9, 1) <= 0) break;
                Level.DropStorm(1, n2, n3);
            }
        }
    }

    public static void BuildStructure(int n, int n2, int n3) {
        Entity entity;
        int n4 = Level.GetBuildingStats(Level._ai_faction, n, 15);
        if (n4 > Level._ai_money) {
            return;
        }
        if (Level._buildings_off_times[1][0] > 0) {
            return;
        }
        if (Level._ai_build_points >= Level._ai_max_build_points) {
            return;
        }
        int n5 = 0;
        n5 = Level.GetBuildingStats(Level._ai_faction, n, 3);
        if (n5 == 0) {
            return;
        }
        int n6 = 0;
        boolean bl = true;
        while (n5 != 0) {
            if ((n5 & 1) != 0 && Level.GetEntityNo(6, n6, 1) == 0) {
                bl = false;
                break;
            }
            ++n6;
            n5 >>= 1;
        }
        if (!bl) {
            return;
        }
        if (n2 <= 0 || n3 <= 0) {
            for (n6 = 64; n6 < 160; ++n6) {
                if (Level._entities_usage[n6] != 1) continue;
                Building building = (Building)Level._entities[n6];
                if (building._subtype != 0 || building._allegiance != 1) continue;
                n2 = building._pos_x;
                n3 = building._pos_y;
                break;
            }
        }
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        n6 = UtilEntity.FindBuildSpot(n, n2, n3, true);
        if (n6 < 0) {
            n6 = UtilEntity.FindBuildSpot(n, n2, n3, false);
        }
        if (n6 < 0) {
            return;
        }
        int n7 = UtilEntity._buildSpots[n6 + 1];
        int n8 = UtilEntity._buildSpots[n6 + 2];
        if (n == 2) {
            entity = Level.FindClosestMineralField(n7, n8, 64);
            if (entity != null) {
                n7 = entity._pos_x;
                n8 = entity._pos_y + 1;
            } else {
                return;
            }
        }
        if ((entity = Level.SpawnBuilding(n, n7, n8, 1, Level._ai_faction)) != null) {
            UtilEntity._buildSpots[n6 + 4] = 48;
            ((Building)entity)._spotPointer = (short)n6;
            Level._ai_money -= Level.GetBuildingStats(((Building)entity)._faction, n, 15);
            Level._statistics[1] = Level._statistics[1] + 1;
        }
    }

    static boolean IsValidBuildingPosition(int n, int n2, int n3) {
        Entity entity;
        int n4 = 4;
        if (n == 2) {
            n4 = 6;
        }
        int n5 = 0;
        if (Level._ai_faction == 1) {
            n5 = 10;
        }
        if ((entity = Level.FindClosestMineralField(n2, n3, 64)) != null) {
            n2 = entity._pos_x;
            n3 = entity._pos_y;
        }
        byte[] byArray = Level.GetCMap(n5 + n);
        int n6 = Level.GetCMapHeaderData(n5 + n, 0);
        int n7 = Level.GetCMapHeaderData(n5 + n, 1);
        int n8 = Level.GetCMapHeaderData(n5 + n, 2);
        int n9 = Level.GetCMapHeaderData(n5 + n, 3);
        int n10 = (n2 + n6) / 8;
        int n11 = (n3 + n7) / 8;
        int n12 = n10 * 8;
        int n13 = n11 * 8;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        while (n16 < n9) {
            n14 = n12;
            int n17 = 0;
            while (n17 < n8) {
                if (byArray[n15] == 12 && Map.GetCollisionAtTile(n10 + n17, n11 + n16) > n4) {
                    return false;
                }
                ++n17;
                n14 += 8;
                ++n15;
            }
            ++n16;
            n13 += 8;
        }
        return true;
    }
}

