/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.GraphicsConstants;
import com.ea.game.Map;
import com.ea.game.Sprites;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Lights
implements Constants,
GraphicsConstants {
    public static int[] _lightMap;
    public static int[] _rgbBuffer;
    public static int _nrLightColors;
    public static int[] _lightColors;
    public static byte[] _lightingTable;
    public static int[][] _lightPals;
    public static int _nrLightsModule;
    public static short[] _lightsWidth;
    public static short[] _lightsHeight;
    public static short[] _lightsXo;
    public static short[] _lightsYo;
    public static short[] _lightsLineStart;
    public static short[] _lightsLineEnd;
    public static short[] _lightsLineOffset;
    public static int[] _lightsOffset;
    public static byte[] _lightsData;
    public static short _nrLights;
    public static short[] _lights;
    public static int _ambient;
    public static int _initial_ambient;
    public static int _lightMapX;
    public static int _lightMapY;
    static int _light_colorIndex;
    static int _light_intensity;
    static int _light_cdb_w;
    static int _light_cdb_h;

    static void InitLights() {
        _rgbBuffer = new int[12288];
        _lightMap = new int[12288];
        Lights.InitLightingTable();
        _lightColors = new int[24];
        _lightPals = new int[24][256];
        _nrLights = 0;
        _lights = new short[504];
        _ambient = 39398550;
    }

    static void GenerateLightsPallette() {
        for (int i = 0; i < _nrLightColors; ++i) {
            int n = _lightColors[i] >> 16 & 0xFF;
            int n2 = _lightColors[i] >> 8 & 0xFF;
            int n3 = _lightColors[i] & 0xFF;
            Lights.CreateLightPalette(i, n, n2, n3);
        }
    }

    static void AddColorToPal(int n) {
        int n2 = 0;
        for (n2 = 0; n2 < _nrLightColors && _lightColors[n2] != n; ++n2) {
        }
        if (n2 == _nrLightColors && _nrLightColors < 24) {
            Lights._lightColors[n2] = n;
            ++_nrLightColors;
        }
    }

    private static void InitLightingTable() {
        _lightingTable = new byte[4096];
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                int n = (i << 6) + j;
                int n2 = i * j * 7 / 252;
                if (n2 > 63) {
                    n2 = 63;
                }
                Lights._lightingTable[n] = (byte)n2;
            }
        }
    }

    static void CreateLightPalette(int n, int n2, int n3, int n4) {
        for (int i = 0; i < 256; ++i) {
            int n5 = n2 * i / 255;
            int n6 = n3 * i / 255;
            int n7 = n4 * i / 255;
            Lights._lightPals[n][i] = n5 << 18 | n6 << 9 | n7;
        }
    }

    static void ReleaseLights() {
        _rgbBuffer = null;
        _lightMap = null;
        _lightingTable = null;
        _lightsWidth = null;
        _lightsHeight = null;
        _lightsXo = null;
        _lightsYo = null;
        _lightsLineStart = null;
        _lightsLineEnd = null;
        _lightsLineOffset = null;
        _lightsOffset = null;
        _lightsData = null;
        _lights = null;
        _lightColors = null;
    }

    static void CleanLights() {
        _nrLights = 0;
        _initial_ambient = _ambient = 39398550;
    }

    static void LoadLightMapEntity(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        _lightMapX = sDKInputStream.readShort();
        _lightMapY = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
    }

    static void LoadLightEntity(SDKInputStream sDKInputStream) throws IOException {
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        short s3 = sDKInputStream.readShort();
        short s4 = sDKInputStream.readShort();
        short s5 = sDKInputStream.readShort();
        int n = sDKInputStream.read() & 0xFF;
        int n2 = sDKInputStream.read() & 0xFF;
        int n3 = sDKInputStream.read() & 0xFF;
        int n4 = sDKInputStream.read() & 0xFF;
        int n5 = sDKInputStream.read() & 0xFF;
    }

    static void DrawLights(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 * n4 > 12288) {
            Lights.DrawLights(n, n2, n3 >> 1, n4, n5, n6);
            Lights.DrawLights(n + (n3 >> 1), n2, n3 >> 1, n4, n5 + (n3 >> 1), n6);
            return;
        }
        XSprite.SetBuffer(_rgbBuffer, n3);
        XSprite.DecoderClip(0, 0, n3, n4);
        int n7 = XSprite._op;
        int n8 = Camera._nCamX;
        int n9 = Camera._nCamY;
        XSprite._op = 4;
        Camera._nCamX = n5;
        Camera._nCamY = n6;
        Utils.MemSet(_lightMap, _ambient);
        XSprite.SetBuffer(_lightMap, n3);
        XSprite xSprite = Sprites._sprites[3];
        int n10 = 0;
        int n11 = 0;
        while (n10 < _nrLights) {
            short s = _lights[n11 + 1];
            int n12 = _lights[n11 + 2] - n5 + _lightMapX;
            int n13 = _lights[n11 + 3] - n6 + _lightMapY;
            XSprite.SetLight(_lightPals[_lights[n11 + 4] & 0xFFFF], _lights[n11 + 5] & 0xFFFF, _lights[n11 + 6] & 0xFFFF);
            xSprite.DrawFrame(s, n12, n13, 0);
            ++n10;
            n11 += 7;
        }
        XSprite._op = n7;
        Camera._nCamX = n8;
        Camera._nCamY = n9;
        Map._imgBB.getRGB(_rgbBuffer, 0, n3, n, n2, n3, n4);
        Lights.Shade(_rgbBuffer, _lightMap, n3 * n4);
        Map._gBB.drawRGB(_rgbBuffer, 0, n3, n, n2, n3, n4, false);
    }

    static void Shade(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            int n3 = nArray2[i];
            nArray[i] = _lightingTable[((n2 >> 19 & 0x1F) << 6) + (n3 >> 20 & 0x1F)] << 19 | _lightingTable[((n2 >> 11 & 0x1F) << 6) + (n3 >> 11 & 0x1F)] << 11 | _lightingTable[((n2 >> 3 & 0x1F) << 6) + (n3 >> 2 & 0x1F)] << 3;
        }
    }

    static void ShadeRegion(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n4 > 0) {
            int n6 = n3;
            while (n6 > 0) {
                int n7 = _rgbBuffer[n5];
                if (n7 == 0) {
                    Lights._rgbBuffer[n5] = 0;
                } else {
                    int n8 = _lightMap[n5];
                    Lights._rgbBuffer[n5] = _lightingTable[((n7 >> 19 & 0x1F) << 6) + (n8 >> 20 & 0x1F)] << 19 | _lightingTable[((n7 >> 11 & 0x1F) << 6) + (n8 >> 11 & 0x1F)] << 11 | _lightingTable[((n7 >> 3 & 0x1F) << 6) + (n8 >> 2 & 0x1F)] << 32;
                }
                --n6;
                ++n5;
            }
            --n4;
        }
    }

    static void DrawLight(int n, int n2, int n3, int n4) {
        if (_light_intensity == 0) {
            return;
        }
        n2 -= Camera._nCamX;
        n3 -= Camera._nCamY;
        int n5 = _lightsWidth[n];
        int n6 = _lightsHeight[n];
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 0;
        if (n2 < 0) {
            n9 = -n2;
            n5 += n2;
            n2 = 0;
            if (n5 <= 0) {
                return;
            }
        }
        if (n3 < 0) {
            n10 = -n3;
            n6 += n3;
            n3 = 0;
            if (n6 <= 0) {
                return;
            }
        }
        if (n2 + n5 > _light_cdb_w && (n5 = _light_cdb_w - n2) <= 0) {
            return;
        }
        if (n3 + n6 > _light_cdb_h && (n6 = _light_cdb_h - n3) <= 0) {
            return;
        }
        int n11 = 1;
        int n12 = 1;
        if ((n4 & 1) != 0) {
            n11 = -1;
        }
        if ((n4 & 2) != 0) {
            n10 = n8 - 1 - n10;
            n12 = -n12;
        }
        int n13 = n12 * n7;
        int n14 = n10 * n7 + _lightsOffset[n];
        int n15 = n2 + n3 * _light_cdb_w;
        int n16 = 255 - _light_intensity;
        int n17 = _light_colorIndex << 8;
        while (n6 != 0) {
            int n18;
            int n19;
            if (n11 < 0) {
                n19 = n7 - 1 - _lightsLineEnd[_lightsLineOffset[n] + n10];
                n18 = n7 - 1 - _lightsLineStart[_lightsLineOffset[n] + n10];
            } else {
                n19 = _lightsLineStart[_lightsLineOffset[n] + n10];
                n18 = _lightsLineEnd[_lightsLineOffset[n] + n10];
            }
            if (n19 < n9) {
                n19 = n9;
            }
            if (n18 >= n9 + n5) {
                n18 = n9 + n5 - 1;
            }
            int n20 = n11 < 0 ? n14 + n7 - 1 - n19 : n14 + n19;
            int n21 = n15 + n19 - n9;
            for (int i = n19; i <= n18; ++i) {
                int n22 = _lightsData[n20] & 0xFF;
                if ((n22 -= n16) > 1) {
                    int n23 = _lightMap[n21];
                    n22 = _lightPals[n17][n22];
                    int n24 = (n22 += n23) & 0x4020100;
                    n24 -= n24 >> 6;
                    n22 |= n24;
                    Lights._lightMap[n21] = n22 &= 0x3FDFEFF;
                }
                n20 += n11;
                ++n21;
            }
            n10 += n12;
            n14 += n13;
            n15 += _light_cdb_w;
            --n6;
        }
    }

    static int GetLight(int n) {
        int n2 = 0;
        for (int i = 0; i < _nrLights; ++i) {
            if (_lights[n2 + 0] == n) {
                return n2;
            }
            n2 += 7;
        }
        return -1;
    }

    static void InvalidateLight(int n, boolean bl) {
        short s = _lights[n + 1];
        short s2 = _lights[n + 2];
        short s3 = _lights[n + 3];
        XSprite xSprite = Sprites._sprites[3];
        xSprite.RectFrame(s, s2, s3, 0);
        if (!bl) {
            Map.CDB_AddInvalidateRegion(XSprite._rect);
        } else {
            Map.CDB_InvalidatePixels(XSprite._rect[0], XSprite._rect[1], XSprite._rect[2] - XSprite._rect[0], XSprite._rect[3] - XSprite._rect[1], bl);
        }
    }

    static void CleanDynamicLights() {
        int n = 504;
        for (int i = 72; i < 288; ++i) {
            Lights._lights[n + 0] = 0;
            Lights._lights[n + 1] = 6;
            Lights._lights[n + 2] = 0;
            Lights._lights[n + 3] = 0;
            Lights._lights[n + 4] = 0;
            Lights._lights[n + 5] = 0;
            n += 7;
        }
    }

    static int GetDynamicLight() {
        int n = 504;
        for (int i = 72; i < 288; ++i) {
            if (_lights[n + 5] <= 0) {
                return n;
            }
            n += 7;
        }
        return -1;
    }
}

