/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.MsgBox;
import com.ea.game.SpriteConstants;
import com.ea.game.Sprites;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Tutorial
implements Constants,
UnitsConstants,
SpriteConstants,
GraphicsConstants,
BuildingConstants {
    static int[][] _tutorials;
    static SDKString _string;
    static int[] _rect;

    static void Tutorials_Init() {
        _tutorials = new int[8][];
        for (int i = 0; i < 8; ++i) {
            Tutorial._tutorials[i] = new int[11];
            Tutorial._tutorials[i][0] = 0;
            Tutorial._tutorials[i][2] = 0;
        }
    }

    static void Tutorials_Release() {
        if (_tutorials != null) {
            for (int i = 0; i < 8; ++i) {
                Tutorial._tutorials[i] = null;
            }
            _tutorials = null;
        }
        System.gc();
    }

    static void Tutorials_Clean() {
        for (int i = 0; i < 8; ++i) {
            Tutorial._tutorials[i][0] = 0;
            Tutorial._tutorials[i][2] = 0;
        }
    }

    static void Tutorials_Update() {
        Hud._bTutorialOn = false;
        block11: for (int i = 0; i < 8; ++i) {
            if (_tutorials[i][0] != 1) continue;
            int n = _tutorials[i][1];
            switch (n) {
                case 0: {
                    Tutorial.UpdateCursorMovementTutorial(i);
                    continue block11;
                }
                case 1: {
                    Tutorial.UpdateUnitsMovementTutorial(i);
                    continue block11;
                }
                case 2: {
                    Tutorial.UpdateAttackTutorial(i);
                    continue block11;
                }
                case 3: {
                    Tutorial.UpdateBuildTutorial(i);
                    continue block11;
                }
                case 4: {
                    Tutorial.UpdateGroupTutorial(i);
                    continue block11;
                }
                case 5: {
                    Tutorial.UpdateTrainTutorial(i);
                    continue block11;
                }
                case 6: {
                    Tutorial.UpdateSelectTutorial(i);
                    continue block11;
                }
                case 7: {
                    Tutorial.UpdateSWTutorial(i);
                    continue block11;
                }
                case 8: {
                    Tutorial.UpdateGarrisonTutorial(i);
                }
            }
        }
    }

    static void Tutorials_Draw(SDKGraphics sDKGraphics) {
        block11: for (int i = 0; i < 8; ++i) {
            if (_tutorials[i][0] != 1) continue;
            int n = _tutorials[i][1];
            switch (n) {
                case 0: {
                    Tutorial.DrawCursorMovementTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 1: {
                    Tutorial.DrawUnitsMovementTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 2: {
                    Tutorial.DrawAttackTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 3: {
                    Tutorial.DrawBuildTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 4: {
                    Tutorial.DrawGroupTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 5: {
                    Tutorial.DrawTrainTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 6: {
                    Tutorial.DrawSelectTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 7: {
                    Tutorial.DrawSWTutorial(i, sDKGraphics);
                    continue block11;
                }
                case 8: {
                    Tutorial.DrawGarrisonTutorial(i, sDKGraphics);
                }
            }
        }
    }

    static void EndTutorial(int n) {
        block3: for (int i = 0; i < 8; ++i) {
            if (_tutorials[i][2] != n) continue;
            Tutorial._tutorials[i][0] = 0;
            Tutorial._tutorials[i][2] = 0;
            int n2 = _tutorials[i][1];
            switch (n2) {
                case 1: 
                case 2: {
                    if (_tutorials[i][7] == -1) continue block3;
                    Entity entity = Level.GetEntitySafe(_tutorials[i][7]);
                    Level.DeleteEntity(entity);
                }
            }
        }
    }

    static int FindTutorialSlot() {
        for (int i = 0; i < 8; ++i) {
            if (_tutorials[i][0] != 0) continue;
            return i;
        }
        return -1;
    }

    static void StartCursorMovementTutorial(int n, int n2) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n3 = Tutorial.FindTutorialSlot();
        if (n3 >= 0) {
            Tutorial._tutorials[n3][0] = 1;
            Tutorial._tutorials[n3][2] = n;
            Tutorial._tutorials[n3][1] = 0;
            Tutorial._tutorials[n3][5] = 0;
            Tutorial._tutorials[n3][6] = n2;
            Tutorial._tutorials[n3][7] = 1;
            Cursor._disableSelection = true;
        }
    }

    static void UpdateCursorMovementTutorial(int n) {
        if (_tutorials[n][7] == 0) {
            int[] nArray = _tutorials[n];
            nArray[5] = nArray[5] + 1;
        }
        if (_tutorials[n][5] > _tutorials[n][6]) {
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
            Cursor._disableSelection = false;
        }
    }

    static void DrawCursorMovementTutorial(int n, SDKGraphics sDKGraphics) {
        int n2 = GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX;
        int n3 = GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY;
        XSprite xSprite = Sprites._sprites[11];
        if (SDKCanvas.isKeyPressed(513)) {
            Tutorial._tutorials[n][7] = 0;
            xSprite.DrawFrame(32, n2, n3 + -32, 0);
        } else {
            xSprite.DrawFrame(31, n2, n3 + -32, 0);
        }
        if (SDKCanvas.isKeyPressed(2052)) {
            Tutorial._tutorials[n][7] = 0;
            xSprite.DrawFrame(38, n2 + -32, n3, 0);
        } else {
            xSprite.DrawFrame(37, n2 + -32, n3, 0);
        }
        if (SDKCanvas.isKeyPressed(8200)) {
            Tutorial._tutorials[n][7] = 0;
            xSprite.DrawFrame(34, n2 + 32, n3, 0);
        } else {
            xSprite.DrawFrame(33, n2 + 32, n3, 0);
        }
        if (SDKCanvas.isKeyPressed(32770)) {
            Tutorial._tutorials[n][7] = 0;
            xSprite.DrawFrame(36, n2, n3 + 32, 0);
        } else {
            xSprite.DrawFrame(35, n2, n3 + 32, 0);
        }
    }

    static void StartUnitsMovementTutorial(int n, int n2, int n3, int n4) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n5 = Tutorial.FindTutorialSlot();
        if (n5 >= 0) {
            Tutorial._tutorials[n5][0] = 1;
            Tutorial._tutorials[n5][2] = n;
            Tutorial._tutorials[n5][1] = 1;
            Tutorial._tutorials[n5][5] = 0;
            Tutorial._tutorials[n5][3] = n2;
            Tutorial._tutorials[n5][4] = n3;
            Tutorial._tutorials[n5][9] = n4;
            Entity entity = Level.SpawnEntity(2);
            if (entity != null) {
                entity.Decorator_Init(n2, n3, 13, 0, 0, 2, -1, 0);
                Tutorial._tutorials[n5][7] = entity.GetPointer();
            } else {
                Tutorial._tutorials[n5][7] = -1;
            }
        }
    }

    static void UpdateUnitsMovementTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            Tutorial._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._allegiance != 0) continue;
            int n2 = _tutorials[n][3] - unit._pos_x;
            int n3 = _tutorials[n][4] - unit._pos_y;
            if (Math.abs(n2) + Math.abs(n3) >= 32) continue;
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
            if (_tutorials[n][7] == -1) break;
            Entity entity = Level.GetEntitySafe(_tutorials[n][7]);
            Level.DeleteEntity(entity);
            break;
        }
    }

    static void DrawUnitsMovementTutorial(int n, SDKGraphics sDKGraphics) {
        int n2 = GameImpl.SV_X + _tutorials[n][3] - Camera._nCamX;
        int n3 = GameImpl.SV_Y + _tutorials[n][4] - Camera._nCamY;
        int n4 = _tutorials[n][3] - Cursor._nCursorPosX;
        int n5 = _tutorials[n][4] - Cursor._nCursorPosY;
        if (Math.abs(n4) + Math.abs(n5) < 16) {
            XSprite xSprite = Sprites._sprites[11];
            n2 = GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX;
            n3 = GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY;
            if (Hud._hud_state == 1) {
                if (_tutorials[n][5] > 2) {
                    xSprite.DrawFrame(40, n2, n3 + 24, 0);
                } else {
                    xSprite.DrawFrame(39, n2, n3 + 24, 0);
                }
            }
        }
    }

    static void StartAttackTutorial(int n, int n2, int n3, int n4, int n5) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n6 = Tutorial.FindTutorialSlot();
        if (n6 >= 0) {
            Entity entity;
            Tutorial._tutorials[n6][0] = 1;
            Tutorial._tutorials[n6][2] = n;
            Tutorial._tutorials[n6][1] = 2;
            Tutorial._tutorials[n6][10] = n5;
            Tutorial._tutorials[n6][3] = n2;
            Tutorial._tutorials[n6][4] = n3;
            if (n5 > 0) {
                entity = Level.GetEntityById(-1, n5);
                if (entity != null) {
                    Tutorial._tutorials[n6][3] = entity._pos_x;
                    Tutorial._tutorials[n6][4] = entity._pos_y;
                    Tutorial._tutorials[n6][10] = entity.GetPointer();
                } else {
                    Tutorial._tutorials[n6][0] = 0;
                    Tutorial._tutorials[n6][2] = 0;
                    return;
                }
            }
            Tutorial._tutorials[n6][9] = n4;
            Tutorial._tutorials[n6][5] = 0;
            entity = Level.SpawnEntity(2);
            if (entity != null) {
                entity.Decorator_Init(_tutorials[n6][3], _tutorials[n6][4] - 16, 14, 6, 0, 4, -1, 0);
                Tutorial._tutorials[n6][7] = entity.GetPointer();
            } else {
                Tutorial._tutorials[n6][7] = -1;
            }
        }
    }

    static void UpdateAttackTutorial(int n) {
        Entity entity;
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            Tutorial._tutorials[n][5] = 0;
        }
        boolean bl = false;
        if (Cursor.GetCursorAction() == 4 && SDKCanvas.isNewKeyReleased(4112) && !Cursor._bcursorDoubleTap) {
            bl = true;
        }
        if (_tutorials[n][10] > 0) {
            entity = Level.GetEntitySafe(_tutorials[n][10]);
            if (entity == null) {
                bl = true;
            } else {
                Entity entity2 = Level.GetEntitySafe(_tutorials[n][7]);
                entity2._pos_x = entity._pos_x;
                entity2._pos_y = entity._pos_y - 16;
                switch (entity._type) {
                    case 5: {
                        Unit unit = (Unit)entity;
                        if (unit._life > 0) break;
                        bl = true;
                        break;
                    }
                    case 6: {
                        Building building = (Building)entity;
                        if (building._life >= 0) break;
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
            if (_tutorials[n][7] != -1) {
                entity = Level.GetEntitySafe(_tutorials[n][7]);
                Level.DeleteEntity(entity);
            }
        }
    }

    static void DrawAttackTutorial(int n, SDKGraphics sDKGraphics) {
        int n2 = _tutorials[n][3] - Cursor._nCursorPosX;
        int n3 = _tutorials[n][4] - Cursor._nCursorPosY;
        if (Cursor.GetCursorAction() == 4 && Math.abs(n2) + Math.abs(n3) < 16) {
            XSprite xSprite = Sprites._sprites[11];
            int n4 = GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX;
            int n5 = GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY;
            if (Hud._hud_state == 1) {
                if (_tutorials[n][5] > 2) {
                    xSprite.DrawFrame(40, n4, n5 + 24, 0);
                } else {
                    xSprite.DrawFrame(39, n4, n5 + 24, 0);
                }
            }
        }
    }

    static void StartGroupTutorial(int n, int n2, int n3) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n4 = Tutorial.FindTutorialSlot();
        if (n4 >= 0) {
            Tutorial._tutorials[n4][0] = 1;
            Tutorial._tutorials[n4][2] = n;
            Tutorial._tutorials[n4][1] = 4;
            Tutorial._tutorials[n4][8] = n2;
            Tutorial._tutorials[n4][9] = n3;
        }
    }

    static void UpdateGroupTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 2) {
            Tutorial._tutorials[n][5] = 0;
            boolean bl = Hud._blink_RSK = !Hud._blink_RSK;
        }
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        if (Level._currentGroup == _tutorials[n][8]) {
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
            Hud._blink_RSK = true;
        }
    }

    static void DrawGroupTutorial(int n, SDKGraphics sDKGraphics) {
    }

    static void StartBuildTutorial(int n, int n2, int n3, int n4) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n5 = Tutorial.FindTutorialSlot();
        if (n5 >= 0) {
            Tutorial._tutorials[n5][0] = 1;
            Tutorial._tutorials[n5][2] = n;
            Tutorial._tutorials[n5][1] = 3;
            Tutorial._tutorials[n5][5] = 0;
            Tutorial._tutorials[n5][6] = n2;
            Tutorial._tutorials[n5][9] = n3;
            Tutorial._tutorials[n5][10] = n4;
            int n6 = 0;
            for (int i = 64; i < 160; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Building building = (Building)Level._entities[i];
                if (building._subtype != n2 || building._allegiance != 0) continue;
                ++n6;
            }
            Tutorial._tutorials[n5][7] = n6;
            Hud._hud_current_tab = 0;
            if (Hud._hud_state == 2 && Hud._hud_substate != 0) {
                Hud.Build_ChangeSubState(0);
            }
        }
    }

    static void UpdateBuildTutorial(int n) {
        Hud._bTutorialOn = true;
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            Tutorial._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        if (_tutorials[n][10] >= 0 && Hud._hud_state == 2 && Hud._hud_substate == 2 && Hud._hud_building == _tutorials[n][6]) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][10], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][10] = -1;
        }
        int n2 = 0;
        for (int i = 64; i < 160; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Building building = (Building)Level._entities[i];
            if (building._subtype != _tutorials[n][6] || building._allegiance != 0) continue;
            ++n2;
        }
        if (n2 > _tutorials[n][7]) {
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
        }
    }

    static void DrawBuildTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state == 2) {
            if (Hud._hud_substate != 2 && Hud._hud_current_tab == 0 && Hud._hud_substate != 5) {
                byte by = Hud._hud_build_cursor_pos[0];
                int n2 = Hud._hud_build_page_pos[0];
                byte[] byArray = Hud._hud_build_items_available[0];
                int n3 = 100;
                byte by2 = Hud._hud_build_items_count[0];
                boolean bl = false;
                if (by != -1 && (byArray[by] == _tutorials[n][6] || byArray[by] - 50 == _tutorials[n][6])) {
                    n3 = 100 + (by - n2) * 39;
                    bl = true;
                    if (_tutorials[n][5] > 0 && Hud._hud_substate != 2 && Hud._hud_substate != 5) {
                        Tutorial.DrawSelectBlinkSquare(n, n3, sDKGraphics);
                    }
                } else {
                    for (int i = n2; i < n2 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS; ++i) {
                        if (!(byArray[i] != _tutorials[n][6] && byArray[i] - 50 != _tutorials[n][6] || bl)) {
                            bl = true;
                            if (_tutorials[n][5] > 0 && Hud._hud_substate != 2 && Hud._hud_substate != 5) {
                                Tutorial.DrawUnSelectBlinkSquare(n, n3, sDKGraphics);
                            }
                        }
                        n3 += 39;
                    }
                }
                if (!bl && _tutorials[n][6] < byArray[n2] && _tutorials[n][5] > 0) {
                    Tutorial.DrawUpArrowBlinkSquare(n, n3, sDKGraphics);
                }
                if (!bl && n2 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS < by2 && _tutorials[n][6] >= byArray[n2 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS] && _tutorials[n][5] > 0) {
                    Tutorial.DrawDownArrowBlinkSquare(n, n3, sDKGraphics);
                }
            }
        } else if (Hud._hud_state == 1) {
            XSprite xSprite = Sprites._sprites[11];
            int n4 = _tutorials[n][5] > 2 ? 41 : 42;
            SDKUtils.setFont(GameImpl.fonts[4]);
            xSprite.DrawFrame(n4, GameImpl.SCR_W >> 1, GameImpl.SCR_H - SDKUtils.getLineSize() - 12, 0);
            SDKUtils.getString(95, _string);
            SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H - 50 - 12, 33);
            SDKUtils.getString(107, _string);
            SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H - 12, 33);
        }
    }

    static void StartTrainTutorial(int n, int n2, int n3, int n4, int n5) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n6 = Tutorial.FindTutorialSlot();
        if (n6 >= 0) {
            Tutorial._tutorials[n6][0] = 1;
            Tutorial._tutorials[n6][2] = n;
            Tutorial._tutorials[n6][1] = 5;
            Tutorial._tutorials[n6][5] = 0;
            Tutorial._tutorials[n6][6] = n2;
            Tutorial._tutorials[n6][8] = n3;
            Tutorial._tutorials[n6][9] = n4;
            Tutorial._tutorials[n6][10] = n5;
            int n7 = 0;
            for (int i = 0; i < 64; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit._subtype != n2 || unit._allegiance != 0) continue;
                ++n7;
            }
            Tutorial._tutorials[n6][7] = n7;
            Hud._hud_current_tab = 1;
            if (_tutorials[n6][8] > 0) {
                Hud._hud_current_squad = _tutorials[n6][8];
            }
            if (Hud._hud_state == 2 && Hud._hud_substate == 1) {
                Hud.Build_ChangeSubState(0);
            }
            if (Hud._hud_state == 2 && Hud._hud_substate == 5) {
                Hud.Build_ChangeSubState(0);
            }
        }
    }

    static void UpdateTrainTutorial(int n) {
        Hud._bTutorialOn = true;
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            Tutorial._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        if (_tutorials[n][10] >= 0 && Hud._hud_state == 2 && Hud._hud_substate == 1 && Hud._hud_build_items_available[1][Hud._hud_build_cursor_pos[1]] == _tutorials[n][6]) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][10], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][10] = -1;
        }
        int n2 = 0;
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._subtype != _tutorials[n][6] || unit._allegiance != 0) continue;
            ++n2;
        }
        if (n2 > _tutorials[n][7]) {
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
        }
    }

    static void DrawTrainTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state == 2) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if (Hud._hud_substate != 1 && Hud._hud_substate != 2 && Hud._hud_current_tab == 1) {
                n6 = Hud._hud_build_cursor_pos[1];
                n5 = Hud._hud_build_page_pos[1];
                byte[] byArray = Hud._hud_build_items_available[1];
                n4 = 100;
                n3 = 0;
                if (n6 != -1 && (byArray[n6] == _tutorials[n][6] || byArray[n6] - 50 == _tutorials[n][6])) {
                    n3 = 1;
                    n4 = 100 + (n6 - n5) * 39;
                    Tutorial.DrawSelectBlinkSquare(n, n4, sDKGraphics);
                } else {
                    for (n2 = n5; n2 < n5 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS; ++n2) {
                        if ((byArray[n2] == _tutorials[n][6] || byArray[n2] - 50 == _tutorials[n][6]) && n3 == 0) {
                            n3 = 1;
                            Tutorial.DrawUnSelectBlinkSquare(n, n4, sDKGraphics);
                        }
                        n4 += 39;
                    }
                }
                if (n3 == 0 && _tutorials[n][6] < n5 && _tutorials[n][5] > 0) {
                    Tutorial.DrawUpArrowBlinkSquare(n, n4, sDKGraphics);
                }
                if (n3 == 0 && _tutorials[n][6] >= n5 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS && _tutorials[n][5] > 0) {
                    Tutorial.DrawDownArrowBlinkSquare(n, n4, sDKGraphics);
                }
            }
            if (Hud._hud_substate == 1) {
                n6 = _tutorials[n][8];
                n5 = _tutorials[n][6];
                if (n6 > 0 && n5 == Hud._hud_build_items_available[Hud._hud_current_tab][Hud._hud_build_cursor_pos[Hud._hud_current_tab]]) {
                    int n7;
                    byte by = Hud._hud_build_cursor_pos[Hud._hud_current_tab];
                    n4 = Hud._hud_build_page_pos[Hud._hud_current_tab];
                    n3 = GameImpl.HUD_BUILD_SQUADS_POSX;
                    n2 = 100 + (by - n4) * 39;
                    int n8 = n7 = n2 - 16 + 8;
                    int n9 = 1;
                    while (n9 < 3) {
                        if (n9 == n6) {
                            if (_tutorials[n][5] > 0) {
                                sDKGraphics.setColor(0xFFFF00);
                                if (Hud._hud_current_squad == n6) {
                                    sDKGraphics.drawRect(n3 + -23, n8 + -10, 46, 20);
                                } else {
                                    sDKGraphics.drawRect(n3 + -18, n8 + -8, 36, 16);
                                }
                            }
                            break;
                        }
                        ++n9;
                        n8 += 16;
                    }
                }
            }
        } else if (Hud._hud_state == 1) {
            XSprite xSprite = Sprites._sprites[11];
            int n10 = _tutorials[n][5] > 2 ? 43 : 44;
            SDKUtils.setFont(GameImpl.fonts[4]);
            xSprite.DrawFrame(n10, GameImpl.SCR_W >> 1, GameImpl.SCR_H - SDKUtils.getLineSize(), 0);
            SDKUtils.getString(95, _string);
            SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H - 50, 33);
            SDKUtils.getString(106, _string);
            SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H, 33);
        }
    }

    static void StartSelectTutorial(int n, int n2, int n3) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n4 = Tutorial.FindTutorialSlot();
        if (n4 >= 0) {
            Tutorial._tutorials[n4][0] = 1;
            Tutorial._tutorials[n4][2] = n;
            Tutorial._tutorials[n4][5] = 0;
            Tutorial._tutorials[n4][1] = 6;
            Tutorial._tutorials[n4][6] = n2;
            Tutorial._tutorials[n4][9] = n3;
        }
    }

    static void UpdateSelectTutorial(int n) {
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            Tutorial._tutorials[n][5] = 0;
        }
        int n2 = 0;
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._subtype != _tutorials[n][6] || unit._allegiance != 0 || !unit._bSelected) continue;
            ++n2;
        }
        if (n2 > 0) {
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
        }
    }

    static void DrawSelectTutorial(int n, SDKGraphics sDKGraphics) {
        Unit unit;
        int n2;
        int n3;
        Constants constants;
        int n4 = Cursor._targetPointer & 0xFFFF;
        XSprite xSprite = Sprites._sprites[13];
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            constants = (Unit)Level._entities[i];
            if (((Unit)constants)._subtype != _tutorials[n][6] || ((Unit)constants)._allegiance != 0 || ((Unit)constants)._bSelected) continue;
            n3 = GameImpl.SV_X + ((Entity)constants)._pos_x - Camera._nCamX;
            n2 = GameImpl.SV_Y + ((Entity)constants)._pos_y - Camera._nCamY;
            if (Hud._hud_state != 1) continue;
            if (_tutorials[n][5] > 2) {
                xSprite.DrawFrame(19, n3, n2 - 24, 0);
                continue;
            }
            xSprite.DrawFrame(20, n3, n2 - 24, 0);
        }
        if (n4 >= 0 && n4 < 64 && (unit = (Unit)Level.GetEntitySafe(Cursor._targetPointer)) != null && unit._subtype == _tutorials[n][6]) {
            constants = Sprites._sprites[11];
            n3 = GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX;
            n2 = GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY;
            if (Hud._hud_state == 1) {
                if (_tutorials[n][5] > 2) {
                    ((XSprite)constants).DrawFrame(40, n3, n2 + 24, 0);
                } else {
                    ((XSprite)constants).DrawFrame(39, n3, n2 + 24, 0);
                }
            }
        }
    }

    static void StartSWTutorial(int n, int n2, int n3, int n4, int n5) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n6 = Tutorial.FindTutorialSlot();
        if (n6 >= 0) {
            Tutorial._tutorials[n6][0] = 1;
            Tutorial._tutorials[n6][2] = n;
            Tutorial._tutorials[n6][1] = 7;
            Tutorial._tutorials[n6][5] = 0;
            Tutorial._tutorials[n6][6] = n2;
            Tutorial._tutorials[n6][9] = n3;
            Tutorial._tutorials[n6][10] = n4;
            Tutorial._tutorials[n6][8] = n5;
            Hud._hud_current_tab = 2;
            if (Hud._hud_state == 2 && (Hud._hud_substate == 3 || Hud._hud_substate == 4)) {
                Hud.Build_ChangeSubState(0);
            }
        }
    }

    static void UpdateSWTutorial(int n) {
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            Tutorial._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        if (_tutorials[n][10] >= 0 && Hud._hud_state == 2 && Hud._hud_substate == 3 && Hud._hud_sw == _tutorials[n][6]) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][10], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][10] = -1;
            if (Hud._hud_sw != 4) {
                Tutorial._tutorials[n][0] = 0;
                Tutorial._tutorials[n][2] = 0;
            }
        }
        if (_tutorials[n][8] >= 0 && Hud._hud_state == 2 && Hud._hud_substate == 4 && Hud._hud_sw == _tutorials[n][6]) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][8], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][8] = -1;
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
        }
    }

    static void DrawSWTutorial(int n, SDKGraphics sDKGraphics) {
        if (Hud._hud_state == 2) {
            if (Hud._hud_substate != 3 && Hud._hud_substate != 4 && Hud._hud_current_tab == 2) {
                byte by = Hud._hud_build_cursor_pos[2];
                int n2 = Hud._hud_build_page_pos[2];
                byte[] byArray = Hud._hud_build_items_available[2];
                int n3 = 100;
                boolean bl = false;
                int n4 = _tutorials[n][6];
                if (by != -1 && (byArray[by] == _tutorials[n][6] || byArray[by] - 50 == _tutorials[n][6])) {
                    n3 = 100 + (by - n2) * 39;
                    bl = true;
                    Tutorial.DrawSelectBlinkSquare(n, n3, sDKGraphics);
                } else {
                    for (int i = n2; i < n2 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS; ++i) {
                        if (!(byArray[i] != n4 && byArray[i] - 50 != n4 || bl)) {
                            bl = true;
                            Tutorial.DrawUnSelectBlinkSquare(n, n3, sDKGraphics);
                        }
                        n3 += 39;
                    }
                }
                if (!bl && n4 < n2 && _tutorials[n][5] > 0) {
                    Tutorial.DrawUpArrowBlinkSquare(n, n3, sDKGraphics);
                }
                if (!bl && n4 >= n2 + GameImpl.HUD_BUILD_NR_VISIBLE_SLOTS && _tutorials[n][5] > 0) {
                    Tutorial.DrawDownArrowBlinkSquare(n, n3, sDKGraphics);
                }
            }
        } else if (Hud._hud_state == 1) {
            XSprite xSprite = Sprites._sprites[11];
            if (_tutorials[n][5] > 2) {
                xSprite.DrawFrame(78, GameImpl.SCR_W >> 1, GameImpl.SCR_H, 0);
            } else {
                xSprite.DrawFrame(79, GameImpl.SCR_W >> 1, GameImpl.SCR_H, 0);
            }
        }
    }

    static void StartGarrisonTutorial(int n, int n2, int n3, int n4) {
        if (!GameImpl._tutorialEnable) {
            return;
        }
        int n5 = Tutorial.FindTutorialSlot();
        if (n5 >= 0) {
            Entity entity = Level.GetEntityById(-1, n2);
            if (entity == null) {
                return;
            }
            Tutorial._tutorials[n5][0] = 1;
            Tutorial._tutorials[n5][2] = n;
            Tutorial._tutorials[n5][1] = 8;
            Tutorial._tutorials[n5][5] = 0;
            Tutorial._tutorials[n5][6] = entity.GetPointer();
            Tutorial._tutorials[n5][9] = n3;
            Tutorial._tutorials[n5][10] = n4;
            Entity entity2 = Level.SpawnEntity(2);
            if (entity2 != null) {
                int[] nArray = entity.ComputeBoundingBox();
                entity2.Decorator_Init(nArray[0] + nArray[2] >> 1, nArray[1], 13, 1, 0, 5, -1, 0);
                Tutorial._tutorials[n5][7] = entity2.GetPointer();
            } else {
                Tutorial._tutorials[n5][7] = -1;
            }
        }
    }

    static void UpdateGarrisonTutorial(int n) {
        Entity entity;
        int[] nArray = _tutorials[n];
        nArray[5] = nArray[5] + 1;
        if (_tutorials[n][5] >= 4) {
            Tutorial._tutorials[n][5] = 0;
        }
        if (_tutorials[n][9] >= 0) {
            if (Level._skipMovieState == 0) {
                MsgBox.Add(_tutorials[n][9], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
            }
            Tutorial._tutorials[n][9] = -1;
        }
        if ((entity = Level.GetEntitySafe(_tutorials[n][6])).GarrisonBld_IsOccupied()) {
            if (_tutorials[n][10] >= 0) {
                if (Level._skipMovieState == 0) {
                    MsgBox.Add(_tutorials[n][10], -1, -1, -1, -1, -1, -1, 6, 32, 8, 0, false);
                }
                Tutorial._tutorials[n][10] = -1;
            }
            Level.DeleteEntity(_tutorials[n][7]);
            Tutorial._tutorials[n][0] = 0;
            Tutorial._tutorials[n][2] = 0;
        }
    }

    static void DrawGarrisonTutorial(int n, SDKGraphics sDKGraphics) {
        if (Cursor._targetPointer == _tutorials[n][6] && Cursor.GetCursorAction() == 5) {
            XSprite xSprite = Sprites._sprites[11];
            int n2 = GameImpl.SV_X + Cursor._nCursorPosX - Camera._nCamX;
            int n3 = GameImpl.SV_Y + Cursor._nCursorPosY - Camera._nCamY;
            if (Hud._hud_state == 1) {
                if (_tutorials[n][5] > 2) {
                    xSprite.DrawFrame(40, n2, n3 + 11, 0);
                } else {
                    xSprite.DrawFrame(39, n2, n3 + 11, 0);
                }
            }
        }
    }

    static void DrawSelectBlinkSquare(int n, int n2, SDKGraphics sDKGraphics) {
        if (_tutorials[n][5] > 0) {
            sDKGraphics.setColor(0xFFFF00);
            sDKGraphics.drawRect(GameImpl.HUD_BUILD_POSX + -29, n2 + -21, 42, 39);
        }
    }

    static void DrawUnSelectBlinkSquare(int n, int n2, SDKGraphics sDKGraphics) {
        if (_tutorials[n][5] > 0) {
            sDKGraphics.setColor(0xFFFF00);
            sDKGraphics.drawRect(GameImpl.HUD_BUILD_POSX + -16, n2 + -21, 42, 39);
        }
    }

    static void DrawUpArrowBlinkSquare(int n, int n2, SDKGraphics sDKGraphics) {
        if (_tutorials[n][5] > 0) {
            sDKGraphics.setColor(0xFFFF00);
            sDKGraphics.drawRect(GameImpl.HUD_BUILD_POSX + -14, 71, 28, 8);
        }
    }

    static void DrawDownArrowBlinkSquare(int n, int n2, SDKGraphics sDKGraphics) {
        if (_tutorials[n][5] > 0) {
            sDKGraphics.setColor(0xFFFF00);
            sDKGraphics.drawRect(GameImpl.HUD_BUILD_POSX + -14, GameImpl.HUD_BUILD_SLOT_BOTTOM_ARROW_POSY, 28, 8);
        }
    }

    static {
        _string = new SDKString("");
    }
}

