/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Debug;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.Level;
import com.ea.game.Lights;
import com.ea.game.Region;
import com.ea.game.Sprites;
import com.ea.game.Unit;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;

public class Map
implements Constants,
BuildingConstants {
    public static int _nrTiles;
    public static short[] _tilePalette;
    public static byte[] _map;
    public static int _map_tw;
    public static int _map_th;
    public static int _map_size;
    public static int _map_w;
    public static int _map_h;
    public static int _map_vcell_w;
    public static int _map_vcell_h;
    public static byte[] _coll_map;
    public static int _coll_map_tw;
    public static int _coll_map_th;
    public static int _coll_map_size;
    public static int _currentTileSet;
    static int _validTileX;
    static int _validTileY;
    static int[] _xx;
    static int[] _yy;
    static int[] _invalidator_rect;
    static boolean _bInvalidatorCDB;
    public static SDKImage _imgBB;
    public static SDKGraphics _gBB;
    public static SDKGraphics _g;
    public static boolean _bResetCDB;
    public static int _CDB_view_tx;
    public static int _CDB_view_ty;
    public static int _CDB_orig_tx;
    public static int _CDB_orig_ty;
    public static int _CDB_xo;
    public static int _CDB_yo;
    public static int _CDB_oldX;
    public static int _CDB_oldY;
    public static int _CDB_x;
    public static int _CDB_y;
    public static int _CDB_w;
    public static int _CDB_h;
    public static int _CDB_nrRegions;
    public static Region[] _CDB_regions;
    public static int _CDB_separator;

    static void ClearTileMap() {
        _tilePalette = null;
        _map = null;
        _coll_map = null;
        System.gc();
    }

    static void LoadTileMap(int n) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            _currentTileSet = Sprites._tileSets[sDKInputStream.read()];
            _nrTiles = sDKInputStream.read() & 0xFF;
            _tilePalette = new short[_nrTiles];
            for (int i = 0; i < _nrTiles; ++i) {
                Map._tilePalette[i] = sDKInputStream.readShort();
            }
            _map_tw = sDKInputStream.read() & 0xFF;
            _map_th = sDKInputStream.read() & 0xFF;
            _map_size = _map_tw * _map_th;
            _map_w = _map_tw * 32;
            _map_h = _map_th * 32;
            _map_vcell_w = _map_w + 64 - 1 >> 6;
            _map_vcell_h = _map_h + 64 - 1 >> 6;
            _map = Utils.ReadByteArray(sDKInputStream, _map_size << 1, new byte[_map_size << 1], 0);
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadTileMap:", exception);
        }
    }

    static void ClearCollisionMap() {
        _coll_map = null;
        System.gc();
    }

    static void LoadCollisionMap(int n) {
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            sDKInputStream.readShort();
            sDKInputStream.readShort();
            _coll_map_tw = sDKInputStream.read() & 0xFF;
            _coll_map_th = sDKInputStream.read() & 0xFF;
            _coll_map_size = _coll_map_tw * _coll_map_th;
            _coll_map = new byte[_coll_map_size];
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < _coll_map_th) {
                boolean bl = true;
                for (int i = 0; i < _coll_map_tw; ++i) {
                    if (bl) {
                        n3 = sDKInputStream.read();
                    }
                    bl = !bl;
                    int n5 = n3 & 0xF;
                    Map._coll_map[n2 + i] = (byte)n5;
                    n3 >>= 4;
                }
                ++n4;
                n2 += _coll_map_tw;
            }
            sDKInputStream.close();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            Debug.CatchException("Exception on LoadCollisionMap:", exception);
        }
    }

    static void COLLISION_MAP__() {
    }

    static int GetCollisionAt(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= _map_w || n2 >= _map_h) {
            return 15;
        }
        return _coll_map[n2 / 8 * _coll_map_tw + n / 8] & 0x7F;
    }

    static int GetCollisionAtTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= _coll_map_tw || n2 >= _coll_map_th) {
            return 15;
        }
        return _coll_map[n2 * _coll_map_tw + n] & 0x7F;
    }

    static int GetCollisionAtTile(int n) {
        if (n < 0 || n >= _coll_map_size) {
            return 15;
        }
        return _coll_map[n] & 0x7F;
    }

    static void SetCollisionAtTile(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n >= _coll_map_tw || n2 >= _coll_map_th) {
            return;
        }
        Map._coll_map[n2 * Map._coll_map_tw + n] = (byte)(n3 & 0x7F);
    }

    static boolean NoLineOfSightCollisionBetween(Entity entity, Entity entity2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl;
        int n6 = entity._pos_x / 8;
        int n7 = entity._pos_y / 8;
        int n8 = entity2._pos_x / 8;
        int n9 = entity2._pos_y / 8;
        boolean bl2 = bl = Math.abs(n7 - n9) > Math.abs(n6 - n8);
        if (bl) {
            n5 = n6;
            n6 = n7;
            n7 = n5;
            n4 = n8;
            n8 = n9;
            n9 = n4;
        }
        if (n6 > n8) {
            n5 = n6;
            n6 = n8;
            n8 = n5;
            n4 = n7;
            n7 = n9;
            n9 = n4;
        }
        int n10 = n8 - n6;
        int n11 = Math.abs(n9 - n7);
        int n12 = n10 / 2;
        int n13 = n7 < n9 ? 1 : -1;
        n4 = n7;
        n5 = n6;
        if (bl) {
            n3 = n5 * _coll_map_tw + n4;
            n2 = n13;
        } else {
            n3 = n4 * _coll_map_tw + n5;
            n2 = n13 * _coll_map_tw;
        }
        for (n5 = n6; n5 < n8; ++n5) {
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            Entity entity3;
            boolean bl3 = false;
            if (entity._type == 6) {
                entity3 = (Building)entity;
                n18 = ((Building)entity3)._subtype * 4;
                n17 = (entity._pos_x + Level._cmaps_header[n18 + 0]) / 8;
                n16 = (entity._pos_y + Level._cmaps_header[n18 + 1]) / 8;
                n15 = n17 + Level._cmaps_header[n18 + 2];
                n14 = n16 + Level._cmaps_header[n18 + 3];
                if (bl) {
                    if (n4 >= n17 && n4 <= n15 && n5 >= n16 && n5 <= n14) {
                        bl3 = true;
                    }
                } else if (n5 >= n17 && n5 <= n15 && n4 >= n16 && n4 <= n14) {
                    bl3 = true;
                }
            } else if (entity._type == 11 || entity._type == 13 || entity._type == 5 && ((Unit)entity)._garrisonBuilding != -1) {
                entity3 = entity;
                if (entity._type == 5) {
                    entity3 = Level.GetEntitySafe(((Unit)entity)._garrisonBuilding);
                }
                int[] nArray = entity3.ComputeBoundingBox();
                if (bl) {
                    if (n4 >= nArray[0] / 8 && n4 <= nArray[2] / 8 && n5 >= nArray[1] / 8 && n5 <= nArray[3] / 8) {
                        bl3 = true;
                    }
                } else if (n5 >= nArray[0] / 8 && n5 <= nArray[2] / 8 && n4 >= nArray[1] / 8 && n4 <= nArray[3] / 8) {
                    bl3 = true;
                }
            }
            if (entity2._type == 6) {
                entity3 = (Building)entity2;
                n18 = ((Building)entity3)._subtype * 4;
                n17 = (entity2._pos_x + Level._cmaps_header[n18 + 0]) / 8;
                n16 = (entity2._pos_y + Level._cmaps_header[n18 + 1]) / 8;
                n15 = n17 + Level._cmaps_header[n18 + 2];
                n14 = n16 + Level._cmaps_header[n18 + 3];
                if (bl) {
                    if (n4 >= n17 && n4 <= n15 && n5 >= n16 && n5 <= n14) {
                        bl3 = true;
                    }
                } else if (n5 >= n17 && n5 <= n15 && n4 >= n16 && n4 <= n14) {
                    bl3 = true;
                }
            } else if (entity2._type == 11 || entity2._type == 13 || entity2._type == 5 && ((Unit)entity2)._garrisonBuilding != -1) {
                entity3 = entity2;
                if (entity2._type == 5) {
                    entity3 = Level.GetEntitySafe(((Unit)entity2)._garrisonBuilding);
                }
                int[] nArray = entity3.ComputeBoundingBox();
                if (bl) {
                    if (n4 >= nArray[0] / 8 && n4 <= nArray[2] / 8 && n5 >= nArray[1] / 8 && n5 <= nArray[3] / 8) {
                        bl3 = true;
                    }
                } else if (n5 >= nArray[0] / 8 && n5 <= nArray[2] / 8 && n4 >= nArray[1] / 8 && n4 <= nArray[3] / 8) {
                    bl3 = true;
                }
            }
            if (!bl3 && _coll_map[n3] > n) {
                return false;
            }
            if ((n12 -= n11) < 0) {
                n4 += n13;
                n12 += n10;
                n3 += n2;
            }
            if (bl) {
                n3 += _coll_map_tw;
                continue;
            }
            ++n3;
        }
        return true;
    }

    static boolean ValidateCollisionTile(int n, int n2, int n3) {
        if (n < 0 || n >= _coll_map_tw || n2 < 0 || n2 >= _coll_map_th) {
            return false;
        }
        _validTileX = n;
        _validTileY = n2;
        int n4 = n2 * _coll_map_tw + n;
        if (_coll_map[n4] > 4) {
            int n5;
            int n6 = Utils.randomInt() & 7;
            for (n5 = 0; n5 < 8; ++n5) {
                if (Map.GetCollisionAtTile(n + _xx[n6], n2 + _yy[n6]) <= 4) {
                    _validTileX = n + _xx[n6];
                    _validTileY = n2 + _yy[n6];
                    return true;
                }
                n6 = n6 + 1 & 7;
            }
            for (n5 = 2; n5 < n3; ++n5) {
                for (int i = -n5; i <= n5; ++i) {
                    if (n + i < 1 || n + i > _coll_map_tw - 1) continue;
                    for (int j = -n5; j <= n5; ++j) {
                        if (n2 + j < 1 || n2 + j > _coll_map_th - 1 || Math.abs(i) + Math.abs(j) != n5 || Map.GetCollisionAtTile(n + i, n2 + j) > 4) continue;
                        _validTileX = n + i;
                        _validTileY = n2 + j;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    static void __COLLISION_MAP() {
    }

    static void CDB_INVALIDATOR__() {
    }

    static void CDB_Invalidator_Init() {
        Utils.ResetRect(_invalidator_rect);
    }

    static void CDB_AddInvalidateRegion(int[] nArray) {
        _bInvalidatorCDB = true;
        Utils.RectUnion(_invalidator_rect, _invalidator_rect, nArray);
    }

    static void CDB_AddInvalidateRegion(int n, int n2, int n3, int n4) {
        _bInvalidatorCDB = true;
        Map._invalidator_rect[0] = Math.min(_invalidator_rect[0], n);
        Map._invalidator_rect[1] = Math.min(_invalidator_rect[1], n2);
        Map._invalidator_rect[2] = Math.max(_invalidator_rect[2], n + n3);
        Map._invalidator_rect[3] = Math.max(_invalidator_rect[3], n2 + n4);
    }

    static void CDB_Invalidator_Update() {
        if (_bInvalidatorCDB) {
            _bInvalidatorCDB = false;
            Map.CDB_InvalidatePixels(_invalidator_rect[0], _invalidator_rect[1], _invalidator_rect[2] - _invalidator_rect[0], _invalidator_rect[3] - _invalidator_rect[1], false);
            Utils.ResetRect(_invalidator_rect);
        }
    }

    static void __CDB_INVALIDATOR() {
    }

    static void CDB_Update() {
        Map._CDB_update(Camera._nCamX, Camera._nCamY);
        for (int i = 0; i < _CDB_nrRegions; ++i) {
            Region region = _CDB_regions[i];
            Map.CDB_InvalidateArea(region.xo, region.yo, region.w, region.h, region.x, region.y, false);
        }
    }

    static void CDB_Invalidate(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n / 32;
        int n12 = n2 / 32;
        int n13 = (n + n3 - 1) / 32 + 1;
        int n14 = (n2 + n4 - 1) / 32 + 1;
        if (n11 < _CDB_view_tx) {
            n11 = _CDB_view_tx;
        }
        if (n13 > _CDB_view_tx + GameImpl.CDB_TW) {
            n13 = _CDB_view_tx + GameImpl.CDB_TW;
        }
        if (n13 - n11 <= 0) {
            return;
        }
        if (n12 < _CDB_view_ty) {
            n12 = _CDB_view_ty;
        }
        if (n14 > _CDB_view_ty + GameImpl.CDB_TH) {
            n14 = _CDB_view_ty + GameImpl.CDB_TH;
        }
        if (n14 - n12 <= 0) {
            return;
        }
        int n15 = n11 + _CDB_orig_tx - _CDB_view_tx;
        int n16 = n15 - GameImpl.CDB_TW;
        if (n16 < 0) {
            n16 = 0;
        }
        if ((n10 = GameImpl.CDB_TW - n15) > (n9 = n13 - n11)) {
            n10 = n9;
        }
        if ((n8 = n9 - n10) > n9) {
            n8 = n9;
        }
        n13 = n11 + n9 - n8;
        int n17 = n12 + _CDB_orig_ty - _CDB_view_ty;
        int n18 = n17 - GameImpl.CDB_TH;
        if (n18 < 0) {
            n18 = 0;
        }
        if ((n7 = GameImpl.CDB_TH - n17) > (n6 = n14 - n12)) {
            n7 = n6;
        }
        if ((n5 = n6 - n7) > n6) {
            n5 = n6;
        }
        n14 = n12 + n6 - n5;
        if (n10 > 0) {
            if (n7 > 0) {
                Map.CDB_InvalidateTiles(n15, n17, n10, n7, n11, n12);
            }
            if (n5 > 0) {
                Map.CDB_InvalidateTiles(n15, n18, n10, n5, n11, n14);
            }
        }
        if (n8 > 0) {
            if (n7 > 0) {
                Map.CDB_InvalidateTiles(n16, n17, n8, n7, n13, n12);
            }
            if (n5 > 0) {
                Map.CDB_InvalidateTiles(n16, n18, n8, n5, n13, n14);
            }
        }
    }

    static void CDB_InvalidatePixels(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (bl) {
            if (n5 < Camera._nCamX) {
                n5 = Camera._nCamX;
            }
            if (n7 > Camera._nCamX + GameImpl.SV_W) {
                n7 = Camera._nCamX + GameImpl.SV_W;
            }
            if (n7 - n5 <= 0) {
                return;
            }
            if (n6 < Camera._nCamY) {
                n6 = Camera._nCamY;
            }
            if (n8 > Camera._nCamY + GameImpl.SV_H) {
                n8 = Camera._nCamY + GameImpl.SV_H;
            }
            if (n8 - n6 <= 0) {
                return;
            }
            n3 = n7 - n5;
            n4 = n8 - n6;
            Map.CDB_InvalidateArea(n5 - Camera._nCamX, n6 - Camera._nCamY, n3, n4, n5, n6, bl);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = _CDB_x;
            int n14 = _CDB_y;
            int n15 = _CDB_xo;
            int n16 = _CDB_yo;
            int n17 = GameImpl.CDB_SCROLLER_W;
            int n18 = GameImpl.CDB_SCROLLER_H;
            if (n5 < n13) {
                n5 = n13;
            }
            if (n7 > n13 + n17) {
                n7 = n13 + n17;
            }
            if (n7 - n5 <= 0) {
                return;
            }
            if (n6 < n14) {
                n6 = n14;
            }
            if (n8 > n14 + n18) {
                n8 = n14 + n18;
            }
            if (n8 - n6 <= 0) {
                return;
            }
            int n19 = n5 + n15 - n13;
            int n20 = n19 - n17;
            if (n20 < 0) {
                n20 = 0;
            }
            if ((n12 = n17 - n19) > (n3 = n7 - n5)) {
                n12 = n3;
            }
            if ((n11 = n3 - n12) > n3) {
                n11 = n3;
            }
            n7 = n5 + n3 - n11;
            int n21 = n6 + n16 - n14;
            int n22 = n21 - n18;
            if (n22 < 0) {
                n22 = 0;
            }
            if ((n10 = n18 - n21) > (n4 = n8 - n6)) {
                n10 = n4;
            }
            if ((n9 = n4 - n10) > n4) {
                n9 = n4;
            }
            n8 = n6 + n4 - n9;
            if (n12 > 0) {
                if (n10 > 0) {
                    Map.CDB_InvalidateArea(n19, n21, n12, n10, n5, n6, bl);
                }
                if (n9 > 0) {
                    Map.CDB_InvalidateArea(n19, n22, n12, n9, n5, n8, bl);
                }
            }
            if (n11 > 0) {
                if (n10 > 0) {
                    Map.CDB_InvalidateArea(n20, n21, n11, n10, n7, n6, bl);
                }
                if (n9 > 0) {
                    Map.CDB_InvalidateArea(n20, n22, n11, n9, n7, n8, bl);
                }
            }
        }
    }

    private static void CDB_InvalidateTilesV(int n, int n2, int n3) {
        if (_CDB_orig_ty > 0) {
            Map.CDB_InvalidateTiles(n, 0, n2, _CDB_orig_ty, n3, _CDB_view_ty + GameImpl.CDB_TH - _CDB_orig_ty);
            Map.CDB_InvalidateTiles(n, _CDB_orig_ty, n2, GameImpl.CDB_TH - _CDB_orig_ty, n3, _CDB_view_ty);
        } else {
            Map.CDB_InvalidateTiles(n, 0, n2, GameImpl.CDB_TH, n3, _CDB_view_ty);
        }
    }

    private static void CDB_InvalidateTilesH(int n, int n2, int n3) {
        if (_CDB_orig_tx > 0) {
            Map.CDB_InvalidateTiles(0, n, _CDB_orig_tx, n2, _CDB_view_tx + GameImpl.CDB_TW - _CDB_orig_tx, n3);
            Map.CDB_InvalidateTiles(_CDB_orig_tx, n, GameImpl.CDB_TW - _CDB_orig_tx, n2, _CDB_view_tx, n3);
        } else {
            Map.CDB_InvalidateTiles(0, n, GameImpl.CDB_TW, n2, _CDB_view_tx, n3);
        }
    }

    private static void CDB_InvalidateTiles(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * 32;
        int n8 = n2 * 32;
        int n9 = n3 * 32;
        int n10 = n4 * 32;
        int n11 = n5 * 32;
        int n12 = n6 * 32;
        _gBB.setClip(n7, n8, n9, n10);
        XSprite.SetGraphics(_gBB);
        if (n3 == 1) {
            int n13 = n8 + n10;
            int n14 = n5 + n6 * _map_tw;
            int n15 = n8;
            while (n15 < n13) {
                Map.CDB_DrawTile(n14, n7, n15);
                n15 += 32;
                n14 += _map_tw;
            }
        } else if (n4 == 1) {
            int n16 = n7 + n9;
            int n17 = n5 + n6 * _map_tw;
            int n18 = n7;
            while (n18 < n16) {
                Map.CDB_DrawTile(n17, n18, n8);
                n18 += 32;
                ++n17;
            }
        } else {
            int n19 = n7 + n9;
            int n20 = n8 + n10;
            int n21 = n5 + n6 * _map_tw;
            int n22 = n8;
            while (n22 < n20) {
                int n23 = n21;
                int n24 = n7;
                while (n24 < n19) {
                    Map.CDB_DrawTile(n23, n24, n22);
                    n24 += 32;
                    ++n23;
                }
                n22 += 32;
                n21 += _map_tw;
            }
        }
        Map.CDB_DrawBackgroundEntities(n7, n8, n9, n10, n11, n12);
    }

    private static void CDB_InvalidateTiles2(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10 = n3 * 32;
        int n11 = n4 * 32;
        if (n10 * n11 > 12288) {
            if (n3 > n4) {
                Map.CDB_InvalidateTiles2(n, n2, n3 >> 1, n4, n5, n6);
                Map.CDB_InvalidateTiles2(n + (n3 >> 1), n2, n3 - (n3 >> 1), n4, n5 + (n3 >> 1), n6);
            } else {
                Map.CDB_InvalidateTiles2(n, n2, n3, n4 >> 1, n5, n6);
                Map.CDB_InvalidateTiles2(n, n2 + (n4 >> 1), n3, n4 - (n4 >> 1), n5, n6 + (n4 >> 1));
            }
            return;
        }
        Utils.MemSet(Lights._rgbBuffer, 0);
        XSprite._op = 3;
        XSprite.SetBuffer(Lights._rgbBuffer, n10);
        XSprite.DecoderClip(0, 0, n10, n11);
        int n12 = n5 + n6 * _map_tw;
        if (n3 == 1) {
            n9 = 0;
            while (n9 < n11) {
                Map.CDB_DrawTile(n12, 0, n9);
                n9 += 32;
                n12 += _map_tw;
            }
        } else if (n4 == 1) {
            n9 = 0;
            while (n9 < n10) {
                Map.CDB_DrawTile(n12, n9, 0);
                n9 += 32;
                ++n12;
            }
        } else {
            n9 = 0;
            while (n9 < n11) {
                n8 = n12;
                n7 = 0;
                while (n7 < n10) {
                    Map.CDB_DrawTile(n8, n7, n9);
                    n7 += 32;
                    ++n8;
                }
                n9 += 32;
                n12 += _map_tw;
            }
        }
        n9 = n * 32;
        n8 = n2 * 32;
        n7 = n5 * 32;
        int n13 = n6 * 32;
        int n14 = Camera._nCamX;
        int n15 = Camera._nCamY;
        Camera._nCamX = n7;
        Camera._nCamY = n13;
        Level.SetEntityClipWithBorder(n7, n13, n10, n11);
        Level.DrawCDBEntities(null);
        Camera._nCamX = n14;
        Camera._nCamY = n15;
        _gBB.setClip(n9, n8, n10, n11);
        _gBB.drawRGB(Lights._rgbBuffer, 0, n10, n9, n8, n10, n11, false);
        XSprite._op = 0;
    }

    private static void CDB_InvalidateArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8 = n3;
        int n9 = n4;
        if (n8 * n9 > 12288) {
            if (n3 > n4) {
                Map.CDB_InvalidateArea(n, n2, n3 >> 1, n4, n5, n6, bl);
                Map.CDB_InvalidateArea(n + (n3 >> 1), n2, n3 - (n3 >> 1), n4, n5 + (n3 >> 1), n6, bl);
            } else {
                Map.CDB_InvalidateArea(n, n2, n3, n4 >> 1, n5, n6, bl);
                Map.CDB_InvalidateArea(n, n2 + (n4 >> 1), n3, n4 - (n4 >> 1), n5, n6 + (n4 >> 1), bl);
            }
            return;
        }
        int n10 = n;
        int n11 = n2;
        _gBB.setClip(n, n2, n3, n4);
        XSprite.SetGraphics(_gBB);
        int n12 = n5 / 32;
        int n13 = n6 / 32;
        int n14 = (n + n3 - 1) / 32 + 1 - n / 32;
        int n15 = (n2 + n4 - 1) / 32 + 1 - n2 / 32;
        int n16 = n12 + n13 * _map_tw;
        int n17 = n12 * 32 - n5 + n10;
        int n18 = n7 = n13 * 32 - n6 + n11;
        while (n18 < n9 + n11) {
            int n19 = n16;
            int n20 = n17;
            while (n20 < n8 + n10) {
                Map.CDB_DrawTile(n19, n20, n18);
                n20 += 32;
                ++n19;
            }
            n18 += 32;
            n16 += _map_tw;
        }
        Map.CDB_DrawBackgroundEntities(n10, n11, n8, n9, n5, n6);
        XSprite._op = 0;
    }

    private static void CDB_DrawBackgroundEntities(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Camera._nCamX;
        int n8 = Camera._nCamY;
        Camera._nCamX = n5 - n;
        Camera._nCamY = n6 - n2;
        Level.SetEntityClipWithBorder(n5, n6, n3, n4);
        Level.DrawCDBEntities(null);
        Camera._nCamX = n7;
        Camera._nCamY = n8;
    }

    static void CDB_Draw(SDKGraphics sDKGraphics) {
        Map._CDB_blitToScreen(sDKGraphics);
    }

    private static void CDB_DrawTile(int n, int n2, int n3) {
        _gBB.setColor(0);
        _gBB.fillRect(n2, n3, 32, 32);
        if ((n <<= 1) < 0 || n >= _map.length) {
            return;
        }
        int n4 = _map[n] & 0xFF;
        if (n4 != 255 && (n4 = _tilePalette[n4]) >= 0) {
            int n5 = _map[n + 1] & 0xFF;
            int n6 = n2;
            int n7 = n3;
            if ((n5 & 4) != 0) {
                if ((n5 & 1) != 0) {
                    n7 += 32;
                }
                if ((n5 & 1) == 0) {
                    n6 += 32;
                }
            } else {
                if ((n5 & 1) != 0) {
                    n6 += 32;
                }
                if ((n5 & 2) != 0) {
                    n7 += 32;
                }
            }
            Sprites._sprites[_currentTileSet].DrawFrame(n4, n6, n7, n5);
        }
    }

    private static void CDB_DrawCollisionMask(int n, int n2, int n3) {
        int n4 = n / _map_tw * 32;
        int n5 = n % _map_tw * 32;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n6 = Map.GetCollisionAt(n5 + j * 8, n4 + i * 8);
                SDKGraphics sDKGraphics = _gBB;
                if (n6 == 0) {
                    sDKGraphics.setColor(0x3300FF00);
                } else if (n6 == 1) {
                    sDKGraphics.setColor(0x33FF0000);
                } else if (n6 == 2) {
                    sDKGraphics.setColor(0x330000FF);
                } else if (n6 == 3) {
                    sDKGraphics.setColor(0x33FF00FF);
                }
                sDKGraphics.fillRect(n2 + j * 8, n3 + i * 8, 8, 8);
            }
        }
    }

    public static void _CDB_init(int n, int n2) {
        _CDB_separator = -1;
        _CDB_x = n;
        _CDB_y = n2;
        _CDB_xo = 0;
        _CDB_yo = 0;
        _CDB_oldX = n;
        _CDB_oldY = n2;
        _CDB_nrRegions = 0;
        Map._CDB_addRegion(n, n2, _CDB_xo, _CDB_yo, _CDB_w, _CDB_h);
    }

    public static void _CDB_moveX(int n) {
        int n2 = _CDB_xo;
        if ((_CDB_xo += n) >= _CDB_w) {
            Map._CDB_findXRegion(_CDB_x + _CDB_w, n2, _CDB_w - n2);
            Map._CDB_findXRegion(_CDB_x + _CDB_w + (_CDB_w - n2), 0, _CDB_xo -= _CDB_w);
            return;
        }
        if (_CDB_xo < 0) {
            Map._CDB_findXRegion(_CDB_x + n, _CDB_xo += _CDB_w, _CDB_w - _CDB_xo);
            Map._CDB_findXRegion(_CDB_x + n + _CDB_w - _CDB_xo, 0, n2);
            return;
        }
        if (n > 0) {
            Map._CDB_findXRegion(_CDB_x + _CDB_w, n2, n);
        } else {
            Map._CDB_findXRegion(_CDB_x + n, n2 + n, -n);
        }
    }

    public static void _CDB_findXRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Map._CDB_addRegion(n, _CDB_y, n2, _CDB_yo, n3, _CDB_h - _CDB_yo);
        if (_CDB_yo != 0) {
            Map._CDB_addRegion(n, _CDB_y + (_CDB_h - _CDB_yo), n2, 0, n3, _CDB_yo);
        }
    }

    public static void _CDB_moveY(int n) {
        int n2 = _CDB_yo;
        if ((_CDB_yo += n) >= _CDB_h) {
            Map._CDB_findYRegion(_CDB_y + _CDB_h, n2, _CDB_h - n2);
            Map._CDB_findYRegion(_CDB_y + _CDB_h + (_CDB_h - n2), 0, _CDB_yo -= _CDB_h);
            return;
        }
        if (_CDB_yo < 0) {
            Map._CDB_findYRegion(_CDB_y + n, _CDB_yo += _CDB_h, _CDB_h - _CDB_yo);
            Map._CDB_findYRegion(_CDB_y + n + _CDB_h - _CDB_yo, 0, n2);
            return;
        }
        if (n > 0) {
            Map._CDB_findYRegion(_CDB_y + _CDB_h, n2, n);
        } else {
            Map._CDB_findYRegion(_CDB_y + n, n2 + n, -n);
        }
    }

    public static void _CDB_findYRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Map._CDB_addRegion(_CDB_x, n, _CDB_xo, n2, _CDB_w - _CDB_xo, n3);
        if (_CDB_xo != 0) {
            Map._CDB_addRegion(_CDB_x + (_CDB_w - _CDB_xo), n, 0, n2, _CDB_xo, n3);
        }
    }

    public static void _CDB_addRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        Region region = new Region();
        region.x = (short)n;
        region.y = (short)n2;
        region.xo = (short)n3;
        region.yo = (short)n4;
        region.w = (short)n5;
        region.h = (short)n6;
        Map._CDB_regions[Map._CDB_nrRegions++] = region;
    }

    public static void _CDB_update(int n, int n2) {
        int n3;
        _CDB_separator = 0;
        if (_bResetCDB) {
            Map._CDB_init(n, n2);
            _bResetCDB = false;
            return;
        }
        _CDB_nrRegions = 0;
        int n4 = n - _CDB_oldX;
        if (n4 <= -_CDB_w || n4 >= _CDB_w) {
            Map._CDB_init(n, n2);
            return;
        }
        if (n4 != 0) {
            Map._CDB_moveX(n4);
        }
        _CDB_x = n;
        _CDB_oldX = n;
        if (_CDB_separator != -1) {
            _CDB_separator = _CDB_nrRegions;
        }
        if ((n3 = n2 - _CDB_oldY) <= -_CDB_h || n3 >= _CDB_h) {
            Map._CDB_init(n, n2);
            return;
        }
        if (n3 != 0) {
            Map._CDB_moveY(n3);
        }
        _CDB_y = n2;
        _CDB_oldY = n2;
    }

    public static void _CDB_blitToScreen(SDKGraphics sDKGraphics) {
        if (_CDB_w - _CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, _CDB_xo, _CDB_yo, _CDB_w - _CDB_xo, _CDB_h - _CDB_yo, 0, GameImpl.SV_X, GameImpl.SV_Y, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, _CDB_xo, 0, _CDB_w - _CDB_xo, _CDB_yo, 0, GameImpl.SV_X, _CDB_h - _CDB_yo + GameImpl.SV_Y, 20);
            }
        }
        if (_CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, 0, _CDB_yo, _CDB_xo, _CDB_h - _CDB_yo, 0, _CDB_w - _CDB_xo + GameImpl.SV_X, GameImpl.SV_Y, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(_imgBB, 0, 0, _CDB_xo, _CDB_yo, 0, _CDB_w - _CDB_xo + GameImpl.SV_X, _CDB_h - _CDB_yo + GameImpl.SV_Y, 20);
            }
        }
    }

    static {
        _currentTileSet = -1;
        _xx = new int[]{0, -1, 0, 1, -1, -1, 1, 1};
        _yy = new int[]{-1, 0, 1, 0, -1, 1, 1, -1};
        _invalidator_rect = new int[5];
        _bInvalidatorCDB = false;
        _CDB_regions = new Region[24];
    }
}

