/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.MasterAI;
import com.ea.game.MsgBox;
import com.ea.game.Pathfinder;
import com.ea.game.Script;
import com.ea.game.ScriptConstants;
import com.ea.game.SpriteConstants;
import com.ea.game.Tutorial;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.UtilEntity;
import com.ea.game.Utils;

public class ScriptInstructions
implements Constants,
ScriptConstants,
UnitsConstants,
SpriteConstants,
GraphicsConstants,
BuildingConstants {
    static int ExecBlock(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = n3 + 1;
        short s = sArray[n4++];
        int n5 = sArray[n4++];
        for (int i = 0; i < n5 && (n4 = Script.ExecuteInstruction(n, n2, n4)) >= 0; ++i) {
        }
        return n3 + s;
    }

    static int ExecIf(int n, int n2, int n3) {
        int n4;
        short[] sArray = Script._scripts[n2];
        int n5 = n3 + 1;
        short s = sArray[n5++];
        int n6 = sArray[n5++];
        short s2 = sArray[n5++];
        boolean bl = true;
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = Script.ExecuteInstruction(n, n2, n5);
            if (Script._scriptInstances[n][4] <= 0) {
                bl = false;
                break;
            }
            n5 = n7;
        }
        if (bl) {
            for (n4 = 0; n4 < s2; ++n4) {
                if ((n5 = Script.ExecuteInstruction(n, n2, n5)) >= 0) continue;
                return -1;
            }
        }
        return n3 + s;
    }

    static int ExecWhile(int n, int n2, int n3) {
        int n4;
        short[] sArray = Script._scripts[n2];
        int n5 = n3 + 1;
        short s = sArray[n5++];
        int n6 = sArray[n5++];
        short s2 = sArray[n5++];
        boolean bl = false;
        for (n4 = 0; n4 < n6; ++n4) {
            int n7 = Script.ExecuteInstruction(n, n2, n5);
            if (Script._scriptInstances[n][4] <= 0) {
                bl = true;
                break;
            }
            n5 = n7;
        }
        if (bl) {
            return n3 + s;
        }
        for (n4 = 0; n4 < s2; ++n4) {
            if ((n5 = Script.ExecuteInstruction(n, n2, n5)) >= 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            return n3 + s;
        }
        return n3;
    }

    static int ExecSetAnim(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        Entity entity = Level.GetEntityById(-1, s);
        entity.SetCrtAnim(n6);
        return ++n3;
    }

    static int ExecSetAnimFrame(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        Entity entity = Level.GetEntityById(-1, s);
        entity._crt_aframe = n6;
        entity._crt_aframe_time = 0;
        return n3;
    }

    static int ExecSetPosition(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        Entity entity = Level.GetEntityById(-1, n5);
        entity.SetPosition(n7, n9);
        return ++n3;
    }

    static int ExecSpawnEntity(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        int n8 = -1;
        if (n7 < 0) {
            n8 = sArray[n3++];
        }
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n8 = Script.GetRegistryValue(n, n8);
        Script.SpawnEntity(n5, n7, n8);
        return n3;
    }

    static int ExecKillEntity(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        ++n3;
        int n5 = sArray[n4];
        Entity entity = Level.GetEntityById(-1, n5 = Script.GetRegistryValue(n, n5));
        if (entity != null) {
            switch (entity._type) {
                case 5: {
                    Unit unit = (Unit)entity;
                    if (unit._state != 4) {
                        Level.DecEntityNo(5, unit._subtype, unit._allegiance);
                    }
                    if (unit._state != 4 && unit._state != 3) {
                        if (unit._allegiance == 0) {
                            --Level._player_command_points;
                        }
                        if (unit._allegiance == 1) {
                            --Level._ai_command_points;
                        }
                    }
                    unit._life = 0;
                    UtilEntity.CheckTriggers(unit, unit._pos_x, unit._pos_y);
                    break;
                }
                case 6: {
                    Building building = (Building)entity;
                    Level.DecEntityNo(6, building._subtype, building._allegiance);
                    if (building._allegiance == 0) {
                        --Level._player_build_points;
                    }
                    if (building._allegiance == 1) {
                        --Level._ai_build_points;
                    }
                    building._life = 0;
                }
            }
            Level.DeleteEntity(entity);
        }
        return n3;
    }

    static int ExecFollowEntity(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n11 = Script.GetRegistryValue(n, n11);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null) {
            Camera.DoFollowEntity(entity.GetPointer());
        }
        return n3;
    }

    static int ExecCenterTo(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        n7 -= GameImpl.SV_H >> 1;
        if ((n5 -= GameImpl.SV_W >> 1) < 0) {
            n5 = 0;
        }
        if (n5 > Map._map_w - GameImpl.SV_W) {
            n5 = Map._map_w - GameImpl.SV_W;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n7 > Map._map_h - GameImpl.SV_H) {
            n7 = Map._map_h - GameImpl.SV_H;
        }
        if (n9 == 0) {
            Camera.DoScroll(n5, n7);
        } else {
            Camera._nCamX = n5;
            Camera._nCamY = n7;
        }
        return n3;
    }

    static int ExecIsAnimEnded(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        Entity entity = Level.GetEntityById(-1, s);
        Script._scriptInstances[n][4] = entity.IsCrtAnimEnded() ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetFlags(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null) {
            entity._flags |= n7;
            if (entity._type == 5) {
                Unit unit = (Unit)entity;
                if ((n7 & 0x400) != 0) {
                    unit._bSelected = false;
                }
                if ((n7 & 0x4000) != 0) {
                    unit._targetPointer = -1;
                }
            }
        }
        return n3;
    }

    static int ExecResetFlags(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null) {
            entity._flags &= ~n7;
        }
        return n3;
    }

    static int ExecCameraLinearTo(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        return ++n3;
    }

    static int ExecBreak(int n, int n2, int n3) {
        return -1;
    }

    static int ExecTestVariable(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        short s2 = sArray[n5];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        short s3 = sArray[n8];
        n7 = Script.GetRegistryValue(n, n7);
        int n9 = Script.GetVariabile(n, s, s2);
        Script._scriptInstances[n][4] = s3 == 0 && n9 == n7 || s3 == 1 && n9 != n7 || s3 == 2 && n9 < n7 || s3 == 3 && n9 > n7 || s3 == 4 && n9 <= n7 || s3 == 5 && n9 >= n7 ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetVariable(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Script.SetVariabile(n, n5, n7, n9);
        return n3;
    }

    static int ExecTestRegister(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        int n7 = Script.GetRegistryValue(n, s);
        Script._scriptInstances[n][4] = n7 == n6 ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetRegister(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        Script._scriptInstances[n][s - 14995] = (short)n6;
        return ++n3;
    }

    static int ExecTestState(int n, int n2, int n3) {
        int n4;
        short[] sArray = Script._scripts[n2];
        int n5 = ++n3;
        short s = sArray[n5];
        int n6 = ++n3;
        int n7 = sArray[n6];
        Script._scriptInstances[n][4] = (n7 = Script.GetRegistryValue(n, n7)) == (n4 = Script.GetVariabile(n, s, 1)) ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetState(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        short s2 = sArray[n5];
        Script.SetVariabile(n, s, 1, s2);
        return ++n3;
    }

    static int ExecAddRegister(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        ++n3;
        int n6 = sArray[n5];
        n6 = Script.GetRegistryValue(n, n6);
        short[] sArray2 = Script._scriptInstances[n];
        int n7 = s - 14995;
        sArray2[n7] = (short)(sArray2[n7] + n6);
        return n3;
    }

    static int ExecSaveVariable(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        short s = sArray[n6];
        int n7 = ++n3;
        short s2 = sArray[n7];
        int n8 = Script.GetVariabile(n, n5, s);
        Script._scriptInstances[n][s2 - 14995] = (short)n8;
        return ++n3;
    }

    static int ExecSaveState(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        short s2 = sArray[n5];
        int n6 = Script.GetVariabile(n, s, 1);
        Script._scriptInstances[n][s2 - 14995] = (short)n6;
        return ++n3;
    }

    static int ExecWait(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = n3 + 1;
        int n5 = sArray[n4++];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = Script._scriptInstances[n][4];
        if (n6 >= 0) {
            n6 = -n5;
        }
        if (++n6 >= 0) {
            Script._scriptInstances[n][4] = (short)n6;
            return n4;
        }
        Script._scriptInstances[n][4] = (short)n6;
        return n3;
    }

    static int ExecStartScript(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        short s = sArray[n4];
        int n5 = ++n3;
        int n6 = sArray[n5];
        int n7 = ++n3;
        int n8 = sArray[n7];
        int n9 = ++n3;
        int n10 = sArray[n9];
        int n11 = ++n3;
        ++n3;
        int n12 = sArray[n11];
        n6 = Script.GetRegistryValue(n, n6);
        n8 = Script.GetRegistryValue(n, n8);
        n10 = Script.GetRegistryValue(n, n10);
        n12 = Script.GetRegistryValue(n, n12);
        Script.StartScript(s, n6, n8, n10, n12);
        return n3;
    }

    static int ExecPlaySound(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        short s = sArray[n6];
        return ++n3;
    }

    static int ExecMovieBars(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        ++n3;
        short s = sArray[n4];
        if (s > 0) {
            Hud.RiseMovieBars();
        } else {
            Hud.SinkMovieBars();
        }
        return n3;
    }

    static int ExecTestMemory(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        Script._scriptInstances[n][4] = (n7 = Script.GetRegistryValue(n, n7)) == Script._memory[n5] ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSetMemory(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Script._memory[n5] = (short)n7;
        return ++n3;
    }

    static int ExecSaveMemory(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        short s = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        Script._scriptInstances[n][s - 14995] = Script._memory[n5];
        return ++n3;
    }

    static int ExecKillScripts(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Script.KillScripts(n5);
        return ++n3;
    }

    static int ExecStopSound(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        return ++n3;
    }

    static int ExecSpawnUnit(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        ++n3;
        int n17 = sArray[n16];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Unit unit = Level.SpawnUnit(n7, n9, n11, n15 = Script.GetRegistryValue(n, n15), n13, (byte)(n17 = Script.GetRegistryValue(n, n17)));
        if (unit != null && n5 > 0) {
            unit._id = n5;
        }
        if (unit._allegiance == 1 && unit._group > 0) {
            int[] nArray = MasterAI._AI_groups[n17];
            nArray[0] = nArray[0] + 1;
        }
        return n3;
    }

    static int ExecSelectUnits(int n, int n2, int n3) {
        int n4;
        short[] sArray = Script._scripts[n2];
        int n5 = ++n3;
        int n6 = sArray[n5];
        int n7 = ++n3;
        int n8 = sArray[n7];
        int n9 = ++n3;
        ++n3;
        int n10 = sArray[n9];
        n6 = Script.GetRegistryValue(n, n6);
        n8 = Script.GetRegistryValue(n, n8);
        n10 = Script.GetRegistryValue(n, n10);
        for (n4 = 0; n4 < 64; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            Unit unit = (Unit)Level._entities[n4];
            if ((n8 >= 0 && n8 != unit._allegiance || n6 >= 0) && n6 != unit._subtype) continue;
            if (n10 > 0) {
                unit._bSelected = true;
                Cursor._bUnitsSelected = true;
            } else {
                unit._bSelected = false;
            }
            Level._currentGroup = 0;
        }
        if (n10 <= 0) {
            n4 = 0;
            for (int i = 0; i < 64; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit._allegiance != 0 || !unit._bSelected) continue;
                ++n4;
            }
            Cursor._bUnitsSelected = n4 > 0;
        }
        return n3;
    }

    static int ExecGroupUnits(int n, int n2, int n3) {
        Unit unit;
        int n4;
        short[] sArray = Script._scripts[n2];
        int n5 = ++n3;
        int n6 = sArray[n5];
        int n7 = ++n3;
        int n8 = sArray[n7];
        int n9 = ++n3;
        int n10 = sArray[n9];
        int n11 = ++n3;
        int n12 = sArray[n11];
        int n13 = ++n3;
        int n14 = sArray[n13];
        int n15 = ++n3;
        int n16 = sArray[n15];
        int n17 = ++n3;
        int n18 = sArray[n17];
        int n19 = ++n3;
        ++n3;
        int n20 = sArray[n19];
        n6 = Script.GetRegistryValue(n, n6);
        n8 = Script.GetRegistryValue(n, n8);
        n10 = Script.GetRegistryValue(n, n10);
        n12 = Script.GetRegistryValue(n, n12);
        n14 = Script.GetRegistryValue(n, n14);
        n16 = Script.GetRegistryValue(n, n16);
        n18 = Script.GetRegistryValue(n, n18);
        if ((n20 = Script.GetRegistryValue(n, n20)) < 0) {
            n20 = 64;
        }
        int n21 = 0;
        Utils._rect[0] = n8;
        Utils._rect[1] = n10;
        Utils._rect[2] = n12;
        Utils._rect[3] = n14;
        for (n4 = 0; n4 < 64; ++n4) {
            if (Level._entities_usage[n4] != 1) continue;
            unit = (Unit)Level._entities[n4];
            if (n6 >= 0) {
                if (unit._subtype != n6 || unit._allegiance != n16 || !Utils.PointInRect(Utils._rect, unit._pos_x, unit._pos_y) || (unit._flags & 0x400) != 0 || n21 >= n20) continue;
                if (unit._allegiance == 1 && unit._group <= 0) {
                    int[] nArray = MasterAI._AI_groups[n18];
                    nArray[0] = nArray[0] + 1;
                    unit._group = (byte)n18;
                    ++n21;
                    continue;
                }
                if (unit._allegiance != 0) continue;
                unit._group = (byte)n18;
                ++n21;
                continue;
            }
            if (unit._allegiance != n16 || !Utils.PointInRect(Utils._rect, unit._pos_x, unit._pos_y) || n21 >= n20) continue;
            if (unit._allegiance == 1 && unit._group <= 0) {
                int[] nArray = MasterAI._AI_groups[n18];
                nArray[0] = nArray[0] + 1;
                unit._group = (byte)n18;
                ++n21;
                continue;
            }
            if (unit._allegiance != 0) continue;
            unit._group = (byte)n18;
            ++n21;
        }
        if (n21 < n20) {
            for (n4 = 0; n4 < 64; ++n4) {
                if (Level._entities_usage[n4] != 1) continue;
                unit = (Unit)Level._entities[n4];
                if (n6 >= 0) {
                    if (unit._subtype != n6 || unit._allegiance != n16 || !Utils.PointInRect(Utils._rect, unit._pos_x, unit._pos_y) || (unit._flags & 0x400) != 0 || n21 >= n20 || unit._allegiance != 1 || unit._group == n18) continue;
                    if (unit._group >= 0 && MasterAI._AI_groups[unit._group][0] > 0) {
                        int[] nArray = MasterAI._AI_groups[unit._group];
                        nArray[0] = nArray[0] - 1;
                    }
                    int[] nArray = MasterAI._AI_groups[n18];
                    nArray[0] = nArray[0] + 1;
                    unit._group = (byte)n18;
                    ++n21;
                    continue;
                }
                if (unit._allegiance != n16 || !Utils.PointInRect(Utils._rect, unit._pos_x, unit._pos_y) || n21 >= n20 || unit._allegiance != 1 || unit._group == n18) continue;
                if (unit._group > 0 && MasterAI._AI_groups[unit._group][0] > 0) {
                    int[] nArray = MasterAI._AI_groups[unit._group];
                    nArray[0] = nArray[0] - 1;
                }
                int[] nArray = MasterAI._AI_groups[n18];
                nArray[0] = nArray[0] + 1;
                unit._group = (byte)n18;
                ++n21;
            }
        }
        return n3;
    }

    static int ExecTestNrUnits(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        short s = sArray[n10];
        n9 = Script.GetRegistryValue(n, n9);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        int n11 = 0;
        if (n5 >= 0) {
            n11 = Level.GetEntityNo(5, n5, n7);
        } else {
            for (int i = 0; i < 15; ++i) {
                n11 += Level.GetEntityNo(5, i, n7);
            }
        }
        Script._scriptInstances[n][4] = s == 0 && n11 == n9 || s == 1 && n11 != n9 || s == 2 && n11 < n9 || s == 3 && n11 > n9 || s == 4 && n11 <= n9 || s == 5 && n11 >= n9 ? (short)1 : 0;
        return n3;
    }

    static int ExecTestNrBuildings(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        short s = sArray[n10];
        n9 = Script.GetRegistryValue(n, n9);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        int n11 = 0;
        if (n5 >= 0) {
            n11 = Level.GetEntityNo(6, n5, n7);
        } else {
            for (int i = 0; i < 10; ++i) {
                n11 += Level.GetEntityNo(6, i, n7);
            }
        }
        Script._scriptInstances[n][4] = s == 0 && n11 == n9 || s == 1 && n11 != n9 || s == 2 && n11 < n9 || s == 3 && n11 > n9 || s == 4 && n11 <= n9 || s == 5 && n11 >= n9 ? (short)1 : 0;
        return n3;
    }

    static int ExecTrainUnit(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        MasterAI.TrainUnit(n5, n7);
        return ++n3;
    }

    static int ExecStartAttack(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        MasterAI.Attack(n5, n7, n9, n11, n13);
        return n3;
    }

    static int ExecEndLevel(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Level.EndLevel(n5);
        return ++n3;
    }

    static int ExecTestRandom(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        short s = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        int n11 = Utils.random(n5, n7);
        Script._scriptInstances[n][4] = s == 0 && n11 == n9 || s == 1 && n11 != n9 || s == 2 && n11 < n9 || s == 3 && n11 > n9 || s == 4 && n11 <= n9 || s == 5 && n11 >= n9 ? (short)1 : 0;
        return n3;
    }

    static int ExecSetCameraTo(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        int n6 = ++n3;
        int n7 = sArray[n6];
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n9 = Script.GetRegistryValue(n, n9);
        n7 -= GameImpl.SV_H >> 1;
        if ((n5 -= GameImpl.SV_W >> 1) < 0) {
            n5 = 0;
        }
        if (n5 > Map._map_w - GameImpl.SV_W) {
            n5 = Map._map_w - GameImpl.SV_W;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n7 > Map._map_h - GameImpl.SV_H) {
            n7 = Map._map_h - GameImpl.SV_H;
        }
        if (n9 == 0) {
            Camera.DoScroll(n5, n7);
        } else {
            int n10 = Cursor._nCursorPosX - Camera._nCamX;
            int n11 = Cursor._nCursorPosY - Camera._nCamY;
            Camera._nCamX = n5;
            Camera._nCamY = n7;
            Cursor._nCursorPosX = n5 + n10;
            Cursor._nCursorPosY = n7 + n11;
            Camera.DoScroll(n5, n7);
        }
        return n3;
    }

    static int ExecStartMove(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Unit unit = (Unit)Level.GetEntityById(5, n5);
        if (unit != null) {
            unit.DoAction(2, -1, n7, n9);
        }
        return n3;
    }

    static int ExecShowMessage(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        if (Level._skipMovieState == 0) {
            MsgBox.Add(n5, n7, 0, -1, -1, -1, 0, n13, n9, n11, 1, false);
        }
        return n3;
    }

    static int ExecStartCursorTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Tutorial.StartCursorMovementTutorial(n5, n7);
        return ++n3;
    }

    static int ExecStartMovementTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        Tutorial.StartUnitsMovementTutorial(n5, n7, n9, n11);
        return n3;
    }

    static int ExecStartAttackTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        Tutorial.StartAttackTutorial(n5, n7, n9, n11, -1);
        return n3;
    }

    static int ExecStartBuildTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        Tutorial.StartBuildTutorial(n5, n7, n9, n11);
        return n3;
    }

    static int ExecStartGroupTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Tutorial.StartGroupTutorial(n5, n7, n9);
        return n3;
    }

    static int ExecStartTrainTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Tutorial.StartTrainTutorial(n5, n7, n9, n11, n13);
        return n3;
    }

    static int ExecStartSelectTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Tutorial.StartSelectTutorial(n5, n7, n9);
        return n3;
    }

    static int ExecTestActiveTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            if (Tutorial._tutorials[i][0] != 1 || Tutorial._tutorials[i][2] != n5) continue;
            bl = true;
            break;
        }
        Script._scriptInstances[n][4] = bl ? (short)1 : 0;
        return n3;
    }

    static int ExecSetAssetAvailable(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        if ((n9 = Script.GetRegistryValue(n, n9)) > 0) {
            Hud.AddAvailableBuildItems(n5, 1 << n7);
        } else {
            Hud.RemoveAvailableBuildItems(n5, 1 << n7);
        }
        return n3;
    }

    static int ExecEndTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Tutorial.EndTutorial(n5);
        return ++n3;
    }

    static int ExecTestBuildingOffline(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        short s = Level._buildings_off_times[n7 = Script.GetRegistryValue(n, n7)][n5];
        Script._scriptInstances[n][4] = s > 0 ? (short)1 : 0;
        return ++n3;
    }

    static int ExecFowDiscoverTiles(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = Script.GetRegistryValue(n, sArray[n4]);
        int n6 = ++n3;
        int n7 = Script.GetRegistryValue(n, sArray[n6]);
        int n8 = ++n3;
        int n9 = Script.GetRegistryValue(n, sArray[n8]);
        int n10 = ++n3;
        int n11 = Script.GetRegistryValue(n, sArray[n10]);
        return ++n3;
    }

    static int ExecFowDiscoverPixels(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = Script.GetRegistryValue(n, sArray[n4]);
        int n6 = ++n3;
        int n7 = Script.GetRegistryValue(n, sArray[n6]);
        int n8 = ++n3;
        int n9 = Script.GetRegistryValue(n, sArray[n8]);
        int n10 = ++n3;
        int n11 = Script.GetRegistryValue(n, sArray[n10]);
        return ++n3;
    }

    static int ExecTestTriggerState(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = 0;
        Script._scriptInstances[n][4] = 0;
        for (int i = 0; i < UtilEntity.nrTriggers; ++i) {
            int n9 = UtilEntity._triggers[n8 + 4];
            if (n9 == n5) {
                int n10 = UtilEntity._triggers[n8 + 5];
                if (n7 != n10) break;
                Script._scriptInstances[n][4] = 1;
                break;
            }
            n8 += 18;
        }
        return n3;
    }

    static int ExecSetAIDefense(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = Script.GetRegistryValue(n, sArray[n4]);
        MasterAI._AI_defend = n5 > 0;
        return ++n3;
    }

    static int ExecSetAIScripting(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = Script.GetRegistryValue(n, sArray[n4]);
        MasterAI._AI_run_script = n5 > 0;
        return ++n3;
    }

    static int ExecFireSuperWeapon(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        switch (n5) {
            case 0: {
                Level.DropNuke(n11, n7, n9);
                break;
            }
            case 1: {
                Level.DropKirov(n11, n7, n9);
                break;
            }
            case 2: {
                Level.DropIronCurtain(n11, n7, n9);
                break;
            }
            case 3: {
                Level.DropHarrier(n11, n7, n9);
                break;
            }
            case 5: {
                Level.DropStorm(n11, n7, n9);
                break;
            }
            case 4: {
                Level.SWChrono_MarkUnits(n7, n9);
            }
        }
        return n3;
    }

    static int ExecTestFinishedTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            if (Tutorial._tutorials[i][0] != 1 || Tutorial._tutorials[i][2] != n5) continue;
            bl = true;
            break;
        }
        Script._scriptInstances[n][4] = !bl ? (short)1 : 0;
        return n3;
    }

    static int ExecSetUnitAction(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            if (n7 != 8) {
                Entity entity2 = Level.GetEntityById(-1, n9);
                if (entity2 != null) {
                    n9 = entity2.GetPointer();
                    if (n11 <= 0) {
                        n11 = entity2._pos_x;
                    }
                    if (n13 <= 0) {
                        n13 = entity2._pos_y;
                    }
                } else {
                    n9 = -1;
                }
            }
            unit.DoAction(n7, n9, n11, n13);
        }
        return n3;
    }

    static int ExecSetUnitAnim(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            unit.SetCrtAnim(n7 + unit._orientation);
            if (unit._bHasTurret) {
                int n8 = n7 + 48;
                unit.Turret_SetCrtAnim(n8 + unit._turretOrientation);
            }
        }
        return n3;
    }

    static int ExecSetHullAnim(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            unit.SetCrtAnim(n7 + unit._orientation);
        }
        return n3;
    }

    static int ExecSetTurretAnim(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            if (unit._bHasTurret) {
                unit.Turret_SetCrtAnim(n7 + unit._turretOrientation);
            }
        }
        return n3;
    }

    static int ExecUnitForceCrawl(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Entity entity = Level.GetEntityById(-1, n5);
        if (entity != null && entity._type == 5) {
            Unit unit = (Unit)entity;
            unit._force_crawl = (byte)n7;
            if (n7 == 1) {
                unit._crawling_timer = (short)64;
                unit.RefreshCrawlingAnim();
            }
            if (n7 == 2) {
                unit._crawling_timer = 0;
                unit.RefreshCrawlingAnim();
            }
        }
        return n3;
    }

    static int ExecAISuperWeapon(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        MasterAI.UseSW(n5, n7, n9);
        return n3;
    }

    static int ExecStartSwTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        Tutorial.StartSWTutorial(n5, n7, n9, n11, n13);
        return n3;
    }

    static int ExecStartGarrisonTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        ++n3;
        int n11 = sArray[n10];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        Tutorial.StartGarrisonTutorial(n5, n7, n9, n11);
        return n3;
    }

    static int ExecBuildStructure(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        MasterAI.BuildStructure(n5, n7, n9);
        return n3;
    }

    static int ExecDeployChronosphere(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        Level.SWChrono_TeleportUnits(n5, n7);
        return ++n3;
    }

    static int ExecSetCameraState(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Camera.SetState(n5);
        return ++n3;
    }

    static int ExecSetTriggerState(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        int n8 = 0;
        for (int i = 0; i < UtilEntity.nrTriggers; ++i) {
            int n9 = UtilEntity._triggers[n8 + 4];
            if (n9 == n5) {
                UtilEntity._triggers[n8 + 5] = n7;
                break;
            }
            n8 += 18;
        }
        return n3;
    }

    static int ExecSetGroupAction(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        ++n3;
        int n17 = sArray[n16];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        if (n11 != 8) {
            Entity entity = Level.GetEntityById(-1, n13);
            if (entity != null) {
                n13 = entity.GetPointer();
                if (n15 <= 0) {
                    n15 = entity._pos_x;
                }
                if (n17 <= 0) {
                    n17 = entity._pos_y;
                }
            } else {
                n13 = -1;
            }
        }
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (n5 > 0 && unit._group != n5 || n7 >= 0 && unit._allegiance != n7 || n9 >= 0 && unit._subtype != n9) continue;
            unit.DoAction(n11, n13, n15, n17);
        }
        return n3;
    }

    static int ExecTestAreaUnits(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        int n17 = sArray[n16];
        int n18 = ++n3;
        ++n3;
        short s = sArray[n18];
        n17 = Script.GetRegistryValue(n, n17);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        int n19 = 0;
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._subtype != n5 && n5 >= 0 || unit._allegiance != n7 && n7 >= 0 || unit._pos_x < n9 || unit._pos_x > n13 || unit._pos_y < n11 || unit._pos_y > n15) continue;
            ++n19;
        }
        Script._scriptInstances[n][4] = s == 0 && n19 == n17 || s == 1 && n19 != n17 || s == 2 && n19 < n17 || s == 3 && n19 > n17 || s == 4 && n19 <= n17 || s == 5 && n19 >= n17 ? (short)1 : 0;
        return n3;
    }

    static int ExecTestAreaBuildings(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        int n17 = sArray[n16];
        int n18 = ++n3;
        ++n3;
        short s = sArray[n18];
        n17 = Script.GetRegistryValue(n, n17);
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        int n19 = 0;
        for (int i = 64; i < 160; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Building building = (Building)Level._entities[i];
            if (building._subtype != n5 && n5 >= 0 || building._allegiance != n7 && n7 >= 0 || building._pos_x < n9 || building._pos_x > n13 || building._pos_y < n11 || building._pos_y > n15) continue;
            ++n19;
        }
        Script._scriptInstances[n][4] = s == 0 && n19 == n17 || s == 1 && n19 != n17 || s == 2 && n19 < n17 || s == 3 && n19 > n17 || s == 4 && n19 <= n17 || s == 5 && n19 >= n17 ? (short)1 : 0;
        return n3;
    }

    static int ExecAddBriefingMessage(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        short s = sArray[n8];
        int n9 = ++n3;
        int n10 = sArray[n9];
        int n11 = ++n3;
        int n12 = sArray[n11];
        int n13 = ++n3;
        int n14 = sArray[n13];
        int n15 = ++n3;
        int n16 = sArray[n15];
        int n17 = ++n3;
        ++n3;
        int n18 = sArray[n17];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n10 = Script.GetRegistryValue(n, n10);
        n12 = Script.GetRegistryValue(n, n12);
        n14 = Script.GetRegistryValue(n, n14);
        n16 = Script.GetRegistryValue(n, n16);
        n18 = Script.GetRegistryValue(n, n18);
        MsgBox.Add(n5, n7, s, n10, n12, n14, n16, n18, -1, -1, -1, true);
        return n3;
    }

    static int ExecStartSnow(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        Utils.SnowSetState(1);
        return ++n3;
    }

    static int ExecStopSnow(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        Utils.SnowSetState(3);
        return ++n3;
    }

    static int ExecSetCameraSpeed(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        Camera._nCamMaxSpd = n5 = Script.GetRegistryValue(n, n5);
        Camera._nCamSpd = n5;
        return ++n3;
    }

    static int ExecDefineEntityObjective(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        ++n3;
        int n13 = sArray[n12];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        UtilEntity.Objectives_AddTypeEntity(n5, n7, n9, n11, n13);
        return n3;
    }

    static int ExecDefineGlobalObjective(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        ++n3;
        int n15 = sArray[n14];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        UtilEntity.Objectives_AddTypeGlobal(n5, n7, n9, n11, n13, n15);
        return n3;
    }

    static int ExecSetObjectiveState(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        UtilEntity.Objectives_ChangeStatus(n5, n7);
        return ++n3;
    }

    static int ExecStartAttackEntityTutorial(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        ++n3;
        int n9 = sArray[n8];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        Tutorial.StartAttackTutorial(n5, 0, 0, n9, n7);
        return n3;
    }

    static int ExecSpawnAnimatedDecorator(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        ++n3;
        int n17 = sArray[n16];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        n17 = Script.GetRegistryValue(n, n17);
        Entity entity = Level.SpawnEntity(2);
        if (entity != null) {
            entity.Decorator_Init(n7, n9, n11, n13, n15, n17, -1, 0);
        }
        return n3;
    }

    static int ExecFadeToDark(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Utils.Fade(true, n5, true);
        return ++n3;
    }

    static int ExecFadeToGame(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Utils.Fade(false, n5, true);
        return ++n3;
    }

    static int ExecSetAlligeanceFlags(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._allegiance != n5 && n5 >= 0) continue;
            unit._flags |= n7;
            if ((n7 & 0x400) != 0) {
                unit._bSelected = false;
            }
            if ((n7 & 0x4000) == 0) continue;
            unit._targetPointer = -1;
        }
        return n3;
    }

    static int ExecResetAlligeanceFlags(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        ++n3;
        int n7 = sArray[n6] & 0xFFFF;
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        for (int i = 0; i < 64; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._allegiance != n5 && n5 >= 0) continue;
            unit._flags &= ~n7;
        }
        return n3;
    }

    static int ExecDisableCursorSelect(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        Cursor._disableBoxSelection = true;
        return ++n3;
    }

    static int ExecEnableCursorSelect(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        Cursor._disableBoxSelection = false;
        return ++n3;
    }

    static int ExecSpawnUnitsAtSP(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        int n15 = sArray[n14];
        int n16 = ++n3;
        ++n3;
        int n17 = sArray[n16];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        Entity entity = Level.GetEntityById(117, n9);
        if (entity != null) {
            for (n17 = Script.GetRegistryValue(n, n17); n17 > 0; --n17) {
                Unit unit = null;
                unit = n15 > 0 ? Level.SpawnUnit(n7, entity._pos_x, entity._pos_y, n13, 0, (byte)n15) : Level.SpawnUnit(n7, entity._pos_x, entity._pos_y, n13, 0, (byte)0);
                if (unit == null) break;
                if (unit != null && n5 > 0) {
                    unit._id = n5;
                }
                if (unit._allegiance != 1 || unit._group <= 0) continue;
                int[] nArray = MasterAI._AI_groups[n15];
                nArray[0] = nArray[0] + 1;
            }
        }
        return n3;
    }

    static int ExecStartSkipableMovie(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        Level._bCanSkipMovie = true;
        Level._bMovieSkipped = false;
        return ++n3;
    }

    static int ExecEndSkipableMovie(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        ++n3;
        if (Level._skipMovieState > 0) {
            Level._skipMovieState = 3;
        }
        Level._bCanSkipMovie = false;
        return n3;
    }

    static int ExecTestMovieSkipped(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        Script._scriptInstances[n][4] = Level._bMovieSkipped ? (short)1 : 0;
        return ++n3;
    }

    static int ExecSelectGroup(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        n5 = Script.GetRegistryValue(n, n5);
        Level.Group_Select(n5);
        return ++n3;
    }

    static int ExecShowPowerLines(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        Hud._show_power_lines = (n5 = Script.GetRegistryValue(n, n5)) == 1;
        return ++n3;
    }

    static int ExecDisableChangeSquad(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        Hud._disable_change_squad = true;
        return ++n3;
    }

    static int ExecSetPathRegion(int n, int n2, int n3) {
        short[] sArray = Script._scripts[n2];
        int n4 = ++n3;
        int n5 = sArray[n4];
        int n6 = ++n3;
        int n7 = sArray[n6];
        int n8 = ++n3;
        int n9 = sArray[n8];
        int n10 = ++n3;
        int n11 = sArray[n10];
        int n12 = ++n3;
        int n13 = sArray[n12];
        int n14 = ++n3;
        ++n3;
        int n15 = sArray[n14];
        n5 = Script.GetRegistryValue(n, n5);
        n7 = Script.GetRegistryValue(n, n7);
        n9 = Script.GetRegistryValue(n, n9);
        n11 = Script.GetRegistryValue(n, n11);
        n13 = Script.GetRegistryValue(n, n13);
        n15 = Script.GetRegistryValue(n, n15);
        Pathfinder.Region_Set(n5, n7, n9, n11, n13, n15);
        return n3;
    }
}

