/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Encyclopedia;
import com.ea.game.Entity;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.MsgBox;
import com.ea.game.Script;
import com.ea.game.Sprites;
import com.ea.game.Tutorial;
import com.ea.game.UtilEntity;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKMoreGames;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class Menu
implements Constants,
Key,
GraphicsConstants {
    public static int _state;
    public static int _menuIndex;
    public static int _menuHeadOnScreen;
    public static int _incBar;
    public static int _numLangsLoaded;
    private static int _numMainMenuItems;
    private static int _numIGMenuItems;
    private static int _numChooseLevelMenuItems;
    private static int _numOptionsMenuItems;
    private static int _numSelectedSkirmMenuItems;
    private static int _numChooseSkirmishLevelMenuItems;
    private static boolean _objectivesMenuDetails;
    private static int _numBonusMenuItems;
    private static int _numObjectivesMenuItems;
    private static int _headHelp;
    private static int _headAchBonus;
    private static int _headStats;
    public static int _msk_bonus_menu;
    private static int _mapIndex;
    private static int _factionIndex;
    private static int _aiIndex;
    private static int _skirmishState;
    private static int[] _splash_entities;
    private static int _splash_kirov_generator;
    private static boolean _splash_first_time;
    private static short _selectedFaction;
    private static int _totDrawH;
    public static int[] _arrow_keys;
    private static final int[] MAIN_MENU_ITEMS;
    private static final int SOVIET_GAME = 0;
    private static final int ALLIED_GAME = 1;
    private static final int SKIRMISH_GAME = 2;
    private static final int[] NEW_GAME_MENU_ITEMS;
    private static final int[] CHOOSE_SOVIET_MENU_ITEMS;
    private static final int[] CHOOSE_ALLIED_MENU_ITEMS;
    private static final int[] OPTIONS_MENU_ITEMS;
    private static final int[] BONUS_MENU_ITEMS;
    private static final int[] IG_MENU_ITEMS;
    private static int IGMenu_Objective_Pos;
    private static final int[] CHOOSE_SKIRMISH_FACTION_ITEMS;
    private static final int[] CHOOSE_SKIRMISH_LEVEL_MENU_ITEMS;
    private static final int[] CHOOSE_TOWER_DEF_MENU_ITEMS;
    private static SDKString[] _igMenu_strings;
    private static int _igMenu_width;
    private static final int[] STATS_MENU_ITEMS;
    public static final int[] ENCYCLOPEDIA_MENU_ITEMS;
    public static final int[] ENCYCLOPEDIA_DESCRIPTIONS;
    public static final int[] ACH_MENU_ITEMS;
    public static final int[] ACH_DESCRIPTIONS;
    private static final int[] EMBLEMS;
    public static SDKMoreGames _mgInstance;
    public static boolean _menuRefresh;
    private static SDKString _string;
    private static int _objectivesStartIndex;
    private static int _cameraStateX;
    private static int _cameraStateY;
    private static int _cameraStateDestX;
    private static int _cameraStateDestY;
    private static int _cameraState;
    private static int _cameraStateCamSpeed;
    private static int _cameraStateCursorDX;
    private static int _cameraStateCursorDY;
    private static int _cameraStateEntityPointer;
    static SDKString _stringTitleBonus;
    static SDKString _stringTitleAch;
    private static int _timer;
    private static int _timer2;
    private static int _horizontalScrollPos;
    private static int _horizontalScrollMax;
    private static int _verticalScrollPos;
    private static int _verticalScrollMax;
    public static short[] _detailStringLines;
    private static int _outro_string;
    static short[] _outro_lines;
    static short[] _outro_display;
    static short _outro_pos;
    static boolean _bScrolling;
    static int _scrollingDelta;
    public static final int MAIN_MENU_IDX = 0;
    public static final int OPTIONS_MENU_ITEMS_IDX = 1;
    public static final int BONUS_MENU_ITEMS_IDX = 2;
    public static final int IG_MENU_ITEMS_IDX = 3;
    public static final int CHOOSE_SKIRMISH_FACTION_ITEMS_IDX = 4;
    public static final int CHOOSE_SKIRMISH_LEVEL_MENU_ITEMS_IDX = 5;
    public static final int STATS_MENU_ITEMS_IDX = 6;
    public static final int ENCYCLOPEDIA_MENU_ITEMS_IDX = 7;
    public static final int ENCYCLOPEDIA_DESCRIPTIONS_IDX = 8;
    public static final int ACH_MENU_ITEMS_IDX = 9;
    public static final int ACH_DESCRIPTIONS_IDX = 10;
    public static final int CHOOSE_SOVIET_IDX = 11;
    public static final int CHOOSE_ALLIED_IDX = 12;
    public static final int[][] MENUS;
    public static boolean bMoreGames;

    public static void Init() {
        _numMainMenuItems = MAIN_MENU_ITEMS.length;
        _numIGMenuItems = IG_MENU_ITEMS.length;
        _igMenu_strings = new SDKString[_numIGMenuItems];
        _numChooseLevelMenuItems = 17;
        _numOptionsMenuItems = OPTIONS_MENU_ITEMS.length;
        _numBonusMenuItems = BONUS_MENU_ITEMS.length;
        _numSelectedSkirmMenuItems = CHOOSE_SKIRMISH_LEVEL_MENU_ITEMS.length;
        _string = new SDKString("");
        _menuRefresh = false;
        byte[] byArray = SDKInputStream.loadResourceAsByteArray(16);
        _numLangsLoaded = SDKUtils.loadTextHeader(byArray);
        _mgInstance = new SDKMoreGames(GameImpl.SCR_W, GameImpl.SCR_H){

            public SDKImage getImage(String string) {
                SDKImage sDKImage = null;
                if (string.equals("FNR")) {
                    sDKImage = SDKInputStream.loadImageObject(12);
                } else if (string.equals("TET")) {
                    sDKImage = SDKInputStream.loadImageObject(13);
                } else if (string.equals("MHA")) {
                    sDKImage = SDKInputStream.loadImageObject(15);
                } else if (string.equals("LOG")) {
                    sDKImage = SDKInputStream.loadImageObject(14);
                }
                return sDKImage;
            }
        };
        _mgInstance.setProductData(SDKInputStream.loadResourceAsByteArray(17));
        Object[] objectArray = new Object[5];
        objectArray[0] = GameImpl.fonts[4];
        objectArray[2] = GameImpl.fonts[5];
        objectArray[3] = GameImpl.fonts[4];
        objectArray[4] = GameImpl.fonts[4];
        objectArray[1] = GameImpl.fonts[4];
        _mgInstance.setFonts(objectArray);
    }

    public static void ShowMenu(int n) {
        _outro_string = -1;
        switch (n) {
            case 0: {
                Sprites.reLoadSplash();
                _menuIndex = 1;
                _state = n;
                break;
            }
            case 1: {
                _menuIndex = SDKUtils.getCurrentLanguage();
                _state = n;
                break;
            }
            case 2: {
                Sprites._sprites[46].Release();
                SDKUtils.loadStringsChunk(21);
                _mgInstance.reset();
                _menuIndex = 0;
                _state = n;
                break;
            }
            case 3: {
                int n2;
                int n3;
                _numObjectivesMenuItems = UtilEntity.Objectives_GetDisplayNr();
                _igMenu_width = 0;
                SDKUtils.setFont(GameImpl.fonts[0]);
                for (n3 = 0; n3 < OPTIONS_MENU_ITEMS.length; ++n3) {
                    Menu._igMenu_strings[n3] = SDKUtils.getString(OPTIONS_MENU_ITEMS[n3], _igMenu_strings[n3]);
                    n2 = SDKUtils.getStringSize(_igMenu_strings[n3]);
                    if (n2 <= _igMenu_width) continue;
                    _igMenu_width = n2;
                }
                for (n3 = 0; n3 < _numIGMenuItems; ++n3) {
                    if (_numObjectivesMenuItems != 0) {
                        // empty if block
                    }
                    if (n3 == IGMenu_Objective_Pos) continue;
                    Menu._igMenu_strings[n3] = SDKUtils.getString(IG_MENU_ITEMS[n3], _igMenu_strings[n3]);
                    n2 = SDKUtils.getStringSize(_igMenu_strings[n3]);
                    if (n2 <= _igMenu_width) continue;
                    _igMenu_width = n2;
                }
                _igMenu_width += 32;
                _menuIndex = 0;
                _state = n;
                break;
            }
            case 4: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _menuIndex = 0;
                _state = n;
                _headStats = 0;
                break;
            }
            case 5: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _menuIndex = 0;
                _state = n;
                _headStats = 0;
                break;
            }
            case 12: {
                int n4;
                Sprites._sprites[11].SetCurrentPalette(0);
                int n5 = Level.Find_unlocked_now();
                int n6 = 0;
                int n7 = 0;
                if (n5 != 0) {
                    for (n4 = 0; n4 < 15; ++n4) {
                        if ((n5 & 1 << n4) == 0) continue;
                        ++n6;
                    }
                    for (n4 = 0; n4 < 12; ++n4) {
                        if ((n5 & 1 << n4 + 16) == 0) continue;
                        ++n7;
                    }
                } else if (Level._b_skirmish) {
                    Menu.ShowMenu(9);
                    break;
                }
                _stringTitleBonus = SDKUtils.getString(389, _string).concat(" (" + n6 + ")");
                _stringTitleAch = SDKUtils.getString(385, _string).concat(" (" + n7 + ")");
                _headAchBonus = 0;
                _menuIndex = 0;
                _state = n;
                _bScrolling = false;
                _scrollingDelta = 0;
                for (int i = 0; i < 12; ++i) {
                    if ((n5 & 1 << i + 16) == 0) continue;
                    SDKUtils.setFont(GameImpl.fonts[5]);
                    _string = SDKUtils.getString(ACH_MENU_ITEMS[i], _string);
                    n4 = SDKUtils.getStringSize(_string);
                    int n8 = 340;
                    if (GameImpl.SCR_H < GameImpl.SCR_W) {
                        n8 = 360;
                    }
                    if (n4 <= n8) continue;
                    _bScrolling = true;
                    if (_scrollingDelta >= n4 - n8) continue;
                    _scrollingDelta = n4 - n8;
                }
                break;
            }
            case 15: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _menuIndex = 0;
                _state = n;
            }
            case 6: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _menuIndex = 0;
                _state = n;
                break;
            }
            case 7: {
                _menuIndex = 0;
                _state = n;
                break;
            }
            case 11: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _menuIndex = 0;
                _state = n;
                break;
            }
            case 14: {
                _headHelp = 0;
                _state = n;
                break;
            }
            case 17: {
                _headHelp = 0;
                _state = n;
                break;
            }
            case 8: {
                _state = n;
                break;
            }
            case 9: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _skirmishState = 0;
                _numSelectedSkirmMenuItems = GameImpl._maxSkirmishMission - 15 + 1;
                _menuIndex = 0;
                _mapIndex = 0;
                _factionIndex = 0;
                _aiIndex = 1;
                _state = n;
                break;
            }
            case 10: {
                _cameraStateX = Camera._nCamX;
                _cameraStateY = Camera._nCamY;
                _cameraStateDestX = Camera._nDestX;
                _cameraStateDestY = Camera._nDestY;
                _cameraState = Camera._state;
                _cameraStateCamSpeed = Camera._nCamSpd;
                _cameraStateCursorDX = Camera._nCursorDX;
                _cameraStateCursorDY = Camera._nCursorDY;
                _cameraStateEntityPointer = Camera._followEntityPointer;
                _timer = 0;
                Camera._state = 0;
                Camera.ResetCamera();
                GameImpl.SV_Y = 0;
                GameImpl.SV_H = 200;
                GameImpl.UpdateScreenConstants();
                _menuIndex = 0;
                _objectivesStartIndex = 0;
                _objectivesMenuDetails = false;
                _numObjectivesMenuItems = UtilEntity.Objectives_GetDisplayNr();
                _state = n;
                _horizontalScrollPos = 0;
                _verticalScrollPos = 0;
                break;
            }
            case 13: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _state = n;
                _menuIndex = 0;
                break;
            }
            case 16: {
                Sprites._sprites[11].SetCurrentPalette(0);
                _skirmishState = 0;
                _numSelectedSkirmMenuItems = CHOOSE_TOWER_DEF_MENU_ITEMS.length;
                _menuIndex = 0;
                _factionIndex = 0;
                _aiIndex = 1;
                _state = n;
                break;
            }
            case 18: {
                Sprites._sprites[11].SetCurrentPalette(0);
                if (Level._crt_level == 7) {
                    _outro_string = 93;
                    SDKUtils.getString(_outro_string, _string);
                    SDKUtils.wrapString(_string, _outro_lines, 200, (short)124);
                    _state = n;
                    _outro_pos = 0;
                    break;
                }
                if (Level._crt_level == 14) {
                    _outro_string = 94;
                    SDKUtils.getString(_outro_string, _string);
                    SDKUtils.wrapString(_string, _outro_lines, 200, (short)124);
                    _state = n;
                    _outro_pos = 0;
                    break;
                }
                Menu.ShowMenu(4);
                break;
            }
            case 19: {
                _state = n;
                _string = SDKUtils.getString(467, _string);
                SDKUtils.wrapString(_string, _detailStringLines, GameImpl.SCR_W - 5, (short)124);
                break;
            }
            case 20: {
                _state = n;
                break;
            }
            case 21: {
                _state = n;
                _string = SDKUtils.getString(341, _string);
                SDKUtils.wrapString(_string, _detailStringLines, GameImpl.SCR_W - 5, (short)124);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void Kill() {
        switch (_state) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 12: {
                break;
            }
            case 5: {
                break;
            }
            case 15: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 11: {
                break;
            }
            case 14: {
                break;
            }
            case 17: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                GameImpl.UpdateScreenResolution(true);
                Camera._nCamX = _cameraStateX;
                Camera._nCamY = _cameraStateY;
                Camera._nDestX = _cameraStateDestX;
                Camera._nDestY = _cameraStateDestY;
                Camera._state = _cameraState;
                Camera._nCamSpd = _cameraStateCamSpeed;
                Camera._nCursorDX = _cameraStateCursorDX;
                Camera._nCursorDY = _cameraStateCursorDY;
                Camera._followEntityPointer = _cameraStateEntityPointer;
                break;
            }
            case 13: {
                break;
            }
            case 18: {
                for (int i = 0; i < 20; ++i) {
                    Menu._outro_lines[i] = 0;
                    Menu._outro_display[i] = 0;
                }
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
        }
        _state = -1;
        _menuIndex = 0;
    }

    public static void Update() {
        switch (_state) {
            case 0: {
                Menu.UpdateSplash();
                Menu.UpdateMainMenu();
                break;
            }
            case 1: {
                if (GameImpl._gameState != 6) {
                    Menu.UpdateSplash();
                }
                Menu.UpdateLanguageMenu();
                break;
            }
            case 2: {
                Menu.UpdateMoreGamesMenu();
                break;
            }
            case 3: {
                Menu.UpdateIngameMenu();
                break;
            }
            case 4: {
                Menu.UpdateVictoryScreen();
                break;
            }
            case 12: {
                Menu.UpdateAchBonusScreen();
                break;
            }
            case 5: {
                Menu.UpdateDefeatScreen();
                break;
            }
            case 15: {
                Menu.UpdateNewGame();
                break;
            }
            case 6: {
                Menu.UpdateChooseLevel();
                break;
            }
            case 7: {
                if (GameImpl._gameState != 6) {
                    Menu.UpdateSplash();
                }
                Menu.UpdateOptionsMenu();
                break;
            }
            case 11: {
                Menu.UpdateSplash();
                Menu.UpdateBonusMenu();
                break;
            }
            case 14: 
            case 17: {
                Menu.UpdateHelpMenu();
                break;
            }
            case 8: {
                MsgBox.Update();
                break;
            }
            case 9: {
                Menu.UpdateSplash();
                Menu.UpdateSkirmish();
                break;
            }
            case 10: {
                Menu.UpdateObjectivesMenu();
                Camera.UpdateCamera();
                Map.CDB_Update();
                Map.CDB_Invalidator_Update();
                Hud.UpdateMinimapOnly();
                break;
            }
            case 13: {
                Menu.UpdateSplash();
                if (SDKCanvas.isNewKeyPressed(32)) {
                    GameImpl.saveRMS();
                    SDKMIDlet.exit();
                    break;
                }
                if (!SDKCanvas.isNewKeyPressed(524352)) break;
                Menu.Kill();
                Menu.ShowMenu(0);
                break;
            }
            case 16: {
                Menu.UpdateSplash();
                Menu.UpdateTDMenu();
                break;
            }
            case 18: {
                Menu.UpdateOutro();
                break;
            }
            case 19: {
                Menu.UpdateIngameExitMenu();
                break;
            }
            case 20: {
                Menu.UpdateSplash();
                if (SDKCanvas.isNewKeyPressed(32)) {
                    Menu.ResetAllSavedData();
                    Menu.Kill();
                    Menu.ShowMenu(7);
                    break;
                }
                if (!SDKCanvas.isNewKeyPressed(524352)) break;
                Menu.Kill();
                Menu.ShowMenu(7);
                break;
            }
            case 21: {
                Menu.UpdateIngameRestartMenu();
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void Draw(SDKGraphics sDKGraphics) {
        switch (_state) {
            case 0: {
                Menu.DrawMainMenu(sDKGraphics);
                break;
            }
            case 1: {
                Menu.DrawLanguageMenu(sDKGraphics);
                break;
            }
            case 2: {
                Menu.DrawMoreGamesMenu(sDKGraphics);
                break;
            }
            case 3: {
                Menu.DrawIngameMenu(sDKGraphics);
                break;
            }
            case 4: {
                Menu.DrawVictoryScreen(sDKGraphics);
                break;
            }
            case 12: {
                Menu.DrawAchBonusResult(sDKGraphics);
                break;
            }
            case 5: {
                Menu.DrawDefeatScreen(sDKGraphics);
                break;
            }
            case 15: {
                Menu.DrawNewGame(sDKGraphics);
                break;
            }
            case 6: {
                Menu.DrawChooseLevel(sDKGraphics);
                break;
            }
            case 7: {
                Menu.DrawOptionsMenu(sDKGraphics);
                break;
            }
            case 11: {
                Menu.DrawBonusMenu(sDKGraphics);
                break;
            }
            case 14: {
                Menu.DrawHelpMenu(sDKGraphics, 330, 338, true);
                break;
            }
            case 17: {
                Menu.DrawHelpMenu(sDKGraphics, 329, 337, false);
                break;
            }
            case 8: {
                XSprite xSprite = Sprites._sprites[46];
                xSprite.DrawFrame(0, 0, 0, 0);
                MsgBox.Draw(sDKGraphics);
                break;
            }
            case 9: {
                Menu.DrawSkirmish(sDKGraphics);
                break;
            }
            case 10: {
                Menu.DrawObjectivesMenu(sDKGraphics);
                Hud.DrawMinimapAndDetailsOnly(sDKGraphics);
                break;
            }
            case 13: {
                Menu.DrawSplash(true);
                Menu.DrawSplashKirov(true);
                _string = SDKUtils.getString(16, _string);
                SDKUtils.setFont(GameImpl.fonts[0]);
                SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 1, 1);
                Hud.DrawSoftKeys(SDKUtils.getString(13, _string), true, 4, false, false, 0);
                Hud.DrawSoftKeys(SDKUtils.getString(14, _string), false, 4, false, false, 0);
                break;
            }
            case 16: {
                Menu.DrawTDMenu(sDKGraphics);
                break;
            }
            case 18: {
                Menu.DrawOutro(sDKGraphics);
                break;
            }
            case 19: {
                Menu.DrawIngameExitMenu(sDKGraphics);
                break;
            }
            case 20: {
                Menu.DrawSplash(true);
                Menu.DrawSplashKirov(true);
                _string = SDKUtils.getString(384, _string);
                SDKUtils.setFont(GameImpl.fonts[4]);
                _detailStringLines = SDKUtils.wrapString(_string, _detailStringLines, GameImpl.SCR_W, (short)124);
                SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 1, 3);
                Hud.DrawSoftKeys(SDKUtils.getString(13, _string), true, 4, false, false, 0);
                Hud.DrawSoftKeys(SDKUtils.getString(14, _string), false, 4, false, false, 0);
                break;
            }
            case 21: {
                Menu.DrawIngameRestartMenu(sDKGraphics);
                break;
            }
            default: {
                return;
            }
        }
    }

    public static void UpdateMainMenu() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            switch (MAIN_MENU_ITEMS[_menuIndex]) {
                case 331: {
                    Menu.Kill();
                    Menu.ShowMenu(15);
                    break;
                }
                case 335: {
                    if (GameImpl._nextMission < 0 || GameImpl._nextMission >= 15) break;
                    Menu.Kill();
                    Level._b_skirmish = false;
                    Level._b_tower_defense = false;
                    Level._crt_level = GameImpl._nextMission;
                    int n = Level.GetLevelStats(Level._crt_level, 16);
                    if (n != -1) {
                        SDKUtils.loadStringsChunk(n);
                    }
                    MsgBox.Start(Level.GetLevelStats(Level._crt_level, 10), true);
                    Menu.ShowMenu(8);
                    break;
                }
                case 333: {
                    Menu.Kill();
                    Menu.ShowMenu(2);
                    break;
                }
                case 336: {
                    Menu.Kill();
                    Menu.ShowMenu(7);
                    break;
                }
                case 339: {
                    _msk_bonus_menu |= 1;
                    if ((GameImpl._unlockables & 0xFFFF) != 0) {
                        _msk_bonus_menu |= 2;
                    }
                    Menu.Kill();
                    Menu.ShowMenu(11);
                    break;
                }
                case 338: {
                    Menu.Kill();
                    Menu.ShowMenu(14);
                    break;
                }
                case 337: {
                    Menu.Kill();
                    Menu.ShowMenu(17);
                    break;
                }
                case 3: {
                    Menu.Kill();
                    Menu.ShowMenu(13);
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(524288)) {
            Menu.Kill();
            Menu.ShowMenu(13);
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (GameImpl._nextMission < 0 && --_menuIndex < 1 || GameImpl._nextMission >= 0 && --_menuIndex < 0) {
                _menuIndex = _numMainMenuItems - 1;
            }
            if (!_mgInstance.isAvailable() && MAIN_MENU_ITEMS[_menuIndex] == 333 && (GameImpl._nextMission < 0 && --_menuIndex < 1 || GameImpl._nextMission >= 0 && --_menuIndex < 0)) {
                _menuIndex = _numMainMenuItems - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            _menuIndex = GameImpl._nextMission < 0 && _menuIndex + 1 == _numMainMenuItems ? (_menuIndex + 2) % _numMainMenuItems : (_menuIndex + 1) % _numMainMenuItems;
            if (!_mgInstance.isAvailable() && MAIN_MENU_ITEMS[_menuIndex] == 333) {
                _menuIndex = GameImpl._nextMission < 0 && _menuIndex + 1 == _numMainMenuItems ? (_menuIndex + 2) % _numMainMenuItems : (_menuIndex + 1) % _numMainMenuItems;
            }
        } else if (SDKCanvas.isNewKeyPressed(256)) {
            // empty if block
        }
    }

    public static void DrawMainMenu(SDKGraphics sDKGraphics) {
        int n = -1;
        if (GameImpl._nextMission < 0) {
            n &= 0xFFFFFFFE;
        }
        if (!_mgInstance.isAvailable()) {
            n &= 0xFFFFFFFB;
        }
        int n2 = Menu.DrawMenu(sDKGraphics, true, true, (byte)17, (short)((GameImpl.SCR_W >> 1) - 140), 90, 0, false, -1, n, 8, 4, 4, 16);
        Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
    }

    public static void InitSplash() {
        if (!_splash_first_time) {
            return;
        }
        Utils.setSeed(System.currentTimeMillis());
        int n = Utils.random(1, 3);
        int n2 = 160 / n;
        for (int i = 0; i < n; ++i) {
            int n3 = Menu.GetOpenPosition();
            if (n3 == -1) continue;
            int n4 = Utils.random(3);
            Menu._splash_entities[n3 * 6 + 0] = 1;
            Menu._splash_entities[n3 * 6 + 1] = 4 + n4;
            Menu._splash_entities[n3 * 6 + 2] = Utils.random(i * n2, (i + 1) * n2);
            Menu._splash_entities[n3 * 6 + 3] = Utils.random(70, 170);
            Menu._splash_entities[n3 * 6 + 5] = Utils.random(5, 55);
            Menu._splash_entities[n3 * 6 + 4] = 1;
        }
    }

    public static void UpdateSplash() {
        int n;
        int n2;
        block10: for (n2 = 0; n2 < 20; ++n2) {
            switch (_splash_entities[n2 * 6 + 0]) {
                case 1: {
                    int n3 = n2 * 6 + 2;
                    _splash_entities[n3] = _splash_entities[n3] - _splash_entities[n2 * 6 + 4];
                    if (_splash_entities[n2 * 6 + 2] <= 160) {
                        int n4 = n2 * 6 + 5;
                        _splash_entities[n4] = _splash_entities[n4] - 1;
                    }
                    if (_splash_entities[n2 * 6 + 5] <= 0 && _splash_entities[n2 * 6 + 2] <= 160) {
                        n = _splash_entities[n2 * 6 + 1] - 4;
                        int n5 = Menu.GetOpenPosition();
                        if (n5 >= 0) {
                            Menu._splash_entities[n5 * 6 + 0] = 2;
                            Menu._splash_entities[n5 * 6 + 1] = 7 + n;
                            Menu._splash_entities[n5 * 6 + 2] = _splash_entities[n2 * 6 + 2];
                            Menu._splash_entities[n5 * 6 + 3] = _splash_entities[n2 * 6 + 3];
                            switch (n) {
                                case 0: {
                                    int n6 = n5 * 6 + 2;
                                    _splash_entities[n6] = _splash_entities[n6] + 37;
                                    int n7 = n5 * 6 + 3;
                                    _splash_entities[n7] = _splash_entities[n7] + 32;
                                    break;
                                }
                                case 1: {
                                    int n8 = n5 * 6 + 2;
                                    _splash_entities[n8] = _splash_entities[n8] + 25;
                                    int n9 = n5 * 6 + 3;
                                    _splash_entities[n9] = _splash_entities[n9] + 23;
                                    break;
                                }
                                case 2: {
                                    int n10 = n5 * 6 + 2;
                                    _splash_entities[n10] = _splash_entities[n10] + 21;
                                    int n11 = n5 * 6 + 3;
                                    _splash_entities[n11] = _splash_entities[n11] + 19;
                                }
                            }
                            Menu._splash_entities[n5 * 6 + 5] = Utils.random(305, 320);
                            Menu._splash_entities[n5 * 6 + 4] = 3;
                            Menu._splash_entities[n2 * 6 + 5] = Utils.random(5, 55);
                        }
                    }
                    if (_splash_entities[n2 * 6 + 2] >= -90) continue block10;
                    Menu._splash_entities[n2 * 6 + 0] = 0;
                    continue block10;
                }
                case 2: {
                    int n12 = n2 * 6 + 3;
                    _splash_entities[n12] = _splash_entities[n12] + _splash_entities[n2 * 6 + 4];
                    if (_splash_entities[n2 * 6 + 3] < _splash_entities[n2 * 6 + 5]) continue block10;
                    Menu._splash_entities[n2 * 6 + 0] = 0;
                    continue block10;
                }
                case 3: {
                    int n13 = n2 * 6 + 5;
                    _splash_entities[n13] = _splash_entities[n13] - 1;
                    if (_splash_entities[n2 * 6 + 5] > 0) continue block10;
                    Menu._splash_entities[n2 * 6 + 0] = 0;
                }
            }
        }
        if (_splash_kirov_generator <= 0 && (n2 = Menu.GetOpenPosition()) != -1) {
            n = Utils.random(3);
            Menu._splash_entities[n2 * 6 + 0] = 1;
            Menu._splash_entities[n2 * 6 + 1] = 4 + n;
            Menu._splash_entities[n2 * 6 + 2] = GameImpl.SV_W;
            Menu._splash_entities[n2 * 6 + 3] = Utils.random(70, 170);
            Menu._splash_entities[n2 * 6 + 5] = Utils.random(5, 55);
            Menu._splash_entities[n2 * 6 + 4] = 1;
            _splash_kirov_generator = Utils.random(100, 160);
        }
        --_splash_kirov_generator;
    }

    public static void DrawSplash(boolean bl) {
        XSprite xSprite = Sprites._sprites[46];
        xSprite.DrawFrame(0, 0, 0, 0);
        if (bl) {
            XSprite xSprite2 = Sprites._sprites[45];
            xSprite2.DrawFrame(16, 0, 0, 0);
        }
    }

    public static void DrawSplashKirov(boolean bl) {
        int n;
        XSprite xSprite = Sprites._sprites[45];
        if (bl) {
            n = 58;
            int n2 = 12;
            int n3 = 0;
            if (GameImpl._language == 1) {
                n3 = 17;
            }
            if (GameImpl._language == 3) {
                n3 = 20;
            }
            if (GameImpl._language == 2) {
                n3 = 0;
            }
            xSprite.DrawFrame(n3, n, n2, 0);
        }
        for (n = 0; n < 20; ++n) {
            if (_splash_entities[n * 6 + 0] <= 0) continue;
            xSprite.DrawFrame(_splash_entities[n * 6 + 1], _splash_entities[n * 6 + 2], _splash_entities[n * 6 + 3], 0);
        }
    }

    public static int GetOpenPosition() {
        for (int i = 0; i < 20; ++i) {
            if (_splash_entities[i * 6 + 0] != 0) continue;
            return i;
        }
        return -1;
    }

    public static void UpdateLanguageMenu() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            SDKUtils.setCurrentLanguage(_menuIndex);
            Hud._tooltip_old_name = -1;
            GameImpl._language = _menuIndex;
            GameImpl.saveRMS();
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            Menu.ShowMenu(7);
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (--_menuIndex < 0) {
                _menuIndex = _numLangsLoaded - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            _menuIndex = (_menuIndex + 1) % _numLangsLoaded;
        }
    }

    public static void DrawLanguageMenu(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        int n3;
        if (GameImpl._gameState != 6) {
            Menu.DrawSplash(true);
            Menu.DrawSplashKirov(true);
        } else {
            Utils.FillRect(sDKGraphics, Integer.MIN_VALUE, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
            n3 = OPTIONS_MENU_ITEMS.length;
            n2 = n3 * 2 + 1;
            n = GameImpl.SCR_W - _igMenu_width >> 1;
            int n4 = GameImpl.SCR_H - (n2 *= SDKUtils.getLineSize()) >> 1;
            sDKGraphics.setColor(0x200000);
            sDKGraphics.fillRect(n, n4, _igMenu_width, n2);
            sDKGraphics.setColor(0xA00000);
            sDKGraphics.drawRect(n, n4, _igMenu_width, n2);
        }
        SDKUtils.setFont(GameImpl.fonts[4]);
        n3 = SDKUtils.getLineSize();
        n2 = (GameImpl.SCR_H >> 1) - (n3 * _numLangsLoaded >> 1);
        for (n = 0; n < _numLangsLoaded; ++n) {
            SDKUtils.getHeaderString(n, 0, _string);
            if (n == _menuIndex) {
                SDKUtils.setFont(GameImpl.fonts[1]);
                SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, n2, 17);
                SDKUtils.setFont(GameImpl.fonts[4]);
            } else {
                SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, n2, 1);
            }
            n2 += n3;
        }
        if (GameImpl._gameState != 6) {
            Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
            Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
        } else {
            Hud.DrawSoftKeys(SDKUtils.getString(6, GameImpl._string), true, 4, true, true, 0);
            Hud.DrawSoftKeys(SDKUtils.getString(4, GameImpl._string), false, 4, true, true, 0);
        }
    }

    public static void UpdateMoreGamesMenu() {
        if (_mgInstance.isActive()) {
            if (!bMoreGames) {
                GameImpl._soundManager.stopSounds();
                bMoreGames = true;
            }
            _mgInstance.update();
        } else {
            Menu.Kill();
            Menu.ShowMenu(0);
            if (bMoreGames) {
                GameImpl._soundManager.setCurrentLoop(-1);
                GameImpl._soundManager.playSound(28);
                bMoreGames = false;
            }
        }
    }

    public static void DrawMoreGamesMenu(SDKGraphics sDKGraphics) {
        _mgInstance.paint(sDKGraphics);
    }

    public static void UpdateIngameMenu() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            switch (IG_MENU_ITEMS[_menuIndex]) {
                case 340: {
                    GameImpl.SetState(5);
                    break;
                }
                case 343: {
                    Menu.Kill();
                    Menu.ShowMenu(10);
                    break;
                }
                case 336: {
                    Menu.Kill();
                    Menu.ShowMenu(7);
                    break;
                }
                case 337: {
                    Menu.Kill();
                    Menu.ShowMenu(17);
                    break;
                }
                case 341: {
                    Menu.Kill();
                    Menu.ShowMenu(21);
                    break;
                }
                case 342: {
                    Menu.Kill();
                    Menu.ShowMenu(19);
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            if (GameImpl._soundEnable) {
                GameImpl._soundFadeTimer = 0;
                Level._SoundUpdate();
            }
            GameImpl.SetState(5);
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            _menuIndex = (_menuIndex + _numIGMenuItems - 1) % _numIGMenuItems;
            if (_numObjectivesMenuItems != 0) {
                // empty if block
            }
            if (_menuIndex == IGMenu_Objective_Pos) {
                _menuIndex = (_menuIndex + _numIGMenuItems - 1) % _numIGMenuItems;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            _menuIndex = (_menuIndex + 1) % _numIGMenuItems;
            if (_numObjectivesMenuItems != 0) {
                // empty if block
            }
            if (_menuIndex == IGMenu_Objective_Pos) {
                _menuIndex = (_menuIndex + 1) % _numIGMenuItems;
            }
        }
    }

    public static void DrawIngameMenu(SDKGraphics sDKGraphics) {
        Menu.darkenRegion(sDKGraphics, Integer.MIN_VALUE, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        if (_numObjectivesMenuItems != 0) {
            // empty if block
        }
        int n = _numIGMenuItems - 1;
        int n2 = 7 + n * (SDKUtils.getLineSize() + 7);
        int n3 = GameImpl.SCR_W - _igMenu_width >> 1;
        int n4 = GameImpl.SCR_H - n2 >> 1;
        sDKGraphics.setColor(0x200000);
        sDKGraphics.fillRect(n3, n4, _igMenu_width, n2);
        sDKGraphics.setColor(0xA00000);
        sDKGraphics.drawRect(n3, n4, _igMenu_width, n2);
        n3 = GameImpl.SCR_W >> 1;
        n4 += 7;
        for (int i = 0; i < _numIGMenuItems; ++i) {
            if (_numObjectivesMenuItems != 0) {
                // empty if block
            }
            if (i == IGMenu_Objective_Pos) continue;
            if (i == _menuIndex) {
                SDKUtils.setFont(GameImpl.fonts[1]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[4]);
            }
            SDKUtils.drawString(_igMenu_strings[i], n3, n4, 1);
            n4 += SDKUtils.getLineSize() + 7;
        }
        Hud.DrawSoftKeys(SDKUtils.getString(6, GameImpl._string), true, 4, true, true, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(4, GameImpl._string), false, 4, true, true, 0);
        _string = SDKUtils.getString(468, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, (GameImpl.SCR_H >> 3) + 0, 1);
    }

    public static void UpdateAchBonusScreen() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            if (GameImpl._nextMission >= 0 && GameImpl._nextMission != Level._crt_level && !Level._b_skirmish) {
                Menu.Kill();
                Level._b_skirmish = false;
                Level._crt_level = GameImpl._nextMission;
                int n = Level.GetLevelStats(Level._crt_level, 16);
                if (n != -1) {
                    SDKUtils.loadStringsChunk(n);
                }
                if (GameImpl._soundEnable) {
                    GameImpl._soundManager.stopSounds();
                    GameImpl._soundManager.setCurrentLoop(-1);
                    GameImpl._soundManager.playSound(28);
                }
                MsgBox.Start(Level.GetLevelStats(Level._crt_level, 10), true);
                GameImpl.SetState(4);
                Menu.ShowMenu(8);
            }
        } else if (SDKCanvas.isKeyPressed(32770)) {
            if (_totDrawH - _headAchBonus - 15 > GameImpl.SCR_H) {
                _headAchBonus += 10;
            }
        } else if (SDKCanvas.isKeyPressed(513)) {
            if (_headAchBonus > 0) {
                _headAchBonus -= 10;
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            GameImpl.SetState(4);
            Menu.ShowMenu(0);
            if (GameImpl._soundEnable) {
                GameImpl._soundManager.setCurrentLoop(-1);
                GameImpl._soundManager.playSound(28);
            }
        }
        if (_bScrolling) {
            _scrollingDelta = _scrollingDelta > -14 ? --_scrollingDelta : 30;
        }
    }

    public static void DrawAchBonusResult(SDKGraphics sDKGraphics) {
        int n = 20;
        XSprite xSprite = Sprites._sprites[42];
        XSprite xSprite2 = Sprites._sprites[11];
        int n2 = Level.Find_unlocked_now();
        if (n2 != 0) {
            int n3;
            SDKUtils.setFont(GameImpl.fonts[1]);
            _detailStringLines = SDKUtils.wrapString(_stringTitleBonus, _detailStringLines, GameImpl.SCR_W, (short)124);
            if (_detailStringLines[0] > 0) {
                SDKUtils.drawWrappedString(_stringTitleBonus, _detailStringLines, 1, _detailStringLines[0], GameImpl.SCR_W >> 1, n - _headAchBonus, 17);
                n += SDKUtils.getLineSize() * _detailStringLines[0];
            } else {
                SDKUtils.drawString(_stringTitleBonus, GameImpl.SCR_W >> 1, n - _headAchBonus, 17);
                n += SDKUtils.getLineSize();
            }
            Menu.DrawLine(SDKUtils.getStringSize(_stringTitleBonus), 21, (GameImpl.SCR_W >> 1) - (SDKUtils.getStringSize(_stringTitleBonus) >> 1), n - _headAchBonus, 2);
            n += 10;
            SDKUtils.setFont(GameImpl.fonts[4]);
            int n4 = 0;
            for (n3 = 0; n3 < 15; ++n3) {
                if ((n2 & 1 << n3) != 0) {
                    _detailStringLines = SDKUtils.wrapString(_string = SDKUtils.getString(445 + n4, _string), _detailStringLines, GameImpl.SCR_W, (short)124);
                    if (_detailStringLines[0] > 1) {
                        SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], GameImpl.SCR_W >> 1, n - _headAchBonus, 17);
                    } else {
                        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, n - _headAchBonus, 17);
                    }
                    xSprite.DrawFrame(31, GameImpl.SCR_W >> 1, (n += SDKUtils.getLineSize() * _detailStringLines[0] + 10) - _headAchBonus, 0);
                    int[] nArray = xSprite.RectFrame(31, 0, 0, 0);
                    n += nArray[3] + 10;
                }
                if (n3 == 7 || n3 == 13 || n3 == 14) continue;
                ++n4;
            }
            if (n2 >> 16 != 0) {
                SDKUtils.setFont(GameImpl.fonts[1]);
                n += SDKUtils.getLineSize();
                SDKUtils.drawString(_stringTitleAch, GameImpl.SCR_W >> 1, (n += SDKUtils.getLineSize()) - _headAchBonus, 17);
                Menu.DrawLine(SDKUtils.getStringSize(_stringTitleAch), 21, (GameImpl.SCR_W >> 1) - (SDKUtils.getStringSize(_stringTitleAch) >> 1), (n += SDKUtils.getLineSize()) - _headAchBonus, 2);
                n += 30;
                SDKUtils.setFont(GameImpl.fonts[4]);
                SDKString sDKString = new SDKString();
                short[] sArray = new short[128];
                n3 = SDKUtils.getLineSize() * 8 + 20;
                for (int i = 0; i <= 12; ++i) {
                    int n5;
                    if ((n2 & 1 << i + 16) == 0) continue;
                    Encyclopedia.DrawAchBox(sDKGraphics, true, n - _headAchBonus - 10, n3);
                    xSprite.DrawFrame(3, 15, n - _headAchBonus + 15, 0);
                    SDKUtils.setFont(GameImpl.fonts[5]);
                    _string = SDKUtils.getString(ACH_MENU_ITEMS[i], _string);
                    int n6 = SDKUtils.getStringSize(_string);
                    int n7 = 340;
                    if (GameImpl.SCR_H < GameImpl.SCR_W) {
                        n7 = 360;
                    }
                    if (n6 > n7) {
                        sDKGraphics.setClip(23, n - _headAchBonus, n7, SDKUtils.getLineSize());
                        n5 = 0;
                        if (_scrollingDelta >= 0) {
                            n5 = _scrollingDelta;
                        }
                        if (n6 >> 1 > (n7 >> 1) + n5) {
                            if (n5 == 0) {
                                SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - ((n6 >> 1) - (n7 >> 1)), n - _headAchBonus, 17);
                            } else {
                                SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) + n5, n - _headAchBonus, 17);
                            }
                        } else {
                            SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) + n5, n - _headAchBonus, 17);
                        }
                        sDKGraphics.setClip(0, 15, GameImpl.SCR_W, GameImpl.SCR_H - 30);
                    } else {
                        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, n - _headAchBonus, 17);
                    }
                    SDKUtils.setFont(GameImpl.fonts[4]);
                    n5 = GameImpl.SCR_H > GameImpl.SCR_W ? n7 : GameImpl.SCR_W - 80 - 40;
                    sDKString = SDKUtils.getString(ACH_DESCRIPTIONS[i], sDKString);
                    SDKUtils.wrapString(sDKString, sArray, n5, (short)124);
                    short s = sArray[0];
                    SDKUtils.drawWrappedString(sDKString, sArray, 1, s, 40, n - _headAchBonus + SDKUtils.getLineSize(), 20);
                    SDKUtils.setFont(GameImpl.fonts[0]);
                    if (i == 12) continue;
                    if (GameImpl.SCR_H > GameImpl.SCR_W) {
                        n += n3 + 20;
                        continue;
                    }
                    n += n3;
                }
            }
            if (GameImpl.SCR_H < GameImpl.SCR_W) {
                n += 15;
            }
            _totDrawH = n;
            sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(0, 0, GameImpl.SCR_W, 15);
            sDKGraphics.fillRect(0, GameImpl.SCR_H - 15, GameImpl.SCR_W, 15);
            if (GameImpl._nextMission >= 0 && GameImpl._nextMission != Level._crt_level && !Level._b_skirmish) {
                Hud.DrawSoftKeys(SDKUtils.getString(335, _string), true, 4, false, false, 0);
            }
            Hud.DrawSoftKeys(SDKUtils.getString(3, _string), false, 4, false, false, 0);
            n3 = 14;
            if (_totDrawH - _headAchBonus - 15 > GameImpl.SCR_H) {
                n3 = SDKCanvas.isKeyPressed(32770) ? 93 : 14;
                xSprite2.DrawFrame(n3, GameImpl.SCR_W >> 1, GameImpl.SCR_H - 7, 0);
            }
            if (_headAchBonus > 0) {
                n3 = SDKCanvas.isKeyPressed(513) ? 92 : 13;
                xSprite2.DrawFrame(n3, GameImpl.SCR_W >> 1, 7, 0);
            }
        }
    }

    public static void UpdateVictoryScreen() {
        int n = Level.Find_unlocked_now();
        if (n != 0) {
            if (SDKCanvas.isNewKeyPressed(4144) || SDKCanvas.isNewKeyPressed(524288)) {
                GameImpl.SetState(11);
            } else if (SDKCanvas.isKeyPressed(32770)) {
                if (_totDrawH - _headStats + 15 > GameImpl.SCR_H) {
                    _headStats += 10;
                }
            } else if (SDKCanvas.isKeyPressed(513) && _headStats > 0) {
                _headStats -= 10;
            }
        } else if (SDKCanvas.isKeyPressed(32770)) {
            if (_totDrawH - _headStats + 15 > GameImpl.SCR_H) {
                _headStats += 10;
            }
        } else if (SDKCanvas.isKeyPressed(513)) {
            if (_headStats > 0) {
                _headStats -= 10;
            }
        } else if (SDKCanvas.isNewKeyPressed(4144)) {
            if (GameImpl._nextMission >= 0 && GameImpl._nextMission != Level._crt_level && !Level._b_skirmish) {
                Menu.Kill();
                Level._b_skirmish = false;
                Level._crt_level = GameImpl._nextMission;
                int n2 = Level.GetLevelStats(Level._crt_level, 16);
                if (n2 != -1) {
                    SDKUtils.loadStringsChunk(n2);
                }
                if (GameImpl._soundEnable) {
                    GameImpl._soundManager.stopSounds();
                    GameImpl._soundManager.setCurrentLoop(-1);
                    GameImpl._soundManager.playSound(28);
                }
                MsgBox.Start(Level.GetLevelStats(Level._crt_level, 10), true);
                GameImpl.SetState(4);
                Menu.ShowMenu(8);
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            GameImpl.SetState(4);
            Menu.ShowMenu(0);
            if (GameImpl._soundEnable) {
                GameImpl._soundManager.setCurrentLoop(-1);
                GameImpl._soundManager.playSound(28);
            }
        }
    }

    public static void DrawVictoryScreen(SDKGraphics sDKGraphics) {
        Menu.DrawStatsScreen(sDKGraphics);
        _string = SDKUtils.getString(344, _string);
        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, 35, 1);
        int n = Level.Find_unlocked_now();
        if (n != 0) {
            Hud.DrawSoftKeys(SDKUtils.getString(5, _string), true, 4, false, false, 0);
        } else {
            if (GameImpl._nextMission >= 0 && GameImpl._nextMission != Level._crt_level && !Level._b_skirmish) {
                Hud.DrawSoftKeys(SDKUtils.getString(335, _string), true, 4, false, false, 0);
            }
            Hud.DrawSoftKeys(SDKUtils.getString(3, _string), false, 4, false, false, 0);
        }
    }

    public static void UpdateDefeatScreen() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            Menu.Kill();
            GameImpl.SetState(8);
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            GameImpl.SetState(4);
            Menu.ShowMenu(0);
            if (GameImpl._soundEnable) {
                GameImpl._soundManager.setCurrentLoop(-1);
                GameImpl._soundManager.playSound(28);
            }
        } else if (SDKCanvas.isKeyPressed(32770)) {
            if (_totDrawH - _headStats + 15 > GameImpl.SCR_H) {
                _headStats += 10;
            }
        } else if (SDKCanvas.isKeyPressed(513) && _headStats > 0) {
            _headStats -= 10;
        }
    }

    public static void DrawDefeatScreen(SDKGraphics sDKGraphics) {
        Menu.DrawStatsScreen(sDKGraphics);
        _string = SDKUtils.getString(345, _string);
        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, 35, 1);
        Hud.DrawSoftKeys(SDKUtils.getString(341, _string), true, 4, false, false, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(3, _string), false, 4, false, false, 0);
    }

    public static void UpdateNewGame() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            switch (NEW_GAME_MENU_ITEMS[_menuIndex]) {
                case 369: {
                    _selectedFaction = 0;
                    Menu.Kill();
                    Menu.ShowMenu(6);
                    break;
                }
                case 370: {
                    _selectedFaction = 1;
                    Menu.Kill();
                    Menu.ShowMenu(6);
                    break;
                }
                case 334: {
                    _selectedFaction = (short)2;
                    Menu.Kill();
                    Menu.ShowMenu(9);
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(2052)) {
            if (--_menuIndex < 0) {
                _menuIndex = NEW_GAME_MENU_ITEMS.length - 1;
            }
            if (GameImpl._maxAlliedMission < 0 && NEW_GAME_MENU_ITEMS[_menuIndex] == 370 && --_menuIndex < 0) {
                _menuIndex = NEW_GAME_MENU_ITEMS.length - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(8200)) {
            _menuIndex = (_menuIndex + 1) % NEW_GAME_MENU_ITEMS.length;
            if (GameImpl._maxAlliedMission < 0 && NEW_GAME_MENU_ITEMS[_menuIndex] == 370) {
                _menuIndex = (_menuIndex + 1) % NEW_GAME_MENU_ITEMS.length;
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            GameImpl.SetState(4);
            _state = 0;
        }
    }

    public static void DrawNewGame(SDKGraphics sDKGraphics) {
        int n = 334;
        int n2 = 1;
        Menu.DrawSplash(false);
        Utils.FillRect(sDKGraphics, -1728053248, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        Hud.DrawSoftKeys(SDKUtils.getString(4, GameImpl._string), false, 4, false, false, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
        XSprite xSprite = Sprites._sprites[43];
        XSprite xSprite2 = Sprites._sprites[42];
        XSprite xSprite3 = Sprites._sprites[11];
        XSprite xSprite4 = Sprites._sprites[45];
        Menu.DrawLine(80, 21, (GameImpl.SCR_W >> 1) - 40, (GameImpl.SCR_H >> 1) - 60, 2);
        Menu.DrawLine(GameImpl.SCR_W - 80, 21, 40, (GameImpl.SCR_H >> 1) + 30, 2);
        if (_menuIndex != 0) {
            xSprite.SetCurrentPalette(1);
            n2 = 23;
        } else {
            xSprite.SetCurrentPalette(0);
            n = 369;
            n2 = 1;
        }
        xSprite.DrawFrame(0, (GameImpl.SCR_W >> 1) - 60 - 30 - 10, (GameImpl.SCR_H >> 1) - 50, 0);
        xSprite2.DrawFrame(n2, (GameImpl.SCR_W >> 1) - 60 - 10, (GameImpl.SCR_H >> 1) - 50 + 30, 0);
        if (_menuIndex != 1) {
            xSprite.SetCurrentPalette(3);
            n2 = 27;
        } else {
            xSprite.SetCurrentPalette(2);
            n = 370;
            n2 = 8;
        }
        xSprite.DrawFrame(0, (GameImpl.SCR_W >> 1) - 30, (GameImpl.SCR_H >> 1) - 50, 0);
        xSprite2.DrawFrame(n2, GameImpl.SCR_W >> 1, (GameImpl.SCR_H >> 1) - 50 + 30, 0);
        if (GameImpl._maxAlliedMission < 0) {
            xSprite4.DrawFrame(13, (GameImpl.SCR_W >> 1) + 30, (GameImpl.SCR_H >> 1) - 50 + 60, 0);
        }
        if (_menuIndex != 2) {
            xSprite.SetCurrentPalette(5);
            n2 = 32;
        } else {
            xSprite.SetCurrentPalette(4);
            n2 = 31;
        }
        xSprite.DrawFrame(0, (GameImpl.SCR_W >> 1) + 30 + 10, (GameImpl.SCR_H >> 1) - 50, 0);
        xSprite2.DrawFrame(n2, (GameImpl.SCR_W >> 1) + 60 + 10, (GameImpl.SCR_H >> 1) - 50 + 30, 0);
        xSprite.SetCurrentPalette(0);
        _string = SDKUtils.getString(n, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, (GameImpl.SCR_H >> 1) - 50 - 35, 1);
        Menu.LightArrowKeys();
        xSprite3.DrawFrame(_arrow_keys[2], (GameImpl.SCR_W >> 1) - (SDKUtils.getStringSize(_string) >> 1) - 5, (GameImpl.SCR_H >> 1) - 50 - 35 + 14, 0);
        xSprite3.DrawFrame(_arrow_keys[3], (GameImpl.SCR_W >> 1) + (SDKUtils.getStringSize(_string) >> 1) + 5, (GameImpl.SCR_H >> 1) - 50 - 35 + 14, 0);
        _string = SDKUtils.getString(331, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, 6, 1);
    }

    public static void UpdateChooseLevel() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            Level._b_skirmish = false;
            Level._b_tower_defense = false;
            if (_selectedFaction == 0) {
                switch (CHOOSE_SOVIET_MENU_ITEMS[_menuIndex]) {
                    case 346: {
                        Level._crt_level = 0;
                        Encyclopedia._msk_alpha_omega = 0;
                        Encyclopedia._alpha_omega = true;
                        Encyclopedia._msk_doctor = 0;
                        Encyclopedia._doctor = true;
                        Encyclopedia._msk_stealth = 0;
                        Encyclopedia._stealth = true;
                        GameImpl.saveRMS();
                        break;
                    }
                    case 347: {
                        Level._crt_level = 1;
                        break;
                    }
                    case 348: {
                        Level._crt_level = 2;
                        break;
                    }
                    case 349: {
                        Level._crt_level = 3;
                        break;
                    }
                    case 350: {
                        Level._crt_level = 4;
                        break;
                    }
                    case 351: {
                        Level._crt_level = 5;
                        break;
                    }
                    case 352: {
                        Level._crt_level = 6;
                        break;
                    }
                    case 353: {
                        Level._crt_level = 7;
                    }
                }
            } else if (_selectedFaction == 1) {
                switch (CHOOSE_ALLIED_MENU_ITEMS[_menuIndex]) {
                    case 354: {
                        Level._crt_level = 8;
                        break;
                    }
                    case 355: {
                        Level._crt_level = 9;
                        break;
                    }
                    case 356: {
                        Level._crt_level = 10;
                        break;
                    }
                    case 357: {
                        Level._crt_level = 11;
                        break;
                    }
                    case 358: {
                        Level._crt_level = 12;
                        break;
                    }
                    case 359: {
                        Level._crt_level = 13;
                        break;
                    }
                    case 360: {
                        Level._crt_level = 14;
                    }
                }
            }
            int n = Level.GetLevelStats(Level._crt_level, 16);
            if (n != -1) {
                SDKUtils.loadStringsChunk(n);
            }
            MsgBox.Start(Level.GetLevelStats(Level._crt_level, 10), false);
            Menu.ShowMenu(8);
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            Menu.ShowMenu(15);
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (--_menuIndex < 0) {
                if (_selectedFaction == 0) {
                    _menuIndex = GameImpl._maxSovietMission;
                } else if (_selectedFaction == 1) {
                    _menuIndex = GameImpl._maxAlliedMission - 7 - 1;
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            if (_selectedFaction == 0) {
                _menuIndex = (_menuIndex + 1) % (GameImpl._maxSovietMission + 1);
            } else if (_selectedFaction == 1) {
                _menuIndex = (_menuIndex + 1) % (GameImpl._maxAlliedMission - 7);
            }
        }
    }

    public static void DrawChooseLevel(SDKGraphics sDKGraphics) {
        int n = 369;
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        XSprite xSprite = Sprites._sprites[42];
        XSprite xSprite2 = Sprites._sprites[40];
        XSprite xSprite3 = Sprites._sprites[43];
        Menu.DrawSplash(false);
        Utils.FillRect(sDKGraphics, -1526726656, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        if (_selectedFaction == 0) {
            n2 = 0;
            n = 369;
            n3 = 1;
            n4 = 2;
            xSprite3.SetCurrentPalette(0);
        } else if (_selectedFaction == 1) {
            n2 = 4;
            n = 370;
            n3 = 8;
            n4 = 7;
            xSprite3.SetCurrentPalette(2);
        }
        _string = SDKUtils.getString(n, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawString(_string, GameImpl.SCR_W - 40, GameImpl.BIG_TOP_MARGIN - 0, 8);
        xSprite2.SetCurrentPalette(0);
        int[] nArray = xSprite2.RectFrame(n2, 0, 0, 0);
        xSprite2.DrawFrame(n2, 15, GameImpl.SCR_H - 30 - nArray[3], 0);
        Menu.DrawLine(90, 21, 0, GameImpl.SCR_H - 30, n4);
        nArray = xSprite3.RectFrame(0, 0, 0, 0);
        xSprite3.DrawFrame(0, GameImpl.SCR_W - 40 - nArray[2], GameImpl.BIG_TOP_MARGIN - 15 - nArray[3], 0);
        xSprite.DrawFrame(n3, GameImpl.SCR_W - 40 - (nArray[2] >> 1), GameImpl.BIG_TOP_MARGIN - 15 - (nArray[3] >> 1), 0);
        Menu.DrawLine(80 + nArray[2], 21, GameImpl.SCR_W - 80 - nArray[2], GameImpl.BIG_TOP_MARGIN - 5, n4);
        if (_selectedFaction == 0) {
            Menu.DrawMenu(sDKGraphics, false, false, (byte)24, (short)40, GameImpl.BIG_TOP_MARGIN + 20, 11, true, -1, -1, 1, 6, 4, GameImpl._maxSovietMission + 1);
        } else if (_selectedFaction == 1) {
            Menu.DrawMenu(sDKGraphics, false, false, (byte)24, (short)40, GameImpl.BIG_TOP_MARGIN + 20, 12, true, -1, -1, 2, 6, 4, GameImpl._maxAlliedMission - 7);
        }
        Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
    }

    public static void DrawStatsScreen(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        int n3;
        XSprite xSprite = Sprites._sprites[42];
        XSprite xSprite2 = Sprites._sprites[43];
        XSprite xSprite3 = Sprites._sprites[11];
        int n4 = 0;
        int n5 = 0;
        int n6 = 5;
        SDKUtils.setFont(GameImpl.fonts[4]);
        int n7 = SDKUtils.getLineSize();
        n6 += n7;
        int[] nArray = xSprite2.RectFrame(0, 0, 0, 0);
        n6 += nArray[3];
        if (_incBar < 60) {
            ++_incBar;
        }
        sDKGraphics.setClip(0, 76, GameImpl.SCR_W, GameImpl.SCR_H - 15 - 70 - 6);
        for (n3 = 0; n3 < 5; ++n3) {
            n2 = 0;
            n = 0;
            if (Level._player_faction == 1) {
                n2 = n3 << 1;
                n = (n3 << 1) + 1;
            } else {
                n2 = (n3 << 1) + 1;
                n = n3 << 1;
            }
            _string = SDKUtils.getString(STATS_MENU_ITEMS[n3], _string);
            SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, n6 - _headStats, 17);
            n6 += n7;
            int n8 = 0;
            if (Level._statistics[n2] > Level._statistics[n]) {
                n8 = Level._statistics[n2];
                ++n5;
            } else {
                n8 = Level._statistics[n];
                if (Level._statistics[n2] < Level._statistics[n]) {
                    ++n4;
                }
            }
            if (n8 == 0) {
                n8 = 1;
            }
            int n9 = n6 + 3 - _headStats;
            sDKGraphics.setColor(0xFF0000);
            sDKGraphics.drawRect(GameImpl.STATISTICS_BAR_X, n9, 60, 7);
            int n10 = Level._statistics[n] * 60 / n8;
            if (_incBar < Level._statistics[n] * 60 / n8) {
                n10 = _incBar;
            }
            sDKGraphics.fillRect(GameImpl.STATISTICS_BAR_X, n9, n10, 7);
            if (Level._statistics[n2] < Level._statistics[n]) {
                if (Level._player_faction == 0) {
                    xSprite3.DrawFrame(76, GameImpl.STATISTICS_BAR_X - 10, n9 + 4, 0);
                } else {
                    xSprite3.DrawFrame(76, GameImpl.STATISTICS_NUMBERS_X + 25, n9 + 4, 0);
                }
            }
            Utils.DrawNumber(Level._statistics[n], GameImpl.STATISTICS_NUMBERS_X, n6 - _headStats, 0);
            n9 = (n6 += n7) + 3 - _headStats;
            sDKGraphics.setColor(255);
            sDKGraphics.drawRect(GameImpl.STATISTICS_BAR_X, n9, 60, 7);
            n10 = Level._statistics[n2] * 60 / n8;
            if (_incBar < Level._statistics[n2] * 60 / n8) {
                n10 = _incBar;
            }
            sDKGraphics.fillRect(GameImpl.STATISTICS_BAR_X, n9, n10, 7);
            if (Level._statistics[n2] > Level._statistics[n]) {
                if (Level._player_faction == 0) {
                    xSprite3.DrawFrame(76, GameImpl.STATISTICS_NUMBERS_X + 25, n9 + 4, 0);
                } else {
                    xSprite3.DrawFrame(76, GameImpl.STATISTICS_BAR_X - 10, n9 + 4, 0);
                }
            }
            Utils.DrawNumber(Level._statistics[n2], GameImpl.STATISTICS_NUMBERS_X, n6 - _headStats, 0);
            n6 += n7;
        }
        sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        _totDrawH = n6;
        n2 = 6;
        Menu.DrawLine(GameImpl.SCR_W, 21, 0, 70, 2);
        if (Level._player_faction == 0) {
            xSprite2.SetCurrentPalette(0);
        } else {
            xSprite2.SetCurrentPalette(2);
        }
        xSprite2.DrawFrame(0, 10 - n2, 5, 0);
        if (Level._player_faction == 0) {
            xSprite.DrawFrame(1, 10 + (nArray[2] >> 1) - n2, 5 + (nArray[3] >> 1), 0);
        } else {
            xSprite.DrawFrame(8, 10 + (nArray[2] >> 1) - n2, 5 + (nArray[3] >> 1), 0);
        }
        if (Level._ai_faction == 0) {
            xSprite2.SetCurrentPalette(0);
        } else {
            xSprite2.SetCurrentPalette(2);
        }
        xSprite2.DrawFrame(0, GameImpl.SCR_W - 10 - nArray[2] + n2, 5, 0);
        if (Level._ai_faction == 1) {
            xSprite.DrawFrame(8, GameImpl.SCR_W - 10 - (nArray[2] >> 1) + n2, 5 + (nArray[3] >> 1), 0);
        } else {
            xSprite.DrawFrame(1, GameImpl.SCR_W - 10 - (nArray[2] >> 1) + n2, 5 + (nArray[3] >> 1), 0);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (Level._player_faction == 0 || Level._player_faction == Level._ai_faction && Level._ai_faction == 0) {
                xSprite3.DrawFrame(76, (n3 + 1) * 12 + 10, nArray[3], 0);
                continue;
            }
            xSprite3.DrawFrame(76, GameImpl.SCR_W - ((n3 + 1) * 12 + 10), nArray[3], 0);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (Level._ai_faction == 1 && Level._player_faction == 0 || Level._player_faction == Level._ai_faction && Level._player_faction == 0) {
                xSprite3.DrawFrame(76, GameImpl.SCR_W - ((n3 + 1) * 12 + 10), nArray[3], 0);
                continue;
            }
            xSprite3.DrawFrame(76, (n3 + 1) * 12 + 10, nArray[3], 0);
        }
        n = 14;
        if (_totDrawH - _headStats + 15 > GameImpl.SCR_H) {
            n = SDKCanvas.isKeyPressed(32770) ? 93 : 14;
            xSprite3.DrawFrame(n, GameImpl.SCR_W >> 1, GameImpl.SCR_H - 12, 0);
        }
        if (_headStats > 0) {
            n = SDKCanvas.isKeyPressed(513) ? 92 : 13;
            xSprite3.DrawFrame(n, GameImpl.SCR_W >> 1, 70, 0);
        }
    }

    public static void UpdateBonusMenu() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            switch (BONUS_MENU_ITEMS[_menuIndex]) {
                case 385: {
                    if ((_msk_bonus_menu & 1) == 0) break;
                    Encyclopedia._achmode = true;
                    Encyclopedia.Init();
                    GameImpl.SetState(9);
                    Encyclopedia._ency_state = (short)2;
                    break;
                }
                case 386: {
                    if ((_msk_bonus_menu & 2) == 0) break;
                    Encyclopedia._achmode = false;
                    Encyclopedia.Init();
                    GameImpl.SetState(9);
                    Encyclopedia._ency_state = 0;
                    break;
                }
                case 387: {
                    Menu.Kill();
                    Menu.ShowMenu(16);
                    break;
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            Menu.ShowMenu(0);
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (--_menuIndex < 0) {
                _menuIndex = _numBonusMenuItems - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            _menuIndex = (_menuIndex + 1) % _numBonusMenuItems;
        }
    }

    public static void DrawBonusMenu(SDKGraphics sDKGraphics) {
        Menu.DrawSplash(true);
        Menu.DrawSplashKirov(true);
        SDKUtils.setFont(GameImpl.fonts[4]);
        XSprite xSprite = Sprites._sprites[45];
        int n = (GameImpl.SCR_H >> 1) + SDKUtils.getLineSize();
        int n2 = SDKUtils.getLineSize();
        for (int i = 0; i < MENUS[2].length; ++i) {
            int n3 = GameImpl.SCR_W - 40 + 8;
            if (i == _menuIndex) {
                if (i != MENUS[2].length - 1) {
                    SDKUtils.setFont(GameImpl.fonts[1]);
                }
                if ((_msk_bonus_menu & 1 << i) != 0) {
                    xSprite.DrawFrame(15, n3, n + (SDKUtils.getLineSize() >> 1), 0);
                }
            } else {
                SDKUtils.setFont(GameImpl.fonts[4]);
            }
            xSprite.DrawFrame(14, n3, n + (SDKUtils.getLineSize() >> 1), 0);
            n2 = SDKUtils.getLineSize();
            n += n2;
        }
        Menu.DrawMenu(sDKGraphics, false, false, (byte)24, (short)40, (GameImpl.SCR_H >> 1) + SDKUtils.getLineSize(), 2, true, -1, _msk_bonus_menu, 1, 4, 4, 16);
        if ((_msk_bonus_menu & 1 << _menuIndex) != 0) {
            Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
        }
        Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
        Menu.DrawLine((GameImpl.SCR_W >> 1) - 40, 21, GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 1, 2);
        Menu.DrawLine((GameImpl.SCR_W >> 1) - 40, 21, GameImpl.SCR_W >> 1, (GameImpl.SCR_H >> 1) + SDKUtils.getLineSize() * (MENUS[2].length + 2), 2);
        _string = SDKUtils.getString(339, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 2, 1);
    }

    private static void ResetAllSavedData() {
        GameImpl._maxSovietMission = 0;
        GameImpl._maxAlliedMission = -1;
        GameImpl._maxSkirmishMission = 15;
        GameImpl._nextMission = -1;
        GameImpl._unlockables = 0;
        _msk_bonus_menu = 0;
        Encyclopedia._msk_alpha_omega = 0;
        Encyclopedia._msk_stealth = 0;
        Encyclopedia._msk_doctor = 0;
        Encyclopedia._sniper = 0;
        Encyclopedia._shmlf_units = 0;
        Encyclopedia._shmlf_bld = 0;
        Encyclopedia._bomb = 0;
        Encyclopedia._beam_me_up = 0;
        Encyclopedia._alpha_omega = true;
        Encyclopedia._ride_lightning = 0;
        Encyclopedia._flesh_wound = false;
        Encyclopedia._big_brain = 0;
        Encyclopedia._road_kill = 0;
        Encyclopedia._superman = true;
        Encyclopedia._stealth = true;
        Encyclopedia._doctor = true;
        GameImpl.saveRMS();
    }

    public static void UpdateOptionsMenu() {
        block30: {
            block29: {
                if (!SDKCanvas.isNewKeyPressed(4144)) break block29;
                switch (OPTIONS_MENU_ITEMS[_menuIndex]) {
                    case 377: {
                        boolean bl = GameImpl._soundEnable = !GameImpl._soundEnable;
                        if (GameImpl._soundEnable) {
                            GameImpl._soundManager.setSoundEnabled(GameImpl._soundEnable);
                            if (GameImpl._gameState == 6) {
                                if (GameImpl._attackSoundPlayed) {
                                    GameImpl._soundManager.setCurrentLoop(-1);
                                    GameImpl._soundManager.playSound(30);
                                } else {
                                    GameImpl._soundManager.setCurrentLoop(-1);
                                    GameImpl._soundManager.playSound(29);
                                }
                            } else {
                                GameImpl._soundManager.setCurrentLoop(-1);
                                GameImpl._soundManager.playSound(28);
                            }
                        } else {
                            GameImpl._soundManager.stopSounds();
                        }
                        SDKCanvas.disableInput(3);
                        break;
                    }
                    case 375: {
                        GameImpl._vibrationsEnable = !GameImpl._vibrationsEnable;
                        GameImpl.saveRMS();
                        if (GameImpl._vibrationsEnable) {
                            GameImpl._soundManager.vibrate(100);
                        }
                        SDKCanvas.disableInput(3);
                        break;
                    }
                    case 332: {
                        Menu.Kill();
                        Menu.ShowMenu(1);
                        break;
                    }
                    case 379: {
                        GameImpl._tutorialEnable = !GameImpl._tutorialEnable;
                        GameImpl.saveRMS();
                        Cursor._disableSelection = false;
                        block11: for (int i = 0; i < 8; ++i) {
                            if (Tutorial._tutorials[i][0] != 1) continue;
                            Tutorial._tutorials[i][0] = 0;
                            Tutorial._tutorials[i][2] = 0;
                            int n = Tutorial._tutorials[i][1];
                            switch (n) {
                                case 1: 
                                case 2: {
                                    if (Tutorial._tutorials[i][7] == -1) continue block11;
                                    Entity entity = Level.GetEntitySafe(Tutorial._tutorials[i][7]);
                                    Level.DeleteEntity(entity);
                                }
                            }
                        }
                        break block30;
                    }
                    case 381: {
                        GameImpl._setDrawLines = !GameImpl._setDrawLines;
                        GameImpl.saveRMS();
                        break;
                    }
                    case 383: {
                        if (GameImpl._gameState == 6) break;
                        Menu.Kill();
                        Menu.ShowMenu(20);
                    }
                }
                break block30;
            }
            if (SDKCanvas.isNewKeyPressed(524352)) {
                Menu.Kill();
                if (GameImpl._gameState == 6) {
                    Menu.ShowMenu(3);
                } else {
                    Menu.ShowMenu(0);
                }
            } else if (SDKCanvas.isNewKeyPressed(513)) {
                if (--_menuIndex < 0) {
                    _menuIndex = _numOptionsMenuItems - 1;
                }
                if (GameImpl._gameState == 6 && (OPTIONS_MENU_ITEMS[_menuIndex] == 332 || OPTIONS_MENU_ITEMS[_menuIndex] == 383) && --_menuIndex < 0) {
                    _menuIndex = _numOptionsMenuItems - 1;
                }
            } else if (SDKCanvas.isNewKeyPressed(32770)) {
                _menuIndex = (_menuIndex + 1) % _numOptionsMenuItems;
                if (GameImpl._gameState == 6 && (OPTIONS_MENU_ITEMS[_menuIndex] == 332 || OPTIONS_MENU_ITEMS[_menuIndex] == 383)) {
                    _menuIndex = (_menuIndex + 1) % _numOptionsMenuItems;
                }
            }
        }
    }

    public static void DrawOptionsMenu(SDKGraphics sDKGraphics) {
        int n;
        int n2 = GameImpl.SCR_H >> 1;
        int n3 = GameImpl.SCR_W - 20;
        int n4 = 24;
        int n5 = 1;
        if (GameImpl._gameState != 6) {
            Menu.DrawSplash(true);
            Menu.DrawSplashKirov(true);
        } else {
            Menu.darkenRegion(sDKGraphics, Integer.MIN_VALUE, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
            n = OPTIONS_MENU_ITEMS.length - 2;
            int n6 = 7 + n * (SDKUtils.getLineSize() + 7);
            if (GameImpl._language > 0) {
                n6 += SDKUtils.getLineSize();
            }
            n3 = GameImpl.SCR_W - _igMenu_width >> 1;
            n2 = GameImpl.SCR_H - n6 >> 1;
            n4 = 1;
            sDKGraphics.setColor(0x200000);
            sDKGraphics.fillRect(n3, n2, _igMenu_width, n6);
            sDKGraphics.setColor(0xA00000);
            sDKGraphics.drawRect(n3, n2, _igMenu_width, n6);
            n3 = GameImpl.SCR_W >> 1;
            n2 += 7;
        }
        if (_menuIndex == 0) {
            SDKUtils.setFont(GameImpl.fonts[n5]);
        } else {
            SDKUtils.setFont(GameImpl.fonts[4]);
        }
        if (GameImpl._soundEnable) {
            SDKUtils.getString(OPTIONS_MENU_ITEMS[0], _string);
        } else {
            SDKUtils.getString(OPTIONS_MENU_ITEMS[0] + 1, _string);
        }
        SDKUtils.drawString(_string, n3, n2, n4);
        n2 = GameImpl._gameState == 6 ? (n2 += 7 + SDKUtils.getLineSize()) : (n2 += SDKUtils.getLineSize());
        if (_menuIndex == 1) {
            SDKUtils.setFont(GameImpl.fonts[n5]);
        } else {
            SDKUtils.setFont(GameImpl.fonts[4]);
        }
        if (GameImpl._vibrationsEnable) {
            SDKUtils.getString(OPTIONS_MENU_ITEMS[1], _string);
        } else {
            SDKUtils.getString(OPTIONS_MENU_ITEMS[1] + 1, _string);
        }
        SDKUtils.drawString(_string, n3, n2, n4);
        n2 = GameImpl._gameState == 6 ? (n2 += 7 + SDKUtils.getLineSize()) : (n2 += SDKUtils.getLineSize());
        if (GameImpl._gameState != 6) {
            if (_menuIndex == 2) {
                SDKUtils.setFont(GameImpl.fonts[n5]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[4]);
            }
            SDKUtils.getString(OPTIONS_MENU_ITEMS[2], _string);
            SDKUtils.drawString(_string, n3, n2, n4);
            n2 = GameImpl._gameState == 6 ? (n2 += 7 + SDKUtils.getLineSize()) : (n2 += SDKUtils.getLineSize());
        }
        if (_menuIndex == 3) {
            SDKUtils.setFont(GameImpl.fonts[n5]);
        } else {
            SDKUtils.setFont(GameImpl.fonts[4]);
        }
        if (GameImpl._setDrawLines) {
            SDKUtils.getString(OPTIONS_MENU_ITEMS[3], _string);
        } else {
            SDKUtils.getString(OPTIONS_MENU_ITEMS[3] + 1, _string);
        }
        n = n3;
        if (GameImpl._gameState == 6) {
            n = GameImpl.SCR_W;
        }
        if ((_detailStringLines = SDKUtils.wrapString(_string, _detailStringLines, n, (short)124))[0] > 1) {
            SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], n3, n2, n4);
        } else {
            SDKUtils.drawString(_string, n3, n2, n4);
        }
        n2 = GameImpl._gameState == 6 ? (n2 += (7 + SDKUtils.getLineSize()) * _detailStringLines[0]) : (n2 += SDKUtils.getLineSize() * _detailStringLines[0]);
        if (GameImpl._gameState != 6) {
            if (_menuIndex == 4) {
                SDKUtils.setFont(GameImpl.fonts[n5]);
            } else {
                SDKUtils.setFont(GameImpl.fonts[4]);
            }
            SDKUtils.getString(OPTIONS_MENU_ITEMS[4], _string);
            SDKUtils.drawString(_string, n3, n2, n4);
        }
        if (GameImpl._gameState != 6) {
            Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
            Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
        } else {
            if (_menuIndex != 4) {
                Hud.DrawSoftKeys(SDKUtils.getString(6, GameImpl._string), true, 4, true, true, 0);
            }
            Hud.DrawSoftKeys(SDKUtils.getString(4, GameImpl._string), false, 4, true, true, 0);
        }
        if (GameImpl._gameState != 6) {
            _string = SDKUtils.getString(336, _string);
            SDKUtils.setFont(GameImpl.fonts[7]);
            SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 2, 1);
        } else {
            _string = SDKUtils.getString(336, _string);
            SDKUtils.setFont(GameImpl.fonts[7]);
            SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 3, 1);
        }
    }

    public static void UpdateHelpMenu() {
        if (SDKCanvas.isKeyPressed(32770)) {
            if (_totDrawH - _headHelp > GameImpl.SCR_H - 35 - 20) {
                _headHelp += 10;
            }
        } else if (SDKCanvas.isKeyPressed(513)) {
            if (_headHelp > 0) {
                _headHelp -= 10;
            }
        } else if (SDKCanvas.isKeyPressed(524352)) {
            Menu.Kill();
            if (GameImpl._gameState == 6) {
                Menu.ShowMenu(3);
            } else {
                Menu.ShowMenu(0);
            }
        }
    }

    public static void DrawHelpMenu(SDKGraphics sDKGraphics, int n, int n2, boolean bl) {
        SDKString sDKString = new SDKString();
        XSprite xSprite = Sprites._sprites[11];
        short[] sArray = new short[128];
        int n3 = 40;
        int n4 = GameImpl.SCR_H > GameImpl.SCR_W ? 200 : 280;
        if (GameImpl._gameState == 6) {
            Utils.FillRect(sDKGraphics, Integer.MIN_VALUE, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
            sDKGraphics.setColor(0x200000);
            sDKGraphics.fillRect(0, 35, GameImpl.SCR_W, GameImpl.SCR_H - 35 - 18);
        }
        SDKUtils.setFont(GameImpl.fonts[4]);
        sDKString = SDKUtils.getString(n, sDKString);
        if (bl) {
            String string = null;
            try {
                string = SDKMIDlet.getAppProp("MIDlet-Version").trim();
            }
            catch (Exception exception) {
                string = "";
            }
            sDKString = sDKString.replaceFirst(string);
        }
        SDKUtils.wrapString(sDKString, sArray, n4, (short)124);
        short s = sArray[0];
        sDKGraphics.setClip(0, 35, GameImpl.SCR_W, GameImpl.SCR_H - 35 - 18);
        SDKUtils.drawWrappedString(sDKString, sArray, 1, s, 20, n3 - _headHelp, 20);
        sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        _totDrawH = s * SDKUtils.getLineSize();
        _string = SDKUtils.getString(n2, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawString(_string, GameImpl.SCR_W >> 1, 8, 17);
        if (GameImpl._gameState != 6) {
            Menu.DrawLine(GameImpl.SCR_W, 21, 0, 35, 2);
            Menu.DrawLine(GameImpl.SCR_W, 21, 0, GameImpl.SCR_H - 18, 2);
        } else {
            sDKGraphics.setColor(0xA00000);
            sDKGraphics.drawLine(0, 35, GameImpl.SCR_W, 35);
            sDKGraphics.drawLine(0, GameImpl.SCR_H - 18, GameImpl.SCR_W, GameImpl.SCR_H - 18);
        }
        int n5 = 14;
        if (_totDrawH - _headHelp > GameImpl.SCR_H - 20 - 18) {
            n5 = SDKCanvas.isKeyPressed(32770) ? 93 : 14;
            int n6 = (GameImpl.SCR_W >> 1) - (SDKUtils.getStringSize(_string) >> 1) - 20;
            _string = SDKUtils.getString(4, _string);
            xSprite.DrawFrame(n5, n6, GameImpl.SCR_H - 18 + 4, 0);
        }
        if (_headHelp > 0) {
            n5 = SDKCanvas.isKeyPressed(513) ? 92 : 13;
            _string = SDKUtils.getString(n2, _string);
            int n7 = (GameImpl.SCR_W >> 1) - (SDKUtils.getStringSize(_string) >> 1) - 20;
            xSprite.DrawFrame(n5, n7, 31, 0);
        }
        if (GameImpl._gameState != 6) {
            Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
        } else {
            Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, true, true, 0);
        }
    }

    public static void UpdateSkirmish() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            switch (_skirmishState) {
                case 0: {
                    Level._crt_level = _menuIndex + 15;
                    _numSelectedSkirmMenuItems = CHOOSE_SKIRMISH_FACTION_ITEMS.length;
                    ++_skirmishState;
                    _menuIndex = _factionIndex;
                    break;
                }
                case 1: {
                    Level._player_sk_faction = _menuIndex + 0;
                    ++_skirmishState;
                    _menuIndex = _aiIndex;
                    break;
                }
                case 2: {
                    Level._ai_sk_faction = _menuIndex + 0;
                    Level._b_skirmish = true;
                    Level._b_tower_defense = false;
                    Encyclopedia._superman = true;
                    GameImpl.SetState(8);
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            switch (_skirmishState) {
                case 0: {
                    Menu.Kill();
                    Menu.ShowMenu(15);
                    break;
                }
                case 1: {
                    _menuIndex = _mapIndex;
                    _numSelectedSkirmMenuItems = GameImpl._maxSkirmishMission - 15 + 1;
                    --_skirmishState;
                    break;
                }
                case 2: {
                    _menuIndex = _factionIndex;
                    --_skirmishState;
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (_skirmishState == 0 && --_menuIndex < 0) {
                _menuIndex = _numSelectedSkirmMenuItems - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            if (_skirmishState == 0) {
                _menuIndex = (_menuIndex + 1) % _numSelectedSkirmMenuItems;
            }
        } else if (SDKCanvas.isNewKeyPressed(2052)) {
            if (_skirmishState != 0 && --_menuIndex < 0) {
                _menuIndex = _numSelectedSkirmMenuItems - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(8200) && _skirmishState != 0) {
            _menuIndex = (_menuIndex + 1) % _numSelectedSkirmMenuItems;
        }
        switch (_skirmishState) {
            case 0: {
                _mapIndex = _menuIndex;
                break;
            }
            case 1: {
                _factionIndex = _menuIndex;
                break;
            }
            case 2: {
                _aiIndex = _menuIndex;
            }
        }
    }

    public static void DrawSkirmish(SDKGraphics sDKGraphics) {
        XSprite xSprite = Sprites._sprites[43];
        XSprite xSprite2 = Sprites._sprites[42];
        XSprite xSprite3 = Sprites._sprites[46];
        XSprite xSprite4 = Sprites._sprites[11];
        Menu.ResetArrowKeys();
        xSprite3.DrawFrame(0, 0, 0, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
        xSprite.SetCurrentPalette(4);
        xSprite.DrawFrame(0, 2, 2, 0);
        xSprite2.DrawFrame(31, 32, 32, 0);
        _string = SDKUtils.getString(334, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) + 30, 7, 17);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (_skirmishState) {
            case 0: {
                n = (GameImpl.SCR_W >> 1) - 0;
                n2 = (GameImpl.SCR_H >> 1) - 80;
                n3 = (GameImpl.SCR_W >> 1) + 0;
                n4 = 80;
                break;
            }
            case 1: {
                n = 0;
                n2 = GameImpl.SCR_H >> 1;
                n3 = GameImpl.SCR_W >> 1;
                n4 = 77;
                break;
            }
            case 2: {
                n = GameImpl.SCR_W >> 1;
                n2 = GameImpl.SCR_H >> 1;
                n3 = GameImpl.SCR_W >> 1;
                n4 = 77;
            }
        }
        Utils.FillRect(sDKGraphics, Integer.MIN_VALUE, n, n2, n3, n4);
        Menu.DrawLine((GameImpl.SCR_W >> 1) + 40, 21, (GameImpl.SCR_W >> 1) - 40, (GameImpl.SCR_H >> 1) - 80, 2);
        Menu.DrawLine(GameImpl.SCR_W, 21, 0, GameImpl.SCR_H >> 1, 2);
        Menu.DrawLine(GameImpl.SCR_W, 21, 0, (GameImpl.SCR_H >> 1) + 80 - 4, 2);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(374, _string);
        int n5 = (GameImpl.SCR_W >> 1) - 0;
        _detailStringLines = SDKUtils.wrapString(_string, _detailStringLines, n5, (short)124);
        if (_detailStringLines[0] > 1) {
            SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], (GameImpl.SCR_W >> 1) - 0 - ((GameImpl.SCR_W >> 1) - 0 >> 1), (GameImpl.SCR_H >> 1) - 50 + 10, 1);
        } else {
            SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - 0 - ((GameImpl.SCR_W >> 1) - 0 >> 1), (GameImpl.SCR_H >> 1) - 50 + 10, 1);
        }
        if (_skirmishState == 0) {
            Menu.LightArrowKeys();
        } else {
            Menu.ResetArrowKeys();
        }
        xSprite4.DrawFrame(_arrow_keys[0], (GameImpl.SCR_W >> 1) + 75 - 0, (GameImpl.SCR_H >> 1) - 50, 0);
        xSprite4.DrawFrame(_arrow_keys[1], (GameImpl.SCR_W >> 1) + 75 - 0, (GameImpl.SCR_H >> 1) - 15, 0);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(CHOOSE_SKIRMISH_LEVEL_MENU_ITEMS[_mapIndex], _string);
        n5 = (GameImpl.SCR_W >> 1) + 0;
        _detailStringLines = SDKUtils.wrapString(_string, _detailStringLines, n5, (short)124);
        if (_detailStringLines[0] > 1) {
            SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], (GameImpl.SCR_W >> 1) - 0 + ((GameImpl.SCR_W >> 1) + 0 >> 1), (GameImpl.SCR_H >> 1) - 50 + 10 - (SDKUtils.getLineSize() >> 1), 1);
        } else {
            SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - 0 + ((GameImpl.SCR_W >> 1) + 0 >> 1), (GameImpl.SCR_H >> 1) - 50 + 10, 1);
        }
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(372, _string);
        n5 = GameImpl.SCR_W >> 1;
        _detailStringLines = SDKUtils.wrapString(_string, _detailStringLines, n5, (short)124);
        if (_detailStringLines[0] > 1) {
            SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], (GameImpl.SCR_W >> 1) - (GameImpl.SCR_W >> 2), (GameImpl.SCR_H >> 1) + 0, 1);
        } else {
            SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - (GameImpl.SCR_W >> 2), (GameImpl.SCR_H >> 1) + 0 + (SDKUtils.getLineSize() >> 1), 1);
        }
        xSprite2.DrawFrame(EMBLEMS[_factionIndex], (GameImpl.SCR_W >> 1) - 0 - 75, (GameImpl.SCR_H >> 1) + 50 - 10, 0);
        if (_skirmishState == 1) {
            Menu.LightArrowKeys();
        } else {
            Menu.ResetArrowKeys();
        }
        xSprite4.DrawFrame(_arrow_keys[2], (GameImpl.SCR_W >> 1) - 0 - 75 - 30, (GameImpl.SCR_H >> 1) + 50 - 0, 0);
        xSprite4.DrawFrame(_arrow_keys[3], (GameImpl.SCR_W >> 1) - 0 - 75 + 30, (GameImpl.SCR_H >> 1) + 50 - 0, 0);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(CHOOSE_SKIRMISH_FACTION_ITEMS[_factionIndex], _string);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - 0 - 75, (GameImpl.SCR_H >> 1) + 75, 33);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(373, _string);
        n5 = GameImpl.SCR_W >> 1;
        _detailStringLines = SDKUtils.wrapString(_string, _detailStringLines, n5, (short)124);
        if (_detailStringLines[0] > 1) {
            SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], (GameImpl.SCR_W >> 1) + (GameImpl.SCR_W >> 2), (GameImpl.SCR_H >> 1) + 0, 1);
        } else {
            SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) + (GameImpl.SCR_W >> 2), (GameImpl.SCR_H >> 1) + 0 + (SDKUtils.getLineSize() >> 1), 1);
        }
        xSprite2.DrawFrame(EMBLEMS[_aiIndex], (GameImpl.SCR_W >> 1) + 0 + 75, (GameImpl.SCR_H >> 1) + 50 - 10, 0);
        if (_skirmishState == 2) {
            Menu.LightArrowKeys();
        } else {
            Menu.ResetArrowKeys();
        }
        xSprite4.DrawFrame(_arrow_keys[2], (GameImpl.SCR_W >> 1) + 0 + 75 - 30, (GameImpl.SCR_H >> 1) + 50 - 0, 0);
        xSprite4.DrawFrame(_arrow_keys[3], (GameImpl.SCR_W >> 1) + 0 + 75 + 30, (GameImpl.SCR_H >> 1) + 50 - 0, 0);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(CHOOSE_SKIRMISH_FACTION_ITEMS[_aiIndex], _string);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) + 0 + 75, (GameImpl.SCR_H >> 1) + 75, 33);
    }

    public static void LightArrowKeys() {
        Menu._arrow_keys[0] = 13;
        Menu._arrow_keys[1] = 14;
        Menu._arrow_keys[2] = 15;
        Menu._arrow_keys[3] = 16;
        if (SDKCanvas.isKeyPressed(513)) {
            Menu._arrow_keys[0] = 92;
        }
        if (SDKCanvas.isKeyPressed(32770)) {
            Menu._arrow_keys[1] = 93;
        }
        if (SDKCanvas.isKeyPressed(2052)) {
            Menu._arrow_keys[2] = 94;
        }
        if (SDKCanvas.isKeyPressed(8200)) {
            Menu._arrow_keys[3] = 95;
        }
    }

    public static void ResetArrowKeys() {
        Menu._arrow_keys[0] = 13;
        Menu._arrow_keys[1] = 14;
        Menu._arrow_keys[2] = 15;
        Menu._arrow_keys[3] = 16;
    }

    public static void UpdateTDMenu() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            switch (_skirmishState) {
                case 0: {
                    Level._crt_level = 20;
                    if (_menuIndex == 0) {
                        Level._crt_level = 20;
                    }
                    if (_menuIndex == 1) {
                        Level._crt_level = 19;
                    }
                    _numSelectedSkirmMenuItems = CHOOSE_SKIRMISH_FACTION_ITEMS.length;
                    ++_skirmishState;
                    _menuIndex = _factionIndex;
                    break;
                }
                case 1: {
                    Level._player_sk_faction = _menuIndex + 0;
                    Level._ai_sk_faction = Level._player_sk_faction == 0 ? 1 : 0;
                    Level._b_skirmish = true;
                    Level._b_tower_defense = true;
                    int n = Level.GetLevelStats(Level._crt_level, 16);
                    if (n != -1) {
                        SDKUtils.loadStringsChunk(n);
                    }
                    Script.Scripts_Release();
                    Script.Scripts_Init(Level._crt_level);
                    Script.LoadScripts(Level._crt_level);
                    GameImpl.SetState(8);
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            switch (_skirmishState) {
                case 0: {
                    Menu.Kill();
                    Menu.ShowMenu(11);
                    break;
                }
                case 1: {
                    _menuIndex = _mapIndex;
                    _numSelectedSkirmMenuItems = CHOOSE_TOWER_DEF_MENU_ITEMS.length;
                    --_skirmishState;
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (_skirmishState == 0 && --_menuIndex < 0) {
                _menuIndex = _numSelectedSkirmMenuItems - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            if (_skirmishState == 0) {
                _menuIndex = (_menuIndex + 1) % _numSelectedSkirmMenuItems;
            }
        } else if (SDKCanvas.isNewKeyPressed(2052)) {
            if (_skirmishState != 0 && --_menuIndex < 0) {
                _menuIndex = _numSelectedSkirmMenuItems - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(8200) && _skirmishState != 0) {
            _menuIndex = (_menuIndex + 1) % _numSelectedSkirmMenuItems;
        }
        switch (_skirmishState) {
            case 0: {
                _mapIndex = _menuIndex;
                break;
            }
            case 1: {
                _factionIndex = _menuIndex;
            }
        }
    }

    public static void DrawTDMenu(SDKGraphics sDKGraphics) {
        XSprite xSprite = Sprites._sprites[43];
        XSprite xSprite2 = Sprites._sprites[42];
        XSprite xSprite3 = Sprites._sprites[46];
        XSprite xSprite4 = Sprites._sprites[11];
        Menu.ResetArrowKeys();
        xSprite3.DrawFrame(0, 0, 0, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(6, _string), true, 4, false, false, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
        xSprite.SetCurrentPalette(4);
        xSprite.DrawFrame(0, 2, 2, 0);
        xSprite2.DrawFrame(31, 32, 32, 0);
        _string = SDKUtils.getString(387, _string);
        SDKUtils.setFont(GameImpl.fonts[0]);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) + 30, 7, 17);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (_skirmishState) {
            case 0: {
                n = (GameImpl.SCR_W >> 1) - 0;
                n2 = (GameImpl.SCR_H >> 1) - 80;
                n3 = (GameImpl.SCR_W >> 1) + 0;
                n4 = 80;
                break;
            }
            case 1: {
                n = 0;
                n2 = GameImpl.SCR_H >> 1;
                n3 = GameImpl.SCR_W >> 1;
                n4 = 78;
            }
        }
        Utils.FillRect(sDKGraphics, Integer.MIN_VALUE, n, n2, n3, n4);
        Menu.DrawLine((GameImpl.SCR_W >> 1) + 40, 21, (GameImpl.SCR_W >> 1) - 40, (GameImpl.SCR_H >> 1) - 80, 2);
        Menu.DrawLine(GameImpl.SCR_W, 21, 0, GameImpl.SCR_H >> 1, 2);
        Menu.DrawLine(GameImpl.SCR_W, 21, 0, (GameImpl.SCR_H >> 1) + 80 - 4, 2);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(374, _string);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - 15, (GameImpl.SCR_H >> 1) - 50 + 10, 8);
        if (_skirmishState == 0) {
            Menu.LightArrowKeys();
        } else {
            Menu.ResetArrowKeys();
        }
        xSprite4.DrawFrame(_arrow_keys[0], (GameImpl.SCR_W >> 1) + 75, (GameImpl.SCR_H >> 1) - 50 + 10, 0);
        xSprite4.DrawFrame(_arrow_keys[1], (GameImpl.SCR_W >> 1) + 75, (GameImpl.SCR_H >> 1) - 15 - 10, 0);
        SDKUtils.setFont(GameImpl.fonts[0]);
        _string = SDKUtils.getString(CHOOSE_TOWER_DEF_MENU_ITEMS[_mapIndex], _string);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) + 75, (GameImpl.SCR_H >> 1) - 50 + 10, 1);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(372, _string);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - 0 - 75, (GameImpl.SCR_H >> 1) + 0, 1);
        xSprite2.DrawFrame(EMBLEMS[_factionIndex], (GameImpl.SCR_W >> 1) - 0 - 75, (GameImpl.SCR_H >> 1) + 50 - 10, 0);
        if (_skirmishState == 1) {
            Menu.LightArrowKeys();
        } else {
            Menu.ResetArrowKeys();
        }
        xSprite4.DrawFrame(_arrow_keys[2], (GameImpl.SCR_W >> 1) - 0 - 75 - 30, (GameImpl.SCR_H >> 1) + 50 - 0, 0);
        xSprite4.DrawFrame(_arrow_keys[3], (GameImpl.SCR_W >> 1) - 0 - 75 + 30, (GameImpl.SCR_H >> 1) + 50 - 0, 0);
        SDKUtils.setFont(GameImpl.fonts[4]);
        _string = SDKUtils.getString(CHOOSE_SKIRMISH_FACTION_ITEMS[_factionIndex], _string);
        SDKUtils.drawString(_string, (GameImpl.SCR_W >> 1) - 0 - 75, (GameImpl.SCR_H >> 1) + 75, 33);
    }

    public static void UpdateObjectivesMenu() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            if (!_objectivesMenuDetails && _numObjectivesMenuItems > 0) {
                int n = -1;
                int n2 = -1;
                while (n != _menuIndex) {
                    if (!UtilEntity.Objective_IsDisplayable(++n2)) continue;
                    ++n;
                }
                if (UtilEntity.Objectives_GetInfo(n2, 7) == 1) {
                    _objectivesMenuDetails = true;
                    _timer = 0;
                    if (UtilEntity.Objectives_GetInfo(n2, 3) == 0) {
                        Camera.DoScroll(UtilEntity.Objectives_GetInfo(n2, 4) - (GameImpl.SV_W >> 1), UtilEntity.Objectives_GetInfo(n2, 5) - (GameImpl.SV_H >> 1));
                    } else {
                        Entity entity = Level.GetEntityById(-1, UtilEntity.Objectives_GetInfo(n2, 6));
                        if (entity != null) {
                            Camera.DoFollowEntity(entity.GetPointer());
                            UtilEntity.Objective_RefreshEntityPos(n2);
                        } else {
                            Camera.DoScroll(UtilEntity.Objectives_GetInfo(n2, 4) - (GameImpl.SV_W >> 1), UtilEntity.Objectives_GetInfo(n2, 5) - (GameImpl.SV_H >> 1));
                        }
                    }
                    Menu.ResetObjectivesHorizontalScroll();
                    Menu.ResetObjectivesVerticalScroll();
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            if (_objectivesMenuDetails) {
                _objectivesMenuDetails = false;
                _timer = 0;
                Menu.ResetObjectivesHorizontalScroll();
            } else {
                Menu.Kill();
                Menu.ShowMenu(3);
            }
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (!_objectivesMenuDetails && _numObjectivesMenuItems > 1) {
                if (_menuIndex > 0) {
                    --_menuIndex;
                    _timer = 0;
                    Menu.ResetObjectivesHorizontalScroll();
                }
                if (_objectivesStartIndex > _menuIndex) {
                    --_objectivesStartIndex;
                }
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            if (!_objectivesMenuDetails && _numObjectivesMenuItems > 1) {
                if (_menuIndex < _numObjectivesMenuItems - 1) {
                    ++_menuIndex;
                    _timer = 0;
                    Menu.ResetObjectivesHorizontalScroll();
                }
                if (_menuIndex >= _objectivesStartIndex + 5) {
                    ++_objectivesStartIndex;
                }
            }
        } else {
            if (_numObjectivesMenuItems == 0) {
                return;
            }
            if (_timer == 14) {
                int n = -1;
                int n3 = -1;
                while (n != _menuIndex) {
                    if (!UtilEntity.Objective_IsDisplayable(++n3)) continue;
                    ++n;
                }
                if (UtilEntity.Objectives_GetInfo(n3, 3) == 0) {
                    Camera.DoScroll(UtilEntity.Objectives_GetInfo(n3, 4) - (GameImpl.SV_W >> 1), UtilEntity.Objectives_GetInfo(n3, 5) - (GameImpl.SV_H >> 1));
                } else {
                    Entity entity = Level.GetEntityById(-1, UtilEntity.Objectives_GetInfo(n3, 6));
                    if (entity != null) {
                        Camera.DoFollowEntity(entity.GetPointer());
                        UtilEntity.Objective_RefreshEntityPos(n3);
                    } else {
                        Camera.DoScroll(UtilEntity.Objectives_GetInfo(n3, 4) - (GameImpl.SV_W >> 1), UtilEntity.Objectives_GetInfo(n3, 5) - (GameImpl.SV_H >> 1));
                    }
                }
            }
            if (_timer >= 14) {
                if (_horizontalScrollPos < _horizontalScrollMax) {
                    _horizontalScrollPos += 3;
                } else {
                    _timer = -14;
                }
            }
            if (++_timer == 0) {
                Menu.ResetObjectivesHorizontalScroll();
            }
            if (_timer2 >= 28) {
                if (_verticalScrollPos < _verticalScrollMax) {
                    ++_verticalScrollPos;
                } else {
                    _timer2 = -28;
                }
            }
            if (++_timer2 == 0) {
                Menu.ResetObjectivesVerticalScroll();
            }
        }
    }

    private static void ResetObjectivesHorizontalScroll() {
        int n = -1;
        int n2 = -1;
        while (n != _menuIndex) {
            if (!UtilEntity.Objective_IsDisplayable(++n2)) continue;
            ++n;
        }
        _string = SDKUtils.getString(UtilEntity.Objectives_GetInfo(n2, 1), _string);
        int n3 = SDKUtils.getStringSize(_string);
        if (n3 > GameImpl.OBJECTIVES_TEXT_WIDTH) {
            _horizontalScrollPos = 0;
            _horizontalScrollMax = n3 - GameImpl.OBJECTIVES_TEXT_WIDTH / 2;
        }
        _timer = 0;
    }

    private static void ResetObjectivesVerticalScroll() {
        int n = -1;
        int n2 = -1;
        while (n != _menuIndex) {
            if (!UtilEntity.Objective_IsDisplayable(++n2)) continue;
            ++n;
        }
        _string = SDKUtils.getString(UtilEntity.Objectives_GetInfo(n2, 2), _string);
        SDKUtils.wrapString(_string, _detailStringLines, GameImpl.OBJECTIVES_TEXT_WIDTH, (short)124);
        _verticalScrollPos = 0;
        _verticalScrollMax = (_detailStringLines[0] - 4 - 1) * (SDKUtils.getLineSize() + 8);
        _timer2 = 0;
    }

    public static void DrawObjectivesMenu(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        XSprite xSprite = Sprites._sprites[42];
        XSprite xSprite2 = Sprites._sprites[11];
        int n3 = 140;
        int n4 = GameImpl.SCR_W;
        int n5 = 0;
        int n6 = GameImpl.SCR_H - n3;
        for (n2 = n5; n2 < GameImpl.SCR_W; n2 += 18) {
            for (n = n6 + 23; n < GameImpl.SCR_H; n += 44) {
                xSprite2.DrawFrame(83, n2, n, 0);
            }
        }
        xSprite.DrawFrame(33, n5, GameImpl.SCR_H - 18, 0);
        xSprite.DrawFrame(34, n5, n6, 0);
        xSprite.DrawFrame(35, GameImpl.SCR_W - 17, n6, 0);
        xSprite.DrawFrame(36, GameImpl.SCR_W - 17, GameImpl.SCR_H - 18, 0);
        sDKGraphics.setClip(0, n6 + 16, 17, GameImpl.SCR_H - 18 - n6 - 16);
        for (n2 = n6 + 16; n2 < GameImpl.SCR_H - 16; n2 += 23) {
            xSprite.DrawFrame(38, 0, n2, 0);
        }
        sDKGraphics.setClip(n4 - 17, n6 + 16, 17, GameImpl.SCR_H - 18 - n6 - 16);
        for (n2 = n6 + 16; n2 < GameImpl.SCR_H - 16; n2 += 23) {
            xSprite.DrawFrame(38, GameImpl.SCR_W - 1, n2, 1);
        }
        sDKGraphics.setClip(16, n6, n4 - 32, 23);
        for (n2 = 16; n2 < GameImpl.SCR_W - 16; n2 += 23) {
            xSprite.DrawFrame(37, n2, n6 + 5, 2);
        }
        sDKGraphics.setClip(16, GameImpl.SCR_H - 23, n4 - 32, 23);
        for (n2 = 16; n2 < GameImpl.SCR_W - 16; n2 += 23) {
            xSprite.DrawFrame(37, n2, GameImpl.SCR_H - 7, 0);
        }
        sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        if (_numObjectivesMenuItems <= 0) {
            _string = SDKUtils.getString(4, _string);
            Hud.DrawSoftKeys(_string, false, 4, true, false, 0);
            return;
        }
        if (_objectivesMenuDetails) {
            n2 = n6 + SDKUtils.getLineSize();
            n = 10 + GameImpl.OBJECTIVES_TEXT_WIDTH / 2;
            SDKUtils.setFont(GameImpl.fonts[4]);
            int n7 = -1;
            int n8 = -1;
            while (n7 != _menuIndex) {
                if (!UtilEntity.Objective_IsDisplayable(++n8)) continue;
                ++n7;
            }
            SDKUtils.setFont(GameImpl.fonts[1]);
            _string = SDKUtils.getString(UtilEntity.Objectives_GetInfo(n8, 1), _string);
            int n9 = SDKUtils.getStringSize(_string);
            if (n9 > GameImpl.OBJECTIVES_TEXT_WIDTH) {
                sDKGraphics.setClip(10, n2 - 10, GameImpl.OBJECTIVES_TEXT_WIDTH, 30);
                SDKUtils.drawString(_string, 10 - _horizontalScrollPos, n2, 0);
                sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
                xSprite2.DrawFrame(88, GameImpl.SV_W - 24, n2 + 3, 0);
                if (UtilEntity.Objectives_GetInfo(n8, 7) == 2) {
                    xSprite2.DrawFrame(89, GameImpl.SV_W - 24, n2 + 3, 0);
                }
            } else {
                SDKUtils.drawString(_string, n - n9 / 2, n2, 0);
                xSprite2.DrawFrame(88, n + n9 / 2 + 12, n2 + 3, 0);
                if (UtilEntity.Objectives_GetInfo(n8, 7) == 2) {
                    xSprite2.DrawFrame(89, n + n9 / 2 + 12, n2 + 3, 0);
                }
            }
            SDKUtils.setFont(GameImpl.fonts[4]);
            sDKGraphics.setClip(15, n2 += SDKUtils.getLineSize() + 15, GameImpl.OBJECTIVES_TEXT_WIDTH, GameImpl.OBJECTIVES_DETAILS_TEXT_HEIGHT - n2 + 5);
            _string = SDKUtils.getString(UtilEntity.Objectives_GetInfo(n8, 2), _string);
            SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], 15, n2 - _verticalScrollPos, 4);
            sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
            _string = SDKUtils.getString(4, _string);
            Hud.DrawSoftKeys(_string, false, 4, false, false, 0);
        } else {
            n2 = _objectivesStartIndex;
            n = 10 + GameImpl.OBJECTIVES_TEXT_WIDTH / 2;
            int n10 = n6 + SDKUtils.getLineSize();
            int n11 = -1;
            int n12 = -1;
            while (n11 < n2 + 5 && n11 < _numObjectivesMenuItems && n12 < 25) {
                int n13;
                if (!UtilEntity.Objective_IsDisplayable(++n12) || ++n11 < n2) continue;
                if (n11 == _menuIndex) {
                    SDKUtils.setFont(GameImpl.fonts[1]);
                    _string = SDKUtils.getString(UtilEntity.Objectives_GetInfo(n12, 1), _string);
                    n13 = SDKUtils.getStringSize(_string);
                    if (n13 > GameImpl.OBJECTIVES_TEXT_WIDTH) {
                        sDKGraphics.setClip(10, n10 - 10, GameImpl.OBJECTIVES_TEXT_WIDTH, 30);
                        SDKUtils.drawString(_string, 10 - _horizontalScrollPos, n10, 0);
                        sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
                        xSprite2.DrawFrame(88, GameImpl.SV_W - 24, n10 + 3, 0);
                        if (UtilEntity.Objectives_GetInfo(n12, 7) == 2) {
                            xSprite2.DrawFrame(89, GameImpl.SV_W - 24, n10 + 3, 0);
                        }
                    } else {
                        SDKUtils.drawString(_string, n - n13 / 2, n10, 0);
                        xSprite2.DrawFrame(88, n + n13 / 2 + 12, n10 + 3, 0);
                        if (UtilEntity.Objectives_GetInfo(n12, 7) == 2) {
                            xSprite2.DrawFrame(89, n + n13 / 2 + 12, n10 + 3, 0);
                        }
                    }
                } else {
                    SDKUtils.setFont(GameImpl.fonts[4]);
                    _string = SDKUtils.getString(UtilEntity.Objectives_GetInfo(n12, 1), _string);
                    n13 = SDKUtils.getStringSize(_string);
                    if (n13 > GameImpl.OBJECTIVES_TEXT_WIDTH) {
                        sDKGraphics.setClip(10, n10 - 10, GameImpl.OBJECTIVES_TEXT_WIDTH, 30);
                        SDKUtils.drawString(_string, 15, n10, 0);
                        sDKGraphics.setClip(0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
                        xSprite2.DrawFrame(88, GameImpl.SV_W - 24, n10 + 3, 0);
                        if (UtilEntity.Objectives_GetInfo(n12, 7) == 2) {
                            xSprite2.DrawFrame(89, GameImpl.SV_W - 24, n10 + 3, 0);
                        }
                    } else {
                        SDKUtils.drawString(_string, n - n13 / 2, n10, 0);
                        xSprite2.DrawFrame(88, n + n13 / 2 + 12, n10 + 3, 0);
                        if (UtilEntity.Objectives_GetInfo(n12, 7) == 2) {
                            xSprite2.DrawFrame(89, n + n13 / 2 + 12, n10 + 3, 0);
                        }
                    }
                }
                n10 += SDKUtils.getLineSize() + 8;
            }
            Hud.DrawSoftKeys(SDKUtils.getString(8, _string), true, 4, false, false, 0);
            Hud.DrawSoftKeys(SDKUtils.getString(4, _string), false, 4, false, false, 0);
        }
    }

    public static int DrawMenu(SDKGraphics sDKGraphics, boolean bl, boolean bl2, byte by, short n, int n2, int n3, boolean bl3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = MENUS[n3].length;
        int n11 = n2;
        int n12 = n;
        int n13 = n12 - 8;
        int n14 = n9;
        if (n3 == 11) {
            n9 = 8;
        } else if (n3 == 12) {
            n9 = 7;
        }
        if (by == 24) {
            n12 = GameImpl.SCR_W - n;
        } else if (by == 17) {
            n12 = (GameImpl.SCR_W >> 1) + n;
        }
        if (bl) {
            Menu.DrawSplash(true);
        }
        if (bl2) {
            Menu.DrawSplashKirov(true);
        }
        if (n9 == 16) {
            _menuHeadOnScreen = 0;
        }
        XSprite xSprite = Sprites._sprites[45];
        int n15 = 0;
        for (int i = _menuHeadOnScreen; i < n10 && n15 < n9; ++i) {
            int n16;
            if ((n4 & 1 << i) == 0) continue;
            ++n15;
            if (i == _menuIndex) {
                SDKUtils.setFont(GameImpl.fonts[n6]);
                n16 = SDKUtils.getLineSize();
            } else if (i == _menuIndex - 1 || i == _menuIndex + 1) {
                SDKUtils.setFont(GameImpl.fonts[n7]);
                n16 = SDKUtils.getLineSize();
            } else {
                SDKUtils.setFont(GameImpl.fonts[n8]);
                n16 = SDKUtils.getLineSize();
            }
            SDKUtils.getString(MENUS[n3][i], _string);
            if (i == _menuIndex) {
                int n17 = GameImpl.SCR_W - n;
                if (by == 17) {
                    n17 = GameImpl.SCR_W - n12 << 1;
                }
                _detailStringLines = SDKUtils.wrapString(_string, _detailStringLines, n17, (short)124);
                n16 = SDKUtils.getLineSize() * _detailStringLines[0];
            }
            if (_state == 0) {
                if ((n5 & 1 << i) == 0) continue;
                if (i == _menuIndex) {
                    if (_detailStringLines[0] > 1) {
                        SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], n12, n11, by);
                    } else {
                        SDKUtils.drawString(_string, n12, n11, by);
                    }
                } else {
                    SDKUtils.drawString(_string, n12, n11, by);
                }
                n11 += n16;
                continue;
            }
            if (n3 == 11 || n3 == 12) {
                if (i == _menuIndex) {
                    if (_detailStringLines[0] > 1) {
                        SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], n12, n11, by);
                    } else {
                        SDKUtils.drawString(_string, n12, n11, by);
                    }
                } else {
                    if (i < n14) {
                        SDKUtils.setFont(GameImpl.fonts[n8]);
                    } else {
                        SDKUtils.setFont(GameImpl.fonts[n7]);
                    }
                    SDKUtils.drawString(_string, n12, n11, by);
                }
                n11 += n16;
                continue;
            }
            if (i == _menuIndex) {
                if (_detailStringLines[0] > 1) {
                    SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], n12, n11, by);
                } else {
                    SDKUtils.drawString(_string, n12, n11, by);
                }
            } else {
                SDKUtils.drawString(_string, n12, n11, by);
            }
            if ((n5 & 1 << i) == 0) {
                if (by == 20) {
                    n13 = n12 - 8;
                } else if (by == 24) {
                    n13 = n12 + 8;
                } else if (by == 17) {
                    n13 = n12 + (SDKUtils.getStringSize(_string) >> 1) + 16;
                }
                xSprite.DrawFrame(13, n13, n11 + (SDKUtils.getLineSize() >> 1), 0);
            }
            n11 += n16;
            ++n11;
        }
        return n11 - n2;
    }

    public static void DrawLine(int n, int n2, int n3, int n4, int n5) {
        XSprite xSprite = Sprites._sprites[42];
        int n6 = n3;
        while (n6 + n2 < n + n3) {
            xSprite.DrawFrame(n5, n6, n4, 0);
            n6 += n2;
        }
        xSprite.DrawFrame(n5, n + n3 - n2, n4, 0);
    }

    public static void UpdateOutro() {
        Menu.UpdateSplash();
        if (_outro_string == -1 || SDKCanvas.isNewKeyPressed(4144)) {
            Menu.Kill();
            Menu.ShowMenu(4);
            GameImpl._nextMission = -1;
        }
        SDKUtils.getString(_outro_string, _string);
        if (_outro_pos < _string.length()) {
            _outro_pos = (short)(_outro_pos + 1);
            while (_string.charAt(_outro_pos) == ' ') {
                _outro_pos = (short)(_outro_pos + 1);
            }
        }
        Menu._outro_display[0] = 0;
        for (int i = 1; _outro_pos > _outro_lines[i] && i < _outro_lines[0] + 1; ++i) {
            Menu._outro_display[0] = (short)i;
            Menu._outro_display[i] = _outro_lines[i];
        }
        Menu._outro_display[i++] = _outro_pos;
    }

    public static void DrawOutro(SDKGraphics sDKGraphics) {
        Menu.DrawSplash(true);
        Menu.DrawSplashKirov(true);
        SDKUtils.getString(_outro_string, _string);
        SDKUtils.drawWrappedString(_string, _outro_display, 1, _outro_display[0], GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 1, 3);
        Hud.DrawSoftKeys(SDKUtils.getString(5, _string), true, 4, false, false, 0);
    }

    public static void UpdateIngameExitMenu() {
        if (SDKCanvas.isNewKeyPressed(32)) {
            GameImpl.SetState(4);
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            Menu.ShowMenu(3);
        }
    }

    public static void DrawIngameExitMenu(SDKGraphics sDKGraphics) {
        Menu.darkenRegion(sDKGraphics, -671088640, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        _string = SDKUtils.getString(467, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 1, 3);
        Hud.DrawSoftKeys(SDKUtils.getString(13, _string), true, 4, true, true, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(14, _string), false, 4, true, true, 0);
    }

    public static void UpdateIngameRestartMenu() {
        if (SDKCanvas.isNewKeyPressed(32)) {
            Level.ClearLevel();
            GameImpl.SetState(8);
        } else if (SDKCanvas.isNewKeyPressed(524352)) {
            Menu.Kill();
            Menu.ShowMenu(3);
        }
    }

    public static void DrawIngameRestartMenu(SDKGraphics sDKGraphics) {
        Menu.darkenRegion(sDKGraphics, -671088640, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
        _string = SDKUtils.getString(341, _string);
        SDKUtils.setFont(GameImpl.fonts[7]);
        SDKUtils.drawWrappedString(_string, _detailStringLines, 1, _detailStringLines[0], GameImpl.SCR_W >> 1, GameImpl.SCR_H >> 1, 3);
        Hud.DrawSoftKeys(SDKUtils.getString(13, _string), true, 4, true, true, 0);
        Hud.DrawSoftKeys(SDKUtils.getString(14, _string), false, 4, true, true, 0);
    }

    public static void darkenRegion(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5) {
        Utils.FillRect(sDKGraphics, n, 0, 0, GameImpl.SCR_W, GameImpl.SCR_H);
    }

    static {
        _menuHeadOnScreen = 0;
        _incBar = 0;
        _headHelp = 40;
        _headAchBonus = 0;
        _headStats = 0;
        _msk_bonus_menu = -4;
        _skirmishState = 0;
        _splash_entities = new int[120];
        _splash_kirov_generator = 0;
        _splash_first_time = true;
        _selectedFaction = 0;
        _totDrawH = 0;
        _arrow_keys = new int[4];
        MAIN_MENU_ITEMS = new int[]{335, 331, 333, 336, 339, 337, 338, 3};
        NEW_GAME_MENU_ITEMS = new int[]{369, 370, 334};
        CHOOSE_SOVIET_MENU_ITEMS = new int[]{346, 347, 348, 349, 350, 351, 352, 353};
        CHOOSE_ALLIED_MENU_ITEMS = new int[]{354, 355, 356, 357, 358, 359, 360};
        OPTIONS_MENU_ITEMS = new int[]{377, 375, 332, 381, 383};
        BONUS_MENU_ITEMS = new int[]{385, 386};
        IG_MENU_ITEMS = new int[]{340, 343, 336, 337, 341, 342};
        IGMenu_Objective_Pos = 1;
        CHOOSE_SKIRMISH_FACTION_ITEMS = new int[]{369, 370, 371};
        CHOOSE_SKIRMISH_LEVEL_MENU_ITEMS = new int[]{362, 363, 364, 365};
        CHOOSE_TOWER_DEF_MENU_ITEMS = new int[]{465, 466};
        STATS_MENU_ITEMS = new int[]{390, 391, 392, 393, 394};
        ENCYCLOPEDIA_MENU_ITEMS = new int[]{421, 422, 425, 426, 428, 429, 431, 432};
        ENCYCLOPEDIA_DESCRIPTIONS = new int[]{433, 434, 437, 438, 440, 441, 443, 444};
        ACH_MENU_ITEMS = new int[]{397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408};
        ACH_DESCRIPTIONS = new int[]{409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420};
        EMBLEMS = new int[]{1, 8, 31};
        _mgInstance = null;
        _detailStringLines = new short[128];
        _outro_lines = new short[20];
        _outro_display = new short[20];
        MENUS = new int[][]{MAIN_MENU_ITEMS, OPTIONS_MENU_ITEMS, BONUS_MENU_ITEMS, IG_MENU_ITEMS, CHOOSE_SKIRMISH_FACTION_ITEMS, CHOOSE_SKIRMISH_LEVEL_MENU_ITEMS, STATS_MENU_ITEMS, ENCYCLOPEDIA_MENU_ITEMS, ENCYCLOPEDIA_DESCRIPTIONS, ACH_MENU_ITEMS, ACH_DESCRIPTIONS, CHOOSE_SOVIET_MENU_ITEMS, CHOOSE_ALLIED_MENU_ITEMS};
        bMoreGames = false;
    }
}

