/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Debug;
import com.ea.game.Encyclopedia;
import com.ea.game.Hud;
import com.ea.game.Key;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.Menu;
import com.ea.game.Script;
import com.ea.game.SpriteConstants;
import com.ea.game.Sprites;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKAutoConstants;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.SystemListener;
import net.rim.device.api.system.SystemListener2;
import net.rim.device.api.ui.UiApplication;

public class GameImpl
implements SDKGame,
ResourceLoader,
Constants,
Key,
SpriteConstants,
SystemListener2 {
    static String _versionNumber;
    public static SDKString _stringVer;
    static int SCR_W;
    static int SCR_H;
    static int SV_X;
    static int SV_Y;
    static int SV_W;
    static int SV_H;
    static int CDB_TW;
    static int CDB_TH;
    static int CDB_W;
    static int CDB_H;
    static int CDB_SCROLLER_W;
    static int CDB_SCROLLER_H;
    static int HUD_BUILD_POSX;
    static int HUD_BUILD_ARROWS_POSX;
    static int HUD_BUILD_SLOT_OFF_POSX;
    static int HUD_BUILD_SLOT_ON_POSX;
    static int HUD_BUILD_NR_VISIBLE_SLOTS;
    static int HUD_BUILD_TOTAL_SLOT_HEIGHT;
    static int HUD_BUILD_SLOT_BOTTOM_ARROW_POSY;
    static int HUD_BUILD_SQUADS_POSX;
    static int LOADING_POS_Y_DELTA;
    static int LOADING_POS_Y_TEXT;
    static int LOADING_POS_Y_LINE;
    static int SW_STORM_CLOUD_DX;
    static int SW_STORM_CLOUD_DY;
    static int SW_STORM_HIGHT;
    static int CURSOR_MIN_Y;
    static int OBJECTIVES_TEXT_WIDTH;
    static int OBJECTIVES_DETAILS_TEXT_HEIGHT;
    static short HUGE_LEFT_MARGIN;
    static short BIG_TOP_MARGIN;
    static int STATISTICS_BAR_X;
    static int STATISTICS_NUMBERS_X;
    protected static SDKSoundManager _soundManager;
    public static boolean _loaded_stats;
    static SDKCanvas _canvas;
    public static GameImpl _instance;
    public static Object[] fonts;
    public static SDKString _string;
    public static int _gameState;
    public static boolean _player_won;
    private static int _screenW;
    private static int _screenH;
    static int _loadingStatus;
    static int _loadingMax;
    static int _timer;
    static int _frameCounter;
    private static long legalsInitTime;
    static int xEng;
    static boolean pauseLoadingEngineer;
    static int _maxSovietMission;
    static int _maxAlliedMission;
    static int _maxSkirmishMission;
    static int _nextMission;
    public static boolean _setDrawLines;
    static boolean _soundEnable;
    static boolean _attackSoundPlayed;
    static boolean _constructionSoundPlayed;
    static int _firstAttackFrame;
    static int _lastAttackSoundFrame;
    static int _soundFadeTimer;
    static int _shoutSoundTimer;
    static boolean _vibrationsEnable;
    static boolean _tutorialEnable;
    static boolean _fiveSelected;
    static int _language;
    static int _drawFiveOut;
    static boolean _soundSelected;
    static int _xNatasha;
    static boolean _useFog;
    private static int _ID;
    private static byte[] _realData;
    private static int _pos;
    public static int _unlockables;
    public static int _new_unlocked;
    public static int _splashLoaded;
    public boolean bIsShown = true;
    public static boolean bBacklightOn;
    public static boolean bBacklightStateChange;
    public static int soundVolume;
    static int _sprite;
    static int _crt_anim;
    static int _crt_aframe;
    static int _crt_aframe_time;
    static int _flags;
    public static SDKString[] _cheatsStrings;
    public static SDKString[] _cheatsNames;
    public static boolean _cheatsEnabledInJad;
    public static char[] _cheatsKeyBuffer;
    public static int _cheatsKeyBufferPos;
    public static int _cheatsDrawTimer;
    public static int _cheatsActive;

    public GameImpl(SDKCanvas sDKCanvas) {
        _canvas = sDKCanvas;
        _instance = this;
    }

    public void init() {
        Application.getApplication().addSystemListener((SystemListener)this);
        GameImpl.SetState(0);
    }

    public void first_time_init() {
        Sprites.InitSprites();
        Sprites.MarkInitSprites();
        Sprites._legalImage = SDKInputStream.loadImageObject(148);
        Utils._rgbData = new int[1034];
        _gameState = -1;
        GameImpl.SetState(1);
        _loadingStatus = 0;
        _loadingMax = 11;
        _timer = 0;
        _maxSovietMission = 0;
        _maxAlliedMission = -1;
        _maxSkirmishMission = 15;
        _nextMission = -1;
        _splashLoaded = 1;
        GameImpl.loadRMS();
        GameImpl.InitCheats();
        legalsInitTime = System.currentTimeMillis();
        GameImpl.UpdateScreenConstants();
        _sprite = 18;
        GameImpl.SetCrtAnim(18);
    }

    public byte[] loadResource(int n) {
        return SDKInputStream.loadResourceAsByteArray(n);
    }

    public static void UpdateScreenResolution(boolean bl) {
        _screenW = _canvas.getWidth();
        _screenH = _canvas.getHeight();
        if (SCR_W != _screenW || SCR_H != _screenH || bl) {
            SCR_W = _screenW;
            SCR_H = _screenH;
            SV_X = 0;
            SV_Y = 28;
            SV_W = SCR_W - SV_X;
            SV_H = SCR_H - SV_Y;
            GameImpl.UpdateScreenConstants();
        }
    }

    public static void UpdateScreenConstants() {
        CDB_TW = (SV_W + 32 - 1) / 32 + 1;
        CDB_TH = (SV_H + 32 - 1) / 32 + 1;
        CDB_W = CDB_TW * 32;
        CDB_H = CDB_TH * 32;
        CDB_SCROLLER_W = SV_W;
        CDB_SCROLLER_H = SV_H;
        HUD_BUILD_POSX = SCR_W - 30;
        HUD_BUILD_ARROWS_POSX = HUD_BUILD_POSX + 4;
        HUD_BUILD_SLOT_OFF_POSX = SCR_W - 25;
        HUD_BUILD_SLOT_ON_POSX = SCR_W - 38;
        HUD_BUILD_SQUADS_POSX = HUD_BUILD_POSX - 14 - 10 - 23;
        SW_STORM_CLOUD_DX = SV_W + 64;
        SW_STORM_CLOUD_DY = SV_H + 64;
        CURSOR_MIN_Y = 64 - SV_Y;
        OBJECTIVES_TEXT_WIDTH = SV_W - 40;
        OBJECTIVES_DETAILS_TEXT_HEIGHT = SCR_H - 20;
        HUD_BUILD_NR_VISIBLE_SLOTS = (SCR_H - 100 - 20) / 39;
        HUD_BUILD_TOTAL_SLOT_HEIGHT = 39 * HUD_BUILD_NR_VISIBLE_SLOTS;
        HUD_BUILD_SLOT_BOTTOM_ARROW_POSY = 100 + HUD_BUILD_TOTAL_SLOT_HEIGHT - 39 + 21;
        HUGE_LEFT_MARGIN = (short)(SCR_W >> 1);
        BIG_TOP_MARGIN = (short)((SCR_H >> 1) - 40);
        STATISTICS_BAR_X = (SCR_W >> 1) - 30;
        STATISTICS_NUMBERS_X = (SCR_W >> 1) + 30 + 5;
    }

    public void update(long l) {
        UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityXOffset(30);
        UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityYOffset(30);
        GameImpl.UpdateScreenResolution(false);
        GameImpl.UpdateCheats();
        if (UiApplication.getUiApplication().isForeground()) {
            if (!this.bIsShown) {
                this.bIsShown = true;
                if (_soundEnable && (_gameState == 4 || _gameState == 9 || _gameState == 10 || _gameState == 3)) {
                    _soundManager.setCurrentLoop(-1);
                    _soundManager.playSound(28);
                }
                if (_soundEnable && (_gameState == 5 || _gameState == 6)) {
                    if (_attackSoundPlayed) {
                        _soundManager.setCurrentLoop(-1);
                        _soundManager.playSound(30);
                    } else {
                        _soundManager.setCurrentLoop(-1);
                        _soundManager.playSound(29);
                    }
                }
            }
        } else if (this.bIsShown) {
            this.bIsShown = false;
            _soundManager.stopSounds();
        }
        if (_soundEnable) {
            if (_shoutSoundTimer == 0 && _gameState != 8) {
                _soundManager.setCurrentLoop(-1);
                _soundManager.playSound(28);
                _soundManager.setSoundVolume(soundVolume);
                _shoutSoundTimer = -1;
            } else if (_shoutSoundTimer > 0) {
                --_shoutSoundTimer;
            }
        }
        switch (_gameState) {
            case 0: {
                this.first_time_init();
                Menu.InitSplash();
                break;
            }
            case 1: {
                if (_splashLoaded == 1) {
                    _versionNumber = "VERSION: " + SDKMIDlet.getAppProp("MIDlet-Version");
                    _stringVer = new SDKString(_versionNumber);
                    fonts = new Object[9];
                    byte[] byArray = SDKInputStream.loadResourceAsByteArray(9);
                    GameImpl.fonts[0] = SDKUtils.loadFont(SDKInputStream.loadImageObject(0), byArray);
                    GameImpl.fonts[1] = SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(0, 1), byArray);
                    GameImpl.fonts[2] = SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(0, 2), byArray);
                    GameImpl.fonts[3] = SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(0, 3), byArray);
                    byArray = SDKInputStream.loadResourceAsByteArray(11);
                    GameImpl.fonts[7] = SDKUtils.loadFont(SDKInputStream.loadImageObject(7), byArray);
                    GameImpl.fonts[8] = SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(7, 8), byArray);
                    byArray = SDKInputStream.loadResourceAsByteArray(10);
                    GameImpl.fonts[4] = SDKUtils.loadFont(SDKInputStream.loadImageObject(4), byArray);
                    GameImpl.fonts[5] = SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(4, 5), byArray);
                    GameImpl.fonts[6] = SDKUtils.loadFont(SDKInputStream.loadImageObjectWithPalette(4, 6), byArray);
                    Debug.setFont(fonts[4]);
                    _soundManager = SDKSoundManager.getManager();
                    _soundManager.setLoader(this);
                    Menu.Init();
                    Encyclopedia.Init();
                    Menu.InitSplash();
                    Sprites.LoadInitSprites();
                    _splashLoaded = 2;
                }
                if (l - legalsInitTime > 3000L) {
                    int n = SDKUtils.chooseLanguage(_language);
                    if (n < 0) {
                        Menu._menuIndex = 0;
                        GameImpl.SetState(13);
                        legalsInitTime = l;
                        SDKUtils.setCurrentLanguage(Menu._menuIndex);
                    } else {
                        SDKUtils.setCurrentLanguage(n);
                        _language = n;
                        GameImpl.SetState(_gameState + 1);
                        legalsInitTime = l;
                    }
                }
                if (_gameState != 2) break;
                Sprites._legalImage = null;
                System.gc();
                break;
            }
            case 2: {
                GameImpl.UpdateLoadingEngineer();
                if (_loadingStatus == _loadingMax) {
                    if (++_timer != 40) break;
                    GameImpl.SetState(_gameState + 1);
                    break;
                }
                if ((pauseLoadingEngineer || _crt_anim == 18) && (_loadingStatus % 3 == 0 || _loadingStatus % 5 == 0)) break;
                GameImpl.InitGame();
                break;
            }
            case 3: {
                GameImpl.UpdateSoundEnable();
                break;
            }
            case 4: {
                Menu.Update();
                if (!Menu._menuRefresh) break;
                Menu._menuRefresh = false;
                break;
            }
            case 5: {
                UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityXOffset(100);
                UiApplication.getUiApplication().getActiveScreen().setTrackballSensitivityYOffset(100);
                this.updateGame();
                break;
            }
            case 8: {
                GameImpl.UpdateLoadingEngineer();
                if (!pauseLoadingEngineer && _crt_anim != 18 || _loadingStatus % 3 != 0 && _loadingStatus % 5 != 0) {
                    Level.LoadLevel(Level._crt_level, _loadingStatus);
                }
                if (_loadingStatus != 10) break;
                if (Level._crt_level < 14) {
                    _nextMission = Level._crt_level;
                    if (Level._crt_level <= 7) {
                        if (_maxSovietMission < _nextMission) {
                            _maxSovietMission = _nextMission;
                        }
                    } else if (Level._crt_level <= 14 && _maxAlliedMission < _nextMission) {
                        _maxAlliedMission = _nextMission;
                    }
                    GameImpl.saveRMS();
                }
                GameImpl.SetState(5);
                _attackSoundPlayed = false;
                _constructionSoundPlayed = true;
                _firstAttackFrame = 0;
                _lastAttackSoundFrame = 0;
                _soundFadeTimer = 0;
                _shoutSoundTimer = -1;
                _soundFadeTimer = 21;
                if (!_soundEnable) break;
                _soundManager.setCurrentLoop(-1);
                _soundManager.playSound(29);
                _soundManager.setSoundVolume(soundVolume);
                break;
            }
            case 6: {
                Menu.Update();
                break;
            }
            case 7: {
                Menu.Update();
                break;
            }
            case 11: {
                Menu.Update();
                break;
            }
            case 9: {
                GameImpl.UpdateLoadingEngineer();
                if (!pauseLoadingEngineer && _crt_anim != 18 || _loadingStatus % 3 != 0 && _loadingStatus % 5 != 0) {
                    Encyclopedia.loadEncyclopedia(_loadingStatus);
                }
                if (_loadingStatus != 10) break;
                GameImpl.SetState(10);
                break;
            }
            case 10: {
                Encyclopedia.UpdateEncyclopediaMenu();
                break;
            }
            case 13: {
                GameImpl.UpdateChooseLanguage();
            }
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        if (!UiApplication.getUiApplication().isForeground()) {
            return;
        }
        this.clearScreen(sDKGraphics, 0);
        SDKUtils.setGraphics(sDKGraphics);
        XSprite.SetGraphics(sDKGraphics);
        switch (_gameState) {
            case 1: {
                this.PaintLegals(sDKGraphics);
                break;
            }
            case 2: {
                this.DrawLoading(sDKGraphics);
                break;
            }
            case 3: {
                GameImpl.DrawSoundEnable(sDKGraphics);
                break;
            }
            case 4: {
                Menu.Draw(sDKGraphics);
                break;
            }
            case 5: {
                this.drawGame(sDKGraphics);
                break;
            }
            case 8: {
                this.DrawLoading(sDKGraphics);
                break;
            }
            case 6: {
                this.drawGame(sDKGraphics);
                Menu.Draw(sDKGraphics);
                break;
            }
            case 7: {
                Menu.Draw(sDKGraphics);
                break;
            }
            case 11: {
                Menu.Draw(sDKGraphics);
                break;
            }
            case 9: {
                this.DrawLoading(sDKGraphics);
                break;
            }
            case 10: {
                Encyclopedia.DrawEncyclopediaMenu(sDKGraphics);
                break;
            }
            case 13: {
                GameImpl.DrawChooseLanguage(sDKGraphics);
            }
        }
        GameImpl.PaintCheats(sDKGraphics);
    }

    public void backlightStateChange(boolean bl) {
        bBacklightStateChange = true;
        if (bl) {
            UiApplication.getUiApplication().requestForeground();
            bBacklightOn = true;
        } else {
            bBacklightOn = false;
        }
    }

    public void cradleMismatch(boolean bl) {
    }

    public void fastReset() {
    }

    public void powerOffRequested(int n) {
    }

    public void usbConnectionStateChange(int n) {
    }

    public void batteryStatusChange(int n) {
    }

    public void batteryGood() {
    }

    public void batteryLow() {
    }

    public void powerOff() {
    }

    public void powerUp() {
    }

    public void pause() {
        Cursor._bCursorExpanded = false;
        Hud._changeDownFrames = 0;
        try {
            if (_soundManager != null) {
                _soundManager.stopSounds();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Level._skipMovieState > 0 && Level._skipMovieState < 3) {
            Utils._darkFade = true;
            Utils._fadeIn = false;
            Utils._fadeSteps = 20;
            Level._skipMovieState = 3;
            Level._bCanSkipMovie = false;
        }
        if (_gameState == 5) {
            GameImpl.SetState(6);
        }
        UiApplication.getUiApplication().requestBackground();
    }

    public void resume() {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bBacklightStateChange) {
            bBacklightStateChange = false;
            if (!UiApplication.getUiApplication().isForeground() && !bBacklightOn) {
                return;
            }
        } else if (!UiApplication.getUiApplication().isForeground()) {
            return;
        }
        if (_soundEnable && (_gameState == 4 || _gameState == 9 || _gameState == 10 || _gameState == 3)) {
            _soundManager.setCurrentLoop(-1);
            _soundManager.playSound(28);
            _soundManager.setSoundVolume(soundVolume);
        }
        if (_soundEnable && (_gameState == 5 || _gameState == 6)) {
            if (_attackSoundPlayed) {
                _soundManager.setCurrentLoop(-1);
                _soundManager.playSound(30);
                _soundManager.setSoundVolume(soundVolume);
            } else {
                _soundManager.setCurrentLoop(-1);
                _soundManager.playSound(29);
                _soundManager.setSoundVolume(soundVolume);
            }
        }
    }

    public void exiting() {
        _soundManager.stopSounds();
        GameImpl.saveRMS();
    }

    void PaintLegals(SDKGraphics sDKGraphics) {
        sDKGraphics.drawImage(Sprites._legalImage, SCR_W >> 1, SCR_H >> 1, 3);
    }

    public static void UpdateLoadingEngineer() {
        GameImpl.UpdateCrtAnim();
        int n = SCR_W / _loadingMax;
        if (xEng - 42 < n * (_loadingStatus + 1) && _loadingStatus < 9) {
            if (_crt_anim != 18) {
                GameImpl.SetCrtAnim(18);
            }
            xEng += 3;
        } else if (_loadingStatus < 9 && _loadingStatus % 5 == 0) {
            if (_crt_anim != 13) {
                GameImpl.SetCrtAnim(13);
                _crt_aframe_time = 1;
            }
            pauseLoadingEngineer = !GameImpl.IsCrtAnimEnded();
        } else if (_loadingStatus < 9 && _loadingStatus % 3 == 0) {
            if (_crt_anim != 92) {
                GameImpl.SetCrtAnim(92);
            }
            pauseLoadingEngineer = !GameImpl.IsCrtAnimEnded() && _crt_aframe <= 2;
        } else if (_loadingStatus >= 9) {
            if (_crt_anim != 92) {
                GameImpl.SetCrtAnim(92);
            }
            pauseLoadingEngineer = !GameImpl.IsCrtAnimEnded() && _crt_aframe <= 2;
        } else {
            pauseLoadingEngineer = false;
        }
    }

    public static void UpdateSoundEnable() {
        if (!_soundSelected) {
            if (SDKCanvas.isNewKeyPressed(64)) {
                _soundEnable = false;
                _soundSelected = true;
                Utils.Fade(false, 20, true);
            } else if (SDKCanvas.isNewKeyPressed(32)) {
                _soundManager.setCurrentLoop(1);
                _soundManager.playSound(34);
                _soundEnable = true;
                _soundSelected = true;
                Utils.Fade(false, 20, true);
            }
        } else {
            Utils.Update_Fade();
            if (SDKCanvas.isNewKeyPressed(4112)) {
                _fiveSelected = true;
            }
        }
        if (_fiveSelected) {
            if (_xNatasha < 130) {
                _xNatasha += 18;
            } else {
                GameImpl.SetState(_gameState + 1);
            }
        }
        Menu.UpdateSplash();
    }

    public static void DrawSoundEnable(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0);
        sDKGraphics.fillRect(0, 0, SCR_W, SCR_H);
        if (_soundSelected) {
            GameImpl.DrawSplash(sDKGraphics);
            if (_drawFiveOut < 13) {
                ++_drawFiveOut;
                SDKUtils.setFont(fonts[4]);
                _string = SDKUtils.getString(15, _string);
                int n = SCR_W;
                Menu._detailStringLines = SDKUtils.wrapString(_string, Menu._detailStringLines, n, (short)124);
                if (Menu._detailStringLines[0] > 1) {
                    SDKUtils.drawWrappedString(_string, Menu._detailStringLines, 1, Menu._detailStringLines[0], SCR_W >> 1, SCR_H - 30, 33);
                } else {
                    SDKUtils.drawString(_string, SCR_W >> 1, SCR_H - 30, 33);
                }
            } else {
                _drawFiveOut = _drawFiveOut < 15 ? ++_drawFiveOut : 0;
            }
            Utils.Draw_Fade(sDKGraphics);
        } else if (!_soundSelected) {
            SDKUtils.setFont(fonts[0]);
            SDKUtils.getString(18, _string);
            SDKUtils.drawString(_string, SCR_W >> 1, SCR_H >> 1, 17);
            SDKUtils.setFont(fonts[4]);
            SDKUtils.getString(14, _string);
            _string = _string.concat(" (P)");
            SDKUtils.drawString(_string, SCR_W - 1, SCR_H - 1, 40);
            SDKUtils.getString(13, _string);
            _string = _string.concat(" (Q)");
            SDKUtils.drawString(_string, 1, SCR_H - 1, 36);
        }
    }

    static void soundVolumeUp() {
        if (soundVolume <= 100) {
            soundVolume += 10;
            try {
                _soundManager.setSoundVolume(soundVolume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void soundVolumeDown() {
        if (soundVolume >= 0) {
            soundVolume -= 10;
            try {
                _soundManager.setSoundVolume(soundVolume);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void appKeyPressed(int n, long l) {
        byte by;
        if (n == 0x400000) {
            GameImpl.soundVolumeDown();
            return;
        }
        if (n == 0x200000) {
            GameImpl.soundVolumeUp();
            return;
        }
        if (Menu._mgInstance != null && Menu._mgInstance.isActive() && (by = Menu._mgInstance.processKey(n)) == 1) {
            Menu._menuRefresh = true;
        }
        switch (_gameState) {
            case 5: {
                if (n != 64 && n != 524288) break;
                GameImpl.SetState(6);
            }
        }
    }

    public void appKeyReleased(int n, long l) {
    }

    public void appLetterPressed(int n, long l) {
    }

    public void appLetterReleased(int n, long l) {
    }

    public void updateSoftKeyLabels(String string, String string2) {
    }

    public void appPointerPressed(int n, int n2, long l) {
    }

    public void appPointerReleased(int n, int n2, long l) {
    }

    public void appPointerDragged(int n, int n2, long l) {
    }

    private void updateGame() {
        ++_frameCounter;
        Level.UpdateLevel();
    }

    private void drawGame(SDKGraphics sDKGraphics) {
        Level.DrawLevel(sDKGraphics);
        SDKUtils.setFont(fonts[4]);
    }

    private void DrawLoading(SDKGraphics sDKGraphics) {
        GameImpl.DrawSplash(sDKGraphics);
        if (_loadingStatus != _loadingMax) {
            SDKUtils.setFont(fonts[4]);
            SDKUtils.getString(17, _string);
            SDKUtils.drawString(_string, SCR_W >> 1, LOADING_POS_Y_TEXT, 17);
        }
    }

    static void DrawSplash(SDKGraphics sDKGraphics) {
        int n;
        int n2;
        XSprite xSprite = Sprites._sprites[45];
        int n3 = 58;
        int n4 = 12;
        if (_gameState != 8) {
            XSprite xSprite2;
            if (_soundSelected) {
                Menu.DrawSplash(true);
                Menu.DrawSplashKirov(false);
            }
            if (_soundSelected && (xSprite2 = Sprites._sprites[47]) != null) {
                n2 = 0;
                if (SCR_H < SCR_W) {
                    n2 = 30;
                }
                xSprite2.DrawFrame(0, SCR_W + _xNatasha, SCR_H + n2 - 0, 0);
            }
            n = 0;
            if (_language == 1) {
                n = 17;
            }
            if (_language == 3) {
                n = 20;
            }
            if (_language == 2) {
                n = 0;
            }
            xSprite.DrawFrame(n, n3, n4, 0);
        }
        if (_gameState == 2 || _gameState == 8 || _gameState == 9) {
            sDKGraphics.setColor(0);
            sDKGraphics.fillRect(0, 0, SCR_W, SCR_H);
            n3 = 42;
            n4 = LOADING_POS_Y_LINE;
            n2 = SCR_W / _loadingMax + 1;
            xSprite.DrawFrame(3, 0, n4, 0);
            xSprite.DrawFrame(3, 20, n4, 0);
            xSprite.DrawFrame(3, 40, n4, 0);
            sDKGraphics.setClip(42, 0, n2 * (_loadingStatus + 1), SCR_H);
            for (n = 0; n < SCR_W / 20 + 1; ++n) {
                xSprite.DrawFrame(3, n3, n4, 0);
                n3 += 20;
            }
            sDKGraphics.setClip(0, 0, SCR_W, SCR_H);
            GameImpl.DrawCrtAnim(sDKGraphics, xEng, LOADING_POS_Y_LINE);
        }
    }

    static void SetState(int n) {
        switch (_gameState) {
            case 3: {
                if (Sprites._sprites[47] == null) break;
                Sprites._sprites[47].Release();
                Sprites._sprites[47] = null;
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                Menu.Kill();
                break;
            }
            case 6: {
                Menu.Kill();
                SDKCanvas.disableInput(2);
                break;
            }
            case 7: {
                break;
            }
            case 11: {
                Menu.Kill();
                break;
            }
            case 2: {
                break;
            }
            case 9: {
                break;
            }
        }
        switch (n) {
            case 5: {
                break;
            }
            case 8: {
                _soundManager.stopSounds();
                Camera._nCamX = 0;
                Camera._nCamY = 0;
                Level.InitLevel();
                _loadingStatus = -1;
                if (!Level._b_skirmish) {
                    Level.LoadLevel(Level._crt_level, _loadingStatus);
                }
                Level._paused = 0;
                SDKCanvas.disableInput(2);
                GameImpl.initLoadingEngineer();
                break;
            }
            case 4: {
                SDKUtils.loadStringsChunk(20);
                if (_gameState != 3 && _gameState != 10 && _soundEnable) {
                    _soundManager.setCurrentLoop(-1);
                    _soundManager.playSound(28);
                    _soundManager.setSoundVolume(soundVolume);
                }
                Sprites._sprites[11].SetCurrentPalette(0);
                Menu.ShowMenu(0);
                break;
            }
            case 12: {
                Menu.ShowMenu(13);
                break;
            }
            case 2: {
                GameImpl.initLoadingEngineer();
                SDKUtils.loadStringsChunk(1);
                break;
            }
            case 6: {
                Cursor._bCursorExpanded = false;
                Hud._changeDownFrames = 0;
                SDKCanvas.disableInput(2);
                Menu.ShowMenu(3);
                break;
            }
            case 7: {
                Level.CalculateEfficency();
                Menu._incBar = 0;
                if (_player_won) {
                    Menu.ShowMenu(18);
                    break;
                }
                Menu.ShowMenu(5);
                break;
            }
            case 11: {
                Menu.ShowMenu(12);
                break;
            }
            case 9: {
                _loadingStatus = 0;
                GameImpl.initLoadingEngineer();
                Encyclopedia.loadEncyclopedia(_loadingStatus);
                SDKCanvas.disableInput(2);
                break;
            }
            case 10: {
                Encyclopedia.UpdateAchHorizontalScroll();
                break;
            }
            case 3: {
                Utils.Fade(true, 1, true);
                Utils.Update_Fade();
            }
        }
        _gameState = n;
    }

    private static void initLoadingEngineer() {
        pauseLoadingEngineer = false;
        xEng = 42;
        _sprite = 18;
        GameImpl.SetCrtAnim(18);
    }

    private void clearScreen(SDKGraphics sDKGraphics, int n) {
        sDKGraphics.setClip(0, 0, _screenW, _screenH);
        sDKGraphics.setColor(n);
        sDKGraphics.fillRect(0, 0, _screenW, _screenH);
    }

    public static void InitGame() {
        System.gc();
        switch (_loadingStatus) {
            case 0: {
                Level.InitStats();
                Level._crt_level = -1;
                Level._b_skirmish = false;
                Level._player_sk_faction = 2;
                Level._ai_sk_faction = 2;
                Sprites._sprites[40]._flags |= 0x403;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Sprites.LoadSprites();
                break;
            }
            case 9: {
                Script.Scripts_Init(-1);
                Script.LoadScripts(-1);
                break;
            }
            case 10: {
                Utils.setSeed(System.currentTimeMillis());
                SDKUtils.loadStringsChunk(2);
            }
        }
        ++_loadingStatus;
        SDKInputStream.purgeCache();
        System.gc();
    }

    public static void rewindSaveBuffer() {
        _pos = 0;
    }

    public static void putIntSaveBuffer(int n) {
        if (_pos + 4 >= _realData.length) {
            System.out.println("int BUFFER_SIZE too small!" + _pos);
            return;
        }
        for (int i = 0; i < 4; ++i) {
            GameImpl._realData[GameImpl._pos++] = (byte)(n & 0xFF);
            n >>= 8;
        }
    }

    public static void putBoolSaveBuffer(boolean bl) {
        if (_pos >= _realData.length) {
            System.out.println("bool BUFFER_SIZE too small!");
            return;
        }
        GameImpl._realData[GameImpl._pos++] = (byte)(bl ? 1 : 0);
    }

    public static void putShortSaveBuffer(short s) {
        if (_pos + 2 >= _realData.length) {
            System.out.println("short BUFFER_SIZE too small!" + _pos);
            return;
        }
        for (int i = 0; i < 2; ++i) {
            GameImpl._realData[GameImpl._pos++] = (byte)(s & 0xFF);
            s = (short)(s >> 8);
        }
    }

    public static void putLongSaveBuffer(long l) {
        if (_pos + 8 >= _realData.length) {
            System.out.println("long BUFFER_SIZE too small!" + _pos);
            return;
        }
        for (int i = 0; i < 8; ++i) {
            GameImpl._realData[GameImpl._pos++] = (byte)(l & 0xFFL);
            l >>= 8;
        }
    }

    public static void putByteSaveBuffer(byte by) {
        if (_pos >= _realData.length) {
            System.out.println("int BUFFER_SIZE too small!" + _pos);
            return;
        }
        GameImpl._realData[GameImpl._pos++] = by;
    }

    public static int getIntSaveBuffer() {
        if (_pos + 4 >= _realData.length) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += (_realData[_pos++] & 0xFF) << i * 8;
        }
        return n;
    }

    public static long getLongSaveBuffer() {
        if (_pos + 8 >= _realData.length) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l += (long)((_realData[_pos++] & 0xFF) << i * 8);
        }
        return l;
    }

    public static boolean getBoolSaveBuffer() {
        if (_pos >= _realData.length) {
            return false;
        }
        return _realData[_pos++] == 1;
    }

    public static short getShortSaveBuffer() {
        if (_pos + 2 >= _realData.length) {
            return 0;
        }
        short s = 0;
        for (int i = 0; i < 2; ++i) {
            s = (short)(s + ((_realData[_pos++] & 0xFF) << i * 8));
        }
        return s;
    }

    public static byte getByteSaveBuffer() {
        if (_pos >= _realData.length) {
            return 0;
        }
        return _realData[_pos++];
    }

    private static void showData() {
    }

    public static void saveRMS() {
        _pos = 0;
        GameImpl.putIntSaveBuffer(_maxSovietMission);
        GameImpl.putIntSaveBuffer(_maxAlliedMission);
        GameImpl.putIntSaveBuffer(_maxSkirmishMission);
        GameImpl.putIntSaveBuffer(_nextMission);
        GameImpl.putIntSaveBuffer(_unlockables);
        GameImpl.putIntSaveBuffer(Encyclopedia._msk_alpha_omega);
        GameImpl.putIntSaveBuffer(Encyclopedia._msk_stealth);
        GameImpl.putIntSaveBuffer(Encyclopedia._msk_doctor);
        GameImpl.putIntSaveBuffer(Encyclopedia._sniper);
        GameImpl.putIntSaveBuffer(Encyclopedia._shmlf_units);
        GameImpl.putIntSaveBuffer(Encyclopedia._shmlf_bld);
        GameImpl.putIntSaveBuffer(Encyclopedia._bomb);
        GameImpl.putIntSaveBuffer(Encyclopedia._beam_me_up);
        GameImpl.putBoolSaveBuffer(Encyclopedia._alpha_omega);
        GameImpl.putIntSaveBuffer(Encyclopedia._ride_lightning);
        GameImpl.putBoolSaveBuffer(Encyclopedia._flesh_wound);
        GameImpl.putIntSaveBuffer(Encyclopedia._big_brain);
        GameImpl.putIntSaveBuffer(Encyclopedia._road_kill);
        GameImpl.putBoolSaveBuffer(Encyclopedia._superman);
        GameImpl.putBoolSaveBuffer(Encyclopedia._stealth);
        GameImpl.putBoolSaveBuffer(Encyclopedia._doctor);
        GameImpl.putBoolSaveBuffer(_vibrationsEnable);
        GameImpl.putBoolSaveBuffer(_tutorialEnable);
        GameImpl.putBoolSaveBuffer(_setDrawLines);
        GameImpl.putIntSaveBuffer(_language);
        SDKUtils.saveRecord(_ID, _realData);
        GameImpl.showData();
    }

    public static void loadRMS() {
        if (SDKUtils.isRecordEmpty(_ID)) {
            return;
        }
        _realData = SDKUtils.loadRecord(_ID);
        _maxSovietMission = GameImpl.getIntSaveBuffer();
        _maxAlliedMission = GameImpl.getIntSaveBuffer();
        _maxSkirmishMission = GameImpl.getIntSaveBuffer();
        _nextMission = GameImpl.getIntSaveBuffer();
        _unlockables = GameImpl.getIntSaveBuffer();
        Encyclopedia._msk_alpha_omega = GameImpl.getIntSaveBuffer();
        Encyclopedia._msk_doctor = GameImpl.getIntSaveBuffer();
        Encyclopedia._msk_stealth = GameImpl.getIntSaveBuffer();
        Encyclopedia._sniper = GameImpl.getIntSaveBuffer();
        Encyclopedia._shmlf_units = GameImpl.getIntSaveBuffer();
        Encyclopedia._shmlf_bld = GameImpl.getIntSaveBuffer();
        Encyclopedia._bomb = GameImpl.getIntSaveBuffer();
        Encyclopedia._beam_me_up = GameImpl.getIntSaveBuffer();
        Encyclopedia._alpha_omega = GameImpl.getBoolSaveBuffer();
        Encyclopedia._ride_lightning = GameImpl.getIntSaveBuffer();
        Encyclopedia._flesh_wound = GameImpl.getBoolSaveBuffer();
        Encyclopedia._big_brain = GameImpl.getIntSaveBuffer();
        Encyclopedia._road_kill = GameImpl.getIntSaveBuffer();
        Encyclopedia._superman = GameImpl.getBoolSaveBuffer();
        Encyclopedia._stealth = GameImpl.getBoolSaveBuffer();
        Encyclopedia._doctor = GameImpl.getBoolSaveBuffer();
        _vibrationsEnable = GameImpl.getBoolSaveBuffer();
        _tutorialEnable = GameImpl.getBoolSaveBuffer();
        _setDrawLines = GameImpl.getBoolSaveBuffer();
        _language = GameImpl.getIntSaveBuffer();
    }

    static void XSPRITE_ANIM__() {
    }

    public static void SetCrtAnim(int n) {
        _crt_anim = n;
        _crt_aframe = 0;
        XSprite xSprite = Sprites._sprites[_sprite];
        _crt_aframe_time = xSprite.GetAnimFrameTime(_crt_anim, _crt_aframe);
        _flags &= 0xFFFFFFDF;
    }

    public static void UpdateCrtAnim() {
        if (_crt_aframe_time == 0 || (_flags & 0x820) == 2080) {
            return;
        }
        _flags &= 0xFFFFFFDF;
        if (--_crt_aframe_time <= 0) {
            XSprite xSprite = Sprites._sprites[_sprite];
            if (++_crt_aframe >= xSprite.GetAnimLength(_crt_anim)) {
                _crt_aframe = 0;
                _flags |= 0x20;
            }
            _crt_aframe_time = xSprite.GetAnimFrameTime(_crt_anim, _crt_aframe);
        }
    }

    public static boolean IsCrtAnimEnded() {
        return _crt_aframe_time == 0 || (_flags & 0x20) != 0;
    }

    public static void DrawCrtAnim(SDKGraphics sDKGraphics, int n, int n2) {
        XSprite xSprite = Sprites._sprites[_sprite];
        xSprite.SetCurrentPalette(0);
        xSprite.DrawAnimFrame(_crt_anim, _crt_aframe, n, n2, _flags & 7);
    }

    static void __XSPRITE_ANIM() {
    }

    public static void UpdateChooseLanguage() {
        if (SDKCanvas.isNewKeyPressed(4144)) {
            SDKUtils.setCurrentLanguage(Menu._menuIndex);
            _language = Menu._menuIndex;
            GameImpl.SetState(2);
        } else if (SDKCanvas.isNewKeyPressed(513)) {
            if (--Menu._menuIndex < 0) {
                Menu._menuIndex = Menu._numLangsLoaded - 1;
            }
        } else if (SDKCanvas.isNewKeyPressed(32770)) {
            Menu._menuIndex = (Menu._menuIndex + 1) % Menu._numLangsLoaded;
        }
    }

    public static void DrawChooseLanguage(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0);
        sDKGraphics.fillRect(0, 0, SCR_W, SCR_H);
        SDKUtils.setFont(fonts[4]);
        int n = SDKUtils.getLineSize();
        int n2 = (SCR_H >> 1) - (n * Menu._numLangsLoaded >> 1);
        for (int i = 0; i < Menu._numLangsLoaded; ++i) {
            SDKUtils.getHeaderString(i, 0, _string);
            if (i == Menu._menuIndex) {
                SDKUtils.setFont(fonts[1]);
                SDKUtils.drawString(_string, SCR_W >> 1, n2, 17);
                SDKUtils.setFont(fonts[4]);
            } else {
                SDKUtils.drawString(_string, SCR_W >> 1, n2, 1);
            }
            n2 += n;
        }
        Hud.DrawSoftKeys(SDKUtils.getHeaderString(Menu._menuIndex, 1, _string), true, 4, false, false, 0);
    }

    public static void InitCheats() {
        try {
            String string = SDKMIDlet.getAppProp("Enable-Cheats");
            _cheatsEnabledInJad = string != null ? string.trim().toUpperCase().equals("ON") : false;
        }
        catch (Exception exception) {
            _cheatsEnabledInJad = false;
        }
        _cheatsActive = 0;
        for (int i = 0; i < 10; ++i) {
            GameImpl._cheatsKeyBuffer[i] = '\u0000';
        }
        _cheatsKeyBufferPos = 0;
    }

    public static void UpdateCheats() {
        if (!_cheatsEnabledInJad) {
            return;
        }
        if (_cheatsDrawTimer > 0) {
            --_cheatsDrawTimer;
        }
        if (SDKCanvas.isNewKeyPressed(130944)) {
            int n;
            for (n = 0; n < 10; ++n) {
                if (!SDKCanvas.isNewKeyPressed(128 << n)) continue;
                GameImpl._cheatsKeyBuffer[GameImpl._cheatsKeyBufferPos++] = (char)(48 + n);
                if (_cheatsKeyBufferPos < 10) continue;
                _cheatsKeyBufferPos = 0;
            }
            for (n = 0; n < 6; ++n) {
                char c;
                char c2;
                int n2;
                SDKString sDKString = _cheatsStrings[n];
                int n3 = sDKString.length();
                for (n2 = n3 - 1; n2 >= 0 && (c2 = sDKString.charAt(n2)) == (c = _cheatsKeyBuffer[(_cheatsKeyBufferPos - (n3 - n2) + 10) % 10]); --n2) {
                }
                if (n2 != -1) continue;
                _cheatsDrawTimer = 20;
                GameImpl.ActivateCheat(n);
            }
        }
    }

    public static void PaintCheats(SDKGraphics sDKGraphics) {
        if (!_cheatsEnabledInJad) {
            return;
        }
        if (_cheatsDrawTimer > 0) {
            int n = 5;
            for (int i = 0; i < 6; ++i) {
                SDKString sDKString;
                if (GameImpl.IsCheatActive(i)) {
                    SDKUtils.setFont(fonts[4]);
                    sDKString = _cheatsNames[i];
                    SDKUtils.drawString(sDKString, 3, n, 0);
                } else {
                    SDKUtils.setFont(fonts[5]);
                    sDKString = _cheatsNames[i];
                    SDKUtils.drawString(sDKString, 3, n, 0);
                }
                n += 20;
            }
        }
    }

    public static boolean IsCheatActive(int n) {
        if (!_cheatsEnabledInJad) {
            return false;
        }
        return (_cheatsActive & 1 << n) != 0;
    }

    public static void DisableCheat(int n) {
        if (!_cheatsEnabledInJad) {
            return;
        }
        _cheatsActive &= ~(1 << n);
    }

    public static void ActivateCheat(int n) {
        _cheatsActive ^= 1 << n;
        if (GameImpl.IsCheatActive(0)) {
            _maxSovietMission = 7;
            _maxAlliedMission = 14;
            _maxSkirmishMission = 18;
        }
        if (GameImpl.IsCheatActive(1) && _gameState == 5) {
            SDKCanvas.disableInput(2);
            Level.EndLevel(0);
        }
        if (GameImpl.IsCheatActive(2) && _gameState == 5) {
            SDKCanvas.disableInput(2);
            Level.EndLevel(1);
        }
        if (GameImpl.IsCheatActive(4)) {
            _useFog = false;
            Level.FOW_DiscoverPixels(0, 0, Map._map_w, Map._map_h);
        } else if (!GameImpl.IsCheatActive(4)) {
            _useFog = false;
        }
    }

    static {
        SCR_W = SDKAutoConstants.getScreenWidth();
        SCR_H = SDKAutoConstants.getScreenHeight();
        SV_X = 0;
        SV_Y = 28;
        SV_W = SCR_W - SV_X;
        SV_H = SCR_H - SV_Y;
        CDB_TW = (SV_W + 32 - 1) / 32 + 1;
        CDB_TH = (SV_H + 32 - 1) / 32 + 1;
        CDB_W = CDB_TW * 32;
        CDB_H = CDB_TH * 32;
        CDB_SCROLLER_W = SV_W;
        CDB_SCROLLER_H = SV_H;
        HUD_BUILD_POSX = SCR_W - 30;
        HUD_BUILD_ARROWS_POSX = HUD_BUILD_POSX + 4;
        HUD_BUILD_SLOT_OFF_POSX = SCR_W - 25;
        HUD_BUILD_SLOT_ON_POSX = SCR_W - 38;
        HUD_BUILD_NR_VISIBLE_SLOTS = (SCR_H - 100 - 20) / 39;
        HUD_BUILD_TOTAL_SLOT_HEIGHT = 39 * HUD_BUILD_NR_VISIBLE_SLOTS;
        HUD_BUILD_SLOT_BOTTOM_ARROW_POSY = 100 + HUD_BUILD_TOTAL_SLOT_HEIGHT - 39 + 21;
        HUD_BUILD_SQUADS_POSX = HUD_BUILD_POSX - 14 - 10 - 23;
        LOADING_POS_Y_DELTA = 35;
        LOADING_POS_Y_TEXT = SCR_H + 5 - LOADING_POS_Y_DELTA;
        LOADING_POS_Y_LINE = SCR_H - LOADING_POS_Y_DELTA;
        SW_STORM_CLOUD_DX = SV_W + 64;
        SW_STORM_CLOUD_DY = SV_H + 64;
        SW_STORM_HIGHT = SV_H / 3;
        CURSOR_MIN_Y = 64 - SV_Y;
        OBJECTIVES_TEXT_WIDTH = SV_W - 40;
        OBJECTIVES_DETAILS_TEXT_HEIGHT = SCR_H - 20;
        HUGE_LEFT_MARGIN = (short)(SCR_W >> 1);
        BIG_TOP_MARGIN = (short)((SCR_H >> 1) - 40);
        STATISTICS_BAR_X = (SCR_W >> 1) - 30;
        STATISTICS_NUMBERS_X = (SCR_W >> 1) + 30 + 5;
        _loaded_stats = false;
        _string = new SDKString("");
        _frameCounter = 0;
        pauseLoadingEngineer = false;
        _maxSovietMission = 0;
        _maxAlliedMission = -1;
        _maxSkirmishMission = 0;
        _nextMission = -1;
        _setDrawLines = true;
        _soundEnable = false;
        _attackSoundPlayed = false;
        _constructionSoundPlayed = false;
        _firstAttackFrame = 0;
        _lastAttackSoundFrame = 0;
        _soundFadeTimer = 0;
        _shoutSoundTimer = 140;
        _vibrationsEnable = true;
        _tutorialEnable = true;
        _fiveSelected = false;
        _language = -1;
        _drawFiveOut = 0;
        _soundSelected = false;
        _xNatasha = 0;
        _useFog = false;
        _ID = 1;
        _realData = new byte[80];
        _pos = 0;
        _splashLoaded = 0;
        bBacklightOn = true;
        bBacklightStateChange = false;
        soundVolume = 100;
        _sprite = 18;
        _crt_anim = 11;
        _crt_aframe = 0;
        _flags = 0;
        _cheatsStrings = new SDKString[]{new SDKString("1234"), new SDKString("2345"), new SDKString("3456"), new SDKString("1337"), new SDKString("4567"), new SDKString("4321")};
        _cheatsNames = new SDKString[]{new SDKString("UNLOCK_ALL_LEVELS"), new SDKString("INSTANT_WIN"), new SDKString("INSTANT_LOOSE"), new SDKString("GOD_MODE"), new SDKString("REVEAL_MAP"), new SDKString("SHOW ALL ACHIVEMENTS")};
        _cheatsEnabledInJad = false;
        _cheatsKeyBuffer = new char[10];
    }
}

