/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Building;
import com.ea.game.BuildingConstants;
import com.ea.game.Camera;
import com.ea.game.Constants;
import com.ea.game.Cursor;
import com.ea.game.Encyclopedia;
import com.ea.game.GameImpl;
import com.ea.game.GraphicsConstants;
import com.ea.game.Hud;
import com.ea.game.Level;
import com.ea.game.Map;
import com.ea.game.SpriteConstants;
import com.ea.game.Sprites;
import com.ea.game.Unit;
import com.ea.game.UnitsConstants;
import com.ea.game.UtilEntity;
import com.ea.game.Utils;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Entity
implements Constants,
UnitsConstants,
BuildingConstants,
GraphicsConstants,
SpriteConstants {
    public static short _global_uid = 0;
    private static SDKString _descr_string;
    static short[] _txtDescrStringLines;
    short _uid;
    short _arrayIndex;
    int _type;
    int _id;
    int _flags;
    int _pos_x;
    int _pos_y;
    byte _orientation;
    int _z_order;
    int _state;
    int _timer;
    short[] _sdata;
    int[] _idata;
    int _tooltipDelta;
    int _tooltipTxt;
    int _sprite;
    int _crt_anim;
    int _crt_aframe;
    int _crt_aframe_time;

    protected static short GetGlobalUID() {
        _global_uid = (short)(_global_uid + 1 & 0xFFF);
        return _global_uid;
    }

    public Entity(int n) {
        this._arrayIndex = (short)n;
        this._type = 0;
        this._id = 0;
        this._flags = 0;
        this._pos_x = 0;
        this._pos_y = 0;
        this._z_order = 0;
        this._timer = 0;
        this._idata = null;
        this._sdata = null;
        this._sprite = 0;
        this._crt_anim = 0;
        this._crt_aframe = 0;
        this._crt_aframe_time = 0;
        this._orientation = 0;
        this._tooltipDelta = 0;
        this._tooltipTxt = 0;
    }

    public Entity(int n, int n2) {
        this._arrayIndex = (short)n;
        this._type = -1;
        this.EntityConstructor(n2);
    }

    public void Release() {
        this._type = -1;
        this._id = 0;
        this._flags = 0;
        this._pos_x = 0;
        this._pos_y = 0;
        this._z_order = 0;
        this._timer = 0;
        this._idata = null;
        this._sdata = null;
        this._sprite = 0;
        this._crt_anim = 0;
        this._crt_aframe = 0;
        this._crt_aframe_time = 0;
        this._orientation = 0;
        this._tooltipDelta = 0;
        this._tooltipTxt = 0;
    }

    public void EntityConstructor(int n) {
        if (this._type != n) {
            this.Release();
            switch (n) {
                case 103: {
                    this._sdata = new short[16];
                    break;
                }
                case 104: {
                    this._sdata = new short[2];
                    break;
                }
                case 9: {
                    this._sdata = new short[2];
                    break;
                }
                case 105: {
                    this._sdata = new short[4];
                    break;
                }
                case 10: {
                    this._idata = new int[1];
                    break;
                }
                case 11: {
                    this._sdata = new short[6];
                    this._idata = new int[16];
                    break;
                }
                case 109: {
                    this._sdata = new short[6];
                    break;
                }
                case 106: {
                    this._idata = new int[6];
                    break;
                }
                case 110: 
                case 111: {
                    this._sdata = new short[16];
                    break;
                }
                case 112: {
                    this._idata = new int[2 + Level.GetSWStats(2, 3)];
                    break;
                }
                case 113: {
                    this._sdata = new short[6];
                    break;
                }
                case 114: {
                    this._sdata = new short[3];
                    break;
                }
                case 115: {
                    this._sdata = new short[8];
                    break;
                }
                case 13: {
                    this._sdata = new short[5];
                    this._sdata[4] = 0;
                    break;
                }
                case 2: {
                    this._idata = new int[2];
                    this._idata[0] = -1;
                    this._idata[1] = 0;
                }
            }
        }
        this._type = n;
        this._state = -1;
        this._sprite = -1;
        this._flags = 0;
    }

    public void EntityDestructor() {
        if (this._type == -1) {
            return;
        }
        this._id = 0;
        switch (this._type) {
            case 6: {
                ((Building)this).Building_Destructor();
                break;
            }
            case 5: {
                ((Unit)this).Unit_Destructor();
            }
        }
    }

    public void Load(SDKInputStream sDKInputStream) throws IOException {
        this._id = sDKInputStream.readShort();
        short s = sDKInputStream.readShort();
        short s2 = sDKInputStream.readShort();
        this.SetPosition(s, s2);
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_Load(sDKInputStream);
                break;
            }
            case 6: {
                ((Building)this).Building_Load(sDKInputStream);
                break;
            }
            case 7: {
                this._state = sDKInputStream.read();
                break;
            }
            case 8: {
                this._state = sDKInputStream.read();
                this._flags |= sDKInputStream.read();
                break;
            }
            case 9: {
                this._sdata[0] = sDKInputStream.readShort();
                this._sdata[1] = sDKInputStream.readShort();
                break;
            }
            case 0: 
            case 1: {
                this._sprite = sDKInputStream.read();
                this._crt_anim = sDKInputStream.read();
                this._flags |= sDKInputStream.read();
                this._z_order = sDKInputStream.read();
                if (this._type != 1) break;
                this._crt_aframe = sDKInputStream.read();
                break;
            }
            case 2: {
                this._sprite = sDKInputStream.read();
                this._crt_anim = sDKInputStream.read();
                this._flags |= sDKInputStream.read();
                this._z_order = sDKInputStream.read();
                break;
            }
            case 10: {
                this._idata[0] = sDKInputStream.readInt() & 0xFFFF;
                break;
            }
            case 11: {
                this.GarrisonBld_Load(sDKInputStream);
                break;
            }
            case 13: {
                this._sdata[0] = (byte)sDKInputStream.read();
                this._sdata[1] = (byte)sDKInputStream.read();
                this._sdata[2] = this._sdata[3] = (short)(sDKInputStream.readShort() & 0xFFFF);
            }
        }
    }

    public void Init() {
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_Init();
                break;
            }
            case 6: {
                ((Building)this).Building_Init();
                break;
            }
            case 7: {
                this._z_order = 3;
                this._sprite = 14;
                break;
            }
            case 8: {
                this._sprite = 4;
                this._z_order = 2;
                break;
            }
            case 9: {
                this.BridgeCmdPost_Init();
                break;
            }
            case 10: {
                this.MField_Init();
                break;
            }
            case 11: {
                this.GarrisonBld_Init();
                break;
            }
            case 13: {
                this.TechBuilding_Init();
            }
        }
    }

    public void Init2() {
        switch (this._type) {
            case 2: {
                break;
            }
            case 5: {
                ((Unit)this).Unit_Init2();
                break;
            }
            case 6: {
                ((Building)this).Building_Init2();
                break;
            }
            case 8: {
                this.Bridge_Init2();
                break;
            }
            case 9: {
                this.SetCrtAnim(2);
                break;
            }
            case 10: {
                this.MField_Init2();
                break;
            }
            case 11: {
                this.GarrisonBld_Init2();
                break;
            }
            case 13: {
                this.TechBuilding_Init2();
            }
        }
    }

    public void Update() {
        if ((this._flags & 8) != 0) {
            return;
        }
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_Update();
                break;
            }
            case 6: {
                ((Building)this).Building_Update();
                break;
            }
            case 103: {
                this.Bullet_Update();
                break;
            }
            case 104: {
                this.Lightning_Update();
                break;
            }
            case 105: {
                this.IGMessage_Update();
                break;
            }
            case 2: {
                this.AnimDecorator_Update();
                break;
            }
            case 7: {
                this.Barrel_Update();
                break;
            }
            case 10: {
                this.MField_Update();
                break;
            }
            case 106: {
                this.Nuke_Update();
                break;
            }
            case 11: {
                this.GarrisonBld_Update();
                break;
            }
            case 107: {
                break;
            }
            case 109: {
                this.Laser_Update();
                break;
            }
            case 110: 
            case 111: {
                this.Kirov_Harrier_Update();
                break;
            }
            case 112: {
                this.IronCurtain_Update();
                break;
            }
            case 113: {
                this.Sniper_Update();
                break;
            }
            case 114: {
                this.StormBolt_Update();
                break;
            }
            case 115: {
                this.Storm_Update();
                break;
            }
            case 13: {
                this.TechBuilding_Update();
                break;
            }
            case 117: {
                break;
            }
            default: {
                if ((this._flags & 0x80) == 0 || this._sprite < 0) break;
                this.UpdateCrtAnim();
            }
        }
    }

    public void Draw(SDKGraphics sDKGraphics) {
        if ((this._flags & 0x10) != 0) {
            return;
        }
        switch (this._type) {
            case 5: {
                if (GameImpl._useFog) {
                    Unit unit = (Unit)this;
                    if (!(unit._FOW_visible || unit._allegiance != 0 && Level.FOW_PercentageVisible(this.ComputeDefaultBoundingBox()) < 40)) {
                        unit._FOW_visible = true;
                    }
                    if (!unit._FOW_visible) break;
                    unit.Unit_Draw(sDKGraphics);
                    break;
                }
                ((Unit)this).Unit_Draw(sDKGraphics);
                break;
            }
            case 6: {
                if (GameImpl._useFog) {
                    Building building = (Building)this;
                    if (!(building._FOW_visible || building._allegiance != 0 && Level.FOW_PercentageVisible(this.ComputeDefaultBoundingBox()) < 40)) {
                        building._FOW_visible = true;
                    }
                    if (!((Building)this)._FOW_visible) break;
                    ((Building)this).Building_Draw(sDKGraphics);
                    break;
                }
                ((Building)this).Building_Draw(sDKGraphics);
                break;
            }
            case 103: {
                this.Bullet_Draw(sDKGraphics);
                break;
            }
            case 104: {
                this.Lightning_Draw(sDKGraphics);
                break;
            }
            case 105: {
                this.IGMessage_Draw(sDKGraphics);
                break;
            }
            case 1: {
                Sprites._sprites[this._sprite].SetCurrentPalette(this._crt_aframe);
                this.Decorator_Draw(sDKGraphics);
                Sprites._sprites[this._sprite].SetCurrentPalette(0);
                break;
            }
            case 0: {
                this.Decorator_Draw(sDKGraphics);
                break;
            }
            case 10: {
                this.MField_Draw(sDKGraphics);
                break;
            }
            case 106: {
                this.Nuke_Draw(sDKGraphics);
                break;
            }
            case 11: {
                this.GarrisonBld_Draw(sDKGraphics);
                break;
            }
            case 107: {
                break;
            }
            case 109: {
                this.Laser_Draw(sDKGraphics);
                break;
            }
            case 110: 
            case 111: {
                this.Kirov_Harrier_Draw(sDKGraphics);
                break;
            }
            case 113: {
                this.Sniper_Draw(sDKGraphics);
                break;
            }
            case 114: {
                this.StormBolt_Draw(sDKGraphics);
                break;
            }
            case 115: {
                this.Storm_Draw(sDKGraphics);
                break;
            }
            case 13: {
                this.TechBuilding_Draw(sDKGraphics);
                break;
            }
            case 14: {
                this.BuildingBase_Draw(sDKGraphics);
                break;
            }
            case 117: {
                break;
            }
            case 7: {
                this.Barrel_Draw(sDKGraphics);
                break;
            }
            case 2: {
                this.AnimDecorator_Draw(sDKGraphics);
                break;
            }
            default: {
                this.DrawCrtAnim(sDKGraphics);
            }
        }
    }

    public void DrawTooltip(SDKGraphics sDKGraphics) {
        int n;
        int n2 = 120;
        boolean bl = false;
        switch (this._type) {
            case 9: {
                bl = true;
                this._tooltipDelta = 0;
                for (n = 0; n <= 1; ++n) {
                    if (this._sdata[n] == -1) continue;
                    Entity entity = Level.GetEntityUnsafe(this._sdata[n]);
                    this._tooltipTxt = entity._state == 1 ? 109 : 110;
                }
                _descr_string = SDKUtils.getString(this._tooltipTxt, _descr_string);
                break;
            }
            case 13: {
                bl = true;
                if (this._sdata[1] != 2) {
                    return;
                }
                this._tooltipDelta = 94;
                this._tooltipTxt = 103 + this._sdata[0];
                _descr_string = SDKUtils.getString(this._tooltipTxt, _descr_string);
                break;
            }
            case 10: {
                bl = Level.FOW_IsDiscovered(this._pos_x, this._pos_y);
                this._tooltipDelta = 75;
                this._tooltipTxt = 117;
                _descr_string = SDKUtils.getString(this._tooltipTxt, _descr_string);
                _descr_string = _descr_string.concat(this._idata[0]);
                break;
            }
            case 6: {
                this._tooltipDelta = 30;
                this._tooltipTxt = 40 + ((Building)this)._faction * 10 + ((Building)this)._subtype;
                _descr_string = SDKUtils.getString(this._tooltipTxt, _descr_string);
            }
        }
        if (bl && Cursor._targetPointer == this.GetPointer() || this._type == 6) {
            int n3 = 0;
            n3 = this._pos_x < n2 >> 1 ? (n2 >> 1) + 2 : (this._pos_x > Map._map_w - (n2 >> 1) ? GameImpl.SCR_W - (n2 >> 1) - 2 : this._pos_x - Camera._nCamX + GameImpl.SV_X);
            n = this._pos_y - Camera._nCamY + GameImpl.SV_Y - this._tooltipDelta;
            SDKUtils.setFont(GameImpl.fonts[4]);
            _txtDescrStringLines = SDKUtils.wrapString(_descr_string, _txtDescrStringLines, n2, (short)124);
            SDKUtils.drawWrappedString(_descr_string, _txtDescrStringLines, 1, _txtDescrStringLines[0], n3, n, 1);
        }
    }

    static void XSPRITE_ANIM__() {
    }

    public void SetCrtAnim(int n) {
        this._crt_anim = n;
        this._crt_aframe = 0;
        XSprite xSprite = Sprites._sprites[this._sprite];
        this._crt_aframe_time = xSprite.GetAnimFrameTime(this._crt_anim, this._crt_aframe);
        this._flags &= 0xFFFFFFDF;
    }

    public void UpdateCrtAnim() {
        if (this._crt_aframe_time == 0 || (this._flags & 0x820) == 2080) {
            return;
        }
        this._flags &= 0xFFFFFFDF;
        --this._crt_aframe_time;
        if (this._crt_aframe_time <= 0) {
            XSprite xSprite = Sprites._sprites[this._sprite];
            ++this._crt_aframe;
            if (this._crt_aframe >= xSprite.GetAnimLength(this._crt_anim)) {
                this._crt_aframe = (this._flags & 0x800) != 0 ? --this._crt_aframe : 0;
                this._flags |= 0x20;
            }
            this._crt_aframe_time = xSprite.GetAnimFrameTime(this._crt_anim, this._crt_aframe);
        }
    }

    public boolean IsCrtAnimEnded() {
        return this._crt_aframe_time == 0 || (this._flags & 0x20) != 0;
    }

    public void DrawCrtAnim(SDKGraphics sDKGraphics) {
        if (this._sprite < 0) {
            return;
        }
        int n = this._pos_x - Camera._nCamX;
        int n2 = this._pos_y - Camera._nCamY;
        if ((this._flags & 0x2000) == 0) {
            n += GameImpl.SV_X;
            n2 += GameImpl.SV_Y;
        }
        XSprite xSprite = Sprites._sprites[this._sprite];
        if (this._type == 103) {
            if (this._sdata[2] == 9 || this._sdata[2] == 13) {
                xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n, n2 - this._sdata[13], this._flags & 7);
            } else if (this._sdata[2] == 10) {
                xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n, n2 - this._sdata[13], this._flags & 7);
            } else {
                xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n, n2, this._flags & 7);
            }
        } else {
            xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n, n2, this._flags & 7);
        }
    }

    static void __XSPRITE_ANIM() {
    }

    public void MarkUsedSprite() {
        int n = 1;
        block0 : switch (this._type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                if (this._sprite < 0) break;
                Sprites._sprites[this._sprite]._flags |= 0x400 | n;
                break;
            }
            case 6: {
                n = ((Building)this).GetUsedPalette();
                if (this._sprite < 0) break;
                int n2 = 0;
                int n3 = Sprites._spritePalCount[this._sprite];
                for (int i = 0; i < 3 && i < n3; ++i) {
                    if ((Sprites._sprites[this._sprite]._flags & 1 << i) == 0) continue;
                    ++n2;
                }
                if (n2 != n && (Sprites._sprites[this._sprite]._flags & 0x800) != 0) {
                    Sprites._sprites[this._sprite].Release();
                }
                Sprites._sprites[this._sprite]._flags |= 0x400 | n;
                break;
            }
            case 5: {
                n = ((Unit)this).GetUsedPalette();
                switch (((Unit)this)._subtype) {
                    case 4: {
                        Sprites._sprites[this._sprite]._flags |= 0x403;
                        break block0;
                    }
                    case 5: {
                        Sprites._sprites[this._sprite]._flags |= 0x403;
                        break block0;
                    }
                }
                if (this._sprite < 0) break;
                int n4 = 0;
                int n5 = Sprites._spritePalCount[this._sprite];
                for (int i = 0; i < 3 && i < n5; ++i) {
                    if ((Sprites._sprites[this._sprite]._flags & 1 << i) == 0) continue;
                    ++n4;
                }
                if (n4 != n && (Sprites._sprites[this._sprite]._flags & 0x800) != 0) {
                    Sprites._sprites[this._sprite].Release();
                }
                Sprites._sprites[this._sprite]._flags |= 0x400 | n;
                break;
            }
            case 7: {
                Sprites._sprites[14]._flags |= 0x400 | n;
                Sprites._sprites[24]._flags |= 0x400 | n;
            }
        }
    }

    public int[] ComputeBoundingBox() {
        XSprite xSprite = Sprites._sprites[this._sprite];
        switch (this._type) {
            default: 
        }
        xSprite.RectFrame(xSprite.GetAnimFrameId(this._crt_anim, this._crt_aframe), this._pos_x, this._pos_y, 0);
        return XSprite._rect;
    }

    public int[] ComputeDefaultBoundingBox() {
        XSprite xSprite = Sprites._sprites[this._sprite];
        switch (this._type) {
            default: 
        }
        xSprite.RectFrame(xSprite.GetAnimFrameId(this._crt_anim, 0), this._pos_x, this._pos_y, 0);
        return XSprite._rect;
    }

    public int[] GetCollisionRect(boolean bl) {
        if ((this._flags & 0x58) != 0) {
            return null;
        }
        switch (this._type) {
            default: 
        }
        return null;
    }

    public int GetLife() {
        switch (this._type) {
            case 5: {
                return ((Unit)this)._life;
            }
            case 6: {
                return ((Building)this)._life;
            }
            case 7: {
                return 1;
            }
            case 11: {
                if (this.GarrisonBld_IsOccupied()) {
                    return this._sdata[2];
                }
                return 0;
            }
            case 13: {
                return this._sdata[3];
            }
        }
        return 0;
    }

    public int GetPointer() {
        return (this._uid & 0xFFFF) << 16 | this._arrayIndex & 0xFFFF;
    }

    public void SetPosition(int n, int n2) {
        if (this._type == 5) {
            int n3 = this._pos_x;
            int n4 = this._pos_y;
            this._pos_x = n;
            this._pos_y = n2;
            UtilEntity.CheckTriggers((Unit)this, n3, n4);
        } else {
            this._pos_x = n;
            this._pos_y = n2;
        }
    }

    void SetState(int n) {
    }

    public int Move(int n, boolean bl) {
        int n2;
        int n3 = this._sdata[0];
        int n4 = this._sdata[1];
        int n5 = n3 - this._pos_x;
        int n6 = n4 - this._pos_y;
        int n7 = Math.abs(n5);
        int n8 = n7 + (n2 = Math.abs(n6));
        if (n8 <= 4) {
            if (bl && Map.GetCollisionAt(n3, n4) > 10) {
                return 2;
            }
            this._pos_x = n3;
            this._pos_y = n4;
            return 1;
        }
        this._orientation = this.GetOrientation(n5, n6);
        if (n8 <= n) {
            if (bl && Map.GetCollisionAt(n3, n4) > 10) {
                return 2;
            }
            this._pos_x = n3;
            this._pos_y = n4;
            return 1;
        }
        n8 = n7 > n2 ? n7 : n2;
        n5 = (n5 * n << 6) / n8;
        n6 = (n6 * n << 6) / n8;
        int n9 = (this._pos_x << 6) + n5 >> 6;
        int n10 = (this._pos_y << 6) + n6 >> 6;
        if (bl && Map.GetCollisionAt(n9, n10) > 10) {
            return 2;
        }
        this._pos_x = n9;
        this._pos_y = n10;
        return 0;
    }

    public byte TurnTowards(byte by, byte by2) {
        if (by2 == by) {
            return by2;
        }
        by2 = by2 > by ? (by2 - by < 7 - by2 + by ? (byte)(by2 - 1) : (byte)(by2 + 1)) : (by - by2 < 7 - by + by2 ? (byte)(by2 + 1) : (byte)(by2 - 1));
        if (by2 > 7) {
            by2 = 0;
        }
        if (by2 < 0) {
            by2 = (byte)7;
        }
        return by2;
    }

    public byte GetOrientation(int n, int n2) {
        if (Math.abs(n) >= Math.abs(n2)) {
            if (n >= 0) {
                if (Math.abs(n) >= Math.abs(n2 << 1)) {
                    return 2;
                }
                if (n2 >= 0) {
                    return 3;
                }
                return 1;
            }
            if (Math.abs(n) >= Math.abs(n2 << 1)) {
                return 6;
            }
            if (n2 >= 0) {
                return 5;
            }
            return 7;
        }
        if (n2 >= 0) {
            if (Math.abs(n2) >= Math.abs(n << 1)) {
                return 4;
            }
            if (n >= 0) {
                return 3;
            }
            return 5;
        }
        if (Math.abs(n2) >= Math.abs(n << 1)) {
            return 0;
        }
        if (n >= 0) {
            return 1;
        }
        return 7;
    }

    public void TakeDamage(int n, int n2, int n3) {
        if (n < 0) {
            return;
        }
        Level.SoundSwitch();
        switch (this._type) {
            case 5: {
                ((Unit)this).Unit_TakeDamage(n, n2, n3);
                break;
            }
            case 6: {
                ((Building)this).TakeDamage(n, n2, n3);
                break;
            }
            case 7: {
                this.Barrel_TakeDamage(n3);
                break;
            }
            case 8: {
                this.Bridge_TakeDamage(n, n2, n3);
                break;
            }
            case 11: {
                this.GarrisonBld_TakeDamage(n, n2, n3);
                break;
            }
            case 13: {
                this.TechBuilding_TakeDamage(n, n2, n3);
            }
        }
    }

    Entity FindTarget(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        Entity entity;
        int n9;
        int n10 = -1;
        int n11 = -1;
        boolean bl = true;
        if (n == 2) {
            return null;
        }
        for (n9 = 0; n9 < 64; ++n9) {
            if (Level._entities_usage[n9] != 1) continue;
            entity = (Unit)Level._entities[n9];
            if (((Unit)entity)._garrisonBuilding != -1 || ((Unit)entity)._allegiance == n || ((Unit)entity)._allegiance == 2 || ((Unit)entity)._life <= 0 || (entity._flags & 0x8000) != 0 || (n8 = (n7 = Math.abs(entity._pos_x - this._pos_x)) + (n6 = Math.abs(entity._pos_y - this._pos_y))) >= n2 || !Entity.CanAttack(entity, this)) continue;
            if (((Unit)entity)._stealth_timer >= 16) {
                if (n7 >= 48 || n6 >= 24) continue;
                ((Unit)entity)._stealth_timer = 0;
                return entity;
            }
            if (!Map.NoLineOfSightCollisionBetween(this, entity, n5)) continue;
            if (n4 == 5) {
                Entity entity2 = Level.GetEntitySafe(((Unit)entity)._targetPointer);
                if (entity2 == null || entity2._type != 5 || ((Unit)entity2)._subtype != 5) continue;
                Encyclopedia.SetStealth();
            }
            int n12 = this.GetTargetScore(entity, n2, n3, n8, n5);
            if (n10 >= 0 && n12 >= n10) continue;
            n10 = n12;
            n11 = n9;
            ((Unit)entity)._requested_action = false;
        }
        if (n4 >= 0) {
            switch (n4) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 12: {
                    bl = false;
                }
            }
        }
        if (bl) {
            for (n9 = 64; n9 < 160; ++n9) {
                if (Level._entities_usage[n9] != 1) continue;
                entity = (Building)Level._entities[n9];
                if (((Building)entity)._allegiance == n || ((Building)entity)._allegiance == 2 || ((Building)entity)._life <= 0 || (entity._flags & 0x8000) != 0 || (n7 = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y)) >= n2 || !Map.NoLineOfSightCollisionBetween(this, entity, n5)) continue;
                n6 = this.GetTargetScore(entity, n2, n3, n7, n5);
                if (n10 >= 0 && n6 >= n10) continue;
                n10 = n6;
                n11 = n9;
            }
            for (n9 = 160; n9 < 416; ++n9) {
                if (Level._entities_usage[n9] != 1) continue;
                entity = Level._entities[n9];
                if (entity._type == 11) {
                    if (entity.GarrisonBld_IsFriendly(n) || (n7 = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y)) >= n2) continue;
                    n6 = this.GetTargetScore(entity, n2, n3, n7, n5);
                    if (n10 >= 0 && n6 >= n10) continue;
                    n10 = n6;
                    n11 = n9;
                    continue;
                }
                if (entity._type != 13 || (n7 = entity._sdata[1]) == 2 || n7 == n || (n6 = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y)) >= n2) continue;
                n8 = this.GetTargetScore(entity, n2, n3, n6, n5);
                if (n10 >= 0 && n8 >= n10) continue;
                n10 = n8;
                n11 = n9;
            }
        }
        if (n11 != -1) {
            return Level._entities[n11];
        }
        return null;
    }

    public static boolean CanAttack(Entity entity, Entity entity2) {
        if (entity2 == null || entity == null) {
            return false;
        }
        if (entity2._type == 6) {
            return entity._type == 5 || entity._type == 6;
        }
        if (entity2._type != 5) {
            return false;
        }
        int n = Level.GetUnitStats(((Unit)entity2)._subtype, 26);
        switch (entity._type) {
            case 5: {
                Unit unit = (Unit)entity;
                if ((unit._attack_capabilities & 0x100) != 0) {
                    return (n & 2) != 0;
                }
                return (n & 1) != 0;
            }
            case 6: {
                return (n & 2) != 0;
            }
            case 7: {
                return (n & 0x10) != 0;
            }
            case 11: {
                return (n & 0x20) != 0;
            }
        }
        return false;
    }

    private int GetTargetScore(Entity entity, int n, int n2, int n3, int n4) {
        Entity entity2;
        int n5 = 0;
        byte by = 1;
        if (this._type == 5) {
            entity2 = (Unit)this;
            n5 = entity2._subtype * 19;
        } else if (this._type == 6) {
            entity2 = (Building)this;
            switch (((Building)entity2)._subtype) {
                case 5: {
                    n5 = 304;
                    break;
                }
                case 6: {
                    n5 = 285;
                }
            }
        }
        switch (entity._type) {
            case 5: {
                entity2 = (Unit)entity;
                by = Level._attack_priorities[n5 + entity2._subtype];
                break;
            }
            case 6: {
                Building building = (Building)entity;
                switch (building._subtype) {
                    case 5: {
                        by = Level._attack_priorities[n5 + 16];
                        break;
                    }
                    case 6: {
                        by = Level._attack_priorities[n5 + 15];
                    }
                }
                break;
            }
            case 11: {
                by = Level._attack_priorities[n5 + 17];
                break;
            }
            case 13: {
                by = Level._attack_priorities[n5 + 18];
            }
        }
        if (Map.NoLineOfSightCollisionBetween(this, entity, n4)) {
            if (n3 < n2) {
                return (n2 << 6) / by;
            }
            return (n3 << 6) / by;
        }
        return (n2 + n3 << 6) / by;
    }

    public boolean Garrison(Entity entity) {
        switch (this._type) {
            case 9: {
                this.BridgeCmdPost_EngineerEntered();
                return true;
            }
            case 11: {
                this.GarrisonBld_AddUnit(entity);
                break;
            }
            case 13: {
                return this.TechBuilding_Garrison((Unit)entity);
            }
            case 6: {
                this.Building_EngineerEntered((Unit)entity);
                return true;
            }
        }
        return false;
    }

    public boolean Demolish(Unit unit) {
        Building building = (Building)this;
        switch (unit._subtype) {
            case 4: 
            case 5: {
                Encyclopedia.SetBigBrain();
                Level._buildings_off_times[building._allegiance][building._subtype] = (short)Level.GetBuildingStats(building._faction, building._subtype, 19);
                return true;
            }
            case 6: {
                building._life = 0;
                building.SetState(3);
                return true;
            }
        }
        return false;
    }

    public static void ANIM_DECORATOR__() {
    }

    public void Decorator_Init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this._pos_x = n;
        this._pos_y = n2;
        this._sprite = n3;
        this._crt_anim = n4;
        this._flags = n5;
        this._z_order = n6;
        if (this._type == 2) {
            this._crt_aframe = 0;
            this._crt_aframe_time = 0;
            this._idata[0] = n7;
            this._idata[1] = n8;
        }
        this.Init2();
    }

    public void AnimDecorator_Update() {
        int n = this._idata[0];
        int n2 = this._idata[1];
        if (n2 >= 0) {
            if (n2 == 0) {
                this.SetCrtAnim(this._crt_anim);
            }
        } else {
            this.UpdateCrtAnim();
            if ((this._flags & 0x200) != 0 && this.IsCrtAnimEnded()) {
                Level.DeleteEntity(this);
            }
        }
        this._idata[1] = --n2;
    }

    public void AnimDecorator_Draw(SDKGraphics sDKGraphics) {
        if (this._idata[1] >= 0) {
            return;
        }
        this.DrawCrtAnim(sDKGraphics);
    }

    public void Decorator_Draw(SDKGraphics sDKGraphics) {
        int n = this._pos_x - Camera._nCamX;
        int n2 = this._pos_y - Camera._nCamY;
        if ((this._flags & 0x2000) == 0) {
            n += GameImpl.SV_X;
            n2 += GameImpl.SV_Y;
        }
        Sprites._sprites[this._sprite].DrawFrame(this._crt_anim, n, n2, this._flags & 7);
    }

    public static void __ANIM_DECORATOR() {
    }

    public void BuildingBase_Init(int n, int n2, int n3, int n4, int n5, int n6) {
        this._pos_x = n;
        this._pos_y = n2;
        this._sprite = n3;
        this._crt_anim = n4;
        this._flags = n5;
        this._z_order = n6;
    }

    public void BuildingBase_Draw(SDKGraphics sDKGraphics) {
        if ((this._flags & 0x10) != 0) {
            return;
        }
        int n = this._pos_x - Camera._nCamX + GameImpl.SV_X;
        int n2 = this._pos_y - Camera._nCamY + GameImpl.SV_Y;
        Sprites._sprites[this._sprite].DrawFrame(this._crt_anim, n, n2, this._flags & 7);
    }

    static void BULLET__() {
    }

    public void Bullet_Init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this._z_order = 3;
        this._pos_x = n3;
        this._pos_y = n4;
        this._sdata[0] = (short)n5;
        this._sdata[1] = (short)n6;
        this._sdata[2] = (short)n;
        this._sdata[3] = (short)n2;
        this._sdata[4] = (short)n8;
        this._sdata[5] = (short)Level.GetBulletStats(n, 2);
        this._sdata[6] = (short)Level.GetBulletStats(n, 3);
        this._sdata[7] = (short)(n7 & 0xFFFF);
        this._sdata[8] = (short)(n7 >> 16);
        this._sdata[9] = (short)(n9 & 0xFFFF);
        this._sdata[10] = (short)(n9 >> 16);
        this._sdata[15] = 0;
        switch (n) {
            case 9: 
            case 13: {
                this._sdata[0] = (short)(n5 + Utils.random(-14, 14));
                this._sdata[1] = (short)(n6 + Utils.random(-14, 14));
                this._sdata[13] = 0;
                this._sdata[11] = 1;
                int n10 = Math.abs(n5 - n3);
                int n11 = Math.abs(n6 - n4);
                int n12 = n10 > n11 ? n10 : n11;
                this._sdata[12] = (short)Utils.GetInitialSpeed(n12 / this._sdata[5], this._sdata[11]);
                Entity entity = Level.SpawnEntity(107);
                if (entity != null) {
                    entity.InitParticle((short)0, n3, n4, 0);
                    this._sdata[14] = entity._arrayIndex;
                } else {
                    this._sdata[14] = -1;
                }
                this._sprite = 12;
                this.SetCrtAnim(20);
                this._flags &= 0xFFFFF7FF;
                break;
            }
            case 10: {
                this._sdata[13] = 0;
                this._sdata[11] = 0;
                int n13 = Math.abs(n5 - n3);
                int n14 = Math.abs(n6 - n4);
                int n15 = n13 > n14 ? n13 : n14;
                this._sdata[12] = (short)Utils.GetInitialSpeed(n15 / this._sdata[5], this._sdata[11]);
                Entity entity = Level.SpawnEntity(107);
                if (entity != null) {
                    entity.InitParticle((short)1, n3, n4, 0);
                    this._sdata[14] = entity._arrayIndex;
                } else {
                    this._sdata[14] = -1;
                }
                this._sprite = 12;
                this.SetCrtAnim(21);
                this._flags &= 0xFFFFF7FF;
                break;
            }
            case 6: {
                Entity entity = Level.SpawnEntity(107);
                if (entity != null) {
                    entity.InitParticle((short)2, n3, n4, 0);
                    this._sdata[14] = entity._arrayIndex;
                } else {
                    this._sdata[14] = -1;
                }
                this._sprite = 36;
                int n16 = n5 - n3;
                int n17 = n6 - n4;
                this._orientation = this.GetOrientation(n16, n17);
                break;
            }
            case 12: {
                this._sprite = Level.GetBulletStats(n, 4);
                this.SetCrtAnim(Level.GetBulletStats(n, 5));
                this._z_order = 5;
                break;
            }
            default: {
                this._sprite = Level.GetBulletStats(n, 4);
                this.SetCrtAnim(Level.GetBulletStats(n, 5));
            }
        }
    }

    private void Bullet_Update() {
        Entity entity;
        short s = this._sdata[2];
        boolean bl = this._sdata[15] == 1;
        switch (s) {
            case 9: 
            case 10: 
            case 13: {
                if (this._sdata[14] >= 0) {
                    entity = Level.GetEntityUnsafe(this._sdata[14]);
                    entity.ParticleGroup_Trail_Update(this._pos_x, this._pos_y, this._sdata[13]);
                }
                if (bl) break;
                this.UpdateCrtAnim();
                this._sdata[13] = (short)(this._sdata[13] + this._sdata[12]);
                this._sdata[12] = (short)(this._sdata[12] - this._sdata[11]);
                break;
            }
            case 12: {
                if (bl) break;
                this.UpdateCrtAnim();
                break;
            }
            case 6: {
                if (this._sdata[14] < 0) break;
                entity = Level.GetEntityUnsafe(this._sdata[14]);
                entity.ParticleGroup_Trail_Update(this._pos_x, this._pos_y, 0);
            }
        }
        if (this.Move(this._sdata[5], false) == 1 && !bl) {
            int n;
            int n2 = Level.GetBulletStats(s, 1);
            int n3 = this._sdata[9] & 0xFFFF | this._sdata[10] << 16;
            int n4 = this._sdata[7] & 0xFFFF | this._sdata[8] << 16;
            Entity entity2 = Level.GetEntitySafe(n4);
            if (entity2 != null) {
                entity2.TakeDamage(this._sdata[4], n2, n3);
            }
            if (this._sdata[6] > 0) {
                Level.DoSplashDamage(this._pos_x, this._pos_y, this._sdata[6], this._sdata[4], n2, n3);
            }
            if ((n = Level.GetBulletStats(s, 7)) >= 0) {
                Entity entity3 = Level.SpawnEntity(2);
                if (entity3 != null) {
                    entity3.Decorator_Init(this._pos_x, this._pos_y, Level.GetBulletStats(s, 6), n, 512, 4, -1, 0);
                }
                if (GameImpl._vibrationsEnable && Level._skipMovieState == 0) {
                    if (s == 13) {
                        GameImpl._soundManager.vibrate(300);
                    } else if (s == 12) {
                        GameImpl._soundManager.vibrate(100);
                    }
                }
            }
            this._sdata[15] = 1;
            bl = true;
        }
        if (!bl) {
            return;
        }
        if (s == 9 || s == 13 || s == 10 || s == 6) {
            if (this._sdata[14] >= 0) {
                entity = Level.GetEntityUnsafe(this._sdata[14]);
                if (entity.ParticleGroup_IsFinished()) {
                    Level.DeleteEntity(entity);
                    Level.DeleteEntity(this);
                }
            } else {
                Level.DeleteEntity(this);
            }
        } else {
            Level.DeleteEntity(this);
        }
    }

    private void Bullet_Draw(SDKGraphics sDKGraphics) {
        short s = this._sdata[2];
        Entity entity = null;
        switch (s) {
            case 0: {
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                this.DrawCrtAnim(sDKGraphics);
                break;
            }
            case 2: {
                break;
            }
            case 15: {
                break;
            }
            case 3: {
                break;
            }
            case 9: 
            case 13: {
                int n = this._sdata[0] - this._pos_x;
                int n2 = this._sdata[1] - this._pos_y;
                short s2 = this._sdata[13];
                int n3 = Utils.GetOrientation2(n, n2, this._sdata[12]);
                XSprite xSprite = Sprites._sprites[this._sprite];
                if (n3 != 16) {
                    xSprite.DrawFrame(26 + n3, this._pos_x + GameImpl.SV_X - Camera._nCamX, this._pos_y + GameImpl.SV_Y - Camera._nCamY - s2, 0);
                }
                if (this._sdata[14] >= 0) {
                    entity = Level.GetEntityUnsafe(this._sdata[14]);
                    entity.ParticleGroup_Trail_Draw(sDKGraphics);
                }
                this.DrawCrtAnim(sDKGraphics);
                break;
            }
            case 10: {
                int n = this._sdata[0] - this._pos_x;
                int n4 = this._sdata[1] - this._pos_y;
                short s3 = this._sdata[13];
                byte by = this.GetOrientation(n, n4);
                sDKGraphics.setColor(0);
                sDKGraphics.drawLine(this._pos_x + GameImpl.SV_X - Camera._nCamX, this._pos_y + GameImpl.SV_Y - Camera._nCamY - s3, this._pos_x + GameImpl.SV_X - Camera._nCamX + Utils._versorX[by] * 7, this._pos_y + GameImpl.SV_Y - Camera._nCamY - s3 + Utils._versorY[by] * 7);
                if (this._sdata[14] >= 0) {
                    entity = Level.GetEntityUnsafe(this._sdata[14]);
                    entity.ParticleGroup_Trail_Draw(sDKGraphics);
                }
                this.DrawCrtAnim(sDKGraphics);
                break;
            }
            case 6: {
                if (this._sdata[14] >= 0) {
                    entity = Level.GetEntityUnsafe(this._sdata[14]);
                    entity.ParticleGroup_Trail_Draw(sDKGraphics);
                }
                XSprite xSprite = Sprites._sprites[this._sprite];
                xSprite.DrawFrame(4 + this._orientation, this._pos_x, this._pos_y, 0);
            }
        }
    }

    void FireBullet(int n, int n2, int n3, int n4, int n5, int n6) {
        Entity entity = Level.GetEntitySafe(n4);
        if (entity == null) {
            return;
        }
        if (this._type == 5) {
            Level.GetUnitFiringPosition(((Unit)this)._subtype, this._orientation);
        } else if (this._type == 6) {
            Level.GetBuildingFiringPosition(((Building)this)._subtype, ((Building)this)._faction, this._orientation);
        } else {
            Level._firingOffsetX = 0;
            Level._firingOffsetY = 0;
        }
        n5 += Level._firingOffsetX;
        n6 += Level._firingOffsetY;
        if (n3 < 0) {
            n3 = Level.GetBulletStats(n2, 0);
        }
        int n7 = 0;
        block0 : switch (n2) {
            case 0: 
            case 2: 
            case 7: 
            case 15: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                Entity entity2 = Level.SpawnEntity(2);
                if (entity2 == null) break;
                entity2.Decorator_Init(entity._pos_x, entity._pos_y - 5, 12, 1, 512, 4, -1, 0);
                break;
            }
            case 6: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                Entity entity3 = Level.SpawnEntity(113);
                if (entity3 == null) break;
                if (entity._type == 5 && Hud._hud_bars_hight == 0) {
                    Encyclopedia.SetSniper();
                }
                entity3.Sniper_Init(n2, n5, n6, entity._pos_x, entity._pos_y);
                break;
            }
            case 17: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                Entity entity4 = Level.SpawnEntity(113);
                if (entity4 == null) break;
                entity4.Sniper_Init(n2, n5, n6, entity._pos_x, entity._pos_y);
                break;
            }
            case 8: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                break;
            }
            case 3: 
            case 4: {
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                Entity entity5 = Level.SpawnEntity(104);
                if (entity5 == null) break;
                entity5.Lightning_Init(n5, n6, entity._pos_x, entity._pos_y);
                break;
            }
            case 11: {
                Unit unit = (Unit)this;
                Entity entity6 = Level.SpawnEntity(109);
                if (entity6 != null) {
                    entity6.Laser_Init(11, n5, n6, n4, false, 0, 0);
                }
                unit._gathered_damage = 0;
                entity.TakeDamage(n3 += unit._gathered_damage, n7, this.GetPointer());
                if (unit._proxyPointer == n4) break;
                int n8 = 4;
                for (int i = 0; i < 160; ++i) {
                    int n9;
                    if (Level._entities_usage[i] != 1) continue;
                    if (n8 <= 0) break block0;
                    Entity entity7 = Level.GetEntityUnsafe(i);
                    if (entity7._type == 5) {
                        Unit unit2 = (Unit)entity7;
                        if (unit2._life <= 0 || unit2._allegiance == n || unit2._allegiance == 2) {
                            continue;
                        }
                    } else if (entity7._type == 6) {
                        Building building = (Building)entity7;
                        if (building._life <= 0 || building._allegiance == n || building._allegiance == 2) continue;
                    }
                    if ((n9 = Math.abs(entity._pos_x - entity7._pos_x) + Math.abs(entity._pos_y - entity7._pos_y)) > Level.GetBulletStats(11, 3) || entity.GetPointer() == entity7.GetPointer()) continue;
                    Entity entity8 = Level.SpawnEntity(109);
                    if (entity8 != null) {
                        entity8.Laser_Init(11, entity._pos_x, entity._pos_y, entity7.GetPointer(), true, 0, 0);
                    }
                    if (this._type == 5) {
                        Unit unit3 = (Unit)this;
                        if (unit3._subtype == 11) {
                            int n10 = n3 * ((Unit)this)._splash_damage / 100;
                            entity7.TakeDamage(n10, n7, this.GetPointer());
                        }
                    }
                    --n8;
                }
                break;
            }
            case 16: {
                Building building;
                Entity entity9 = Level.SpawnEntity(109);
                if (entity._type == 6 && this._type == 6) {
                    building = (Building)this;
                    Building building2 = (Building)entity;
                    if (building._subtype == 5 && building._faction == 1 && building2._subtype == 5 && building2._faction == 1 && building2._allegiance == building._allegiance) {
                        Level.GetBuildingFiringPosition(5, 1, this.GetOrientation(-building2._pos_x + building._pos_x, -building2._pos_y + building._pos_y));
                        entity9.Laser_Init(16, n5, n6, n4, false, Level._firingOffsetX, Level._firingOffsetY);
                        return;
                    }
                }
                if (this._type == 6) {
                    building = (Building)this;
                    if (building._subtype == 5 && building._faction == 1) {
                        n3 *= building._prismTowers;
                    }
                }
                if (entity9 != null) {
                    entity9.Laser_Init(16, n5, n6, n4, false, 0, 0);
                }
                entity.TakeDamage(n3, n7, this.GetPointer());
                break;
            }
            case 14: {
                Entity entity10;
                n7 = Level.GetBulletStats(n2, 1);
                entity.TakeDamage(n3, n7, this.GetPointer());
                if (entity._type == 5) {
                    ((Unit)entity)._slow_timer = (short)14;
                }
                if ((entity10 = Level.SpawnEntity(2)) == null) break;
                entity10.Decorator_Init(entity._pos_x, entity._pos_y - 5, 12, 1, 512, 4, -1, 0);
                break;
            }
            default: {
                Entity entity11 = Level.SpawnEntity(103);
                if (entity11 == null) break;
                entity11.Bullet_Init(n2, n, n5, n6, entity._pos_x, entity._pos_y, n4, n3, this.GetPointer());
            }
        }
    }

    static void __BULLET() {
    }

    static void BARREL__() {
    }

    public void Barrel_Init2() {
        this.SetCrtAnim(0 + this._state);
    }

    private void Barrel_Update() {
        if (this._state < 0) {
            --this._timer;
            if (this._timer == 0) {
                int n = this._pos_x;
                int n2 = this._pos_y;
                for (short i = 0; i < 416; ++i) {
                    int n3;
                    if (Level._entities_usage[i] != 1 || i == this._arrayIndex) continue;
                    Entity entity = Level._entities[i];
                    if (entity._type == 5 && ((Unit)entity)._subtype == 6 || (n3 = Math.abs(entity._pos_x - n) + Math.abs(entity._pos_y - n2)) >= 75) continue;
                    entity.TakeDamage(-this._state * (100 - n3), 1, this.GetPointer());
                }
            } else if (this._timer < 0) {
                Level.DeleteEntity(this);
            }
        }
    }

    protected void CreateExplosion(int n, int n2, boolean bl, int n3, int n4, int n5) {
        int n6 = 0;
        Entity entity = Level.SpawnEntity(2);
        this._pos_x += n3;
        this._pos_y += n4;
        int n7 = -1;
        if (entity != null) {
            entity.Decorator_Init(this._pos_x, this._pos_y, 24, n6, 512, 4, n7, n5);
            while (n > 1) {
                int n8 = Utils.random(n >> 1, n << 1) + n5;
                int n9 = Utils.random(-n2, n2);
                int n10 = 0;
                n10 = n9 == n2 || n9 == -n2 ? 0 : (n3 > 0 ? Utils.random(-n2 + n9, n2 - n9) : Utils.random(-n2 - n9, n2 + n9));
                entity = Level.SpawnEntity(2);
                entity.Decorator_Init(this._pos_x + n9, this._pos_y + n10, 24, n6, 512, 4, -1, n8);
                --n;
            }
        }
        this._pos_x -= n3;
        this._pos_y -= n4;
    }

    private void Barrel_TakeDamage(int n) {
        if (this._state < 0) {
            return;
        }
        Entity entity = Level.GetEntitySafe(n);
        this._state = -this._state;
        if (entity._type == 7) {
            int n2 = Math.abs(entity._pos_x - this._pos_x) + Math.abs(entity._pos_y - this._pos_y);
            this._timer = 1 + 4 * n2 / 75;
        } else {
            this._timer = 1;
        }
        if (GameImpl._vibrationsEnable && Level._skipMovieState == 0) {
            GameImpl._soundManager.vibrate(200);
        }
    }

    private void Barrel_Draw(SDKGraphics sDKGraphics) {
        if (this._state > 0) {
            this.DrawCrtAnim(sDKGraphics);
        } else if (this._timer > 0) {
            this.DrawCrtAnim(sDKGraphics);
        } else if (this._timer == 0) {
            this.CreateExplosion(1, 0, true, 0, 0, 0);
        }
    }

    static void __BARREL() {
    }

    static void LIGHTNING__() {
    }

    public void Lightning_Init(int n, int n2, int n3, int n4) {
        this._z_order = 4;
        this._pos_x = n;
        this._pos_y = n2;
        this._sdata[0] = (short)n3;
        this._sdata[1] = (short)n4;
        this._timer = 0;
    }

    private void Lightning_Update() {
        ++this._timer;
        if (this._timer > 6) {
            Level.DeleteEntity(this);
        }
    }

    private void Lightning_Draw(SDKGraphics sDKGraphics) {
        Utils.DrawLightningBolt(sDKGraphics, this._pos_x << 6, this._pos_y << 6, this._sdata[0] << 6, this._sdata[1] << 6, 32, 128, true, 0xFFFFFF, 0x8080FF);
    }

    static void __LIGHTNING() {
    }

    static void BRIDGE__() {
    }

    public void Bridge_Init2() {
        int n = this._state;
        this._state = -1;
        this.Bridge_ChangeState(n, false);
    }

    void Bridge_ChangeState(int n, boolean bl) {
        if (n == this._state) {
            return;
        }
        switch (n) {
            case 0: {
                this.SetCrtAnim(0);
                Level.EraseCollisionMap(this._pos_x, this._pos_y, 20 + (this._flags & 1), 0);
                break;
            }
            case 1: {
                this.CreateExplosion(1, 0, true, 0, 0, 0);
                this.SetCrtAnim(1);
                Level.ApplyCollisionMap(this._pos_x, this._pos_y, 20 + (this._flags & 1));
            }
        }
        if (bl) {
            XSprite xSprite = Sprites._sprites[this._sprite];
            xSprite.RectFrame(xSprite.GetCurFrameInAnim(this._crt_anim, this._crt_aframe), this._pos_x, this._pos_y, 0);
            Map.CDB_AddInvalidateRegion(XSprite._rect);
        }
        this._state = n;
    }

    public void BridgeCmdPost_Init() {
        for (int i = 0; i <= 1; ++i) {
            if (this._sdata[i] == -1) continue;
            Entity entity = Level.GetEntityById(8, this._sdata[i]);
            this._sdata[i] = entity._arrayIndex;
        }
        this._sprite = 4;
        this._z_order = 2;
    }

    public void BridgeCmdPost_EngineerEntered() {
        Entity entity;
        int n;
        boolean bl = false;
        for (n = 0; n <= 1; ++n) {
            if (this._sdata[n] == -1) continue;
            entity = Level.GetEntityUnsafe(this._sdata[n]);
            if (entity._state != 1) continue;
            bl = true;
        }
        for (n = 0; n <= 1; ++n) {
            if (this._sdata[n] == -1) continue;
            entity = Level.GetEntityUnsafe(this._sdata[n]);
            if (bl) {
                entity.Bridge_ChangeState(0, true);
                continue;
            }
            entity.Bridge_ChangeState(1, true);
            if (GameImpl._vibrationsEnable && Level._skipMovieState == 0) {
                GameImpl._soundManager.vibrate(500);
            }
            for (int i = 0; i < 64; ++i) {
                int n2;
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit._life <= 0 || (n2 = Math.abs(entity._pos_x - unit._pos_x) + Math.abs(entity._pos_y - unit._pos_y)) >= 64) continue;
                unit.DoAction(5, -1, -1, -1);
            }
        }
    }

    public void Building_EngineerEntered(Unit unit) {
        Building building = (Building)Level.GetEntitySafe(unit._targetPointer);
        building._life = building._life + unit._repair_amt < building._initial_life ? (short)(building._life + unit._repair_amt) : building._initial_life;
        if (building._on_fire && building._life > building._initial_life / 2 && building._subtype != 6) {
            building.SetStayAnim();
            building._on_fire = false;
        }
    }

    public int BridgeCmdPost_GetBridgeState() {
        for (int i = 0; i <= 1; ++i) {
            if (this._sdata[i] == -1) continue;
            Entity entity = Level.GetEntityUnsafe(this._sdata[i]);
            if (entity._state != 1) continue;
            return 1;
        }
        return 0;
    }

    public void Bridge_TakeDamage(int n, int n2, int n3) {
        if (n > 40) {
            this.Bridge_ChangeState(1, true);
            if (GameImpl._vibrationsEnable && Level._skipMovieState == 0) {
                GameImpl._soundManager.vibrate(500);
            }
            for (int i = 0; i < 64; ++i) {
                int n4;
                if (Level._entities_usage[i] != 1) continue;
                Unit unit = (Unit)Level._entities[i];
                if (unit._life <= 0 || (n4 = Math.abs(this._pos_x - unit._pos_x) + Math.abs(this._pos_y - unit._pos_y)) >= 64) continue;
                unit.DoAction(5, -1, -1, -1);
            }
        }
    }

    static void __BRIDGE() {
    }

    static void IGMESSAGE__() {
    }

    public void IGMessage_Init(int n, int n2, int n3, int n4, int n5, int n6) {
        this._pos_x = n2;
        this._pos_y = n3;
        this._z_order = 5;
        short[] sArray = this._sdata;
        sArray[0] = (short)n;
        sArray[1] = (short)n4;
        sArray[2] = (short)n5;
        sArray[3] = (short)n6;
        if (n == 0) {
            this._timer = 0;
        }
    }

    private void IGMessage_Update() {
        short[] sArray = this._sdata;
        int n = sArray[1];
        if (n != 32760) {
            --n;
        }
        if (n <= 0) {
            Level.DeleteEntity(this);
            return;
        }
        short s = sArray[0];
        switch (s) {
            case 0: {
                --this._timer;
                if (this._timer > 0) break;
                --this._pos_y;
                this._timer = 1;
            }
        }
        sArray[1] = (short)n;
    }

    private void IGMessage_Draw(SDKGraphics sDKGraphics) {
        short[] sArray = this._sdata;
        short s = sArray[0];
        switch (s) {
            case 0: {
                SDKUtils.setFont(GameImpl.fonts[4]);
                int n = SDKUtils.getLineSize();
                SDKString sDKString = SDKUtils.getString(sArray[2], GameImpl._string);
                int n2 = SDKUtils.getStringSize(sDKString) + 4;
                int n3 = n + 2;
                int n4 = GameImpl.SV_X + this._pos_x - Camera._nCamX;
                int n5 = GameImpl.SV_Y + this._pos_y - Camera._nCamY;
                if ((sArray[3] & 4) != 0) {
                    if (n4 <= 0) {
                        n4 = n4 + n2 / 2 >= 0 ? 1 : -n2 - 4;
                    } else if (n4 + n2 + 2 >= GameImpl.SV_W) {
                        n4 = n4 + n2 / 2 + 2 <= GameImpl.SV_W ? GameImpl.SV_W - n2 - 2 : GameImpl.SV_W;
                    }
                } else if ((sArray[3] & 1) != 0) {
                    if (n4 - n2 / 2 < 0) {
                        n4 = n4 >= 0 ? n2 / 2 : -n2 - 4;
                    } else if (n4 + n2 / 2 > GameImpl.SV_W) {
                        n4 = n4 <= GameImpl.SV_W + n2 / 2 ? GameImpl.SV_W - n2 / 2 : GameImpl.SV_W + n2;
                    }
                } else if ((sArray[3] & 8) != 0) {
                    if (n4 + n2 < 0) {
                        n4 = n4 + n2 + n2 / 2 > 0 ? -n2 : -2 * n2 - 4;
                    } else if (n4 > GameImpl.SV_W) {
                        n4 = n4 - n2 / 2 < GameImpl.SV_W ? GameImpl.SV_W : GameImpl.SV_W + n2 + 2;
                    }
                }
                Utils.FillRect(sDKGraphics, -1610612736, n4 - (n2 >> 1), n5 - (n3 - 1), n2, n3);
                SDKUtils.drawString(sDKString, n4, n5, sArray[3]);
            }
        }
    }

    static void __IGMESSAGE() {
    }

    static void MFIELD__() {
    }

    public void MField_Init() {
        this._sprite = 1;
        this._z_order = 3;
        Level.ApplyCollisionMap(this._pos_x, this._pos_y, 22);
    }

    public void MField_Init2() {
        this.SetCrtAnim(0);
    }

    public void MField_Update() {
        this.UpdateCrtAnim();
    }

    public int MField_ExtractMoney(int n) {
        int n2 = 0;
        int n3 = this._idata[0];
        if (n3 > 0) {
            if ((n3 -= n) < 0) {
                n += n3;
                n3 = 0;
            }
            n2 = n;
        }
        this._idata[0] = n3;
        return n2;
    }

    public void MField_Draw(SDKGraphics sDKGraphics) {
        this.DrawCrtAnim(sDKGraphics);
    }

    static void __MFIELD() {
    }

    static void GARRISON_BLD__() {
    }

    public void GarrisonBld_Load(SDKInputStream sDKInputStream) throws IOException {
        this._sdata[0] = (short)((sDKInputStream.read() & 0xFF) - 1);
        this._sprite = 1;
        this._z_order = 3;
        this._sdata[5] = (short)(sDKInputStream.read() & 0xFF);
        this._sdata[2] = this._sdata[3] = sDKInputStream.readShort();
        for (int i = 0; i < 5; ++i) {
            this._idata[i] = sDKInputStream.readShort();
        }
    }

    public void GarrisonBld_Init() {
        this._sdata[4] = 0;
        this._sdata[1] = 2;
    }

    public void GarrisonBld_Init2() {
        int n;
        this.SetCrtAnim(1 + this._sdata[0]);
        for (n = 0; n < 5; ++n) {
            int n2 = this._idata[n];
            this._idata[n] = -1;
            Entity entity = Level.GetEntityById(5, n2);
            if (entity == null) continue;
            this.GarrisonBld_AddUnit(entity);
        }
        for (n = 5; n < 8; ++n) {
            this._idata[n] = -1;
        }
    }

    public void GarrisonBld_Update() {
        if (this._sdata[4] > 0) {
            int n = 1 + this._sdata[0] + 6;
            int n2 = this._sdata[5];
            for (int i = 0; i < n2; ++i) {
                if (this._idata[i] == -1) continue;
                Unit unit = (Unit)Level.GetEntitySafe(this._idata[i]);
                if (unit == null) {
                    this.GarrisonBld_RemoveUnit(i);
                    continue;
                }
                if (unit._state != 2) continue;
                n = 1 + this._sdata[0] + 12;
            }
            if (this._sdata[4] > 0 && n != this._crt_anim) {
                this.SetCrtAnim(n);
            }
        }
        this.UpdateCrtAnim();
    }

    public void GarrisonBld_Draw(SDKGraphics sDKGraphics) {
        if (GameImpl._useFog && Level.FOW_PercentageVisible(this.ComputeBoundingBox()) < 40) {
            int n = this._crt_anim;
            this._crt_anim = 1 + this._sdata[0];
            this.DrawCrtAnim(sDKGraphics);
            this._crt_anim = n;
        } else {
            this.DrawCrtAnim(sDKGraphics);
            if (this._sdata[4] > 0) {
                this.GarrisonBld_DrawDetails(sDKGraphics);
            }
        }
    }

    public void GarrisonBld_DrawDetails(SDKGraphics sDKGraphics) {
        int[] nArray = this.ComputeBoundingBox();
        short s = this._sdata[1];
        short s2 = this._sdata[3];
        short s3 = this._sdata[2];
        int n = this._pos_x - 36 - Camera._nCamX + GameImpl.SV_X;
        int n2 = nArray[1] - 4 - 1 - Camera._nCamY + GameImpl.SV_Y;
        int n3 = 0xFFFF00;
        if (s == 0) {
            n3 = 65280;
        } else if (s == 1) {
            n3 = 0xFF0000;
        }
        sDKGraphics.setColor(n3);
        if (s2 != 0) {
            sDKGraphics.fillRect(n, n2, s3 * 72 / s2, 4);
        }
        sDKGraphics.setColor(n3);
        sDKGraphics.drawRect(n, n2, 72, 4);
        int n4 = 36;
        int n5 = this._sdata[5];
        short s4 = this._sdata[4];
        XSprite xSprite = Sprites._sprites[1];
        for (int i = 0; i < n5; ++i) {
            if (i >= s4) {
                n4 = 37;
            }
            xSprite.DrawFrame(n4, n, n2 + 4 + 3, 0);
            n += 9;
        }
    }

    public boolean GarrisonBld_HasFreeSlots() {
        return this._sdata[4] < this._sdata[5];
    }

    public boolean GarrisonBld_IsOccupied() {
        return this._sdata[4] > 0;
    }

    public boolean GarrisonBld_IsFriendly(int n) {
        short s = this._sdata[1];
        return s == 2 || s == n;
    }

    public void GarrisonBld_AddUnit(Entity entity) {
        int n;
        Unit unit = (Unit)entity;
        if (!this.GarrisonBld_HasFreeSlots()) {
            return;
        }
        if (this._sdata[4] == 0) {
            this._sdata[1] = unit._allegiance;
        }
        if (unit._allegiance != this._sdata[1]) {
            return;
        }
        int n2 = this._sdata[5];
        for (n = 0; n < n2 && this._idata[n] != -1; ++n) {
        }
        if (n != n2) {
            this._sdata[4] = (short)(this._sdata[4] + 1);
            this._idata[n] = unit.GetPointer();
            this._idata[8 + n] = unit._group;
            unit._garrisonBuilding = this.GetPointer();
            unit._bSelected = false;
            unit._pos_x = this._pos_x;
            unit._pos_y = this._pos_y - 1;
            unit.DoAction(1, -1, -1, -1);
            Level.Group_Remove(unit);
            int n3 = 1 + this._sdata[0] + 6;
            if (n3 != this._crt_anim) {
                this.SetCrtAnim(n3);
            }
        }
    }

    public Unit GarrisonBld_RemoveUnit(int n) {
        if (this._idata[n] == -1) {
            return null;
        }
        Unit unit = (Unit)Level.GetEntitySafe(this._idata[n]);
        if (unit != null) {
            unit._garrisonBuilding = -1;
            Level.Group_Add(unit, this._idata[8 + n]);
        }
        this._idata[n] = -1;
        this._sdata[4] = (short)(this._sdata[4] - 1);
        if (this._sdata[4] == 0) {
            this._sdata[1] = 2;
            int n2 = 1 + this._sdata[0];
            this.SetCrtAnim(n2);
        }
        return unit;
    }

    public void GarrisonBld_Evacuate() {
        int n = this._pos_x / 8;
        int n2 = this._pos_y / 8;
        int n3 = this._sdata[5];
        for (int i = 0; i < n3; ++i) {
            Unit unit = this.GarrisonBld_RemoveUnit(i);
            if (unit == null || !Map.ValidateCollisionTile(n, n2, 8)) continue;
            unit._pos_x = Map._validTileX * 8 + 4;
            unit._pos_y = Map._validTileY * 8 + 4;
            unit.DoAction(2, -1, unit._pos_x, unit._pos_y);
        }
        this._sdata[4] = 0;
    }

    public void GarrisonBld_TakeDamage(int n, int n2, int n3) {
        int n4;
        if (this._sdata[4] <= 0) {
            return;
        }
        int n5 = (n *= Unit._units_damage_matrix[n2][3]) >> 6;
        int n6 = n * 40 / (100 * this._sdata[4]) >> 6;
        int n7 = this._sdata[5];
        for (n4 = 0; n4 < n7; ++n4) {
            Unit unit = (Unit)Level.GetEntitySafe(this._idata[n4]);
            if (unit == null) continue;
            unit.TakeDamage(n6, n2, n3);
        }
        n4 = this._sdata[2];
        if ((n4 -= n5) <= 0) {
            n4 = 0;
            this.CreateExplosion(1, 0, true, 0, 0, 0);
            this.GarrisonBld_Evacuate();
            Level.DeleteEntity(this);
        }
        this._sdata[2] = (short)n4;
    }

    static void __GARRISON_BLD() {
    }

    static void PARTICLE_GROUP__() {
    }

    public void InitParticle(short s, int n, int n2, int n3) {
        switch (s) {
            case 0: {
                this._sdata = new short[113];
                this.SetParticleGroupData(0, s);
                this.SetParticleGroupData(1, (short)15);
                this.SetParticleGroupData(2, (short)0);
                this.SetParticleGroupData(3, (short)n);
                this.SetParticleGroupData(4, (short)n2);
                this.SetParticleGroupData(5, (short)n3);
                this.SetParticleGroupData(7, (short)0);
                this.SetParticleGroupData(6, (short)0);
                this._sprite = 23;
                break;
            }
            case 1: {
                this._sdata = new short[113];
                this.SetParticleGroupData(0, s);
                this.SetParticleGroupData(1, (short)15);
                this.SetParticleGroupData(2, (short)0);
                this.SetParticleGroupData(3, (short)n);
                this.SetParticleGroupData(4, (short)n2);
                this.SetParticleGroupData(5, (short)n3);
                this.SetParticleGroupData(7, (short)0);
                this.SetParticleGroupData(6, (short)1);
                this._sprite = 23;
                break;
            }
        }
        this._pos_x = n;
        this._pos_y = n2;
        for (int i = 0; i < this.GetParticleGroupData(1); ++i) {
            this.SetParticleData(i, 0, (short)0);
            this.SetParticleData(i, 1, (short)0);
            this.SetParticleData(i, 2, (short)0);
            this.SetParticleData(i, 3, (short)0);
            this.SetParticleData(i, 4, (short)0);
            this.SetParticleData(i, 5, (short)0);
            this.SetParticleData(i, 6, (short)0);
        }
    }

    public void ParticleGroup_Trail_Update(int n, int n2, int n3) {
        XSprite xSprite = Sprites._sprites[this._sprite];
        short s = this.GetParticleGroupData(6);
        switch (this.GetParticleGroupData(0)) {
            case 0: 
            case 1: {
                this.SetParticleGroupData(7, (short)1);
                for (int i = 0; i < this._sdata[1]; ++i) {
                    if (this.GetParticleData(i, 0) <= 0) continue;
                    this.SetParticleData(i, 0, (short)(this.GetParticleData(i, 0) - 1));
                    if (this.GetParticleData(i, 0) <= 0) continue;
                    this.SetParticleGroupData(7, (short)0);
                    this._crt_aframe_time = this.GetParticleData(i, 6);
                    --this._crt_aframe_time;
                    if (this._crt_aframe_time <= 0) {
                        this._crt_aframe = this.GetParticleData(i, 5) + 1;
                        this.SetParticleData(i, 5, (short)this._crt_aframe);
                        this._crt_aframe_time = xSprite.GetAnimFrameTime(this.GetParticleGroupData(6), this._crt_aframe);
                    }
                    this.SetParticleData(i, 6, (short)this._crt_aframe_time);
                }
                int n4 = n + Utils.random(-1, 1);
                int n5 = n2 + Utils.random(-1, 1);
                int n6 = n3 + Utils.random(-1, 1);
                this.CreateParticle((short)xSprite.GetAnimLength(s), (short)n4, (short)n5, (short)n6, s, true);
                this.SetParticleGroupData(3, (short)n);
                this.SetParticleGroupData(4, (short)n2);
                this.SetParticleGroupData(5, (short)n3);
                if (this._pos_x == n && this._pos_y == n2) {
                    this.SetParticleGroupData(7, (short)1);
                }
                this._pos_x = n;
                this._pos_y = n2;
                break;
            }
            case 2: 
            case 3: {
                this.SetParticleGroupData(7, (short)1);
                for (int i = 0; i < this._sdata[1]; ++i) {
                    if (this.GetParticleData(i, 0) <= 0) continue;
                    this.SetParticleData(i, 0, (short)(this.GetParticleData(i, 0) - 1));
                    if (this.GetParticleData(i, 0) <= 0) continue;
                    this.SetParticleGroupData(7, (short)0);
                    this.SetParticleData(i, 5, (short)(this.GetParticleData(i, 5) + 1));
                }
                break;
            }
        }
    }

    public void ParticleGroup_Trail_Draw(SDKGraphics sDKGraphics) {
        int n = GameImpl.SV_X - Camera._nCamX;
        int n2 = GameImpl.SV_Y - Camera._nCamY;
        boolean bl = false;
        XSprite xSprite = Sprites._sprites[this._sprite];
        if (this.GetParticleGroupData(0) == 2) {
            for (int i = 0; i < this.GetParticleGroupData(1); ++i) {
                int n3;
                if (this.GetParticleData(i, 0) <= 0) continue;
                short s = this.GetParticleData(i, 5);
                if (s > 16 && !bl && (n3 = i - 1) >= 0) {
                    sDKGraphics.setColor(0xFFFFFF);
                    sDKGraphics.drawLine(this.GetParticleData(n3, 1) + n, this.GetParticleData(n3, 2) + n2, this.GetParticleGroupData(3) + n, this.GetParticleGroupData(4) + n2);
                    bl = true;
                }
                if (s > 17) {
                    xSprite.DrawFrame(this.GetParticleData(i, 5) + 4, this.GetParticleData(i, 1) + n, this.GetParticleData(i, 2) + n2, 0);
                }
                xSprite.DrawFrame(this.GetParticleData(i, 5), this.GetParticleData(i, 1) + n, this.GetParticleData(i, 2) + n2, 0);
            }
        } else if (this.GetParticleGroupData(0) == 3) {
            for (int i = 0; i < this.GetParticleGroupData(1); ++i) {
                int n4;
                if (this.GetParticleData(i, 0) <= 0) continue;
                short s = this.GetParticleData(i, 5);
                if (s > 66 && !bl && (n4 = i - 1) >= 0) {
                    sDKGraphics.setColor(0xFFFFFF);
                    sDKGraphics.drawLine(this.GetParticleData(n4, 1) + n, this.GetParticleData(n4, 2) + n2, this.GetParticleGroupData(3) + n, this.GetParticleGroupData(4) + n2);
                    bl = true;
                }
                if (s > 67) {
                    xSprite.DrawFrame(this.GetParticleData(i, 5) + 4, this.GetParticleData(i, 1) + n, this.GetParticleData(i, 2) + n2, 0);
                }
                xSprite.DrawFrame(this.GetParticleData(i, 5), this.GetParticleData(i, 1) + n, this.GetParticleData(i, 2) + n2, 0);
            }
        } else {
            for (int i = 0; i < this.GetParticleGroupData(1); ++i) {
                if (this.GetParticleData(i, 0) <= 0) continue;
                xSprite.DrawAnimFrame(this.GetParticleGroupData(6), this.GetParticleData(i, 5), this.GetParticleData(i, 1) + n, this.GetParticleData(i, 2) + n2 - this.GetParticleData(i, 3), 0);
            }
        }
    }

    public void CreateParticle(short s, short s2, short s3, short s4, short s5, boolean bl) {
        int n = this.GetParticleGroupData(2);
        this.SetParticleData(n, 1, s2);
        this.SetParticleData(n, 2, s3);
        this.SetParticleData(n, 3, s4);
        this.SetParticleData(n, 4, (short)0);
        int n2 = 0;
        if (bl) {
            n2 += Utils.random(0, 4);
        }
        this.SetParticleData(n, 5, (short)n2);
        this.SetParticleData(n, 0, (short)(s - n2));
        XSprite xSprite = Sprites._sprites[this._sprite];
        this._crt_aframe_time = xSprite.GetAnimFrameTime(s5, n2);
        this.SetParticleData(n, 6, (short)this._crt_aframe_time);
        n = (n + 1) % this.GetParticleGroupData(1);
        this.SetParticleGroupData(2, (short)n);
    }

    public short GetParticleGroupData(int n) {
        return this._sdata[n];
    }

    public void SetParticleGroupData(int n, short s) {
        this._sdata[n] = s;
    }

    public short GetParticleData(int n, int n2) {
        return this._sdata[8 + n * 7 + n2];
    }

    public void SetParticleData(int n, int n2, short s) {
        this._sdata[8 + n * 7 + n2] = s;
    }

    public boolean ParticleGroup_IsFinished() {
        return this.GetParticleGroupData(7) == 1;
    }

    static void __PARTICLE_GROUP() {
    }

    static void LASER__() {
    }

    public void Laser_Init(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this._z_order = 5;
        this._timer = 0;
        this._flags = 0;
        this._sdata[0] = (short)n;
        this._sdata[1] = (short)n2;
        this._sdata[2] = (short)n3;
        Entity entity = Level.GetEntitySafe(n4);
        if (entity == null) {
            Level.DeleteEntity(this);
            return;
        }
        this._sdata[3] = (short)(entity._pos_x + n5);
        this._pos_x = this._sdata[3];
        this._sdata[4] = (short)(entity._pos_y + n6);
        this._pos_y = this._sdata[4];
        this._sdata[5] = (short)(bl && n == 11 ? 1 : 0);
        if (bl && n == 11) {
            this._sprite = Level.GetBulletStats(11, 6);
            this.SetCrtAnim(Level.GetBulletStats(11, 7));
        }
    }

    public void Laser_Update() {
        boolean bl;
        boolean bl2 = bl = this._sdata[5] == 1;
        if (bl && !this.IsCrtAnimEnded()) {
            this.UpdateCrtAnim();
        }
        int n = 0;
        switch (this._sdata[0]) {
            case 11: 
            case 16: {
                n = 7;
            }
        }
        ++this._timer;
        if (this._timer >= n) {
            Level.DeleteEntity(this);
        }
    }

    public void Laser_Draw(SDKGraphics sDKGraphics) {
        boolean bl;
        int n = this._sdata[1] + GameImpl.SV_X - Camera._nCamX;
        int n2 = this._sdata[2] + GameImpl.SV_Y - Camera._nCamY;
        int n3 = this._sdata[3] + GameImpl.SV_X - Camera._nCamX;
        int n4 = this._sdata[4] + GameImpl.SV_Y - Camera._nCamY;
        boolean bl2 = bl = this._sdata[5] == 1;
        if (bl && !this.IsCrtAnimEnded()) {
            this.DrawCrtAnim(sDKGraphics);
        }
        if (this._timer == 6) {
            sDKGraphics.setColor(0x33FFFF);
            sDKGraphics.drawLine(n, n2, n3, n4);
        } else {
            int n5;
            boolean bl3;
            XSprite xSprite = Sprites._sprites[36];
            int n6 = 76;
            sDKGraphics.setColor(0xFFFFFF);
            sDKGraphics.drawLine(n, n2, n3, n4);
            n6 = 76;
            boolean bl4 = bl3 = Math.abs(n4 - n2) > Math.abs(n3 - n);
            if (bl3) {
                n5 = n;
                n = n2;
                n2 = n5;
                n5 = n3;
                n3 = n4;
                n4 = n5;
            }
            if (n > n3) {
                n5 = n;
                n = n3;
                n3 = n5;
                n5 = n2;
                n2 = n4;
                n4 = n5;
            }
            int n7 = n3 - n;
            int n8 = Math.abs(n4 - n2);
            int n9 = n7 / 2;
            int n10 = n2 < n4 ? 1 : -1;
            int n11 = n2;
            for (n5 = n; n5 < n3; ++n5) {
                if (bl3) {
                    xSprite.DrawFrame(n6, n11, n5, 0);
                } else {
                    xSprite.DrawFrame(n6, n5, n11, 0);
                }
                if ((n9 -= n8) >= 0) continue;
                n11 += n10;
                n9 += n7;
            }
        }
    }

    static void __LASER() {
    }

    static void SNIPER__() {
    }

    public void Sniper_Init(int n, int n2, int n3, int n4, int n5) {
        if (n == 6) {
            n5 -= 14;
        }
        this._sdata[0] = (short)n;
        this._sdata[1] = (short)n2;
        this._sdata[2] = (short)n3;
        this._sdata[3] = (short)n4;
        this._sdata[4] = (short)n5;
        Entity entity = Level.SpawnEntity(107);
        this._sdata[5] = entity._arrayIndex;
        this._sprite = 36;
        this._pos_x = n4;
        this._pos_y = n5;
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        this._orientation = this.GetOrientation(n6, n7);
        int n8 = Math.abs(n6) + Math.abs(n7);
        int n9 = n8 / 4;
        entity._sdata = new short[8 + 7 * n9];
        if (n == 6) {
            entity.SetParticleGroupData(0, (short)2);
        } else if (n == 17) {
            entity.SetParticleGroupData(0, (short)3);
        }
        entity.SetParticleGroupData(1, (short)n9);
        entity.SetParticleGroupData(2, (short)0);
        entity.SetParticleGroupData(3, (short)n4);
        entity.SetParticleGroupData(4, (short)n5);
        entity.SetParticleGroupData(5, (short)0);
        entity.SetParticleGroupData(7, (short)0);
        if (n == 6) {
            entity.SetParticleGroupData(6, (short)4);
        } else if (n == 17) {
            entity.SetParticleGroupData(6, (short)9);
        }
        entity._sprite = 36;
        this._timer = 0;
        int n10 = n4 << 6;
        int n11 = n5 << 6;
        int n12 = n2 << 6;
        int n13 = n3 << 6;
        int n14 = Math.abs(n12 - n10) + Math.abs(n13 - n11);
        if (n9 == 0) {
            return;
        }
        int n15 = (n12 - n10) / n9;
        int n16 = (n13 - n11) / n9;
        int n17 = n14 / 9;
        for (int i = 0; i < n9; ++i) {
            int n18 = (n14 - (Math.abs(n12 - n10) + Math.abs(n13 - n11))) / n17;
            int n19 = 9 - n18;
            if (n19 > 4) {
                n19 = 4;
            }
            entity.SetParticleData(i, 0, (short)n19);
            entity.SetParticleData(i, 1, (short)(n10 >> 6));
            entity.SetParticleData(i, 2, (short)(n11 >> 6));
            entity.SetParticleData(i, 3, (short)0);
            entity.SetParticleData(i, 4, (short)0);
            if (n == 6) {
                entity.SetParticleData(i, 5, (short)(12 + n18));
            } else if (n == 17) {
                entity.SetParticleData(i, 5, (short)(62 + n18));
            }
            entity.SetParticleData(i, 6, (short)0);
            n10 += n15;
            n11 += n16;
        }
    }

    public void Sniper_Update() {
        Entity entity = Level.GetEntityUnsafe(this._sdata[5]);
        entity.ParticleGroup_Trail_Update(this._pos_x, this._pos_y, 0);
        ++this._timer;
        if (entity.ParticleGroup_IsFinished() || entity.GetParticleGroupData(1) == 0) {
            Level.DeleteEntity(entity);
            Level.DeleteEntity(this);
        }
    }

    public void Sniper_Draw(SDKGraphics sDKGraphics) {
        Entity entity = Level.GetEntityUnsafe(this._sdata[5]);
        entity.ParticleGroup_Trail_Draw(sDKGraphics);
        XSprite xSprite = Sprites._sprites[this._sprite];
        short s = this._sdata[0];
        if (s == 6) {
            if (this._timer < 3) {
                xSprite.DrawFrame(4 + this._orientation, this._pos_x, this._pos_y, 0);
            }
            if (this._timer > 1 && this._timer < 3) {
                xSprite = Sprites._sprites[23];
                int n = 23;
                int n2 = this._sdata[1] + GameImpl.SV_X - Camera._nCamX;
                int n3 = this._sdata[2] + GameImpl.SV_Y - Camera._nCamY;
                int n4 = this._sdata[3] + GameImpl.SV_X - Camera._nCamX;
                int n5 = this._sdata[4] + GameImpl.SV_Y - Camera._nCamY;
                int n6 = n4 - n2;
                int n7 = n5 - n3;
                n = Math.abs(n6) > Math.abs(n7) ? (n6 > 0 ? 24 : 26) : (n7 > 0 ? 25 : 23);
                xSprite.DrawFrame(n, n4, n5, 0);
            }
        }
    }

    static void __SNIPER() {
    }

    static void NUKE__() {
    }

    public void Nuke_Init(int n, int n2, int n3) {
        this._z_order = 5;
        this._pos_x = n2;
        this._pos_y = n3;
        this._idata[0] = 0;
        this._idata[1] = 0;
        this._idata[2] = this._pos_y - 400;
        this._idata[3] = 4;
        this._idata[4] = 4;
    }

    private void Nuke_Update() {
        int n = this._idata[0];
        switch (n) {
            case 0: {
                this._idata[2] = this._idata[2] + this._idata[3];
                if (this._idata[2] >= this._pos_y) {
                    this._idata[0] = 1;
                    this._idata[2] = this._pos_y;
                    this._sprite = 41;
                    this.SetCrtAnim(0);
                    this._flags |= 0x800;
                    break;
                }
                this._idata[3] = this._idata[3] + 1;
                if (this._idata[3] <= 32) break;
                this._idata[3] = 32;
                break;
            }
            case 1: {
                if (this._crt_aframe == 3) {
                    // empty if block
                }
                if (this._crt_aframe == 9) {
                    // empty if block
                }
                this.UpdateCrtAnim();
                if (GameImpl._vibrationsEnable && Level._skipMovieState == 0) {
                    GameImpl._soundManager.vibrate(1000);
                }
                if (!this.IsCrtAnimEnded()) break;
                int n2 = this._pos_x;
                int n3 = this._pos_y;
                int n4 = Level.GetSWStats(0, 4);
                int n5 = Level.GetSWStats(0, 5);
                int n6 = Level.GetSWStats(0, 3);
                for (int i = 0; i < 416; ++i) {
                    int n7;
                    if (Level._entities_usage[i] != 1 || (n7 = Math.abs(Level._entities[i]._pos_x - n2) + Math.abs(Level._entities[i]._pos_y - n3)) >= n4) continue;
                    Level._entities[i].TakeDamage(n5 - n7, n6, this.GetPointer());
                }
                this._sprite = -1;
                this._idata[0] = 2;
                this._timer = 0;
                this._idata[4] = -1;
                break;
            }
            case 2: {
                ++this._timer;
                if (this._timer > Level.GetSWStats(0, 10)) {
                    int n8 = this._pos_x;
                    int n9 = this._pos_y;
                    int n10 = Level.GetSWStats(0, 8);
                    int n11 = Level.GetSWStats(0, 9);
                    int n12 = Level.GetSWStats(0, 7);
                    for (int i = 0; i < 416; ++i) {
                        int n13;
                        if (Level._entities_usage[i] != 1 || (n13 = Math.abs(Level._entities[i]._pos_x - n8) + Math.abs(Level._entities[i]._pos_y - n9)) >= n10) continue;
                        Level._entities[i].TakeDamage(n11, n12, this.GetPointer());
                    }
                    this._timer = 0;
                }
                this._idata[1] = this._idata[1] + 1;
                if (this._idata[1] <= Level.GetSWStats(0, 6)) break;
                Level.DeleteEntity(this);
            }
        }
    }

    private void Nuke_Draw(SDKGraphics sDKGraphics) {
        int n = this._idata[0];
        switch (n) {
            case 0: {
                int n2 = this._idata[2];
                int n3 = this._pos_x;
                n3 = GameImpl.SV_X + n3 - Camera._nCamX;
                n2 = GameImpl.SV_Y + n2 - Camera._nCamY;
                XSprite xSprite = Sprites._sprites[41];
                int n4 = 0;
                xSprite.DrawFrame(n4, n3, n2, 0);
                break;
            }
            case 1: {
                if (this._sprite < 0) break;
                this.DrawCrtAnim(sDKGraphics);
                break;
            }
        }
    }

    static void __NUKE() {
    }

    static void KIROV__() {
    }

    public void Kirov_Init(int n, int n2, int n3) {
        this._z_order = 6;
        this._sprite = 32;
        this._sdata[7] = (short)n;
        this._pos_x = n2 / (Map._map_w >> 1) * Map._map_w;
        this._pos_y = n3 / (Map._map_h >> 1) * Map._map_h;
        int n4 = n2 - this._pos_x;
        int n5 = n3 - this._pos_y;
        int n6 = Math.abs(n4);
        int n7 = Math.abs(n5);
        int n8 = n6 + n7;
        this._sdata[0] = (short)n2;
        this._sdata[1] = (short)n3;
        this._sdata[4] = (short)(this._pos_x + n4 * 1500 / n8);
        this._sdata[5] = (short)(this._pos_y + n5 * 1500 / n8);
        this._sdata[2] = (short)n2;
        this._sdata[3] = (short)n3;
        this._sdata[8] = 3;
        this._sdata[9] = 12;
        this._sdata[10] = 6;
        this._sdata[11] = 8;
        this._sdata[12] = 128;
        this._sdata[13] = -1;
        this._sdata[14] = 0;
        this._sdata[15] = 0;
        this._sdata[6] = 126;
        this._state = 0;
    }

    public void Harrier_Init(int n, int n2, int n3) {
        this._z_order = 6;
        this._sprite = 37;
        this._sdata[7] = (short)n;
        this._pos_x = n2 / (Map._map_w >> 1) * Map._map_w;
        this._pos_y = n3 / (Map._map_h >> 1) * Map._map_h;
        int n4 = n2 - this._pos_x;
        int n5 = n3 - this._pos_y;
        int n6 = Math.abs(n4);
        int n7 = Math.abs(n5);
        int n8 = n6 + n7;
        this._sdata[0] = (short)n2;
        this._sdata[1] = (short)n3;
        this._sdata[4] = (short)(this._pos_x + n4 * 1500 / n8);
        this._sdata[5] = (short)(this._pos_y + n5 * 1500 / n8);
        this._sdata[2] = (short)n2;
        this._sdata[3] = (short)n3;
        this._sdata[8] = 9;
        this._sdata[9] = 13;
        this._sdata[10] = 3;
        this._sdata[11] = 5;
        this._sdata[12] = 128;
        this._sdata[6] = 256;
        Entity entity = Level.SpawnEntity(107);
        if (entity != null) {
            entity.InitParticle((short)0, this._pos_x, this._pos_y, 128);
        }
        this._sdata[13] = entity._arrayIndex;
        this._sdata[14] = 0;
        this._sdata[15] = 0;
        this._state = 0;
    }

    public void Kirov_Harrier_Update() {
        this.UpdateCrtAnim();
        int n = this.Move(this._sdata[8], false);
        if (n == 0) {
            if (this._crt_anim != 0 + this._orientation) {
                this.SetCrtAnim(0 + this._orientation);
                this._sdata[14] = Level._firing_positions[256 + (this._orientation << 1)];
                this._sdata[15] = Level._firing_positions[256 + (this._orientation << 1) + 1];
            }
            if (this._sdata[13] != -1) {
                Entity entity = Level.GetEntityUnsafe(this._sdata[13]);
                entity.ParticleGroup_Trail_Update(this._pos_x + this._sdata[14], this._pos_y + this._sdata[15], this._sdata[12]);
            }
        } else if (n == 1) {
            if (Math.abs(this._sdata[2] - this._pos_x) + Math.abs(this._sdata[3] - this._pos_y) <= this._sdata[8] << 1) {
                this._sdata[0] = this._sdata[4];
                this._sdata[1] = this._sdata[5];
            } else {
                Level.DeleteEntity(this);
                return;
            }
        }
        if (this._state == 0) {
            if (Math.abs(this._sdata[2] - this._pos_x) + Math.abs(this._sdata[3] - this._pos_y) <= this._sdata[6]) {
                this._state = 1;
                this._timer = 0;
            }
        } else if (this._state >= 1 && this._state < 1 + this._sdata[11]) {
            ++this._timer;
            if (this._timer >= this._sdata[10]) {
                ++this._state;
                this._timer = 0;
                int n2 = Level.GetBulletStats(this._sdata[9], 0);
                Entity entity = Level.SpawnEntity(103);
                int n3 = this._pos_x;
                int n4 = this._pos_y;
                int n5 = this._pos_x;
                int n6 = this._pos_y;
                if (this._sprite == 37) {
                    n5 = this._pos_x;
                    n6 = this._pos_y - this._sdata[12];
                    n3 = this._sdata[2] + Utils.random(-20, 20);
                    n4 = this._sdata[3] + Utils.random(-20, 20);
                } else {
                    n5 = this._pos_x + Utils.random(-20, 20);
                    n6 = this._pos_y - this._sdata[12];
                    n3 = n5;
                    n4 = this._pos_y + Utils.random(-20, 20);
                }
                if (entity != null) {
                    entity.Bullet_Init(this._sdata[9], this._sdata[7], n5, n6, n3, n4, -1, n2, this.GetPointer());
                }
            }
        }
    }

    public void Kirov_Harrier_Draw(SDKGraphics sDKGraphics) {
        XSprite xSprite = Sprites._sprites[6];
        if (this._sprite == 37) {
            xSprite.DrawFrame(11 + this._orientation, GameImpl.SV_X + this._pos_x - Camera._nCamX, GameImpl.SV_Y + this._pos_y - Camera._nCamY, 0);
        } else {
            xSprite.DrawFrame(19 + this._orientation, GameImpl.SV_X + this._pos_x - Camera._nCamX, GameImpl.SV_Y + this._pos_y - Camera._nCamY, 0);
        }
        if (this._sdata[13] != -1) {
            Entity entity = Level.GetEntityUnsafe(this._sdata[13]);
            entity.ParticleGroup_Trail_Draw(sDKGraphics);
        }
        int n = this._pos_y;
        this._pos_y -= this._sdata[12];
        this.DrawCrtAnim(sDKGraphics);
        this._pos_y = n;
    }

    static void __KIROV() {
    }

    static void IRON_CURTAIN__() {
    }

    void IronCurtain_Init(int n, int n2, int n3) {
        this._idata[0] = 14 * Level.GetSWStats(2, 5);
        Hud._player_iron_curtain_timer = this._idata[0];
        this._idata[1] = Level.GetSWStats(2, 3);
        int n4 = Level.GetSWStats(2, 4);
        int n5 = 2;
        int n6 = -1;
        int n7 = n4 * n4;
        for (int i = 0; i < 64; ++i) {
            int n8;
            int n9;
            if (Level._entities_usage[i] != 1) continue;
            Unit unit = (Unit)Level._entities[i];
            if (unit._allegiance != 0 || unit._life <= 0 || (n9 = (unit._pos_x - n2) * (unit._pos_x - n2) + (unit._pos_y - n3) * (unit._pos_y - n3)) >= n7) continue;
            if (n5 < 2 + this._idata[1]) {
                this._idata[n5++] = unit.GetPointer();
                unit._bInvincible = true;
                if (n5 != 2 + this._idata[1]) continue;
                n7 = 0;
                for (n8 = 2; n8 < 2 + this._idata[1]; ++n8) {
                    unit = (Unit)Level.GetEntitySafe(this._idata[n8]);
                    n9 = (unit._pos_x - n2) * (unit._pos_x - n2) + (unit._pos_y - n3) * (unit._pos_y - n3);
                    if (n9 <= n7) continue;
                    n6 = n8;
                    n7 = n9;
                }
                continue;
            }
            n8 = unit.GetPointer();
            unit._bInvincible = true;
            unit = (Unit)Level.GetEntitySafe(this._idata[n6]);
            unit._bInvincible = false;
            this._idata[n6] = n8;
            n7 = 0;
            for (int j = 2; j < 2 + this._idata[1]; ++j) {
                unit = (Unit)Level.GetEntitySafe(this._idata[j]);
                n9 = Math.abs(unit._pos_x - n2) * Math.abs(unit._pos_x - n2) + Math.abs(unit._pos_y - n3) * Math.abs(unit._pos_y - n3);
                if (n9 <= n7) continue;
                n6 = j;
                n7 = n9;
            }
        }
    }

    void IronCurtain_Update() {
        this._idata[0] = this._idata[0] - 1;
        Hud._player_iron_curtain_timer = this._idata[0];
        if (this._idata[0] <= 0) {
            for (int i = 2; i < 2 + this._idata[1]; ++i) {
                Unit unit = (Unit)Level.GetEntitySafe(this._idata[i]);
                if (unit == null) continue;
                unit._bInvincible = false;
            }
            Level.DeleteEntity(this);
        }
    }

    static void __IRON_CURTAIN() {
    }

    static void STORMBOLT__() {
    }

    public void StormBolt_Init(int n, int n2, int n3, int n4) {
        this._z_order = 4;
        this._pos_x = n3;
        this._pos_y = n4;
        this._sdata[0] = (short)n;
        this._sdata[1] = (short)n2;
        this._timer = 0;
    }

    private void StormBolt_Update() {
        ++this._timer;
        if (this._timer == 1) {
            int n = this._pos_x;
            int n2 = this._pos_y;
            int n3 = Level.GetSWStats(5, 6);
            int n4 = Level.GetSWStats(5, 5);
            int n5 = Level.GetSWStats(5, 3);
            for (int i = 0; i < 416; ++i) {
                int n6;
                if (Level._entities_usage[i] != 1 || (n6 = Math.abs(Level._entities[i]._pos_x - n) + Math.abs(Level._entities[i]._pos_y - n2)) >= n3) continue;
                Level._entities[i].TakeDamage(n4 - n6, n5, this.GetPointer());
            }
        }
        if (this._timer > 4) {
            Level.DeleteEntity(this);
        }
    }

    private void StormBolt_Draw(SDKGraphics sDKGraphics) {
        Utils.DrawLightningBolt(sDKGraphics, this._sdata[0] << 6, this._sdata[1] << 6, this._pos_x << 6, this._pos_y << 6, 32, 256, false, 0xFFFFFF, 0x8080FF);
    }

    static void __STORMBOLT() {
    }

    static void STORM__() {
    }

    public void Storm_Init(int n, int n2, int n3) {
        this._z_order = 5;
        this._pos_x = n2;
        this._pos_y = n3;
        this._sdata[0] = (short)(this._pos_x - GameImpl.SW_STORM_CLOUD_DX);
        this._sdata[1] = (short)(this._pos_y - GameImpl.SW_STORM_HIGHT + 8);
        this._sdata[2] = (short)(this._pos_x - GameImpl.SW_STORM_CLOUD_DX);
        this._sdata[3] = (short)(this._pos_y - GameImpl.SW_STORM_HIGHT + 0 - GameImpl.SW_STORM_CLOUD_DX);
        this._sdata[4] = (short)(this._pos_x + GameImpl.SW_STORM_CLOUD_DX);
        this._sdata[5] = (short)(this._pos_y - GameImpl.SW_STORM_HIGHT + -16);
        this._sdata[6] = (short)(this._pos_x + GameImpl.SW_STORM_CLOUD_DX);
        this._sdata[7] = (short)(this._pos_y - GameImpl.SW_STORM_HIGHT + 8);
        this._timer = 0;
        this._state = 0;
        this._sprite = 36;
    }

    private void Storm_Update() {
        boolean bl = true;
        switch (this._state) {
            case 0: {
                ++this._timer;
                this._sdata[0] = (short)(this._sdata[0] + 8);
                if (this._sdata[0] >= this._pos_x + -24) {
                    this._sdata[0] = (short)(this._pos_x + -24);
                } else {
                    bl = false;
                }
                this._sdata[2] = (short)(this._sdata[2] + 8);
                this._sdata[3] = (short)(this._sdata[3] + 8);
                if (this._sdata[2] >= this._pos_x + 0) {
                    this._sdata[2] = (short)(this._pos_x + 0);
                } else {
                    bl = false;
                }
                this._sdata[4] = (short)(this._sdata[4] - 8);
                if (this._sdata[4] <= this._pos_x + 16) {
                    this._sdata[4] = (short)(this._pos_x + 16);
                } else {
                    bl = false;
                }
                this._sdata[6] = (short)(this._sdata[6] - 8);
                if (this._sdata[6] <= this._pos_x + 32) {
                    this._sdata[6] = (short)(this._pos_x + 32);
                } else {
                    bl = false;
                }
                if (!bl) break;
                this._state = 1;
                this._timer = 0;
                break;
            }
            case 1: {
                ++this._timer;
                int n = Level.GetSWStats(5, 4);
                int n2 = Utils.random(0, n);
                int n3 = n2 - (n >> 1);
                n2 = Utils.random(0, n);
                int n4 = n2 - (n >> 1);
                Entity entity = Level.SpawnEntity(114);
                if (entity != null) {
                    entity.StormBolt_Init(this._pos_x + n3, this._pos_y - GameImpl.SW_STORM_HIGHT, this._pos_x + n3, this._pos_y + n4);
                }
                if (GameImpl._vibrationsEnable && Level._skipMovieState == 0) {
                    GameImpl._soundManager.vibrate(18);
                }
                if (this._timer <= 18) break;
                this._state = 2;
                this._timer = 0;
                break;
            }
            case 2: {
                ++this._timer;
                this._sdata[0] = (short)(this._sdata[0] - 8);
                if (this._sdata[0] <= this._pos_x - GameImpl.SW_STORM_CLOUD_DX) {
                    this._sdata[0] = (short)(this._pos_x - GameImpl.SW_STORM_CLOUD_DX);
                } else {
                    bl = false;
                }
                this._sdata[2] = (short)(this._sdata[2] - 8);
                this._sdata[3] = (short)(this._sdata[3] - 8);
                if (this._sdata[2] <= this._pos_x - GameImpl.SW_STORM_CLOUD_DX) {
                    this._sdata[2] = (short)(this._pos_x - GameImpl.SW_STORM_CLOUD_DX);
                } else {
                    bl = false;
                }
                this._sdata[4] = (short)(this._sdata[4] + 8);
                if (this._sdata[4] >= this._pos_x + GameImpl.SW_STORM_CLOUD_DX) {
                    this._sdata[4] = (short)(this._pos_x + GameImpl.SW_STORM_CLOUD_DX);
                } else {
                    bl = false;
                }
                this._sdata[6] = (short)(this._sdata[6] + 8);
                if (this._sdata[6] >= this._pos_x + GameImpl.SW_STORM_CLOUD_DX) {
                    this._sdata[6] = (short)(this._pos_x + GameImpl.SW_STORM_CLOUD_DX);
                } else {
                    bl = false;
                }
                if (!bl) break;
                Level.DeleteEntity(this);
            }
        }
    }

    private void Storm_Draw(SDKGraphics sDKGraphics) {
        int n = GameImpl.SV_X - Camera._nCamX;
        int n2 = GameImpl.SV_Y - Camera._nCamY;
        XSprite xSprite = Sprites._sprites[this._sprite];
        xSprite.DrawFrame(26, n + this._sdata[2], n2 + this._sdata[3], 0);
        xSprite.DrawFrame(27, n + this._sdata[4], n2 + this._sdata[5], 0);
        xSprite.DrawFrame(25, n + this._sdata[0], n2 + this._sdata[1], 0);
        xSprite.DrawFrame(28, n + this._sdata[6], n2 + this._sdata[7], 0);
    }

    static void __STORM() {
    }

    static void TECH_BUILDING__() {
    }

    private void TechBuilding_Init() {
        this._sdata[4] = 0;
        this._sprite = 1;
        this._z_order = 3;
    }

    private void TechBuilding_Init2() {
        this.TechBuilding_RefreshAnim();
        Level.IncEntityNo(13, this._sdata[0], this._sdata[1]);
    }

    private void TechBuilding_Update() {
        this.UpdateCrtAnim();
        short s = this._sdata[1];
        if (s == 2) {
            return;
        }
        switch (this._sdata[0]) {
            case 0: {
                --this._timer;
                if (this._timer > 0) break;
                this._timer = 20;
                if (s == 0) {
                    Level._player_money += 10;
                    break;
                }
                if (s != 1) break;
                Level._ai_money += 10;
            }
        }
    }

    private void TechBuilding_Draw(SDKGraphics sDKGraphics) {
        this.DrawCrtAnim(sDKGraphics);
        if (this._sdata[4] != 0) {
            this.TechBuilding_DrawLife(sDKGraphics);
        }
        this._sdata[4] = 0;
    }

    private void TechBuilding_DrawName(SDKGraphics sDKGraphics) {
        int n = this._pos_x - Camera._nCamX + GameImpl.SV_X;
        int n2 = this._pos_y - 64 - Camera._nCamY + GameImpl.SV_Y;
        SDKUtils.setFont(GameImpl.fonts[4]);
        Utils.DrawString(60 + this._sdata[0], n, n2, 1);
    }

    public void TechBuilding_DrawLife(SDKGraphics sDKGraphics) {
        int[] nArray = this.ComputeBoundingBox();
        short s = this._sdata[1];
        short s2 = this._sdata[2];
        short s3 = this._sdata[3];
        int n = this._pos_x - 36 - Camera._nCamX + GameImpl.SV_X;
        int n2 = nArray[1] - 4 - 1 - Camera._nCamY + GameImpl.SV_Y;
        int n3 = 0xFFFF00;
        if (s == 0) {
            n3 = 65280;
        } else if (s == 1) {
            n3 = 0xFF0000;
        }
        sDKGraphics.setColor(n3);
        if (s2 != 0) {
            sDKGraphics.fillRect(n, n2, s3 * 72 / s2, 4);
        }
        sDKGraphics.setColor(n3);
        sDKGraphics.drawRect(n, n2, 72, 4);
    }

    private boolean TechBuilding_Garrison(Unit unit) {
        if (this._sdata[1] != 2) {
            return false;
        }
        Level.DecEntityNo(13, this._sdata[0], this._sdata[1]);
        this._sdata[1] = unit._allegiance;
        Level.IncEntityNo(13, this._sdata[0], this._sdata[1]);
        this._timer = 0;
        this.TechBuilding_RefreshAnim();
        return true;
    }

    private void TechBuilding_RefreshAnim() {
        int n = this._sdata[1];
        if (Level._player_faction == 1 && n != 2) {
            n ^= 1;
        }
        this.SetCrtAnim(this._sdata[0] * 3 + n + 19);
    }

    public void TechBuilding_TakeDamage(int n, int n2, int n3) {
        n *= Unit._units_damage_matrix[n2][3];
        int n4 = this._sdata[3];
        if ((n4 -= (n >>= 6)) <= 0) {
            n4 = 0;
            Level.DecEntityNo(13, this._sdata[0], this._sdata[1]);
            this.CreateExplosion(1, 0, true, 0, 0, 0);
            Level.DeleteEntity(this);
        }
        this._sdata[3] = (short)n4;
    }

    static void __TECH_BUILDING() {
    }

    static void SPAWN_POINT__() {
    }

    static void __SPAWN_POINT() {
    }

    static {
        _txtDescrStringLines = new short[128];
    }
}

